/*
 * Decompiled with CFR 0.152.
 */
package com.infomir.wms.module;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import java.util.HashMap;
import java.util.Map;
import net.azhurb.rest.RESTClient;

public class TmpLinkModule
extends ModuleBase {
    private String stalkerApiServer;

    public void onAppStart(IApplicationInstance appInstance) {
        String fullname = String.valueOf(appInstance.getApplication().getName()) + "/" + appInstance.getName();
        TmpLinkModule.getLogger().info("TmpLinkModule.onAppStart: " + fullname);
        this.stalkerApiServer = appInstance.getProperties().getPropertyStr("stalkerApiServer", "http://127.0.0.1/stalker_portal/api/");
        TmpLinkModule.getLogger().info("stalkerApiServer: " + this.stalkerApiServer);
    }

    public void onConnect(IClient client, RequestFunction function, AMFDataList params) {
        TmpLinkModule.getLogger().info("TmpLinkModule.onConnect: ");
        TmpLinkModule.getLogger().info("params: " + params);
        String token = TmpLinkModule.getParamString((AMFDataList)params, (int)3);
        if (token == null || token.isEmpty() || !this.isValidToken(token)) {
            client.rejectConnection();
        } else {
            client.acceptConnection();
        }
    }

    public void onHTTPCupertinoStreamingSessionCreate(HTTPStreamerSessionCupertino httpSession) {
        TmpLinkModule.getLogger().info("TmpLinkModule.onHTTPCupertinoStreamingSessionCreate: " + httpSession.getSessionId());
        Map<String, String> query = TmpLinkModule.getQueryMap(httpSession.getQueryStr());
        String token = query.get("token");
        if (this.isValidToken(token)) {
            httpSession.acceptSession();
        } else {
            httpSession.rejectSession();
        }
    }

    private boolean isValidToken(String token) {
        String myObject;
        TmpLinkModule.getLogger().info("token: " + token);
        if (token == null || token.isEmpty()) {
            return false;
        }
        try {
            myObject = null;
            RESTClient rest = new RESTClient(this.stalkerApiServer);
            rest.setResource("tv_tmp_link");
            rest.setIdentifier(token);
            try {
                myObject = (String)rest.get();
            }
            catch (Exception e) {
                TmpLinkModule.getLogger().warn(e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        TmpLinkModule.getLogger().info("myObject: " + myObject);
        return myObject.equals("1");
    }

    public void onCall(String handlerName, IClient client, RequestFunction function, AMFDataList params) {
        TmpLinkModule.getLogger().info("TmpLinkModule.onCall: " + handlerName);
    }

    public static Map<String, String> getQueryMap(String query) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        if (query == null || query.isEmpty()) {
            return map;
        }
        if (!query.contains("=")) {
            query = "token=" + query;
        }
        String[] stringArray = params = query.split("&");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (param.contains("=")) {
                String name = param.split("=")[0];
                String value = param.split("=")[1];
                map.put(name, value);
            } else {
                map.put(param, "");
            }
            ++n2;
        }
        return map;
    }
}

