/*
 * Decompiled with CFR 0.152.
 */
package net.azhurb.rest;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import net.azhurb.rest.RESTClientException;
import net.azhurb.rest.RESTClientExecuteException;

public class RESTClient {
    private String resource;
    private String restServer;
    private String method;
    private ArrayList<String> identifiers;
    private Map<String, String> data;

    public RESTClient(String server) {
        this.restServer = server;
    }

    public Object get() throws RESTClientExecuteException {
        this.method = "GET";
        return this.execute();
    }

    public Object create(Map<String, String> createData) throws RESTClientExecuteException {
        this.method = "POST";
        this.data = createData;
        return this.execute();
    }

    public Object update(Map<String, String> updateData) throws RESTClientExecuteException {
        this.method = "PUT";
        this.data = updateData;
        return this.execute();
    }

    public Object delete() throws RESTClientExecuteException {
        this.method = "DELETE";
        return this.execute();
    }

    public void setResource(String newResource) {
        this.resource = newResource;
    }

    public void setIdentifiers(ArrayList<String> ids) {
        this.identifiers = ids;
    }

    public void setIdentifier(String id) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList();
        }
        this.identifiers.add(id);
    }

    private Object execute() throws RESTClientExecuteException {
        String decodedString = "";
        String urlString = String.valueOf(this.restServer) + this.resource + "/";
        if (this.identifiers != null) {
            urlString = String.valueOf(urlString) + this.implodeList(this.identifiers);
        }
        try {
            String line;
            URL target = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)target.openConnection();
            connection.setRequestMethod(this.method);
            if (target.getUserInfo() != null) {
                connection.setRequestProperty("Authorization", "Basic " + DatatypeConverter.printBase64Binary((byte[])target.getUserInfo().getBytes()));
            }
            connection.setRequestProperty("Connection", "close");
            connection.setDoOutput(true);
            if (this.data != null) {
                OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
                out.write(this.buildQuery(this.data));
                out.close();
            }
            this.reset();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                decodedString = String.valueOf(decodedString) + line;
            }
            in.close();
            Gson gson = new Gson();
            System.out.println(decodedString);
            RESTResponse response = gson.fromJson(decodedString, RESTResponse.class);
            System.out.println(response);
            if (response == null) {
                throw new RESTClientException("Result cannot be decoded. Result: " + decodedString);
            }
            if (!response.getStatus().equals("OK")) {
                String error = response.getError() != null ? response.getError() : "No description of the error. Result: " + decodedString;
                throw new RESTClientException(error);
            }
            return response.getResults();
        }
        catch (Exception e) {
            throw new RESTClientExecuteException(e.getMessage());
        }
    }

    private String implodeList(ArrayList<String> list) {
        String listString = "";
        for (String s : list) {
            listString = String.valueOf(listString) + s + ",";
        }
        return listString;
    }

    private String buildQuery(Map<?, ?> data) throws UnsupportedEncodingException {
        StringBuffer queryString = new StringBuffer();
        for (Map.Entry<?, ?> pair : data.entrySet()) {
            queryString.append(String.valueOf(URLEncoder.encode((String)pair.getKey(), "UTF-8")) + "=");
            queryString.append(String.valueOf(URLEncoder.encode((String)pair.getValue(), "UTF-8")) + "&");
        }
        if (queryString.length() > 0) {
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }

    private void reset() {
        this.identifiers = null;
        this.data = null;
        this.resource = null;
        this.method = null;
    }

    class RESTResponse {
        private String status;
        private String results = "";
        private String error = "";

        RESTResponse() {
        }

        public String getStatus() {
            return this.status;
        }

        public Object getResults() {
            return this.results;
        }

        public String getError() {
            return this.error;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setResults(String results) {
            this.results = results;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String toString() {
            return String.format("status:%s, results:%s, error:%s", this.status, this.results, this.error);
        }
    }
}

