--

ALTER TABLE `users` ADD `openweathermap_city_id` int(11) NOT NULL DEFAULT 0;

CREATE TABLE `all_cities` (
  `id` int NOT NULL,
  `name` varchar(64) NOT NULL DEFAULT '',
  `name_ru` varchar(64) NOT NULL DEFAULT '',
  `country` varchar(64) NOT NULL DEFAULT '',
  `country_id` int NOT NULL DEFAULT 0,
  `admin1_code` varchar(64) NOT NULL DEFAULT '',
  `admin2_code` varchar(64) NOT NULL DEFAULT '',
  `admin3_code` varchar(64) NOT NULL DEFAULT '',
  `admin4_code` varchar(64) NOT NULL DEFAULT '',
  `lat` varchar(32) NOT NULL DEFAULT '',
  `lon` varchar(32) NOT NULL DEFAULT '',
  `timezone` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`),
  KEY `timezone` (`timezone`)
) DEFAULT CHARSET=utf8;

CREATE TABLE `openweathermap_cache` (
  `id` int NOT NULL AUTO_INCREMENT,
  `current` text,
  `forecast` text,
  `updated_current` timestamp DEFAULT 0,
  `updated_forecast` timestamp DEFAULT 0,
  `city_id` int NOT NULL DEFAULT 0,
  `last_request` timestamp DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `city_id` (`city_id`)
) DEFAULT CHARSET=utf8;

ALTER TABLE `weatherco_cache` ADD `updated_current` timestamp DEFAULT 0;
ALTER TABLE `weatherco_cache` ADD `updated_forecast` timestamp DEFAULT 0;
UPDATE weatherco_cache SET updated_current = updated, updated_forecast=updated;

SET NAMES utf8;

INSERT INTO all_cities (id, name, name_ru, country, country_id, admin1_code, admin2_code, admin3_code, admin4_code, lat, lon, timezone) VALUES
("290594", "Umm al Qaywayn", "Умм-эль-Кайвайн", "AE", "784", "07", "", "", "", "25.56473", "55.55517", "Asia/Dubai"),
("291074", "Ras al-Khaimah", "Рас-эль-Хайма", "AE", "784", "05", "", "", "", "25.78953", "55.9432", "Asia/Dubai"),
("291696", "Khawr Fakkan", "Хор-Факкан", "AE", "784", "06", "", "", "", "25.33132", "56.34199", "Asia/Dubai"),
("292223", "Dubai", "Дубай", "AE", "784", "03", "", "", "", "25.25817", "55.30472", "Asia/Dubai"),
("292239", "Dibba Al-Hisn", "Дибба Аль-Хисн", "AE", "784", "04", "", "", "", "25.61955", "56.27291", "Asia/Dubai"),
("292672", "Sharjah", "Шарджа", "AE", "784", "06", "", "", "", "25.33737", "55.41206", "Asia/Dubai"),
("292688", "Ar Ruways", "Ар-Руваис", "AE", "784", "01", "", "", "", "24.11028", "52.73056", "Asia/Dubai"),
("292878", "Al Fujayrah", "Фуджейра", "AE", "784", "04", "", "", "", "25.11641", "56.34141", "Asia/Dubai"),
("292913", "Al Ain", "Аль-Айн", "AE", "784", "01", "", "", "", "24.19167", "55.76056", "Asia/Dubai"),
("292932", "Ajman", "", "AE", "784", "02", "", "", "", "25.41111", "55.43504", "Asia/Dubai"),
("292953", "Adh Dhayd", "", "AE", "784", "06", "", "", "", "25.28812", "55.88157", "Asia/Dubai"),
("292968", "Abu Dhabi", "Абу-Даби", "AE", "784", "01", "", "", "", "24.46667", "54.36667", "Asia/Dubai"),
("1120985", "Zaranj", "Зарани", "AF", "4", "19", "7053297", "", "", "30.95962", "61.86037", "Asia/Kabul"),
("1123004", "Taloqan", "Таликан", "AF", "4", "26", "", "", "", "36.73605", "69.53451", "Asia/Kabul"),
("1125155", "Shindand", "Шинданд", "AF", "4", "11", "", "", "", "33.30294", "62.1474", "Asia/Kabul"),
("1125444", "Shibirghan", "Шеберган", "AF", "4", "31", "", "", "", "36.66757", "65.7529", "Asia/Kabul"),
("1125896", "Shahrak", "", "AF", "4", "09", "", "", "", "34.10738", "64.3052", "Asia/Kabul"),
("1127110", "Sar-e Pul", "Сари-Пуль", "AF", "4", "33", "", "", "", "36.21544", "65.93249", "Asia/Kabul"),
("1127628", "Sang-e Charak", "", "AF", "4", "33", "", "", "", "35.84972", "66.43694", "Asia/Kabul"),
("1127768", "Aibak", "Саманган", "AF", "4", "32", "", "", "", "36.26468", "68.01551", "Asia/Kabul"),
("1128265", "Rustaq", "", "AF", "4", "26", "", "", "", "37.12604", "69.83045", "Asia/Kabul"),
("1129516", "Qarqin", "Кханика", "AF", "4", "31", "", "", "", "37.41853", "66.04358", "Asia/Kabul"),
("1129648", "Qarawul", "", "AF", "4", "24", "", "", "", "37.21959", "68.7802", "Asia/Kabul"),
("1130490", "Pul-e Khumri", "Пули-Хумри", "AF", "4", "03", "", "", "", "35.94458", "68.71512", "Asia/Kabul"),
("1131316", "Paghman", "Пагман", "AF", "4", "13", "", "", "", "34.58787", "68.95091", "Asia/Kabul"),
("1132495", "Nahrin", "Нахрин", "AF", "4", "03", "", "", "", "36.0649", "69.13343", "Asia/Kabul"),
("1133453", "Maymana", "Меймене", "AF", "4", "07", "", "", "", "35.92139", "64.78361", "Asia/Kabul"),
("1133574", "Mehtar Lam", "Митарлам", "AF", "4", "35", "", "", "", "34.67139", "70.20944", "Asia/Kabul"),
("1133616", "Mazar-e Sharif", "Мазари-Шариф", "AF", "4", "30", "", "", "", "36.70904", "67.11087", "Asia/Kabul"),
("1134720", "Lashkar Gah", "Лашкаргах", "AF", "4", "10", "", "", "", "31.59382", "64.37161", "Asia/Kabul"),
("1135158", "Kushk", "Кушк", "AF", "4", "11", "", "", "", "33.29565", "61.95221", "Asia/Kabul"),
("1135689", "Kunduz", "Кундуз", "AF", "4", "24", "", "", "", "36.72896", "68.857", "Asia/Kabul"),
("1136469", "Khost", "Хост", "AF", "4", "37", "", "", "", "33.33951", "69.92041", "Asia/Kabul"),
("1136575", "Khulm", "Ташкурган", "AF", "4", "30", "", "", "", "36.69736", "67.69826", "Asia/Kabul"),
("1136863", "Khash", "", "AF", "4", "19", "", "", "", "31.52919", "62.79055", "Asia/Kabul"),
("1137168", "Khanabad", "Ханабад", "AF", "4", "24", "", "", "", "36.6825", "69.11556", "Asia/Kabul"),
("1137807", "Karukh", "", "AF", "4", "11", "", "", "", "34.48108", "62.5863", "Asia/Kabul"),
("1138336", "Kandahar", "Кандагар", "AF", "4", "23", "", "", "", "31.61332", "65.71013", "Asia/Kabul"),
("1138958", "Kabul", "Кабул", "AF", "4", "13", "", "", "", "34.52813", "69.17233", "Asia/Kabul"),
("1139715", "Jalalabad", "Джалалабад", "AF", "4", "18", "", "", "", "34.42647", "70.45153", "Asia/Kabul"),
("1139807", "Jabal os Saraj", "Dzhabal’-Ussaradzh", "AF", "4", "40", "", "", "", "35.11833", "69.23778", "Asia/Kabul"),
("1140026", "Herat", "Герат", "AF", "4", "11", "", "", "", "34.34817", "62.19967", "Asia/Kabul"),
("1141089", "Ghormach", "", "AF", "4", "02", "7052787", "", "", "35.73062", "63.78264", "Asia/Kabul"),
("1141269", "Ghazni", "Газни", "AF", "4", "08", "", "", "", "33.55391", "68.42096", "Asia/Kabul"),
("1141540", "Gereshk", "Герешк", "AF", "4", "10", "", "", "", "31.82089", "64.57005", "Asia/Kabul"),
("1141857", "Gardez", "Гардез", "AF", "4", "36", "", "", "", "33.59744", "69.22592", "Asia/Kabul"),
("1142170", "Fayzabad", "Файзабад", "AF", "4", "01", "", "", "", "37.11664", "70.58002", "Asia/Kabul"),
("1142264", "Farah", "", "AF", "4", "06", "", "", "", "32.37451", "62.11638", "Asia/Kabul"),
("1142404", "Kafir Qala", "", "AF", "4", "11", "", "", "", "34.66667", "61.06667", "Asia/Kabul"),
("1145352", "Charikar", "Чарикар", "AF", "4", "40", "", "", "", "35.01361", "69.17139", "Asia/Kabul"),
("1147066", "Baraki Barak", "", "AF", "4", "17", "", "", "", "33.96744", "68.9492", "Asia/Kabul"),
("1147242", "Bamyan", "", "AF", "4", "05", "", "", "", "34.82156", "67.82734", "Asia/Kabul"),
("1147290", "Balkh", "Балх", "AF", "4", "30", "", "", "", "36.75635", "66.8972", "Asia/Kabul"),
("1147540", "Baghlan", "Баглан", "AF", "4", "03", "", "", "", "36.13068", "68.70829", "Asia/Kabul"),
("1148106", "Art Khwajah", "", "AF", "4", "26", "", "", "", "37.08571", "69.47958", "Asia/Kabul"),
("1148205", "Asmar", "", "AF", "4", "34", "", "", "", "35.03333", "71.35809", "Asia/Kabul"),
("1148311", "Asadabad", "Асадабад", "AF", "4", "34", "", "", "", "34.87311", "71.14697", "Asia/Kabul"),
("1148658", "Andkhoy", "", "AF", "4", "07", "", "", "", "36.95293", "65.12376", "Asia/Kabul"),
("1429434", "Bazarak", "Базарак", "AF", "4", "42", "", "", "", "35.31292", "69.51519", "Asia/Kabul"),
("1469706", "Markaz-e Woluswali-ye Achin", "", "AF", "4", "18", "", "", "", "34.12583", "70.70778", "Asia/Kabul"),
("6692413", "Cool urhajo", "", "AF", "4", "05", "", "", "", "34.26545", "67.34516", "Asia/Kabul"),
("363243", "Sarande", "Саранда", "AL", "8", "51", "20", "", "", "39.87556", "20.00528", "Europe/Tirane"),
("782661", "Kukes", "Кукес", "AL", "8", "47", "", "", "", "42.07694", "20.42194", "Europe/Tirane"),
("782756", "Korce", "Корча", "AL", "8", "46", "09", "", "", "40.61861", "20.78083", "Europe/Tirane"),
("783148", "Gjirokaster", "Гирокастра", "AL", "8", "45", "", "", "", "40.07583", "20.13889", "Europe/Tirane"),
("783263", "Elbasan", "Эльбасан", "AL", "8", "43", "", "", "", "41.1125", "20.08222", "Europe/Tirane"),
("783493", "Burrel", "Буррель", "AL", "8", "41", "15", "", "", "41.61028", "20.00889", "Europe/Tirane"),
("3183719", "Vlore", "Влёра", "AL", "8", "51", "", "", "", "40.46667", "19.48972", "Europe/Tirane"),
("3183875", "Tirana", "Тирана", "AL", "8", "50", "", "", "", "41.3275", "19.81889", "Europe/Tirane"),
("3184081", "Shkoder", "Шкодер", "AL", "8", "49", "21", "", "", "42.06828", "19.51258", "Europe/Tirane"),
("3184517", "Patos Fshat", "", "AL", "8", "44", "", "", "", "40.64278", "19.65083", "Europe/Tirane"),
("3184862", "Lushnje", "Люшня", "AL", "8", "44", "14", "", "", "40.94194", "19.705", "Europe/Tirane"),
("3184935", "Lezhe", "Лежа", "AL", "8", "48", "", "", "", "41.78361", "19.64361", "Europe/Tirane"),
("3185012", "Lac", "Лак", "AL", "8", "48", "35", "", "", "41.63556", "19.71306", "Europe/Tirane"),
("3185060", "Kucove", "Кучова", "AL", "8", "40", "34", "", "", "40.80028", "19.91667", "Europe/Tirane"),
("3185082", "Kruje", "Круе", "AL", "8", "42", "10", "", "", "41.50917", "19.79278", "Europe/Tirane"),
("3185211", "Kavaje", "Кавайе", "AL", "8", "50", "33", "", "", "41.18556", "19.55694", "Europe/Tirane"),
("3185670", "Fier-Cifci", "", "AL", "8", "44", "", "", "", "40.71667", "19.56667", "Europe/Tirane"),
("3185672", "Fier", "Фиери", "AL", "8", "44", "", "", "", "40.72389", "19.55611", "Europe/Tirane"),
("3185728", "Durres", "Дуррес", "AL", "8", "42", "", "", "", "41.32306", "19.44139", "Europe/Tirane"),
("3186084", "Berat", "Берат", "AL", "8", "40", "01", "", "", "40.70583", "19.95222", "Europe/Tirane"),
("174875", "Kapan", "Капан", "AM", "51", "08", "", "", "", "39.20754", "46.40576", "Asia/Yerevan"),
("174895", "Goris", "Горис", "AM", "51", "08", "", "", "", "39.51288", "46.33816", "Asia/Yerevan"),
("174972", "Hats'avan", "Ацаван", "AM", "51", "08", "", "", "", "39.46405", "45.97047", "Asia/Yerevan"),
("174979", "Artashat", "Арташат", "AM", "51", "02", "", "", "", "39.96144", "44.54447", "Asia/Yerevan"),
("174991", "Ararat", "Арарат", "AM", "51", "02", "", "", "", "39.83166", "44.70489", "Asia/Yerevan"),
("616052", "Yerevan", "Ереван", "AM", "51", "11", "", "", "", "40.18111", "44.51361", "Asia/Yerevan"),
("616062", "Ejmiatsin", "Вагаршапат", "AM", "51", "03", "", "", "", "40.16557", "44.29462", "Asia/Yerevan"),
("616199", "Spitak", "Спитак", "AM", "51", "06", "", "", "", "40.8322", "44.2673", "Asia/Yerevan"),
("616250", "Sevan", "Севан", "AM", "51", "04", "", "", "", "40.5484", "44.94868", "Asia/Yerevan"),
("616435", "Masis", "Масис", "AM", "51", "02", "", "", "", "40.06762", "44.43591", "Asia/Yerevan"),
("616530", "Vanadzor", "Кировакан", "AM", "51", "06", "", "", "", "40.80456", "44.4939", "Asia/Yerevan"),
("616599", "Gavarr", "Гавар", "AM", "51", "04", "", "", "", "40.35398", "45.12386", "Asia/Yerevan"),
("616629", "Hrazdan", "Раздан", "AM", "51", "05", "", "", "", "40.49748", "44.7662", "Asia/Yerevan"),
("616631", "Armavir", "Армавир", "AM", "51", "03", "", "", "", "40.15446", "44.03815", "Asia/Yerevan"),
("616635", "Gyumri", "Гюмри", "AM", "51", "07", "", "", "", "40.7942", "43.84528", "Asia/Yerevan"),
("616877", "Ashtarak", "Аштарак", "AM", "51", "01", "", "", "", "40.2991", "44.36204", "Asia/Yerevan"),
("617026", "Abovyan", "Абовян", "AM", "51", "05", "", "", "", "40.26741", "44.62656", "Asia/Yerevan"),
("145531", "Saurimo", "Сауримо", "AO", "24", "18", "", "", "", "-9.66078", "20.39155", "Africa/Luanda"),
("145724", "Lucapa", "Лукапа", "AO", "24", "17", "", "", "", "-8.41915", "20.74466", "Africa/Luanda"),
("876177", "Luau", "Луау", "AO", "24", "14", "", "", "", "-10.70727", "22.22466", "Africa/Luanda"),
("2236568", "Uige", "Уиже", "AO", "24", "15", "", "", "", "-7.60874", "15.06131", "Africa/Luanda"),
("2236967", "Soio", "Сойу", "AO", "24", "16", "", "", "", "-6.1349", "12.36894", "Africa/Luanda"),
("2239001", "Nzeto", "Нзето", "AO", "24", "16", "", "", "", "-7.23116", "12.8666", "Africa/Luanda"),
("2239076", "N'dalatando", "", "AO", "24", "05", "", "", "", "-9.29782", "14.91162", "Africa/Luanda"),
("2239520", "Mbanza Congo", "", "AO", "24", "16", "", "", "", "-6.26703", "14.2401", "Africa/Luanda"),
("2239862", "Malanje", "Маланже", "AO", "24", "12", "2239859", "", "", "-9.54015", "16.34096", "Africa/Luanda"),
("2240449", "Luanda", "Луанда", "AO", "24", "20", "", "", "", "-8.83682", "13.23432", "Africa/Luanda"),
("2242001", "Caxito", "Кашито", "AO", "24", "19", "", "", "", "-8.57848", "13.66425", "Africa/Luanda"),
("2243271", "Cabinda", "Кабинда", "AO", "24", "03", "", "", "", "-5.55", "12.2", "Africa/Luanda"),
("3346015", "Sumbe", "Сумбе", "AO", "24", "06", "", "", "", "-11.20605", "13.84371", "Africa/Luanda"),
("3347019", "Namibe", "Намибе", "AO", "24", "13", "", "", "", "-15.19611", "12.15222", "Africa/Luanda"),
("3347353", "Menongue", "Менонге", "AO", "24", "04", "", "", "", "-14.6585", "17.69099", "Africa/Luanda"),
("3347719", "Luena", "Луэна", "AO", "24", "14", "", "", "", "-11.78333", "19.91667", "Africa/Luanda"),
("3347762", "Lubango", "Лубанго", "AO", "24", "09", "", "", "", "-14.91717", "13.4925", "Africa/Luanda"),
("3347853", "Longonjo", "Логонжу", "AO", "24", "08", "", "", "", "-12.90667", "15.25333", "Africa/Luanda"),
("3347939", "Lobito", "Лобиту", "AO", "24", "01", "", "", "", "-12.3644", "13.53601", "Africa/Luanda"),
("3348078", "Cuito", "Куито", "AO", "24", "02", "", "", "", "-12.38333", "16.93333", "Africa/Luanda"),
("3348313", "Huambo", "Уамбо", "AO", "24", "08", "", "", "", "-12.77611", "15.73917", "Africa/Luanda"),
("3350246", "Catumbela", "Катумбела", "AO", "24", "01", "", "", "", "-12.43002", "13.54677", "Africa/Luanda"),
("3350372", "Catabola", "Катабола", "AO", "24", "02", "", "", "", "-12.15", "17.28333", "Africa/Luanda"),
("3351014", "Camacupa", "Камакупа", "AO", "24", "02", "", "", "", "-12.01667", "17.48333", "Africa/Luanda"),
("3351024", "Caluquembe", "Калукембе", "AO", "24", "09", "", "", "", "-13.78333", "14.68333", "Africa/Luanda"),
("3351500", "Caala", "Каале", "AO", "24", "08", "", "", "", "-12.8525", "15.56056", "Africa/Luanda"),
("3351663", "Benguela", "Бенгела", "AO", "24", "01", "", "", "", "-12.57626", "13.40547", "Africa/Luanda"),
("3427213", "Zarate", "Зарате", "AR", "32", "01", "3427212", "", "", "-34.09814", "-59.02858", "America/Argentina/Buenos_Aires"),
("3427388", "Villa Ocampo", "", "AR", "32", "21", "", "", "", "-28.48752", "-59.35515", "America/Argentina/Cordoba"),
("3427408", "Villa Lugano", "", "AR", "32", "07", "", "", "", "-34.67907", "-58.47262", "America/Argentina/Buenos_Aires"),
("3427428", "Villaguay", "", "AR", "32", "08", "3427426", "", "", "-31.8653", "-59.02689", "America/Argentina/Cordoba"),
("3427431", "Villa Gesell", "Вилья-Хесель", "AR", "32", "01", "", "", "", "-37.26394", "-56.97304", "America/Argentina/Buenos_Aires"),
("3427761", "Tigre", "Тигре", "AR", "32", "01", "3427753", "", "", "-34.42603", "-58.57962", "America/Argentina/Buenos_Aires"),
("3427833", "Tandil", "Тандиль", "AR", "32", "01", "3427832", "", "", "-37.32167", "-59.13316", "America/Argentina/Buenos_Aires"),
("3428068", "San Vicente", "", "AR", "32", "14", "", "", "", "-26.61667", "-54.13333", "America/Argentina/Cordoba"),
("3428071", "Santo Tome", "", "AR", "32", "06", "", "", "", "-28.54939", "-56.04077", "America/Argentina/Cordoba"),
("3428359", "Santa Elena", "", "AR", "32", "08", "", "", "", "-30.94768", "-59.78696", "America/Argentina/Cordoba"),
("3428577", "San Pedro", "", "AR", "32", "14", "3428569", "", "", "-26.62207", "-54.10842", "America/Argentina/Cordoba"),
("3428708", "San Luis del Palmar", "", "AR", "32", "06", "", "", "", "-27.5079", "-58.55454", "America/Argentina/Cordoba"),
("3428759", "San Lorenzo", "", "AR", "32", "06", "", "", "", "-28.13306", "-58.76733", "America/Argentina/Cordoba"),
("3428975", "San Javier", "", "AR", "32", "21", "3428973", "", "", "-30.57781", "-59.9317", "America/Argentina/Cordoba"),
("3428992", "San Isidro", "", "AR", "32", "01", "3428983", "", "", "-34.47145", "-58.50776", "America/Argentina/Buenos_Aires"),
("3429403", "Saladas", "", "AR", "32", "06", "3429402", "", "", "-28.25384", "-58.62591", "America/Argentina/Cordoba"),
("3429576", "Retiro", "Ретиро", "AR", "32", "07", "", "", "", "-34.58333", "-58.38333", "America/Argentina/Buenos_Aires"),
("3429577", "Resistencia", "Ресистенсия", "AR", "32", "03", "", "", "", "-27.46056", "-58.98389", "America/Argentina/Cordoba"),
("3429594", "Reconquista", "Реконкиста", "AR", "32", "21", "", "", "", "-29.15", "-59.65", "America/Argentina/Cordoba"),
("3429652", "Quilmes", "Кильмес", "AR", "32", "01", "3429651", "", "", "-34.72418", "-58.25265", "America/Argentina/Buenos_Aires"),
("3429732", "Puerto Rico", "", "AR", "32", "14", "", "", "", "-26.79598", "-55.02402", "America/Argentina/Cordoba"),
("3429777", "Puerto Iguazu", "Пуэрто-Игуасу", "AR", "32", "14", "3433487", "", "", "-25.59912", "-54.57355", "America/Argentina/Cordoba"),
("3429786", "Puerto Esperanza", "", "AR", "32", "14", "", "", "", "-26.01517", "-54.67306", "America/Argentina/Cordoba"),
("3429790", "Puerto Eldorado", "", "AR", "32", "14", "", "", "", "-26.40842", "-54.69463", "America/Argentina/Cordoba"),
("3429886", "Posadas", "Посадас", "AR", "32", "14", "", "", "", "-27.36708", "-55.89608", "America/Argentina/Cordoba"),
("3429902", "Pontevedra", "", "AR", "32", "01", "", "", "", "-34.74974", "-58.68696", "America/Argentina/Buenos_Aires"),
("3429949", "Pirane", "", "AR", "32", "09", "3429948", "", "", "-25.73239", "-59.10879", "America/Argentina/Cordoba"),
("3430104", "Paso de los Libres", "", "AR", "32", "06", "3430103", "", "", "-29.71311", "-57.08991", "America/Argentina/Cordoba"),
("3430340", "Obera", "Обера", "AR", "32", "14", "3430339", "", "", "-27.48706", "-55.11994", "America/Argentina/Cordoba"),
("3430443", "Necochea", "", "AR", "32", "01", "", "", "", "-38.54726", "-58.73675", "America/Argentina/Buenos_Aires"),
("3430545", "Moron", "", "AR", "32", "01", "3430544", "", "", "-34.65344", "-58.61975", "America/Argentina/Buenos_Aires"),
("3430598", "Monte Caseros", "", "AR", "32", "06", "3430597", "", "", "-30.25359", "-57.63626", "America/Argentina/Cordoba"),
("3430601", "Montecarlo", "", "AR", "32", "14", "3430599", "", "", "-26.5662", "-54.757", "America/Argentina/Cordoba"),
("3430708", "Mercedes", "", "AR", "32", "01", "3430705", "", "", "-34.65146", "-59.43068", "America/Argentina/Buenos_Aires"),
("3430709", "Mercedes", "Мерседес", "AR", "32", "06", "", "", "", "-29.18186", "-58.07895", "America/Argentina/Cordoba"),
("3430863", "Mar del Plata", "Мар-дель-Плата", "AR", "32", "01", "", "", "", "-38.00228", "-57.55754", "America/Argentina/Buenos_Aires"),
("3430988", "Lujan", "Лухан", "AR", "32", "01", "3430982", "", "", "-34.57028", "-59.105", "America/Argentina/Buenos_Aires"),
("3432043", "La Plata", "Ла-Плата", "AR", "32", "01", "3432039", "", "", "-34.92145", "-57.95453", "America/Argentina/Buenos_Aires"),
("3432079", "La Paz", "", "AR", "32", "08", "3432077", "", "", "-30.74485", "-59.64566", "America/Argentina/Cordoba"),
("3433349", "Jardin America", "", "AR", "32", "14", "", "", "", "-27.04346", "-55.22698", "America/Argentina/Cordoba"),
("3433658", "Gualeguaychu", "Гуалегуайчу", "AR", "32", "08", "", "", "", "-33.00938", "-58.51722", "America/Argentina/Cordoba"),
("3433663", "Gualeguay", "", "AR", "32", "08", "3433661", "", "", "-33.14156", "-59.30966", "America/Argentina/Cordoba"),
("3433715", "Goya", "Гойя", "AR", "32", "06", "", "", "", "-29.14003", "-59.26256", "America/Argentina/Cordoba"),
("3433753", "Gobernador Ingeniero Valentin Virasoro", "", "AR", "32", "06", "", "", "", "-28.05", "-56.03333", "America/Argentina/Cordoba"),
("3433803", "General Jose de San Martin", "", "AR", "32", "03", "", "", "", "-26.53743", "-59.34158", "America/Argentina/Cordoba"),
("3433836", "Garupa", "", "AR", "32", "14", "", "", "", "-27.48171", "-55.82921", "America/Argentina/Cordoba"),
("3433899", "Formosa", "Формоза", "AR", "32", "09", "", "", "", "-26.17753", "-58.17814", "America/Argentina/Cordoba"),
("3433901", "Fontana", "", "AR", "32", "03", "", "", "", "-27.41813", "-59.02392", "America/Argentina/Cordoba"),
("3433956", "Federal", "", "AR", "32", "08", "", "", "", "-30.95465", "-58.78326", "America/Argentina/Cordoba"),
("3434095", "Esquina", "", "AR", "32", "06", "3434094", "", "", "-30.01444", "-59.52719", "America/Argentina/Cordoba"),
("3434291", "El Soberbio", "", "AR", "32", "14", "", "", "", "-27.29846", "-54.19877", "America/Argentina/Cordoba"),
("3435038", "Dolores", "", "AR", "32", "01", "3435032", "", "", "-36.31322", "-57.67918", "America/Argentina/Buenos_Aires"),
("3435103", "Curuzu Cuatia", "", "AR", "32", "06", "", "", "", "-29.79171", "-58.0546", "America/Argentina/Cordoba"),
("3435217", "Corrientes", "Корриентес", "AR", "32", "06", "", "", "", "-27.4806", "-58.8341", "America/Argentina/Cordoba"),
("3435261", "Concordia", "Конкордия", "AR", "32", "08", "", "", "", "-31.39296", "-58.02089", "America/Argentina/Cordoba"),
("3435264", "Concepcion del Uruguay", "Консепсьон-дель-Уругвай", "AR", "32", "08", "", "", "", "-32.48249", "-58.23722", "America/Argentina/Cordoba"),
("3435356", "Colegiales", "", "AR", "32", "07", "", "", "", "-34.57365", "-58.44924", "America/Argentina/Buenos_Aires"),
("3435486", "Chajari", "", "AR", "32", "08", "", "", "", "-30.75048", "-57.97962", "America/Argentina/Cordoba"),
("3435810", "Campana", "Кампана", "AR", "32", "01", "3435809", "", "", "-34.16874", "-58.95914", "America/Argentina/Buenos_Aires"),
("3435910", "Buenos Aires", "Буэнос-Айрес", "AR", "32", "07", "", "", "", "-34.61315", "-58.37723", "America/Argentina/Buenos_Aires"),
("3436124", "Barranqueras", "", "AR", "32", "03", "", "", "", "-27.48299", "-58.93579", "America/Argentina/Cordoba"),
("3436199", "Azul", "Азул", "AR", "32", "01", "3436197", "", "", "-36.77698", "-59.85854", "America/Argentina/Buenos_Aires"),
("3436230", "Avellaneda", "", "AR", "32", "21", "", "", "", "-29.11761", "-59.65834", "America/Argentina/Cordoba"),
("3436287", "Aristobulo del Valle", "", "AR", "32", "14", "", "", "", "-27.09625", "-54.89626", "America/Argentina/Cordoba"),
("3832132", "Zapala", "Сапала", "AR", "32", "15", "3832131", "", "", "-38.89916", "-70.05442", "America/Argentina/Salta"),
("3832260", "Yerba Buena", "", "AR", "32", "24", "", "", "", "-26.81667", "-65.31667", "America/Argentina/Tucuman"),
("3832647", "Villa Regina", "", "AR", "32", "16", "", "", "", "-39.1", "-67.06667", "America/Argentina/Salta"),
("3832653", "Villa Paula de Sarmiento", "", "AR", "32", "18", "", "", "", "-31.4933", "-68.53838", "America/Argentina/San_Juan"),
("3832662", "Villa Nueva", "", "AR", "32", "05", "", "", "", "-32.43293", "-63.24763", "America/Argentina/Cordoba"),
("3832694", "Villa Maria", "", "AR", "32", "05", "", "", "", "-32.40751", "-63.24016", "America/Argentina/Cordoba"),
("3832756", "Villa Dolores", "", "AR", "32", "05", "", "", "", "-31.94585", "-65.18958", "America/Argentina/Cordoba"),
("3832778", "Villa Constitucion", "", "AR", "32", "21", "", "", "", "-33.22778", "-60.3297", "America/Argentina/Cordoba"),
("3832791", "Villa Carlos Paz", "Карлос-Паз", "AR", "32", "05", "", "", "", "-31.42414", "-64.49778", "America/Argentina/Cordoba"),
("3832811", "Villa Angela", "", "AR", "32", "03", "", "", "", "-27.57383", "-60.71526", "America/Argentina/Cordoba"),
("3832815", "Villa Allende", "", "AR", "32", "05", "", "", "", "-31.29458", "-64.29538", "America/Argentina/Cordoba"),
("3832899", "Viedma", "Вьедма", "AR", "32", "16", "", "", "", "-40.81345", "-62.99668", "America/Argentina/Salta"),
("3832934", "Victoria", "Виктория", "AR", "32", "08", "3832932", "", "", "-32.61841", "-60.15478", "America/Argentina/Cordoba"),
("3833027", "Vera", "", "AR", "32", "21", "", "", "", "-29.4593", "-60.21261", "America/Argentina/Cordoba"),
("3833062", "Venado Tuerto", "Неукен", "AR", "32", "21", "", "", "", "-33.74556", "-61.96884", "America/Argentina/Cordoba"),
("3833112", "Veinticinco de Mayo", "", "AR", "32", "01", "3833100", "", "", "-35.4323", "-60.17271", "America/Argentina/Buenos_Aires"),
("3833367", "Ushuaia", "Ушуая", "AR", "32", "23", "", "", "", "-54.8", "-68.3", "America/Argentina/Ushuaia"),
("3833412", "Unquillo", "", "AR", "32", "05", "", "", "", "-31.23073", "-64.31615", "America/Argentina/Cordoba"),
("3833794", "Tres Isletas", "", "AR", "32", "03", "", "", "", "-26.34066", "-60.43207", "America/Argentina/Cordoba"),
("3833859", "Tres Arroyos", "", "AR", "32", "01", "3833857", "", "", "-38.37394", "-60.27978", "America/Argentina/Buenos_Aires"),
("3833883", "Trelew", "", "AR", "32", "04", "", "", "", "-43.24895", "-65.30505", "America/Argentina/Catamarca"),
("3834502", "Termas de Rio Hondo", "", "AR", "32", "22", "", "", "", "-27.49983", "-64.86042", "America/Argentina/Cordoba"),
("3834601", "Tartagal", "Тартагал", "AR", "32", "17", "", "", "", "-22.51636", "-63.80131", "America/Argentina/Salta"),
("3834813", "Tafi Viejo", "", "AR", "32", "24", "", "", "", "-26.73201", "-65.25921", "America/Argentina/Tucuman"),
("3834971", "Sunchales", "", "AR", "32", "21", "", "", "", "-30.94404", "-61.56148", "America/Argentina/Cordoba"),
("3835793", "Santo Tome", "", "AR", "32", "21", "", "", "", "-31.66274", "-60.7653", "America/Argentina/Cordoba"),
("3835869", "Santiago del Estero", "Сантьяго-дель-Эстеро", "AR", "32", "22", "", "", "", "-27.79511", "-64.26149", "America/Argentina/Cordoba"),
("3835994", "Santa Rosa", "Санта-Роса", "AR", "32", "11", "", "", "", "-36.61667", "-64.28333", "America/Argentina/Salta"),
("3836194", "Santa Lucia", "", "AR", "32", "18", "3836188", "", "", "-31.53987", "-68.49503", "America/Argentina/San_Juan"),
("3836277", "Santa Fe de la Vera Cruz", "Санта-Фе", "AR", "32", "21", "", "", "", "-31.63333", "-60.7", "America/Argentina/Cordoba"),
("3836564", "San Salvador de Jujuy", "Сан Сальвадор де Жужуй", "AR", "32", "10", "", "", "", "-24.19456", "-65.29712", "America/Argentina/Jujuy"),
("3836620", "San Ramon de la Nueva Oran", "", "AR", "32", "17", "", "", "", "-23.13705", "-64.32426", "America/Argentina/Salta"),
("3836669", "San Rafael", "Сан-Рафаэль", "AR", "32", "13", "", "", "", "-34.61772", "-68.33007", "America/Argentina/Mendoza"),
("3836772", "San Pedro", "", "AR", "32", "10", "3836752", "", "", "-24.23127", "-64.86614", "America/Argentina/Jujuy"),
("3836846", "San Nicolas de los Arroyos", "", "AR", "32", "01", "", "", "", "-33.33578", "-60.22523", "America/Argentina/Buenos_Aires"),
("3836873", "San Miguel de Tucuman", "Сан-Мигель-де-Тукуман", "AR", "32", "24", "", "", "", "-26.82414", "-65.2226", "America/Argentina/Tucuman"),
("3836951", "San Martin de los Andes", "Сан-Мартин-Де-Лос-Андес", "AR", "32", "15", "3852288", "", "", "-40.15789", "-71.35337", "America/Argentina/Salta"),
("3836992", "San Martin", "", "AR", "32", "13", "", "", "", "-33.08103", "-68.46814", "America/Argentina/Mendoza"),
("3837056", "San Luis", "Сан-Луис", "AR", "32", "19", "", "", "", "-33.29501", "-66.33563", "America/Argentina/San_Luis"),
("3837124", "San Justo", "", "AR", "32", "21", "3837122", "", "", "-30.78913", "-60.59189", "America/Argentina/Cordoba"),
("3837213", "San Juan", "Сан-Хуан", "AR", "32", "18", "", "", "", "-31.5375", "-68.53639", "America/Argentina/San_Juan"),
("3837240", "San Jose de Jachal", "", "AR", "32", "18", "", "", "", "-30.24057", "-68.74693", "America/Argentina/San_Juan"),
("3837441", "San Jorge", "", "AR", "32", "21", "", "", "", "-31.89618", "-61.85984", "America/Argentina/Cordoba"),
("3837675", "San Francisco", "", "AR", "32", "05", "", "", "", "-31.42797", "-62.08266", "America/Argentina/Cordoba"),
("3837702", "San Fernando del Valle de Catamarca", "Сан-Фернандо-дель-Валье-де-Катамарка", "AR", "32", "02", "", "", "", "-28.46957", "-65.78524", "America/Argentina/Catamarca"),
("3837980", "San Antonio Oeste", "", "AR", "32", "16", "", "", "", "-40.73193", "-64.94769", "America/Argentina/Salta"),
("3838233", "Salta", "Сальта", "AR", "32", "17", "", "", "", "-24.7859", "-65.41166", "America/Argentina/Salta"),
("3838506", "Rufino", "", "AR", "32", "21", "", "", "", "-34.26827", "-62.71262", "America/Argentina/Cordoba"),
("3838583", "Rosario", "Росарио", "AR", "32", "21", "3838574", "", "", "-32.94682", "-60.63932", "America/Argentina/Cordoba"),
("3838793", "Rio Tercero", "", "AR", "32", "05", "", "", "", "-32.17301", "-64.11406", "America/Argentina/Cordoba"),
("3838797", "Rio Segundo", "", "AR", "32", "05", "3838796", "", "", "-31.6526", "-63.9099", "America/Argentina/Cordoba"),
("3838859", "Rio Gallegos", "Рио-Гальегос", "AR", "32", "20", "", "", "", "-51.62261", "-69.21813", "America/Argentina/Rio_Gallegos"),
("3838874", "Rio Cuarto", "Рио-Куарто", "AR", "32", "05", "3838873", "", "", "-33.13067", "-64.34992", "America/Argentina/Cordoba"),
("3838902", "Rio Ceballos", "", "AR", "32", "05", "", "", "", "-31.16486", "-64.32241", "America/Argentina/Cordoba"),
("3839307", "Rawson", "Роусон", "AR", "32", "04", "3839303", "", "", "-43.30016", "-65.10228", "America/Argentina/Catamarca"),
("3839479", "Rafaela", "Рафаэла", "AR", "32", "21", "", "", "", "-31.25033", "-61.4867", "America/Argentina/Cordoba"),
("3839490", "Quitilipi", "", "AR", "32", "03", "3839489", "", "", "-26.86913", "-60.21683", "America/Argentina/Cordoba"),
("3839982", "Punta Alta", "Пунта-Альта", "AR", "32", "01", "", "", "", "-38.87588", "-62.07359", "America/Argentina/Buenos_Aires"),
("3840092", "Puerto Madryn", "Пуэрто-Мадрин", "AR", "32", "04", "", "", "", "-42.7692", "-65.03851", "America/Argentina/Catamarca"),
("3840300", "Presidencia Roque Saenz Pena", "", "AR", "32", "03", "", "", "", "-26.78522", "-60.43876", "America/Argentina/Cordoba"),
("3840860", "Pocito", "", "AR", "32", "18", "3840858", "", "", "-31.68333", "-68.58333", "America/Argentina/San_Juan"),
("3840885", "Plottier", "", "AR", "32", "15", "", "", "", "-38.96667", "-68.23333", "America/Argentina/Salta"),
("3841490", "Pergamino", "Пергамино", "AR", "32", "01", "3841488", "", "", "-33.88995", "-60.57357", "America/Argentina/Buenos_Aires"),
("3841500", "Perez", "", "AR", "32", "21", "", "", "", "-32.99835", "-60.76791", "America/Argentina/Cordoba"),
("3841956", "Parana", "Парана", "AR", "32", "08", "", "", "", "-31.73197", "-60.5238", "America/Argentina/Cordoba"),
("3842190", "Palpala", "", "AR", "32", "10", "", "", "", "-24.25648", "-65.21163", "America/Argentina/Jujuy"),
("3842670", "Olavarria", "Олаваррия", "AR", "32", "01", "", "", "", "-36.89272", "-60.32254", "America/Argentina/Buenos_Aires"),
("3842881", "Nueve de Julio", "Нев-де-Хулио", "AR", "32", "01", "3842871", "", "", "-35.44437", "-60.88313", "America/Argentina/Buenos_Aires"),
("3843123", "Neuquen", "Неукен", "AR", "32", "15", "", "", "", "-38.95161", "-68.0591", "America/Argentina/Salta"),
("3843619", "Morteros", "", "AR", "32", "05", "", "", "", "-30.71164", "-61.99862", "America/Argentina/Cordoba"),
("3843803", "Monteros", "", "AR", "32", "24", "3843802", "", "", "-27.16742", "-65.49832", "America/Argentina/Tucuman"),
("3844421", "Mendoza", "Мендоса", "AR", "32", "13", "", "", "", "-32.89084", "-68.82717", "America/Argentina/Mendoza"),
("3844899", "Marcos Juarez", "", "AR", "32", "05", "", "", "", "-32.6978", "-62.10672", "America/Argentina/Cordoba"),
("3845330", "Machagai", "", "AR", "32", "03", "", "", "", "-26.92614", "-60.04956", "America/Argentina/Cordoba"),
("3846864", "Lincoln", "", "AR", "32", "01", "3846861", "", "", "-34.86649", "-61.5302", "America/Argentina/Buenos_Aires"),
("3846915", "Libertador General San Martin", "", "AR", "32", "10", "", "", "", "-23.80644", "-64.78757", "America/Argentina/Jujuy"),
("3848687", "Las Brenas", "", "AR", "32", "03", "", "", "", "-27.08966", "-61.08161", "America/Argentina/Cordoba"),
("3848950", "La Rioja", "Ла-Риоха", "AR", "32", "12", "", "", "", "-29.41105", "-66.85067", "America/Argentina/La_Rioja"),
("3851331", "La Falda", "", "AR", "32", "05", "", "", "", "-31.08841", "-64.48987", "America/Argentina/Cordoba"),
("3852374", "La Calera", "", "AR", "32", "05", "", "", "", "-31.34377", "-64.33529", "America/Argentina/Cordoba"),
("3852468", "Laboulaye", "", "AR", "32", "05", "", "", "", "-34.12662", "-63.39119", "America/Argentina/Cordoba"),
("3853354", "Junin", "", "AR", "32", "01", "3853351", "", "", "-34.58382", "-60.94332", "America/Argentina/Buenos_Aires"),
("3853491", "Joaquin V. Gonzalez", "", "AR", "32", "17", "", "", "", "-25.08333", "-64.18333", "America/Argentina/Salta"),
("3853510", "Jesus Maria", "", "AR", "32", "05", "", "", "", "-30.98153", "-64.09424", "America/Argentina/Cordoba"),
("3854895", "Granadero Baigorria", "", "AR", "32", "21", "", "", "", "-32.85683", "-60.71754", "America/Argentina/Cordoba"),
("3854985", "Gobernador Galvez", "", "AR", "32", "21", "", "", "", "-33.03016", "-60.64045", "America/Argentina/Cordoba"),
("3855065", "General Roca", "Хенераль", "AR", "32", "16", "3855061", "", "", "-39.03333", "-67.58333", "America/Argentina/Salta"),
("3855074", "General Pinedo", "", "AR", "32", "03", "", "", "", "-27.31667", "-61.28333", "America/Argentina/Cordoba"),
("3855075", "General Pico", "", "AR", "32", "11", "", "", "", "-35.65662", "-63.75682", "America/Argentina/Salta"),
("3855116", "General Enrique Mosconi", "", "AR", "32", "17", "", "", "", "-22.59588", "-63.81255", "America/Argentina/Salta"),
("3855244", "Galvez", "", "AR", "32", "21", "", "", "", "-32.02927", "-61.22103", "America/Argentina/Cordoba"),
("3855554", "Firmat", "", "AR", "32", "21", "", "", "", "-33.45937", "-61.4832", "America/Argentina/Cordoba"),
("3855666", "Famailla", "", "AR", "32", "24", "3855665", "", "", "-27.05413", "-65.40329", "America/Argentina/Tucuman"),
("3855974", "Esquel", "Эскель", "AR", "32", "04", "3855298", "", "", "-42.91147", "-71.31947", "America/Argentina/Catamarca"),
("3856022", "Esperanza", "", "AR", "32", "21", "", "", "", "-31.4488", "-60.93173", "America/Argentina/Cordoba"),
("3856231", "Embarcacion", "", "AR", "32", "17", "", "", "", "-23.20898", "-64.09605", "America/Argentina/Salta"),
("3856235", "Embalse", "", "AR", "32", "05", "3863430", "", "", "-32.18", "-64.41809", "America/Argentina/Cordoba"),
("3858765", "El Bolson", "", "AR", "32", "16", "", "", "", "-41.96051", "-71.53336", "America/Argentina/Salta"),
("3859384", "Diamante", "", "AR", "32", "08", "", "", "", "-32.06641", "-60.63836", "America/Argentina/Cordoba"),
("3859512", "Dean Funes", "", "AR", "32", "05", "", "", "", "-30.42036", "-64.34984", "America/Argentina/Cordoba"),
("3859552", "Cutral-Co", "", "AR", "32", "15", "", "", "", "-38.93424", "-69.23052", "America/Argentina/Salta"),
("3859828", "Cruz del Eje", "", "AR", "32", "05", "3859827", "", "", "-30.72644", "-64.80387", "America/Argentina/Cordoba"),
("3859904", "Crespo", "", "AR", "32", "08", "", "", "", "-32.02873", "-60.30658", "America/Argentina/Cordoba"),
("3859965", "Cosquin", "", "AR", "32", "05", "", "", "", "-31.24508", "-64.46563", "America/Argentina/Cordoba"),
("3860164", "Coronel Suarez", "Коронель-Суарез", "AR", "32", "01", "3860163", "", "", "-37.45467", "-61.93343", "America/Argentina/Buenos_Aires"),
("3860217", "Coronda", "", "AR", "32", "21", "", "", "", "-31.97263", "-60.91982", "America/Argentina/Cordoba"),
("3860259", "Cordoba", "Кордова", "AR", "32", "05", "3862744", "", "", "-31.4135", "-64.18105", "America/Argentina/Cordoba"),
("3860443", "Comodoro Rivadavia", "Комодоро-Ривадавия", "AR", "32", "04", "", "", "", "-45.86414", "-67.49656", "America/Argentina/Catamarca"),
("3861056", "Cipolletti", "Чиполлетти", "AR", "32", "16", "", "", "", "-38.93392", "-67.99032", "America/Argentina/Salta"),
("3861061", "Cinco Saltos", "", "AR", "32", "16", "", "", "", "-38.82224", "-68.06293", "America/Argentina/Salta"),
("3861344", "Chivilcoy", "", "AR", "32", "01", "3435406", "", "", "-34.89566", "-60.01667", "America/Argentina/Buenos_Aires"),
("3861416", "Chimbas", "", "AR", "32", "18", "3861415", "", "", "-31.48333", "-68.53333", "America/Argentina/San_Juan"),
("3861445", "Chilecito", "", "AR", "32", "12", "3861443", "", "", "-29.16195", "-67.4974", "America/Argentina/La_Rioja"),
("3861678", "Charata", "", "AR", "32", "03", "", "", "", "-27.21438", "-61.18795", "America/Argentina/Cordoba"),
("3861953", "Chacabuco", "Чакабуко", "AR", "32", "01", "3861944", "", "", "-34.64167", "-60.47389", "America/Argentina/Buenos_Aires"),
("3862144", "Centenario", "", "AR", "32", "15", "", "", "", "-38.82955", "-68.1318", "America/Argentina/Salta"),
("3862240", "Caucete", "", "AR", "32", "18", "", "", "", "-31.65179", "-68.28105", "America/Argentina/San_Juan"),
("3862254", "Catriel", "", "AR", "32", "16", "", "", "", "-37.87907", "-67.7956", "America/Argentina/Salta"),
("3862320", "Castelli", "", "AR", "32", "03", "", "", "", "-25.94679", "-60.61947", "America/Argentina/Cordoba"),
("3862351", "Casilda", "", "AR", "32", "21", "", "", "", "-33.04417", "-61.16806", "America/Argentina/Cordoba"),
("3862655", "Carcarana", "", "AR", "32", "21", "", "", "", "-32.85679", "-61.15331", "America/Argentina/Cordoba"),
("3862738", "Capitan Bermudez", "", "AR", "32", "21", "", "", "", "-32.82262", "-60.71852", "America/Argentina/Cordoba"),
("3862981", "Canada de Gomez", "Канада-де-Гомес", "AR", "32", "21", "", "", "", "-32.81636", "-61.39493", "America/Argentina/Cordoba"),
("3863379", "Caleta Olivia", "Калета-Оливия", "AR", "32", "20", "", "", "", "-46.43929", "-67.52814", "America/Argentina/Rio_Gallegos"),
("3864331", "Bell Ville", "", "AR", "32", "05", "", "", "", "-32.62591", "-62.68873", "America/Argentina/Cordoba"),
("3864375", "Bella Vista", "", "AR", "32", "24", "", "", "", "-27.03084", "-65.30315", "America/Argentina/Tucuman"),
("3865086", "Bahia Blanca", "Байя-Бланка", "AR", "32", "01", "3865084", "", "", "-38.7196", "-62.27243", "America/Argentina/Buenos_Aires"),
("3865385", "Arroyo Seco", "", "AR", "32", "21", "", "", "", "-33.15489", "-60.50863", "America/Argentina/Cordoba"),
("3865424", "Arroyito", "", "AR", "32", "05", "", "", "", "-31.42022", "-63.05002", "America/Argentina/Cordoba"),
("3865840", "Anatuya", "", "AR", "32", "22", "", "", "", "-28.46064", "-62.83472", "America/Argentina/Cordoba"),
("3866163", "Alta Gracia", "Альта-Грация", "AR", "32", "05", "", "", "", "-31.65292", "-64.42826", "America/Argentina/Cordoba"),
("3866242", "Allen", "", "AR", "32", "16", "", "", "", "-38.97736", "-67.82714", "America/Argentina/Salta"),
("3866367", "Alderetes", "", "AR", "32", "24", "", "", "", "-26.81667", "-65.13333", "America/Argentina/Tucuman"),
("3866425", "Albardon", "", "AR", "32", "18", "3866424", "", "", "-31.43722", "-68.52556", "America/Argentina/San_Juan"),
("3866496", "Aguilares", "", "AR", "32", "24", "", "", "", "-27.4338", "-65.61427", "America/Argentina/Tucuman"),
("6693230", "Villa Santa Rita", "", "AR", "32", "07", "", "", "", "-34.61082", "-58.481", "America/Argentina/Buenos_Aires"),
("7116866", "Villa Mercedes", "", "AR", "32", "19", "", "", "", "-33.67571", "-65.45783", "America/Argentina/San_Luis"),
("7647007", "San Carlos de Bariloche", "Сан Карлос де Барилоче", "AR", "32", "16", "3864759", "3837856", "", "-41.14557", "-71.30822", "America/Argentina/Salta"),
("2760910", "Wolfsberg", "", "AT", "40", "02", "209", "20923", "", "46.84056", "14.84417", "Europe/Vienna"),
("2761353", "Wiener Neustadt", "Винер-Нойштадт", "AT", "40", "03", "304", "30401", "", "47.8", "16.25", "Europe/Vienna"),
("2761369", "Vienna", "Вена", "AT", "40", "09", "900", "901", "", "48.20849", "16.37208", "Europe/Vienna"),
("2761524", "Wels", "Вельс", "AT", "40", "04", "403", "40301", "", "48.16667", "14.03333", "Europe/Vienna"),
("2761669", "Weinzierl bei Krems", "", "AT", "40", "03", "313", "31327", "", "48.4", "15.6", "Europe/Vienna"),
("2762372", "Villach", "Филлах", "AT", "40", "02", "202", "20201", "", "46.61028", "13.85583", "Europe/Vienna"),
("2763423", "Traun", "", "AT", "40", "04", "410", "41021", "", "48.22656", "14.23459", "Europe/Vienna"),
("2763460", "Traiskirchen", "", "AT", "40", "03", "306", "30639", "", "48.01485", "16.29324", "Europe/Vienna"),
("2763795", "Ternitz", "Терниц", "AT", "40", "03", "318", "31839", "", "47.71565", "16.03575", "Europe/Vienna"),
("2764359", "Steyr", "Штайр", "AT", "40", "04", "402", "40201", "", "48.04274", "14.42127", "Europe/Vienna"),
("2764786", "Spittal an der Drau", "Шпитталь-ан-дер-Драу", "AT", "40", "02", "206", "20635", "", "46.8", "13.5", "Europe/Vienna"),
("2765388", "Schwechat", "Швехат", "AT", "40", "03", "324", "32419", "", "48.13333", "16.46667", "Europe/Vienna"),
("2766429", "Sankt Poelten", "Санкт-Пёльтен", "AT", "40", "03", "302", "30201", "", "48.2", "15.63333", "Europe/Vienna"),
("2766824", "Salzburg", "Зальцбург", "AT", "40", "05", "501", "50101", "", "47.79941", "13.04399", "Europe/Vienna"),
("2766922", "Saalfelden am Steinernen Meer", "Зальфельден-ам-Штайнернен-Меер", "AT", "40", "05", "506", "50619", "", "47.42681", "12.848", "Europe/Vienna"),
("2771335", "Modling", "Мёдлинг", "AT", "40", "03", "317", "31717", "", "48.08605", "16.28921", "Europe/Vienna"),
("2772173", "Lustenau", "Лустенау", "AT", "40", "08", "803", "80303", "", "47.42642", "9.65851", "Europe/Vienna"),
("2772400", "Linz", "Линц", "AT", "40", "04", "401", "40101", "", "48.30639", "14.28611", "Europe/Vienna"),
("2772635", "Leonding", "Леондинг", "AT", "40", "04", "410", "41012", "", "48.27965", "14.2533", "Europe/Vienna"),
("2772649", "Leoben", "Леобен", "AT", "40", "06", "611", "61108", "", "47.3765", "15.09144", "Europe/Vienna"),
("2773300", "Kufstein", "Куфштайн", "AT", "40", "07", "705", "70513", "", "47.58333", "12.16667", "Europe/Vienna"),
("2773549", "Krems an der Donau", "Кремс-на-Дунае", "AT", "40", "03", "301", "30101", "", "48.40921", "15.61415", "Europe/Vienna"),
("2773913", "Klosterneuburg", "Клостернойбург", "AT", "40", "03", "324", "32408", "", "48.30521", "16.32522", "Europe/Vienna"),
("2774326", "Klagenfurt am Woerthersee", "Клагенфурт", "AT", "40", "02", "201", "20101", "", "46.62472", "14.30528", "Europe/Vienna"),
("2774773", "Kapfenberg", "Капфенберг", "AT", "40", "06", "621", "62113", "", "47.44458", "15.29331", "Europe/Vienna"),
("2775220", "Innsbruck", "Инсбрук", "AT", "40", "07", "701", "70101", "", "47.26266", "11.39454", "Europe/Vienna"),
("2776951", "Hallein", "Халлайн", "AT", "40", "05", "502", "50205", "", "47.68333", "13.1", "Europe/Vienna"),
("2778067", "Graz", "Грац", "AT", "40", "06", "601", "60101", "", "47.06667", "15.45", "Europe/Vienna"),
("2779674", "Feldkirch", "Фельдкирх", "AT", "40", "08", "804", "80404", "", "47.23306", "9.6", "Europe/Vienna"),
("2780741", "Dornbirn", "Дорнбирн", "AT", "40", "08", "803", "80301", "", "47.41427", "9.74195", "Europe/Vienna"),
("2781503", "Bregenz", "Брегенц", "AT", "40", "08", "802", "80207", "", "47.50311", "9.7471", "Europe/Vienna"),
("2781520", "Braunau am Inn", "Браунау-ам-Инн", "AT", "40", "04", "404", "40404", "", "48.25628", "13.04343", "Europe/Vienna"),
("2782067", "Baden", "Баден", "AT", "40", "03", "306", "30604", "", "48.00543", "16.23264", "Europe/Vienna"),
("2782555", "Amstetten", "Амштеттен", "AT", "40", "03", "305", "30502", "", "48.1229", "14.87206", "Europe/Vienna"),
("3323063", "Ansfelden", "", "AT", "40", "05", "503", "50332", "", "47.965", "13.04944", "Europe/Vienna"),
("2058430", "Whyalla", "Уайалла", "AU", "36", "05", "48540", "", "", "-33.03268", "137.56484", "Australia/Adelaide"),
("2062338", "Rockingham", "", "AU", "36", "08", "57490", "", "", "-32.27682", "115.72978", "Australia/Perth"),
("2062944", "Prospect", "", "AU", "36", "05", "46510", "", "", "-34.88241", "138.5933", "Australia/Adelaide"),
("2063042", "Port Hedland", "Порт-Хедленд", "AU", "36", "08", "57280", "", "", "-20.31215", "118.61059", "Australia/Perth"),
("2063523", "Perth", "Перт", "AU", "36", "08", "51310", "", "", "-31.95224", "115.8614", "Australia/Perth"),
("2065176", "Murray Bridge", "Марри-Бридж", "AU", "36", "05", "45040", "", "", "-35.11986", "139.27345", "Australia/Adelaide"),
("2065594", "Mount Isa", "Маунт-Айза", "AU", "36", "04", "35300", "", "", "-20.72523", "139.49727", "Australia/Brisbane"),
("2065740", "Morphett Vale", "", "AU", "36", "05", "45340", "", "", "-35.13333", "138.51667", "Australia/Adelaide"),
("2067119", "Mandurah", "Мандъюра", "AU", "36", "08", "55110", "", "", "-32.5269", "115.7217", "Australia/Perth"),
("2068079", "Kwinana", "", "AU", "36", "08", "54830", "", "", "-32.23013", "115.78128", "Australia/Perth"),
("2068823", "Kalgoorlie", "Калгурли", "AU", "36", "08", "54280", "", "", "-30.74614", "121.4742", "Australia/Perth"),
("2070571", "Gosnells", "", "AU", "36", "08", "53780", "", "", "-32.081", "116.0054", "Australia/Perth"),
("2070998", "Geraldton", "Джералдтон", "AU", "36", "08", "53520", "", "", "-28.77897", "114.61459", "Australia/Perth"),
("2071059", "Gawler", "Голер", "AU", "36", "05", "42030", "", "", "-34.60251", "138.74902", "Australia/Adelaide"),
("2071223", "Fremantle", "Фримантл", "AU", "36", "08", "53430", "", "", "-32.05", "115.76667", "Australia/Perth"),
("2073124", "Darwin", "Дарвин", "AU", "36", "03", "71000", "", "", "-12.46113", "130.84185", "Australia/Darwin"),
("2075265", "Busselton", "", "AU", "36", "08", "51260", "", "", "-33.65249", "115.3455", "Australia/Perth"),
("2075432", "Bunbury", "Банбери", "AU", "36", "08", "51190", "", "", "-33.32711", "115.64137", "Australia/Perth"),
("2077579", "Armadale", "", "AU", "36", "08", "50210", "", "", "-32.14607", "116.0093", "Australia/Perth"),
("2077895", "Alice Springs", "Алис-Спрингс", "AU", "36", "03", "70200", "", "", "-23.69748", "133.88362", "Australia/Darwin"),
("2077963", "Albany", "Олбани", "AU", "36", "08", "50080", "", "", "-35.0031", "117.86595", "Australia/Perth"),
("2078025", "Adelaide", "Аделаида", "AU", "36", "05", "40070", "", "", "-34.92866", "138.59863", "Australia/Adelaide"),
("2143069", "Woodridge", "", "AU", "36", "04", "34590", "", "", "-27.63333", "153.1", "Australia/Brisbane"),
("2143285", "Wodonga", "Уодонга", "AU", "36", "07", "27170", "", "", "-36.12179", "146.88809", "Australia/Melbourne"),
("2144528", "Warrnambool", "Уорнамбул", "AU", "36", "07", "26730", "", "", "-38.38176", "142.48799", "Australia/Melbourne"),
("2144764", "Wangaratta", "Уангаратта", "AU", "36", "07", "26700", "", "", "-36.35846", "146.32056", "Australia/Melbourne"),
("2145110", "Wagga Wagga", "Уогга Уогга", "AU", "36", "02", "17750", "", "", "-35.12577", "147.35374", "Australia/Sydney"),
("2146108", "Traralgon", "Траралгон", "AU", "36", "07", "23810", "", "", "-38.19528", "146.5415", "Australia/Melbourne"),
("2146142", "Townsville", "Таунсвилл", "AU", "36", "04", "37010", "", "", "-19.26639", "146.8057", "Australia/Brisbane"),
("2146268", "Toowoomba", "Тувумба", "AU", "36", "04", "36910", "", "", "-27.56056", "151.95386", "Australia/Brisbane"),
("2147381", "Taree", "Тари", "AU", "36", "02", "13350", "", "", "-31.91099", "152.45387", "Australia/Sydney"),
("2147497", "Tamworth", "Тамуорт", "AU", "36", "02", "17310", "", "", "-31.09048", "150.92905", "Australia/Sydney"),
("2147714", "Sydney", "Сидней", "AU", "36", "02", "17200", "", "", "-33.86785", "151.20732", "Australia/Sydney"),
("2147849", "Surfers Paradise", "Сёрферс Парадайз", "AU", "36", "04", "33430", "", "", "-28.00274", "153.42999", "Australia/Brisbane"),
("2147892", "Sunnybank", "", "AU", "36", "04", "31000", "", "", "-27.58333", "153.05", "Australia/Brisbane"),
("2147914", "Sunbury", "Санбери", "AU", "36", "07", "23270", "", "", "-37.57742", "144.72607", "Australia/Melbourne"),
("2148398", "Port Stephens", "", "AU", "36", "02", "16400", "", "", "-32.71314", "152.06623", "Australia/Sydney"),
("2148928", "Southport", "", "AU", "36", "04", "33430", "", "", "-27.96724", "153.39796", "Australia/Brisbane"),
("2148997", "South Grafton", "", "AU", "36", "02", "11730", "", "", "-29.7076", "152.92627", "Australia/Sydney"),
("2149645", "Shepparton", "Шеппартон", "AU", "36", "07", "22830", "", "", "-36.38047", "145.39867", "Australia/Melbourne"),
("2150660", "Saint Kilda", "", "AU", "36", "07", "25900", "", "", "-37.8676", "144.98099", "Australia/Melbourne"),
("2151437", "Rockhampton", "Рокхемптон", "AU", "36", "04", "36360", "", "", "-23.38032", "150.50595", "Australia/Brisbane"),
("2151649", "Richmond", "", "AU", "36", "07", "27350", "", "", "-37.81819", "145.00176", "Australia/Melbourne"),
("2152286", "Queanbeyan", "Куинбеян", "AU", "36", "02", "16470", "", "", "-35.35493", "149.232", "Australia/Sydney"),
("2152329", "Quakers Hill", "", "AU", "36", "02", "10750", "", "", "-33.73333", "150.88333", "Australia/Sydney"),
("2152659", "Port Macquarie", "Порт Маккуори", "AU", "36", "02", "16380", "", "", "-31.43084", "152.90894", "Australia/Sydney"),
("2154219", "Orange", "Орандж", "AU", "36", "02", "16150", "", "", "-33.28397", "149.10018", "Australia/Sydney"),
("2154787", "Nowra", "Новра", "AU", "36", "02", "16950", "", "", "-34.88422", "150.60036", "Australia/Sydney"),
("2155472", "Newcastle", "Ньюкасл", "AU", "36", "02", "15900", "", "", "-32.92715", "151.77647", "Australia/Sydney"),
("2155542", "Nerang", "", "AU", "36", "04", "33430", "", "", "-27.98941", "153.33633", "Australia/Brisbane"),
("2156340", "Mulgrave", "", "AU", "36", "07", "24970", "", "", "-37.91667", "145.2", "Australia/Melbourne"),
("2156643", "Mount Gambier", "Маунт-Гамбиер", "AU", "36", "05", "44620", "", "", "-37.8318", "140.77919", "Australia/Adelaide"),
("2156813", "Mosman", "Мосман", "AU", "36", "02", "15350", "", "", "-33.83902", "151.23956", "Australia/Sydney"),
("2156878", "Mornington", "Морнингтон", "AU", "36", "07", "25340", "", "", "-38.21792", "145.03876", "Australia/Melbourne"),
("2156934", "Morayfield", "", "AU", "36", "04", "35010", "", "", "-27.10876", "152.94907", "Australia/Brisbane"),
("2157343", "Moe", "Мои", "AU", "36", "07", "23810", "", "", "-38.17828", "146.26099", "Australia/Melbourne"),
("2157698", "Mildura", "Милдьюра", "AU", "36", "07", "24780", "", "", "-34.18551", "142.16251", "Australia/Melbourne"),
("2158151", "Melton", "Мелтон", "AU", "36", "07", "24650", "", "", "-37.68339", "144.58543", "Australia/Melbourne"),
("2158177", "Melbourne", "Мельбурн", "AU", "36", "07", "24600", "", "", "-37.814", "144.96332", "Australia/Melbourne"),
("2158562", "Maryborough", "Мэриборо", "AU", "36", "04", "33220", "", "", "-25.54073", "152.70493", "Australia/Brisbane"),
("2158626", "Marrickville", "", "AU", "36", "02", "15200", "", "", "-33.90318", "151.15176", "Australia/Sydney"),
("2158651", "Maroubra", "", "AU", "36", "02", "16550", "", "", "-33.95", "151.23333", "Australia/Sydney"),
("2159045", "Maitland", "Мейтленд", "AU", "36", "02", "15050", "", "", "-32.73308", "151.5574", "Australia/Sydney"),
("2159220", "Mackay", "Макей", "AU", "36", "04", "34770", "", "", "-21.15345", "149.16554", "Australia/Brisbane"),
("2159851", "Liverpool", "", "AU", "36", "02", "12850", "", "", "-33.9", "150.93333", "Australia/Sydney"),
("2160063", "Lismore", "Лизмор", "AU", "36", "02", "14850", "", "", "-28.81354", "153.2773", "Australia/Sydney"),
("2160517", "Launceston", "Лонсестон", "AU", "36", "06", "64010", "", "", "-41.43876", "147.13467", "Australia/Hobart"),
("2161776", "Katoomba", "Катумба", "AU", "36", "02", "10900", "", "", "-33.71977", "150.30739", "Australia/Sydney"),
("2163137", "Hornsby", "", "AU", "36", "02", "14000", "", "", "-33.70244", "151.09931", "Australia/Sydney"),
("2163355", "Hobart", "Хобарт", "AU", "36", "06", "62810", "", "", "-42.87936", "147.32941", "Australia/Hobart"),
("2164422", "Griffith", "Гриффит", "AU", "36", "02", "13450", "", "", "-34.28853", "146.05093", "Australia/Sydney"),
("2164515", "Greensborough", "", "AU", "36", "07", "20660", "", "", "-37.70462", "145.10302", "Australia/Melbourne"),
("2164691", "Granville", "", "AU", "36", "02", "16250", "", "", "-33.83333", "151.01667", "Australia/Sydney"),
("2164837", "Goulburn", "Гулберн", "AU", "36", "02", "13310", "", "", "-34.75155", "149.72086", "Australia/Sydney"),
("2165087", "Gold Coast", "Голд Коуст", "AU", "36", "04", "33430", "", "", "-28.00029", "153.43088", "Australia/Brisbane"),
("2165478", "Gladstone", "Глэдстон", "AU", "36", "04", "33360", "", "", "-23.84761", "151.25635", "Australia/Brisbane"),
("2165798", "Geelong", "Джилонг", "AU", "36", "07", "22750", "", "", "-38.14711", "144.36069", "Australia/Melbourne"),
("2166143", "Frankston East", "Френкстон", "AU", "36", "07", "22170", "", "", "-38.13333", "145.13333", "Australia/Melbourne"),
("2166309", "Forster", "", "AU", "36", "02", "13400", "", "", "-32.18136", "152.51715", "Australia/Sydney"),
("2167280", "Epping", "", "AU", "36", "02", "16250", "", "", "-33.77271", "151.08184", "Australia/Sydney"),
("2167312", "Engadine", "", "AU", "36", "02", "17150", "", "", "-34.06564", "151.01266", "Australia/Sydney"),
("2167817", "Echuca", "Ичука", "AU", "36", "07", "21370", "", "", "-36.14057", "144.75185", "Australia/Melbourne"),
("2167949", "Earlwood", "", "AU", "36", "02", "14150", "", "", "-33.95", "151.1", "Australia/Sydney"),
("2168305", "Dubbo", "Даббо", "AU", "36", "02", "12600", "", "", "-32.24295", "148.60484", "Australia/Sydney"),
("2168943", "Devonport", "Девонпорт", "AU", "36", "06", "61610", "", "", "-41.17695", "146.35152", "Australia/Hobart"),
("2169220", "Deception Bay", "", "AU", "36", "04", "35010", "", "", "-27.19354", "153.02631", "Australia/Brisbane"),
("2169956", "Cronulla", "", "AU", "36", "02", "17150", "", "", "-34.06251", "151.14961", "Australia/Sydney"),
("2170078", "Cranbourne", "", "AU", "36", "07", "21610", "", "", "-38.1", "145.28333", "Australia/Melbourne"),
("2170089", "Craigieburn", "", "AU", "36", "07", "23270", "", "", "-37.6", "144.95", "Australia/Melbourne"),
("2171085", "Coffs Harbour", "Кофс-Харбор", "AU", "36", "02", "11800", "", "", "-30.29626", "153.11351", "Australia/Sydney"),
("2171507", "Wollongong", "Вуллонгонг", "AU", "36", "02", "18450", "", "", "-34.424", "150.89345", "Australia/Sydney"),
("2171845", "Cessnock", "Сеснок", "AU", "36", "02", "11720", "", "", "-32.83211", "151.35623", "Australia/Sydney"),
("2172111", "Castle Hill", "", "AU", "36", "02", "10500", "", "", "-33.73333", "151", "Australia/Sydney"),
("2172303", "Carlingford", "", "AU", "36", "02", "16250", "", "", "-33.78269", "151.04888", "Australia/Sydney"),
("2172311", "Caringbah", "", "AU", "36", "02", "17150", "", "", "-34.04726", "151.12051", "Australia/Sydney"),
("2172517", "Canberra", "Канберра", "AU", "36", "01", "", "", "", "-35.28346", "149.12807", "Australia/Sydney"),
("2172686", "Camberwell", "", "AU", "36", "07", "21110", "", "", "-37.84205", "145.0694", "Australia/Melbourne"),
("2172710", "Caloundra", "Калундра", "AU", "36", "04", "36710", "", "", "-26.79709", "153.13771", "Australia/Brisbane"),
("2172797", "Cairns", "Кернс", "AU", "36", "04", "32070", "", "", "-16.92304", "145.76625", "Australia/Brisbane"),
("2172832", "Caboolture", "", "AU", "36", "04", "35010", "", "", "-27.08465", "152.9511", "Australia/Brisbane"),
("2173125", "Burnie", "Берни", "AU", "36", "06", "60610", "", "", "-41.05584", "145.90375", "Australia/Hobart"),
("2173323", "Bundaberg", "Бандаберг", "AU", "36", "04", "31820", "", "", "-24.86621", "152.3479", "Australia/Brisbane"),
("2173605", "Buderim", "", "AU", "36", "04", "36710", "", "", "-26.68443", "153.05705", "Australia/Brisbane"),
("2173741", "Brunswick", "", "AU", "36", "07", "25250", "", "", "-37.76667", "144.96667", "Australia/Melbourne"),
("2173911", "Broken Hill", "Брокен-Хилл", "AU", "36", "02", "11250", "", "", "-31.96173", "141.45998", "Australia/Broken_Hill"),
("2174003", "Brisbane", "Брисбен", "AU", "36", "04", "31000", "", "", "-27.46794", "153.02809", "Australia/Brisbane"),
("2175411", "Blacktown", "", "AU", "36", "02", "10750", "", "", "-33.76667", "150.91667", "Australia/Sydney"),
("2176187", "Bendigo", "Бендиго", "AU", "36", "07", "22620", "", "", "-36.75818", "144.28024", "Australia/Melbourne"),
("2176632", "Bathurst", "Бэтхерст", "AU", "36", "02", "10470", "", "", "-33.41665", "149.5806", "Australia/Sydney"),
("2176934", "Banora Point", "", "AU", "36", "02", "17550", "", "", "-28.21298", "153.53634", "Australia/Sydney"),
("2177091", "Ballarat", "Балларат", "AU", "36", "07", "20570", "", "", "-37.56622", "143.84957", "Australia/Melbourne"),
("2177671", "Armidale", "Армидейл", "AU", "36", "02", "10110", "", "", "-30.50828", "151.67123", "Australia/Sydney"),
("2178174", "Albury", "Олбери", "AU", "36", "02", "10050", "", "", "-36.07494", "146.92394", "Australia/Sydney"),
("2207259", "South Brisbane", "", "AU", "36", "04", "31000", "", "", "-27.48034", "153.02049", "Australia/Brisbane"),
("2208285", "Randwick", "", "AU", "36", "02", "16550", "", "", "-33.91439", "151.24895", "Australia/Sydney"),
("2208305", "Dee Why", "", "AU", "36", "02", "18000", "", "", "-33.75", "151.3", "Australia/Sydney"),
("6301965", "Palmerston", "Палмерстон", "AU", "36", "03", "72800", "", "", "-12.48602", "130.9833", "Australia/Darwin"),
("6943558", "Bracken Ridge", "", "AU", "36", "04", "31000", "", "", "-27.3171", "153.03097", "Australia/Brisbane"),
("7281782", "North Ryde", "", "AU", "36", "02", "16700", "", "", "-33.79677", "151.12436", "Australia/Sydney"),
("7281807", "Hoppers Crossing", "", "AU", "36", "07", "27260", "", "", "-37.88264", "144.7003", "Australia/Melbourne"),
("7281838", "Logan City", "", "AU", "36", "04", "34590", "", "", "-27.63917", "153.10944", "Australia/Brisbane"),
("7281839", "Carindale", "", "AU", "36", "04", "31000", "", "", "-27.50578", "153.10236", "Australia/Brisbane"),
("7281840", "Paramatta", "", "AU", "36", "02", "16250", "", "", "-33.8178", "151.00348", "Australia/Sydney"),
("7281850", "Ferntree Gully", "", "AU", "36", "07", "23670", "", "", "-37.88461", "145.29539", "Australia/Melbourne"),
("7302259", "City of Parramatta", "", "AU", "36", "02", "16250", "", "", "-33.81667", "151", "Australia/Sydney"),
("7302628", "Adelaide Hills", "", "AU", "36", "05", "40120", "", "", "-34.91118", "138.70735", "Australia/Adelaide"),
("7302631", "Canning Vale", "", "AU", "36", "08", "51330", "", "", "-32.05798", "115.91814", "Australia/Perth"),
("7302642", "Glenmore Park", "", "AU", "36", "02", "16350", "", "", "-33.79068", "150.6693", "Australia/Sydney"),
("7932612", "Glen Iris", "", "AU", "36", "07", "26350", "", "", "-37.85995", "145.05489", "Australia/Melbourne"),
("7932629", "Balwyn North", "", "AU", "36", "07", "21110", "", "", "-37.79086", "145.09386", "Australia/Melbourne"),
("7932636", "Carnegie", "", "AU", "36", "07", "22310", "", "", "-37.88867", "145.05713", "Australia/Melbourne"),
("7932638", "Malvern East", "", "AU", "36", "07", "26350", "", "", "-37.87397", "145.04253", "Australia/Melbourne"),
("7932646", "Brighton East", "", "AU", "36", "07", "20910", "", "", "-37.90141", "145.01884", "Australia/Melbourne"),
("7932654", "Booval", "", "AU", "36", "04", "33960", "", "", "-27.61328", "152.78944", "Australia/Brisbane"),
("8015209", "St Albans", "", "AU", "36", "07", "21180", "", "", "-37.74496", "144.80049", "Australia/Melbourne"),
("8347325", "Endeavour Hills", "", "AU", "36", "07", "21610", "", "", "-37.97695", "145.25866", "Australia/Melbourne"),
("8347717", "Clayton", "", "AU", "36", "07", "24970", "", "", "-37.91731", "145.13041", "Australia/Melbourne"),
("146970", "Xankǝndi", "Степанакерт", "AZ", "31", "61", "", "", "", "39.8177", "46.7528", "Asia/Baku"),
("147059", "Ahmadbayli", "Tel’mankend", "AZ", "31", "45", "", "", "", "39.87867", "48.39902", "Asia/Baku"),
("147105", "Shushi", "Шуша", "AZ", "31", "55", "", "", "", "39.76006", "46.74989", "Asia/Baku"),
("147271", "Salyan", "Сальян", "AZ", "31", "49", "", "", "", "39.59621", "48.98479", "Asia/Baku"),
("147288", "Saatli", "Саатлы", "AZ", "31", "45", "", "", "", "39.93214", "48.36892", "Asia/Baku"),
("147425", "Neftcala", "Нефтечала", "AZ", "31", "36", "", "", "", "39.3768", "49.247", "Asia/Baku"),
("147429", "Nakhchivan", "Нахичевань", "AZ", "31", "35", "", "", "", "39.20889", "45.41222", "Asia/Baku"),
("147622", "Lǝnkǝran", "Ленкорань", "AZ", "31", "29", "", "", "", "38.75428", "48.85062", "Asia/Baku"),
("147982", "Imishli", "Имишли", "AZ", "31", "24", "", "", "", "39.87095", "48.05995", "Asia/Baku"),
("148106", "Fizuli", "Физули", "AZ", "31", "18", "", "", "", "39.60094", "47.14529", "Asia/Baku"),
("148290", "Dzhalilabad", "", "AZ", "31", "15", "", "", "", "39.20963", "48.49186", "Asia/Baku"),
("148340", "Pushkino", "", "AZ", "31", "13", "", "", "", "39.45833", "48.545", "Asia/Baku"),
("148354", "Beyləqan", "", "AZ", "31", "12", "", "", "", "39.77556", "47.61861", "Asia/Baku"),
("148445", "Astara", "Астара", "AZ", "31", "08", "", "", "", "38.45598", "48.87498", "Asia/Baku"),
("148565", "Sirvan", "Ширван", "AZ", "31", "07", "", "", "", "39.93778", "48.929", "Asia/Baku"),
("148619", "Agdam", "Агдам", "AZ", "31", "03", "", "", "", "39.99096", "46.92736", "Asia/Baku"),
("584596", "Zaqatala", "Закаталы", "AZ", "31", "70", "", "", "", "41.6316", "46.64479", "Asia/Baku"),
("584614", "Zabrat", "Забрат", "AZ", "31", "09", "", "", "", "40.47746", "49.94174", "Asia/Baku"),
("584649", "Yevlakh", "Евлах", "AZ", "31", "68", "", "", "", "40.61832", "47.15014", "Asia/Baku"),
("584716", "Yelenendorf", "Гёйгёль", "AZ", "31", "62", "", "", "", "40.58584", "46.3189", "Asia/Baku"),
("584717", "Xacmaz", "Хачмас", "AZ", "31", "60", "", "", "", "41.46426", "48.80565", "Asia/Baku"),
("584791", "Ujar", "Уджары", "AZ", "31", "59", "", "", "", "40.51902", "47.65423", "Asia/Baku"),
("584871", "Terter", "Тертер", "AZ", "31", "57", "", "", "", "40.34179", "46.93242", "Asia/Baku"),
("584923", "Sumqayit", "Сумгаит", "AZ", "31", "54", "", "", "", "40.58972", "49.66861", "Asia/Baku"),
("585103", "Qaracuxur", "Гарачухур", "AZ", "31", "09", "", "", "", "40.39667", "49.97361", "Asia/Baku"),
("585152", "Shamkhor", "Шамкир", "AZ", "31", "51", "", "", "", "40.82975", "46.0178", "Asia/Baku"),
("585156", "Shamakhi", "Шемаха", "AZ", "31", "50", "", "", "", "40.63141", "48.64137", "Asia/Baku"),
("585170", "Sheki", "Шеки", "AZ", "31", "48", "", "", "", "41.19194", "47.17056", "Asia/Baku"),
("585184", "Sabuncu", "Сабунчи", "AZ", "31", "09", "", "", "", "40.4425", "49.94806", "Asia/Baku"),
("585187", "Sabirabad", "Сабирабад", "AZ", "31", "46", "", "", "", "40.00869", "48.47701", "Asia/Baku"),
("585220", "Qusar", "Кусары", "AZ", "31", "44", "", "", "", "41.4275", "48.4302", "Asia/Baku"),
("585221", "Quba", "Куба", "AZ", "31", "42", "", "", "", "41.36108", "48.51341", "Asia/Baku"),
("585225", "Haciqabul", "Кази-Магомед", "AZ", "31", "23", "", "", "", "40.03874", "48.94286", "Asia/Baku"),
("585226", "Qazax", "Казах", "AZ", "31", "40", "", "", "", "41.09246", "45.36561", "Asia/Baku"),
("585379", "Haci Zeynalabdin", "", "AZ", "31", "54", "", "", "", "40.62333", "49.55861", "Asia/Baku"),
("585514", "Mingelchaur", "Мингечаур", "AZ", "31", "33", "", "", "", "40.76395", "47.05953", "Asia/Baku"),
("585557", "Mastaga", "Маштага", "AZ", "31", "09", "", "", "", "40.52982", "50.00616", "Asia/Baku"),
("585568", "Mardakyany", "Мардакян", "AZ", "31", "09", "", "", "", "40.49182", "50.14292", "Asia/Baku"),
("585630", "Lokbatan", "Локбатан", "AZ", "31", "09", "", "", "", "40.3256", "49.73376", "Asia/Baku"),
("585763", "Kyurdarmir", "Кюрдамир", "AZ", "31", "27", "", "", "", "40.34532", "48.15085", "Asia/Baku"),
("585915", "Khirdalan", "Хырдалан", "AZ", "31", "01", "", "", "", "40.44808", "49.75502", "Asia/Baku"),
("586340", "Yeni Suraxani", "", "AZ", "31", "09", "", "", "", "40.43026", "50.03598", "Asia/Baku"),
("586427", "Geoktschai", "Геокчай", "AZ", "31", "22", "", "", "", "40.65056", "47.74219", "Asia/Baku"),
("586429", "Hovsan", "Говсан", "AZ", "31", "09", "", "", "", "40.37444", "50.08528", "Asia/Baku"),
("586523", "Ganja", "Гянджа", "AZ", "31", "20", "", "", "", "40.68278", "46.36056", "Asia/Baku"),
("586763", "Divichibazar", "Дивичи", "AZ", "31", "17", "", "", "", "41.20117", "48.98712", "Asia/Baku"),
("586925", "Buzovna", "Бузовна", "AZ", "31", "09", "", "", "", "40.51903", "50.11438", "Asia/Baku"),
("586968", "Biny Selo", "Бина", "AZ", "31", "09", "", "", "", "40.45076", "50.08686", "Asia/Baku"),
("587057", "Barda", "Барда", "AZ", "31", "11", "", "", "", "40.37577", "47.12619", "Asia/Baku"),
("587078", "Bilajari", "", "AZ", "31", "09", "", "", "", "40.4444", "49.80566", "Asia/Baku"),
("587084", "Baku", "Баку", "AZ", "31", "09", "", "", "", "40.37767", "49.89201", "Asia/Baku"),
("587261", "Amirdzhan", "", "AZ", "31", "09", "", "", "", "40.42639", "49.98361", "Asia/Baku"),
("587361", "Aghsu", "Ахсу", "AZ", "31", "06", "", "", "", "40.57028", "48.40087", "Asia/Baku"),
("587378", "Agdas", "Агдаш", "AZ", "31", "04", "", "", "", "40.64699", "47.4738", "Asia/Baku"),
("587384", "Agdzhabedy", "Агджабеди", "AZ", "31", "02", "", "", "", "40.05015", "47.45937", "Asia/Baku"),
("824003", "Bakixanov", "Бакиханова", "AZ", "31", "09", "", "", "", "40.41894", "49.96693", "Asia/Baku"),
("3186573", "Zenica", "Зеница", "BA", "70", "01", "", "", "", "44.20169", "17.90397", "Europe/Sarajevo"),
("3187609", "Visoko", "Високо", "BA", "70", "01", "", "", "", "43.98889", "18.17806", "Europe/Sarajevo"),
("3188225", "Velika Kladusa", "Велика-Кладуша", "BA", "70", "01", "", "", "", "45.18497", "15.80579", "Europe/Sarajevo"),
("3188582", "Tuzla", "Тузла", "BA", "70", "01", "", "", "", "44.53842", "18.66709", "Europe/Sarajevo"),
("3188893", "Trebinje", "Требинье", "BA", "70", "02", "", "", "", "42.71197", "18.34362", "Europe/Sarajevo"),
("3188924", "Travnik", "Травник", "BA", "70", "01", "", "", "", "44.22637", "17.66582", "Europe/Sarajevo"),
("3191281", "Sarajevo", "Сараево", "BA", "70", "01", "3343737", "", "", "43.84864", "18.35644", "Europe/Sarajevo"),
("3192409", "Prijedor", "Приедора", "BA", "70", "02", "", "", "", "44.97991", "16.71401", "Europe/Sarajevo"),
("3194828", "Mostar", "Мостар", "BA", "70", "01", "3343740", "", "", "43.34333", "17.80806", "Europe/Sarajevo"),
("3199744", "Gradacac", "", "BA", "70", "01", "", "", "", "44.87851", "18.42764", "Europe/Sarajevo"),
("3199779", "Gracanica", "", "BA", "70", "01", "", "", "", "44.70307", "18.3101", "Europe/Sarajevo"),
("3200396", "Gorazde", "Горажде", "BA", "70", "01", "", "", "", "43.66795", "18.97564", "Europe/Sarajevo"),
("3201984", "Doboj", "Добой", "BA", "70", "02", "", "", "", "44.73179", "18.08698", "Europe/Sarajevo"),
("3202822", "Cazin", "", "BA", "70", "01", "", "", "", "44.96694", "15.94306", "Europe/Sarajevo"),
("3203099", "Bugojno", "Бугойно", "BA", "70", "01", "", "", "", "44.05722", "17.45083", "Europe/Sarajevo"),
("3203521", "Brcko", "Брчко", "BA", "70", "BRC", "", "", "", "44.87278", "18.80833", "Europe/Sarajevo"),
("3203653", "Bosanska Krupa", "Босанска Крупа", "BA", "70", "01", "", "", "", "44.8825", "16.15139", "Europe/Sarajevo"),
("3204186", "Bijeljina", "Биелине", "BA", "70", "02", "", "", "", "44.75874", "19.21437", "Europe/Sarajevo"),
("3204222", "Bihac", "Бихач", "BA", "70", "01", "", "", "", "44.81694", "15.87083", "Europe/Sarajevo"),
("3204541", "Banja Luka", "Баня-Лука", "BA", "70", "02", "", "", "", "44.77583", "17.18556", "Europe/Sarajevo"),
("3337476", "Konjic", "", "BA", "70", "01", "", "", "", "43.65126", "17.96082", "Europe/Sarajevo"),
("3374036", "Bridgetown", "Бриджтаун", "BB", "52", "08", "", "", "", "13.1", "-59.61667", "America/Barbados"),
("1185092", "Thakurgaon", "", "BD", "50", "87", "", "", "", "26.03097", "88.46989", "Asia/Dhaka"),
("1185095", "Teknaf", "", "BD", "50", "84", "", "", "", "20.86382", "92.30153", "Asia/Dhaka"),
("1185098", "Tungi", "", "BD", "50", "81", "", "", "", "23.89154", "90.40232", "Asia/Dhaka"),
("1185099", "Sylhet", "Силхет", "BD", "50", "86", "", "", "", "24.89904", "91.87198", "Asia/Dhaka"),
("1185100", "Dohar", "", "BD", "50", "81", "", "", "", "23.59311", "90.14251", "Asia/Dhaka"),
("1185106", "Jamalpur", "", "BD", "50", "81", "", "", "", "24.91965", "89.94812", "Asia/Dhaka"),
("1185108", "Shibganj", "", "BD", "50", "83", "", "", "", "24.68501", "88.15638", "Asia/Dhaka"),
("1185111", "Satkhira", "", "BD", "50", "82", "", "", "", "22.70817", "89.07185", "Asia/Dhaka"),
("1185115", "Sirajganj", "Сираджгандж", "BD", "50", "83", "", "", "", "24.45771", "89.70802", "Asia/Dhaka"),
("1185116", "Netrakona", "", "BD", "50", "81", "", "", "", "24.88352", "90.72898", "Asia/Dhaka"),
("1185117", "Narsingdi", "", "BD", "50", "81", "", "", "", "23.92298", "90.71768", "Asia/Dhaka"),
("1185120", "Sandwip", "Сандвип", "BD", "50", "84", "", "", "", "22.51409", "91.45491", "Asia/Dhaka"),
("1185121", "Shahzadpur", "", "BD", "50", "83", "", "", "", "24.17687", "89.5988", "Asia/Dhaka"),
("1185127", "Ramganj", "", "BD", "50", "84", "", "", "", "23.1006", "90.84989", "Asia/Dhaka"),
("1185128", "Rajshahi", "Раджшахи", "BD", "50", "83", "", "", "", "24.374", "88.60114", "Asia/Dhaka"),
("1185138", "Pirojpur", "", "BD", "50", "85", "", "", "", "22.57965", "89.97521", "Asia/Dhaka"),
("1185141", "Panchagarh", "", "BD", "50", "87", "", "", "", "26.33338", "88.55777", "Asia/Dhaka"),
("1185148", "Patiya", "", "BD", "50", "84", "", "", "", "22.29543", "91.979", "Asia/Dhaka"),
("1185149", "Parbatipur", "", "BD", "50", "87", "", "", "", "25.66369", "88.93093", "Asia/Dhaka"),
("1185155", "Narayanganj", "", "BD", "50", "81", "", "", "", "23.61352", "90.50298", "Asia/Dhaka"),
("1185156", "Nalchiti", "", "BD", "50", "85", "", "", "", "22.63696", "90.27195", "Asia/Dhaka"),
("1185159", "Nagarpur", "", "BD", "50", "81", "", "", "", "24.05783", "89.87696", "Asia/Dhaka"),
("1185160", "Nageswari", "", "BD", "50", "87", "", "", "", "25.96817", "89.69153", "Asia/Dhaka"),
("1185162", "Mymensingh", "Майменсингх", "BD", "50", "81", "", "", "", "24.75636", "90.40646", "Asia/Dhaka"),
("1185164", "Muktagacha", "", "BD", "50", "81", "", "", "", "24.76484", "90.25698", "Asia/Dhaka"),
("1185165", "Mirzapur", "Мирзапур", "BD", "50", "81", "", "", "", "24.10287", "90.09841", "Asia/Dhaka"),
("1185166", "Maulavi Bazar", "", "BD", "50", "86", "", "", "", "24.48888", "91.77075", "Asia/Dhaka"),
("1185167", "Morrelgonj", "", "BD", "50", "82", "", "", "", "22.45566", "89.85584", "Asia/Dhaka"),
("1185171", "Mehendiganj", "", "BD", "50", "85", "", "", "", "22.82257", "90.52859", "Asia/Dhaka"),
("1185173", "Mathba", "", "BD", "50", "85", "", "", "", "22.28616", "89.95882", "Asia/Dhaka"),
("1185181", "Lalmanirhat", "", "BD", "50", "87", "", "", "", "25.91719", "89.44595", "Asia/Dhaka"),
("1185183", "Laksham", "", "BD", "50", "84", "", "", "", "23.24018", "91.12143", "Asia/Dhaka"),
("1185186", "Comilla", "Комилле", "BD", "50", "84", "", "", "", "23.46186", "91.18504", "Asia/Dhaka"),
("1185188", "Rangpur", "Рангпур", "BD", "50", "87", "", "", "", "25.74664", "89.25166", "Asia/Dhaka"),
("1185191", "Kushtia", "", "BD", "50", "82", "", "", "", "23.9028", "89.11943", "Asia/Dhaka"),
("1185199", "Kaliganj", "", "BD", "50", "82", "", "", "", "23.40964", "89.13801", "Asia/Dhaka"),
("1185204", "Jhingergacha", "", "BD", "50", "82", "", "", "", "23.11134", "89.09061", "Asia/Dhaka"),
("1185206", "Joypur Hat", "", "BD", "50", "83", "", "", "", "25.10147", "89.02734", "Asia/Dhaka"),
("1185207", "Ishurdi", "", "BD", "50", "83", "", "", "", "24.12858", "89.06573", "Asia/Dhaka"),
("1185209", "Habiganj", "", "BD", "50", "86", "", "", "", "24.38044", "91.413", "Asia/Dhaka"),
("1185210", "Gaurnadi", "", "BD", "50", "85", "", "", "", "22.97372", "90.22376", "Asia/Dhaka"),
("1185218", "Gafargaon", "", "BD", "50", "81", "", "", "", "24.432", "90.5585", "Asia/Dhaka"),
("1185224", "Feni", "", "BD", "50", "84", "", "", "", "23.01134", "91.4013", "Asia/Dhaka"),
("1185236", "Raipur", "Райпур", "BD", "50", "84", "", "", "", "23.0391", "90.76808", "Asia/Dhaka"),
("1185239", "Sarankhola", "", "BD", "50", "82", "", "", "", "22.31006", "89.79113", "Asia/Dhaka"),
("1185241", "Dhaka", "Дакка", "BD", "50", "81", "13", "", "", "23.7104", "90.40744", "Asia/Dhaka"),
("1185247", "Chilmari", "", "BD", "50", "87", "", "", "", "25.55613", "89.67097", "Asia/Dhaka"),
("1185249", "Chhagalnaiya", "", "BD", "50", "84", "", "", "", "23.02475", "91.51092", "Asia/Dhaka"),
("1185251", "Lalmohan", "", "BD", "50", "85", "", "", "", "22.33774", "90.73708", "Asia/Dhaka"),
("1185252", "Khagrachhari", "Кхаграчари", "BD", "50", "84", "", "", "", "23.10787", "91.97006", "Asia/Dhaka"),
("1185254", "Chhatak", "", "BD", "50", "86", "", "", "", "25.03858", "91.6815", "Asia/Dhaka"),
("1185260", "Bhatpara Abhaynagar", "", "BD", "50", "82", "", "", "", "23.01472", "89.43936", "Asia/Dhaka"),
("1185262", "Bheramara", "", "BD", "50", "82", "", "", "", "24.02452", "88.99234", "Asia/Dhaka"),
("1185263", "Bhairab Bazar", "", "BD", "50", "81", "", "", "", "24.0524", "90.9764", "Asia/Dhaka"),
("1185270", "Bandarban", "Бандарбан", "BD", "50", "84", "", "", "", "22.19534", "92.21946", "Asia/Dhaka"),
("1185272", "Kalia", "Калия", "BD", "50", "82", "", "", "", "23.043", "89.63094", "Asia/Dhaka"),
("1185274", "Baniachang", "", "BD", "50", "86", "", "", "", "24.51863", "91.35787", "Asia/Dhaka"),
("1185276", "Bajitpur", "", "BD", "50", "81", "", "", "", "24.21623", "90.95002", "Asia/Dhaka"),
("1185283", "Badarganj", "", "BD", "50", "87", "", "", "", "25.67419", "89.05377", "Asia/Dhaka"),
("1185293", "Narail", "", "BD", "50", "82", "", "", "", "23.15509", "89.49515", "Asia/Dhaka"),
("1185920", "Tungipara", "", "BD", "50", "81", "", "", "", "22.89983", "89.90326", "Asia/Dhaka"),
("1188569", "Sarishabari", "", "BD", "50", "81", "", "", "", "24.75127", "89.83126", "Asia/Dhaka"),
("1189056", "Sakhipur", "", "BD", "50", "81", "", "", "", "24.31988", "90.16943", "Asia/Dhaka"),
("1189638", "Raojan", "", "BD", "50", "84", "", "", "", "22.53511", "91.91919", "Asia/Dhaka"),
("1191139", "Phultala", "", "BD", "50", "82", "", "", "", "22.71673", "89.51194", "Asia/Dhaka"),
("1191368", "Palang", "", "BD", "50", "81", "", "", "", "23.21824", "90.35076", "Asia/Dhaka"),
("1192366", "Par Naogaon", "", "BD", "50", "83", "", "", "", "24.80418", "88.94875", "Asia/Dhaka"),
("1193823", "Nabinagar", "", "BD", "50", "84", "", "", "", "23.88791", "90.96792", "Asia/Dhaka"),
("1196292", "Lakshmipur", "", "BD", "50", "84", "", "", "", "22.9443", "90.83005", "Asia/Dhaka"),
("1197895", "Kesabpur", "", "BD", "50", "82", "", "", "", "22.90725", "89.21954", "Asia/Dhaka"),
("1201753", "Hajiganj", "", "BD", "50", "84", "", "", "", "23.25191", "90.85508", "Asia/Dhaka"),
("1203344", "Faridpur", "", "BD", "50", "81", "", "", "", "23.60612", "89.84064", "Asia/Dhaka"),
("1203891", "Dinajpur", "", "BD", "50", "87", "", "", "", "25.62745", "88.63779", "Asia/Dhaka"),
("1205481", "Uttar Char Fasson", "", "BD", "50", "82", "", "", "", "22.22647", "90.71275", "Asia/Dhaka"),
("1205733", "Chittagong", "Читтагонг", "BD", "50", "84", "Chittagong", "", "", "22.3384", "91.83168", "Asia/Dhaka"),
("1207047", "Char Bhadrasan", "", "BD", "50", "81", "", "", "", "23.30916", "90.22698", "Asia/Dhaka"),
("1209562", "Bera", "Беру", "BD", "50", "83", "", "", "", "24.07821", "89.63262", "Asia/Dhaka"),
("1210565", "Burhanuddin", "", "BD", "50", "85", "", "", "", "22.49518", "90.7239", "Asia/Dhaka"),
("1336133", "Satkania", "", "BD", "50", "84", "", "", "", "22.07639", "92.04955", "Asia/Dhaka"),
("1336134", "Cox's Bazar", "Кокс-Базар", "BD", "50", "84", "", "", "", "21.45388", "91.96765", "Asia/Dhaka"),
("1336135", "Khulna", "Кхулна", "BD", "50", "82", "", "", "", "22.80978", "89.56439", "Asia/Dhaka"),
("1336136", "Bhola", "Бхола", "BD", "50", "85", "", "", "", "22.68759", "90.64403", "Asia/Dhaka"),
("1336137", "Barisal", "Барисал", "BD", "50", "85", "", "", "", "22.70497", "90.37013", "Asia/Dhaka"),
("1336140", "Jessore", "", "BD", "50", "82", "", "", "", "23.16971", "89.21371", "Asia/Dhaka"),
("1336143", "Pabna", "Пабне", "BD", "50", "83", "", "", "", "24.00644", "89.2372", "Asia/Dhaka"),
("1336144", "Tangail", "", "BD", "50", "81", "", "", "", "24.24984", "89.91655", "Asia/Dhaka"),
("1337233", "Bogra", "Богра", "BD", "50", "83", "", "", "", "24.85098", "89.37108", "Asia/Dhaka"),
("1337239", "Pirgaaj", "", "BD", "50", "87", "", "", "", "25.85587", "88.35943", "Asia/Dhaka"),
("1337240", "Nawabganj", "", "BD", "50", "83", "", "", "", "24.59025", "88.27444", "Asia/Dhaka"),
("1337245", "Madaripur", "", "BD", "50", "81", "", "", "", "23.17097", "90.20935", "Asia/Dhaka"),
("1337248", "Sherpur", "", "BD", "50", "81", "", "", "", "25.01881", "90.01751", "Asia/Dhaka"),
("1337249", "Kishorganj", "", "BD", "50", "81", "", "", "", "24.43944", "90.78291", "Asia/Dhaka"),
("1462681", "Manikchari", "", "BD", "50", "84", "", "", "", "22.83957", "91.84128", "Asia/Dhaka"),
("1477498", "Bhandaria", "", "BD", "50", "85", "", "", "", "22.48898", "90.06273", "Asia/Dhaka"),
("6414184", "Fatikchari", "", "BD", "50", "84", "", "", "", "22.68768", "91.78123", "Asia/Dhaka"),
("6545349", "Saidpur", "", "BD", "50", "83", "", "", "", "25.77769", "88.89169", "Asia/Dhaka"),
("2783081", "Zwijndrecht", "", "BE", "56", "VLG", "VAN", "11", "11056", "51.21979", "4.32664", "Europe/Brussels"),
("2783089", "Zwevegem", "", "BE", "56", "VLG", "VWV", "34", "34042", "50.81268", "3.33848", "Europe/Brussels"),
("2783175", "Zottegem", "Зоттегем", "BE", "56", "VLG", "VOV", "41", "41081", "50.86956", "3.81052", "Europe/Brussels"),
("2783188", "Zonhoven", "", "BE", "56", "VLG", "VLI", "71", "71066", "50.99064", "5.36819", "Europe/Brussels"),
("2783204", "Zoersel", "", "BE", "56", "VLG", "VAN", "11", "11055", "51.26825", "4.71296", "Europe/Brussels"),
("2783274", "Zemst", "Земст", "BE", "56", "VLG", "VBR", "23", "23096", "50.98318", "4.46079", "Europe/Brussels"),
("2783293", "Zele", "Зеле", "BE", "56", "VLG", "VOV", "42", "42028", "51.06566", "4.0403", "Europe/Brussels"),
("2783308", "Zedelgem", "Зедельгем", "BE", "56", "VLG", "VWV", "31", "31040", "51.14236", "3.1368", "Europe/Brussels"),
("2783310", "Zaventem", "", "BE", "56", "VLG", "VBR", "23", "23094", "50.88365", "4.47298", "Europe/Brussels"),
("2783416", "Wuustwezel", "", "BE", "56", "VLG", "VAN", "11", "11053", "51.39214", "4.59546", "Europe/Brussels"),
("2783632", "Willebroek", "Виллебрук", "BE", "56", "VLG", "VAN", "12", "12040", "51.06041", "4.36019", "Europe/Brussels"),
("2783759", "Wevelgem", "Вевельгеме", "BE", "56", "VLG", "VWV", "34", "34041", "50.8", "3.16667", "Europe/Brussels"),
("2783763", "Wetteren", "Веттерен", "BE", "56", "VLG", "VOV", "42", "42025", "51.00526", "3.88341", "Europe/Brussels"),
("2783801", "Westerlo", "Вестерло", "BE", "56", "VLG", "VAN", "13", "13049", "51.09049", "4.91544", "Europe/Brussels"),
("2783820", "Wervik", "", "BE", "56", "VLG", "VWV", "33", "33029", "50.78069", "3.03854", "Europe/Brussels"),
("2783941", "Wavre", "Вавр", "BE", "56", "WAL", "WBR", "25", "25112", "50.71717", "4.60138", "Europe/Brussels"),
("2783985", "Waterloo", "Ватерлоо", "BE", "56", "WAL", "WBR", "25", "25110", "50.71469", "4.3991", "Europe/Brussels"),
("2784068", "Waregem", "Варегем", "BE", "56", "VLG", "VWV", "34", "34040", "50.88898", "3.42756", "Europe/Brussels"),
("2784189", "Walcourt", "Валькур", "BE", "56", "WAL", "WNA", "93", "93088", "50.25401", "4.43796", "Europe/Brussels"),
("2784548", "Vise", "", "BE", "56", "WAL", "WLG", "62", "62108", "50.7376", "5.69907", "Europe/Brussels"),
("2784604", "Vilvoorde", "Вилворде", "BE", "56", "VLG", "VBR", "23", "23088", "50.92814", "4.42938", "Europe/Brussels"),
("2784821", "Verviers", "Вервье", "BE", "56", "WAL", "WLG", "63", "63079", "50.58907", "5.86241", "Europe/Brussels"),
("2785141", "Turnhout", "Турнхоут", "BE", "56", "VLG", "VAN", "13", "13040", "51.32254", "4.94471", "Europe/Brussels"),
("2785169", "Tubize", "Тюбиз", "BE", "56", "WAL", "WBR", "25", "25105", "50.69059", "4.2009", "Europe/Brussels"),
("2785341", "Tournai", "Турне", "BE", "56", "WAL", "WHT", "57", "57081", "50.60715", "3.38932", "Europe/Brussels"),
("2785364", "Torhout", "Торхоут", "BE", "56", "VLG", "VWV", "31", "31033", "51.0656", "3.10085", "Europe/Brussels"),
("2785389", "Tongeren", "Тонгерен", "BE", "56", "VLG", "VLI", "73", "73083", "50.78054", "5.46484", "Europe/Brussels"),
("2785470", "Tienen", "Тинен", "BE", "56", "VLG", "VBR", "24", "24107", "50.80744", "4.9378", "Europe/Brussels"),
("2785476", "Tielt", "", "BE", "56", "VLG", "VWV", "37", "37015", "50.99931", "3.32707", "Europe/Brussels"),
("2785612", "Tessenderlo", "", "BE", "56", "VLG", "VLI", "71", "71057", "51.06513", "5.08856", "Europe/Brussels"),
("2785622", "Tervuren", "Тервюрен", "BE", "56", "VLG", "VBR", "24", "24104", "50.82372", "4.51418", "Europe/Brussels"),
("2785778", "Temse", "Темсе", "BE", "56", "VLG", "VOV", "46", "46025", "51.12794", "4.21372", "Europe/Brussels"),
("2786087", "Stekene", "", "BE", "56", "VLG", "VOV", "46", "46024", "51.2099", "4.0365", "Europe/Brussels"),
("2786229", "Stabroek", "", "BE", "56", "VLG", "VAN", "11", "11044", "51.33189", "4.37127", "Europe/Brussels"),
("2786344", "Soumagne", "Сумань", "BE", "56", "WAL", "WLG", "62", "62099", "50.61385", "5.74679", "Europe/Brussels"),
("2786420", "Soignies", "Суанье", "BE", "56", "WAL", "WHT", "55", "55040", "50.57904", "4.07129", "Europe/Brussels"),
("2786545", "Sint-Truiden", "Синт-Трюйден", "BE", "56", "VLG", "VLI", "71", "71053", "50.81679", "5.18647", "Europe/Brussels"),
("2786559", "Sint-Pieters-Leeuw", "", "BE", "56", "VLG", "VBR", "23", "23077", "50.77926", "4.24355", "Europe/Brussels"),
("2786578", "Sint-Niklaas", "Синт-Никлас", "BE", "56", "VLG", "VOV", "46", "46021", "51.16509", "4.1437", "Europe/Brussels"),
("2786634", "Sint-Kruis", "", "BE", "56", "VLG", "VWV", "", "", "51.21399", "3.24949", "Europe/Brussels"),
("2786641", "Sint-Katelijne-Waver", "", "BE", "56", "VLG", "VAN", "12", "12035", "51.06691", "4.53469", "Europe/Brussels"),
("2786694", "Sint-Gillis-Waas", "", "BE", "56", "VLG", "VOV", "46", "46020", "51.21914", "4.12374", "Europe/Brussels"),
("2786700", "Sint-Genesius-Rode", "", "BE", "56", "VLG", "VBR", "23", "23101", "50.74645", "4.35754", "Europe/Brussels"),
("2786824", "Seraing", "Серен", "BE", "56", "WAL", "WLG", "62", "62096", "50.58362", "5.50115", "Europe/Brussels"),
("2786963", "Schoten", "", "BE", "56", "VLG", "VAN", "11", "11040", "51.25251", "4.50268", "Europe/Brussels"),
("2787048", "Schilde", "Шильде", "BE", "56", "VLG", "VAN", "11", "11039", "51.24107", "4.58336", "Europe/Brussels"),
("2787356", "Saint-Nicolas", "Санкт-Никола", "BE", "56", "WAL", "WLG", "62", "62093", "50.62837", "5.53243", "Europe/Brussels"),
("2787416", "Saint-Ghislain", "Санкт-Гилене", "BE", "56", "WAL", "WHT", "53", "53070", "50.44816", "3.81886", "Europe/Brussels"),
("2787662", "Rotselaar", "", "BE", "56", "VLG", "VBR", "24", "24094", "50.95302", "4.71665", "Europe/Brussels"),
("2787769", "Ronse", "Ронсе", "BE", "56", "VLG", "VOV", "45", "45041", "50.74574", "3.6005", "Europe/Brussels"),
("2787889", "Roeselare", "Руселаре", "BE", "56", "VLG", "VWV", "36", "36015", "50.94653", "3.12269", "Europe/Brussels"),
("2787989", "Rixensart", "Риксенсарт", "BE", "56", "WAL", "WBR", "25", "25091", "50.71229", "4.52529", "Europe/Brussels"),
("2788088", "Riemst", "", "BE", "56", "VLG", "VLI", "73", "73066", "50.80995", "5.60131", "Europe/Brussels"),
("2788348", "Ranst", "", "BE", "56", "VLG", "VAN", "11", "11035", "51.18983", "4.56533", "Europe/Brussels"),
("2788499", "Quaregnon", "", "BE", "56", "WAL", "WHT", "53", "53065", "50.44067", "3.8653", "Europe/Brussels"),
("2788506", "Puurs", "", "BE", "56", "VLG", "VAN", "12", "12030", "51.07409", "4.28844", "Europe/Brussels"),
("2788521", "Putte", "", "BE", "56", "VLG", "VAN", "12", "12029", "51.05337", "4.63263", "Europe/Brussels"),
("2788726", "Poperinge", "Поперинге", "BE", "56", "VLG", "VWV", "33", "33021", "50.85386", "2.72659", "Europe/Brussels"),
("2788765", "Pont-a-Celles", "", "BE", "56", "WAL", "WHT", "52", "52055", "50.50518", "4.36887", "Europe/Brussels"),
("2789162", "Peruwelz", "Перювельз", "BE", "56", "WAL", "WHT", "57", "57064", "50.50819", "3.59373", "Europe/Brussels"),
("2789232", "Peer", "", "BE", "56", "VLG", "VLI", "72", "72030", "51.1303", "5.45952", "Europe/Brussels"),
("2789413", "Overijse", "Оверийсе", "BE", "56", "VLG", "VBR", "23", "23062", "50.77436", "4.53461", "Europe/Brussels"),
("2789471", "Oupeye", "Упе", "BE", "56", "WAL", "WLG", "62", "62079", "50.71184", "5.6468", "Europe/Brussels"),
("2789529", "Oudenaarde", "Оуденаарде", "BE", "56", "VLG", "VOV", "45", "45035", "50.85168", "3.60891", "Europe/Brussels"),
("2789751", "Oostkamp", "Осткамп", "BE", "56", "VLG", "VWV", "31", "31022", "51.15432", "3.23128", "Europe/Brussels"),
("2789786", "Oostende", "Остенде", "BE", "56", "VLG", "VWV", "35", "35013", "51.22339", "2.91185", "Europe/Brussels"),
("2790101", "Nivelles", "Нивель", "BE", "56", "WAL", "WBR", "25", "25072", "50.59833", "4.32848", "Europe/Brussels"),
("2790114", "Ninove", "Нинове", "BE", "56", "VLG", "VOV", "41", "41048", "50.82776", "4.02657", "Europe/Brussels"),
("2790135", "Nijlen", "", "BE", "56", "VLG", "VAN", "12", "12026", "51.16096", "4.67008", "Europe/Brussels"),
("2790357", "Neerpelt", "", "BE", "56", "VLG", "VLI", "72", "72025", "51.22807", "5.4427", "Europe/Brussels"),
("2790471", "Namur", "Намюр", "BE", "56", "WAL", "WNA", "92", "92094", "50.4669", "4.86746", "Europe/Brussels"),
("2790595", "Mouscron", "Мускрон", "BE", "56", "WAL", "WHT", "54", "54007", "50.74497", "3.20639", "Europe/Brussels"),
("2790676", "Mortsel", "Мортсел", "BE", "56", "VLG", "VAN", "11", "11029", "51.16697", "4.45127", "Europe/Brussels"),
("2790697", "Morlanwelz-Mariemont", "", "BE", "56", "WAL", "WHT", "56", "56087", "50.45502", "4.24519", "Europe/Brussels"),
("2790869", "Mons", "Монс", "BE", "56", "WAL", "WHT", "53", "53053", "50.45413", "3.95229", "Europe/Brussels"),
("2791067", "Mol", "Мол", "BE", "56", "VLG", "VAN", "13", "13025", "51.19188", "5.11662", "Europe/Brussels"),
("2791194", "Middelkerke", "", "BE", "56", "VLG", "VWV", "35", "35011", "51.18532", "2.82077", "Europe/Brussels"),
("2791315", "Merelbeke", "Мерелбеке", "BE", "56", "VLG", "VOV", "44", "44043", "50.99447", "3.74621", "Europe/Brussels"),
("2791343", "Menen", "Менен", "BE", "56", "VLG", "VWV", "34", "34027", "50.79722", "3.12245", "Europe/Brussels"),
("2791424", "Meise", "", "BE", "56", "VLG", "VBR", "23", "23050", "50.93934", "4.32655", "Europe/Brussels"),
("2791537", "Mechelen", "Мехелен", "BE", "56", "VLG", "VAN", "12", "12025", "51.02574", "4.47762", "Europe/Brussels"),
("2791744", "Marche-en-Famenne", "Марш-ан-Фамен", "BE", "56", "WAL", "WLX", "83", "83034", "50.22678", "5.34416", "Europe/Brussels"),
("2791814", "Manage", "", "BE", "56", "WAL", "WHT", "52", "52043", "50.50312", "4.23589", "Europe/Brussels"),
("2791857", "Maldegem", "Мальдегем", "BE", "56", "VLG", "VOV", "43", "43010", "51.20737", "3.44511", "Europe/Brussels"),
("2791961", "Maasmechelen", "Маасмехелене", "BE", "56", "VLG", "VLI", "73", "73107", "50.96545", "5.69452", "Europe/Brussels"),
("2791964", "Maaseik", "Маасейк", "BE", "56", "VLG", "VLI", "72", "72021", "51.09802", "5.78379", "Europe/Brussels"),
("2792073", "Louvain-la-Neuve", "Лувен-ла-Нев", "BE", "56", "WAL", "WBR", "25", "25121", "50.66829", "4.61443", "Europe/Brussels"),
("2792165", "Londerzeel", "", "BE", "56", "VLG", "VBR", "23", "23045", "51.00468", "4.30304", "Europe/Brussels"),
("2792179", "Lommel", "Ломмел", "BE", "56", "VLG", "VLI", "72", "72020", "51.23074", "5.31349", "Europe/Brussels"),
("2792196", "Lokeren", "Локерен", "BE", "56", "VLG", "VOV", "46", "46014", "51.10364", "3.99339", "Europe/Brussels"),
("2792235", "Lochristi", "", "BE", "56", "VLG", "VOV", "44", "44034", "51.09644", "3.83194", "Europe/Brussels"),
("2792360", "Lille", "", "BE", "56", "VLG", "VAN", "13", "13019", "51.24197", "4.82312", "Europe/Brussels"),
("2792397", "Lier", "Льер", "BE", "56", "VLG", "VAN", "12", "12021", "51.13128", "4.57042", "Europe/Brussels"),
("2792413", "Liege", "Льеж", "BE", "56", "WAL", "WLG", "62", "62063", "50.63373", "5.56749", "Europe/Brussels"),
("2792482", "Leuven", "Лёвен", "BE", "56", "VLG", "VBR", "24", "24062", "50.87959", "4.70093", "Europe/Brussels"),
("2792567", "Lessines", "Лессин", "BE", "56", "WAL", "WHT", "55", "55023", "50.71104", "3.83579", "Europe/Brussels"),
("2793077", "Lede", "", "BE", "56", "VLG", "VOV", "41", "41034", "50.96626", "3.98594", "Europe/Brussels"),
("2793144", "Lebbeke", "", "BE", "56", "VLG", "VOV", "42", "42011", "51.00464", "4.13457", "Europe/Brussels"),
("2793446", "Lanaken", "", "BE", "56", "VLG", "VLI", "73", "73042", "50.89318", "5.6468", "Europe/Brussels"),
("2793508", "La Louviere", "Ла-Лувьер", "BE", "56", "WAL", "WHT", "55", "55022", "50.48657", "4.18785", "Europe/Brussels"),
("2794055", "Kortrijk", "Кортрейк", "BE", "56", "VLG", "VWV", "34", "34022", "50.82803", "3.26487", "Europe/Brussels"),
("2794070", "Kortenberg", "", "BE", "56", "VLG", "VBR", "24", "24055", "50.88982", "4.54353", "Europe/Brussels"),
("2794117", "Kontich", "Контич", "BE", "56", "VLG", "VAN", "11", "11024", "51.13213", "4.44706", "Europe/Brussels"),
("2794166", "Koksijde", "Коксийде", "BE", "56", "VLG", "VWV", "38", "38014", "51.11642", "2.63772", "Europe/Brussels"),
("2794210", "Knokke-Heist", "Кнокке-Хейст", "BE", "56", "VLG", "VWV", "31", "31043", "51.35", "3.26667", "Europe/Brussels"),
("2794663", "Kasterlee", "", "BE", "56", "VLG", "VAN", "13", "13017", "51.24118", "4.96651", "Europe/Brussels"),
("2794730", "Kapellen", "Капеллене", "BE", "56", "VLG", "VAN", "11", "11023", "51.31377", "4.43539", "Europe/Brussels"),
("2794788", "Kalmthout", "", "BE", "56", "VLG", "VAN", "11", "11022", "51.38442", "4.47556", "Europe/Brussels"),
("2795009", "Izegem", "Изегем", "BE", "56", "VLG", "VWV", "36", "36008", "50.91396", "3.21378", "Europe/Brussels"),
("2795100", "Ieper", "Ипр", "BE", "56", "VLG", "VWV", "33", "33011", "50.85114", "2.88569", "Europe/Brussels"),
("2795113", "Huy", "Юи", "BE", "56", "WAL", "WLG", "61", "61031", "50.51894", "5.23284", "Europe/Brussels"),
("2795261", "Houthalen", "", "BE", "56", "VLG", "VLI", "72", "72039", "51.03427", "5.37429", "Europe/Brussels"),
("2795398", "Hoogstraten", "Хогстратен", "BE", "56", "VLG", "VAN", "13", "13014", "51.40029", "4.76034", "Europe/Brussels"),
("2795730", "Hoboken", "", "BE", "56", "VLG", "VAN", "11", "11002", "51.17611", "4.34844", "Europe/Brussels"),
("2795800", "Heusden", "", "BE", "56", "VLG", "VLI", "71", "71070", "51.03664", "5.28013", "Europe/Brussels"),
("2795908", "Herzele", "", "BE", "56", "VLG", "VOV", "41", "41027", "50.88681", "3.89014", "Europe/Brussels"),
("2795912", "Herve", "Эрв", "BE", "56", "WAL", "WLG", "63", "63035", "50.64083", "5.79353", "Europe/Brussels"),
("2795930", "Herstal", "Эрсталь", "BE", "56", "WAL", "WLG", "62", "62051", "50.66415", "5.62346", "Europe/Brussels"),
("2796009", "Herentals", "Херенталс", "BE", "56", "VLG", "VAN", "13", "13011", "51.17655", "4.83248", "Europe/Brussels"),
("2796012", "Herent", "", "BE", "56", "VLG", "VBR", "24", "24038", "50.90861", "4.67056", "Europe/Brussels"),
("2796132", "Helchteren", "", "BE", "56", "VLG", "VLI", "72", "72039", "51.05591", "5.38244", "Europe/Brussels"),
("2796153", "Heist-op-den-Berg", "", "BE", "56", "VLG", "VAN", "12", "12014", "51.07537", "4.72827", "Europe/Brussels"),
("2796491", "Hasselt", "Хасселт", "BE", "56", "VLG", "VLI", "71", "71022", "50.93106", "5.33781", "Europe/Brussels"),
("2796542", "Harelbeke", "Харелбеке", "BE", "56", "VLG", "VWV", "34", "34013", "50.85343", "3.30935", "Europe/Brussels"),
("2796637", "Hamme", "Хамме", "BE", "56", "VLG", "VOV", "42", "42008", "51.09822", "4.13705", "Europe/Brussels"),
("2796696", "Halle", "Галле", "BE", "56", "VLG", "VBR", "23", "23027", "50.73385", "4.23454", "Europe/Brussels"),
("2796833", "Haaltert", "", "BE", "56", "VLG", "VOV", "41", "41024", "50.90634", "4.00093", "Europe/Brussels"),
("2797114", "Grimbergen", "Гримберген", "BE", "56", "VLG", "VBR", "23", "23025", "50.93409", "4.37213", "Europe/Brussels"),
("2797638", "Geraardsbergen", "Герардсберген", "BE", "56", "VLG", "VOV", "41", "41018", "50.77343", "3.88223", "Europe/Brussels"),
("2797656", "Gent", "Гент", "BE", "56", "VLG", "VOV", "44", "44021", "51.05", "3.71667", "Europe/Brussels"),
("2797670", "Genk", "Генк", "BE", "56", "VLG", "VLI", "71", "71016", "50.965", "5.50082", "Europe/Brussels"),
("2797713", "Gembloux", "Гемблуа", "BE", "56", "WAL", "WNA", "92", "92142", "50.56149", "4.69889", "Europe/Brussels"),
("2797779", "Geel", "Геел", "BE", "56", "VLG", "VAN", "13", "13008", "51.16557", "4.98917", "Europe/Brussels"),
("2798023", "Frameries", "Фрамерис", "BE", "56", "WAL", "WHT", "53", "53028", "50.40578", "3.89603", "Europe/Brussels"),
("2798297", "Fleurus", "Флерус", "BE", "56", "WAL", "WHT", "52", "52021", "50.48351", "4.55006", "Europe/Brussels"),
("2798301", "Fleron", "Флерон", "BE", "56", "WAL", "WLG", "62", "62038", "50.61516", "5.68062", "Europe/Brussels"),
("2798307", "Flemalle-Haute", "", "BE", "56", "WAL", "WLG", "62", "62120", "50.59994", "5.44471", "Europe/Brussels"),
("2798551", "Evergem", "Эвергем", "BE", "56", "VLG", "VOV", "44", "44019", "51.1053", "3.704", "Europe/Brussels"),
("2798573", "Eupen", "Эйпен", "BE", "56", "WAL", "WLG", "63", "63023", "50.6279", "6.03647", "Europe/Brussels"),
("2798615", "Essen", "", "BE", "56", "VLG", "VAN", "11", "11016", "51.46272", "4.45393", "Europe/Brussels"),
("2798987", "Eeklo", "Экло", "BE", "56", "VLG", "VOV", "43", "43005", "51.18703", "3.55654", "Europe/Brussels"),
("2799007", "Edegem", "", "BE", "56", "VLG", "VAN", "11", "11013", "51.15662", "4.44504", "Europe/Brussels"),
("2799090", "Duffel", "", "BE", "56", "VLG", "VAN", "12", "12009", "51.09554", "4.50903", "Europe/Brussels"),
("2799226", "Dour", "", "BE", "56", "WAL", "WHT", "53", "53020", "50.39583", "3.77792", "Europe/Brussels"),
("2799365", "Dilbeek", "Дилбек", "BE", "56", "VLG", "VBR", "23", "23016", "50.84799", "4.25972", "Europe/Brussels"),
("2799369", "Diksmuide", "", "BE", "56", "VLG", "VWV", "32", "32003", "51.03248", "2.86384", "Europe/Brussels"),
("2799397", "Diest", "", "BE", "56", "VLG", "VBR", "24", "24020", "50.98923", "5.05062", "Europe/Brussels"),
("2799412", "Diepenbeek", "", "BE", "56", "VLG", "VLI", "71", "71011", "50.90769", "5.41875", "Europe/Brussels"),
("2799496", "Destelbergen", "", "BE", "56", "VLG", "VOV", "44", "44013", "51.05952", "3.79899", "Europe/Brussels"),
("2799645", "Dendermonde", "Дендермонде", "BE", "56", "VLG", "VOV", "42", "42006", "51.02869", "4.10106", "Europe/Brussels"),
("2799647", "Denderleeuw", "", "BE", "56", "VLG", "VOV", "41", "41011", "50.88506", "4.07601", "Europe/Brussels"),
("2799746", "Deinze", "Дейнзе", "BE", "56", "VLG", "VOV", "44", "44011", "50.98175", "3.53096", "Europe/Brussels"),
("2800063", "Courcelles", "Курсель", "BE", "56", "WAL", "WHT", "52", "52015", "50.46379", "4.3747", "Europe/Brussels"),
("2800220", "Colfontaine", "", "BE", "56", "WAL", "WHT", "53", "53082", "50.4141", "3.85569", "Europe/Brussels"),
("2800438", "Chaudfontaine", "", "BE", "56", "WAL", "WLG", "62", "62022", "50.5828", "5.6341", "Europe/Brussels"),
("2800448", "Chatelet", "Шатле", "BE", "56", "WAL", "WHT", "52", "52012", "50.40338", "4.52826", "Europe/Brussels"),
("2800461", "Chasse Royale", "", "BE", "56", "WAL", "WHT", "", "", "50.42842", "3.95001", "Europe/Brussels"),
("2800481", "Charleroi", "Шарлеруа", "BE", "56", "WAL", "WHT", "52", "52011", "50.41136", "4.44448", "Europe/Brussels"),
("2800866", "Brussels", "Брюссель", "BE", "56", "BRU", "BRU", "21", "21004", "50.85045", "4.34878", "Europe/Brussels"),
("2800931", "Brugge", "Брюгге", "BE", "56", "VLG", "VWV", "31", "31005", "51.20892", "3.22424", "Europe/Brussels"),
("2801106", "Brecht", "Брехт", "BE", "56", "VLG", "VAN", "11", "11009", "51.35024", "4.63829", "Europe/Brussels"),
("2801117", "Brasschaat", "Брасхат", "BE", "56", "VLG", "VAN", "11", "11008", "51.2912", "4.49182", "Europe/Brussels"),
("2801150", "Braine-le-Comte", "Брем-ле-Конт", "BE", "56", "WAL", "WHT", "55", "55004", "50.60979", "4.14658", "Europe/Brussels"),
("2801154", "Braine-l'Alleud", "Брен-л'Аллё", "BE", "56", "WAL", "WBR", "25", "25014", "50.68363", "4.36784", "Europe/Brussels"),
("2801226", "Boussu", "Боуссу", "BE", "56", "WAL", "WHT", "53", "53014", "50.43417", "3.7944", "Europe/Brussels"),
("2801447", "Bornem", "", "BE", "56", "VLG", "VAN", "12", "12007", "51.09716", "4.24364", "Europe/Brussels"),
("2801494", "Boom", "", "BE", "56", "VLG", "VAN", "11", "11005", "51.09242", "4.3717", "Europe/Brussels"),
("2801858", "Blankenberge", "Бланкенберге", "BE", "56", "VLG", "VWV", "31", "31004", "51.31306", "3.13227", "Europe/Brussels"),
("2801922", "Binche", "Бенш", "BE", "56", "WAL", "WHT", "56", "56011", "50.41155", "4.16469", "Europe/Brussels"),
("2801924", "Bilzen", "Билзен", "BE", "56", "VLG", "VLI", "73", "73006", "50.87325", "5.5184", "Europe/Brussels"),
("2802031", "Beveren", "Беверен", "BE", "56", "VLG", "VOV", "46", "46003", "51.21187", "4.25633", "Europe/Brussels"),
("2802170", "Beringen", "Берингене", "BE", "56", "VLG", "VLI", "71", "71004", "51.04954", "5.22606", "Europe/Brussels"),
("2802433", "Beersel", "Берсел", "BE", "56", "VLG", "VBR", "23", "23003", "50.76589", "4.3002", "Europe/Brussels"),
("2802435", "Beerse", "", "BE", "56", "VLG", "VAN", "13", "13004", "51.31927", "4.85304", "Europe/Brussels"),
("2802743", "Balen", "", "BE", "56", "VLG", "VAN", "13", "13003", "51.16837", "5.17027", "Europe/Brussels"),
("2803010", "Ath", "Ат", "BE", "56", "WAL", "WHT", "51", "51004", "50.62937", "3.77801", "Europe/Brussels"),
("2803033", "Asse", "Ассо", "BE", "56", "VLG", "VBR", "23", "23002", "50.91011", "4.19836", "Europe/Brussels"),
("2803073", "Arlon", "Арлон", "BE", "56", "WAL", "WLX", "81", "81001", "49.68333", "5.81667", "Europe/Brussels"),
("2803138", "Antwerpen", "Антверпен", "BE", "56", "VLG", "VAN", "11", "11002", "51.21989", "4.40346", "Europe/Brussels"),
("2803160", "Ans", "Анс", "BE", "56", "WAL", "WLG", "62", "62003", "50.6623", "5.52029", "Europe/Brussels"),
("2803204", "Andenne", "Анден", "BE", "56", "WAL", "WNA", "92", "92003", "50.48941", "5.09513", "Europe/Brussels"),
("2803429", "Aarschot", "Ааршот", "BE", "56", "VLG", "VBR", "24", "24001", "50.98715", "4.83695", "Europe/Brussels"),
("2803443", "Aalter", "Алтер", "BE", "56", "VLG", "VOV", "44", "44001", "51.09017", "3.44693", "Europe/Brussels"),
("2803448", "Aalst", "", "BE", "56", "VLG", "VOV", "41", "41002", "50.93604", "4.0355", "Europe/Brussels"),
("2353197", "Zorgo", "", "BF", "854", "11", "20", "", "", "12.24922", "-0.61527", "Africa/Ouagadougou"),
("2353688", "Yako", "Яко", "BF", "854", "10", "34", "", "", "12.9591", "-2.26075", "Africa/Ouagadougou"),
("2354176", "Tougan", "", "BF", "854", "01", "73", "", "", "13.0725", "-3.0694", "Africa/Ouagadougou"),
("2354349", "Titao", "", "BF", "854", "10", "62", "", "", "13.76667", "-2.06667", "Africa/Ouagadougou"),
("2354675", "Tenkodogo", "", "BF", "854", "04", "49", "", "", "11.78", "-0.36972", "Africa/Ouagadougou"),
("2356228", "Reo", "Рео", "BF", "854", "06", "36", "", "", "12.31963", "-2.47094", "Africa/Ouagadougou"),
("2356454", "Po", "", "BF", "854", "07", "65", "", "", "11.16972", "-1.145", "Africa/Ouagadougou"),
("2357043", "Ouahigouya", "", "BF", "854", "10", "76", "", "", "13.58278", "-2.42158", "Africa/Ouagadougou"),
("2357048", "Ouagadougou", "Уагадугу", "BF", "854", "03", "53", "", "", "12.36566", "-1.53388", "Africa/Ouagadougou"),
("2357163", "Nouna", "", "BF", "854", "01", "58", "", "", "12.72938", "-3.86305", "Africa/Ouagadougou"),
("2358100", "Manga", "", "BF", "854", "07", "44", "", "", "11.66361", "-1.07306", "Africa/Ouagadougou"),
("2358382", "Leo", "Лев", "BF", "854", "06", "72", "", "", "11.10033", "-2.10654", "Africa/Ouagadougou"),
("2358738", "Koupela", "", "BF", "854", "04", "28", "", "", "12.17864", "-0.35103", "Africa/Ouagadougou"),
("2358946", "Koudougou", "Кудугу", "BF", "854", "06", "19", "", "", "12.25263", "-2.36272", "Africa/Ouagadougou"),
("2359142", "Kongoussi", "", "BF", "854", "05", "15", "", "", "13.32583", "-1.53472", "Africa/Ouagadougou"),
("2359227", "Kombissiri", "", "BF", "854", "07", "47", "", "", "12.06095", "-1.33355", "Africa/Ouagadougou"),
("2359317", "Kokologo", "", "BF", "854", "06", "19", "", "", "12.18972", "-1.88556", "Africa/Ouagadougou"),
("2359608", "Kaya", "Кая", "BF", "854", "05", "70", "", "", "13.09167", "-1.08444", "Africa/Ouagadougou"),
("2360073", "Hounde", "", "BF", "854", "09", "74", "", "", "11.5", "-3.51667", "Africa/Ouagadougou"),
("2360238", "Gourcy", "", "BF", "854", "10", "78", "", "", "13.20776", "-2.35893", "Africa/Ouagadougou"),
("2360615", "Garango", "", "BF", "854", "04", "49", "", "", "11.8", "-0.55056", "Africa/Ouagadougou"),
("2360886", "Fada N'gourma", "", "BF", "854", "08", "50", "", "", "12.06157", "0.35843", "Africa/Ouagadougou"),
("2361082", "Dori", "Дори", "BF", "854", "12", "71", "", "", "14.0354", "-0.0345", "Africa/Ouagadougou"),
("2361177", "Djibo", "Джибо", "BF", "854", "12", "40", "", "", "14.0994", "-1.62554", "Africa/Ouagadougou"),
("2361373", "Diapaga", "Диапага", "BF", "854", "08", "42", "", "", "12.07305", "1.78838", "Africa/Ouagadougou"),
("2361477", "Dedougou", "", "BF", "854", "01", "63", "", "", "12.46338", "-3.46075", "Africa/Ouagadougou"),
("2361845", "Bousse", "", "BF", "854", "11", "60", "", "", "12.6576", "-1.89288", "Africa/Ouagadougou"),
("2361946", "Boulsa", "", "BF", "854", "05", "64", "", "", "12.66664", "-0.57468", "Africa/Ouagadougou"),
("2362344", "Bobo-Dioulasso", "Бобо-Диуласо", "BF", "854", "09", "51", "", "", "11.17715", "-4.2979", "Africa/Ouagadougou"),
("2362909", "Banfora", "Банфору", "BF", "854", "02", "55", "", "", "10.63333", "-4.76667", "Africa/Ouagadougou"),
("2577162", "Gaoua", "", "BF", "854", "13", "69", "", "", "10.29917", "-3.25083", "Africa/Ouagadougou"),
("2577164", "Orodara", "", "BF", "854", "09", "54", "", "", "10.94917", "-4.93417", "Africa/Ouagadougou"),
("725578", "Yambol", "", "BG", "100", "65", "JAM26", "", "", "42.48333", "26.5", "Europe/Sofia"),
("725712", "Vratsa", "Враца", "BG", "100", "64", "VRC10", "", "", "43.21", "23.5625", "Europe/Sofia"),
("725905", "Vidin", "Видин", "BG", "100", "63", "VID09", "", "", "43.99", "22.8725", "Europe/Sofia"),
("725988", "Velingrad", "Велинград", "BG", "100", "48", "PAZ08", "", "", "42.02754", "23.99155", "Europe/Sofia"),
("725993", "Veliko Turnovo", "", "BG", "100", "62", "VTR04", "", "", "43.08124", "25.62904", "Europe/Sofia"),
("726050", "Varna", "Варна", "BG", "100", "61", "VAR06", "", "", "43.21667", "27.91667", "Europe/Sofia"),
("726174", "Targovishte", "", "BG", "100", "60", "TGV35", "", "", "43.2512", "26.57215", "Europe/Sofia"),
("726320", "Troyan", "", "BG", "100", "46", "LOV34", "", "", "42.89427", "24.71589", "Europe/Sofia"),
("726418", "Dobrich", "Добрич", "BG", "100", "40", "DOB28", "", "", "43.56667", "27.83333", "Europe/Sofia"),
("726534", "Svishtov", "", "BG", "100", "62", "VTR28", "", "", "43.61959", "25.35044", "Europe/Sofia"),
("726546", "Svilengrad", "Свиленград", "BG", "100", "43", "HKV28", "", "", "41.76667", "26.2", "Europe/Sofia"),
("726848", "Stara Zagora", "Стара-Загора", "BG", "100", "59", "SZR31", "", "", "42.43278", "25.64194", "Europe/Sofia"),
("726872", "Dupnitsa", "", "BG", "100", "45", "KNL48", "", "", "42.26667", "23.11667", "Europe/Sofia"),
("727011", "Sofia", "София", "BG", "100", "42", "SOF46", "", "", "42.69751", "23.32415", "Europe/Sofia"),
("727030", "Smolyan", "", "BG", "100", "57", "SML31", "", "", "41.58528", "24.69194", "Europe/Sofia"),
("727079", "Sliven", "Сливен", "BG", "100", "56", "SLV20", "", "", "42.68583", "26.32917", "Europe/Sofia"),
("727221", "Silistra", "Силистра", "BG", "100", "55", "SLS31", "", "", "44.11667", "27.26667", "Europe/Sofia"),
("727233", "Shumen", "", "BG", "100", "54", "SHU30", "", "", "43.27064", "26.92286", "Europe/Sofia"),
("727337", "Sevlievo", "", "BG", "100", "41", "GAB29", "", "", "43.02583", "25.11361", "Europe/Sofia"),
("727447", "Sandanski", "", "BG", "100", "38", "BLG40", "", "", "41.56667", "23.28333", "Europe/Sofia"),
("727462", "Samokov", "", "BG", "100", "58", "SFO39", "", "", "42.337", "23.5528", "Europe/Sofia"),
("727523", "Ruse", "Русе", "BG", "100", "53", "RSE27", "", "", "43.85639", "25.97083", "Europe/Sofia"),
("727696", "Razgrad", "Разград", "BG", "100", "52", "RAZ26", "", "", "43.53333", "26.51667", "Europe/Sofia"),
("727791", "Rakovski", "", "BG", "100", "51", "PDV25", "", "", "42.3", "24.96667", "Europe/Sofia"),
("728075", "Popovo", "", "BG", "100", "60", "TGV24", "", "", "43.35", "26.23333", "Europe/Sofia"),
("728193", "Plovdiv", "Пловдив", "BG", "100", "51", "PDV22", "", "", "42.15", "24.75", "Europe/Sofia"),
("728203", "Pleven", "Плевен", "BG", "100", "50", "PVN24", "", "", "43.41667", "24.61667", "Europe/Sofia"),
("728288", "Petrich", "Петрич", "BG", "100", "38", "BLG33", "", "", "41.4", "23.21667", "Europe/Sofia"),
("728317", "Peshtera", "", "BG", "100", "48", "PAZ21", "", "", "42.03333", "24.3", "Europe/Sofia"),
("728330", "Pernik", "Перник", "BG", "100", "49", "PER32", "", "", "42.6", "23.03333", "Europe/Sofia"),
("728378", "Pazardzhik", "Пазарджик", "BG", "100", "48", "PAZ19", "", "", "42.2", "24.33333", "Europe/Sofia"),
("728448", "Panagyurishte", "", "BG", "100", "48", "PAZ20", "", "", "42.5", "24.18333", "Europe/Sofia"),
("728742", "Nova Zagora", "", "BG", "100", "56", "SLV16", "", "", "42.48333", "26.01667", "Europe/Sofia"),
("729114", "Montana", "Монтана", "BG", "100", "47", "MON29", "", "", "43.4125", "23.225", "Europe/Sofia"),
("729559", "Lovech", "Ловеч", "BG", "100", "46", "LOV18", "", "", "43.13333", "24.71667", "Europe/Sofia"),
("729581", "Lom", "", "BG", "100", "47", "MON24", "", "", "43.81389", "23.23611", "Europe/Sofia"),
("729730", "Kyustendil", "", "BG", "100", "45", "KNL29", "", "", "42.28389", "22.69111", "Europe/Sofia"),
("729794", "Kurdzhali", "Кырджали", "BG", "100", "44", "KRZ16", "", "", "41.65", "25.36667", "Europe/Sofia"),
("730435", "Haskovo", "Хасково", "BG", "100", "43", "HKV34", "", "", "41.93415", "25.55557", "Europe/Sofia"),
("730442", "Kharmanli", "", "BG", "100", "43", "HKV33", "", "", "41.93333", "25.9", "Europe/Sofia"),
("730496", "Kazanluk", "Казанлык", "BG", "100", "59", "SZR12", "", "", "42.61667", "25.4", "Europe/Sofia"),
("730559", "Karnobat", "", "BG", "100", "39", "BGS09", "", "", "42.65", "26.98333", "Europe/Sofia"),
("730565", "Karlovo", "Карлово", "BG", "100", "51", "PDV13", "", "", "42.63333", "24.8", "Europe/Sofia"),
("731108", "Gotse Delchev", "Гоце-Делчев", "BG", "100", "38", "BLG11", "", "", "41.56667", "23.73333", "Europe/Sofia"),
("731233", "Gorna Oryakhovitsa", "Горна Оряховица", "BG", "100", "62", "VTR06", "", "", "43.12778", "25.70167", "Europe/Sofia"),
("731549", "Gabrovo", "Габрово", "BG", "100", "41", "GAB05", "", "", "42.87472", "25.33417", "Europe/Sofia"),
("732263", "Dimitrovgrad", "Димитровград", "BG", "100", "43", "HKV09", "", "", "42.05", "25.6", "Europe/Sofia"),
("732452", "Chirpan", "", "BG", "100", "59", "SZR36", "", "", "42.2", "25.33333", "Europe/Sofia"),
("732491", "Cherven Bryag", "", "BG", "100", "50", "PVN37", "", "", "43.26667", "24.1", "Europe/Sofia"),
("732770", "Burgas", "Бургас", "BG", "100", "39", "BGS04", "", "", "42.50606", "27.46781", "Europe/Sofia"),
("733014", "Botevgrad", "", "BG", "100", "58", "SFO07", "", "", "42.9", "23.78333", "Europe/Sofia"),
("733191", "Blagoevgrad", "Благоевград", "BG", "100", "38", "BLG03", "", "", "42.01667", "23.1", "Europe/Sofia"),
("733264", "Berkovitsa", "", "BG", "100", "47", "MON02", "", "", "43.23611", "23.12583", "Europe/Sofia"),
("733579", "Aytos", "", "BG", "100", "39", "BGS01", "", "", "42.7", "27.25", "Europe/Sofia"),
("733618", "Asenovgrad", "", "BG", "100", "51", "PDV01", "", "", "42.01667", "24.86667", "Europe/Sofia"),
("422232", "Makamba", "Макамба", "BI", "108", "17", "", "", "", "-4.1348", "29.804", "Africa/Bujumbura"),
("423328", "Bururi", "Бурури", "BI", "108", "10", "", "", "", "-3.94877", "29.62438", "Africa/Bujumbura"),
("425378", "Bujumbura", "Бужумбура", "BI", "108", "24", "", "", "", "-3.3822", "29.3644", "Africa/Bujumbura"),
("425551", "Muramvya", "", "BI", "108", "22", "", "", "", "-3.2682", "29.6079", "Africa/Bujumbura"),
("426272", "Gitega", "Гитеге", "BI", "108", "13", "", "", "", "-3.4264", "29.9308", "Africa/Bujumbura"),
("426700", "Ruyigi", "Руйиги", "BI", "108", "21", "", "", "", "-3.47639", "30.24861", "Africa/Bujumbura"),
("430569", "Ngozi", "Нгози", "BI", "108", "19", "", "", "", "-2.9075", "29.8306", "Africa/Bujumbura"),
("430952", "Kayanza", "", "BI", "108", "15", "", "", "", "-2.9221", "29.6293", "Africa/Bujumbura"),
("431748", "Muyinga", "Муйинга", "BI", "108", "18", "", "", "", "-2.8451", "30.3414", "Africa/Bujumbura"),
("433635", "Rutana", "Рутана", "BI", "108", "20", "", "", "", "-3.9279", "29.992", "Africa/Bujumbura"),
("2391377", "Tchaourou", "", "BJ", "204", "10", "", "", "", "8.88649", "2.59752", "Africa/Porto-Novo"),
("2391455", "Tanguieta", "", "BJ", "204", "08", "", "", "", "10.62118", "1.26651", "Africa/Porto-Novo"),
("2391893", "Save", "", "BJ", "204", "11", "", "", "", "8.03424", "2.4866", "Africa/Porto-Novo"),
("2391895", "Savalou", "", "BJ", "204", "11", "", "", "", "7.92807", "1.97558", "Africa/Porto-Novo"),
("2392009", "Sakete", "", "BJ", "204", "17", "", "", "", "6.73618", "2.65866", "Africa/Porto-Novo"),
("2392087", "Porto-Novo", "Порто-Ново", "BJ", "204", "16", "", "", "", "6.49646", "2.60359", "Africa/Porto-Novo"),
("2392108", "Pobe", "", "BJ", "204", "17", "", "", "", "6.98008", "2.6649", "Africa/Porto-Novo"),
("2392204", "Parakou", "Параку", "BJ", "204", "10", "", "", "", "9.33716", "2.63031", "Africa/Porto-Novo"),
("2392308", "Ouidah", "Виды", "BJ", "204", "09", "", "", "", "6.36307", "2.08506", "Africa/Porto-Novo"),
("2392505", "Nikki", "Никки", "BJ", "204", "10", "", "", "", "9.94009", "3.21075", "Africa/Porto-Novo"),
("2392601", "Natitingou", "Натитингу", "BJ", "204", "08", "", "", "", "10.30416", "1.37962", "Africa/Porto-Novo"),
("2392837", "Malanville", "Маланвилем", "BJ", "204", "08", "", "", "", "11.86819", "3.38327", "Africa/Porto-Novo"),
("2392897", "Lokossa", "", "BJ", "204", "15", "", "", "", "6.63869", "1.71674", "Africa/Porto-Novo"),
("2393551", "Ketou", "", "BJ", "204", "17", "", "", "", "7.36332", "2.59978", "Africa/Porto-Novo"),
("2393693", "Kandi", "Канди", "BJ", "204", "07", "", "", "", "11.13417", "2.93861", "Africa/Porto-Novo"),
("2394545", "Dogbo", "", "BJ", "204", "12", "", "", "", "6.81667", "1.78333", "Africa/Porto-Novo"),
("2394560", "Djougou", "", "BJ", "204", "13", "", "", "", "9.70853", "1.66598", "Africa/Porto-Novo"),
("2394711", "Dassa-Zoume", "", "BJ", "204", "11", "", "", "", "7.75", "2.18333", "Africa/Porto-Novo"),
("2394814", "Cove", "", "BJ", "204", "18", "", "", "", "7.22097", "2.34017", "Africa/Porto-Novo"),
("2394819", "Cotonou", "Котону", "BJ", "204", "14", "", "", "", "6.36536", "2.41833", "Africa/Porto-Novo"),
("2394824", "Come", "", "BJ", "204", "15", "", "", "", "6.40764", "1.88198", "Africa/Porto-Novo"),
("2395049", "Bohicon", "", "BJ", "204", "18", "", "", "", "7.17826", "2.0667", "Africa/Porto-Novo"),
("2395182", "Bembereke", "", "BJ", "204", "10", "", "", "", "10.22827", "2.66335", "Africa/Porto-Novo"),
("2395261", "Bassila", "", "BJ", "204", "13", "", "", "", "9.00814", "1.6654", "Africa/Porto-Novo"),
("2395317", "Banikoara", "", "BJ", "204", "07", "", "", "", "11.29845", "2.43856", "Africa/Porto-Novo"),
("2395568", "Aplahoue", "", "BJ", "204", "12", "", "", "", "6.93333", "1.68333", "Africa/Porto-Novo"),
("2395635", "Allada", "", "BJ", "204", "09", "", "", "", "6.66547", "2.15138", "Africa/Porto-Novo"),
("2395914", "Abomey-Calavi", "Абомей-Калави", "BJ", "204", "09", "", "", "", "6.44852", "2.35566", "Africa/Porto-Novo"),
("2395915", "Abomey", "Абомей", "BJ", "204", "18", "", "", "", "7.18286", "1.99119", "Africa/Porto-Novo"),
("3901178", "Yacuiba", "Якуиба", "BO", "68", "09", "", "", "", "-22.03799", "-63.67968", "America/La_Paz"),
("3901301", "Warnes", "", "BO", "68", "08", "", "", "", "-17.5", "-63.16667", "America/La_Paz"),
("3901501", "Villazon", "Вильясон", "BO", "68", "07", "", "", "", "-22.08659", "-65.59422", "America/La_Paz"),
("3901504", "Villa Yapacani", "", "BO", "68", "08", "", "", "", "-17.4", "-63.83333", "America/La_Paz"),
("3901547", "Villamontes", "Вилья-Монтес", "BO", "68", "09", "", "", "", "-21.26236", "-63.46903", "America/La_Paz"),
("3902202", "Tupiza", "", "BO", "68", "07", "", "", "", "-21.44344", "-65.71875", "America/La_Paz"),
("3902377", "Trinidad", "Тринидад", "BO", "68", "03", "", "", "", "-14.83333", "-64.9", "America/La_Paz"),
("3903320", "Tarija", "Тариха", "BO", "68", "09", "", "", "", "-21.53549", "-64.72956", "America/La_Paz"),
("3903987", "Sucre", "Сукре", "BO", "68", "01", "", "", "", "-19.03332", "-65.26274", "America/La_Paz"),
("3904666", "Santiago del Torno", "", "BO", "68", "08", "", "", "", "-17.98674", "-63.38118", "America/La_Paz"),
("3904906", "Santa Cruz de la Sierra", "Санта-Крус-де-ла-Сиерра", "BO", "68", "08", "", "", "", "-17.78629", "-63.18117", "America/La_Paz"),
("3905658", "San Ignacio de Velasco", "", "BO", "68", "08", "", "", "", "-16.36667", "-60.95", "America/La_Paz"),
("3905792", "San Borja", "", "BO", "68", "03", "", "", "", "-14.81667", "-66.85", "America/La_Paz"),
("3906466", "Riberalta", "", "BO", "68", "03", "", "", "", "-11.00654", "-66.06312", "America/La_Paz"),
("3907080", "Punata", "", "BO", "68", "02", "", "", "", "-17.54234", "-65.83472", "America/La_Paz"),
("3907584", "Potosi", "Потоси", "BO", "68", "07", "", "", "", "-19.58361", "-65.75306", "America/La_Paz"),
("3909234", "Oruro", "Оруро", "BO", "68", "05", "", "", "", "-17.98333", "-67.15", "America/La_Paz"),
("3910027", "Montero", "Монтеро", "BO", "68", "08", "", "", "", "-17.33866", "-63.2505", "America/La_Paz"),
("3910291", "Mizque", "", "BO", "68", "02", "", "", "", "-17.94101", "-65.34016", "America/La_Paz"),
("3911409", "Llallagua", "", "BO", "68", "07", "", "", "", "-18.42426", "-66.58388", "America/La_Paz"),
("3911925", "La Paz", "Ла-Пас", "BO", "68", "04", "", "", "", "-16.5", "-68.15", "America/La_Paz"),
("3914839", "Huanuni", "", "BO", "68", "05", "", "", "", "-18.289", "-66.83583", "America/La_Paz"),
("3915350", "Guayaramerin", "", "BO", "68", "03", "", "", "", "-10.83676", "-65.36136", "America/La_Paz"),
("3918937", "Cotoca", "", "BO", "68", "08", "", "", "", "-17.81667", "-63.05", "America/La_Paz"),
("3919968", "Cochabamba", "Кочабамба", "BO", "68", "02", "", "", "", "-17.3895", "-66.1568", "America/La_Paz"),
("3919998", "Cobija", "Кобиха", "BO", "68", "06", "", "", "", "-11.02671", "-68.76918", "America/La_Paz"),
("3922414", "Camiri", "Камири", "BO", "68", "08", "", "", "", "-20.03849", "-63.51833", "America/La_Paz"),
("3384986", "Vitoria do Mearim", "", "BR", "76", "13", "2112902", "", "", "-3.46222", "-44.87056", "America/Fortaleza"),
("3384987", "Vitoria de Santo Antao", "Витория-де-Санту-Антан", "BR", "76", "30", "2616407", "", "", "-8.11806", "-35.29139", "America/Recife"),
("3385022", "Viseu", "", "BR", "76", "16", "1508308", "", "", "-1.19667", "-46.14", "America/Belem"),
("3385077", "Conde", "", "BR", "76", "17", "2504603", "", "", "-7.25972", "-34.9075", "America/Fortaleza"),
("3385088", "Vigia", "", "BR", "76", "16", "1508209", "", "", "-0.85833", "-48.14167", "America/Belem"),
("3385106", "Vicosa do Ceara", "", "BR", "76", "06", "2314102", "", "", "-3.56222", "-41.09222", "America/Fortaleza"),
("3385109", "Vicosa", "", "BR", "76", "02", "2709400", "", "", "-9.37139", "-36.24083", "America/Maceio"),
("3385122", "Viana", "Виана", "BR", "76", "13", "2112803", "", "", "-3.22028", "-45.00361", "America/Fortaleza"),
("3385467", "Varzea Alegre", "", "BR", "76", "06", "2305605", "", "", "-5.35", "-40.38333", "America/Fortaleza"),
("3385504", "Varjota", "", "BR", "76", "06", "2313955", "", "", "-4.19444", "-40.47667", "America/Fortaleza"),
("3385538", "Vargem Grande", "", "BR", "76", "13", "2112704", "", "", "-3.54306", "-43.91583", "America/Fortaleza"),
("3385592", "Valenca do Piaui", "", "BR", "76", "20", "2211308", "", "", "-6.4075", "-41.74556", "America/Fortaleza"),
("3385742", "Uniao dos Palmares", "", "BR", "76", "02", "2709301", "", "", "-9.16278", "-36.03194", "America/Maceio"),
("3385745", "Uniao", "", "BR", "76", "20", "2211100", "", "", "-4.58583", "-42.86417", "America/Fortaleza"),
("3385922", "Tuntum", "", "BR", "76", "13", "2112308", "", "", "-5.25806", "-44.64889", "America/Fortaleza"),
("3385935", "Tucurui", "", "BR", "76", "16", "1508100", "", "", "-3.76611", "-49.6725", "America/Belem"),
("3385980", "Tucuma", "", "BR", "76", "16", "1502509", "", "", "-0.18333", "-50.05", "America/Belem"),
("3386042", "Trindade", "", "BR", "76", "30", "2615607", "", "", "-7.76194", "-40.26778", "America/Recife"),
("3386177", "Trairi", "", "BR", "76", "06", "2313500", "", "", "-3.27778", "-39.26889", "America/Fortaleza"),
("3386264", "Toritama", "Торитама", "BR", "76", "30", "2615409", "", "", "-8.00667", "-36.05667", "America/Recife"),
("3386279", "Tome Acu", "", "BR", "76", "16", "1508001", "", "", "-2.41889", "-48.15222", "America/Belem"),
("3386361", "Timon", "Тимон", "BR", "76", "13", "2112209", "", "", "-5.09417", "-42.83667", "America/Fortaleza"),
("3386372", "Timbiras", "", "BR", "76", "13", "2112100", "", "", "-4.25528", "-43.94056", "America/Fortaleza"),
("3386396", "Timbauba", "", "BR", "76", "30", "2615300", "", "", "-7.50528", "-35.31833", "America/Recife"),
("3386449", "Tiangua", "", "BR", "76", "06", "2313401", "", "", "-3.73222", "-40.99167", "America/Fortaleza"),
("3386496", "Teresina", "Терезина", "BR", "76", "20", "2211001", "", "", "-5.08917", "-42.80194", "America/Fortaleza"),
("3386567", "Sao Joao dos Inhamuns", "", "BR", "76", "06", "2313302", "", "", "-6", "-40.28333", "America/Fortaleza"),
("3386931", "Tamandare", "", "BR", "76", "30", "2614857", "", "", "-8.75632", "-35.09995", "America/Recife"),
("3387082", "Tabira", "", "BR", "76", "30", "2614600", "", "", "-7.59083", "-37.53944", "America/Recife"),
("3387115", "Surubim", "", "BR", "76", "30", "2614501", "", "", "-7.83306", "-35.75472", "America/Recife"),
("3387202", "Sousa", "", "BR", "76", "17", "2516201", "", "", "-6.75917", "-38.22806", "America/Fortaleza"),
("3387204", "Soure", "", "BR", "76", "16", "1507904", "", "", "-0.71667", "-48.52333", "America/Belem"),
("3387266", "Solanea", "", "BR", "76", "17", "2501500", "", "", "-6.755", "-35.54", "America/Fortaleza"),
("3387296", "Sobral", "Собрал", "BR", "76", "06", "2312908", "", "", "-3.68611", "-40.34972", "America/Fortaleza"),
("3387604", "Sirinhaem", "", "BR", "76", "30", "2614204", "", "", "-8.59083", "-35.11611", "America/Recife"),
("3387663", "Sertania", "", "BR", "76", "30", "2614105", "", "", "-8.07361", "-37.26444", "America/Recife"),
("3387786", "Serra Talhada", "", "BR", "76", "30", "2613909", "", "", "-7.99194", "-38.29833", "America/Recife"),
("3387926", "Senador Pompeu", "", "BR", "76", "06", "2312700", "", "", "-5.58806", "-39.37167", "America/Fortaleza"),
("3387987", "Satuba", "", "BR", "76", "02", "2708907", "", "", "-9.56333", "-35.82444", "America/Maceio"),
("3388145", "Sao Raimundo Nonato", "", "BR", "76", "20", "2210607", "", "", "-9.01528", "-42.69944", "America/Fortaleza"),
("3388269", "Sao Miguel dos Campos", "Сан-Мигель-дус-Кампус", "BR", "76", "02", "2708600", "", "", "-9.78111", "-36.09361", "America/Maceio"),
("3388270", "Sao Miguel do Guama", "", "BR", "76", "16", "1507607", "", "", "-1.62667", "-47.48333", "America/Belem"),
("3388318", "Sao Mateus do Maranhao", "", "BR", "76", "13", "2111508", "", "", "-4.04167", "-44.475", "America/Fortaleza"),
("3388341", "Sao Luis do Quitunde", "", "BR", "76", "02", "2708501", "", "", "-9.31833", "-35.56111", "America/Maceio"),
("3388368", "Sao Luis", "Сан-Луис", "BR", "76", "13", "2111300", "", "", "-2.52972", "-44.30278", "America/Fortaleza"),
("3388376", "Sao Lourenco da Mata", "Сан-Лоренсу-да-Мата", "BR", "76", "30", "2613701", "", "", "-8.00222", "-35.01833", "America/Recife"),
("3388435", "Sao Jose do Egito", "", "BR", "76", "30", "2613602", "", "", "-7.47889", "-37.27444", "America/Recife"),
("3388441", "Sao Jose de Ribamar", "", "BR", "76", "13", "2111201", "", "", "-2.56194", "-44.05417", "America/Fortaleza"),
("3388443", "Sao Jose de Mipibu", "", "BR", "76", "22", "2412203", "", "", "-6.07472", "-35.23778", "America/Fortaleza"),
("3388615", "Sao Joao dos Patos", "", "BR", "76", "13", "2111102", "", "", "-6.495", "-43.70222", "America/Fortaleza"),
("3388714", "Sao Goncalo do Amarante", "", "BR", "76", "06", "2312403", "", "", "-3.60722", "-38.96833", "America/Fortaleza"),
("3388847", "Sao Felix do Xingu", "", "BR", "76", "16", "1507300", "", "", "-6.64472", "-51.995", "America/Belem"),
("3388868", "Sao Domingos do Maranhao", "", "BR", "76", "13", "2110708", "", "", "-5.57583", "-44.38528", "America/Fortaleza"),
("3388991", "Sao Bento", "", "BR", "76", "17", "2504306", "", "", "-6.28333", "-37.75", "America/Fortaleza"),
("3389006", "Sao Bento", "Сан-Бенту", "BR", "76", "13", "2110500", "", "", "-2.69583", "-44.82139", "America/Fortaleza"),
("3389321", "Santa Rita", "", "BR", "76", "17", "2513703", "", "", "-7.11389", "-34.97806", "America/Fortaleza"),
("3389353", "Santarem", "Сантарен", "BR", "76", "16", "1506807", "", "", "-2.44306", "-54.70833", "America/Santarem"),
("3389358", "Santa Quiteria do Maranhao", "", "BR", "76", "13", "2110104", "", "", "-3.51556", "-42.54667", "America/Fortaleza"),
("3389361", "Santa Quiteria", "", "BR", "76", "06", "2312205", "", "", "-4.33194", "-40.15667", "America/Fortaleza"),
("3389384", "Santana do Ipanema", "Сантана-ду-Ипанема", "BR", "76", "02", "2708006", "", "", "-9.37833", "-37.24528", "America/Maceio"),
("3389557", "Santa Luzia", "", "BR", "76", "13", "2109502", "", "", "-7.64265", "-47.21738", "America/Fortaleza"),
("3389609", "Santa Ines", "Санта-Инес", "BR", "76", "13", "2109908", "", "", "-3.66667", "-45.38", "America/Fortaleza"),
("3389622", "Santa Helena", "", "BR", "76", "13", "2109809", "", "", "-2.23111", "-45.3", "America/Fortaleza"),
("3389652", "Santa Cruz do Capibaribe", "", "BR", "76", "30", "2612505", "", "", "-7.9575", "-36.20472", "America/Recife"),
("3389673", "Santa Cruz", "", "BR", "76", "22", "2411205", "", "", "-6.22944", "-36.02278", "America/Fortaleza"),
("3389822", "Salinopolis", "", "BR", "76", "16", "1506203", "", "", "-0.61361", "-47.35611", "America/Belem"),
("3389860", "Salgueiro", "Салгейру", "BR", "76", "30", "2612208", "", "", "-8.07417", "-39.11917", "America/Recife"),
("3390160", "Russas", "", "BR", "76", "06", "2311801", "", "", "-4.94028", "-37.97583", "America/Fortaleza"),
("3390288", "Rio Largo", "", "BR", "76", "02", "2707701", "", "", "-9.47833", "-35.85333", "America/Maceio"),
("3390295", "Rio Formoso", "", "BR", "76", "30", "2611903", "", "", "-8.66877", "-35.16277", "America/Recife"),
("3390326", "Ribeirao", "", "BR", "76", "30", "2611804", "", "", "-8.51444", "-35.37778", "America/Recife"),
("3390760", "Recife", "Ресифи", "BR", "76", "30", "2611606", "", "", "-8.05389", "-34.88111", "America/Recife"),
("3390901", "Quixeramobim", "", "BR", "76", "06", "2311405", "", "", "-5.19917", "-39.29278", "America/Fortaleza"),
("3390907", "Quixada", "", "BR", "76", "06", "2311306", "", "", "-4.97139", "-39.01528", "America/Fortaleza"),
("3391220", "Presidente Dutra", "", "BR", "76", "13", "2109106", "", "", "-5.29", "-44.49", "America/Fortaleza"),
("3391360", "Santana", "Сантана", "BR", "76", "03", "1600600", "", "", "-0.05833", "-51.18167", "America/Belem"),
("3391397", "Porto Calvo", "", "BR", "76", "02", "2707305", "", "", "-9.045", "-35.39833", "America/Maceio"),
("3391412", "Portel", "", "BR", "76", "16", "1505809", "", "", "-1.93556", "-50.82111", "America/Belem"),
("3391556", "Pombos", "", "BR", "76", "30", "2611309", "", "", "-8.14139", "-35.39583", "America/Recife"),
("3391571", "Pombal", "", "BR", "76", "17", "2512101", "", "", "-6.77028", "-37.80167", "America/Fortaleza"),
("3391908", "Piripiri", "", "BR", "76", "20", "2208403", "", "", "-4.27333", "-41.77694", "America/Fortaleza"),
("3391991", "Piracuruca", "", "BR", "76", "20", "2208304", "", "", "-3.92806", "-41.70917", "America/Fortaleza"),
("3392054", "Pinheiro", "Пиньейру", "BR", "76", "13", "2108603", "", "", "-2.52139", "-45.0825", "America/Fortaleza"),
("3392088", "Pindare Mirim", "", "BR", "76", "13", "2108504", "", "", "-3.60833", "-45.34333", "America/Fortaleza"),
("3392126", "Pilar", "Пилар", "BR", "76", "02", "2706901", "", "", "-9.59722", "-35.95667", "America/Maceio"),
("3392167", "Picos", "Пикус", "BR", "76", "20", "2208007", "", "", "-7.07694", "-41.46694", "America/Fortaleza"),
("3392242", "Petrolina", "Петролина", "BR", "76", "30", "2611101", "", "", "-9.39861", "-40.50083", "America/Recife"),
("3392243", "Jatoba", "Ятоба", "BR", "76", "30", "2608057", "", "", "-9.18306", "-38.26889", "America/Recife"),
("3392251", "Pesqueira", "", "BR", "76", "30", "2610905", "", "", "-8.35778", "-36.69639", "America/Recife"),
("3392345", "Pentecoste", "", "BR", "76", "06", "2310704", "", "", "-3.79278", "-39.27028", "America/Fortaleza"),
("3392368", "Penalva", "", "BR", "76", "13", "2108306", "", "", "-3.29417", "-45.17361", "America/Fortaleza"),
("3392431", "Pedro II", "", "BR", "76", "20", "2207900", "", "", "-4.42472", "-41.45861", "America/Fortaleza"),
("3392629", "Pedra Branca", "Педра-Бранка", "BR", "76", "06", "2310506", "", "", "-5.45417", "-39.71722", "America/Fortaleza"),
("3392734", "Paulo Afonso", "", "BR", "76", "05", "2924009", "", "", "-9.40611", "-38.21472", "America/Bahia"),
("3392740", "Paulista", "", "BR", "76", "30", "2610707", "", "", "-7.94083", "-34.87306", "America/Recife"),
("3392887", "Patos", "Патус", "BR", "76", "17", "2510808", "", "", "-7.02444", "-37.28", "America/Fortaleza"),
("3392998", "Parnamirim", "Парнамирин", "BR", "76", "22", "2403251", "", "", "-5.91556", "-35.26278", "America/Fortaleza"),
("3393001", "Parnaiba", "Парнаиба", "BR", "76", "20", "2207702", "", "", "-2.90472", "-41.77667", "America/Fortaleza"),
("3393008", "Parintins", "Паринтинса", "BR", "76", "04", "1303403", "", "", "-2.62833", "-56.73583", "America/Manaus"),
("3393017", "Parelhas", "", "BR", "76", "22", "2408904", "", "", "-6.68778", "-36.6575", "America/Fortaleza"),
("3393091", "Paraipaba", "", "BR", "76", "06", "2310258", "", "", "-3.43944", "-39.14833", "America/Fortaleza"),
("3393106", "Paragominas", "", "BR", "76", "16", "1505502", "", "", "-2.96667", "-47.48333", "America/Belem"),
("3393115", "Paracuru", "", "BR", "76", "06", "2310209", "", "", "-3.41", "-39.03056", "America/Fortaleza"),
("3393264", "Palmares", "", "BR", "76", "30", "2610004", "", "", "-8.68333", "-35.59167", "America/Recife"),
("3393400", "Pacatuba", "", "BR", "76", "06", "2309706", "", "", "-3.98417", "-38.62028", "America/Fortaleza"),
("3393409", "Pacajus", "", "BR", "76", "06", "2309607", "", "", "-4.1725", "-38.46056", "America/Fortaleza"),
("3393452", "Ouricuri", "", "BR", "76", "30", "2609907", "", "", "-7.8825", "-40.08167", "America/Recife"),
("3393465", "Oros", "", "BR", "76", "06", "2309508", "", "", "-6.24444", "-38.91361", "America/Fortaleza"),
("3393471", "Oriximina", "", "BR", "76", "16", "1505304", "", "", "-1.76556", "-55.86611", "America/Santarem"),
("3393536", "Olinda", "Олинда", "BR", "76", "30", "2609600", "", "", "-8.00889", "-34.85528", "America/Recife"),
("3393764", "Oeiras", "", "BR", "76", "20", "2207009", "", "", "-7.02528", "-42.13111", "America/Fortaleza"),
("3393768", "Abidos", "", "BR", "76", "16", "1505106", "", "", "-1.9175", "-55.51806", "America/Santarem"),
("3393832", "Nova Russas", "", "BR", "76", "06", "2309300", "", "", "-4.70667", "-40.56306", "America/Fortaleza"),
("3393876", "Nova Cruz", "", "BR", "76", "22", "2408300", "", "", "-6.47806", "-35.43389", "America/Fortaleza"),
("3393972", "Nazare da Mata", "Назар-да-Мата", "BR", "76", "30", "2609501", "", "", "-7.74167", "-35.22778", "America/Recife"),
("3394023", "Natal", "Натал", "BR", "76", "22", "2408102", "", "", "-5.795", "-35.20944", "America/Fortaleza"),
("3394116", "Murici", "", "BR", "76", "02", "2705507", "", "", "-9.30667", "-35.94333", "America/Maceio"),
("3394453", "Moreno", "", "BR", "76", "30", "2609402", "", "", "-8.11861", "-35.09222", "America/Recife"),
("3394500", "Morada Nova", "", "BR", "76", "06", "2308708", "", "", "-5.10667", "-38.3725", "America/Fortaleza"),
("3394549", "Monteiro", "", "BR", "76", "17", "2509701", "", "", "-7.88944", "-37.12", "America/Fortaleza"),
("3394605", "Monte Alegre", "Монти-Алегри", "BR", "76", "16", "1504802", "", "", "-2.00082", "-54.08102", "America/Santarem"),
("3394649", "Mombaca", "", "BR", "76", "06", "2308500", "", "", "-5.74306", "-39.6275", "America/Fortaleza"),
("3394661", "Moju", "", "BR", "76", "16", "1504703", "", "", "-1.88389", "-48.76889", "America/Belem"),
("3394682", "Mossoro", "Мосоро", "BR", "76", "22", "2408003", "", "", "-5.1875", "-37.34417", "America/Fortaleza"),
("3394745", "Mocajuba", "", "BR", "76", "16", "1504604", "", "", "-2.58417", "-49.50722", "America/Belem"),
("3395062", "Maues", "", "BR", "76", "04", "1302900", "", "", "-3.38361", "-57.71861", "America/Manaus"),
("3395077", "Matriz de Camaragibe", "", "BR", "76", "02", "2705101", "", "", "-9.15167", "-35.53333", "America/Maceio"),
("3395380", "Mari", "", "BR", "76", "17", "2509107", "", "", "-7.06", "-35.31944", "America/Fortaleza"),
("3395395", "Marechal Deodoro", "", "BR", "76", "02", "2704708", "", "", "-9.71028", "-35.895", "America/Maceio"),
("3395458", "Maragogi", "", "BR", "76", "02", "2704500", "", "", "-9.01222", "-35.2225", "America/Maceio"),
("3395473", "Maracanau", "", "BR", "76", "06", "2307650", "", "", "-3.87667", "-38.62556", "America/Fortaleza"),
("3395503", "Maraba", "Мараба", "BR", "76", "16", "1504208", "", "", "-5.36861", "-49.11778", "America/Belem"),
("3395717", "Mamanguape", "", "BR", "76", "17", "2508901", "", "", "-6.83861", "-35.12611", "America/Fortaleza"),
("3395981", "Maceio", "Масейо", "BR", "76", "02", "2704302", "", "", "-9.66583", "-35.73528", "America/Maceio"),
("3395998", "Macau", "", "BR", "76", "22", "2407203", "", "", "-5.115", "-36.63444", "America/Fortaleza"),
("3396016", "Macapa", "Макапа", "BR", "76", "03", "1600303", "", "", "0.03889", "-51.06639", "America/Belem"),
("3396048", "Macaiba", "", "BR", "76", "22", "2407104", "", "", "-5.85833", "-35.35389", "America/Fortaleza"),
("3396266", "Limoeiro do Norte", "", "BR", "76", "06", "2307601", "", "", "-5.14556", "-38.09806", "America/Fortaleza"),
("3396277", "Limoeiro", "", "BR", "76", "30", "2608909", "", "", "-7.87472", "-35.45028", "America/Recife"),
("3396364", "Lavras da Mangabeira", "", "BR", "76", "06", "2307502", "", "", "-6.75333", "-38.96444", "America/Fortaleza"),
("3396496", "Lajedo", "Лажеду", "BR", "76", "30", "2608800", "", "", "-8.66361", "-36.32", "America/Recife"),
("3396601", "Lago da Pedra", "Лаго-да-Педра", "BR", "76", "13", "2113009", "", "", "-4.28674", "-45.23824", "America/Fortaleza"),
("3396769", "Lagoa do Itaenga", "", "BR", "76", "30", "2608503", "", "", "-7.93611", "-35.29028", "America/Recife"),
("3397147", "Juazeiro do Norte", "Жуазейру-ду-Норти", "BR", "76", "06", "2307304", "", "", "-7.21306", "-39.31528", "America/Fortaleza"),
("3397230", "Jose de Freitas", "", "BR", "76", "20", "2205508", "", "", "-4.75639", "-42.57556", "America/Fortaleza"),
("3397277", "Joao Pessoa", "Жуан-Песоа", "BR", "76", "17", "2507507", "", "", "-7.115", "-34.86306", "America/Fortaleza"),
("3397315", "Joao Camara", "", "BR", "76", "22", "2405801", "", "", "-5.5375", "-35.81972", "America/Fortaleza"),
("3397665", "Jaguaruana", "", "BR", "76", "06", "2307007", "", "", "-4.83389", "-37.78111", "America/Fortaleza"),
("3397675", "Jaguaribe", "Жагуариби", "BR", "76", "06", "2306900", "", "", "-5.89056", "-38.62194", "America/Fortaleza"),
("3397838", "Jaboatao", "", "BR", "76", "30", "2607901", "", "", "-8.18028", "-35.00139", "America/Recife"),
("3397851", "Itupiranga", "", "BR", "76", "16", "1503705", "", "", "-5.13472", "-49.32667", "America/Belem"),
("3397893", "Itacoatiara", "", "BR", "76", "04", "1301902", "", "", "-3.14306", "-58.44417", "America/Manaus"),
("3397898", "Itaporanga", "", "BR", "76", "17", "2507002", "", "", "-7.30444", "-38.15028", "America/Fortaleza"),
("3397904", "Itapissuma", "", "BR", "76", "30", "2607752", "", "", "-7.77639", "-34.89222", "America/Recife"),
("3397909", "Itapipoca", "Итапипока", "BR", "76", "06", "2306405", "", "", "-3.49444", "-39.57861", "America/Fortaleza"),
("3397936", "Itapecuru Mirim", "", "BR", "76", "13", "2105401", "", "", "-3.3925", "-44.35861", "America/Fortaleza"),
("3397941", "Itapage", "", "BR", "76", "06", "2306306", "", "", "-3.68667", "-39.58611", "America/Fortaleza"),
("3397967", "Itaituba", "", "BR", "76", "16", "1503606", "", "", "-4.27611", "-55.98361", "America/Santarem"),
("3397969", "Itaitinga", "", "BR", "76", "06", "2306256", "", "", "-3.96944", "-38.52806", "America/Fortaleza"),
("3398003", "Itabaiana", "", "BR", "76", "17", "2506905", "", "", "-7.32861", "-35.3325", "America/Fortaleza"),
("3398076", "Ipueiras", "", "BR", "76", "06", "", "", "", "-7.03333", "-40.45", "America/Fortaleza"),
("3398105", "Ipubi", "", "BR", "76", "30", "2607307", "", "", "-7.65194", "-40.14889", "America/Recife"),
("3398112", "Ipu", "", "BR", "76", "06", "2305803", "", "", "-4.32222", "-40.71083", "America/Fortaleza"),
("3398115", "Ipojuca", "Ипожука", "BR", "76", "30", "2607208", "", "", "-8.39889", "-35.06389", "America/Recife"),
("3398269", "Imperatriz", "Императрис", "BR", "76", "13", "2105302", "", "", "-5.52639", "-47.49167", "America/Fortaleza"),
("3398331", "Iguatu", "", "BR", "76", "06", "2305506", "", "", "-6.35944", "-39.29861", "America/Fortaleza"),
("3398343", "Igarape Miri", "", "BR", "76", "16", "1503309", "", "", "-1.975", "-48.95972", "America/Belem"),
("3398350", "Igarape Acu", "", "BR", "76", "16", "1503200", "", "", "-1.12889", "-47.62", "America/Belem"),
("3398352", "Igarassu", "", "BR", "76", "30", "2606804", "", "", "-7.83417", "-34.90639", "America/Recife"),
("3398379", "Ico", "", "BR", "76", "06", "2305407", "", "", "-6.40111", "-38.86222", "America/Fortaleza"),
("3398450", "Horizonte", "", "BR", "76", "06", "2305233", "", "", "-4.1", "-38.48333", "America/Fortaleza"),
("3398569", "Guaraciaba do Norte", "", "BR", "76", "06", "2305001", "", "", "-4.16694", "-40.7475", "America/Fortaleza"),
("3398570", "Guarabira", "", "BR", "76", "17", "2506301", "", "", "-6.85472", "-35.49", "America/Fortaleza"),
("3398614", "Guaiuba", "", "BR", "76", "06", "2304954", "", "", "-4.03972", "-38.63722", "America/Fortaleza"),
("3398691", "Gravata", "", "BR", "76", "30", "2606408", "", "", "-8.20111", "-35.56472", "America/Recife"),
("3398706", "Granja", "", "BR", "76", "06", "2304707", "", "", "-3.12028", "-40.82611", "America/Fortaleza"),
("3398856", "Grajau", "", "BR", "76", "13", "2104800", "", "", "-5.81944", "-46.13861", "America/Fortaleza"),
("3398904", "Goiana", "Гояна", "BR", "76", "30", "2606200", "", "", "-7.56056", "-35.0025", "America/Recife"),
("3398920", "Gloria do Goita", "", "BR", "76", "30", "2606101", "", "", "-8.00167", "-35.29278", "America/Recife"),
("3399058", "Garanhuns", "Гараньюнс", "BR", "76", "30", "", "", "", "-8.88202", "-36.50216", "America/Recife"),
("3399132", "Gameleira", "", "BR", "76", "30", "2605905", "", "", "-8.58444", "-35.38667", "America/Recife"),
("3399415", "Fortaleza", "Форталеза", "BR", "76", "06", "2304400", "", "", "-3.71722", "-38.54306", "America/Fortaleza"),
("3399506", "Floriano", "Флориан", "BR", "76", "20", "2203909", "", "", "-6.76694", "-43.0225", "America/Fortaleza"),
("3399518", "Floresta", "", "BR", "76", "30", "2605707", "", "", "-8.60111", "-38.56861", "America/Recife"),
("3400558", "Eusebio", "Эусебио", "BR", "76", "06", "2304285", "", "", "-3.89", "-38.45056", "America/Fortaleza"),
("3400567", "Extremoz", "Эстремос", "BR", "76", "22", "2403608", "", "", "-5.70556", "-35.30722", "America/Fortaleza"),
("3400617", "Estreito", "", "BR", "76", "13", "2107803", "", "", "-5.78333", "-43.25", "America/Fortaleza"),
("3400740", "Esperantina", "", "BR", "76", "20", "2203701", "", "", "-3.90167", "-42.23361", "America/Fortaleza"),
("3400752", "Esperanca", "", "BR", "76", "17", "2506004", "", "", "-7.03306", "-35.85722", "America/Fortaleza"),
("3400804", "Escada", "", "BR", "76", "30", "2605202", "", "", "-8.35917", "-35.22361", "America/Recife"),
("3400969", "Dom Pedro", "", "BR", "76", "13", "2106003", "", "", "-5.0375", "-44.43857", "America/Fortaleza"),
("3401106", "Demerval Lobao", "", "BR", "76", "20", "2203305", "", "", "-5.35833", "-42.67639", "America/Fortaleza"),
("3401109", "Delmiro Gouveia", "", "BR", "76", "02", "2702405", "", "", "-9.38861", "-37.99917", "America/Maceio"),
("3401138", "Custodia", "", "BR", "76", "30", "2605103", "", "", "-8.0875", "-37.64306", "America/Recife"),
("3401148", "Cururupu", "", "BR", "76", "13", "2103703", "", "", "-1.82833", "-44.86833", "America/Fortaleza"),
("3401283", "Currais Novos", "Куррайс-Новус", "BR", "76", "22", "2403103", "", "", "-6.26083", "-36.51778", "America/Fortaleza"),
("3401340", "Cupira", "", "BR", "76", "30", "2605004", "", "", "-8.61667", "-35.95", "America/Recife"),
("3401545", "Crato", "Крату", "BR", "76", "06", "2304202", "", "", "-7.23417", "-39.40944", "America/Fortaleza"),
("3401548", "Crateus", "", "BR", "76", "06", "2304103", "", "", "-5.17833", "-40.6775", "America/Fortaleza"),
("3401703", "Coroata", "", "BR", "76", "13", "2103604", "", "", "-4.13", "-44.12417", "America/Fortaleza"),
("3401830", "Condado", "", "BR", "76", "30", "2604601", "", "", "-7.58583", "-35.10583", "America/Recife"),
("3401845", "Conceicao do Araguaia", "", "BR", "76", "16", "1502707", "", "", "-8.25778", "-49.26472", "America/Araguaina"),
("3401963", "Colinas", "Колинас", "BR", "76", "13", "2103505", "", "", "-6.02583", "-44.24917", "America/Fortaleza"),
("3401992", "Coelho Neto", "", "BR", "76", "13", "2103406", "", "", "-4.25667", "-43.01278", "America/Fortaleza"),
("3402000", "Codo", "", "BR", "76", "13", "2103307", "", "", "-4.45528", "-43.88556", "America/Fortaleza"),
("3402229", "Chapadinha", "", "BR", "76", "13", "2103208", "", "", "-3.74167", "-43.36028", "America/Fortaleza"),
("3402271", "Cha Grande", "", "BR", "76", "30", "2604502", "", "", "-8.23833", "-35.46167", "America/Recife"),
("3402360", "Ceara Mirim", "", "BR", "76", "22", "2402600", "", "", "-5.63444", "-35.42556", "America/Fortaleza"),
("3402383", "Caxias", "", "BR", "76", "13", "2103000", "", "", "-4.85889", "-43.35611", "America/Fortaleza"),
("3402429", "Caucaia", "", "BR", "76", "06", "2303709", "", "", "-3.73611", "-38.65306", "America/Fortaleza"),
("3402465", "Catole do Rocha", "", "BR", "76", "17", "2504306", "", "", "-6.34389", "-37.74667", "America/Fortaleza"),
("3402528", "Catende", "", "BR", "76", "30", "2604205", "", "", "-8.66667", "-35.71667", "America/Recife"),
("3402591", "Castanhal", "", "BR", "76", "16", "1502400", "", "", "-1.29389", "-47.92639", "America/Belem"),
("3402613", "Cascavel", "", "BR", "76", "06", "2303501", "", "", "-4.13306", "-38.24194", "America/Fortaleza"),
("3402655", "Caruaru", "Каруару", "BR", "76", "30", "2604106", "", "", "-8.28333", "-35.97611", "America/Recife"),
("3402721", "Carpina", "Карпина", "BR", "76", "30", "2604007", "", "", "-7.85083", "-35.25472", "America/Recife"),
("3402724", "Carolina", "Каролина", "BR", "76", "13", "2102804", "", "", "-7.33561", "-47.46218", "America/Fortaleza"),
("3403127", "Capitao Poco", "", "BR", "76", "16", "1502301", "", "", "-1.74639", "-47.05944", "America/Belem"),
("3403208", "Capanema", "", "BR", "76", "16", "1502202", "", "", "-1.19583", "-47.18083", "America/Belem"),
("3403353", "Caninde", "", "BR", "76", "06", "2302800", "", "", "-4.35889", "-39.31167", "America/Fortaleza"),
("3403362", "Canguaretama", "Кангуаретама", "BR", "76", "22", "2402204", "", "", "-6.38", "-35.12889", "America/Fortaleza"),
("3403534", "Campos Sales", "", "BR", "76", "06", "2302701", "", "", "-7.07444", "-40.37611", "America/Fortaleza"),
("3403566", "Campo Maior", "", "BR", "76", "20", "2202208", "", "", "-4.82778", "-42.16861", "America/Fortaleza"),
("3403611", "Campo Alegre", "", "BR", "76", "02", "2701407", "", "", "-9.78194", "-36.35083", "America/Maceio"),
("3403642", "Campina Grande", "Кампина-Гранде", "BR", "76", "17", "2504009", "", "", "-7.23056", "-35.88111", "America/Fortaleza"),
("3403687", "Camocim", "", "BR", "76", "06", "2302602", "", "", "-2.90222", "-40.84111", "America/Fortaleza"),
("3403697", "Cameta", "", "BR", "76", "16", "1502103", "", "", "-2.24444", "-49.49583", "America/Belem"),
("3403941", "Cajueiro", "", "BR", "76", "02", "2704203", "", "", "-9.71667", "-36.45", "America/Maceio"),
("3404020", "Cajazeiras", "Кажазейрас", "BR", "76", "17", "2503704", "", "", "-6.89028", "-38.55528", "America/Fortaleza"),
("3404117", "Caico", "Кайко", "BR", "76", "22", "2402006", "", "", "-6.45833", "-37.09778", "America/Fortaleza"),
("3404513", "Cabrobo", "", "BR", "76", "30", "2603009", "", "", "-8.51417", "-39.31", "America/Recife"),
("3404545", "Cabo", "", "BR", "76", "30", "2602902", "", "", "-8.28333", "-35.03333", "America/Recife"),
("3404558", "Cabedelo", "", "BR", "76", "17", "2503209", "", "", "-6.98111", "-34.83389", "America/Fortaleza"),
("3404722", "Buriti Bravo", "", "BR", "76", "13", "2102309", "", "", "-5.83722", "-43.83361", "America/Fortaleza"),
("3404766", "Buique", "Буики", "BR", "76", "30", "2602803", "", "", "-8.62306", "-37.15583", "America/Recife"),
("3404817", "Breves", "", "BR", "76", "16", "1501808", "", "", "-1.68222", "-50.48028", "America/Belem"),
("3404833", "Brejo Santo", "", "BR", "76", "06", "2302503", "", "", "-7.49333", "-38.98722", "America/Fortaleza"),
("3404862", "Brejo da Madre de Deus", "", "BR", "76", "30", "2602605", "", "", "-8.14583", "-36.37111", "America/Recife"),
("3405006", "Braganca", "", "BR", "76", "16", "1501709", "", "", "-1.05361", "-46.76556", "America/Belem"),
("3405380", "Bom Conselho", "", "BR", "76", "30", "2602100", "", "", "-9.16972", "-36.67972", "America/Recife"),
("3405616", "Boa Viagem", "", "BR", "76", "06", "2302404", "", "", "-5.1275", "-39.73222", "America/Fortaleza"),
("3405738", "Bezerros", "Безеррус", "BR", "76", "30", "2601904", "", "", "-8.23333", "-35.79694", "America/Recife"),
("3405792", "Benevides", "", "BR", "76", "16", "1501501", "", "", "-1.36139", "-48.24472", "America/Belem"),
("3405812", "Belo Jardim", "", "BR", "76", "30", "2601706", "", "", "-8.33556", "-36.42417", "America/Recife"),
("3405863", "Belem", "Белем", "BR", "76", "17", "2501906", "", "", "-6.69167", "-35.53333", "America/Fortaleza"),
("3405870", "Belem", "Белен", "BR", "76", "16", "1501402", "", "", "-1.45583", "-48.50444", "America/Belem"),
("3405924", "Beberibe", "Беберибе", "BR", "76", "06", "2302206", "", "", "-4.17972", "-38.13056", "America/Fortaleza"),
("3405940", "Bayeux", "", "BR", "76", "17", "2501807", "", "", "-7.125", "-34.93222", "America/Fortaleza"),
("3405954", "Baturite", "", "BR", "76", "06", "2302107", "", "", "-4.32861", "-38.88472", "America/Fortaleza"),
("3406160", "Barreiros", "", "BR", "76", "30", "2601409", "", "", "-8.81833", "-35.18639", "America/Recife"),
("3406196", "Barreirinhas", "", "BR", "76", "13", "2101707", "", "", "-2.75556", "-42.82591", "America/Fortaleza"),
("3406263", "Barras", "Баррас", "BR", "76", "20", "2201200", "", "", "-4.24444", "-42.29444", "America/Fortaleza"),
("3406318", "Barra do Corda", "", "BR", "76", "13", "2101608", "", "", "-5.50308", "-45.23693", "America/Fortaleza"),
("3406429", "Barcarena", "", "BR", "76", "16", "1501303", "", "", "-1.50583", "-48.62583", "America/Belem"),
("3406442", "Barbalha", "", "BR", "76", "06", "2301901", "", "", "-7.31111", "-39.30417", "America/Fortaleza"),
("3406545", "Balsas", "Альтбальсас", "BR", "76", "13", "2101400", "", "", "-7.5325", "-46.03556", "America/Fortaleza"),
("3406910", "Bacabal", "Бакабал", "BR", "76", "13", "2101202", "", "", "-4.29167", "-44.79167", "America/Fortaleza"),
("3406961", "Augusto Correa", "", "BR", "76", "16", "1500909", "", "", "-1.02167", "-46.635", "America/Belem"),
("3406996", "Atalaia", "", "BR", "76", "02", "2700409", "", "", "-9.50194", "-36.02278", "America/Maceio"),
("3407194", "Areia Branca", "", "BR", "76", "22", "2401107", "", "", "-4.95611", "-37.13694", "America/Fortaleza"),
("3407216", "Arcoverde", "Арковерди", "BR", "76", "30", "2601201", "", "", "-8.41889", "-37.05389", "America/Recife"),
("3407243", "Araripina", "Арарипина", "BR", "76", "30", "2601102", "", "", "-7.57611", "-40.49833", "America/Recife"),
("3407258", "Arari", "", "BR", "76", "13", "2101004", "", "", "-3.45361", "-44.78", "America/Fortaleza"),
("3407327", "Arapiraca", "", "BR", "76", "02", "2700300", "", "", "-9.7525", "-36.66111", "America/Maceio"),
("3407357", "Araguaina", "Арагуаина", "BR", "76", "31", "1702109", "", "", "-7.19111", "-48.20722", "America/Araguaina"),
("3407378", "Aracati", "Аракати", "BR", "76", "06", "2301109", "", "", "-4.56167", "-37.76972", "America/Fortaleza"),
("3407407", "Aquiraz", "", "BR", "76", "06", "2301000", "", "", "-3.90139", "-38.39111", "America/Fortaleza"),
("3407440", "Apodi", "", "BR", "76", "22", "2401008", "", "", "-5.66417", "-37.79889", "America/Fortaleza"),
("3407669", "Ananindeua", "Ананиндеуа", "BR", "76", "16", "1500800", "", "", "-1.36556", "-48.37222", "America/Belem"),
("3407758", "Amaraji", "", "BR", "76", "30", "2600906", "", "", "-8.38306", "-35.4525", "America/Recife"),
("3407797", "Altos", "", "BR", "76", "20", "2200400", "", "", "-5.03806", "-42.46", "America/Fortaleza"),
("3407882", "Altamira", "Альтамира", "BR", "76", "16", "1500602", "", "", "-3.20333", "-52.20639", "America/Santarem"),
("3407903", "Almeirim", "Алмейрин", "BR", "76", "16", "1500503", "", "", "-1.52333", "-52.58167", "America/Santarem"),
("3407980", "Alenquer", "", "BR", "76", "16", "1500404", "", "", "-1.94167", "-54.73833", "America/Santarem"),
("3408100", "Alagoa Grande", "", "BR", "76", "17", "2515807", "", "", "-7.15833", "-35.63", "America/Fortaleza"),
("3408166", "Aguas Belas", "", "BR", "76", "30", "2600500", "", "", "-9.11139", "-37.12306", "America/Recife"),
("3408175", "Agua Preta", "", "BR", "76", "30", "2600401", "", "", "-8.7075", "-35.53056", "America/Recife"),
("3408274", "Afogados da Ingazeira", "", "BR", "76", "30", "2600104", "", "", "-7.75083", "-37.63917", "America/Recife"),
("3408337", "Acu", "", "BR", "76", "22", "2400208", "", "", "-5.57667", "-36.90861", "America/Fortaleza"),
("3408343", "Acopiara", "", "BR", "76", "06", "2300309", "", "", "-6.09528", "-39.4525", "America/Fortaleza"),
("3408368", "Acarau", "Акарау", "BR", "76", "06", "2300200", "", "", "-2.88556", "-40.12", "America/Fortaleza"),
("3408404", "Abreu e Lima", "", "BR", "76", "30", "2600054", "", "", "-7.91167", "-34.90278", "America/Recife"),
("3408424", "Abaetetuba", "", "BR", "76", "16", "1500107", "", "", "-1.71806", "-48.8825", "America/Belem"),
("3444823", "Xique Xique", "", "BR", "76", "05", "2933604", "", "", "-10.82167", "-42.73111", "America/Bahia"),
("3444848", "Xanxere", "", "BR", "76", "26", "4219507", "", "", "-26.87694", "-52.40417", "America/Sao_Paulo"),
("3444864", "Votuporanga", "", "BR", "76", "27", "3557105", "", "", "-20.42278", "-49.97278", "America/Sao_Paulo"),
("3444866", "Votorantim", "", "BR", "76", "27", "3557006", "", "", "-23.54667", "-47.43778", "America/Sao_Paulo"),
("3444876", "Volta Redonda", "Волта-Редонда", "BR", "76", "21", "3306305", "", "", "-22.52306", "-44.10417", "America/Sao_Paulo"),
("3444914", "Vitoria da Conquista", "Витория-да-Конкиста", "BR", "76", "05", "2933307", "", "", "-14.86611", "-40.83944", "America/Bahia"),
("3444924", "Vitoria", "Витория", "BR", "76", "08", "3205309", "", "", "-20.31944", "-40.33778", "America/Sao_Paulo"),
("3444969", "Visconde do Rio Branco", "", "BR", "76", "15", "3172004", "", "", "-21.01028", "-42.84056", "America/Sao_Paulo"),
("3444997", "Viradouro", "", "BR", "76", "27", "3556800", "", "", "-20.87306", "-48.29694", "America/Sao_Paulo"),
("3445014", "Vinhedo", "", "BR", "76", "27", "3556701", "", "", "-23.02972", "-46.97528", "America/Sao_Paulo"),
("3445026", "Vila Velha", "Вила-Велья", "BR", "76", "08", "3205200", "", "", "-20.32972", "-40.2925", "America/Sao_Paulo"),
("3445126", "Videira", "Видейра", "BR", "76", "26", "4219309", "", "", "-27.00833", "-51.15167", "America/Sao_Paulo"),
("3445133", "Vicosa", "Висоза", "BR", "76", "15", "3171303", "", "", "-20.75389", "-42.88194", "America/Sao_Paulo"),
("3445153", "Viana", "Виана", "BR", "76", "08", "3205101", "", "", "-20.39028", "-40.49611", "America/Sao_Paulo"),
("3445156", "Viamao", "Виаман", "BR", "76", "23", "4323002", "", "", "-30.08111", "-51.02333", "America/Sao_Paulo"),
("3445162", "Vespasiano", "", "BR", "76", "15", "3171204", "", "", "-19.69194", "-43.92333", "America/Sao_Paulo"),
("3445299", "Veranopolis", "", "BR", "76", "23", "4322806", "", "", "-28.93611", "-51.54944", "America/Sao_Paulo"),
("3445307", "Vera Cruz", "", "BR", "76", "05", "2901304", "", "", "-12.63333", "-41.03333", "America/Bahia"),
("3445348", "Wenceslau Braz", "", "BR", "76", "18", "4128500", "", "", "-23.87389", "-49.80278", "America/Sao_Paulo"),
("3445350", "Venancio Aires", "", "BR", "76", "23", "4322608", "", "", "-29.60639", "-52.19194", "America/Sao_Paulo"),
("3445418", "Vazante", "", "BR", "76", "15", "3171006", "", "", "-17.98694", "-46.90778", "America/Sao_Paulo"),
("3445433", "Vassouras", "", "BR", "76", "21", "3306206", "", "", "-22.40389", "-43.6625", "America/Sao_Paulo"),
("3445446", "Varzea Paulista", "", "BR", "76", "27", "3556503", "", "", "-23.21139", "-46.82833", "America/Sao_Paulo"),
("3445451", "Varzea Grande", "", "BR", "76", "14", "5108402", "", "", "-15.64667", "-56.1325", "America/Cuiaba"),
("3445459", "Varzea da Palma", "", "BR", "76", "15", "3170800", "", "", "-17.59806", "-44.73083", "America/Sao_Paulo"),
("3445487", "Varginha", "Варжинья", "BR", "76", "15", "3170701", "", "", "-21.55139", "-45.43028", "America/Sao_Paulo"),
("3445500", "Vargem Grande do Sul", "Варжен-Гранди-ду-Сул", "BR", "76", "27", "3556404", "", "", "-21.83222", "-46.89361", "America/Sao_Paulo"),
("3445575", "Valparaiso", "", "BR", "76", "27", "3556305", "", "", "-21.22778", "-50.86833", "America/Sao_Paulo"),
("3445578", "Valinhos", "", "BR", "76", "27", "3556206", "", "", "-22.97056", "-46.99583", "America/Sao_Paulo"),
("3445596", "Valenca", "Валенса", "BR", "76", "21", "3306107", "", "", "-22.24556", "-43.70028", "America/Sao_Paulo"),
("3445597", "Valenca", "", "BR", "76", "05", "2932903", "", "", "-13.37028", "-39.07306", "America/Bahia"),
("3445630", "Vacaria", "Вакария", "BR", "76", "23", "4322509", "", "", "-28.51222", "-50.93389", "America/Sao_Paulo"),
("3445679", "Uruguaiana", "Уругуаяна", "BR", "76", "23", "4322400", "", "", "-29.75472", "-57.08833", "America/Sao_Paulo"),
("3445690", "Urucuca", "", "BR", "76", "05", "2932705", "", "", "-14.59306", "-39.28444", "America/Bahia"),
("3445713", "Uruacu", "Уруасу", "BR", "76", "29", "5221601", "", "", "-14.52472", "-49.14083", "America/Sao_Paulo"),
("3445746", "Uniao da Vitoria", "Униан-да-Витория", "BR", "76", "18", "4128203", "", "", "-26.23", "-51.08639", "America/Sao_Paulo"),
("3445764", "Unai", "Унай", "BR", "76", "15", "3170404", "", "", "-16.3575", "-46.90611", "America/Sao_Paulo"),
("3445781", "Una", "", "BR", "76", "05", "2932507", "", "", "-15.29333", "-39.07528", "America/Bahia"),
("3445782", "Umuarama", "", "BR", "76", "18", "4128104", "", "", "-23.76639", "-53.325", "America/Sao_Paulo"),
("3445831", "Uberlandia", "Уберландия", "BR", "76", "15", "3170206", "", "", "-18.91861", "-48.27722", "America/Sao_Paulo"),
("3445839", "Uberaba", "Убераба", "BR", "76", "15", "3170107", "", "", "-19.74833", "-47.93194", "America/Sao_Paulo"),
("3445847", "Ubatuba", "Убатуба", "BR", "76", "27", "3555406", "", "", "-23.43389", "-45.07111", "America/Sao_Paulo"),
("3445849", "Ubata", "", "BR", "76", "05", "2932309", "", "", "-14.21389", "-39.52278", "America/Bahia"),
("3445853", "Ubaitaba", "", "BR", "76", "05", "2932200", "", "", "-14.3125", "-39.32333", "America/Bahia"),
("3445859", "Uba", "Уба", "BR", "76", "15", "3169901", "", "", "-21.12", "-42.94278", "America/Sao_Paulo"),
("3445939", "Tupancireta", "", "BR", "76", "23", "4322202", "", "", "-29.08056", "-53.83583", "America/Sao_Paulo"),
("3445941", "Tupaciguara", "Тупасигуара", "BR", "76", "15", "3169604", "", "", "-18.59222", "-48.705", "America/Sao_Paulo"),
("3445942", "Tupa", "Тупа", "BR", "76", "27", "3555000", "", "", "-21.93472", "-50.51361", "America/Sao_Paulo"),
("3445983", "Tucano", "", "BR", "76", "05", "2931905", "", "", "-10.96306", "-38.78667", "America/Bahia"),
("3445993", "Tubarao", "Тубаран", "BR", "76", "26", "4218707", "", "", "-28.46667", "-49.00694", "America/Sao_Paulo"),
("3446038", "Trindade", "Триндади", "BR", "76", "29", "5221403", "", "", "-16.64944", "-49.48889", "America/Sao_Paulo"),
("3446065", "Tres Rios", "", "BR", "76", "21", "3306008", "", "", "-22.11667", "-43.20917", "America/Sao_Paulo"),
("3446077", "Tres Pontas", "Трес-Понтас", "BR", "76", "15", "3169406", "", "", "-21.36667", "-45.5125", "America/Sao_Paulo"),
("3446087", "Tres Passos", "", "BR", "76", "23", "4321907", "", "", "-27.45556", "-53.93194", "America/Sao_Paulo"),
("3446098", "Tres Lagoas", "Трес-Лагоас", "BR", "76", "11", "5008305", "", "", "-20.78741", "-51.70406", "America/Campo_Grande"),
("3446130", "Tres de Maio", "", "BR", "76", "23", "4321808", "", "", "-27.77333", "-54.24", "America/Sao_Paulo"),
("3446137", "Tres Coroas", "", "BR", "76", "23", "4321709", "", "", "-29.51694", "-50.77778", "America/Sao_Paulo"),
("3446138", "Tres Coracoes", "", "BR", "76", "15", "3169307", "", "", "-21.69694", "-45.25333", "America/Sao_Paulo"),
("3446194", "Tremembe", "", "BR", "76", "27", "3554805", "", "", "-22.95833", "-45.54944", "America/Sao_Paulo"),
("3446232", "Tramandai", "", "BR", "76", "23", "4321600", "", "", "-29.98472", "-50.13361", "America/Sao_Paulo"),
("3446295", "Torres", "Торрес", "BR", "76", "23", "4321501", "", "", "-29.33528", "-49.72694", "America/Sao_Paulo"),
("3446370", "Toledo", "Толедо", "BR", "76", "18", "4127700", "", "", "-24.71361", "-53.74306", "America/Sao_Paulo"),
("3446400", "Tobias Barreto", "", "BR", "76", "28", "2807402", "", "", "-11.18389", "-37.99833", "America/Maceio"),
("3446445", "Timoteo", "Тимофей", "BR", "76", "15", "3168705", "", "", "-19.5825", "-42.64444", "America/Sao_Paulo"),
("3446465", "Timbo", "", "BR", "76", "26", "4218202", "", "", "-26.82333", "-49.27167", "America/Sao_Paulo"),
("3446500", "Tijucas", "Тижукас", "BR", "76", "26", "4218004", "", "", "-27.24139", "-48.63361", "America/Sao_Paulo"),
("3446539", "Tiete", "", "BR", "76", "27", "3554508", "", "", "-23.10194", "-47.71472", "America/Sao_Paulo"),
("3446556", "Teutonia", "", "BR", "76", "23", "4321451", "", "", "-29.44806", "-51.80639", "America/Sao_Paulo"),
("3446606", "Teresopolis", "Терезополис", "BR", "76", "21", "3305802", "", "", "-22.41222", "-42.96556", "America/Sao_Paulo"),
("3446621", "Teofilo Otoni", "Теофилу-Отони", "BR", "76", "15", "3168606", "", "", "-17.8575", "-41.50528", "America/Sao_Paulo"),
("3446625", "Teodoro Sampaio", "", "BR", "76", "27", "3554300", "", "", "-22.5325", "-52.1675", "America/Sao_Paulo"),
("3446652", "Telemaco Borba", "", "BR", "76", "18", "4127106", "", "", "-24.32389", "-50.61556", "America/Sao_Paulo"),
("3446682", "Taubate", "Таубате", "BR", "76", "27", "3554102", "", "", "-23.02639", "-45.55528", "America/Sao_Paulo"),
("3446692", "Tatui", "", "BR", "76", "27", "3554003", "", "", "-23.35556", "-47.85694", "America/Sao_Paulo"),
("3446752", "Taquarituba", "", "BR", "76", "27", "3553807", "", "", "-23.53306", "-49.24444", "America/Sao_Paulo"),
("3446753", "Taquaritinga", "", "BR", "76", "27", "3553708", "", "", "-21.40611", "-48.50472", "America/Sao_Paulo"),
("3446783", "Taquari", "Такуари", "BR", "76", "23", "4321303", "", "", "-29.79972", "-51.86444", "America/Sao_Paulo"),
("3446847", "Taquara", "", "BR", "76", "23", "4321204", "", "", "-29.65056", "-50.78056", "America/Sao_Paulo"),
("3446866", "Tapiramuta", "", "BR", "76", "05", "2931301", "", "", "-11.84722", "-40.79139", "America/Bahia"),
("3446880", "Tapes", "", "BR", "76", "23", "4321105", "", "", "-30.67333", "-51.39583", "America/Sao_Paulo"),
("3446974", "Tangua", "", "BR", "76", "21", "3305752", "", "", "-22.73028", "-42.71417", "America/Sao_Paulo"),
("3446979", "Tanabi", "", "BR", "76", "27", "3553401", "", "", "-20.62639", "-49.64917", "America/Sao_Paulo"),
("3447005", "Tambau", "", "BR", "76", "27", "3553302", "", "", "-21.705", "-47.27444", "America/Sao_Paulo"),
("3447059", "Taiobeiras", "Тайобейрас", "BR", "76", "15", "3168002", "", "", "-15.80778", "-42.23306", "America/Sao_Paulo"),
("3447186", "Taboao da Serra", "", "BR", "76", "27", "3552809", "", "", "-23.62611", "-46.79167", "America/Sao_Paulo"),
("3447212", "Suzano", "Сузано", "BR", "76", "27", "3552502", "", "", "-23.5425", "-46.31083", "America/Sao_Paulo"),
("3447259", "Sumare", "Сумаре", "BR", "76", "27", "3552403", "", "", "-22.82194", "-47.26694", "America/Sao_Paulo"),
("3447399", "Sorocaba", "Сорокаба", "BR", "76", "27", "3552205", "", "", "-23.50167", "-47.45806", "America/Sao_Paulo"),
("3447423", "Soledade", "", "BR", "76", "23", "4320800", "", "", "-28.81833", "-52.51028", "America/Sao_Paulo"),
("3447437", "Socorro", "Сокорро", "BR", "76", "27", "3552106", "", "", "-22.59139", "-46.52889", "America/Sao_Paulo"),
("3447473", "Sobradinho", "", "BR", "76", "05", "2929107", "", "", "-12.83333", "-39.1", "America/Bahia"),
("3447562", "Simao Dias", "", "BR", "76", "28", "2807105", "", "", "-10.73833", "-37.81111", "America/Maceio"),
("3447591", "Silva Jardim", "", "BR", "76", "21", "3305604", "", "", "-22.65083", "-42.39167", "America/Sao_Paulo"),
("3447597", "Sidrolandia", "", "BR", "76", "11", "5007901", "", "", "-20.93194", "-54.96139", "America/Campo_Grande"),
("3447624", "Sete Lagoas", "Сети-Лагоас", "BR", "76", "15", "3167202", "", "", "-19.46583", "-44.24667", "America/Sao_Paulo"),
("3447651", "Sertaozinho", "", "BR", "76", "27", "3551702", "", "", "-21.13778", "-47.99028", "America/Sao_Paulo"),
("3447690", "Serrinha", "", "BR", "76", "05", "2930501", "", "", "-11.66417", "-39.0075", "America/Bahia"),
("3447718", "Serra Negra", "", "BR", "76", "27", "3551603", "", "", "-22.61222", "-46.70056", "America/Sao_Paulo"),
("3447720", "Serrana", "", "BR", "76", "27", "3551504", "", "", "-21.21139", "-47.59556", "America/Sao_Paulo"),
("3447779", "Serra", "Серра", "BR", "76", "08", "3205002", "", "", "-20.12861", "-40.30778", "America/Sao_Paulo"),
("3447785", "Seropedica", "", "BR", "76", "21", "3305554", "", "", "-22.74389", "-43.7075", "America/Sao_Paulo"),
("3447839", "Senhor do Bonfim", "", "BR", "76", "05", "2930105", "", "", "-10.46139", "-40.18944", "America/Bahia"),
("3447854", "Senador Canedo", "", "BR", "76", "29", "5220454", "", "", "-16.70806", "-49.09306", "America/Sao_Paulo"),
("3447928", "Seabra", "", "BR", "76", "05", "2929909", "", "", "-12.41861", "-41.77028", "America/Bahia"),
("3447929", "Schroeder", "", "BR", "76", "26", "4217402", "", "", "-26.4125", "-49.07306", "America/Sao_Paulo"),
("3447961", "Saubara", "", "BR", "76", "05", "2929750", "", "", "-12.7375", "-38.76861", "America/Bahia"),
("3447969", "Sarzedo", "", "BR", "76", "15", "3165537", "", "", "-20.03528", "-44.14472", "America/Sao_Paulo"),
("3447997", "Sarandi", "Саранди", "BR", "76", "23", "4320107", "", "", "-27.94389", "-52.92306", "America/Sao_Paulo"),
("3447998", "Sarandi", "", "BR", "76", "18", "4126256", "", "", "-23.44361", "-51.87389", "America/Sao_Paulo"),
("3448011", "Saquarema", "", "BR", "76", "21", "3305505", "", "", "-22.92", "-42.51028", "America/Sao_Paulo"),
("3448031", "Sapucaia", "Сапукая", "BR", "76", "23", "4320008", "", "", "-29.83333", "-51.15", "America/Sao_Paulo"),
("3448063", "Sapiranga", "", "BR", "76", "23", "4319901", "", "", "-29.63806", "-51.00694", "America/Sao_Paulo"),
("3448136", "Sao Vicente", "Сан-Висенти", "BR", "76", "27", "3551009", "", "", "-23.96306", "-46.39194", "America/Sao_Paulo"),
("3448207", "Sao Sepe", "", "BR", "76", "23", "4319604", "", "", "-30.16056", "-53.56528", "America/Sao_Paulo"),
("3448219", "Sao Sebastiao do Passe", "", "BR", "76", "05", "2929503", "", "", "-12.5125", "-38.49528", "America/Bahia"),
("3448221", "Sao Sebastiao do Paraiso", "Сан-Себастьян-ду-Параисо", "BR", "76", "15", "3164704", "", "", "-20.91694", "-46.99139", "America/Sao_Paulo"),
("3448227", "Sao Sebastiao do Cai", "", "BR", "76", "23", "4319505", "", "", "-29.58667", "-51.37556", "America/Sao_Paulo"),
("3448257", "Sao Sebastiao", "", "BR", "76", "27", "3550704", "", "", "-23.76", "-45.40972", "America/Sao_Paulo"),
("3448300", "Sao Roque", "", "BR", "76", "27", "3550605", "", "", "-23.52917", "-47.13528", "America/Sao_Paulo"),
("3448351", "Sao Pedro da Aldeia", "", "BR", "76", "21", "3305208", "", "", "-22.83917", "-42.10278", "America/Sao_Paulo"),
("3448403", "Sao Pedro", "", "BR", "76", "27", "3550407", "", "", "-22.54861", "-47.91389", "America/Sao_Paulo"),
("3448439", "Sao Paulo", "Сан-Паулу", "BR", "76", "27", "3550308", "", "", "-23.5475", "-46.63611", "America/Sao_Paulo"),
("3448453", "Sao Miguel do Iguacu", "", "BR", "76", "18", "4125704", "", "", "-25.34806", "-54.23778", "America/Sao_Paulo"),
("3448455", "Sao Miguel do Araguaia", "", "BR", "76", "29", "5220207", "", "", "-13.275", "-50.16278", "America/Sao_Paulo"),
("3448502", "Sao Mateus do Sul", "Сан-Матеус-ду-Сул", "BR", "76", "18", "4125605", "", "", "-25.87417", "-50.38278", "America/Sao_Paulo"),
("3448519", "Sao Mateus", "Сан-Матеус", "BR", "76", "08", "3204906", "", "", "-18.72011", "-39.85891", "America/Sao_Paulo"),
("3448533", "Sao Marcos", "", "BR", "76", "23", "4319000", "", "", "-28.97111", "-51.06806", "America/Sao_Paulo"),
("3448545", "Sao Manuel", "Сан-Мануэль", "BR", "76", "27", "3550100", "", "", "-22.73111", "-48.57056", "America/Sao_Paulo"),
("3448552", "Sao Luiz Gonzaga", "", "BR", "76", "23", "4318903", "", "", "-28.40833", "-54.96083", "America/Sao_Paulo"),
("3448558", "Sao Luis de Montes Belos", "", "BR", "76", "29", "5220108", "", "", "-16.525", "-50.37222", "America/Sao_Paulo"),
("3448596", "Sao Lourenco do Sul", "Сан-Лоренсу-ду-Сул", "BR", "76", "23", "4318804", "", "", "-31.36528", "-51.97833", "America/Sao_Paulo"),
("3448616", "Sao Lourenco", "Сан-Лоренсу", "BR", "76", "15", "3163706", "", "", "-22.11639", "-45.05444", "America/Sao_Paulo"),
("3448622", "Sao Leopoldo", "Сан-Леополду", "BR", "76", "23", "4318705", "", "", "-29.76028", "-51.14722", "America/Sao_Paulo"),
("3448632", "Sao Jose dos Pinhais", "Сан-Жозе-дус-Пиньяйс", "BR", "76", "18", "4125506", "", "", "-25.53472", "-49.20639", "America/Sao_Paulo"),
("3448636", "Sao Jose dos Campos", "Сан-Жозе-дус-Кампус", "BR", "76", "27", "3549904", "", "", "-23.17944", "-45.88694", "America/Sao_Paulo"),
("3448639", "Sao Jose do Rio Preto", "Сан-Жозе-ду-Риу-Прету", "BR", "76", "27", "3549805", "", "", "-20.81972", "-49.37944", "America/Sao_Paulo"),
("3448640", "Sao Jose do Rio Pardo", "", "BR", "76", "27", "3549706", "", "", "-21.59556", "-46.88861", "America/Sao_Paulo"),
("3448742", "Sao Jose", "", "BR", "76", "26", "4202800", "", "", "-28.21171", "-49.1632", "America/Sao_Paulo"),
("3448825", "Sao Joaquim da Barra", "", "BR", "76", "27", "3549409", "", "", "-20.58139", "-47.85472", "America/Sao_Paulo"),
("3448828", "Sao Joaquim", "", "BR", "76", "26", "4216503", "", "", "-28.29389", "-49.93167", "America/Sao_Paulo"),
("3448846", "Sao Joao Nepomuceno", "Сан-Жуан-Непомусено", "BR", "76", "15", "3162906", "", "", "-21.54", "-43.01056", "America/Sao_Paulo"),
("3448877", "Sao Joao de Meriti", "Сан-Жуан-ди-Мерити", "BR", "76", "21", "3305109", "", "", "-22.80389", "-43.37222", "America/Sao_Paulo"),
("3448879", "Sao Joao del Rei", "Сан-Жуан-дел-Рей", "BR", "76", "15", "3162500", "", "", "-21.13556", "-44.26167", "America/Sao_Paulo"),
("3448902", "Sao Joao da Boa Vista", "", "BR", "76", "27", "3549102", "", "", "-21.96917", "-46.79806", "America/Sao_Paulo"),
("3448903", "Sao Joao da Barra", "Сан-Жуан-да-Барра", "BR", "76", "21", "3305000", "", "", "-21.64028", "-41.05111", "America/Sao_Paulo"),
("3449045", "Sao Jeronimo", "", "BR", "76", "23", "4318408", "", "", "-29.95917", "-51.72222", "America/Sao_Paulo"),
("3449053", "Sao Gotardo", "", "BR", "76", "15", "3162104", "", "", "-19.31111", "-46.04889", "America/Sao_Paulo"),
("3449056", "Sao Goncalo do Sapucai", "", "BR", "76", "15", "3162005", "", "", "-21.89222", "-45.59528", "America/Sao_Paulo"),
("3449099", "Sao Gabriel", "", "BR", "76", "23", "4318309", "", "", "-30.33639", "-54.32", "America/Sao_Paulo"),
("3449112", "Sao Francisco do Sul", "Сан-Франсиску-ду-Сул", "BR", "76", "26", "4216206", "", "", "-26.24333", "-48.63806", "America/Sao_Paulo"),
("3449116", "Sao Francisco do Conde", "Сан-Франсиску-ду-Конде", "BR", "76", "05", "2929206", "", "", "-12.6275", "-38.68", "America/Bahia"),
("3449176", "Sao Francisco", "", "BR", "76", "15", "3161106", "", "", "-15.94861", "-44.86444", "America/Sao_Paulo"),
("3449195", "Sao Fidelis", "", "BR", "76", "21", "3304805", "", "", "-21.64611", "-41.74694", "America/Sao_Paulo"),
("3449310", "Sao Cristovao", "Сан-Кристован", "BR", "76", "28", "2806701", "", "", "-11.01472", "-37.20639", "America/Maceio"),
("3449319", "Sao Carlos", "Сан-Карлос", "BR", "76", "27", "3548906", "", "", "-22.0175", "-47.89083", "America/Sao_Paulo"),
("3449324", "Sao Caetano do Sul", "Сан-Каэтано-ду-Сул", "BR", "76", "27", "3548807", "", "", "-23.62306", "-46.55111", "America/Sao_Paulo"),
("3449340", "Sao Borja", "Сан-Борха", "BR", "76", "23", "4318002", "", "", "-28.66056", "-56.00444", "America/Sao_Paulo"),
("3449344", "Sao Bernardo do Campo", "Сан-Бернардо-ду-Кампу", "BR", "76", "27", "3548708", "", "", "-23.69389", "-46.565", "America/Sao_Paulo"),
("3449350", "Sao Bento do Sul", "Сан-Бенту-ду-Сул", "BR", "76", "26", "4215802", "", "", "-26.25028", "-49.37861", "America/Sao_Paulo"),
("3449427", "Santos Dumont", "", "BR", "76", "15", "3160702", "", "", "-21.45667", "-43.5525", "America/Sao_Paulo"),
("3449433", "Santos", "Сантос", "BR", "76", "27", "3548500", "", "", "-23.96083", "-46.33361", "America/Sao_Paulo"),
("3449467", "Santo Estevao", "", "BR", "76", "05", "2928802", "", "", "-12.43028", "-39.25139", "America/Bahia"),
("3449500", "Santo Antonio do Monte", "", "BR", "76", "15", "3160405", "", "", "-20.08722", "-45.29361", "America/Sao_Paulo"),
("3449516", "Santo Antonio do Amparo", "", "BR", "76", "15", "3159902", "", "", "-20.94639", "-44.91889", "America/Sao_Paulo"),
("3449518", "Santo Antonio de Posse", "", "BR", "76", "27", "3548005", "", "", "-22.60611", "-46.91944", "America/Sao_Paulo"),
("3449519", "Santo Antonio de Padua", "", "BR", "76", "21", "3304706", "", "", "-21.53944", "-42.18028", "America/Sao_Paulo"),
("3449521", "Santo Antonio de Jesus", "", "BR", "76", "05", "2928703", "", "", "-12.96889", "-39.26139", "America/Bahia"),
("3449529", "Santo Antonio da Platina", "Санту-Антониу-да-Платина", "BR", "76", "18", "4124103", "", "", "-23.295", "-50.07722", "America/Sao_Paulo"),
("3449696", "Santo Angelo", "Санту-Анджело", "BR", "76", "23", "4317509", "", "", "-28.29917", "-54.26306", "America/Sao_Paulo"),
("3449701", "Santo Andre", "Санту-Андре", "BR", "76", "27", "3547809", "", "", "-23.66389", "-46.53833", "America/Sao_Paulo"),
("3449707", "Santo Anastacio", "", "BR", "76", "27", "3543238", "", "", "-21.83833", "-51.61028", "America/Sao_Paulo"),
("3449711", "Santo Amaro da Imperatriz", "", "BR", "76", "26", "4215703", "", "", "-27.68806", "-48.77861", "America/Sao_Paulo"),
("3449720", "Santo Amaro", "", "BR", "76", "05", "2928604", "", "", "-12.54667", "-38.71194", "America/Bahia"),
("3449741", "Santiago", "Сантьяго", "BR", "76", "23", "4317400", "", "", "-29.19167", "-54.86722", "America/Sao_Paulo"),
("3449747", "Santa Vitoria do Palmar", "", "BR", "76", "23", "4317301", "", "", "-33.51889", "-53.36806", "America/Sao_Paulo"),
("3449793", "Santa Rosa de Viterbo", "", "BR", "76", "27", "3547601", "", "", "-21.47278", "-47.36306", "America/Sao_Paulo"),
("3449822", "Santa Rosa", "", "BR", "76", "23", "4317202", "", "", "-27.87083", "-54.48139", "America/Sao_Paulo"),
("3449847", "Santa Rita do Sapucai", "Санта-Рита-ду-Сапукайя", "BR", "76", "15", "3159605", "", "", "-22.25222", "-45.70333", "America/Sao_Paulo"),
("3449851", "Santa Rita do Passa Quatro", "", "BR", "76", "27", "3547502", "", "", "-21.71028", "-47.47806", "America/Sao_Paulo"),
("3449933", "Santana do Paraiso", "Сантана-ду-Параисо", "BR", "76", "15", "3158953", "", "", "-19.36361", "-42.56861", "America/Sao_Paulo"),
("3449936", "Santana do Livramento", "Сантана-ду-Ливраменту", "BR", "76", "23", "4317103", "", "", "-30.89083", "-55.53278", "America/Sao_Paulo"),
("3449948", "Santana de Parnaiba", "", "BR", "76", "27", "3547304", "", "", "-23.44417", "-46.91778", "America/Sao_Paulo"),
("3450063", "Santa Maria da Vitoria", "Санта-Мария-да-Витория", "BR", "76", "05", "2929057", "", "", "-13.39472", "-44.18861", "America/Bahia"),
("3450083", "Santa Maria", "Санта-Мария", "BR", "76", "23", "4316907", "", "", "-29.68417", "-53.80694", "America/Sao_Paulo"),
("3450144", "Santa Luzia", "Санта-Лусия", "BR", "76", "15", "3157807", "", "", "-19.76972", "-43.85139", "America/Sao_Paulo"),
("3450157", "Santaluz", "", "BR", "76", "05", "2928000", "", "", "-11.25583", "-39.37472", "America/Bahia"),
("3450188", "Santa Isabel", "", "BR", "76", "27", "3546801", "", "", "-23.31556", "-46.22139", "America/Sao_Paulo"),
("3450206", "Santa Helena de Goias", "Санта-Элена-ди-Гояс", "BR", "76", "29", "5219308", "", "", "-17.81361", "-50.59694", "America/Sao_Paulo"),
("3450225", "Santa Gertrudes", "", "BR", "76", "27", "3546702", "", "", "-22.45667", "-47.53028", "America/Sao_Paulo"),
("3450232", "Santa Fe do Sul", "", "BR", "76", "27", "3546603", "", "", "-20.21111", "-50.92583", "America/Sao_Paulo"),
("3450269", "Santa Cruz do Sul", "Санта-Крус-ду-Сул", "BR", "76", "23", "4316808", "", "", "-29.7175", "-52.42583", "America/Sao_Paulo"),
("3450272", "Santa Cruz do Rio Pardo", "", "BR", "76", "27", "3546405", "", "", "-22.89889", "-49.6325", "America/Sao_Paulo"),
("3450283", "Santa Cruz das Palmeiras", "", "BR", "76", "27", "3546306", "", "", "-21.82694", "-47.24861", "America/Sao_Paulo"),
("3450288", "Santa Cruz Cabralia", "", "BR", "76", "05", "2927705", "", "", "-16.27806", "-39.02472", "America/Bahia"),
("3450376", "Santa Cecilia", "", "BR", "76", "26", "4215505", "", "", "-26.96083", "-50.42694", "America/Sao_Paulo"),
("3450404", "Santa Barbara d'Oeste", "", "BR", "76", "27", "3545803", "", "", "-22.75361", "-47.41361", "America/Sao_Paulo"),
("3450554", "Salvador", "Салвадор", "BR", "76", "05", "2927408", "", "", "-12.97111", "-38.51083", "America/Bahia"),
("3450563", "Salto de Pirapora", "", "BR", "76", "27", "3545308", "", "", "-23.64889", "-47.57333", "America/Sao_Paulo"),
("3450594", "Salto", "Сальто", "BR", "76", "27", "3545209", "", "", "-23.20083", "-47.28694", "America/Sao_Paulo"),
("3450671", "Salinas", "", "BR", "76", "15", "3157005", "", "", "-16.17028", "-42.29028", "America/Sao_Paulo"),
("3450759", "Sacramento", "", "BR", "76", "15", "3156908", "", "", "-19.86528", "-47.44", "America/Sao_Paulo"),
("3450832", "Ruy Barbosa", "", "BR", "76", "05", "2927200", "", "", "-12.28389", "-40.49389", "America/Bahia"),
("3450843", "Rubiataba", "", "BR", "76", "29", "5218904", "", "", "-15.16444", "-49.80333", "America/Sao_Paulo"),
("3450873", "Rosario do Sul", "Росарио-ду-Сул", "BR", "76", "23", "4316402", "", "", "-30.25833", "-54.91417", "America/Sao_Paulo"),
("3450909", "Rondonopolis", "", "BR", "76", "14", "5107602", "", "", "-16.47083", "-54.63556", "America/Cuiaba"),
("3450963", "Rolante", "", "BR", "76", "23", "4316006", "", "", "-29.65056", "-50.57583", "America/Sao_Paulo"),
("3450964", "Rolandia", "", "BR", "76", "18", "4122404", "", "", "-23.30972", "-51.36917", "America/Sao_Paulo"),
("3451051", "Rio Verde de Mato Grosso", "", "BR", "76", "11", "5007406", "", "", "-18.91806", "-54.84417", "America/Campo_Grande"),
("3451071", "Rio Real", "", "BR", "76", "05", "2927002", "", "", "-11.48472", "-37.93278", "America/Bahia"),
("3451102", "Rio Pardo", "Рио-Пардо", "BR", "76", "23", "4315701", "", "", "-29.98972", "-52.37806", "America/Sao_Paulo"),
("3451121", "Rio Negro", "", "BR", "76", "18", "4122305", "", "", "-26.10583", "-49.7975", "America/Sao_Paulo"),
("3451124", "Rio Negrinho", "", "BR", "76", "26", "4215000", "", "", "-26.25444", "-49.51833", "America/Sao_Paulo"),
("3451134", "Rio Grande da Serra", "", "BR", "76", "27", "3544103", "", "", "-23.74417", "-46.39833", "America/Sao_Paulo"),
("3451138", "Rio Grande", "Рио-Гранде", "BR", "76", "23", "4315602", "", "", "-32.035", "-52.09861", "America/Sao_Paulo"),
("3451152", "Rio do Sul", "Риу-ду-Сул", "BR", "76", "26", "4214805", "", "", "-27.21417", "-49.64306", "America/Sao_Paulo"),
("3451190", "Rio de Janeiro", "Рио-де-Жанейро", "BR", "76", "21", "3304557", "", "", "-22.90278", "-43.2075", "America/Sao_Paulo"),
("3451202", "Rio das Pedras", "", "BR", "76", "27", "3544004", "", "", "-22.84333", "-47.60611", "America/Sao_Paulo"),
("3451205", "Rio das Ostras", "", "BR", "76", "21", "3304524", "", "", "-22.52694", "-41.945", "America/Sao_Paulo"),
("3451234", "Rio Claro", "", "BR", "76", "27", "3543907", "", "", "-22.41139", "-47.56139", "America/Sao_Paulo"),
("3451241", "Rio Brilhante", "", "BR", "76", "11", "5007208", "", "", "-21.80194", "-54.54639", "America/Campo_Grande"),
("3451242", "Rio Branco do Sul", "Риу-Бранку-ду-Сул", "BR", "76", "18", "4122206", "", "", "-25.19", "-49.31417", "America/Sao_Paulo"),
("3451261", "Rio Bonito", "", "BR", "76", "21", "3304300", "", "", "-22.70861", "-42.60972", "America/Sao_Paulo"),
("3451328", "Ribeirao Preto", "Рибейран-Прету", "BR", "76", "27", "3543402", "", "", "-21.1775", "-47.81028", "America/Sao_Paulo"),
("3451329", "Ribeirao Pires", "", "BR", "76", "27", "3543303", "", "", "-23.71056", "-46.41333", "America/Sao_Paulo"),
("3451353", "Ribeirao das Neves", "", "BR", "76", "15", "3154606", "", "", "-19.76694", "-44.08667", "America/Sao_Paulo"),
("3451357", "Ribeirao da Ilha", "", "BR", "76", "26", "4205407", "", "", "-27.69934", "-48.53219", "America/Sao_Paulo"),
("3451383", "Ribeira do Pombal", "", "BR", "76", "05", "2926608", "", "", "-10.83444", "-38.53583", "America/Bahia"),
("3451474", "Riachao do Jacuipe", "", "BR", "76", "05", "2926301", "", "", "-11.80694", "-39.38556", "America/Bahia"),
("3451650", "Resplendor", "", "BR", "76", "15", "3154309", "", "", "-19.32556", "-41.25528", "America/Sao_Paulo"),
("3451668", "Resende", "Резенди", "BR", "76", "21", "3304201", "", "", "-22.46889", "-44.44667", "America/Sao_Paulo"),
("3451704", "Registro", "", "BR", "76", "27", "3542602", "", "", "-24.4875", "-47.84361", "America/Sao_Paulo"),
("3451709", "Regente Feijo", "", "BR", "76", "27", "3542404", "", "", "-22.22139", "-51.30278", "America/Sao_Paulo"),
("3451856", "Rancharia", "", "BR", "76", "27", "3542206", "", "", "-22.22917", "-50.89306", "America/Sao_Paulo"),
("3451931", "Quirinopolis", "", "BR", "76", "29", "5218508", "", "", "-18.44833", "-50.45167", "America/Sao_Paulo"),
("3452073", "Queimados", "", "BR", "76", "21", "3304144", "", "", "-22.71611", "-43.55528", "America/Sao_Paulo"),
("3452141", "Quatro Barras", "", "BR", "76", "18", "4120804", "", "", "-25.36556", "-49.07694", "America/Sao_Paulo"),
("3452179", "Quarai", "Куараи", "BR", "76", "23", "4315305", "", "", "-30.3875", "-56.45139", "America/Sao_Paulo"),
("3452216", "Prudentopolis", "", "BR", "76", "18", "4120606", "", "", "-25.21306", "-50.97778", "America/Sao_Paulo"),
("3452233", "Propria", "", "BR", "76", "28", "2805703", "", "", "-10.21111", "-36.84028", "America/Maceio"),
("3452237", "Promissao", "", "BR", "76", "27", "3541604", "", "", "-21.53667", "-49.85806", "America/Sao_Paulo"),
("3452320", "Presidente Venceslau", "", "BR", "76", "27", "3541505", "", "", "-21.87611", "-51.84389", "America/Sao_Paulo"),
("3452324", "Presidente Prudente", "Президенти-Пруденти", "BR", "76", "27", "3541406", "", "", "-22.12556", "-51.38889", "America/Sao_Paulo"),
("3452331", "Presidente Epitacio", "", "BR", "76", "27", "3541307", "", "", "-21.76333", "-52.11556", "America/Sao_Paulo"),
("3452440", "Prata", "", "BR", "76", "15", "3152808", "", "", "-19.30722", "-48.92417", "America/Sao_Paulo"),
("3452465", "Praia Grande", "Прайя-Гранди", "BR", "76", "27", "3541000", "", "", "-24.00583", "-46.40278", "America/Sao_Paulo"),
("3452483", "Prado", "", "BR", "76", "05", "2925501", "", "", "-17.34111", "-39.22083", "America/Bahia"),
("3452525", "Pouso Alegre", "Позу-Алегри", "BR", "76", "15", "3152501", "", "", "-22.23", "-45.93639", "America/Sao_Paulo"),
("3452599", "Posse", "", "BR", "76", "29", "5218300", "", "", "-14.09306", "-46.36944", "America/Sao_Paulo"),
("3452623", "Porto Uniao", "", "BR", "76", "26", "4213609", "", "", "-26.23806", "-51.07833", "America/Sao_Paulo"),
("3452640", "Porto Seguro", "Порту-Сегуру", "BR", "76", "05", "2925303", "", "", "-16.44972", "-39.06472", "America/Bahia"),
("3452775", "Porto Ferreira", "Порту-Феррейра", "BR", "76", "27", "3540705", "", "", "-21.85389", "-47.47917", "America/Sao_Paulo"),
("3452779", "Porto Feliz", "Порту-Фелис", "BR", "76", "27", "3540606", "", "", "-23.21472", "-47.52389", "America/Sao_Paulo"),
("3452925", "Porto Alegre", "Порту-Алегри", "BR", "76", "23", "4314902", "", "", "-30.03306", "-51.23", "America/Sao_Paulo"),
("3452982", "Portao", "", "BR", "76", "23", "4314803", "", "", "-29.70167", "-51.24194", "America/Sao_Paulo"),
("3453014", "Porangatu", "Порангату", "BR", "76", "29", "5218003", "", "", "-13.44083", "-49.14861", "America/Sao_Paulo"),
("3453060", "Pontes e Lacerda", "", "BR", "76", "14", "5106752", "", "", "-15.22611", "-59.33528", "America/Cuiaba"),
("3453078", "Ponte Nova", "", "BR", "76", "15", "3152105", "", "", "-20.41639", "-42.90861", "America/Sao_Paulo"),
("3453150", "Ponta Pora", "Понта-Поран", "BR", "76", "11", "5006606", "", "", "-22.53611", "-55.72556", "America/Campo_Grande"),
("3453171", "Pontal", "", "BR", "76", "27", "3540200", "", "", "-21.0225", "-48.03722", "America/Sao_Paulo"),
("3453186", "Ponta Grossa", "Понта-Гроса", "BR", "76", "18", "4119905", "", "", "-25.095", "-50.16194", "America/Sao_Paulo"),
("3453240", "Pompeu", "", "BR", "76", "15", "3152006", "", "", "-19.22444", "-44.93528", "America/Sao_Paulo"),
("3453242", "Pompeia", "", "BR", "76", "27", "3540002", "", "", "-22.10861", "-50.17167", "America/Sao_Paulo"),
("3453245", "Pomerode", "", "BR", "76", "26", "4213203", "", "", "-26.74056", "-49.17694", "America/Sao_Paulo"),
("3453303", "Pocos de Caldas", "Посус-ди-Калдас", "BR", "76", "15", "3151800", "", "", "-21.78778", "-46.56139", "America/Sao_Paulo"),
("3453315", "Pocone", "", "BR", "76", "14", "5106505", "", "", "-16.25667", "-56.62278", "America/Cuiaba"),
("3453337", "Pocoes", "", "BR", "76", "05", "2925105", "", "", "-14.52972", "-40.36528", "America/Bahia"),
("3453406", "Poa", "", "BR", "76", "27", "3539806", "", "", "-23.52806", "-46.34472", "America/Sao_Paulo"),
("3453420", "Planaltina", "", "BR", "76", "29", "5217609", "", "", "-15.45278", "-47.61417", "America/Sao_Paulo"),
("3453435", "Piuma", "", "BR", "76", "08", "3204203", "", "", "-20.83778", "-40.72194", "America/Sao_Paulo"),
("3453439", "Piui", "", "BR", "76", "15", "3151503", "", "", "-20.46528", "-45.95806", "America/Sao_Paulo"),
("3453457", "Pitangui", "", "BR", "76", "15", "3151404", "", "", "-19.68278", "-44.89028", "America/Sao_Paulo"),
("3453467", "Pitangueiras", "", "BR", "76", "27", "3539509", "", "", "-21.00944", "-48.22167", "America/Sao_Paulo"),
("3453478", "Pitanga", "", "BR", "76", "18", "4119608", "", "", "-24.75722", "-51.76139", "America/Sao_Paulo"),
("3453494", "Piritiba", "", "BR", "76", "05", "2924801", "", "", "-11.73028", "-40.55528", "America/Bahia"),
("3453503", "Pires do Rio", "Пирес-ду-Риу", "BR", "76", "29", "5217401", "", "", "-17.29972", "-48.27944", "America/Sao_Paulo"),
("3453535", "Piraquara", "", "BR", "76", "18", "4119509", "", "", "-25.44167", "-49.06333", "America/Sao_Paulo"),
("3453542", "Pirapozinho", "", "BR", "76", "27", "3539202", "", "", "-22.27528", "-51.5", "America/Sao_Paulo"),
("3453546", "Pirapora", "", "BR", "76", "15", "3151206", "", "", "-17.345", "-44.94194", "America/Sao_Paulo"),
("3453605", "Pirajui", "", "BR", "76", "27", "3538907", "", "", "-21.99861", "-49.45722", "America/Sao_Paulo"),
("3453610", "Piraju", "", "BR", "76", "27", "3538808", "", "", "-23.19361", "-49.38389", "America/Sao_Paulo"),
("3453622", "Pirai do Sul", "", "BR", "76", "18", "4119400", "", "", "-24.52611", "-49.94861", "America/Sao_Paulo"),
("3453635", "Pirai", "", "BR", "76", "21", "3304003", "", "", "-22.62917", "-43.89806", "America/Sao_Paulo"),
("3453639", "Pirassununga", "Пирасунунга", "BR", "76", "27", "3539301", "", "", "-21.99611", "-47.42583", "America/Sao_Paulo"),
("3453643", "Piracicaba", "Пирасикаба", "BR", "76", "27", "3538709", "", "", "-22.72528", "-47.64917", "America/Sao_Paulo"),
("3453659", "Piracanjuba", "", "BR", "76", "29", "5217104", "", "", "-17.30278", "-49.01667", "America/Sao_Paulo"),
("3453661", "Piracaia", "", "BR", "76", "27", "3538600", "", "", "-23.05389", "-46.35806", "America/Sao_Paulo"),
("3453767", "Pinheiral", "", "BR", "76", "21", "3303955", "", "", "-22.51278", "-44.00056", "America/Sao_Paulo"),
("3453777", "Pinhao", "", "BR", "76", "18", "4119301", "", "", "-25.69556", "-51.65972", "America/Sao_Paulo"),
("3453807", "Espirito Santo do Pinhal", "", "BR", "76", "27", "3548104", "", "", "-22.11583", "-46.68278", "America/Sao_Paulo"),
("3453827", "Pindobacu", "", "BR", "76", "05", "2924603", "", "", "-10.74167", "-40.36083", "America/Bahia"),
("3453837", "Pindamonhangaba", "Пиндамоньянгаба", "BR", "76", "27", "3538006", "", "", "-22.92389", "-45.46167", "America/Sao_Paulo"),
("3453896", "Pilar do Sul", "", "BR", "76", "27", "3537909", "", "", "-23.81306", "-47.71639", "America/Sao_Paulo"),
("3453926", "Piedade", "", "BR", "76", "27", "3537800", "", "", "-23.71194", "-47.42778", "America/Sao_Paulo"),
("3454031", "Petropolis", "Петрополис", "BR", "76", "21", "3303906", "", "", "-22.505", "-43.17861", "America/Sao_Paulo"),
("3454061", "Peruibe", "Перуиби", "BR", "76", "27", "3537602", "", "", "-24.32", "-46.99833", "America/Sao_Paulo"),
("3454131", "Pereira Barreto", "", "BR", "76", "27", "3537404", "", "", "-20.63833", "-51.10917", "America/Sao_Paulo"),
("3454139", "Perdoes", "", "BR", "76", "15", "3149903", "", "", "-21.09083", "-45.09139", "America/Sao_Paulo"),
("3454213", "Penha", "Пенья", "BR", "76", "26", "4212502", "", "", "-26.76944", "-48.64583", "America/Sao_Paulo"),
("3454231", "Penedo", "", "BR", "76", "02", "2706703", "", "", "-10.29028", "-36.58639", "America/Maceio"),
("3454235", "Penapolis", "Пенаполис", "BR", "76", "27", "3537305", "", "", "-21.41972", "-50.0775", "America/Sao_Paulo"),
("3454244", "Pelotas", "Пелотас", "BR", "76", "23", "4314407", "", "", "-31.77194", "-52.3425", "America/Sao_Paulo"),
("3454358", "Pedro Leopoldo", "", "BR", "76", "15", "3149309", "", "", "-19.61806", "-44.04306", "America/Sao_Paulo"),
("3454407", "Pedreira", "Педрейра", "BR", "76", "27", "3537107", "", "", "-22.74194", "-46.90139", "America/Sao_Paulo"),
("3454578", "Pedra Azul", "", "BR", "76", "15", "3148707", "", "", "-16.00528", "-41.29722", "America/Sao_Paulo"),
("3454620", "Pederneiras", "", "BR", "76", "27", "3536703", "", "", "-22.35167", "-48.775", "America/Sao_Paulo"),
("3454690", "Paulinia", "Паулиния", "BR", "76", "27", "3536505", "", "", "-22.76111", "-47.15417", "America/Sao_Paulo"),
("3454763", "Patrocinio", "Патросиниу", "BR", "76", "15", "3148103", "", "", "-18.94389", "-46.9925", "America/Sao_Paulo"),
("3454783", "Patos de Minas", "Патус-ди-Минас", "BR", "76", "15", "3148004", "", "", "-18.57889", "-46.51806", "America/Sao_Paulo"),
("3454818", "Pato Branco", "Пату-Бранку", "BR", "76", "18", "4118501", "", "", "-26.22861", "-52.67056", "America/Sao_Paulo"),
("3454827", "Paty do Alferes", "Пати-ду-Алферис", "BR", "76", "21", "3303856", "", "", "-22.42861", "-43.41861", "America/Sao_Paulo"),
("3454847", "Passos", "Пассос", "BR", "76", "15", "3147907", "", "", "-20.71889", "-46.60972", "America/Sao_Paulo"),
("3454857", "Passo Fundo", "Пасу-Фунду", "BR", "76", "23", "4314100", "", "", "-28.26278", "-52.40667", "America/Sao_Paulo"),
("3454954", "Parobe", "", "BR", "76", "23", "4314050", "", "", "-29.62861", "-50.83472", "America/Sao_Paulo"),
("3455036", "Paraty", "", "BR", "76", "21", "3303807", "", "", "-23.21778", "-44.71306", "America/Sao_Paulo"),
("3455051", "Paranavai", "", "BR", "76", "18", "4118402", "", "", "-23.07306", "-52.46528", "America/Sao_Paulo"),
("3455061", "Paranapanema", "", "BR", "76", "27", "3535804", "", "", "-23.3863", "-48.72441", "America/Sao_Paulo"),
("3455065", "Paranaiba", "Паранаиба", "BR", "76", "11", "5006309", "", "", "-19.67722", "-51.19083", "America/Campo_Grande"),
("3455070", "Paranagua", "Паранагуа", "BR", "76", "18", "4118204", "", "", "-25.51944", "-48.51992", "America/Sao_Paulo"),
("3455141", "Paraiba do Sul", "Параиба-ду-Сул", "BR", "76", "21", "3303708", "", "", "-22.16194", "-43.29278", "America/Sao_Paulo"),
("3455152", "Paraguacu Paulista", "", "BR", "76", "27", "3535507", "", "", "-22.41278", "-50.57583", "America/Sao_Paulo"),
("3455155", "Paraguacu", "", "BR", "76", "15", "3147204", "", "", "-21.54722", "-45.7375", "America/Sao_Paulo"),
("3455161", "Para de Minas", "Пара-ди-Минас", "BR", "76", "15", "3147105", "", "", "-19.86028", "-44.60833", "America/Sao_Paulo"),
("3455168", "Paracatu", "Паракату", "BR", "76", "15", "3147006", "", "", "-17.22222", "-46.87472", "America/Sao_Paulo"),
("3455170", "Paracambi", "", "BR", "76", "21", "3303609", "", "", "-22.60829", "-43.7084", "America/Sao_Paulo"),
("3455281", "Panambi", "", "BR", "76", "23", "4313904", "", "", "-28.2925", "-53.50167", "America/Sao_Paulo"),
("3455298", "Palotina", "", "BR", "76", "18", "4117909", "", "", "-24.28389", "-53.84", "America/Sao_Paulo"),
("3455342", "Palmital", "", "BR", "76", "27", "3535309", "", "", "-22.78889", "-50.2175", "America/Sao_Paulo"),
("3455416", "Palmeira das Missoes", "", "BR", "76", "23", "4313706", "", "", "-27.89944", "-53.31361", "America/Sao_Paulo"),
("3455425", "Palmeira", "", "BR", "76", "18", "4117701", "", "", "-25.42944", "-50.00639", "America/Sao_Paulo"),
("3455459", "Palmas", "Пальмас", "BR", "76", "18", "4117602", "", "", "-26.48417", "-51.99056", "America/Sao_Paulo"),
("3455478", "Palhoca", "Пальоса", "BR", "76", "26", "4211900", "", "", "-27.64528", "-48.66778", "America/Sao_Paulo"),
("3455553", "Paicandu", "", "BR", "76", "18", "4117503", "", "", "-23.4575", "-52.04861", "America/Sao_Paulo"),
("3455580", "Padre Bernardo", "", "BR", "76", "29", "5215603", "", "", "-15.16595", "-48.28281", "America/Sao_Paulo"),
("3455671", "Ouro Preto", "Ору-Прету", "BR", "76", "15", "3146107", "", "", "-20.39484", "-43.50517", "America/Sao_Paulo"),
("3455689", "Ouro Branco", "", "BR", "76", "15", "3145901", "", "", "-20.52083", "-43.69194", "America/Sao_Paulo"),
("3455729", "Ourinhos", "Ориньюс", "BR", "76", "27", "3534708", "", "", "-22.97889", "-49.87056", "America/Sao_Paulo"),
("3455756", "Osvaldo Cruz", "", "BR", "76", "27", "3534609", "", "", "-21.79667", "-50.87861", "America/Sao_Paulo"),
("3455769", "Osorio", "Осорио", "BR", "76", "23", "4313508", "", "", "-29.88667", "-50.26972", "America/Sao_Paulo"),
("3455775", "Osasco", "Осаску", "BR", "76", "27", "3534401", "", "", "-23.5325", "-46.79167", "America/Sao_Paulo"),
("3455784", "Orleans", "", "BR", "76", "26", "4211702", "", "", "-28.35889", "-49.29139", "America/Sao_Paulo"),
("3455785", "Orlandia", "", "BR", "76", "27", "3534302", "", "", "-20.72028", "-47.88667", "America/Sao_Paulo"),
("3455908", "Oliveira", "Оливейра", "BR", "76", "15", "3145604", "", "", "-20.69639", "-44.82722", "America/Sao_Paulo"),
("3455923", "Olimpia", "Олимпия", "BR", "76", "27", "3533908", "", "", "-20.73722", "-48.91472", "America/Sao_Paulo"),
("3456060", "Novo Horizonte", "", "BR", "76", "27", "3533502", "", "", "-21.46806", "-49.22083", "America/Sao_Paulo"),
("3456068", "Novo Hamburgo", "Нову-Амбургу", "BR", "76", "23", "4313409", "", "", "-29.67833", "-51.13056", "America/Sao_Paulo"),
("3456102", "Nova Vicosa", "", "BR", "76", "05", "2923001", "", "", "-17.89194", "-39.37194", "America/Bahia"),
("3456110", "Nova Venecia", "", "BR", "76", "08", "3203908", "", "", "-18.71056", "-40.40056", "America/Sao_Paulo"),
("3456125", "Nova Prata", "", "BR", "76", "23", "4313300", "", "", "-28.78389", "-51.61", "America/Sao_Paulo"),
("3456127", "Nova Petropolis", "", "BR", "76", "23", "4313201", "", "", "-29.37639", "-51.11444", "America/Sao_Paulo"),
("3456137", "Nova Olimpia", "", "BR", "76", "14", "5106232", "", "", "-14.79722", "-57.28806", "America/Cuiaba"),
("3456138", "Nova Odessa", "", "BR", "76", "27", "3533403", "", "", "-22.7775", "-47.29583", "America/Sao_Paulo"),
("3456147", "Nova Lima", "Нова-Лима", "BR", "76", "15", "3144805", "", "", "-19.98556", "-43.84667", "America/Sao_Paulo"),
("3456160", "Nova Iguacu", "Нова-Игуасу", "BR", "76", "21", "3303500", "", "", "-22.75917", "-43.45111", "America/Sao_Paulo"),
("3456164", "Nova Granada", "", "BR", "76", "27", "3533007", "", "", "-20.53389", "-49.31417", "America/Sao_Paulo"),
("3456166", "Nova Friburgo", "Нова-Фрибургу", "BR", "76", "21", "3303401", "", "", "-22.28194", "-42.53111", "America/Sao_Paulo"),
("3456176", "Nova Era", "", "BR", "76", "15", "3144706", "", "", "-19.75", "-43.0375", "America/Sao_Paulo"),
("3456223", "Nossa Senhora do Socorro", "", "BR", "76", "28", "2804805", "", "", "-10.855", "-37.12611", "America/Maceio"),
("3456240", "Nossa Senhora da Gloria", "", "BR", "76", "28", "2804508", "", "", "-10.21833", "-37.42028", "America/Maceio"),
("3456283", "Niteroi", "Нитерой", "BR", "76", "21", "3303302", "", "", "-22.88333", "-43.10361", "America/Sao_Paulo"),
("3456285", "Niquelandia", "Никеландия", "BR", "76", "29", "5214606", "", "", "-14.47389", "-48.45972", "America/Sao_Paulo"),
("3456290", "Nilopolis", "", "BR", "76", "21", "3303203", "", "", "-22.8075", "-43.41389", "America/Sao_Paulo"),
("3456322", "Neropolis", "Нерополис", "BR", "76", "29", "5214507", "", "", "-16.40639", "-49.21861", "America/Sao_Paulo"),
("3456324", "Nepomuceno", "", "BR", "76", "15", "3144607", "", "", "-21.23583", "-45.23583", "America/Sao_Paulo"),
("3456366", "Nazare", "Назар", "BR", "76", "05", "2922508", "", "", "-13.035", "-39.01444", "America/Bahia"),
("3456368", "Navirai", "Навираи", "BR", "76", "11", "5005707", "", "", "-23.065", "-54.19056", "America/Campo_Grande"),
("3456370", "Navegantes", "Навегантис", "BR", "76", "26", "4211306", "", "", "-26.89889", "-48.65417", "America/Sao_Paulo"),
("3456398", "Nanuque", "", "BR", "76", "15", "3144300", "", "", "-17.83917", "-40.35389", "America/Sao_Paulo"),
("3456412", "Muzambinho", "", "BR", "76", "15", "3144102", "", "", "-21.37583", "-46.52556", "America/Sao_Paulo"),
("3456483", "Muritiba", "", "BR", "76", "05", "2908309", "", "", "-12.91667", "-39.25", "America/Bahia"),
("3456500", "Muriae", "Муриаэ", "BR", "76", "15", "3143906", "", "", "-21.13056", "-42.36639", "America/Sao_Paulo"),
("3456593", "Mucuri", "Мукури", "BR", "76", "05", "2922003", "", "", "-18.08639", "-39.55083", "America/Bahia"),
("3456696", "Morro do Chapeu", "", "BR", "76", "05", "2921708", "", "", "-11.54852", "-41.15804", "America/Bahia"),
("3456724", "Morro Agudo", "", "BR", "76", "27", "3531902", "", "", "-20.73139", "-48.05778", "America/Sao_Paulo"),
("3456735", "Morrinhos", "", "BR", "76", "29", "5213806", "", "", "-17.73111", "-49.09944", "America/Sao_Paulo"),
("3456814", "Montes Claros", "Монтис-Кларус", "BR", "76", "15", "3143302", "", "", "-16.735", "-43.86167", "America/Sao_Paulo"),
("3456816", "Monte Santo de Minas", "", "BR", "76", "15", "3143203", "", "", "-21.18972", "-46.98028", "America/Sao_Paulo"),
("3456826", "Montenegro", "Черногория", "BR", "76", "23", "4312401", "", "", "-29.68861", "-51.46111", "America/Sao_Paulo"),
("3456827", "Monte Mor", "", "BR", "76", "27", "3531803", "", "", "-22.94667", "-47.31583", "America/Sao_Paulo"),
("3456848", "Monte Carmelo", "", "BR", "76", "15", "3143104", "", "", "-18.72472", "-47.49861", "America/Sao_Paulo"),
("3456863", "Monte Azul Paulista", "", "BR", "76", "27", "3531506", "", "", "-20.90722", "-48.64139", "America/Sao_Paulo"),
("3456866", "Monte Aprazivel", "", "BR", "76", "27", "3531407", "", "", "-20.7725", "-49.71417", "America/Sao_Paulo"),
("3456873", "Monte Alto", "", "BR", "76", "27", "3531308", "", "", "-21.26111", "-48.49639", "America/Sao_Paulo"),
("3456944", "Mongagua", "", "BR", "76", "27", "3531100", "", "", "-24.09306", "-46.62083", "America/Sao_Paulo"),
("3456998", "Mogi Mirim", "Можи-Мирин", "BR", "76", "27", "3530805", "", "", "-22.43194", "-46.95778", "America/Sao_Paulo"),
("3457000", "Mogi Guacu", "Можи-Гуасу", "BR", "76", "27", "3530706", "", "", "-22.36742", "-46.94389", "America/Sao_Paulo"),
("3457001", "Mogi das Cruzes", "", "BR", "76", "27", "3530607", "", "", "-23.52278", "-46.18833", "America/Sao_Paulo"),
("3457025", "Mococa", "", "BR", "76", "27", "3530508", "", "", "-21.46778", "-47.00472", "America/Sao_Paulo"),
("3457107", "Mirandopolis", "Мирандополис", "BR", "76", "27", "3530102", "", "", "-21.13361", "-51.10167", "America/Sao_Paulo"),
("3457133", "Miracema", "Мирасема", "BR", "76", "21", "3303005", "", "", "-21.41222", "-42.19667", "America/Sao_Paulo"),
("3457147", "Mineiros", "", "BR", "76", "29", "5213103", "", "", "-17.56944", "-52.55111", "America/Sao_Paulo"),
("3457191", "Miguel Pereira", "", "BR", "76", "21", "3302908", "", "", "-22.45389", "-43.46889", "America/Sao_Paulo"),
("3457192", "Miguelopolis", "", "BR", "76", "27", "3529708", "", "", "-20.17944", "-48.03194", "America/Sao_Paulo"),
("3457247", "Mendes", "", "BR", "76", "21", "3302809", "", "", "-22.52667", "-43.73278", "America/Sao_Paulo"),
("3457359", "Medianeira", "Медианейра", "BR", "76", "18", "4115804", "", "", "-25.29528", "-54.09389", "America/Sao_Paulo"),
("3457360", "Medeiros Neto", "", "BR", "76", "05", "2921104", "", "", "-17.37389", "-40.22056", "America/Bahia"),
("3457381", "Maua", "", "BR", "76", "27", "3529401", "", "", "-23.66778", "-46.46139", "America/Sao_Paulo"),
("3457393", "Matozinhos", "", "BR", "76", "15", "3141108", "", "", "-19.55778", "-44.08139", "America/Sao_Paulo"),
("3457484", "Mateus Leme", "", "BR", "76", "15", "3140704", "", "", "-19.98639", "-44.42778", "America/Sao_Paulo"),
("3457509", "Matao", "", "BR", "76", "27", "3529302", "", "", "-21.60333", "-48.36583", "America/Sao_Paulo"),
("3457528", "Mata de Sao Joao", "Мата-де-Сан-Жуан", "BR", "76", "05", "2921005", "", "", "-12.53028", "-38.29917", "America/Bahia"),
("3457566", "Mascote", "", "BR", "76", "05", "2920908", "", "", "-15.56306", "-39.3025", "America/Bahia"),
("3457595", "Martinopolis", "", "BR", "76", "27", "3529203", "", "", "-22.14583", "-51.17083", "America/Sao_Paulo"),
("3457671", "Maringa", "Маринга", "BR", "76", "18", "4115200", "", "", "-23.42528", "-51.93861", "America/Sao_Paulo"),
("3457692", "Marilia", "Марилья", "BR", "76", "27", "3529005", "", "", "-22.21389", "-49.94583", "America/Sao_Paulo"),
("3457708", "Marica", "", "BR", "76", "21", "3302700", "", "", "-22.91944", "-42.81861", "America/Sao_Paulo"),
("3457736", "Mariana", "Мариана", "BR", "76", "15", "3140001", "", "", "-20.37778", "-43.41611", "America/Sao_Paulo"),
("3457741", "Marialva", "", "BR", "76", "18", "4114807", "", "", "-23.485", "-51.79167", "America/Sao_Paulo"),
("3457772", "Marechal Candido Rondon", "", "BR", "76", "18", "4114609", "", "", "-24.55611", "-54.05667", "America/Sao_Paulo"),
("3457817", "Marau", "", "BR", "76", "23", "4311809", "", "", "-28.44917", "-52.2", "America/Sao_Paulo"),
("3457819", "Marataizes", "", "BR", "76", "08", "3203320", "", "", "-21.04333", "-40.82444", "America/Sao_Paulo"),
("3457850", "Maragogipe", "", "BR", "76", "05", "2920601", "", "", "-12.77778", "-38.91944", "America/Bahia"),
("3457854", "Maracas", "", "BR", "76", "05", "2920502", "", "", "-13.44111", "-40.43083", "America/Bahia"),
("3457859", "Maracaju", "", "BR", "76", "11", "5005400", "", "", "-21.61444", "-55.16833", "America/Campo_Grande"),
("3457950", "Manhumirim", "", "BR", "76", "15", "3139508", "", "", "-20.35778", "-41.95806", "America/Sao_Paulo"),
("3457952", "Manhuacu", "Маньюасу", "BR", "76", "15", "3139409", "", "", "-20.25806", "-42.03361", "America/Sao_Paulo"),
("3457991", "Mangaratiba", "", "BR", "76", "21", "3302601", "", "", "-22.95972", "-44.04056", "America/Sao_Paulo"),
("3458049", "Mandaguari", "", "BR", "76", "18", "4114203", "", "", "-23.5475", "-51.67083", "America/Sao_Paulo"),
("3458131", "Mairipora", "Майрипоран", "BR", "76", "27", "3528502", "", "", "-23.31861", "-46.58667", "America/Sao_Paulo"),
("3458132", "Mairinque", "Майринки", "BR", "76", "27", "3528403", "", "", "-23.54583", "-47.18333", "America/Sao_Paulo"),
("3458147", "Mafra", "Мафре", "BR", "76", "26", "4210100", "", "", "-26.11139", "-49.80528", "America/Sao_Paulo"),
("3458211", "Machado", "", "BR", "76", "15", "3139003", "", "", "-21.67472", "-45.91972", "America/Sao_Paulo"),
("3458245", "Macatuba", "", "BR", "76", "27", "3528007", "", "", "-22.50222", "-48.71139", "America/Sao_Paulo"),
("3458266", "Macae", "Макаэ", "BR", "76", "21", "3302403", "", "", "-22.37083", "-41.78694", "America/Sao_Paulo"),
("3458329", "Luziania", "", "BR", "76", "29", "5212501", "", "", "-16.2525", "-47.95028", "America/Sao_Paulo"),
("3458397", "Lucas", "Лукас", "BR", "76", "14", "5101605", "", "", "-16.33333", "-55.93333", "America/Cuiaba"),
("3458406", "Louveira", "", "BR", "76", "27", "3527306", "", "", "-23.08639", "-46.95056", "America/Sao_Paulo"),
("3458425", "Lorena", "", "BR", "76", "27", "3527207", "", "", "-22.73083", "-45.12472", "America/Sao_Paulo"),
("3458449", "Londrina", "Лондрина", "BR", "76", "18", "4113700", "", "", "-23.31028", "-51.16278", "America/Sao_Paulo"),
("3458479", "Loanda", "", "BR", "76", "18", "4113502", "", "", "-22.92306", "-53.13722", "America/Sao_Paulo"),
("3458481", "Livramento do Brumado", "", "BR", "76", "05", "2919504", "", "", "-13.64306", "-41.84056", "America/Bahia"),
("3458494", "Lins", "Линс", "BR", "76", "27", "3527108", "", "", "-21.67861", "-49.7425", "America/Sao_Paulo"),
("3458498", "Linhares", "", "BR", "76", "08", "3203205", "", "", "-19.39111", "-40.07222", "America/Sao_Paulo"),
("3458575", "Limeira", "Лимейра", "BR", "76", "27", "3526902", "", "", "-22.56472", "-47.40167", "America/Sao_Paulo"),
("3458632", "Leopoldina", "", "BR", "76", "15", "3138401", "", "", "-21.53194", "-42.64306", "America/Sao_Paulo"),
("3458645", "Lencois Paulista", "", "BR", "76", "27", "3526803", "", "", "-22.59861", "-48.80028", "America/Sao_Paulo"),
("3458662", "Leme", "Лем", "BR", "76", "27", "3526704", "", "", "-22.18556", "-47.39028", "America/Sao_Paulo"),
("3458696", "Lavras", "Лаврас", "BR", "76", "15", "3138203", "", "", "-21.24528", "-44.99972", "America/Sao_Paulo"),
("3458746", "Laranjeiras do Sul", "", "BR", "76", "18", "4113304", "", "", "-25.40778", "-52.41611", "America/Sao_Paulo"),
("3458778", "Laranjeiras", "", "BR", "76", "28", "2803609", "", "", "-10.80639", "-37.17", "America/Maceio"),
("3458786", "Laranjal Paulista", "", "BR", "76", "27", "3526407", "", "", "-23.04972", "-47.83667", "America/Sao_Paulo"),
("3458826", "Lapa", "", "BR", "76", "18", "4113205", "", "", "-25.76972", "-49.71583", "America/Sao_Paulo"),
("3458902", "Lajinha", "", "BR", "76", "15", "3137700", "", "", "-20.15139", "-41.62278", "America/Sao_Paulo"),
("3458930", "Lages", "Лажис", "BR", "76", "26", "4209300", "", "", "-27.81611", "-50.32611", "America/Sao_Paulo"),
("3459035", "Lajeado", "", "BR", "76", "23", "4311403", "", "", "-29.46694", "-51.96139", "America/Sao_Paulo"),
("3459094", "Laguna", "Лагуна", "BR", "76", "26", "4209409", "", "", "-28.4825", "-48.78083", "America/Sao_Paulo"),
("3459126", "Lagoa Vermelha", "", "BR", "76", "23", "4311304", "", "", "-28.20861", "-51.52583", "America/Sao_Paulo"),
("3459138", "Lagoa Santa", "", "BR", "76", "15", "3137601", "", "", "-19.62722", "-43.88972", "America/Sao_Paulo"),
("3459251", "Lagoa da Prata", "", "BR", "76", "15", "3137205", "", "", "-20.0225", "-45.54361", "America/Sao_Paulo"),
("3459342", "Lagarto", "", "BR", "76", "28", "2803500", "", "", "-10.91722", "-37.65", "America/Maceio"),
("3459352", "Ladario", "", "BR", "76", "11", "5005202", "", "", "-19.00472", "-57.60167", "America/Campo_Grande"),
("3459462", "Jundiai", "Жундиаи", "BR", "76", "27", "3525904", "", "", "-23.18639", "-46.88417", "America/Sao_Paulo"),
("3459495", "Julio de Castilhos", "", "BR", "76", "23", "4311205", "", "", "-29.22694", "-53.68167", "America/Sao_Paulo"),
("3459505", "Juiz de Fora", "Жуис-ди-Фора", "BR", "76", "15", "3136702", "", "", "-21.76417", "-43.35028", "America/Sao_Paulo"),
("3459550", "Juatuba", "", "BR", "76", "15", "3136652", "", "", "-19.95194", "-44.34278", "America/Sao_Paulo"),
("3459667", "Jose Bonifacio", "", "BR", "76", "27", "3525706", "", "", "-21.05278", "-49.68833", "America/Sao_Paulo"),
("3459712", "Joinville", "Жоинвили", "BR", "76", "26", "4209102", "", "", "-26.30444", "-48.84556", "America/Sao_Paulo"),
("3459785", "Joao Pinheiro", "", "BR", "76", "15", "3136306", "", "", "-17.7425", "-46.1725", "America/Sao_Paulo"),
("3459796", "Joao Monlevade", "Жуан-Монлевади", "BR", "76", "15", "3136207", "", "", "-19.81", "-43.17361", "America/Sao_Paulo"),
("3459869", "Joacaba", "Жоасаба", "BR", "76", "26", "4209003", "", "", "-27.17806", "-51.50472", "America/Sao_Paulo"),
("3459922", "Jeremoabo", "", "BR", "76", "05", "2918100", "", "", "-10.075", "-38.48083", "America/Bahia"),
("3459925", "Jequitinhonha", "", "BR", "76", "15", "3135803", "", "", "-16.43389", "-41.00333", "America/Sao_Paulo"),
("3459943", "Jequie", "Жекие", "BR", "76", "05", "2918001", "", "", "-13.8575", "-40.08361", "America/Bahia"),
("3460005", "Jau", "Жау", "BR", "76", "27", "3525300", "", "", "-22.29639", "-48.55778", "America/Sao_Paulo"),
("3460064", "Jatai", "", "BR", "76", "29", "5211909", "", "", "-17.88139", "-51.71444", "America/Sao_Paulo"),
("3460068", "Jarinu", "", "BR", "76", "27", "3525201", "", "", "-23.10139", "-46.72833", "America/Sao_Paulo"),
("3460071", "Jardinopolis", "", "BR", "76", "27", "3525102", "", "", "-21.01778", "-47.76389", "America/Sao_Paulo"),
("3460087", "Jardim", "", "BR", "76", "11", "5005004", "", "", "-21.48028", "-56.13806", "America/Campo_Grande"),
("3460102", "Jaragua do Sul", "Жарагуа-ду-Сул", "BR", "76", "26", "4208906", "", "", "-26.48611", "-49.06667", "America/Sao_Paulo"),
("3460107", "Jaragua", "", "BR", "76", "29", "5211800", "", "", "-15.75694", "-49.33444", "America/Sao_Paulo"),
("3460132", "Japeri", "", "BR", "76", "21", "3302270", "", "", "-22.64306", "-43.65333", "America/Sao_Paulo"),
("3460148", "Januaria", "", "BR", "76", "15", "3135209", "", "", "-15.48866", "-44.35988", "America/Sao_Paulo"),
("3460170", "Jandira", "", "BR", "76", "27", "3525003", "", "", "-23.5275", "-46.9025", "America/Sao_Paulo"),
("3460172", "Jandaia do Sul", "", "BR", "76", "18", "4112108", "", "", "-23.60306", "-51.64333", "America/Sao_Paulo"),
("3460174", "Janauba", "", "BR", "76", "15", "3135100", "", "", "-15.8025", "-43.30889", "America/Sao_Paulo"),
("3460186", "Jales", "", "BR", "76", "27", "3524808", "", "", "-20.26889", "-50.54583", "America/Sao_Paulo"),
("3460200", "Jaguariuna", "", "BR", "76", "27", "3524709", "", "", "-22.70556", "-46.98583", "America/Sao_Paulo"),
("3460214", "Jaguariaiva", "", "BR", "76", "18", "4112009", "", "", "-24.25111", "-49.70583", "America/Sao_Paulo"),
("3460225", "Jaguarari", "", "BR", "76", "05", "2917706", "", "", "-10.26389", "-40.19583", "America/Bahia"),
("3460232", "Jaguarao", "", "BR", "76", "23", "4311007", "", "", "-32.56611", "-53.37583", "America/Sao_Paulo"),
("3460242", "Jaguaquara", "", "BR", "76", "05", "2917607", "", "", "-13.53056", "-39.97083", "America/Bahia"),
("3460267", "Jacutinga", "", "BR", "76", "15", "3134905", "", "", "-22.28556", "-46.61222", "America/Sao_Paulo"),
("3460344", "Jacobina", "", "BR", "76", "05", "2917508", "", "", "-11.18056", "-40.51833", "America/Bahia"),
("3460355", "Jaciara", "", "BR", "76", "14", "5104807", "", "", "-15.96528", "-54.96833", "America/Cuiaba"),
("3460362", "Jacarezinho", "Жакарезинью", "BR", "76", "18", "4111803", "", "", "-23.16056", "-49.96944", "America/Sao_Paulo"),
("3460370", "Jacarei", "Жакареи", "BR", "76", "27", "3524402", "", "", "-23.30528", "-45.96583", "America/Sao_Paulo"),
("3460441", "Jaboticabal", "Жаботикабал", "BR", "76", "27", "3524303", "", "", "-21.25472", "-48.32222", "America/Sao_Paulo"),
("3460484", "Ivoti", "", "BR", "76", "23", "4310801", "", "", "-29.59111", "-51.16056", "America/Sao_Paulo"),
("3460511", "Ituverava", "", "BR", "76", "27", "3524105", "", "", "-20.33944", "-47.78056", "America/Sao_Paulo"),
("3460513", "Iturama", "Итурама", "BR", "76", "15", "3134400", "", "", "-19.72806", "-50.19556", "America/Sao_Paulo"),
("3460516", "Itupeva", "", "BR", "76", "27", "3524006", "", "", "-23.15306", "-47.05778", "America/Sao_Paulo"),
("3460522", "Itumbiara", "Итумбиара", "BR", "76", "29", "5211503", "", "", "-18.41917", "-49.21528", "America/Sao_Paulo"),
("3460523", "Ituiutaba", "Итиютаба", "BR", "76", "15", "3134202", "", "", "-18.96889", "-49.465", "America/Sao_Paulo"),
("3460530", "Itubera", "", "BR", "76", "05", "2917300", "", "", "-13.73222", "-39.14917", "America/Bahia"),
("3460535", "Itu", "Иту", "BR", "76", "27", "3523909", "", "", "-23.26417", "-47.29917", "America/Sao_Paulo"),
("3460542", "Itororo", "", "BR", "76", "05", "2917102", "", "", "-15.11694", "-40.07028", "America/Bahia"),
("3460584", "Itauna", "", "BR", "76", "15", "3133808", "", "", "-20.07528", "-44.57639", "America/Sao_Paulo"),
("3460594", "Itatinga", "", "BR", "76", "27", "3523503", "", "", "-23.10167", "-48.61583", "America/Sao_Paulo"),
("3460598", "Itatiba", "", "BR", "76", "27", "3523404", "", "", "-23.00583", "-46.83889", "America/Sao_Paulo"),
("3460620", "Itarare", "Итараре", "BR", "76", "27", "3523206", "", "", "-24.1125", "-49.33167", "America/Sao_Paulo"),
("3460629", "Itaqui", "Итака", "BR", "76", "23", "4310603", "", "", "-29.12528", "-56.55306", "America/Sao_Paulo"),
("3460644", "Itaquaquecetuba", "", "BR", "76", "27", "3523107", "", "", "-23.48611", "-46.34833", "America/Sao_Paulo"),
("3460648", "Itapuranga", "", "BR", "76", "29", "5211206", "", "", "-15.56222", "-49.94861", "America/Sao_Paulo"),
("3460671", "Itapolis", "", "BR", "76", "27", "3522703", "", "", "-21.59556", "-48.81278", "America/Sao_Paulo"),
("3460699", "Itapira", "", "BR", "76", "27", "3522604", "", "", "-22.43611", "-46.82167", "America/Sao_Paulo"),
("3460718", "Itapevi", "", "BR", "76", "27", "3522505", "", "", "-23.54889", "-46.93417", "America/Sao_Paulo"),
("3460723", "Itapeva", "", "BR", "76", "27", "3522406", "", "", "-23.98222", "-48.87556", "America/Sao_Paulo"),
("3460728", "Itapetininga", "Итапетининга", "BR", "76", "27", "3522307", "", "", "-23.59167", "-48.05306", "America/Sao_Paulo"),
("3460730", "Itapetinga", "", "BR", "76", "05", "2916401", "", "", "-15.24889", "-40.24778", "America/Bahia"),
("3460733", "Itaperuna", "", "BR", "76", "21", "3302205", "", "", "-21.205", "-41.88778", "America/Sao_Paulo"),
("3460734", "Itaperucu", "", "BR", "76", "18", "4111258", "", "", "-25.22", "-49.34778", "America/Sao_Paulo"),
("3460738", "Itapemirim", "", "BR", "76", "08", "3202801", "", "", "-21.01111", "-40.83389", "America/Sao_Paulo"),
("3460740", "Itapema", "Итапема", "BR", "76", "26", "4208302", "", "", "-27.09028", "-48.61139", "America/Sao_Paulo"),
("3460748", "Itapecerica da Serra", "Итапесерика-да-Серра", "BR", "76", "27", "3522208", "", "", "-23.71694", "-46.84917", "America/Sao_Paulo"),
("3460752", "Itapecerica", "", "BR", "76", "15", "3133501", "", "", "-20.4725", "-45.12556", "America/Sao_Paulo"),
("3460764", "Itaparica", "", "BR", "76", "05", "2916104", "", "", "-12.88833", "-38.67861", "America/Bahia"),
("3460773", "Itapaci", "", "BR", "76", "29", "5210901", "", "", "-14.95083", "-49.54944", "America/Sao_Paulo"),
("3460774", "Itaocara", "", "BR", "76", "21", "3302106", "", "", "-21.66917", "-42.07611", "America/Sao_Paulo"),
("3460791", "Itanhaem", "", "BR", "76", "27", "3522109", "", "", "-24.18306", "-46.78889", "America/Sao_Paulo"),
("3460813", "Itambe", "", "BR", "76", "05", "2915809", "", "", "-15.245", "-40.62444", "America/Bahia"),
("3460825", "Itamarandiba", "", "BR", "76", "15", "3132503", "", "", "-17.85722", "-42.85889", "America/Sao_Paulo"),
("3460826", "Itamaraju", "", "BR", "76", "05", "2915601", "", "", "-17.03917", "-39.53111", "America/Bahia"),
("3460831", "Itajuipe", "", "BR", "76", "05", "2915502", "", "", "-14.67806", "-39.375", "America/Bahia"),
("3460834", "Itajuba", "Итажуба", "BR", "76", "15", "3132404", "", "", "-22.42556", "-45.45278", "America/Sao_Paulo"),
("3460845", "Itajai", "Итажаи", "BR", "76", "26", "4208203", "", "", "-26.90778", "-48.66194", "America/Sao_Paulo"),
("3460887", "Itai", "", "BR", "76", "27", "3521804", "", "", "-23.41778", "-49.09056", "America/Sao_Paulo"),
("3460899", "Itaguai", "Итагуаи", "BR", "76", "21", "3302007", "", "", "-22.85222", "-43.77528", "America/Sao_Paulo"),
("3460949", "Itabuna", "Итабуна", "BR", "76", "05", "2914802", "", "", "-14.78556", "-39.28028", "America/Bahia"),
("3460950", "Itaborai", "", "BR", "76", "21", "3301900", "", "", "-22.74444", "-42.85944", "America/Sao_Paulo"),
("3460954", "Itabirito", "", "BR", "76", "15", "3131901", "", "", "-20.25333", "-43.80139", "America/Sao_Paulo"),
("3460960", "Itabira", "Итабира", "BR", "76", "15", "3131703", "", "", "-19.61917", "-43.22694", "America/Sao_Paulo"),
("3460963", "Itaberai", "Итабераи", "BR", "76", "29", "5210406", "", "", "-16.02028", "-49.81028", "America/Sao_Paulo"),
("3460966", "Itaberaba", "", "BR", "76", "05", "2914703", "", "", "-12.5275", "-40.30694", "America/Bahia"),
("3460971", "Itabaianinha", "", "BR", "76", "28", "2803005", "", "", "-11.27389", "-37.79", "America/Maceio"),
("3460974", "Itabaiana", "", "BR", "76", "28", "2802908", "", "", "-10.685", "-37.42528", "America/Maceio"),
("3461013", "Irece", "", "BR", "76", "05", "2914604", "", "", "-11.30417", "-41.85583", "America/Bahia"),
("3461017", "Irati", "", "BR", "76", "18", "4110706", "", "", "-25.46722", "-50.65111", "America/Sao_Paulo"),
("3461055", "Iracemapolis", "", "BR", "76", "27", "3521408", "", "", "-22.58056", "-47.51861", "America/Sao_Paulo"),
("3461090", "Ipora", "Ипора", "BR", "76", "29", "5210208", "", "", "-16.44194", "-51.11778", "America/Sao_Paulo"),
("3461124", "Ipira", "", "BR", "76", "05", "2914000", "", "", "-12.15833", "-39.73722", "America/Bahia"),
("3461129", "Ipiau", "Ипиау", "BR", "76", "05", "2913903", "", "", "-14.13341", "-39.73708", "America/Bahia"),
("3461134", "Ipero", "", "BR", "76", "27", "3521002", "", "", "-23.35028", "-47.68861", "America/Sao_Paulo"),
("3461144", "Ipatinga", "Ипатинга", "BR", "76", "15", "3131307", "", "", "-19.46833", "-42.53667", "America/Sao_Paulo"),
("3461151", "Ipameri", "", "BR", "76", "29", "5210109", "", "", "-17.72194", "-48.15972", "America/Sao_Paulo"),
("3461153", "Ipaba", "", "BR", "76", "15", "3131158", "", "", "-19.41361", "-42.41944", "America/Sao_Paulo"),
("3461194", "Inhumas", "", "BR", "76", "29", "5210000", "", "", "-16.35778", "-49.49611", "America/Sao_Paulo"),
("3461311", "Indaiatuba", "Индаятуба", "BR", "76", "27", "3520509", "", "", "-23.08842", "-47.2119", "America/Sao_Paulo"),
("3461316", "Indaial", "", "BR", "76", "26", "4207502", "", "", "-26.89778", "-49.23167", "America/Sao_Paulo"),
("3461368", "Imbituva", "", "BR", "76", "18", "4110102", "", "", "-25.23", "-50.60444", "America/Sao_Paulo"),
("3461370", "Imbituba", "", "BR", "76", "26", "4207304", "", "", "-28.24", "-48.67028", "America/Sao_Paulo"),
("3461408", "Ilheus", "Ильеус", "BR", "76", "05", "2913606", "", "", "-14.79364", "-39.03949", "America/Bahia"),
("3461411", "Ilha Solteira", "Илья-Солтейра", "BR", "76", "27", "3520442", "", "", "-20.43278", "-51.3425", "America/Sao_Paulo"),
("3461425", "Ilhabela", "", "BR", "76", "27", "3520400", "", "", "-23.77806", "-45.35806", "America/Sao_Paulo"),
("3461444", "Ijui", "Ижуи", "BR", "76", "23", "4310207", "", "", "-28.38778", "-53.91472", "America/Sao_Paulo"),
("3461465", "Iguape", "Игуапи", "BR", "76", "27", "3520301", "", "", "-24.70806", "-47.55528", "America/Sao_Paulo"),
("3461481", "Igrejinha", "Игрежинья", "BR", "76", "23", "4310108", "", "", "-29.57444", "-50.79028", "America/Sao_Paulo"),
("3461498", "Igarape", "", "BR", "76", "15", "3130101", "", "", "-20.07028", "-44.30167", "America/Sao_Paulo"),
("3461499", "Igarapava", "", "BR", "76", "27", "3520103", "", "", "-20.03833", "-47.74694", "America/Sao_Paulo"),
("3461501", "Igaracu do Tiete", "", "BR", "76", "27", "3520004", "", "", "-22.50917", "-48.55778", "America/Sao_Paulo"),
("3461519", "Icara", "Исара", "BR", "76", "26", "4207007", "", "", "-28.71333", "-49.3", "America/Sao_Paulo"),
("3461525", "Ibotirama", "", "BR", "76", "05", "2913200", "", "", "-12.18528", "-43.22056", "America/Bahia"),
("3461528", "Ibiuna", "", "BR", "76", "27", "3519709", "", "", "-23.65639", "-47.2225", "America/Sao_Paulo"),
("3461550", "Ibitinga", "", "BR", "76", "27", "3519600", "", "", "-21.75778", "-48.82889", "America/Sao_Paulo"),
("3461563", "Ibirite", "Ибирите", "BR", "76", "15", "3129806", "", "", "-20.02194", "-44.05889", "America/Sao_Paulo"),
("3461565", "Ibirataia", "", "BR", "76", "05", "2912905", "", "", "-14.06694", "-39.64056", "America/Bahia"),
("3461576", "Ibirama", "", "BR", "76", "26", "4206900", "", "", "-27.05694", "-49.51778", "America/Sao_Paulo"),
("3461588", "Ibipora", "", "BR", "76", "18", "4109807", "", "", "-23.26917", "-51.04806", "America/Sao_Paulo"),
("3461606", "Ibicarai", "", "BR", "76", "05", "2912103", "", "", "-14.865", "-39.5875", "America/Bahia"),
("3461620", "Ibia", "", "BR", "76", "15", "3129509", "", "", "-19.47833", "-46.53889", "America/Sao_Paulo"),
("3461625", "Ibate", "", "BR", "76", "27", "3519303", "", "", "-21.95472", "-47.99667", "America/Sao_Paulo"),
("3461628", "Ibaiti", "", "BR", "76", "18", "4109708", "", "", "-23.84861", "-50.18778", "America/Sao_Paulo"),
("3461638", "Iacu", "", "BR", "76", "05", "2911907", "", "", "-12.76722", "-40.21167", "America/Bahia"),
("3461655", "Hortolandia", "Ортоландия", "BR", "76", "27", "3519071", "", "", "-22.85833", "-47.22", "America/Sao_Paulo"),
("3461680", "Herval", "", "BR", "76", "23", "4307104", "", "", "-32.02361", "-53.39556", "America/Sao_Paulo"),
("3461724", "Gurupi", "Гурупи", "BR", "76", "31", "1709500", "", "", "-11.72917", "-49.06861", "America/Araguaina"),
("3461763", "Guaxupe", "", "BR", "76", "15", "3128709", "", "", "-21.30528", "-46.71278", "America/Sao_Paulo"),
("3461786", "Guarulhos", "", "BR", "76", "27", "3518800", "", "", "-23.46278", "-46.53333", "America/Sao_Paulo"),
("3461789", "Guaruja", "Гуаружа", "BR", "76", "27", "3518701", "", "", "-23.99306", "-46.25639", "America/Sao_Paulo"),
("3461824", "Guariba", "", "BR", "76", "27", "3518602", "", "", "-21.36", "-48.22833", "America/Sao_Paulo"),
("3461857", "Guaratuba", "", "BR", "76", "18", "4109609", "", "", "-25.88278", "-48.57472", "America/Sao_Paulo"),
("3461859", "Guaratingueta", "Гуаратингета", "BR", "76", "27", "3518404", "", "", "-22.81639", "-45.1925", "America/Sao_Paulo"),
("3461871", "Guararema", "", "BR", "76", "27", "3518305", "", "", "-23.415", "-46.035", "America/Sao_Paulo"),
("3461874", "Guararapes", "", "BR", "76", "27", "3518206", "", "", "-21.26083", "-50.64278", "America/Sao_Paulo"),
("3461879", "Guarapuava", "Гуарапуава", "BR", "76", "18", "4109401", "", "", "-25.39528", "-51.45806", "America/Sao_Paulo"),
("3461888", "Guarapari", "Гуарапари", "BR", "76", "08", "3202405", "", "", "-20.65367", "-40.50204", "America/Sao_Paulo"),
("3461910", "Guaranesia", "", "BR", "76", "15", "3128303", "", "", "-21.29917", "-46.8025", "America/Sao_Paulo"),
("3461914", "Guaramirim", "", "BR", "76", "26", "4206504", "", "", "-26.47306", "-49.00278", "America/Sao_Paulo"),
("3461935", "Guara", "", "BR", "76", "27", "3517703", "", "", "-20.42833", "-47.82417", "America/Sao_Paulo"),
("3461941", "Guapore", "", "BR", "76", "23", "4309407", "", "", "-28.84556", "-51.89028", "America/Sao_Paulo"),
("3461949", "Guapimirim", "Гуапимирин", "BR", "76", "21", "3301850", "", "", "-22.53722", "-42.98194", "America/Sao_Paulo"),
("3461958", "Guanhaes", "", "BR", "76", "15", "3128006", "", "", "-18.775", "-42.9325", "America/Sao_Paulo"),
("3461973", "Guanambi", "", "BR", "76", "05", "2911709", "", "", "-14.22333", "-42.78139", "America/Bahia"),
("3461995", "Guaira", "Гуайра", "BR", "76", "27", "3517406", "", "", "-20.31833", "-48.31056", "America/Sao_Paulo"),
("3462022", "Guacui", "", "BR", "76", "08", "3202306", "", "", "-20.77556", "-41.67944", "America/Sao_Paulo"),
("3462089", "Gravatai", "Граватаи", "BR", "76", "23", "4309209", "", "", "-29.94444", "-50.99194", "America/Sao_Paulo"),
("3462315", "Governador Valadares", "Говернадор-Валадарес", "BR", "76", "15", "3127701", "", "", "-18.85111", "-41.94944", "America/Sao_Paulo"),
("3462371", "Goiatuba", "Гоятуба", "BR", "76", "29", "5209101", "", "", "-18.0125", "-49.35472", "America/Sao_Paulo"),
("3462374", "Goias", "", "BR", "76", "29", "5208905", "", "", "-15.93444", "-50.14028", "America/Sao_Paulo"),
("3462376", "Goianira", "Гоянира", "BR", "76", "29", "5208806", "", "", "-16.49611", "-49.42639", "America/Sao_Paulo"),
("3462377", "Goiania", "Гояния", "BR", "76", "29", "5208707", "", "", "-16.67861", "-49.25389", "America/Sao_Paulo"),
("3462378", "Goianesia", "", "BR", "76", "29", "5208608", "", "", "-15.3175", "-49.1175", "America/Sao_Paulo"),
("3462535", "Gaspar", "", "BR", "76", "26", "4205902", "", "", "-26.93139", "-48.95889", "America/Sao_Paulo"),
("3462557", "Garibaldi", "", "BR", "76", "23", "4308607", "", "", "-29.25611", "-51.53361", "America/Sao_Paulo"),
("3462580", "Garca", "", "BR", "76", "27", "3516705", "", "", "-22.21056", "-49.65611", "America/Sao_Paulo"),
("3462601", "Gandu", "", "BR", "76", "05", "2911204", "", "", "-13.74389", "-39.48667", "America/Bahia"),
("3462916", "Frutal", "Фрутал", "BR", "76", "15", "3127107", "", "", "-20.02472", "-48.94056", "America/Sao_Paulo"),
("3462956", "Frederico Westphalen", "", "BR", "76", "23", "4308508", "", "", "-27.35917", "-53.39444", "America/Sao_Paulo"),
("3462964", "Franco da Rocha", "", "BR", "76", "27", "3516408", "", "", "-23.32167", "-46.72694", "America/Sao_Paulo"),
("3462980", "Francisco Morato", "", "BR", "76", "27", "3516309", "", "", "-23.28167", "-46.74528", "America/Sao_Paulo"),
("3462996", "Francisco Beltrao", "Белтран-Франциско", "BR", "76", "18", "4108403", "", "", "-26.08111", "-53.055", "America/Sao_Paulo"),
("3463011", "Franca", "Франко", "BR", "76", "27", "3516200", "", "", "-20.53861", "-47.40083", "America/Sao_Paulo"),
("3463030", "Foz do Iguacu", "Фос-ду-Игуасу", "BR", "76", "18", "4108304", "", "", "-25.54778", "-54.58806", "America/Sao_Paulo"),
("3463066", "Forquilhinha", "Форкильинья", "BR", "76", "26", "4205456", "", "", "-28.7475", "-49.47222", "America/Sao_Paulo"),
("3463140", "Formosa", "", "BR", "76", "29", "5208004", "", "", "-15.53722", "-47.33444", "America/Sao_Paulo"),
("3463174", "Formiga", "Формига", "BR", "76", "15", "3126109", "", "", "-20.46444", "-45.42639", "America/Sao_Paulo"),
("3463237", "Florianopolis", "Флорианополис", "BR", "76", "26", "4205407", "", "", "-27.59667", "-48.54917", "America/Sao_Paulo"),
("3463271", "Flores da Cunha", "", "BR", "76", "23", "4308201", "", "", "-29.02889", "-51.18167", "America/Sao_Paulo"),
("3463422", "Ferraz de Vasconcelos", "", "BR", "76", "27", "3515707", "", "", "-23.54083", "-46.36861", "America/Sao_Paulo"),
("3463432", "Fernandopolis", "", "BR", "76", "27", "3515509", "", "", "-20.28389", "-50.24639", "America/Sao_Paulo"),
("3463478", "Feira de Santana", "Фейра-де-Сантана", "BR", "76", "05", "2910800", "", "", "-12.26667", "-38.96667", "America/Bahia"),
("3463605", "Farroupilha", "", "BR", "76", "23", "4307906", "", "", "-29.225", "-51.34778", "America/Sao_Paulo"),
("3463698", "Euclides da Cunha", "Евклид-да-Кунья", "BR", "76", "05", "2910701", "", "", "-10.5075", "-39.01583", "America/Bahia"),
("3463762", "Estrela", "", "BR", "76", "23", "4322509", "", "", "-28.06111", "-50.93833", "America/Sao_Paulo"),
("3463859", "Esteio", "", "BR", "76", "23", "4307708", "", "", "-29.86139", "-51.17917", "America/Sao_Paulo"),
("3463865", "Estancia Velha", "", "BR", "76", "23", "4307609", "", "", "-29.64833", "-51.17389", "America/Sao_Paulo"),
("3463900", "Estancia", "", "BR", "76", "28", "2802106", "", "", "-11.26833", "-37.43833", "America/Maceio"),
("3463920", "Esplanada", "", "BR", "76", "05", "2910602", "", "", "-11.79611", "-37.945", "America/Bahia"),
("3463939", "Espinosa", "", "BR", "76", "15", "3124302", "", "", "-14.92611", "-42.81917", "America/Sao_Paulo"),
("3464008", "Esmeraldas", "Эсмеральдас", "BR", "76", "15", "3124104", "", "", "-19.7625", "-44.31389", "America/Sao_Paulo"),
("3464073", "Erechim", "Эрешин", "BR", "76", "23", "4307005", "", "", "-27.63417", "-52.27389", "America/Sao_Paulo"),
("3464100", "Entre Rios", "", "BR", "76", "05", "2910503", "", "", "-11.94194", "-38.08444", "America/Bahia"),
("3464255", "Encruzilhada do Sul", "", "BR", "76", "23", "4306908", "", "", "-30.54389", "-52.52194", "America/Sao_Paulo"),
("3464274", "Encantado", "", "BR", "76", "23", "4306809", "", "", "-29.23611", "-51.86972", "America/Sao_Paulo"),
("3464304", "Embu Guacu", "", "BR", "76", "27", "3515103", "", "", "-23.83222", "-46.81139", "America/Sao_Paulo"),
("3464305", "Embu", "Эмба", "BR", "76", "27", "3515004", "", "", "-23.64889", "-46.85222", "America/Sao_Paulo"),
("3464329", "Eloi Mendes", "", "BR", "76", "15", "3123601", "", "", "-21.61", "-45.56528", "America/Sao_Paulo"),
("3464374", "Duque de Caxias", "Дуки-ди-Кашиас", "BR", "76", "21", "3301702", "", "", "-22.78556", "-43.31167", "America/Sao_Paulo"),
("3464460", "Dourados", "Дорадус", "BR", "76", "11", "5003702", "", "", "-22.22111", "-54.80556", "America/Campo_Grande"),
("3464547", "Dom Pedrito", "", "BR", "76", "23", "4306601", "", "", "-30.98278", "-54.67306", "America/Sao_Paulo"),
("3464579", "Dois Vizinhos", "", "BR", "76", "18", "4107207", "", "", "-25.73361", "-53.05722", "America/Sao_Paulo"),
("3464618", "Dois Corregos", "", "BR", "76", "27", "3514106", "", "", "-22.36611", "-48.38028", "America/Sao_Paulo"),
("3464688", "Divinopolis", "Дивинополис", "BR", "76", "15", "3122306", "", "", "-20.13889", "-44.88389", "America/Sao_Paulo"),
("3464724", "Diamantino", "", "BR", "76", "14", "5103502", "", "", "-14.40861", "-56.44611", "America/Cuiaba"),
("3464728", "Diamantina", "Диамантина", "BR", "76", "15", "3121605", "", "", "-18.24142", "-43.60568", "America/Sao_Paulo"),
("3464739", "Diadema", "Диадема", "BR", "76", "27", "3513801", "", "", "-23.68611", "-46.62278", "America/Sao_Paulo"),
("3464809", "Descalvado", "", "BR", "76", "27", "3513702", "", "", "-21.90389", "-47.61944", "America/Sao_Paulo"),
("3464891", "Curvelo", "Курвелу", "BR", "76", "15", "3120904", "", "", "-18.75639", "-44.43083", "America/Sao_Paulo"),
("3464974", "Curitibanos", "Куритибанус", "BR", "76", "26", "4204806", "", "", "-27.28278", "-50.58444", "America/Sao_Paulo"),
("3464975", "Curitiba", "Куритиба", "BR", "76", "18", "4106902", "", "", "-25.42778", "-49.27306", "America/Sao_Paulo"),
("3465038", "Cuiaba", "Куяба", "BR", "76", "14", "5103403", "", "", "-15.59611", "-56.09667", "America/Cuiaba"),
("3465059", "Cubatao", "", "BR", "76", "27", "3513504", "", "", "-23.895", "-46.42528", "America/Sao_Paulo"),
("3465083", "Cruzeiro do Oeste", "", "BR", "76", "18", "4106605", "", "", "-23.785", "-53.07333", "America/Sao_Paulo"),
("3465090", "Cruzeiro", "", "BR", "76", "27", "3513405", "", "", "-22.57611", "-44.96278", "America/Sao_Paulo"),
("3465105", "Cruz das Almas", "", "BR", "76", "05", "2909802", "", "", "-12.67", "-39.10194", "America/Bahia"),
("3465108", "Cruz Alta", "Крус-Алта", "BR", "76", "23", "4306106", "", "", "-28.63861", "-53.60639", "America/Sao_Paulo"),
("3465164", "Cristalina", "Кристалина", "BR", "76", "29", "5206206", "", "", "-16.76861", "-47.61361", "America/Sao_Paulo"),
("3465196", "Criciuma", "Крисиума", "BR", "76", "26", "4204608", "", "", "-28.6775", "-49.36972", "America/Sao_Paulo"),
("3465209", "Cravinhos", "", "BR", "76", "27", "3513108", "", "", "-21.34028", "-47.72944", "America/Sao_Paulo"),
("3465228", "Coxim", "Кошин", "BR", "76", "11", "5003306", "", "", "-18.50667", "-54.76", "America/Campo_Grande"),
("3465284", "Cotia", "", "BR", "76", "27", "3513009", "", "", "-23.60389", "-46.91917", "America/Sao_Paulo"),
("3465320", "Cosmopolis", "", "BR", "76", "27", "3512803", "", "", "-22.64583", "-47.19611", "America/Sao_Paulo"),
("3465329", "Coruripe", "", "BR", "76", "02", "2702306", "", "", "-10.12556", "-36.17556", "America/Maceio"),
("3465342", "Corumba", "Корумба", "BR", "76", "11", "5003207", "", "", "-19.00917", "-57.65333", "America/Campo_Grande"),
("3465459", "Coronel Vivida", "", "BR", "76", "18", "4106506", "", "", "-25.97972", "-52.56778", "America/Sao_Paulo"),
("3465476", "Coronel Fabriciano", "Коронел-Фабрисиану", "BR", "76", "15", "3119401", "", "", "-19.51861", "-42.62889", "America/Sao_Paulo"),
("3465487", "Coromandel", "", "BR", "76", "15", "3119302", "", "", "-18.47333", "-47.20028", "America/Sao_Paulo"),
("3465512", "Corinto", "Коринто", "BR", "76", "15", "3119104", "", "", "-18.38083", "-44.45639", "America/Sao_Paulo"),
("3465524", "Cordeiropolis", "", "BR", "76", "27", "3512407", "", "", "-22.48194", "-47.45667", "America/Sao_Paulo"),
("3465527", "Cordeiro", "", "BR", "76", "21", "3301504", "", "", "-22.02861", "-42.36083", "America/Sao_Paulo"),
("3465624", "Contagem", "Контажен", "BR", "76", "15", "3118601", "", "", "-19.93167", "-44.05361", "America/Sao_Paulo"),
("3465644", "Conselheiro Lafaiete", "Консельейру-Лафаети", "BR", "76", "15", "3118304", "", "", "-20.66028", "-43.78611", "America/Sao_Paulo"),
("3465671", "Congonhas", "Конгоньяс", "BR", "76", "15", "3118007", "", "", "-20.49972", "-43.85778", "America/Sao_Paulo"),
("3465713", "Conde", "", "BR", "76", "05", "2908606", "", "", "-11.81361", "-37.61056", "America/Bahia"),
("3465721", "Concordia", "Конкордия", "BR", "76", "26", "4204301", "", "", "-27.23417", "-52.02778", "America/Sao_Paulo"),
("3465731", "Conchal", "", "BR", "76", "27", "3512209", "", "", "-22.33028", "-47.1725", "America/Sao_Paulo"),
("3465748", "Conceicao do Coite", "", "BR", "76", "05", "2908408", "", "", "-11.56389", "-39.28278", "America/Bahia"),
("3465758", "Conceicao do Jacuipe", "", "BR", "76", "05", "2908507", "", "", "-12.31667", "-38.76667", "America/Bahia"),
("3465764", "Conceicao das Alagoas", "", "BR", "76", "15", "3117306", "", "", "-19.91472", "-48.38833", "America/Sao_Paulo"),
("3465767", "Conceicao da Feira", "", "BR", "76", "05", "2908200", "", "", "-12.50583", "-38.99861", "America/Bahia"),
("3465769", "Conceicao da Barra", "", "BR", "76", "08", "3201605", "", "", "-18.59333", "-39.73222", "America/Sao_Paulo"),
("3465881", "Colorado", "", "BR", "76", "18", "4105904", "", "", "-22.8375", "-51.97306", "America/Sao_Paulo"),
("3465927", "Colombo", "Коломбо", "BR", "76", "18", "4105805", "", "", "-25.29167", "-49.22417", "America/Sao_Paulo"),
("3465944", "Colatina", "Колатина", "BR", "76", "08", "3201506", "", "", "-19.53944", "-40.63056", "America/Sao_Paulo"),
("3466041", "Coaraci", "", "BR", "76", "05", "2908002", "", "", "-14.64083", "-39.55111", "America/Bahia"),
("3466062", "Claudio", "", "BR", "76", "15", "3116605", "", "", "-20.44333", "-44.76583", "America/Sao_Paulo"),
("3466171", "Cicero Dantas", "", "BR", "76", "05", "2907806", "", "", "-10.6", "-38.38333", "America/Bahia"),
("3466174", "Cianorte", "Сианорте", "BR", "76", "18", "4105508", "", "", "-23.66333", "-52.605", "America/Sao_Paulo"),
("3466261", "Charqueadas", "", "BR", "76", "23", "4305355", "", "", "-29.95472", "-51.62528", "America/Sao_Paulo"),
("3466296", "Chapeco", "Шапеко", "BR", "76", "26", "4204202", "", "", "-27.09639", "-52.61833", "America/Sao_Paulo"),
("3466429", "Cerquilho", "", "BR", "76", "27", "3511508", "", "", "-23.165", "-47.74361", "America/Sao_Paulo"),
("3466436", "Ceres", "", "BR", "76", "29", "5205406", "", "", "-15.30833", "-49.59833", "America/Sao_Paulo"),
("3466481", "Celso Ramos", "", "BR", "76", "26", "4204152", "", "", "-27.63444", "-51.33639", "America/Sao_Paulo"),
("3466537", "Caxias do Sul", "Кашиас-ду-Сул", "BR", "76", "23", "4305108", "", "", "-29.16806", "-51.17944", "America/Sao_Paulo"),
("3466547", "Caxambu", "", "BR", "76", "15", "3115508", "", "", "-21.97722", "-44.9325", "America/Sao_Paulo"),
("3466641", "Catu", "", "BR", "76", "05", "2907509", "", "", "-12.35306", "-38.37889", "America/Bahia"),
("3466692", "Catanduva", "Катандува", "BR", "76", "27", "3511102", "", "", "-21.13778", "-48.97278", "America/Sao_Paulo"),
("3466696", "Catalao", "", "BR", "76", "29", "5205109", "", "", "-18.16583", "-47.94639", "America/Sao_Paulo"),
("3466698", "Cataguases", "Катагуазис", "BR", "76", "15", "3115300", "", "", "-21.38917", "-42.69667", "America/Sao_Paulo"),
("3466704", "Castro", "", "BR", "76", "18", "4104907", "", "", "-24.79111", "-50.01194", "America/Sao_Paulo"),
("3466723", "Castelo", "Каштелу", "BR", "76", "08", "3201407", "", "", "-20.60361", "-41.18472", "America/Sao_Paulo"),
("3466750", "Cassilandia", "", "BR", "76", "11", "5002902", "", "", "-19.11333", "-51.73417", "America/Campo_Grande"),
("3466763", "Casimiro de Abreu", "", "BR", "76", "21", "3301306", "", "", "-22.48056", "-42.20417", "America/Sao_Paulo"),
("3466779", "Cascavel", "Каскавел", "BR", "76", "18", "4104808", "", "", "-24.95583", "-53.45528", "America/Sao_Paulo"),
("3466824", "Casa Branca", "", "BR", "76", "27", "3510807", "", "", "-21.77389", "-47.08639", "America/Sao_Paulo"),
("3466902", "Carmo do Paranaiba", "", "BR", "76", "15", "3114303", "", "", "-19.00083", "-46.31611", "America/Sao_Paulo"),
("3466903", "Carmo do Cajuru", "", "BR", "76", "15", "3114204", "", "", "-20.18417", "-44.77111", "America/Sao_Paulo"),
("3466933", "Carlos Barbosa", "", "BR", "76", "23", "4304804", "", "", "-29.2975", "-51.50361", "America/Sao_Paulo"),
("3466978", "Carazinho", "Каразинью", "BR", "76", "23", "4304705", "", "", "-28.28389", "-52.78639", "America/Sao_Paulo"),
("3466988", "Caratinga", "Каратинга", "BR", "76", "15", "3113404", "", "", "-19.78972", "-42.13917", "America/Sao_Paulo"),
("3466998", "Carapicuiba", "", "BR", "76", "27", "3510609", "", "", "-23.52272", "-46.835", "America/Sao_Paulo"),
("3467012", "Carangola", "Карангола", "BR", "76", "15", "3113305", "", "", "-20.73306", "-42.02944", "America/Sao_Paulo"),
("3467026", "Carandai", "", "BR", "76", "15", "3113206", "", "", "-20.95361", "-43.80639", "America/Sao_Paulo"),
("3467081", "Caraguatatuba", "Карагуататуба", "BR", "76", "27", "3510500", "", "", "-23.62028", "-45.41306", "America/Sao_Paulo"),
("3467197", "Capivari", "Капивари", "BR", "76", "27", "3510401", "", "", "-22.995", "-47.50778", "America/Sao_Paulo"),
("3467261", "Capinzal", "", "BR", "76", "26", "4203907", "", "", "-27.34361", "-51.61194", "America/Sao_Paulo"),
("3467272", "Capim Grosso", "", "BR", "76", "05", "2906873", "", "", "-11.38111", "-40.01278", "America/Bahia"),
("3467305", "Capelinha", "Капелинья", "BR", "76", "15", "3112307", "", "", "-17.69139", "-42.51583", "America/Sao_Paulo"),
("3467319", "Capela", "", "BR", "76", "28", "2801306", "", "", "-10.50333", "-37.05278", "America/Maceio"),
("3467362", "Capao da Canoa", "", "BR", "76", "23", "4304630", "", "", "-29.74556", "-50.00972", "America/Sao_Paulo"),
("3467371", "Capao Bonito", "", "BR", "76", "27", "3510203", "", "", "-24.00583", "-48.34944", "America/Sao_Paulo"),
("3467452", "Canoinhas", "", "BR", "76", "26", "4203808", "", "", "-26.17722", "-50.39", "America/Sao_Paulo"),
("3467467", "Canoas", "Каноас", "BR", "76", "23", "4304606", "", "", "-29.91778", "-51.18361", "America/Sao_Paulo"),
("3467512", "Cangucu", "", "BR", "76", "23", "4304507", "", "", "-31.395", "-52.67556", "America/Sao_Paulo"),
("3467530", "Canela", "Канела", "BR", "76", "23", "4304408", "", "", "-29.36556", "-50.81556", "America/Sao_Paulo"),
("3467542", "Candido Mota", "", "BR", "76", "27", "3510005", "", "", "-22.74639", "-50.38694", "America/Sao_Paulo"),
("3467550", "Candelaria", "", "BR", "76", "23", "4304200", "", "", "-29.66917", "-52.78889", "America/Sao_Paulo"),
("3467577", "Canavieiras", "", "BR", "76", "05", "2906303", "", "", "-15.675", "-38.94722", "America/Bahia"),
("3467673", "Campo Verde", "", "BR", "76", "11", "5004908", "", "", "-20.41667", "-54.06667", "America/Campo_Grande"),
("3467677", "Campos Novos", "Кампус-Новус", "BR", "76", "26", "4203600", "", "", "-27.40167", "-51.225", "America/Sao_Paulo"),
("3467680", "Campos Gerais", "Кампус-Жерайс", "BR", "76", "15", "3111606", "", "", "-21.235", "-45.75861", "America/Sao_Paulo"),
("3467684", "Campos do Jordao", "Кампус-ду-Жордау", "BR", "76", "27", "3509700", "", "", "-22.73944", "-45.59139", "America/Sao_Paulo"),
("3467687", "Campos Belos", "", "BR", "76", "29", "5204904", "", "", "-13.03667", "-46.77167", "America/Sao_Paulo"),
("3467693", "Campos", "Кампос", "BR", "76", "21", "3301009", "", "", "-21.75227", "-41.33044", "America/Sao_Paulo"),
("3467717", "Campo Mourao", "", "BR", "76", "18", "4104303", "", "", "-24.04556", "-52.38306", "America/Sao_Paulo"),
("3467736", "Campo Largo", "", "BR", "76", "18", "4104204", "", "", "-25.45861", "-49.52833", "America/Sao_Paulo"),
("3467747", "Campo Grande", "Кампу-Гранди", "BR", "76", "11", "5002704", "", "", "-20.44278", "-54.64639", "America/Campo_Grande"),
("3467760", "Campo Formoso", "", "BR", "76", "05", "2906006", "", "", "-10.5075", "-40.32139", "America/Bahia"),
("3467796", "Campo Belo", "Кампу-Белу", "BR", "76", "15", "3111200", "", "", "-20.89722", "-45.27722", "America/Sao_Paulo"),
("3467865", "Campinas", "Кампинас", "BR", "76", "27", "3509502", "", "", "-22.90556", "-47.06083", "America/Sao_Paulo"),
("3467877", "Campina Grande do Sul", "Кампина-Гранде-ду-Сул", "BR", "76", "18", "4104006", "", "", "-25.30556", "-49.05528", "America/Sao_Paulo"),
("3467956", "Cambui", "", "BR", "76", "15", "3110608", "", "", "-22.61222", "-46.0575", "America/Sao_Paulo"),
("3467978", "Cambe", "", "BR", "76", "18", "4103701", "", "", "-23.27583", "-51.27833", "America/Sao_Paulo"),
("3467985", "Cambara", "", "BR", "76", "18", "4103602", "", "", "-23.04639", "-50.07361", "America/Sao_Paulo"),
("3468014", "Camaqua", "", "BR", "76", "23", "4303509", "", "", "-30.85111", "-51.81222", "America/Sao_Paulo"),
("3468023", "Camanducaia", "", "BR", "76", "15", "3110509", "", "", "-22.75528", "-46.14472", "America/Sao_Paulo"),
("3468031", "Camacari", "", "BR", "76", "05", "2905701", "", "", "-12.6975", "-38.32417", "America/Bahia"),
("3468100", "Caldas Novas", "", "BR", "76", "29", "5204508", "", "", "-17.74167", "-48.625", "America/Sao_Paulo"),
("3468121", "Cajuru", "", "BR", "76", "27", "3509403", "", "", "-21.27528", "-47.30417", "America/Sao_Paulo"),
("3468157", "Cajati", "", "BR", "76", "27", "3509254", "", "", "-24.73611", "-48.12278", "America/Sao_Paulo"),
("3468158", "Cajamar", "", "BR", "76", "27", "3509205", "", "", "-23.35611", "-46.87694", "America/Sao_Paulo"),
("3468215", "Caieiras", "", "BR", "76", "27", "3509007", "", "", "-23.36417", "-46.74056", "America/Sao_Paulo"),
("3468317", "Caetite", "Каэтите", "BR", "76", "05", "2905206", "", "", "-14.06944", "-42.475", "America/Bahia"),
("3468327", "Caete", "Каэте", "BR", "76", "15", "3110004", "", "", "-19.88", "-43.66972", "America/Sao_Paulo"),
("3468376", "Cachoeiro de Itapemirim", "Кашуэйру-ди-Итапемирин", "BR", "76", "08", "3201209", "", "", "-20.84889", "-41.11278", "America/Sao_Paulo"),
("3468403", "Cachoeirinha", "", "BR", "76", "23", "4303103", "", "", "-29.95111", "-51.09389", "America/Sao_Paulo"),
("3468425", "Cachoeiras de Macacu", "", "BR", "76", "21", "3300803", "", "", "-22.4625", "-42.65306", "America/Sao_Paulo"),
("3468436", "Cachoeira do Sul", "Кашуэйра-ду-Сул", "BR", "76", "23", "4303004", "", "", "-30.03917", "-52.89389", "America/Sao_Paulo"),
("3468535", "Cachoeira", "", "BR", "76", "05", "2904902", "", "", "-12.61833", "-38.95583", "America/Bahia"),
("3468560", "Cacapava do Sul", "", "BR", "76", "23", "4302808", "", "", "-30.51222", "-53.49139", "America/Sao_Paulo"),
("3468562", "Cacapava", "", "BR", "76", "27", "3508504", "", "", "-23.10083", "-45.70694", "America/Sao_Paulo"),
("3468570", "Cacador", "Касадор", "BR", "76", "26", "4203006", "", "", "-26.77528", "-51.015", "America/Sao_Paulo"),
("3468592", "Cabreuva", "Кабреува", "BR", "76", "27", "3508405", "", "", "-23.3075", "-47.13278", "America/Sao_Paulo"),
("3468615", "Cabo Frio", "Кабу-Фриу", "BR", "76", "21", "3300704", "", "", "-22.88717", "-42.02622", "America/Sao_Paulo"),
("3468704", "Butia", "", "BR", "76", "23", "4302709", "", "", "-30.11972", "-51.96222", "America/Sao_Paulo"),
("3468720", "Buritizeiro", "", "BR", "76", "15", "3109402", "", "", "-17.35111", "-44.96222", "America/Sao_Paulo"),
("3468732", "Buritis", "", "BR", "76", "15", "3109303", "", "", "-15.61778", "-46.42333", "America/Sao_Paulo"),
("3468802", "Buri", "", "BR", "76", "27", "3508009", "", "", "-23.7975", "-48.59278", "America/Sao_Paulo"),
("3468858", "Buerarema", "", "BR", "76", "05", "2904704", "", "", "-14.95944", "-39.29972", "America/Bahia"),
("3468879", "Brusque", "", "BR", "76", "26", "4202909", "", "", "-27.09806", "-48.9175", "America/Sao_Paulo"),
("3468893", "Brumado", "Брумаду", "BR", "76", "05", "2904605", "", "", "-14.20361", "-41.66528", "America/Bahia"),
("3468894", "Brumadinho", "", "BR", "76", "15", "3109006", "", "", "-20.14333", "-44.19972", "America/Sao_Paulo"),
("3468899", "Brotas", "", "BR", "76", "27", "3507902", "", "", "-22.28417", "-48.12667", "America/Sao_Paulo"),
("3468902", "Brodosqui", "", "BR", "76", "27", "3507803", "", "", "-20.99139", "-47.65861", "America/Sao_Paulo"),
("3469058", "Brasilia", "Бразилия", "BR", "76", "07", "5300108", "", "", "-15.77972", "-47.92972", "America/Sao_Paulo"),
("3469092", "Braganca Paulista", "Браганса-Паулиста", "BR", "76", "27", "3507605", "", "", "-22.95194", "-46.54194", "America/Sao_Paulo"),
("3469115", "Braco do Norte", "", "BR", "76", "26", "4202800", "", "", "-28.275", "-49.16556", "America/Sao_Paulo"),
("3469136", "Botucatu", "Ботукату", "BR", "76", "27", "3507506", "", "", "-22.88583", "-48.445", "America/Sao_Paulo"),
("3469425", "Bom Jesus do Itabapoana", "Бон-Жезус-ду-Итабапоана", "BR", "76", "21", "3300605", "", "", "-21.13389", "-41.67972", "America/Sao_Paulo"),
("3469437", "Bom Jesus da Lapa", "Бон-Жезус-да-Лапа", "BR", "76", "05", "2903904", "", "", "-13.255", "-43.41806", "America/Bahia"),
("3469516", "Bom Despacho", "", "BR", "76", "15", "3107406", "", "", "-19.73639", "-45.25222", "America/Sao_Paulo"),
("3469540", "Boituva", "", "BR", "76", "27", "3507001", "", "", "-23.28333", "-47.67222", "America/Sao_Paulo"),
("3469601", "Bocaiuva", "", "BR", "76", "15", "3107307", "", "", "-17.10778", "-43.815", "America/Sao_Paulo"),
("3469932", "Boa Esperanca", "Боа-Эсперанса", "BR", "76", "15", "3107109", "", "", "-21.09", "-45.56583", "America/Sao_Paulo"),
("3469968", "Blumenau", "Блуменау", "BR", "76", "26", "4202404", "", "", "-26.91944", "-49.06611", "America/Sao_Paulo"),
("3469984", "Biritiba Mirim", "", "BR", "76", "27", "3506607", "", "", "-23.5725", "-46.03861", "America/Sao_Paulo"),
("3469989", "Birigui", "", "BR", "76", "27", "3506508", "", "", "-21.28861", "-50.34", "America/Sao_Paulo"),
("3470003", "Biguacu", "", "BR", "76", "26", "4202305", "", "", "-27.49417", "-48.65556", "America/Sao_Paulo"),
("3470044", "Betim", "Бетин", "BR", "76", "15", "3106705", "", "", "-19.96778", "-44.19833", "America/Sao_Paulo"),
("3470052", "Bertioga", "", "BR", "76", "27", "3506359", "", "", "-23.85444", "-46.13861", "America/Sao_Paulo"),
("3470073", "Bento Goncalves", "", "BR", "76", "23", "4302105", "", "", "-29.17139", "-51.51917", "America/Sao_Paulo"),
("3470117", "Belo Oriente", "", "BR", "76", "15", "3106309", "", "", "-19.22", "-42.48361", "America/Sao_Paulo"),
("3470127", "Belo Horizonte", "Белу-Оризонти", "BR", "76", "15", "3106200", "", "", "-19.92083", "-43.93778", "America/Sao_Paulo"),
("3470142", "Belford Roxo", "Белфорд-Рошу", "BR", "76", "21", "3300456", "", "", "-22.76417", "-43.39944", "America/Sao_Paulo"),
("3470177", "Bela Vista", "", "BR", "76", "11", "5002100", "", "", "-22.10889", "-56.52111", "America/Campo_Grande"),
("3470264", "Bebedouro", "", "BR", "76", "27", "3506102", "", "", "-20.94944", "-48.47917", "America/Sao_Paulo"),
("3470279", "Bauru", "Бауру", "BR", "76", "27", "3506003", "", "", "-22.31472", "-49.06056", "America/Sao_Paulo"),
("3470324", "Batatais", "Бататайс", "BR", "76", "27", "3505906", "", "", "-20.89111", "-47.585", "America/Sao_Paulo"),
("3470341", "Bastos", "", "BR", "76", "27", "3505807", "", "", "-21.92194", "-50.73389", "America/Sao_Paulo"),
("3470353", "Barueri", "Баруэри", "BR", "76", "27", "3505708", "", "", "-23.51056", "-46.87611", "America/Sao_Paulo"),
("3470369", "Barroso", "", "BR", "76", "15", "3105905", "", "", "-21.18694", "-43.97583", "America/Sao_Paulo"),
("3470428", "Barrinha", "", "BR", "76", "27", "3505609", "", "", "-21.19361", "-48.16389", "America/Sao_Paulo"),
("3470451", "Barretos", "Барретус", "BR", "76", "27", "3505500", "", "", "-20.55722", "-48.56778", "America/Sao_Paulo"),
("3470470", "Barreiro do Jaiba", "", "BR", "76", "15", "3171030", "", "", "-15.61532", "-43.59187", "America/Sao_Paulo"),
("3470583", "Barreiras", "Баррейрас", "BR", "76", "05", "2903201", "", "", "-12.15278", "-44.99", "America/Bahia"),
("3470597", "Barra Velha", "", "BR", "76", "26", "4202107", "", "", "-26.63222", "-48.68472", "America/Sao_Paulo"),
("3470636", "Barra Mansa", "Барра-Манса", "BR", "76", "21", "3300407", "", "", "-22.54417", "-44.17139", "America/Sao_Paulo"),
("3470674", "Barra dos Coqueiros", "", "BR", "76", "28", "2800605", "", "", "-10.90889", "-37.03861", "America/Maceio"),
("3470691", "Barra do Pirai", "", "BR", "76", "21", "3300308", "", "", "-22.47", "-43.82556", "America/Sao_Paulo"),
("3470709", "Barra do Garcas", "Барра-ду-Гарсас", "BR", "76", "14", "5101803", "", "", "-15.89", "-52.25667", "America/Cuiaba"),
("3470718", "Barra do Bugres", "", "BR", "76", "14", "5101704", "", "", "-15.0725", "-57.18111", "America/Cuiaba"),
("3470730", "Barra de Sao Francisco", "Барра-де-Сан-Франциско", "BR", "76", "08", "3200904", "", "", "-18.755", "-40.89083", "America/Sao_Paulo"),
("3470776", "Barra Bonita", "", "BR", "76", "27", "3505302", "", "", "-22.49472", "-48.55806", "America/Sao_Paulo"),
("3470821", "Barra", "Барра", "BR", "76", "05", "2902708", "", "", "-11.08944", "-43.14167", "America/Bahia"),
("3470825", "Bariri", "", "BR", "76", "27", "3505203", "", "", "-22.07444", "-48.74028", "America/Sao_Paulo"),
("3470858", "Barbacena", "", "BR", "76", "15", "3105608", "", "", "-21.22583", "-43.77361", "America/Sao_Paulo"),
("3470878", "Barao de Cocais", "", "BR", "76", "15", "3105400", "", "", "-19.94583", "-43.48722", "America/Sao_Paulo"),
("3470912", "Bandeirantes", "", "BR", "76", "18", "4102406", "", "", "-23.11", "-50.3675", "America/Sao_Paulo"),
("3471005", "Bambui", "", "BR", "76", "15", "3105103", "", "", "-20.00639", "-45.97694", "America/Sao_Paulo"),
("3471039", "Balneario Camboriu", "Балнеариу-Камбориу", "BR", "76", "26", "4202008", "", "", "-26.99056", "-48.63472", "America/Sao_Paulo"),
("3471061", "Baixo Guandu", "", "BR", "76", "08", "3200805", "", "", "-19.51889", "-41.01583", "America/Sao_Paulo"),
("3471196", "Bage", "Баг", "BR", "76", "23", "4301602", "", "", "-31.33139", "-54.10694", "America/Sao_Paulo"),
("3471291", "Avare", "", "BR", "76", "27", "3504503", "", "", "-23.09861", "-48.92583", "America/Sao_Paulo"),
("3471335", "Atibaia", "Атибая", "BR", "76", "27", "3504107", "", "", "-23.11694", "-46.55028", "America/Sao_Paulo"),
("3471368", "Astorga", "", "BR", "76", "18", "4102109", "", "", "-23.2325", "-51.66556", "America/Sao_Paulo"),
("3471374", "Assis", "Ассис", "BR", "76", "27", "3504008", "", "", "-22.66167", "-50.41222", "America/Sao_Paulo"),
("3471393", "Aruja", "", "BR", "76", "27", "3503901", "", "", "-23.39611", "-46.32083", "America/Sao_Paulo"),
("3471395", "Artur Nogueira", "", "BR", "76", "27", "3503802", "", "", "-22.57306", "-47.1725", "America/Sao_Paulo"),
("3471422", "Arroio Grande", "", "BR", "76", "23", "4301305", "", "", "-32.2375", "-53.08694", "America/Sao_Paulo"),
("3471428", "Arroio do Meio", "", "BR", "76", "23", "4301008", "", "", "-29.40111", "-51.945", "America/Sao_Paulo"),
("3471451", "Arraial do Cabo", "", "BR", "76", "21", "3300258", "", "", "-22.96611", "-42.02778", "America/Sao_Paulo"),
("3471487", "Armacao de Buzios", "", "BR", "76", "21", "3300233", "", "", "-22.74694", "-41.88167", "America/Sao_Paulo"),
("3471683", "Arcos", "Аркос", "BR", "76", "15", "3104205", "", "", "-20.28194", "-45.53944", "America/Sao_Paulo"),
("3471691", "Araxa", "Араша", "BR", "76", "15", "3104007", "", "", "-19.59333", "-46.94056", "America/Sao_Paulo"),
("3471697", "Araucaria", "Араукария", "BR", "76", "18", "4101804", "", "", "-25.59306", "-49.41028", "America/Sao_Paulo"),
("3471715", "Araruama", "Араруама", "BR", "76", "21", "3300209", "", "", "-22.87278", "-42.34306", "America/Sao_Paulo"),
("3471758", "Araras", "", "BR", "76", "27", "3503307", "", "", "-22.35694", "-47.38417", "America/Sao_Paulo"),
("3471766", "Araraquara", "Араракуара", "BR", "76", "27", "3503208", "", "", "-21.79444", "-48.17556", "America/Sao_Paulo"),
("3471772", "Ararangua", "Арарангуа", "BR", "76", "26", "4201406", "", "", "-28.93472", "-49.48583", "America/Sao_Paulo"),
("3471798", "Arapongas", "Арапонгас", "BR", "76", "18", "4101507", "", "", "-23.41944", "-51.42444", "America/Sao_Paulo"),
("3471830", "Araguari", "Арагуари", "BR", "76", "15", "3103504", "", "", "-18.64722", "-48.18722", "America/Sao_Paulo"),
("3471840", "Aragarcas", "", "BR", "76", "29", "5201702", "", "", "-15.8975", "-52.25083", "America/Sao_Paulo"),
("3471846", "Aracuai", "Арасуаи", "BR", "76", "15", "3103405", "", "", "-16.84972", "-42.07028", "America/Sao_Paulo"),
("3471848", "Aracruz", "Аракрус", "BR", "76", "08", "3200607", "", "", "-19.82028", "-40.27333", "America/Sao_Paulo"),
("3471849", "Aracoiaba da Serra", "", "BR", "76", "27", "3502903", "", "", "-23.50528", "-47.61417", "America/Sao_Paulo"),
("3471854", "Araci", "", "BR", "76", "05", "2902104", "", "", "-11.33333", "-38.96667", "America/Bahia"),
("3471859", "Aracatuba", "Арасатуба", "BR", "76", "27", "3502804", "", "", "-21.20889", "-50.43278", "America/Sao_Paulo"),
("3471872", "Aracaju", "Аракажу", "BR", "76", "28", "2800308", "", "", "-10.91111", "-37.07167", "America/Maceio"),
("3471896", "Aquidauana", "", "BR", "76", "11", "5001102", "", "", "-20.47111", "-55.78722", "America/Campo_Grande"),
("3471910", "Apucarana", "", "BR", "76", "18", "4101408", "", "", "-23.55083", "-51.46083", "America/Sao_Paulo"),
("3471927", "Apiai", "", "BR", "76", "27", "3502705", "", "", "-24.50944", "-48.8425", "America/Sao_Paulo"),
("3471940", "Aparecida do Taboado", "", "BR", "76", "11", "5001003", "", "", "-20.08667", "-51.09361", "America/Campo_Grande"),
("3471949", "Aparecida", "Апаресида", "BR", "76", "27", "3502507", "", "", "-22.84694", "-45.22972", "America/Sao_Paulo"),
("3472048", "Antonina", "", "BR", "76", "18", "4101200", "", "", "-25.42861", "-48.71194", "America/Sao_Paulo"),
("3472138", "Anicuns", "", "BR", "76", "29", "5201306", "", "", "-16.46111", "-49.96167", "America/Sao_Paulo"),
("3472177", "Angra dos Reis", "Ангра-дус-Рейс", "BR", "76", "21", "3300100", "", "", "-23.00667", "-44.31806", "America/Sao_Paulo"),
("3472248", "Andradina", "", "BR", "76", "27", "3502101", "", "", "-20.89611", "-51.37944", "America/Sao_Paulo"),
("3472254", "Andradas", "Андрадас", "BR", "76", "15", "3102605", "", "", "-22.06806", "-46.56917", "America/Sao_Paulo"),
("3472284", "Anastacio", "", "BR", "76", "11", "5000708", "", "", "-20.48361", "-55.80694", "America/Campo_Grande"),
("3472287", "Anapolis", "Анаполис", "BR", "76", "29", "5201108", "", "", "-16.32667", "-48.95278", "America/Sao_Paulo"),
("3472311", "Amparo", "", "BR", "76", "27", "3501905", "", "", "-22.70111", "-46.76444", "America/Sao_Paulo"),
("3472338", "Americo Brasiliense", "", "BR", "76", "27", "3501707", "", "", "-21.72444", "-48.10167", "America/Sao_Paulo"),
("3472343", "Americana", "Американа", "BR", "76", "27", "3501608", "", "", "-22.73917", "-47.33139", "America/Sao_Paulo"),
("3472370", "Amargosa", "", "BR", "76", "05", "2901007", "", "", "-13.03028", "-39.60472", "America/Bahia"),
("3472417", "Alvares Machado", "", "BR", "76", "27", "3501301", "", "", "-22.07944", "-51.47194", "America/Sao_Paulo"),
("3472518", "Almirante Tamandare", "", "BR", "76", "18", "4100400", "", "", "-25.32472", "-49.31", "America/Sao_Paulo"),
("3472520", "Almenara", "Альменара", "BR", "76", "15", "3101706", "", "", "-16.18361", "-40.69444", "America/Sao_Paulo"),
("3472603", "Alfenas", "", "BR", "76", "15", "3101607", "", "", "-21.42917", "-45.94722", "America/Sao_Paulo"),
("3472609", "Alem Paraiba", "", "BR", "76", "15", "3101508", "", "", "-21.88778", "-42.70444", "America/Sao_Paulo"),
("3472638", "Alegrete", "Алегрети", "BR", "76", "23", "4300406", "", "", "-29.78306", "-55.79194", "America/Sao_Paulo"),
("3472666", "Alegre", "", "BR", "76", "08", "3200201", "", "", "-20.76361", "-41.53306", "America/Sao_Paulo"),
("3472766", "Alagoinhas", "Алагоиньяс", "BR", "76", "05", "2900702", "", "", "-12.13556", "-38.41917", "America/Bahia"),
("3472808", "Aimores", "", "BR", "76", "15", "3101102", "", "", "-19.49583", "-41.06389", "America/Sao_Paulo"),
("3472825", "Agudos", "", "BR", "76", "27", "3500709", "", "", "-22.46917", "-48.9875", "America/Sao_Paulo"),
("3472848", "Aguas Vermelhas", "", "BR", "76", "15", "3101003", "", "", "-15.74722", "-41.46", "America/Sao_Paulo"),
("3472869", "Aguas de Lindoia", "", "BR", "76", "27", "3500501", "", "", "-22.47639", "-46.63278", "America/Sao_Paulo"),
("3472969", "Aguai", "", "BR", "76", "27", "3500303", "", "", "-22.05944", "-46.97861", "America/Sao_Paulo"),
("3473157", "Adamantina", "", "BR", "76", "27", "3500105", "", "", "-21.68528", "-51.0725", "America/Sao_Paulo"),
("3473267", "Abaete", "Абаэте", "BR", "76", "15", "3100203", "", "", "-19.16", "-45.44583", "America/Sao_Paulo"),
("3473964", "Guaiba", "", "BR", "76", "23", "4309308", "", "", "-30.11389", "-51.325", "America/Sao_Paulo"),
("3474574", "Palmas", "Палмас", "BR", "76", "31", "1721000", "", "", "-10.16745", "-48.32766", "America/Araguaina"),
("3661944", "Tefe", "", "BR", "76", "04", "1304203", "", "", "-3.35021", "-64.70879", "America/Manaus"),
("3661980", "Tarauaca", "", "BR", "76", "01", "1200609", "", "", "-8.16139", "-70.76556", "America/Rio_Branco"),
("3662075", "Tabatinga", "", "BR", "76", "04", "1304062", "", "", "-4.23095", "-69.93858", "America/Manaus"),
("3662155", "Sena Madureira", "", "BR", "76", "01", "1200500", "", "", "-9.06556", "-68.65694", "America/Eirunepe"),
("3662342", "Sao Gabriel da Cachoeira", "", "BR", "76", "04", "1303809", "", "", "-0.13028", "-67.08917", "America/Manaus"),
("3662574", "Rio Branco", "Риу-Бранку", "BR", "76", "01", "1200401", "", "", "-9.97472", "-67.81", "America/Rio_Branco"),
("3662762", "Porto Velho", "Порту-Велью", "BR", "76", "24", "1100205", "", "", "-8.76194", "-63.90389", "America/Porto_Velho"),
("3663517", "Manaus", "Манаус", "BR", "76", "04", "1302603", "", "", "-3.10194", "-60.025", "America/Manaus"),
("3663529", "Manacapuru", "Манакапуру", "BR", "76", "04", "1302504", "", "", "-3.29972", "-60.62056", "America/Manaus"),
("3664078", "Humaita", "", "BR", "76", "04", "1301704", "", "", "-7.51651", "-63.03105", "America/Manaus"),
("3664207", "Fonte Boa", "", "BR", "76", "04", "1301605", "", "", "-2.51389", "-66.09167", "America/Manaus"),
("3664321", "Eirunepe", "", "BR", "76", "04", "1301407", "", "", "-6.66028", "-69.87361", "America/Eirunepe"),
("3664464", "Cruzeiro do Sul", "", "BR", "76", "01", "1200203", "", "", "-7.63111", "-72.67", "America/Rio_Branco"),
("3664539", "Coari", "Коари", "BR", "76", "04", "1301209", "", "", "-4.085", "-63.14139", "America/Manaus"),
("3664659", "Carauari", "", "BR", "76", "04", "1301001", "", "", "-4.88278", "-66.89583", "America/Manaus"),
("3664980", "Boa Vista", "Боа-Виста", "BR", "76", "25", "1400100", "", "", "2.81972", "-60.67333", "America/Boa_Vista"),
("3665199", "Ariquemes", "", "BR", "76", "24", "1100023", "", "", "-9.91333", "-63.04083", "America/Porto_Velho"),
("3665202", "Aripuana", "Арипуанан", "BR", "76", "14", "5103254", "", "", "-9.16667", "-60.63333", "America/Cuiaba"),
("3924679", "Vilhena", "Вилена", "BR", "76", "24", "1100304", "", "", "-12.74056", "-60.14583", "America/Porto_Velho"),
("3924877", "Posto Fiscal Rolim de Moura", "", "BR", "76", "24", "1100015", "", "", "-13.08271", "-62.27726", "America/Porto_Velho"),
("3924908", "Pimenta Bueno", "", "BR", "76", "24", "1100189", "", "", "-11.6725", "-61.19361", "America/Porto_Velho"),
("3924948", "Ouro Preto do Oeste", "Ору-Прету-ду-Уэсти", "BR", "76", "24", "1100155", "", "", "-10.74806", "-62.21583", "America/Porto_Velho"),
("3925033", "Ji Parana", "", "BR", "76", "24", "1100122", "", "", "-10.88528", "-61.95167", "America/Porto_Velho"),
("3925040", "Jaru", "Жара", "BR", "76", "24", "1100114", "", "", "-10.43889", "-62.46639", "America/Porto_Velho"),
("3925075", "Guajara Mirim", "", "BR", "76", "24", "1100106", "", "", "-10.78278", "-65.33944", "America/Porto_Velho"),
("3925212", "Cacoal", "Какоал", "BR", "76", "24", "1100049", "", "", "-11.43861", "-61.44722", "America/Porto_Velho"),
("6316406", "Aparecida de Goiania", "Апаресида-ди-Гояния", "BR", "76", "29", "5201405", "", "", "-16.82333", "-49.24389", "America/Sao_Paulo"),
("6316729", "Campinas", "", "BR", "76", "26", "4216602", "", "", "-27.59444", "-48.60694", "America/Sao_Paulo"),
("6317344", "Jaboatao dos Guararapes", "Жабоатан-дус-Гуарарапис", "BR", "76", "30", "2607901", "", "", "-8.11278", "-35.01472", "America/Recife"),
("6317464", "Lauro de Freitas", "", "BR", "76", "05", "2919207", "", "", "-12.89444", "-38.32722", "America/Bahia"),
("6317953", "Pinhais", "", "BR", "76", "18", "4119152", "", "", "-25.44472", "-49.1925", "America/Sao_Paulo"),
("6318165", "Rio Preto da Eva", "", "BR", "76", "04", "1303569", "", "", "-2.69795", "-59.70172", "America/Manaus"),
("6318694", "Simoes Filho", "", "BR", "76", "05", "2930709", "", "", "-12.78444", "-38.40389", "America/Bahia"),
("6318696", "Sinop", "", "BR", "76", "14", "5107909", "", "", "-11.86417", "-55.5025", "America/Cuiaba"),
("6693804", "Cambebba", "", "BR", "76", "06", "2303709", "", "", "-3.62092", "-38.82913", "America/Fortaleza"),
("7874479", "Trindade", "", "BR", "76", "26", "4205407", "", "", "-27.58612", "-48.52335", "America/Sao_Paulo"),
("7874492", "Freguesia do Ribeirao da Ilha", "", "BR", "76", "26", "4205407", "", "", "-27.71773", "-48.56266", "America/Sao_Paulo"),
("933000", "Tonota", "", "BW", "72", "01", "", "", "", "-21.44236", "27.46153", "Africa/Gaborone"),
("933018", "Thamaga", "", "BW", "72", "06", "", "", "", "-24.67014", "25.53975", "Africa/Gaborone"),
("933088", "Serowe", "Серова", "BW", "72", "01", "", "", "", "-22.38754", "26.71077", "Africa/Gaborone"),
("933099", "Selebi-Phikwe", "", "BW", "72", "01", "", "", "", "-21.97895", "27.84296", "Africa/Gaborone"),
("933141", "Ramotswa", "", "BW", "72", "09", "", "", "", "-24.87158", "25.86989", "Africa/Gaborone"),
("933182", "Palapye", "Палапье", "BW", "72", "01", "", "", "", "-22.54605", "27.12507", "Africa/Gaborone"),
("933271", "Mosopa", "", "BW", "72", "10", "", "", "", "-24.7718", "25.42156", "Africa/Gaborone"),
("933305", "Molepolole", "Молепололе", "BW", "72", "06", "", "", "", "-24.40659", "25.49508", "Africa/Gaborone"),
("933331", "Mogoditshane", "", "BW", "72", "06", "", "", "", "-24.62694", "25.86556", "Africa/Gaborone"),
("933340", "Mochudi", "Мочуди", "BW", "72", "05", "", "", "", "-24.41667", "26.15", "Africa/Gaborone"),
("933366", "Maun", "Маун", "BW", "72", "11", "", "", "", "-19.98333", "23.41667", "Africa/Gaborone"),
("933471", "Mahalapye", "", "BW", "72", "01", "", "", "", "-23.10407", "26.81421", "Africa/Gaborone"),
("933521", "Lobatse", "Лобаце", "BW", "72", "09", "", "", "", "-25.22435", "25.67728", "Africa/Gaborone"),
("933535", "Letlhakane", "", "BW", "72", "01", "", "", "", "-21.41494", "25.59263", "Africa/Gaborone"),
("933685", "Kanye", "Канье", "BW", "72", "10", "", "", "", "-24.96675", "25.33274", "Africa/Gaborone"),
("933719", "Janeng", "", "BW", "72", "09", "", "", "", "-25.41667", "25.55", "Africa/Gaborone"),
("933773", "Gaborone", "Габороне", "BW", "72", "09", "", "", "", "-24.65451", "25.90859", "Africa/Gaborone"),
("933778", "Francistown", "Франсистаун", "BW", "72", "08", "", "", "", "-21.16995", "27.50788", "Africa/Gaborone"),
("618800", "Horad Zhodzina", "Жодино", "BY", "112", "05", "", "", "", "54.0985", "28.3331", "Europe/Minsk"),
("618806", "Zhlobin", "Жлобин", "BY", "112", "02", "", "", "", "52.8926", "30.024", "Europe/Minsk"),
("620127", "Vitebsk", "Витебск", "BY", "112", "07", "", "", "", "55.1904", "30.2049", "Europe/Minsk"),
("620181", "Vilyeyka", "Вилейка", "BY", "112", "05", "", "", "", "54.4914", "26.9111", "Europe/Minsk"),
("620391", "Vawkavysk", "Волковыск", "BY", "112", "03", "", "", "", "53.1561", "24.4513", "Europe/Minsk"),
("621074", "Svyetlahorsk", "Светлогорск", "BY", "112", "02", "", "", "", "52.6329", "29.7389", "Europe/Minsk"),
("621266", "Stowbtsy", "Столбцы", "BY", "112", "05", "", "", "", "53.4785", "26.7434", "Europe/Minsk"),
("621713", "Smarhon'", "Сморгонь", "BY", "112", "03", "", "", "", "54.4798", "26.3957", "Europe/Minsk"),
("621741", "Slutsk", "Слуцк", "BY", "112", "05", "", "", "", "53.0274", "27.5597", "Europe/Minsk"),
("621754", "Slonim", "Слоним", "BY", "112", "03", "", "", "", "53.0869", "25.3163", "Europe/Minsk"),
("622113", "Shchuchin", "Щучин", "BY", "112", "03", "", "", "", "53.6014", "24.7465", "Europe/Minsk"),
("622428", "Salihorsk", "Солигорск", "BY", "112", "05", "", "", "", "52.7876", "27.5415", "Europe/Minsk"),
("622739", "Rahachow", "Рогачев", "BY", "112", "02", "", "", "", "53.0934", "30.0495", "Europe/Minsk"),
("622794", "Rechytsa", "Речица", "BY", "112", "02", "", "", "", "52.3617", "30.3916", "Europe/Minsk"),
("622997", "Pruzhany", "Пружаны", "BY", "112", "01", "", "", "", "52.556", "24.4573", "Europe/Minsk"),
("623317", "Polatsk", "Полоцк", "BY", "112", "07", "", "", "", "55.4879", "28.7856", "Europe/Minsk"),
("623549", "Pinsk", "Пинск", "BY", "112", "01", "", "", "", "52.1229", "26.0951", "Europe/Minsk"),
("623760", "Pastavy", "Поставы", "BY", "112", "07", "", "", "", "55.11676", "26.83263", "Europe/Minsk"),
("624034", "Asipovichy", "Осиповичи", "BY", "112", "06", "", "", "", "53.3011", "28.6386", "Europe/Minsk"),
("624079", "Orsha", "Орша", "BY", "112", "07", "", "", "", "54.5081", "30.4172", "Europe/Minsk"),
("624400", "Novoye Medvezhino", "Медвежино", "BY", "112", "04", "", "", "", "53.88333", "27.45", "Europe/Minsk"),
("624784", "Navapolatsk", "Новополоцк", "BY", "112", "07", "", "", "", "55.5318", "28.5987", "Europe/Minsk"),
("624785", "Navahrudak", "Новогрудок", "BY", "112", "03", "", "", "", "53.5942", "25.8191", "Europe/Minsk"),
("625144", "Minsk", "Минск", "BY", "112", "04", "", "", "", "53.9", "27.56667", "Europe/Minsk"),
("625324", "Mazyr", "Мозырь", "BY", "112", "02", "", "", "", "52.0495", "29.2456", "Europe/Minsk"),
("625367", "Masty", "Мосты", "BY", "112", "03", "", "", "", "53.4122", "24.5387", "Europe/Minsk"),
("625409", "Mar''ina Horka", "Марьина Горка", "BY", "112", "05", "", "", "", "53.509", "28.147", "Europe/Minsk"),
("625625", "Maladzyechna", "Молодечно", "BY", "112", "05", "", "", "", "54.3167", "26.854", "Europe/Minsk"),
("625665", "Mahilyow", "Могилёв", "BY", "112", "06", "", "", "", "53.9168", "30.3449", "Europe/Minsk"),
("625743", "Lyepyel'", "Лепель", "BY", "112", "07", "", "", "", "54.8814", "28.699", "Europe/Minsk"),
("625818", "Luninyets", "Лунинец", "BY", "112", "01", "", "", "", "52.2472", "26.8047", "Europe/Minsk"),
("626081", "Lida", "Лида", "BY", "112", "03", "", "", "", "53.88333", "25.29972", "Europe/Minsk"),
("626450", "Krychaw", "Кричев", "BY", "112", "06", "", "", "", "53.7125", "31.717", "Europe/Minsk"),
("627083", "Kalodzishchy", "Колодищи", "BY", "112", "05", "", "", "", "53.944", "27.7823", "Europe/Minsk"),
("627145", "Kobryn", "Кобрин", "BY", "112", "01", "", "", "", "52.2138", "24.3564", "Europe/Minsk"),
("627751", "Kalinkavichy", "Калинковичи", "BY", "112", "02", "", "", "", "52.1323", "29.3257", "Europe/Minsk"),
("627800", "Ivatsevichy", "Ивацевичи", "BY", "112", "01", "", "", "", "52.709", "25.3401", "Europe/Minsk"),
("627904", "Hrodna", "Гродно", "BY", "112", "03", "", "", "", "53.6884", "23.8258", "Europe/Minsk"),
("627905", "Horki", "Горки", "BY", "112", "06", "", "", "", "54.2862", "30.9863", "Europe/Minsk"),
("627907", "Gomel", "Гомель", "BY", "112", "02", "", "", "", "52.4345", "30.9754", "Europe/Minsk"),
("627908", "Hlybokaye", "Глубокое", "BY", "112", "07", "", "", "", "55.1384", "27.6905", "Europe/Minsk"),
("628634", "Dzyarzhynsk", "Дзержинск", "BY", "112", "05", "", "", "", "53.6832", "27.138", "Europe/Minsk"),
("629018", "Dobrush", "Добруш", "BY", "112", "02", "", "", "", "52.4089", "31.3237", "Europe/Minsk"),
("629447", "Bykhaw", "Быхов", "BY", "112", "06", "", "", "", "53.521", "30.2454", "Europe/Minsk"),
("629454", "Byaroza", "Берёза", "BY", "112", "01", "", "", "", "52.5314", "24.9786", "Europe/Minsk"),
("629634", "Brest", "Брест", "BY", "112", "01", "", "", "", "52.09755", "23.68775", "Europe/Minsk"),
("630376", "Horad Barysaw", "Город Борисов", "BY", "112", "05", "", "", "", "54.2279", "28.505", "Europe/Minsk"),
("630429", "Baranovichi", "Барановичи", "BY", "112", "01", "", "", "", "53.1327", "26.0139", "Europe/Minsk"),
("630468", "Babruysk", "Бобруйск", "BY", "112", "06", "", "", "", "53.1384", "29.2214", "Europe/Minsk"),
("8020218", "Malinovka", "Малиновка", "BY", "112", "04", "", "", "", "53.8579", "27.4374", "Europe/Minsk"),
("3581194", "San Ignacio", "", "BZ", "84", "02", "", "", "", "17.15297", "-89.08058", "America/Belize"),
("3581514", "Orange Walk", "", "BZ", "84", "04", "", "", "", "18.08124", "-88.56328", "America/Belize"),
("3582672", "Belmopan", "Бельмопан", "BZ", "84", "02", "", "", "", "17.25", "-88.76667", "America/Belize"),
("3582677", "Belize City", "Белиз", "BZ", "84", "01", "", "", "", "17.49952", "-88.19756", "America/Belize"),
("5881791", "Abbotsford", "Абботсфорд", "CA", "124", "02", "5957659", "", "", "49.05798", "-122.25257", "America/Vancouver"),
("5882799", "Airdrie", "", "CA", "124", "01", "", "", "", "51.30011", "-114.03528", "America/Edmonton"),
("5882873", "Ajax", "Эйджакс", "CA", "124", "08", "", "", "", "43.85012", "-79.03288", "America/Toronto"),
("5884083", "Alma", "Алма", "CA", "124", "10", "02", "", "", "48.55009", "-71.6491", "America/Montreal"),
("5884588", "Amos", "", "CA", "124", "10", "08", "", "", "48.56688", "-78.11624", "America/Montreal"),
("5885383", "Anmore", "", "CA", "124", "02", "5915", "", "", "49.31637", "-122.85263", "America/Vancouver"),
("5889745", "Baie-Comeau", "", "CA", "124", "10", "09", "", "", "49.21679", "-68.14894", "America/Montreal"),
("5894171", "Barrie", "Барри", "CA", "124", "08", "", "", "", "44.40011", "-79.66634", "America/Toronto"),
("5895650", "Beaconsfield", "", "CA", "124", "10", "", "", "", "45.43341", "-73.86586", "America/Montreal"),
("5897884", "Belleville", "Бельвиль", "CA", "124", "08", "", "", "", "44.16682", "-77.38277", "America/Toronto"),
("5898138", "Beloeil", "", "CA", "124", "10", "16", "", "", "45.56678", "-73.19915", "America/Montreal"),
("5903510", "Blainville", "", "CA", "124", "10", "15", "", "", "45.66678", "-73.88249", "America/Montreal"),
("5905132", "Boisbriand", "", "CA", "124", "10", "15", "", "", "45.61678", "-73.83249", "America/Montreal"),
("5906267", "Boucherville", "Бушервиль", "CA", "124", "10", "16", "", "", "45.59104", "-73.43605", "America/Montreal"),
("5907180", "Bradford West Gwillimbury", "", "CA", "124", "08", "", "", "", "44.11681", "-79.61633", "America/Toronto"),
("5907364", "Brampton", "Брамптон", "CA", "124", "08", "", "", "", "43.68341", "-79.76633", "America/Toronto"),
("5907896", "Brandon", "Брэндон", "CA", "124", "03", "", "", "", "49.84692", "-99.95306", "America/Winnipeg"),
("5907983", "Brant", "", "CA", "124", "08", "", "", "", "43.1334", "-80.34967", "America/Toronto"),
("5907990", "Brantford", "Брантфорд", "CA", "124", "08", "", "", "", "43.1334", "-80.26636", "America/Toronto"),
("5909294", "Brockville", "Броквилл", "CA", "124", "08", "", "", "", "44.59132", "-75.68705", "America/Toronto"),
("5909629", "Brossard", "", "CA", "124", "10", "16", "", "", "45.45008", "-73.46583", "America/Montreal"),
("5911592", "Burlington", "Берлингтон", "CA", "124", "08", "", "", "", "43.38621", "-79.83713", "America/Toronto"),
("5911606", "Burnaby", "Бернаби", "CA", "124", "02", "", "", "", "49.26636", "-122.95263", "America/Vancouver"),
("5913490", "Calgary", "Калгари", "CA", "124", "01", "", "", "", "51.05011", "-114.08529", "America/Edmonton"),
("5913695", "Cambridge", "Кеймбридж", "CA", "124", "08", "", "", "", "43.3601", "-80.31269", "America/Toronto"),
("5914132", "Campbell River", "Кэмпбелл-Ривер", "CA", "124", "02", "", "", "", "50.01634", "-125.24459", "America/Vancouver"),
("5914653", "Camrose", "", "CA", "124", "01", "", "", "", "53.01684", "-112.83525", "America/Edmonton"),
("5914826", "Candiac", "", "CA", "124", "10", "16", "", "", "45.38338", "-73.51587", "America/Montreal"),
("5919566", "Chambly", "Шамбли", "CA", "124", "10", "16", "", "", "45.45008", "-73.28246", "America/Montreal"),
("5920288", "Charlottetown", "Шарлоттаун", "CA", "124", "09", "", "", "", "46.23525", "-63.12671", "America/Halifax"),
("5920433", "Chateauguay", "", "CA", "124", "10", "16", "", "", "45.38338", "-73.74919", "America/Montreal"),
("5921356", "Chilliwack", "", "CA", "124", "02", "5909", "", "", "49.16638", "-121.95257", "America/Vancouver"),
("5923101", "Clarence-Rockland", "", "CA", "124", "08", "", "", "", "45.5501", "-75.29101", "America/Toronto"),
("5924579", "Cobourg", "", "CA", "124", "08", "", "", "", "43.95977", "-78.16515", "America/Toronto"),
("5924618", "Cochrane", "", "CA", "124", "01", "", "", "", "51.18341", "-114.46871", "America/Edmonton"),
("5925975", "Collingwood", "", "CA", "124", "08", "", "", "", "44.4834", "-80.21638", "America/Toronto"),
("5926511", "Conception Bay South", "", "CA", "124", "05", "", "", "", "47.49989", "-52.99806", "America/St_Johns"),
("5927689", "Coquitlam", "", "CA", "124", "02", "", "", "", "49.28297", "-122.75262", "America/Vancouver"),
("5927969", "Corner Brook", "Корнер-Брук", "CA", "124", "05", "", "", "", "48.95001", "-57.95202", "America/St_Johns"),
("5928065", "Cornwall", "", "CA", "124", "08", "", "", "", "45.01809", "-74.72815", "America/Toronto"),
("5928488", "Cote-Saint-Luc", "", "CA", "124", "10", "", "", "", "45.46536", "-73.66585", "America/Montreal"),
("5930890", "Courtenay", "Куртенэ", "CA", "124", "02", "", "", "", "49.68657", "-124.9936", "America/Vancouver"),
("5931800", "Cranbrook", "Кранбрук", "CA", "124", "02", "", "", "", "49.49991", "-115.76879", "America/Edmonton"),
("5935277", "Dartmouth", "", "CA", "124", "07", "", "", "", "44.67134", "-63.57719", "America/Halifax"),
("5937615", "Delta", "Дельта", "CA", "124", "02", "", "", "", "49.14399", "-122.9068", "America/Vancouver"),
("5938513", "Deux-Montagnes", "", "CA", "124", "10", "15", "", "", "45.53455", "-73.90168", "America/Montreal"),
("5939219", "Dieppe", "Дьеп", "CA", "124", "04", "", "", "", "46.07844", "-64.68735", "America/Moncton"),
("5940956", "Dollard-Des Ormeaux", "", "CA", "124", "10", "", "", "", "45.49452", "-73.82419", "America/Montreal"),
("5941925", "Dorval", "Дорваль", "CA", "124", "10", "", "", "", "45.4473", "-73.75335", "America/Montreal"),
("5942845", "Drummondville", "Драммондвилл", "CA", "124", "10", "17", "", "", "45.88336", "-72.48241", "America/Montreal"),
("5943865", "Duncan", "Дункан", "CA", "124", "02", "", "", "", "48.78293", "-123.70266", "America/Vancouver"),
("5946768", "Edmonton", "Эдмонтон", "CA", "124", "01", "", "", "", "53.55014", "-113.46871", "America/Edmonton"),
("5950267", "Etobicoke", "Этобико", "CA", "124", "08", "", "", "", "43.65421", "-79.56711", "America/Toronto"),
("5955815", "Fort Erie", "", "CA", "124", "08", "", "", "", "42.90012", "-78.93286", "America/Toronto"),
("5955895", "Fort McMurray", "", "CA", "124", "01", "", "", "", "56.72676", "-111.38103", "America/Edmonton"),
("5955960", "Fort St. John", "Форт-Сент-Джон", "CA", "124", "02", "", "", "", "56.24988", "-120.85292", "America/Dawson_Creek"),
("5957776", "Fredericton", "Фредериктон", "CA", "124", "04", "", "", "", "45.94541", "-66.66558", "America/Moncton"),
("5959974", "Gatineau", "Гатино", "CA", "124", "10", "07", "", "", "45.47723", "-75.70164", "America/Montreal"),
("5961564", "Glace Bay", "", "CA", "124", "07", "", "", "", "46.19695", "-59.95698", "America/Glace_Bay"),
("5964215", "Granby", "Гранби", "CA", "124", "10", "16", "", "", "45.40008", "-72.73243", "America/Montreal"),
("5964347", "Grande Prairie", "Гранд-Прери", "CA", "124", "01", "", "", "", "55.16667", "-118.80271", "America/Edmonton"),
("5964700", "Greater Sudbury", "Большой Садбери", "CA", "124", "08", "", "", "", "46.49", "-80.99001", "America/Toronto"),
("5965812", "Greater Napanee", "", "CA", "124", "08", "", "", "", "44.25012", "-76.94944", "America/Toronto"),
("5967629", "Guelph", "Гелф", "CA", "124", "08", "6177913", "", "", "43.54594", "-80.25599", "America/Toronto"),
("5969782", "Hamilton", "Гамильтон", "CA", "124", "08", "", "", "", "43.25011", "-79.84963", "America/Toronto"),
("5978765", "Huntsville", "Хантсвилл", "CA", "124", "08", "", "", "", "45.33341", "-79.21632", "America/Toronto"),
("5987650", "Joliette", "", "CA", "124", "10", "14", "", "", "46.01677", "-73.44915", "America/Montreal"),
("5989045", "Kamloops", "Камлупс", "CA", "124", "02", "", "", "", "50.66648", "-120.3192", "America/Vancouver"),
("5990579", "Kelowna", "Келоуна", "CA", "124", "02", "", "", "", "49.88307", "-119.48568", "America/Vancouver"),
("5991370", "Keswick", "", "CA", "124", "08", "", "", "", "44.25011", "-79.46632", "America/Toronto"),
("5992500", "Kingston", "Кингстон", "CA", "124", "08", "", "", "", "44.22976", "-76.48098", "America/Toronto"),
("5992830", "Kirkland", "", "CA", "124", "10", "", "", "", "45.45008", "-73.86586", "America/Montreal"),
("5992996", "Kitchener", "Китченер", "CA", "124", "08", "", "", "", "43.42537", "-80.5112", "America/Toronto"),
("6049388", "Langford", "", "CA", "124", "02", "", "", "", "48.44963", "-123.50261", "America/Vancouver"),
("6049429", "Langley", "", "CA", "124", "02", "", "", "", "49.10107", "-122.65883", "America/Vancouver"),
("6049430", "Langley", "", "CA", "124", "02", "", "", "", "49.08297", "-122.58589", "America/Vancouver"),
("6049863", "La Prairie", "", "CA", "124", "10", "16", "", "", "45.41678", "-73.49917", "America/Montreal"),
("6050263", "L'Assomption", "", "CA", "124", "10", "14", "", "", "45.82318", "-73.4294", "America/Montreal"),
("6050610", "Laval", "Лаваль", "CA", "124", "10", "13", "", "", "45.56995", "-73.692", "America/Montreal"),
("6051562", "Leduc", "", "CA", "124", "01", "", "", "", "53.26682", "-113.55201", "America/Edmonton"),
("6053154", "Lethbridge", "Летбридж", "CA", "124", "01", "", "", "", "49.69999", "-112.81856", "America/Edmonton"),
("6058024", "Lloydminster", "Ллойдминстер", "CA", "124", "11", "", "", "", "53.28346", "-110.00157", "America/Edmonton"),
("6058560", "London", "Лондон", "CA", "124", "08", "", "", "", "42.98339", "-81.23304", "America/Toronto"),
("6059891", "Longueuil", "Лонгёй", "CA", "124", "10", "16", "", "", "45.53121", "-73.51806", "America/Montreal"),
("6064180", "Magog", "Мейгог", "CA", "124", "10", "05", "", "", "45.26678", "-72.14909", "America/Montreal"),
("6065686", "Maple Ridge", "Мэпл-Ридж", "CA", "124", "02", "", "", "", "49.21939", "-122.60193", "America/Vancouver"),
("6066513", "Markham", "Маркем", "CA", "124", "08", "", "", "", "43.86682", "-79.2663", "America/Toronto"),
("6067494", "Mascouche", "", "CA", "124", "10", "14", "", "", "45.74965", "-73.59956", "America/Montreal"),
("6071618", "Medicine Hat", "Медисин-Хат", "CA", "124", "01", "", "", "", "50.05006", "-110.66834", "America/Edmonton"),
("6073363", "Midland", "", "CA", "124", "08", "", "", "", "44.7501", "-79.88296", "America/Toronto"),
("6074377", "Milton", "Милтон", "CA", "124", "08", "5969719", "", "", "43.51681", "-79.88294", "America/Toronto"),
("6075061", "Mirabel", "Мирабель", "CA", "124", "10", "15", "", "", "45.65008", "-74.08251", "America/Montreal"),
("6075081", "Miramichi", "Мирамиши", "CA", "124", "04", "1309", "", "", "47.02895", "-65.50186", "America/Moncton"),
("6075357", "Mississauga", "Миссиссога", "CA", "124", "08", "", "", "", "43.5789", "-79.6583", "America/Toronto"),
("6076211", "Moncton", "Монктон", "CA", "124", "04", "", "", "", "46.11594", "-64.80186", "America/Moncton"),
("6077243", "Montreal", "Монреаль", "CA", "124", "10", "06", "", "", "45.50884", "-73.58781", "America/Montreal"),
("6077315", "Mont-Royal", "", "CA", "124", "10", "", "", "", "45.51675", "-73.64918", "America/Montreal"),
("6077340", "Mont-Saint-Hilaire", "", "CA", "124", "10", "16", "", "", "45.56678", "-73.19915", "America/Montreal"),
("6078112", "Moose Jaw", "Мус-Джо", "CA", "124", "11", "", "", "", "50.40005", "-105.53445", "America/Regina"),
("6082231", "Mount Pearl", "", "CA", "124", "05", "", "", "", "47.51659", "-52.78135", "America/St_Johns"),
("6085772", "Nanaimo", "Нанаймо", "CA", "124", "02", "", "", "", "49.16638", "-123.94003", "America/Vancouver"),
("6087579", "New Glasgow", "", "CA", "124", "07", "", "", "", "45.58344", "-62.64863", "America/Halifax"),
("6087701", "Newmarket", "Ньюмаркет", "CA", "124", "08", "", "", "", "44.05011", "-79.46631", "America/Toronto"),
("6087844", "New Westminster", "Нью-Уэстминстер", "CA", "124", "02", "", "", "", "49.20678", "-122.91092", "America/Vancouver"),
("6087892", "Niagara Falls", "Ниагара-Фолс", "CA", "124", "08", "", "", "", "43.10012", "-79.06627", "America/Toronto"),
("6089125", "Norfolk County", "", "CA", "124", "08", "", "", "", "42.8334", "-80.38297", "America/Toronto"),
("6089404", "North Battleford", "", "CA", "124", "11", "", "", "", "52.77972", "-108.2967", "America/Regina"),
("6089426", "North Bay", "Норт-Бей", "CA", "124", "08", "", "", "", "46.3168", "-79.46633", "America/Toronto"),
("6089661", "North Cowichan", "", "CA", "124", "02", "", "", "", "48.84133", "-123.68596", "America/Vancouver"),
("6090785", "North Vancouver", "", "CA", "124", "02", "5909", "", "", "49.31636", "-123.06934", "America/Vancouver"),
("6091104", "North York", "Норт-Йорк", "CA", "124", "08", "", "", "", "43.76681", "-79.4163", "America/Toronto"),
("6091919", "Oak Bay", "", "CA", "124", "02", "", "", "", "48.44964", "-123.3026", "America/Vancouver"),
("6092122", "Oakville", "Оквилл", "CA", "124", "08", "", "", "", "43.45011", "-79.68292", "America/Toronto"),
("6094201", "Orangeville", "", "CA", "124", "08", "", "", "", "43.9168", "-80.09967", "America/Toronto"),
("6094325", "Orillia", "Ориллия", "CA", "124", "08", "", "", "", "44.60868", "-79.42068", "America/Toronto"),
("6094578", "Oshawa", "Ошава", "CA", "124", "08", "", "", "", "43.90012", "-78.84957", "America/Toronto"),
("6094817", "Ottawa", "Оттава", "CA", "124", "08", "", "", "", "45.41117", "-75.69812", "America/Toronto"),
("6095645", "Owen Sound", "Оуэн-Саунд", "CA", "124", "08", "", "", "", "44.56717", "-80.94349", "America/Toronto"),
("6098642", "Parksville", "", "CA", "124", "02", "5921", "", "", "49.31835", "-124.31494", "America/Vancouver"),
("6100832", "Pembroke", "", "CA", "124", "08", "", "", "", "45.81681", "-77.11616", "America/Toronto"),
("6101141", "Penticton", "", "CA", "124", "02", "", "", "", "49.48062", "-119.58584", "America/Vancouver"),
("6101606", "Petawawa", "", "CA", "124", "08", "", "", "", "45.89452", "-77.28007", "America/Toronto"),
("6101645", "Peterborough", "Питерборо", "CA", "124", "08", "", "", "", "44.30012", "-78.31623", "America/Toronto"),
("6104111", "Pickering", "Пикеринг", "CA", "124", "08", "", "", "", "43.90012", "-79.13289", "America/Toronto"),
("6105815", "Pitt Meadows", "Питт-Медоус", "CA", "124", "02", "", "", "", "49.22119", "-122.68965", "America/Vancouver"),
("6107325", "Pointe-Claire", "", "CA", "124", "10", "06", "", "", "45.44868", "-73.81669", "America/Montreal"),
("6111632", "Port Alberni", "", "CA", "124", "02", "", "", "", "49.24133", "-124.8028", "America/Vancouver"),
("6111704", "Port Colborne", "", "CA", "124", "08", "", "", "", "42.90012", "-79.23288", "America/Toronto"),
("6111962", "Port Moody", "", "CA", "124", "02", "", "", "", "49.28297", "-122.85263", "America/Vancouver"),
("6113335", "Prince Albert", "Принс-Альберт", "CA", "124", "11", "", "", "", "53.20008", "-105.76772", "America/Regina"),
("6113355", "Prince Edward", "", "CA", "124", "08", "", "", "", "44.00012", "-77.24946", "America/Toronto"),
("6113365", "Prince George", "Принс-Джордж", "CA", "124", "02", "", "", "", "53.9166", "-122.75301", "America/Vancouver"),
("6115355", "Quinte West", "", "CA", "124", "08", "", "", "", "44.18342", "-77.56618", "America/Toronto"),
("6117731", "Rayside-Balfour", "", "CA", "124", "08", "", "", "", "46.60873", "-81.20763", "America/Toronto"),
("6118158", "Red Deer", "Ред-Дир", "CA", "124", "01", "", "", "", "52.26682", "-113.802", "America/Edmonton"),
("6119109", "Regina", "Реджайна", "CA", "124", "11", "", "", "", "50.45008", "-104.6178", "America/Regina"),
("6119518", "Repentigny", "Репантиньи", "CA", "124", "10", "14", "", "", "45.74222", "-73.45008", "America/Montreal"),
("6122085", "Richmond", "Ричмонд", "CA", "124", "02", "", "", "", "49.17003", "-123.13683", "America/Vancouver"),
("6122091", "Richmond Hill", "", "CA", "124", "08", "", "", "", "43.87111", "-79.43725", "America/Toronto"),
("6128577", "Rouyn-Noranda", "Руэн-Норанда", "CA", "124", "10", "08", "", "", "48.23656", "-79.02311", "America/Montreal"),
("6137270", "Saguenay", "Сагеней", "CA", "124", "10", "02", "", "", "48.41675", "-71.06573", "America/Montreal"),
("6137489", "Saint-Basile-le-Grand", "", "CA", "124", "10", "16", "", "", "45.53338", "-73.28246", "America/Montreal"),
("6137540", "Saint-Bruno-de-Montarville", "", "CA", "124", "10", "", "", "", "45.53341", "-73.34916", "America/Montreal"),
("6137633", "Saint-Constant", "", "CA", "124", "10", "16", "", "", "45.36678", "-73.56588", "America/Montreal"),
("6137781", "Sainte-Catherine", "", "CA", "124", "10", "", "", "", "46.31836", "-72.56632", "America/Montreal"),
("6137941", "Sainte-Julie", "", "CA", "124", "10", "16", "", "", "45.58338", "-73.33246", "America/Montreal"),
("6138121", "Sainte-Therese", "", "CA", "124", "10", "15", "", "", "45.63922", "-73.82757", "America/Montreal"),
("6138175", "Saint-Eustache", "", "CA", "124", "10", "15", "", "", "45.565", "-73.90554", "America/Montreal"),
("6138374", "Saint-Hyacinthe", "Санкт-Гиацинт", "CA", "124", "10", "16", "", "", "45.63076", "-72.95699", "America/Montreal"),
("6138495", "Saint-Jean-sur-Richelieu", "Сен-Жан-сюр-Ришелье", "CA", "124", "10", "16", "", "", "45.30713", "-73.26259", "America/Montreal"),
("6138501", "Saint-Jerome", "Сен-Жером", "CA", "124", "10", "15", "", "", "45.78036", "-74.00365", "America/Montreal"),
("6138517", "Saint John", "Сент-Джон", "CA", "124", "04", "", "", "", "45.27271", "-66.06766", "America/Moncton"),
("6138610", "Saint-Laurent", "Сен-Лоран", "CA", "124", "10", "", "", "", "45.50008", "-73.66585", "America/Montreal"),
("6138617", "Saint-Lazare", "", "CA", "124", "10", "16", "", "", "45.40008", "-74.13256", "America/Montreal"),
("6138625", "Saint-Leonard", "", "CA", "124", "10", "06", "", "", "45.58773", "-73.59501", "America/Montreal"),
("6139289", "Salaberry-de-Valleyfield", "Салаберри-де-Валлифилд", "CA", "124", "10", "16", "", "", "45.25008", "-74.13253", "America/Montreal"),
("6139416", "Salmon Arm", "Сэлмон-Арм", "CA", "124", "02", "", "", "", "50.6998", "-119.30237", "America/Vancouver"),
("6141190", "Sarnia", "Сарния", "CA", "124", "08", "", "", "", "42.97866", "-82.40407", "America/Toronto"),
("6141256", "Saskatoon", "Саскатун", "CA", "124", "11", "", "", "", "52.11679", "-106.63452", "America/Regina"),
("6141439", "Sault Ste. Marie", "", "CA", "124", "08", "5883638", "", "", "46.51677", "-84.33325", "America/Toronto"),
("6144312", "Sept-Iles", "Сет-Иль", "CA", "124", "10", "09", "", "", "50.20011", "-66.38208", "America/Montreal"),
("6145489", "Shawinigan", "Шавиниган", "CA", "124", "10", "04", "", "", "46.56675", "-72.74913", "America/Montreal"),
("6146143", "Sherbrooke", "Шербрук", "CA", "124", "10", "05", "", "", "45.40008", "-71.89908", "America/Montreal"),
("6146279", "Sherwood Park", "", "CA", "124", "01", "", "", "", "53.51684", "-113.3187", "America/Edmonton"),
("6151352", "Sorel-Tracy", "Сорель-Трейси", "CA", "124", "10", "16", "", "", "46.03336", "-73.11585", "America/Montreal"),
("6154383", "Spruce Grove", "", "CA", "124", "01", "", "", "", "53.53344", "-113.91874", "America/Edmonton"),
("6155033", "St. Albert", "", "CA", "124", "01", "", "", "", "53.63344", "-113.63533", "America/Edmonton"),
("6155721", "St. Catharines", "Сент-Катаринс", "CA", "124", "08", "6087883", "", "", "43.17126", "-79.24267", "America/Toronto"),
("6157977", "Stratford", "Стратфорд", "CA", "124", "08", "", "", "", "43.36679", "-80.94972", "America/Toronto"),
("6158357", "St. Thomas", "", "CA", "124", "08", "", "", "", "42.77361", "-81.18038", "America/Toronto"),
("6159905", "Surrey", "Суррей", "CA", "124", "02", "", "", "", "49.10635", "-122.82509", "America/Vancouver"),
("6162949", "Terrace", "", "CA", "124", "02", "", "", "", "54.51634", "-128.60345", "America/Vancouver"),
("6163012", "Terrebonne", "Тербон", "CA", "124", "10", "14", "", "", "45.70004", "-73.64732", "America/Montreal"),
("6165719", "Thorold", "", "CA", "124", "08", "", "", "", "43.11682", "-79.19958", "America/Toronto"),
("6166142", "Thunder Bay", "Тандер-Бей", "CA", "124", "08", "6166139", "", "", "48.38202", "-89.25018", "America/Thunder_Bay"),
("6166739", "Timmins", "", "CA", "124", "08", "", "", "", "48.46686", "-81.33312", "America/Toronto"),
("6167865", "Toronto", "Торонто", "CA", "124", "08", "", "", "", "43.70011", "-79.4163", "America/Toronto"),
("6169141", "Trois-Rivieres", "Труа-Ривьер", "CA", "124", "10", "04", "", "", "46.34515", "-72.5477", "America/Montreal"),
("6169587", "Truro", "Труро", "CA", "124", "07", "", "", "", "45.36685", "-63.26538", "America/Halifax"),
("6173017", "Val-d'Or", "Валь-д'Ор", "CA", "124", "10", "08", "", "", "48.10018", "-77.7828", "America/Montreal"),
("6173331", "Vancouver", "Ванкувер", "CA", "124", "02", "", "", "", "49.24966", "-123.11934", "America/Vancouver"),
("6173508", "Varennes", "", "CA", "124", "10", "16", "", "", "45.68338", "-73.43246", "America/Montreal"),
("6173570", "Vaudreuil-Dorion", "", "CA", "124", "10", "16", "", "", "45.40008", "-74.03251", "America/Montreal"),
("6173577", "Vaughan", "Вон", "CA", "124", "08", "", "", "", "43.8361", "-79.49827", "America/Toronto"),
("6173864", "Vernon", "Вернон", "CA", "124", "02", "", "", "", "50.25809", "-119.26905", "America/Vancouver"),
("6174041", "Victoria", "Виктория", "CA", "124", "02", "", "", "", "48.43294", "-123.3693", "America/Vancouver"),
("6174151", "Victoriaville", "Викториавилл", "CA", "124", "10", "04", "", "", "46.05007", "-71.96579", "America/Montreal"),
("6176823", "Waterloo", "Ватерлоо", "CA", "124", "08", "", "", "", "43.4668", "-80.51639", "America/Toronto"),
("6177869", "Welland", "", "CA", "124", "08", "", "", "", "42.98342", "-79.24958", "America/Toronto"),
("6178582", "West End", "", "CA", "124", "02", "", "", "", "49.28333", "-123.13333", "America/Vancouver"),
("6179226", "Westmount", "Уэстмаунт", "CA", "124", "10", "", "", "", "45.48341", "-73.59918", "America/Montreal"),
("6180550", "Whitehorse", "Уайтхорс", "CA", "124", "12", "", "", "", "60.71611", "-135.05375", "America/Whitehorse"),
("6180961", "White Rock", "", "CA", "124", "02", "5915", "", "", "49.01636", "-122.8026", "America/Vancouver"),
("6182962", "Windsor", "Уинсор", "CA", "124", "08", "", "", "", "42.30008", "-83.01654", "America/Toronto"),
("6183235", "Winnipeg", "Виннипег", "CA", "124", "03", "", "", "", "49.8844", "-97.14704", "America/Winnipeg"),
("6184365", "Woodstock", "Вудсток", "CA", "124", "08", "", "", "", "43.13339", "-80.7497", "America/Toronto"),
("6185377", "Yellowknife", "Йеллоунайф", "CA", "124", "13", "", "", "", "62.456", "-114.35255", "America/Yellowknife"),
("6185607", "Yorkton", "", "CA", "124", "11", "", "", "", "51.2167", "-102.46766", "America/Regina"),
("6324729", "Halifax", "Галифакс", "CA", "124", "07", "", "", "", "44.64533", "-63.57239", "America/Halifax"),
("6324733", "St. John's", "Сент-Джонс", "CA", "124", "05", "", "", "", "47.56494", "-52.70931", "America/St_Johns"),
("6325494", "Quebec", "Квебек", "CA", "124", "10", "", "", "", "46.81228", "-71.21454", "America/Montreal"),
("6325521", "Levis", "Леви", "CA", "124", "10", "12", "", "", "46.80326", "-71.17793", "America/Montreal"),
("6354895", "Rimouski", "Римуски", "CA", "124", "10", "01", "", "", "48.44879", "-68.52396", "America/Montreal"),
("6354897", "Riviere-du-Loup", "Ривьер-дю-Лу", "CA", "124", "10", "01", "", "", "47.82699", "-69.54243", "America/Montreal"),
("6354908", "Sydney", "", "CA", "124", "07", "", "", "", "46.1351", "-60.1831", "America/Glace_Bay"),
("6534203", "L'Ancienne-Lorette", "", "CA", "124", "10", "", "", "", "46.79392", "-71.35191", "America/Montreal"),
("6545023", "Edmundston", "Эдмундстон", "CA", "124", "04", "", "", "", "47.3737", "-68.32512", "America/Moncton"),
("6943827", "Thetford-Mines", "", "CA", "124", "10", "12", "", "", "46.09371", "-71.30539", "America/Montreal"),
("7280414", "Cole Harbour", "", "CA", "124", "07", "", "", "", "44.67244", "-63.47506", "America/Halifax"),
("7281931", "Okanagan", "", "CA", "124", "02", "", "", "", "50.36386", "-119.34997", "America/Vancouver"),
("7281936", "West Kelowna", "", "CA", "124", "02", "", "", "", "49.8625", "-119.58333", "America/Vancouver"),
("7302647", "Bellechasse Regional County Municipality", "", "CA", "124", "10", "12", "", "", "46.66667", "-70.71667", "America/Montreal"),
("7303786", "Jonquiere", "Жонкьер", "CA", "124", "10", "02", "", "", "48.41648", "-71.24884", "America/Montreal"),
("7535681", "Saint-Augustin-de-Desmaures", "", "CA", "124", "10", "03", "", "", "46.74064", "-71.45131", "America/Montreal"),
("7602078", "Ladner", "", "CA", "124", "02", "", "", "", "49.08938", "-123.08241", "America/Vancouver"),
("7669012", "Walnut Grove", "", "CA", "124", "02", "", "", "", "49.16473", "-122.64042", "America/Vancouver"),
("8285452", "Ancaster", "Анкастер", "CA", "124", "08", "", "", "", "43.21806", "-79.98716", "America/Toronto"),
("8533869", "West Vancouver", "", "CA", "124", "02", "", "", "", "49.36672", "-123.16652", "America/Vancouver"),
("8558534", "Willowdale", "", "CA", "124", "08", "", "", "", "43.76672", "-79.39909", "America/Toronto"),
("7304591", "West Island", "", "CC", "166", "", "", "", "", "-12.15681", "96.82251", "Indian/Cocos"),
("237478", "Mobaye", "", "CF", "140", "02", "", "", "", "4.31902", "21.17861", "Africa/Bangui"),
("238566", "Ippy", "", "CF", "140", "11", "", "", "", "6.26793", "21.22468", "Africa/Bangui"),
("239899", "Bria", "Бриа", "CF", "140", "03", "", "", "", "6.54233", "21.98633", "Africa/Bangui"),
("240498", "Bangassou", "Бангасу", "CF", "140", "08", "", "", "", "4.74132", "22.81838", "Africa/Bangui"),
("240604", "Bambari", "Бамбари", "CF", "140", "11", "", "", "", "5.76795", "20.67565", "Africa/Bangui"),
("2383119", "Sibut", "Сибут", "CF", "140", "06", "", "", "", "5.71801", "19.07389", "Africa/Bangui"),
("2383523", "Paoua", "", "CF", "140", "13", "", "", "", "7.24269", "16.44059", "Africa/Bangui"),
("2383827", "Nola", "", "CF", "140", "16", "", "", "", "3.52716", "16.04", "Africa/Bangui"),
("2384770", "Mbaiki", "", "CF", "140", "07", "", "", "", "3.86781", "17.98923", "Africa/Bangui"),
("2386012", "Kaga Bandoro", "", "CF", "140", "15", "", "", "", "6.98961", "19.18744", "Africa/Bangui"),
("2387435", "Damara", "Дамара", "CF", "140", "17", "", "", "", "4.96075", "18.7035", "Africa/Bangui"),
("2387495", "Carnot", "", "CF", "140", "04", "", "", "", "4.94273", "15.87735", "Africa/Bangui"),
("2387546", "Bozoum", "Бозуме", "CF", "140", "13", "", "", "", "6.31933", "16.37992", "Africa/Bangui"),
("2387926", "Bouar", "Буаре", "CF", "140", "09", "", "", "", "5.93404", "15.59599", "Africa/Bangui"),
("2388036", "Bossangoa", "Босангоа", "CF", "140", "12", "", "", "", "6.49263", "17.45518", "Africa/Bangui"),
("2388614", "Boda", "", "CF", "140", "07", "", "", "", "4.31887", "17.46953", "Africa/Bangui"),
("2388873", "Bimbo", "", "CF", "140", "17", "", "", "", "4.25671", "18.41583", "Africa/Bangui"),
("2389086", "Berberati", "Берберати", "CF", "140", "04", "", "", "", "4.26116", "15.79216", "Africa/Bangui"),
("2389691", "Batangafo", "", "CF", "140", "12", "", "", "", "7.30082", "18.2833", "Africa/Bangui"),
("2389853", "Bangui", "Банги", "CF", "140", "18", "", "", "", "4.36122", "18.55496", "Africa/Bangui"),
("2657896", "Zurich", "Цюрих", "CH", "756", "ZH", "112", "261", "", "47.36667", "8.55", "Europe/Zurich"),
("2657908", "Zug", "Цуг", "CH", "756", "ZG", "900", "1711", "", "47.17242", "8.51744", "Europe/Zurich"),
("2657941", "Yverdon-les-Bains", "Ивердон-ле-Бен", "CH", "756", "VD", "2224", "5938", "", "46.77852", "6.64115", "Europe/Zurich"),
("2657970", "Winterthur", "Винтертур", "CH", "756", "ZH", "110", "230", "", "47.50004", "8.7251", "Europe/Zurich"),
("2657996", "Wil", "Виль", "CH", "756", "SG", "1728", "3427", "", "47.46152", "9.04552", "Europe/Zurich"),
("2658011", "Wettingen", "Веттинген", "CH", "756", "AG", "1902", "4045", "", "47.4705", "8.31636", "Europe/Zurich"),
("2658145", "Vevey", "Веве", "CH", "756", "VD", "2230", "5890", "", "46.46299", "6.84345", "Europe/Zurich"),
("2658154", "Vernier", "", "CH", "756", "GE", "2500", "6643", "", "46.21702", "6.08497", "Europe/Zurich"),
("2658216", "Uster", "Устер", "CH", "756", "ZH", "109", "198", "", "47.34713", "8.72091", "Europe/Zurich"),
("2658377", "Thun", "Тун", "CH", "756", "BE", "247", "942", "", "46.75118", "7.62166", "Europe/Zurich"),
("2658494", "Steffisburg", "", "CH", "756", "BE", "247", "939", "", "46.77807", "7.63249", "Europe/Zurich"),
("2658576", "Sitten", "Сьон", "CH", "756", "VS", "2312", "6266", "", "46.22908", "7.35942", "Europe/Zurich"),
("2658606", "Sierre", "", "CH", "756", "VS", "2311", "6248", "", "46.29192", "7.53559", "Europe/Zurich"),
("2658656", "Zuerich (Kreis 11) / Seebach", "", "CH", "756", "ZH", "112", "261", "", "47.42181", "8.54779", "Europe/Zurich"),
("2658761", "Schaffhausen", "Шаффхаузен", "CH", "756", "SH", "1403", "2939", "", "47.69732", "8.63493", "Europe/Zurich"),
("2658822", "Sankt Gallen", "Санкт-Галлен", "CH", "756", "SG", "1721", "3203", "", "47.42391", "9.37477", "Europe/Zurich"),
("2659070", "Renens", "Ренан", "CH", "756", "VD", "2229", "5591", "", "46.53989", "6.5881", "Europe/Zurich"),
("2659099", "Rapperswil", "Рапперсвиль", "CH", "756", "SG", "1726", "3340", "", "47.22557", "8.82228", "Europe/Zurich"),
("2659127", "Pully", "", "CH", "756", "VD", "2226", "5590", "", "46.51027", "6.66183", "Europe/Zurich"),
("2659296", "Onex", "", "CH", "756", "GE", "2500", "6631", "", "46.18391", "6.10181", "Europe/Zurich"),
("2659297", "Olten", "Ольтен", "CH", "756", "SO", "1108", "2581", "", "47.34999", "7.90329", "Europe/Zurich"),
("2659310", "Zuerich (Kreis 11) / Oerlikon", "", "CH", "756", "ZH", "112", "261", "", "47.40823", "8.54258", "Europe/Zurich"),
("2659422", "Nyon", "Ньон", "CH", "756", "VD", "2228", "5724", "", "46.38318", "6.23955", "Europe/Zurich"),
("2659496", "Neuchatel", "Невшатель", "CH", "756", "NE", "2404", "6458", "", "46.99179", "6.931", "Europe/Zurich"),
("2659522", "Muttenz", "Муттенц", "CH", "756", "BL", "1301", "2770", "", "47.52271", "7.64511", "Europe/Zurich"),
("2659601", "Montreux", "Монтрё", "CH", "756", "VD", "2230", "5886", "", "46.43301", "6.91143", "Europe/Zurich"),
("2659613", "Monthey", "Монте", "CH", "756", "VS", "2308", "6153", "", "46.25546", "6.96066", "Europe/Zurich"),
("2659667", "Meyrin", "Мерен", "CH", "756", "GE", "2500", "6630", "", "46.23424", "6.08025", "Europe/Zurich"),
("2659811", "Luzern", "Люцерн", "CH", "756", "LU", "311", "1061", "", "47.05048", "8.30635", "Europe/Zurich"),
("2659836", "Lugano", "Лугано", "CH", "756", "TI", "2105", "5192", "", "46.01008", "8.96004", "Europe/Zurich"),
("2659873", "Littau", "", "CH", "756", "LU", "311", "1061", "", "47.05", "8.26274", "Europe/Zurich"),
("2659977", "Le Chatelard", "Шатлар", "CH", "756", "VD", "2230", "5886", "", "46.44527", "6.89908", "Europe/Zurich"),
("2659994", "Lausanne", "Лозанна", "CH", "756", "VD", "2225", "5586", "", "46.516", "6.63282", "Europe/Zurich"),
("2660076", "La Chaux-de-Fonds", "Ла-Шо-де-Фон", "CH", "756", "NE", "2402", "6421", "", "47.09993", "6.82586", "Europe/Zurich"),
("2660104", "Kriens", "Кринс", "CH", "756", "LU", "312", "1059", "", "47.03537", "8.27631", "Europe/Zurich"),
("2660108", "Kreuzlingen", "Кройцлинген", "CH", "756", "TG", "2013", "4671", "", "47.65", "9.18333", "Europe/Zurich"),
("2660119", "Koniz", "Кёниц", "CH", "756", "BE", "246", "355", "", "46.92436", "7.41457", "Europe/Zurich"),
("2660127", "Kloten", "Клотен", "CH", "756", "ZH", "103", "62", "", "47.45152", "8.58491", "Europe/Zurich"),
("2660221", "Jona", "", "CH", "756", "SG", "1726", "3340", "", "47.22983", "8.83884", "Europe/Zurich"),
("2660305", "Horgen", "Хорген", "CH", "756", "ZH", "106", "133", "", "47.25579", "8.60027", "Europe/Zurich"),
("2660306", "Zuerich (Kreis 10) / Hoengg", "", "CH", "756", "ZH", "112", "261", "", "47.40313", "8.4971", "Europe/Zurich"),
("2660365", "Herisau", "Херизау", "CH", "756", "AR", "1501", "3001", "", "47.38615", "9.27916", "Europe/Zurich"),
("2660512", "Grenchen", "Гренхен", "CH", "756", "SO", "1107", "2546", "", "47.1921", "7.39586", "Europe/Zurich"),
("2660549", "Gossau", "Госсау", "CH", "756", "SG", "1721", "3443", "", "47.41694", "9.25125", "Europe/Zurich"),
("2660646", "Geneve", "Женева", "CH", "756", "GE", "2500", "6621", "", "46.20222", "6.14569", "Europe/Zurich"),
("2660718", "Fribourg", "Фрибур", "CH", "756", "FR", "1004", "2196", "", "46.80237", "7.15128", "Europe/Zurich"),
("2660727", "Frauenfeld", "Фрауэнфельд", "CH", "756", "TG", "2012", "4566", "", "47.55816", "8.89854", "Europe/Zurich"),
("2660911", "Emmen", "Эммен", "CH", "756", "LU", "313", "1024", "", "47.07772", "8.27888", "Europe/Zurich"),
("2660971", "Dubendorf", "", "CH", "756", "ZH", "109", "191", "", "47.39724", "8.61872", "Europe/Zurich"),
("2661015", "Dietikon", "", "CH", "756", "ZH", "111", "243", "", "47.40165", "8.40015", "Europe/Zurich"),
("2661169", "Chur", "Кур", "CH", "756", "GR", "1829", "3901", "", "46.84986", "9.53287", "Europe/Zurich"),
("2661265", "Carouge", "Каруж", "CH", "756", "GE", "2500", "6608", "", "46.18096", "6.13921", "Europe/Zurich"),
("2661513", "Biel/Bienne", "Биль", "CH", "756", "BE", "242", "371", "", "47.13713", "7.24608", "Europe/Zurich"),
("2661552", "Bern", "Берн", "CH", "756", "BE", "246", "351", "", "46.94809", "7.44744", "Europe/Zurich"),
("2661567", "Bellinzona", "Беллинцона", "CH", "756", "TI", "2101", "5002", "", "46.19278", "9.01703", "Europe/Zurich"),
("2661604", "Basel", "Базель", "CH", "756", "BS", "1200", "2701", "", "47.5584", "7.57327", "Europe/Zurich"),
("2661646", "Baden", "Баден", "CH", "756", "AG", "1902", "4021", "", "47.47333", "8.30592", "Europe/Zurich"),
("2661653", "Baar", "Бар", "CH", "756", "ZG", "900", "1701", "", "47.19625", "8.52954", "Europe/Zurich"),
("2661666", "Aussersihl", "", "CH", "756", "ZH", "112", "261", "", "47.37752", "8.52127", "Europe/Zurich"),
("2661810", "Allschwil", "Альшвиль", "CH", "756", "BL", "1301", "2762", "", "47.55074", "7.53599", "Europe/Zurich"),
("2661861", "Adliswil", "", "CH", "756", "ZH", "106", "131", "", "47.30997", "8.52462", "Europe/Zurich"),
("2661881", "Aarau", "Арау", "CH", "756", "AG", "1901", "4001", "", "47.39254", "8.04422", "Europe/Zurich"),
("3206590", "Riehen", "Риен", "CH", "756", "BS", "1200", "2703", "", "47.57884", "7.64683", "Europe/Zurich"),
("6295475", "Zuerich (Kreis 10) / Wipkingen", "", "CH", "756", "ZH", "112", "261", "", "47.39503", "8.52529", "Europe/Zurich"),
("6295484", "Zuerich (Kreis 11) / Affoltern", "", "CH", "756", "ZH", "112", "261", "", "47.41814", "8.5122", "Europe/Zurich"),
("6295495", "Zuerich (Kreis 2) / Wollishofen", "", "CH", "756", "ZH", "112", "261", "", "47.3401", "8.53134", "Europe/Zurich"),
("6295498", "Zuerich (Kreis 3) / Sihlfeld", "", "CH", "756", "ZH", "112", "261", "", "47.37382", "8.51164", "Europe/Zurich"),
("6295504", "Zuerich (Kreis 6) / Unterstrass", "", "CH", "756", "ZH", "112", "261", "", "47.3953", "8.53721", "Europe/Zurich"),
("6295512", "Zuerich (Kreis 9) / Albisrieden", "", "CH", "756", "ZH", "112", "261", "", "47.37398", "8.49007", "Europe/Zurich"),
("6295513", "Zuerich (Kreis 9) / Altstetten", "", "CH", "756", "ZH", "112", "261", "", "47.38946", "8.48533", "Europe/Zurich"),
("6295520", "Stadt Winterthur (Kreis 1)", "", "CH", "756", "ZH", "110", "230", "", "47.49494", "8.71954", "Europe/Zurich"),
("6295523", "Zuerich (Kreis 12)", "", "CH", "756", "ZH", "112", "261", "", "47.40372", "8.57608", "Europe/Zurich"),
("6295531", "Seen (Kreis 3)", "", "CH", "756", "ZH", "110", "230", "", "47.47646", "8.76996", "Europe/Zurich"),
("6295532", "Zuerich (Kreis 3)", "", "CH", "756", "ZH", "112", "261", "", "47.35785", "8.50296", "Europe/Zurich"),
("6295533", "Zuerich (Kreis 11)", "", "CH", "756", "ZH", "112", "261", "", "47.42326", "8.52166", "Europe/Zurich"),
("6295534", "Zuerich (Kreis 9)", "", "CH", "756", "ZH", "112", "261", "", "47.38245", "8.47993", "Europe/Zurich"),
("6295536", "Oberwinterthur (Kreis 2)", "", "CH", "756", "ZH", "110", "230", "", "47.51692", "8.76863", "Europe/Zurich"),
("6295539", "Zuerich (Kreis 10)", "", "CH", "756", "ZH", "112", "261", "", "47.40773", "8.5005", "Europe/Zurich"),
("6295540", "Zuerich (Kreis 2)", "", "CH", "756", "ZH", "112", "261", "", "47.33756", "8.5211", "Europe/Zurich"),
("6295542", "Zuerich (Kreis 8)", "", "CH", "756", "ZH", "112", "261", "", "47.3548", "8.56097", "Europe/Zurich"),
("6295548", "Zuerich (Kreis 7)", "", "CH", "756", "ZH", "112", "261", "", "47.37328", "8.58038", "Europe/Zurich"),
("6295550", "Zuerich (Kreis 6)", "", "CH", "756", "ZH", "112", "261", "", "47.39223", "8.54381", "Europe/Zurich"),
("6691640", "Lancy", "Ланси", "CH", "756", "GE", "2500", "6628", "", "46.18981", "6.11441", "Europe/Zurich"),
("2279172", "Zuenoula", "", "CI", "385", "83", "", "", "", "7.43027", "-6.05054", "Africa/Abidjan"),
("2279755", "Yamoussoukro", "Ямусукро", "CI", "385", "81", "", "", "", "6.82055", "-5.27674", "Africa/Abidjan"),
("2280045", "Vavoua", "Вавуа", "CI", "385", "80", "", "", "", "7.38194", "-6.47778", "Africa/Abidjan"),
("2280316", "Toumodi", "", "CI", "385", "81", "", "", "", "6.55799", "-5.01769", "Africa/Abidjan"),
("2280376", "Touba", "", "CI", "385", "75", "", "", "", "8.28333", "-7.68333", "Africa/Abidjan"),
("2280589", "Tengrela", "", "CI", "385", "87", "", "", "", "10.48115", "-6.40694", "Africa/Abidjan"),
("2280761", "Tiassale", "", "CI", "385", "82", "", "", "", "5.89839", "-4.82293", "Africa/Abidjan"),
("2280995", "Tanda", "", "CI", "385", "92", "", "", "", "7.80336", "-3.16832", "Africa/Abidjan"),
("2281120", "Tabou", "", "CI", "385", "76", "", "", "", "4.42295", "-7.3528", "Africa/Abidjan"),
("2281606", "Sinfra", "", "CI", "385", "92", "", "", "", "6.62103", "-5.91144", "Africa/Abidjan"),
("2281951", "Sassandra", "Сассандра", "CI", "385", "76", "", "", "", "4.95384", "-6.08531", "Africa/Abidjan"),
("2282006", "San-Pedro", "", "CI", "385", "76", "", "", "", "4.74851", "-6.6363", "Africa/Abidjan"),
("2282178", "Sakassou", "", "CI", "385", "90", "", "", "", "7.45462", "-5.29263", "Africa/Abidjan"),
("2282827", "Oume", "", "CI", "385", "79", "", "", "", "6.38309", "-5.41759", "Africa/Abidjan"),
("2283016", "Odienne", "Одиенне", "CI", "385", "77", "", "", "", "9.50511", "-7.56433", "Africa/Abidjan"),
("2284589", "Mankono", "", "CI", "385", "91", "", "", "", "8.05861", "-6.18972", "Africa/Abidjan"),
("2284647", "Man", "", "CI", "385", "78", "", "", "", "7.41251", "-7.55383", "Africa/Abidjan"),
("2285449", "Lakota", "Лакота", "CI", "385", "88", "", "", "", "5.84752", "-5.682", "Africa/Abidjan"),
("2286304", "Korhogo", "Корого", "CI", "385", "87", "", "", "", "9.45803", "-5.62961", "Africa/Abidjan"),
("2287298", "Katiola", "", "CI", "385", "90", "", "", "", "8.13728", "-5.10095", "Africa/Abidjan"),
("2287790", "Issia", "", "CI", "385", "80", "", "", "", "6.49224", "-6.58558", "Africa/Abidjan"),
("2287958", "Guiglo", "", "CI", "385", "78", "", "", "", "6.54368", "-7.4935", "Africa/Abidjan"),
("2288115", "Grand-Bassam", "Гран-Бассам", "CI", "385", "89", "", "", "", "5.2118", "-3.73884", "Africa/Abidjan"),
("2288118", "Affery", "", "CI", "385", "82", "", "", "", "6.32035", "-3.95235", "Africa/Abidjan"),
("2288829", "Gagnoa", "", "CI", "385", "79", "", "", "", "6.13193", "-5.9506", "Africa/Abidjan"),
("2289049", "Ferkessedougou", "Феркеседугу", "CI", "385", "87", "", "", "", "9.5928", "-5.19449", "Africa/Abidjan"),
("2289549", "Duekoue", "", "CI", "385", "78", "", "", "", "6.74202", "-7.34918", "Africa/Abidjan"),
("2289887", "Divo", "", "CI", "385", "88", "", "", "", "5.83739", "-5.35723", "Africa/Abidjan"),
("2289983", "Dimbokro", "", "CI", "385", "81", "", "", "", "6.64678", "-4.70519", "Africa/Abidjan"),
("2290412", "Daoukro", "Даукро", "CI", "385", "86", "", "", "", "7.0591", "-3.9631", "Africa/Abidjan"),
("2290462", "Danane", "Данане", "CI", "385", "78", "", "", "", "7.25957", "-8.15498", "Africa/Abidjan"),
("2290486", "Daloa", "Далоа", "CI", "385", "80", "", "", "", "6.87736", "-6.45022", "Africa/Abidjan"),
("2290582", "Dabou", "Даб", "CI", "385", "82", "", "", "", "5.32556", "-4.37685", "Africa/Abidjan"),
("2290836", "Boundiali", "Бундиали", "CI", "385", "87", "", "", "", "9.52167", "-6.48694", "Africa/Abidjan"),
("2290849", "Bouna", "Буна", "CI", "385", "92", "", "", "", "9.26926", "-2.9951", "Africa/Abidjan"),
("2290956", "Bouake", "Буаке", "CI", "385", "90", "", "", "", "7.69385", "-5.03031", "Africa/Abidjan"),
("2290964", "Bouafle", "", "CI", "385", "83", "", "", "", "6.99041", "-5.7442", "Africa/Abidjan"),
("2291087", "Bonoua", "", "CI", "385", "89", "", "", "", "5.27247", "-3.59625", "Africa/Abidjan"),
("2291113", "Bongouanou", "", "CI", "385", "81", "", "", "", "6.65175", "-4.20406", "Africa/Abidjan"),
("2291136", "Bondoukou", "Бондуку", "CI", "385", "92", "", "", "", "8.0402", "-2.80003", "Africa/Abidjan"),
("2291580", "Bingerville", "", "CI", "385", "82", "", "", "", "5.35581", "-3.88537", "Africa/Abidjan"),
("2291666", "Biankouma", "", "CI", "385", "78", "", "", "", "7.73909", "-7.61377", "Africa/Abidjan"),
("2291779", "Beoumi", "", "CI", "385", "90", "", "", "", "7.67395", "-5.58086", "Africa/Abidjan"),
("2292179", "Bangolo", "", "CI", "385", "78", "", "", "", "7.01232", "-7.4864", "Africa/Abidjan"),
("2292755", "Arrah", "", "CI", "385", "81", "", "", "", "6.67342", "-3.96938", "Africa/Abidjan"),
("2292852", "Anyama", "Аньяме", "CI", "385", "82", "", "", "", "5.49462", "-4.05183", "Africa/Abidjan"),
("2293107", "Akoupe", "", "CI", "385", "82", "", "", "", "6.38423", "-3.88759", "Africa/Abidjan"),
("2293260", "Agnibilekrou", "", "CI", "385", "85", "", "", "", "7.13113", "-3.20415", "Africa/Abidjan"),
("2293268", "Agboville", "Агбовиле", "CI", "385", "74", "", "", "", "5.92801", "-4.21319", "Africa/Abidjan"),
("2293342", "Adzope", "Адзопе", "CI", "385", "82", "", "", "", "6.10694", "-3.86194", "Africa/Abidjan"),
("2293428", "Adiake", "", "CI", "385", "89", "", "", "", "5.28634", "-3.30402", "Africa/Abidjan"),
("2293507", "Aboisso", "Абуассо", "CI", "385", "89", "", "", "", "5.46779", "-3.20711", "Africa/Abidjan"),
("2293521", "Abobo", "", "CI", "385", "82", "", "", "", "5.41613", "-4.0159", "Africa/Abidjan"),
("2293538", "Abidjan", "Абиджан", "CI", "385", "82", "", "", "", "5.30966", "-4.01266", "Africa/Abidjan"),
("2293549", "Abengourou", "Абенгуру", "CI", "385", "85", "", "", "", "6.72972", "-3.49639", "Africa/Abidjan"),
("2596934", "Seguela", "Сегеле", "CI", "385", "91", "", "", "", "7.96111", "-6.67306", "Africa/Abidjan"),
("2598243", "Soubre", "", "CI", "385", "76", "", "", "", "5.78556", "-6.60833", "Africa/Abidjan"),
("2220957", "Yaounde", "Яунде", "CM", "120", "11", "", "", "", "3.86667", "11.51667", "Africa/Douala"),
("2221030", "Yagoua", "", "CM", "120", "12", "", "", "", "10.34107", "15.23288", "Africa/Douala"),
("2221053", "Wum", "", "CM", "120", "07", "", "", "", "6.38333", "10.06667", "Africa/Douala"),
("2221394", "Tonga", "", "CM", "120", "08", "", "", "", "4.96667", "10.7", "Africa/Douala"),
("2221504", "Tiko", "", "CM", "120", "09", "", "", "", "4.0745", "9.3699", "Africa/Douala"),
("2221530", "Tibati", "", "CM", "120", "10", "", "", "", "6.46504", "12.62843", "Africa/Douala"),
("2221607", "Tchollire", "", "CM", "120", "13", "", "", "", "8.4022", "14.1698", "Africa/Douala"),
("2222230", "Sangmelima", "Сангмелима", "CM", "120", "14", "", "", "", "2.93333", "11.98333", "Africa/Douala"),
("2222623", "Penja", "", "CM", "120", "05", "", "", "", "4.63911", "9.67987", "Africa/Douala"),
("2223293", "Obala", "", "CM", "120", "11", "", "", "", "4.16667", "11.53333", "Africa/Douala"),
("2223734", "Nkoteng", "", "CM", "120", "11", "", "", "", "4.51667", "12.03333", "Africa/Douala"),
("2223763", "Nkongsamba", "Нконгсамба", "CM", "120", "05", "", "", "", "4.9547", "9.9404", "Africa/Douala"),
("2224827", "Ngaoundere", "", "CM", "120", "10", "", "", "", "7.32765", "13.58472", "Africa/Douala"),
("2225457", "Nanga Eboko", "", "CM", "120", "11", "", "", "", "4.68333", "12.36667", "Africa/Douala"),
("2225726", "Muyuka", "", "CM", "120", "09", "", "", "", "4.2898", "9.4103", "Africa/Douala"),
("2225728", "Mutengene", "", "CM", "120", "09", "", "", "", "4.0913", "9.3144", "Africa/Douala"),
("2225991", "Mora", "Море", "CM", "120", "12", "", "", "", "11.04611", "14.14011", "Africa/Douala"),
("2226275", "Mokolo", "", "CM", "120", "12", "", "", "", "10.74244", "13.80227", "Africa/Douala"),
("2227230", "Melong", "", "CM", "120", "05", "", "", "", "5.1218", "9.96143", "Africa/Douala"),
("2227402", "Meiganga", "Мейганге", "CM", "120", "10", "", "", "", "6.51667", "14.3", "Africa/Douala"),
("2227613", "Mbouda", "", "CM", "120", "08", "", "", "", "5.62611", "10.2542", "Africa/Douala"),
("2228005", "Mbanga", "", "CM", "120", "05", "", "", "", "4.5016", "9.5671", "Africa/Douala"),
("2228028", "Mbandjok", "", "CM", "120", "11", "", "", "", "4.45", "11.9", "Africa/Douala"),
("2228079", "Mbalmayo", "Мбальмайо", "CM", "120", "11", "", "", "", "3.51667", "11.5", "Africa/Douala"),
("2228373", "Maroua", "Маруа", "CM", "120", "12", "", "", "", "10.59095", "14.31592", "Africa/Douala"),
("2228499", "Manjo", "", "CM", "120", "05", "", "", "", "4.8428", "9.8217", "Africa/Douala"),
("2228675", "Mamfe", "", "CM", "120", "09", "", "", "", "5.754", "9.3123", "Africa/Douala"),
("2229152", "Loum", "Лум", "CM", "120", "05", "", "", "", "4.7182", "9.7351", "Africa/Douala"),
("2229267", "Lolodorf", "", "CM", "120", "14", "", "", "", "3.23333", "10.73333", "Africa/Douala"),
("2229411", "Limbe", "Лимбе", "CM", "120", "09", "", "", "", "4.0242", "9.2149", "Africa/Douala"),
("2229681", "Lagdo", "", "CM", "120", "13", "", "", "", "9.0263", "13.6919", "Africa/Douala"),
("2229748", "Kumbo", "", "CM", "120", "07", "", "", "", "6.2", "10.66667", "Africa/Douala"),
("2229752", "Kumba", "Кумбой", "CM", "120", "09", "", "", "", "4.6363", "9.4469", "Africa/Douala"),
("2229761", "Kribi", "Криби", "CM", "120", "14", "", "", "", "2.95", "9.91667", "Africa/Douala"),
("2229798", "Kousseri", "", "CM", "120", "12", "", "", "", "12.07689", "15.03063", "Africa/Douala"),
("2230599", "Kaele", "", "CM", "120", "12", "", "", "", "10.10917", "14.45083", "Africa/Douala"),
("2230876", "Guider", "", "CM", "120", "13", "", "", "", "9.9333", "13.94672", "Africa/Douala"),
("2231319", "Garoua Boulai", "", "CM", "120", "04", "", "", "", "5.88333", "14.55", "Africa/Douala"),
("2231320", "Garoua", "Гаруа", "CM", "120", "13", "", "", "", "9.30142", "13.39771", "Africa/Douala"),
("2231482", "Fundong", "", "CM", "120", "07", "", "", "", "6.25", "10.26667", "Africa/Douala"),
("2231504", "Foumbot", "", "CM", "120", "08", "", "", "", "5.50803", "10.6325", "Africa/Douala"),
("2231506", "Foumban", "", "CM", "120", "08", "", "", "", "5.72662", "10.89865", "Africa/Douala"),
("2231564", "Fontem", "", "CM", "120", "09", "", "", "", "5.4685", "9.8818", "Africa/Douala"),
("2231881", "Eseka", "", "CM", "120", "11", "", "", "", "3.65", "10.76667", "Africa/Douala"),
("2232239", "Edea", "Эдеа", "CM", "120", "05", "", "", "", "3.8", "10.13333", "Africa/Douala"),
("2232283", "Ebolowa", "", "CM", "120", "14", "", "", "", "2.9", "11.15", "Africa/Douala"),
("2232444", "Dschang", "", "CM", "120", "08", "", "", "", "5.44397", "10.05332", "Africa/Douala"),
("2232593", "Douala", "Дуала", "CM", "120", "05", "", "", "", "4.04827", "9.70428", "Africa/Douala"),
("2232997", "Dizangue", "", "CM", "120", "05", "", "", "", "3.76667", "9.98333", "Africa/Douala"),
("2233410", "Buea", "", "CM", "120", "09", "", "", "", "4.1527", "9.241", "Africa/Douala"),
("2233805", "Bogo", "", "CM", "120", "12", "", "", "", "10.7336", "14.60928", "Africa/Douala"),
("2234359", "Bertoua", "Бертуа", "CM", "120", "04", "", "", "", "4.57728", "13.68459", "Africa/Douala"),
("2234536", "Belabo", "Белабо", "CM", "120", "04", "", "", "", "4.93333", "13.3", "Africa/Douala"),
("2234663", "Batouri", "", "CM", "120", "04", "", "", "", "4.43333", "14.36667", "Africa/Douala"),
("2234794", "Banyo", "", "CM", "120", "10", "", "", "", "6.75", "11.81667", "Africa/Douala"),
("2234865", "Bangangte", "", "CM", "120", "08", "", "", "", "5.14079", "10.52535", "Africa/Douala"),
("2234941", "Bamusso", "", "CM", "120", "09", "", "", "", "4.4591", "8.9027", "Africa/Douala"),
("2234974", "Bamenda", "Баменды", "CM", "120", "07", "", "", "", "5.9597", "10.14597", "Africa/Douala"),
("2235029", "Bali", "Бали", "CM", "120", "07", "", "", "", "5.88737", "10.01176", "Africa/Douala"),
("2235189", "Bafoussam", "Бафуссама", "CM", "120", "08", "", "", "", "5.47775", "10.41759", "Africa/Douala"),
("2235194", "Bafia", "", "CM", "120", "11", "", "", "", "4.75", "11.23333", "Africa/Douala"),
("2235196", "Bafang", "", "CM", "120", "08", "", "", "", "5.15705", "10.1771", "Africa/Douala"),
("2235776", "Akonolinga", "", "CM", "120", "11", "", "", "", "3.76667", "12.25", "Africa/Douala"),
("2594800", "Idenao", "", "CM", "120", "09", "", "", "", "4.2475", "9.00472", "Africa/Douala"),
("1279715", "Rikaze", "Шигадзе", "CN", "156", "14", "", "", "", "29.25", "88.88333", "Asia/Urumqi"),
("1279945", "Jiuquan", "Сучжоу", "CN", "156", "15", "", "", "", "39.74318", "98.51736", "Asia/Chongqing"),
("1280037", "Shache", "", "CN", "156", "13", "", "", "", "38.41667", "77.24056", "Asia/Kashgar"),
("1280281", "Qamdo", "", "CN", "156", "14", "", "", "", "31.1304", "97.17982", "Asia/Urumqi"),
("1280517", "Nagqu", "Нагчу", "CN", "156", "14", "", "", "", "31.47678", "92.05729", "Asia/Urumqi"),
("1280737", "Lhasa", "Лхаса", "CN", "156", "14", "", "", "", "29.65", "91.1", "Asia/Urumqi"),
("1280757", "Laojunmiao", "", "CN", "156", "15", "", "", "", "39.83333", "97.73333", "Asia/Chongqing"),
("1280849", "Kashi", "Кашгар", "CN", "156", "13", "", "", "", "39.47066", "75.98951", "Asia/Kashgar"),
("1280957", "Jiayuguan", "Цзяюйгуань", "CN", "156", "15", "", "", "", "39.81121", "98.28618", "Asia/Chongqing"),
("1281019", "Hotan", "Хотан", "CN", "156", "13", "", "", "", "37.1075", "79.93548", "Asia/Kashgar"),
("1281368", "Deqen", "Дечен", "CN", "156", "14", "", "", "", "29.96178", "90.71875", "Asia/Urumqi"),
("1529102", "UEruemqi", "Урумчи", "CN", "156", "13", "", "", "", "43.80096", "87.60046", "Asia/Urumqi"),
("1529114", "Laochenglu", "Турфан", "CN", "156", "13", "", "", "", "42.9251", "89.16831", "Asia/Urumqi"),
("1529195", "Shihezi", "Шихэцзы", "CN", "156", "13", "", "", "", "44.3023", "86.03694", "Asia/Urumqi"),
("1529363", "Kuche", "Куча", "CN", "156", "13", "", "", "", "41.72778", "82.93639", "Asia/Urumqi"),
("1529376", "Sayibage", "Корла", "CN", "156", "13", "", "", "", "41.76055", "86.15231", "Asia/Urumqi"),
("1529452", "Hoxtolgay", "", "CN", "156", "13", "", "", "", "46.51872", "86.00214", "Asia/Urumqi"),
("1529484", "Hami", "Хами", "CN", "156", "13", "", "", "", "42.83393", "93.50601", "Asia/Urumqi"),
("1529569", "Yan'an Beilu", "Чанцзи", "CN", "156", "13", "", "", "", "44.00782", "87.30461", "Asia/Urumqi"),
("1529626", "Baijiantan", "", "CN", "156", "13", "", "", "", "45.68928", "85.12441", "Asia/Urumqi"),
("1529641", "Aral", "Аральское", "CN", "156", "13", "", "", "", "40.51556", "81.26361", "Asia/Kashgar"),
("1529651", "Altay", "Алтайская", "CN", "156", "13", "", "", "", "47.84864", "88.13361", "Asia/Urumqi"),
("1529660", "Yingbazha", "Аксу", "CN", "156", "13", "", "", "", "41.11312", "80.26918", "Asia/Kashgar"),
("1783621", "Zunyi", "Цзуньи", "CN", "156", "18", "", "", "", "27.68667", "106.90722", "Asia/Chongqing"),
("1783633", "Zoucheng", "", "CN", "156", "25", "", "", "", "35.40056", "116.96556", "Asia/Shanghai"),
("1783683", "Yanjiang", "Цзыян", "CN", "156", "32", "", "", "", "30.12108", "104.64811", "Asia/Chongqing"),
("1783745", "Zigong", "Цзыгун", "CN", "156", "32", "", "", "", "29.34162", "104.77689", "Asia/Chongqing"),
("1783763", "Zhuzhou", "Чжучжоу", "CN", "156", "11", "1783761", "", "", "27.83333", "113.15", "Asia/Shanghai"),
("1783873", "Zhumadian", "Чжумадянь", "CN", "156", "09", "", "", "", "32.97944", "114.02944", "Asia/Shanghai"),
("1783934", "Shangqiu", "Шанцю", "CN", "156", "09", "", "", "", "34.45", "115.65", "Asia/Shanghai"),
("1783940", "Zhuji", "", "CN", "156", "02", "", "", "", "29.71876", "120.24233", "Asia/Shanghai"),
("1783988", "Mizhou", "", "CN", "156", "25", "", "", "", "35.99472", "119.3975", "Asia/Shanghai"),
("1784055", "Zhuanghe", "", "CN", "156", "19", "", "", "", "39.70083", "122.99111", "Asia/Shanghai"),
("1784074", "Zhouzhuang", "Чжоучжуан", "CN", "156", "04", "", "", "", "31.11788", "120.84427", "Asia/Shanghai"),
("1784130", "Zhoukou", "Чжоуко", "CN", "156", "09", "", "", "", "33.63333", "114.63333", "Asia/Shanghai"),
("1784178", "Zhoucun", "", "CN", "156", "25", "", "", "", "36.81667", "117.81667", "Asia/Shanghai"),
("1784185", "Yuxi", "Юйси", "CN", "156", "29", "", "", "", "24.355", "102.54222", "Asia/Chongqing"),
("1784253", "Zhongxing", "", "CN", "156", "04", "", "", "", "33.70389", "118.67917", "Asia/Shanghai"),
("1784310", "Zhongshu", "Чжуншу", "CN", "156", "29", "", "", "", "24.51667", "103.76667", "Asia/Chongqing"),
("1784553", "Zhicheng", "", "CN", "156", "02", "", "", "", "31.0054", "119.90488", "Asia/Shanghai"),
("1784554", "Zhicheng", "", "CN", "156", "12", "", "", "", "30.29556", "111.50472", "Asia/Shanghai"),
("1784580", "Zhenzhou", "", "CN", "156", "04", "", "", "", "32.28034", "119.16999", "Asia/Shanghai"),
("1784642", "Zhenjiang", "", "CN", "156", "04", "", "", "", "32.21086", "119.45508", "Asia/Shanghai"),
("1784647", "Zhaobaoshan", "", "CN", "156", "02", "", "", "", "29.9695", "121.68753", "Asia/Shanghai"),
("1784658", "Zhengzhou", "Чжэнчжоу", "CN", "156", "09", "", "", "", "34.75778", "113.64861", "Asia/Shanghai"),
("1784820", "Xinghua", "Синхуа", "CN", "156", "04", "", "", "", "32.93917", "119.83417", "Asia/Shanghai"),
("1784841", "Zhaotong", "Чжаотун", "CN", "156", "29", "", "", "", "27.31667", "103.71667", "Asia/Chongqing"),
("1784853", "Zhaoqing", "Чжаоцин", "CN", "156", "30", "", "", "", "23.05116", "112.45972", "Asia/Shanghai"),
("1784929", "Zhaogezhuang", "", "CN", "156", "10", "", "", "", "39.76667", "118.4", "Asia/Shanghai"),
("1784953", "Luofeng", "", "CN", "156", "25", "", "", "", "37.36497", "120.40997", "Asia/Shanghai"),
("1784990", "Zhanjiang", "Чжаньцзян", "CN", "156", "30", "", "", "", "21.28145", "110.34271", "Asia/Urumqi"),
("1785018", "Zhangzhou", "Чжанчжоу", "CN", "156", "07", "", "", "", "24.51333", "117.65556", "Asia/Shanghai"),
("1785036", "Zhangye", "", "CN", "156", "15", "", "", "", "38.93417", "100.45167", "Asia/Chongqing"),
("1785286", "Zibo", "Цзыбо", "CN", "156", "25", "", "", "", "36.79056", "118.06333", "Asia/Shanghai"),
("1785294", "Anyang", "Аньянг", "CN", "156", "09", "", "", "", "36.09944", "114.32889", "Asia/Shanghai"),
("1785453", "Zaozhuang", "Цзаочжуан", "CN", "156", "25", "", "", "", "34.86472", "117.55417", "Asia/Shanghai"),
("1785462", "Zaoyang", "", "CN", "156", "12", "", "", "", "32.12722", "112.75417", "Asia/Shanghai"),
("1785545", "Yuyao", "Юяо", "CN", "156", "02", "1799395", "1785543", "", "30.05", "121.14944", "Asia/Shanghai"),
("1785566", "Yuzhou", "", "CN", "156", "09", "", "", "", "34.16278", "113.46389", "Asia/Shanghai"),
("1785572", "Yuxia", "", "CN", "156", "26", "", "", "", "34.06154", "108.62905", "Asia/Chongqing"),
("1785623", "Kunshan", "Куньшань", "CN", "156", "04", "", "", "", "31.37762", "120.9543", "Asia/Shanghai"),
("1785655", "Yunyang", "", "CN", "156", "09", "", "", "", "33.44743", "112.71422", "Asia/Shanghai"),
("1785698", "Yunmeng Chengguanzhen", "", "CN", "156", "12", "", "", "", "31.06251", "113.76545", "Asia/Shanghai"),
("1785710", "Jinghong", "", "CN", "156", "29", "", "", "", "21.99102", "100.73409", "Asia/Chongqing"),
("1785716", "Pizhou", "", "CN", "156", "04", "", "", "", "34.31139", "117.95028", "Asia/Shanghai"),
("1785725", "Yunfu", "Юньфу", "CN", "156", "30", "", "", "", "22.92832", "112.03954", "Asia/Chongqing"),
("1785738", "Yuncheng", "Юньчэн", "CN", "156", "24", "", "", "", "35.02306", "110.99278", "Asia/Shanghai"),
("1785777", "Yulin", "Юйлинь", "CN", "156", "26", "", "", "", "38.29056", "109.74944", "Asia/Chongqing"),
("1785781", "Yulin", "", "CN", "156", "16", "", "", "", "22.63333", "110.15", "Asia/Chongqing"),
("1785964", "Yudong", "Юйдун", "CN", "156", "33", "", "", "", "29.385", "106.51944", "Asia/Chongqing"),
("1785974", "Yuci", "", "CN", "156", "24", "", "", "", "37.68028", "112.73194", "Asia/Shanghai"),
("1785980", "Yucheng", "Юйчэн", "CN", "156", "25", "", "", "", "34.92889", "116.46528", "Asia/Shanghai"),
("1786060", "Yuanping", "", "CN", "156", "24", "", "", "", "38.71528", "112.7575", "Asia/Shanghai"),
("1786067", "Qianjiang", "Юаньлинь", "CN", "156", "12", "", "", "", "30.421", "112.8919", "Asia/Shanghai"),
("1786112", "Heyuan", "Хэюань", "CN", "156", "30", "", "", "", "23.73333", "114.68333", "Asia/Shanghai"),
("1786357", "Yongfeng", "", "CN", "156", "11", "", "", "", "27.42829", "112.18338", "Asia/Shanghai"),
("1786378", "Yongchuan", "", "CN", "156", "33", "", "", "", "29.35376", "105.89392", "Asia/Chongqing"),
("1786455", "Yishui", "", "CN", "156", "25", "", "", "", "35.78472", "118.62806", "Asia/Shanghai"),
("1786546", "Zhongxiang", "", "CN", "156", "12", "", "", "", "31.16611", "112.58306", "Asia/Shanghai"),
("1786587", "Yingshang Chengguanzhen", "", "CN", "156", "01", "", "", "", "32.62945", "116.27014", "Asia/Shanghai"),
("1786640", "Chengzhong", "", "CN", "156", "12", "", "", "", "30.94454", "113.55284", "Asia/Shanghai"),
("1786657", "Yinchuan", "Иньчуань", "CN", "156", "21", "", "", "", "38.46806", "106.27306", "Asia/Chongqing"),
("1786676", "Yima", "Йимы", "CN", "156", "09", "", "", "", "34.73806", "111.88389", "Asia/Shanghai"),
("1786720", "Yigou", "", "CN", "156", "09", "", "", "", "35.81139", "114.31667", "Asia/Shanghai"),
("1786731", "Qingzhou", "Цинчжоу", "CN", "156", "25", "", "", "", "36.69667", "118.47972", "Asia/Shanghai"),
("1786746", "Yichun", "Ичунь", "CN", "156", "03", "", "", "", "27.83333", "114.4", "Asia/Shanghai"),
("1786759", "Yicheng", "", "CN", "156", "12", "", "", "", "31.70472", "112.25611", "Asia/Shanghai"),
("1786760", "Yicheng", "", "CN", "156", "04", "", "", "", "31.36059", "119.82016", "Asia/Shanghai"),
("1786764", "Yichang", "Ичан", "CN", "156", "12", "", "", "", "30.71444", "111.28472", "Asia/Shanghai"),
("1786770", "Yibin", "Ибинь", "CN", "156", "32", "", "", "", "28.76667", "104.62383", "Asia/Chongqing"),
("1786855", "Yatou", "Жунчэн", "CN", "156", "25", "", "", "", "37.1566", "122.43762", "Asia/Shanghai"),
("1786867", "Yashan", "", "CN", "156", "16", "", "", "", "22.1975", "109.94194", "Asia/Chongqing"),
("1787031", "Yanzhou", "", "CN", "156", "25", "", "", "", "35.55278", "116.82861", "Asia/Shanghai"),
("1787093", "Yantai", "Яньтай", "CN", "156", "25", "", "", "", "37.47649", "121.44081", "Asia/Shanghai"),
("1787144", "Yanliang", "", "CN", "156", "26", "", "", "", "34.65918", "109.22921", "Asia/Chongqing"),
("1787227", "Yangzhou", "Янчжоу", "CN", "156", "04", "", "", "", "32.39722", "119.43583", "Asia/Shanghai"),
("1787323", "Yangshuo", "Яншо", "CN", "156", "16", "", "", "", "24.78081", "110.48967", "Asia/Chongqing"),
("1787331", "Zhangjiagang", "", "CN", "156", "04", "", "", "", "31.865", "120.53889", "Asia/Shanghai"),
("1787351", "Yangquan", "", "CN", "156", "24", "", "", "", "37.8575", "113.56333", "Asia/Shanghai"),
("1787437", "Yangliuqing", "", "CN", "156", "28", "", "", "", "39.1375", "116.99972", "Asia/Shanghai"),
("1787601", "Yanggu", "Янг", "CN", "156", "25", "", "", "", "36.11056", "115.77528", "Asia/Shanghai"),
("1787646", "Yangcun", "", "CN", "156", "28", "", "", "", "39.36389", "117.06028", "Asia/Shanghai"),
("1787746", "Yancheng", "Яньчэн", "CN", "156", "04", "", "", "", "33.3575", "120.1573", "Asia/Shanghai"),
("1787824", "Tongshan", "Сюйчжоу", "CN", "156", "04", "", "", "", "34.18045", "117.15707", "Asia/Shanghai"),
("1787837", "Xucheng", "", "CN", "156", "30", "", "", "", "20.32917", "110.16712", "Asia/Urumqi"),
("1787858", "Shangrao", "Шанжао", "CN", "156", "03", "", "", "", "28.45322", "117.9686", "Asia/Shanghai"),
("1787901", "Xunchang", "", "CN", "156", "32", "", "", "", "28.45433", "104.71498", "Asia/Chongqing"),
("1788046", "Xuchang", "", "CN", "156", "09", "", "", "", "34.01667", "113.81667", "Asia/Shanghai"),
("1788081", "Xuanzhou", "", "CN", "156", "01", "", "", "", "30.9525", "118.75528", "Asia/Shanghai"),
("1788206", "Xixiang", "", "CN", "156", "09", "", "", "", "35.16278", "112.865", "Asia/Shanghai"),
("1788245", "Xiuying", "", "CN", "156", "31", "", "", "", "20.00073", "110.29359", "Asia/Chongqing"),
("1788268", "Xiulin", "", "CN", "156", "12", "", "", "", "29.71667", "112.4", "Asia/Shanghai"),
("1788402", "Xiongzhou", "", "CN", "156", "30", "", "", "", "25.11667", "114.3", "Asia/Shanghai"),
("1788406", "Guixi", "", "CN", "156", "03", "", "", "", "28.28857", "117.21329", "Asia/Shanghai"),
("1788450", "Xinzhou", "Синьчжоу", "CN", "156", "24", "", "", "", "38.40917", "112.73333", "Asia/Shanghai"),
("1788452", "Xinzhou", "", "CN", "156", "12", "", "", "", "30.86667", "114.8", "Asia/Shanghai"),
("1788462", "Xinzhi", "", "CN", "156", "24", "", "", "", "36.49889", "111.70472", "Asia/Shanghai"),
("1788508", "Xinyu", "", "CN", "156", "03", "", "", "", "27.80429", "114.93335", "Asia/Shanghai"),
("1788522", "Xinye", "", "CN", "156", "09", "", "", "", "32.51861", "112.35222", "Asia/Shanghai"),
("1788534", "Xinyang", "Цзинань", "CN", "156", "09", "", "", "", "32.12278", "114.06556", "Asia/Shanghai"),
("1788572", "Xinxiang", "Синьсян", "CN", "156", "09", "", "", "", "35.30889", "113.86722", "Asia/Shanghai"),
("1788618", "Xintai", "", "CN", "156", "25", "", "", "", "35.90056", "117.75194", "Asia/Shanghai"),
("1788638", "Xinshi", "", "CN", "156", "12", "", "", "", "31.04704", "113.14098", "Asia/Shanghai"),
("1788694", "Xinpu", "", "CN", "156", "04", "", "", "", "34.59972", "119.15944", "Asia/Shanghai"),
("1788816", "Xinji", "", "CN", "156", "10", "", "", "", "37.90278", "115.20361", "Asia/Shanghai"),
("1788852", "Xining", "Синин", "CN", "156", "06", "", "", "", "36.62554", "101.75739", "Asia/Chongqing"),
("1788869", "Shangmei", "", "CN", "156", "11", "", "", "", "27.74278", "111.29556", "Asia/Shanghai"),
("1788927", "Xingtai", "Синтай", "CN", "156", "10", "", "", "", "37.06306", "114.49417", "Asia/Shanghai"),
("1789065", "Ankang", "Анкан", "CN", "156", "26", "", "", "", "32.68", "109.01722", "Asia/Chongqing"),
("1789118", "Xindian", "", "CN", "156", "25", "", "", "", "36.7975", "118.29444", "Asia/Shanghai"),
("1789137", "Xindi", "", "CN", "156", "12", "", "", "", "29.81667", "113.46667", "Asia/Shanghai"),
("1789176", "Feicheng", "", "CN", "156", "25", "", "", "", "36.24861", "116.76583", "Asia/Shanghai"),
("1789273", "Sanshui", "", "CN", "156", "30", "", "", "", "23.15486", "112.89161", "Asia/Shanghai"),
("1789289", "Ximei", "", "CN", "156", "07", "", "", "", "24.98773", "118.3858", "Asia/Shanghai"),
("1789427", "Xihua", "", "CN", "156", "09", "", "", "", "33.78333", "114.51667", "Asia/Shanghai"),
("1789462", "Xihe", "", "CN", "156", "12", "", "", "", "31.68636", "113.46585", "Asia/Shanghai"),
("1789647", "Xichang", "Сичан", "CN", "156", "32", "", "", "", "27.89642", "102.26342", "Asia/Chongqing"),
("1789693", "Xiazhuang", "", "CN", "156", "25", "", "", "", "34.91611", "118.63889", "Asia/Shanghai"),
("1789703", "Xiazhen", "", "CN", "156", "25", "", "", "", "34.80222", "117.11167", "Asia/Shanghai"),
("1789799", "Xiashi", "", "CN", "156", "02", "", "", "", "30.53629", "120.68638", "Asia/Shanghai"),
("1789897", "Gongyi", "", "CN", "156", "09", "", "", "", "34.76", "112.97139", "Asia/Shanghai"),
("1789945", "Xiaoweizhai", "", "CN", "156", "18", "", "", "", "26.19028", "107.5125", "Asia/Chongqing"),
("1789998", "Xiaoshan", "Сяошань", "CN", "156", "02", "", "", "", "30.16746", "120.25883", "Asia/Shanghai"),
("1790100", "Xiaolingwei", "", "CN", "156", "04", "", "", "", "32.03244", "118.854", "Asia/Shanghai"),
("1790254", "Xiaogan", "", "CN", "156", "12", "", "", "", "30.92689", "113.92221", "Asia/Shanghai"),
("1790353", "Xianyang", "Саньян", "CN", "156", "26", "", "", "", "34.33778", "108.70261", "Asia/Chongqing"),
("1790371", "Xiantao", "", "CN", "156", "12", "", "", "", "30.3708", "113.44294", "Asia/Shanghai"),
("1790379", "Xianshuigu", "", "CN", "156", "28", "", "", "", "38.985", "117.38278", "Asia/Shanghai"),
("1790392", "Xiannu", "", "CN", "156", "04", "", "", "", "32.42806", "119.56048", "Asia/Shanghai"),
("1790396", "Xianning", "Сяньнин", "CN", "156", "12", "", "", "", "29.88333", "114.21667", "Asia/Shanghai"),
("1790413", "Xianju", "", "CN", "156", "02", "", "", "", "28.8547", "120.73168", "Asia/Shanghai"),
("1790437", "Zhuhai", "Чжухай", "CN", "156", "30", "", "", "", "22.27694", "113.56778", "Asia/Shanghai"),
("1790451", "Wenxing", "", "CN", "156", "11", "", "", "", "28.66667", "112.88333", "Asia/Shanghai"),
("1790471", "Xiangxiang", "", "CN", "156", "11", "", "", "", "27.73333", "112.53333", "Asia/Shanghai"),
("1790492", "Xiangtan", "Сянтань", "CN", "156", "11", "", "", "", "27.85", "112.9", "Asia/Shanghai"),
("1790587", "Xiangyang", "Сянфань", "CN", "156", "12", "", "", "", "32.0422", "112.14479", "Asia/Shanghai"),
("1790601", "Xiangcheng", "", "CN", "156", "09", "", "", "", "33.84703", "113.4778", "Asia/Shanghai"),
("1790630", "Xi'an", "Сиань", "CN", "156", "26", "", "", "", "34.25833", "108.92861", "Asia/Chongqing"),
("1790645", "Xiamen", "Сямэнь", "CN", "156", "07", "", "", "", "24.47979", "118.08187", "Asia/Shanghai"),
("1790840", "Wuzhou", "", "CN", "156", "16", "", "", "", "23.48333", "111.31667", "Asia/Chongqing"),
("1790885", "Wuyang", "", "CN", "156", "01", "", "", "", "31.9925", "116.24722", "Asia/Shanghai"),
("1790894", "Wuxue", "", "CN", "156", "12", "", "", "", "29.85058", "115.5525", "Asia/Shanghai"),
("1790923", "Wuxi", "Уси", "CN", "156", "04", "", "", "", "31.56887", "120.28857", "Asia/Shanghai"),
("1791056", "Dongyang", "", "CN", "156", "02", "", "", "", "29.26778", "120.22528", "Asia/Shanghai"),
("1791121", "Changde", "Чандэ", "CN", "156", "11", "", "", "", "29.04638", "111.6783", "Asia/Shanghai"),
("1791236", "Wuhu", "Уху", "CN", "156", "01", "", "", "", "31.33728", "118.37351", "Asia/Shanghai"),
("1791247", "Wuhan", "Ухань", "CN", "156", "12", "", "", "", "30.58333", "114.26667", "Asia/Shanghai"),
("1791249", "Wuhai", "", "CN", "156", "20", "", "", "", "39.68442", "106.81582", "Asia/Chongqing"),
("1791325", "Wuda", "", "CN", "156", "20", "", "", "", "39.49944", "106.71167", "Asia/Chongqing"),
("1791347", "Wucheng", "", "CN", "156", "01", "", "", "", "29.60077", "118.17495", "Asia/Shanghai"),
("1791388", "Wenzhou", "Вэньчжоу", "CN", "156", "02", "", "", "", "27.99942", "120.66682", "Asia/Shanghai"),
("1791428", "Wenshang", "", "CN", "156", "25", "", "", "", "35.7275", "116.49611", "Asia/Shanghai"),
("1791464", "Wenling", "", "CN", "156", "02", "", "", "", "28.37161", "121.36974", "Asia/Shanghai"),
("1791536", "Tianfu", "", "CN", "156", "25", "", "", "", "37.19723", "122.05228", "Asia/Shanghai"),
("1791636", "Weinan", "Вэйнань", "CN", "156", "26", "", "", "", "34.50355", "109.50891", "Asia/Chongqing"),
("1791673", "Weihai", "Вэйхай", "CN", "156", "25", "", "", "", "37.50914", "122.11356", "Asia/Shanghai"),
("1791681", "Weifang", "Вэйфан", "CN", "156", "25", "", "", "", "36.71", "119.10194", "Asia/Shanghai"),
("1791748", "Wanxian", "", "CN", "156", "33", "", "", "", "30.81544", "108.37089", "Asia/Chongqing"),
("1791779", "Wancheng", "", "CN", "156", "31", "", "", "", "18.80454", "110.39512", "Asia/Chongqing"),
("1792087", "Yinzhu", "", "CN", "156", "25", "", "", "", "35.87861", "119.97528", "Asia/Shanghai"),
("1792260", "Wafangdian", "", "CN", "156", "19", "", "", "", "39.61833", "122.00806", "Asia/Shanghai"),
("1792359", "Huangshan", "Туньси", "CN", "156", "01", "", "", "", "29.71139", "118.3125", "Asia/Shanghai"),
("1792516", "Loushanguan", "", "CN", "156", "18", "", "", "", "28.1368", "106.822", "Asia/Chongqing"),
("1792520", "Tongzhou", "Тунчжоу", "CN", "156", "22", "", "", "", "39.90395", "116.66183", "Asia/Shanghai"),
("1792585", "Fuding", "", "CN", "156", "07", "", "", "", "27.32734", "120.214", "Asia/Shanghai"),
("1792592", "Tongren", "", "CN", "156", "18", "", "", "", "27.71722", "109.18528", "Asia/Chongqing"),
("1792621", "Wusong", "", "CN", "156", "01", "", "", "", "30.95", "117.78333", "Asia/Shanghai"),
("1792692", "Tongchuan", "", "CN", "156", "32", "", "", "", "31.09407", "105.08731", "Asia/Chongqing"),
("1792892", "Tianshui", "", "CN", "156", "15", "", "", "", "34.57952", "105.74238", "Asia/Chongqing"),
("1792916", "Tianpeng", "", "CN", "156", "32", "", "", "", "30.98664", "103.93933", "Asia/Chongqing"),
("1792947", "Tianjin", "Тяньцзинь", "CN", "156", "28", "", "", "", "39.14222", "117.17667", "Asia/Shanghai"),
("1793036", "Tengzhou", "Тэнчжоу", "CN", "156", "25", "", "", "", "35.07706", "117.15176", "Asia/Shanghai"),
("1793089", "Taozhuang", "", "CN", "156", "25", "", "", "", "34.85", "117.33333", "Asia/Shanghai"),
("1793230", "Tantou", "", "CN", "156", "07", "", "", "", "26.03033", "119.59739", "Asia/Shanghai"),
("1793286", "Tangzhai", "", "CN", "156", "01", "", "", "", "34.43278", "116.59111", "Asia/Shanghai"),
("1793346", "Tangshan", "Таншань", "CN", "156", "10", "", "", "", "39.63333", "118.18333", "Asia/Shanghai"),
("1793364", "Tangping", "", "CN", "156", "30", "", "", "", "22.03177", "111.93537", "Asia/Chongqing"),
("1793385", "Tangjiazhuang", "", "CN", "156", "10", "", "", "", "39.73333", "118.45", "Asia/Shanghai"),
("1793419", "Tanghe", "", "CN", "156", "09", "", "", "", "32.68833", "112.8275", "Asia/Shanghai"),
("1793424", "Tanggu", "Танго", "CN", "156", "28", "", "", "", "39.02111", "117.64694", "Asia/Shanghai"),
("1793505", "Taizhou", "Тайчжоу", "CN", "156", "04", "", "", "", "32.49069", "119.90812", "Asia/Shanghai"),
("1793511", "Taiyuan", "Тайюань", "CN", "156", "24", "", "", "", "37.86944", "112.56028", "Asia/Shanghai"),
("1793533", "Taixing", "", "CN", "156", "04", "", "", "", "32.16667", "120.01361", "Asia/Shanghai"),
("1793700", "Taishan", "Тайшань", "CN", "156", "30", "", "", "", "22.25135", "112.7799", "Asia/Chongqing"),
("1793724", "Tai'an", "Тайань", "CN", "156", "25", "", "", "", "36.18528", "117.12", "Asia/Shanghai"),
("1793743", "Suzhou", "Сучжоу", "CN", "156", "01", "", "", "", "33.63611", "116.97889", "Asia/Shanghai"),
("1793774", "Suozhen", "", "CN", "156", "25", "", "", "", "36.95389", "118.10472", "Asia/Shanghai"),
("1793879", "Suizhou", "", "CN", "156", "12", "", "", "", "31.71111", "113.36306", "Asia/Shanghai"),
("1793889", "Suixi", "", "CN", "156", "01", "", "", "", "33.89067", "116.77472", "Asia/Shanghai"),
("1793899", "Suicheng", "", "CN", "156", "04", "", "", "", "33.8963", "117.93307", "Asia/Shanghai"),
("1793900", "Suining", "Суйнин", "CN", "156", "32", "", "", "", "30.50802", "105.57332", "Asia/Chongqing"),
("1794035", "Songjiang", "", "CN", "156", "23", "", "", "", "31.03595", "121.2146", "Asia/Shanghai"),
("1794140", "Sishui", "", "CN", "156", "25", "", "", "", "35.64889", "117.27583", "Asia/Shanghai"),
("1794479", "Laixi", "", "CN", "156", "25", "", "", "", "36.85917", "120.52694", "Asia/Shanghai"),
("1794794", "Shouguang", "Шоугуан", "CN", "156", "25", "", "", "", "36.88", "118.7375", "Asia/Shanghai"),
("1794806", "Shizuishan", "", "CN", "156", "21", "", "", "", "39.23333", "106.76944", "Asia/Chongqing"),
("1794825", "Shizilu", "", "CN", "156", "25", "", "", "", "35.17111", "118.82889", "Asia/Shanghai"),
("1794903", "Shiyan", "Шиянь", "CN", "156", "12", "", "", "", "32.6475", "110.77806", "Asia/Shanghai"),
("1794904", "Shiyan", "Шиян", "CN", "156", "12", "", "", "", "32.56667", "110.78333", "Asia/Shanghai"),
("1794947", "Shiwan", "", "CN", "156", "30", "", "", "", "23.00107", "113.077", "Asia/Shanghai"),
("1794971", "Shitanjing", "", "CN", "156", "21", "", "", "", "39.23417", "106.34389", "Asia/Chongqing"),
("1795055", "Shiqiao", "", "CN", "156", "30", "", "", "", "22.9464", "113.35769", "Asia/Shanghai"),
("1795060", "Shiqi", "", "CN", "156", "30", "", "", "", "22.51682", "113.38521", "Asia/Shanghai"),
("1795166", "Shima", "Шима", "CN", "156", "07", "", "", "", "24.44647", "117.81216", "Asia/Shanghai"),
("1795184", "Shilong", "", "CN", "156", "30", "", "", "", "23.11444", "113.84722", "Asia/Shanghai"),
("1795196", "Tongchuan", "", "CN", "156", "26", "", "", "", "35.08056", "109.08972", "Asia/Chongqing"),
("1795270", "Shijiazhuang", "Шицзячжуан", "CN", "156", "10", "", "", "", "38.04139", "114.47861", "Asia/Shanghai"),
("1795565", "Shenzhen", "Шэньчжэнь", "CN", "156", "30", "1795563", "", "", "22.54554", "114.0683", "Asia/Shanghai"),
("1795579", "Yanta", "", "CN", "156", "25", "", "", "", "36.24111", "115.66722", "Asia/Shanghai"),
("1795632", "Shenjiamen", "", "CN", "156", "02", "", "", "", "29.95762", "122.29802", "Asia/Shanghai"),
("1795816", "Shashi", "Шаши", "CN", "156", "12", "", "", "", "30.30722", "112.24472", "Asia/Shanghai"),
("1795842", "Shaping", "", "CN", "156", "30", "", "", "", "22.77019", "112.95776", "Asia/Shanghai"),
("1795855", "Shaoxing", "Шаосин", "CN", "156", "02", "", "", "", "30.00237", "120.57864", "Asia/Shanghai"),
("1795857", "Shaowu", "", "CN", "156", "07", "", "", "", "27.34089", "117.4831", "Asia/Shanghai"),
("1795874", "Shaoguan", "Шаогуань", "CN", "156", "30", "", "", "", "24.8", "113.58333", "Asia/Shanghai"),
("1795919", "Shancheng", "", "CN", "156", "25", "", "", "", "34.79528", "116.08167", "Asia/Shanghai"),
("1795928", "Shanwei", "Шаньвэй", "CN", "156", "30", "", "", "", "22.78199", "115.3475", "Asia/Shanghai"),
("1795940", "Shantou", "Шаньтоу", "CN", "156", "30", "", "", "", "23.36814", "116.71479", "Asia/Shanghai"),
("1795941", "Shanting", "", "CN", "156", "25", "", "", "", "35.07528", "117.45778", "Asia/Shanghai"),
("1796236", "Shanghai", "Шанхай", "CN", "156", "23", "", "", "", "31.22222", "121.45806", "Asia/Shanghai"),
("1796421", "Shahecheng", "", "CN", "156", "10", "", "", "", "36.93833", "114.50583", "Asia/Shanghai"),
("1796556", "Sanya", "Санья", "CN", "156", "31", "", "", "", "18.24306", "109.505", "Asia/Chongqing"),
("1796663", "Sanming", "Саньмин", "CN", "156", "07", "", "", "", "26.24861", "117.61861", "Asia/Shanghai"),
("1797038", "Runan", "", "CN", "156", "09", "", "", "", "33.00111", "114.35417", "Asia/Shanghai"),
("1797120", "Fuqing", "Фуцинь", "CN", "156", "07", "", "", "", "25.725", "119.37944", "Asia/Shanghai"),
("1797121", "Jieyang", "Цзеян", "CN", "156", "30", "", "", "", "23.5418", "116.36581", "Asia/Shanghai"),
("1797132", "Rizhao", "", "CN", "156", "25", "", "", "", "35.4275", "119.45528", "Asia/Shanghai"),
("1797181", "Renqiu", "", "CN", "156", "10", "", "", "", "38.69889", "116.09361", "Asia/Shanghai"),
("1797264", "Quzhou", "Цюйчжоу", "CN", "156", "02", "", "", "", "28.95944", "118.86861", "Asia/Shanghai"),
("1797318", "Qujing", "", "CN", "156", "29", "", "", "", "25.48333", "103.78333", "Asia/Chongqing"),
("1797333", "Qufu", "Цюйфу", "CN", "156", "25", "", "", "", "35.59667", "116.99111", "Asia/Shanghai"),
("1797353", "Quanzhou", "Цюаньчжоу", "CN", "156", "07", "", "", "", "24.91389", "118.58583", "Asia/Shanghai"),
("1797417", "Wuxi", "", "CN", "156", "11", "", "", "", "26.5844", "111.859", "Asia/Shanghai"),
("1797438", "Zhuangyuan", "", "CN", "156", "25", "", "", "", "37.30553", "120.82747", "Asia/Shanghai"),
("1797535", "Qiongshan", "", "CN", "156", "31", "", "", "", "20.00583", "110.35417", "Asia/Chongqing"),
("1797543", "Qionghu", "", "CN", "156", "11", "", "", "", "28.84061", "112.37399", "Asia/Shanghai"),
("1797551", "Qinzhou", "", "CN", "156", "16", "", "", "", "21.97296", "108.62612", "Asia/Chongqing"),
("1797575", "Qinnan", "", "CN", "156", "04", "", "", "", "33.25306", "119.91333", "Asia/Shanghai"),
("1797595", "Qinhuangdao", "Циньхуандао", "CN", "156", "10", "", "", "", "39.93167", "119.58833", "Asia/Shanghai"),
("1797658", "Jinjiang", "", "CN", "156", "07", "", "", "", "24.81978", "118.57414", "Asia/Shanghai"),
("1797793", "Qingquan", "Цинцюань", "CN", "156", "12", "", "", "", "30.45113", "115.25593", "Asia/Shanghai"),
("1797873", "Huai'an", "", "CN", "156", "04", "", "", "", "33.58861", "119.01917", "Asia/Shanghai"),
("1797929", "Qingdao", "Циндао", "CN", "156", "25", "", "", "", "36.06605", "120.36939", "Asia/Shanghai"),
("1797945", "Qingyuan", "", "CN", "156", "30", "", "", "", "23.7", "113.03333", "Asia/Shanghai"),
("1798082", "Hongqiao", "Хунцяо", "CN", "156", "11", "", "", "", "26.76837", "112.10814", "Asia/Shanghai"),
("1798422", "Puyang Chengguanzhen", "", "CN", "156", "09", "", "", "", "35.70506", "115.01409", "Asia/Shanghai"),
("1798425", "Puyang", "", "CN", "156", "02", "", "", "", "29.45679", "119.88872", "Asia/Shanghai"),
("1798449", "Putian", "Путянь", "CN", "156", "07", "", "", "", "25.43944", "119.01028", "Asia/Shanghai"),
("1798473", "Puqi", "", "CN", "156", "12", "", "", "", "29.71667", "113.88333", "Asia/Shanghai"),
("1798480", "Pumiao", "", "CN", "156", "16", "", "", "", "22.75867", "108.48111", "Asia/Chongqing"),
("1798490", "Pulandian", "", "CN", "156", "19", "", "", "", "39.39528", "121.96694", "Asia/Shanghai"),
("1798548", "Poyang", "Поянху", "CN", "156", "03", "", "", "", "28.99242", "116.66754", "Asia/Shanghai"),
("1798632", "Pingyin", "", "CN", "156", "25", "", "", "", "36.28306", "116.44528", "Asia/Shanghai"),
("1798634", "Pingyi", "", "CN", "156", "25", "", "", "", "35.50056", "117.63083", "Asia/Shanghai"),
("1798636", "Gutao", "Пинъяо", "CN", "156", "24", "", "", "", "37.2025", "112.17806", "Asia/Shanghai"),
("1798654", "Pingxiang", "", "CN", "156", "03", "", "", "", "27.61672", "113.85353", "Asia/Shanghai"),
("1798713", "Pingshan", "", "CN", "156", "30", "", "", "", "22.99376", "114.71311", "Asia/Shanghai"),
("1798733", "Pingnan", "", "CN", "156", "16", "", "", "", "23.54218", "110.38946", "Asia/Chongqing"),
("1798760", "Pingliang", "Пинлян", "CN", "156", "15", "", "", "", "35.53917", "106.68611", "Asia/Chongqing"),
("1798821", "Pingdu", "Пинду", "CN", "156", "25", "", "", "", "36.78444", "119.94639", "Asia/Shanghai"),
("1798827", "Pingdingshan", "Пиндиншань", "CN", "156", "09", "", "", "", "33.73847", "113.30119", "Asia/Shanghai"),
("1798946", "Pengcheng", "", "CN", "156", "10", "", "", "", "36.43111", "114.17", "Asia/Shanghai"),
("1798998", "Dadukou", "Паньчжихуа", "CN", "156", "32", "", "", "", "26.5479", "101.70539", "Asia/Chongqing"),
("1799348", "Ningyang", "", "CN", "156", "25", "", "", "", "35.76417", "116.79139", "Asia/Shanghai"),
("1799352", "Yutan", "", "CN", "156", "11", "", "", "", "28.25831", "112.56048", "Asia/Shanghai"),
("1799383", "Ninghai", "", "CN", "156", "25", "", "", "", "37.38422", "121.60859", "Asia/Shanghai"),
("1799384", "Ninghai", "", "CN", "156", "02", "", "", "", "29.28917", "121.42472", "Asia/Shanghai"),
("1799397", "Ningbo", "Нинбо", "CN", "156", "02", "", "", "", "29.87819", "121.54945", "Asia/Shanghai"),
("1799491", "Neijiang", "", "CN", "156", "32", "", "", "", "29.58354", "105.06216", "Asia/Chongqing"),
("1799552", "Nanzhou", "", "CN", "156", "11", "", "", "", "29.35955", "112.40243", "Asia/Shanghai"),
("1799574", "Nanzhang Chengguanzhen", "", "CN", "156", "12", "", "", "", "31.78394", "111.82752", "Asia/Shanghai"),
("1799629", "Nanyang", "Наньян", "CN", "156", "09", "", "", "", "32.99472", "112.53278", "Asia/Shanghai"),
("1799722", "Nantong", "Наньтун", "CN", "156", "04", "", "", "", "32.03028", "120.87472", "Asia/Shanghai"),
("1799832", "Pucheng", "", "CN", "156", "07", "", "", "", "27.92333", "118.53333", "Asia/Shanghai"),
("1799846", "Nanping", "Наньпин", "CN", "156", "07", "", "", "", "26.645", "118.17361", "Asia/Shanghai"),
("1799869", "Nanning", "Наньнин", "CN", "156", "16", "", "", "", "22.81667", "108.31667", "Asia/Chongqing"),
("1799897", "Nanma", "", "CN", "156", "25", "", "", "", "36.18167", "118.15833", "Asia/Shanghai"),
("1799908", "Nanlong", "", "CN", "156", "32", "", "", "", "31.35333", "106.06309", "Asia/Chongqing"),
("1799962", "Nanjing", "Нанкин", "CN", "156", "04", "", "", "", "32.06167", "118.77778", "Asia/Shanghai"),
("1800065", "Nangong", "", "CN", "156", "10", "", "", "", "37.35806", "115.37444", "Asia/Shanghai"),
("1800088", "Nanfeng", "", "CN", "156", "30", "", "", "", "23.72695", "111.79723", "Asia/Shanghai"),
("1800101", "Nandu", "", "CN", "156", "16", "", "", "", "22.8525", "110.82333", "Asia/Chongqing"),
("1800107", "Nanding", "", "CN", "156", "25", "", "", "", "36.74833", "118.05583", "Asia/Shanghai"),
("1800146", "Nanchong", "Наньчун", "CN", "156", "32", "", "", "", "30.79508", "106.08474", "Asia/Chongqing"),
("1800163", "Nanchang", "Наньчан", "CN", "156", "03", "", "", "", "28.68333", "115.88333", "Asia/Shanghai"),
("1800430", "Miyang", "", "CN", "156", "29", "", "", "", "24.40417", "103.44278", "Asia/Chongqing"),
("1800498", "Mingshui", "", "CN", "156", "25", "", "", "", "36.71667", "117.5", "Asia/Shanghai"),
("1800519", "Mingguang", "", "CN", "156", "01", "", "", "", "32.78017", "117.96378", "Asia/Shanghai"),
("1800521", "Minggang", "", "CN", "156", "09", "", "", "", "32.45861", "114.04861", "Asia/Shanghai"),
("1800627", "Mianyang", "Мяньян", "CN", "156", "32", "", "", "", "31.45934", "104.75424", "Asia/Chongqing"),
("1800657", "Mentougou", "", "CN", "156", "22", "", "", "", "39.93819", "116.09307", "Asia/Shanghai"),
("1800675", "Mengyin", "", "CN", "156", "25", "", "", "", "35.70694", "117.92639", "Asia/Shanghai"),
("1800764", "Mengcheng Chengguanzhen", "", "CN", "156", "01", "", "", "", "33.26611", "116.56605", "Asia/Shanghai"),
("1800779", "Meizhou", "Мэйчжоу", "CN", "156", "30", "", "", "", "24.29769", "116.10724", "Asia/Shanghai"),
("1800829", "Wuchuan", "", "CN", "156", "30", "", "", "", "21.45713", "110.76591", "Asia/Urumqi"),
("1801401", "Majie", "", "CN", "156", "29", "", "", "", "25.03333", "102.63611", "Asia/Chongqing"),
("1801455", "Zhijiang", "", "CN", "156", "12", "", "", "", "30.42139", "111.75333", "Asia/Shanghai"),
("1801582", "Macheng", "", "CN", "156", "12", "", "", "", "31.18013", "115.02213", "Asia/Shanghai"),
("1801615", "Maba", "", "CN", "156", "30", "", "", "", "24.68412", "113.59839", "Asia/Shanghai"),
("1801722", "Lushun", "Порт-Артур", "CN", "156", "19", "", "", "", "38.8", "121.26667", "Asia/Shanghai"),
("1801757", "Luqiao", "", "CN", "156", "02", "", "", "", "28.58023", "121.37491", "Asia/Shanghai"),
("1801792", "Luoyang", "Лоян", "CN", "156", "09", "1801785", "", "", "34.68361", "112.45361", "Asia/Shanghai"),
("1801797", "Luoyang", "Лоян", "CN", "156", "07", "", "", "", "24.95938", "118.683", "Asia/Shanghai"),
("1801799", "Luoyang", "Лоян", "CN", "156", "30", "", "", "", "23.16244", "114.27342", "Asia/Shanghai"),
("1801850", "Luorong", "", "CN", "156", "16", "", "", "", "24.40583", "109.60861", "Asia/Chongqing"),
("1801934", "Luohe", "", "CN", "156", "09", "", "", "", "33.57167", "114.03528", "Asia/Shanghai"),
("1801983", "Luocheng", "", "CN", "156", "32", "", "", "", "29.38481", "104.02862", "Asia/Chongqing"),
("1802068", "Lucheng", "", "CN", "156", "01", "", "", "", "31.23357", "117.28057", "Asia/Shanghai"),
("1802171", "Kangding", "Кандин", "CN", "156", "32", "", "", "", "30.05127", "101.96033", "Asia/Chongqing"),
("1802177", "Lubu", "", "CN", "156", "30", "", "", "", "23.17233", "112.28298", "Asia/Shanghai"),
("1802204", "Luancheng", "", "CN", "156", "10", "", "", "", "37.87917", "114.65167", "Asia/Shanghai"),
("1802238", "Loudi", "Лоуди", "CN", "156", "11", "", "", "", "27.73444", "111.99444", "Asia/Shanghai"),
("1802476", "Longquan", "Лунцюань", "CN", "156", "29", "", "", "", "24.67192", "102.1613", "Asia/Chongqing"),
("1802550", "Longgang", "", "CN", "156", "25", "", "", "", "37.65182", "120.33063", "Asia/Shanghai"),
("1802788", "Licheng", "", "CN", "156", "04", "", "", "", "31.42813", "119.48353", "Asia/Shanghai"),
("1802875", "Guankou", "Лиуянг", "CN", "156", "11", "", "", "", "28.15861", "113.62709", "Asia/Shanghai"),
("1802940", "Puning", "", "CN", "156", "30", "", "", "", "23.31072", "116.16869", "Asia/Shanghai"),
("1803245", "Lishui", "Лишуй", "CN", "156", "02", "", "", "", "28.46042", "119.91029", "Asia/Shanghai"),
("1803266", "Lintong", "", "CN", "156", "26", "", "", "", "34.37803", "109.20892", "Asia/Chongqing"),
("1803318", "Linyi", "Линьи", "CN", "156", "25", "", "", "", "35.06306", "118.34278", "Asia/Shanghai"),
("1803331", "Linxia Chengguanzhen", "Линься", "CN", "156", "15", "", "", "", "35.60028", "103.20639", "Asia/Chongqing"),
("1803334", "Linxi", "", "CN", "156", "10", "", "", "", "39.7", "118.43333", "Asia/Shanghai"),
("1803352", "Linshui", "", "CN", "156", "10", "", "", "", "36.42472", "114.20472", "Asia/Shanghai"),
("1803364", "Linqu", "", "CN", "156", "25", "", "", "", "36.51556", "118.53972", "Asia/Shanghai"),
("1803365", "Linqiong", "", "CN", "156", "32", "", "", "", "30.41587", "103.46088", "Asia/Chongqing"),
("1803367", "Qingnian", "", "CN", "156", "25", "", "", "", "36.84032", "115.71183", "Asia/Shanghai"),
("1803374", "Linping", "", "CN", "156", "02", "", "", "", "30.4225", "120.29722", "Asia/Shanghai"),
("1803422", "Linhai", "", "CN", "156", "02", "", "", "", "28.84815", "121.12807", "Asia/Shanghai"),
("1803551", "Lingcheng", "", "CN", "156", "16", "", "", "", "22.70722", "110.34917", "Asia/Chongqing"),
("1803560", "Lincheng", "Линьчэн", "CN", "156", "31", "", "", "", "19.90778", "109.68583", "Asia/Chongqing"),
("1803567", "Linfen", "Линьфынь", "CN", "156", "24", "", "", "", "36.08889", "111.51889", "Asia/Shanghai"),
("1803616", "Xishan", "Лилин", "CN", "156", "11", "", "", "", "27.66667", "113.5", "Asia/Shanghai"),
("1803782", "Lichuan", "Личуань", "CN", "156", "12", "", "", "", "30.3", "108.85", "Asia/Shanghai"),
("1803791", "Licheng", "", "CN", "156", "30", "", "", "", "23.29549", "113.82465", "Asia/Shanghai"),
("1803834", "Liaocheng", "Ляочэн", "CN", "156", "25", "", "", "", "36.45596", "115.97766", "Asia/Shanghai"),
("1803841", "Lianzhou", "", "CN", "156", "30", "", "", "", "24.78186", "112.3712", "Asia/Shanghai"),
("1803842", "Lianzhou", "", "CN", "156", "16", "", "", "", "21.66621", "109.20116", "Asia/Chongqing"),
("1803886", "Lianran", "", "CN", "156", "29", "", "", "", "24.92271", "102.48496", "Asia/Chongqing"),
("1803936", "Wuwei", "", "CN", "156", "15", "", "", "", "37.92672", "102.63202", "Asia/Chongqing"),
("1803948", "Liangxiang", "", "CN", "156", "22", "", "", "", "39.73598", "116.13295", "Asia/Shanghai"),
("1804120", "Lianjiang", "", "CN", "156", "30", "", "", "", "21.64673", "110.28172", "Asia/Urumqi"),
("1804153", "Leshan", "Лэшань", "CN", "156", "32", "", "", "", "29.56228", "103.76386", "Asia/Chongqing"),
("1804162", "Lengshuitan", "", "CN", "156", "11", "", "", "", "26.4111", "111.59559", "Asia/Shanghai"),
("1804169", "Lengshuijiang", "", "CN", "156", "11", "", "", "", "27.68806", "111.42944", "Asia/Shanghai"),
("1804208", "Leiyang", "", "CN", "156", "11", "", "", "", "26.40238", "112.85908", "Asia/Shanghai"),
("1804252", "Lecheng", "", "CN", "156", "30", "", "", "", "25.128", "113.35041", "Asia/Shanghai"),
("1804386", "Laohekou", "", "CN", "156", "12", "", "", "", "32.38583", "111.66778", "Asia/Shanghai"),
("1804430", "Lanzhou", "Ланьчжоу", "CN", "156", "15", "", "", "", "36.05701", "103.83987", "Asia/Chongqing"),
("1804442", "Lanxi", "", "CN", "156", "02", "", "", "", "29.21588", "119.47156", "Asia/Shanghai"),
("1804451", "Lianyuan", "", "CN", "156", "11", "", "", "", "27.68833", "111.66417", "Asia/Shanghai"),
("1804540", "Langfang", "Ланфан", "CN", "156", "10", "", "", "", "39.50972", "116.69472", "Asia/Shanghai"),
("1804578", "Weichanglu", "", "CN", "156", "25", "", "", "", "37.18072", "119.94217", "Asia/Shanghai"),
("1804586", "Laiyang", "", "CN", "156", "25", "", "", "", "36.97583", "120.71361", "Asia/Shanghai"),
("1804591", "Laiwu", "", "CN", "156", "25", "", "", "", "36.19278", "117.65694", "Asia/Shanghai"),
("1804609", "Laibin", "", "CN", "156", "16", "", "", "", "23.7", "109.26667", "Asia/Chongqing"),
("1804645", "Kunyang", "", "CN", "156", "02", "", "", "", "27.66583", "120.56583", "Asia/Shanghai"),
("1804651", "Kunming", "Куньмин", "CN", "156", "29", "", "", "", "25.03889", "102.71833", "Asia/Chongqing"),
("1804850", "Kaiyuan", "Кайюань", "CN", "156", "29", "", "", "", "23.69767", "103.30372", "Asia/Chongqing"),
("1804874", "Kaihua", "", "CN", "156", "29", "", "", "", "23.3695", "104.27721", "Asia/Chongqing"),
("1804879", "Kaifeng", "Кайфэн", "CN", "156", "09", "", "", "", "34.7986", "114.30742", "Asia/Shanghai"),
("1804892", "Juye", "", "CN", "156", "25", "", "", "", "35.39472", "116.08833", "Asia/Shanghai"),
("1804979", "Juegang", "", "CN", "156", "04", "", "", "", "32.31737", "121.18552", "Asia/Shanghai"),
("1805179", "Jiujiang", "Цзюцзян", "CN", "156", "03", "", "", "", "29.73333", "115.98333", "Asia/Shanghai"),
("1805267", "Jishui", "", "CN", "156", "09", "", "", "", "33.73333", "115.4", "Asia/Shanghai"),
("1805270", "Qianzhou", "", "CN", "156", "11", "", "", "", "28.31926", "109.73346", "Asia/Shanghai"),
("1805298", "Jinzhou", "Цзиньчжоу", "CN", "156", "19", "", "", "", "39.1", "121.71667", "Asia/Shanghai"),
("1805334", "Jinxiangzhen", "", "CN", "156", "02", "", "", "", "27.43265", "120.60625", "Asia/Shanghai"),
("1805379", "Jinshi", "", "CN", "156", "11", "", "", "", "29.60487", "111.87012", "Asia/Shanghai"),
("1805408", "Jinsha", "Цзиньша", "CN", "156", "04", "", "", "", "32.08982", "121.07355", "Asia/Shanghai"),
("1805505", "Jinjiang", "", "CN", "156", "31", "", "", "", "19.72878", "110.00851", "Asia/Chongqing"),
("1805515", "Jinji", "", "CN", "156", "16", "", "", "", "23.22806", "110.82611", "Asia/Chongqing"),
("1805518", "Jining", "Цзинин", "CN", "156", "25", "", "", "", "35.405", "116.58139", "Asia/Shanghai"),
("1805528", "Jinhua", "Цзиньхуа", "CN", "156", "02", "", "", "", "29.10678", "119.64421", "Asia/Shanghai"),
("1805540", "Jingzhou", "Цзинчжоу", "CN", "156", "12", "", "", "", "30.35028", "112.19028", "Asia/Shanghai"),
("1805563", "Tianchang", "", "CN", "156", "10", "", "", "", "37.99806", "114.01556", "Asia/Shanghai"),
("1805611", "Jingmen", "Цзинмэнь", "CN", "156", "12", "", "", "", "31.03361", "112.20472", "Asia/Shanghai"),
("1805618", "Jingling", "", "CN", "156", "12", "", "", "", "30.65", "113.1", "Asia/Shanghai"),
("1805680", "Jingdezhen", "Цзиндэчжэнь", "CN", "156", "03", "", "", "", "29.2947", "117.20789", "Asia/Shanghai"),
("1805733", "Jinchang", "Цзиньчан", "CN", "156", "15", "1805747", "", "", "38.50062", "102.19379", "Asia/Chongqing"),
("1805741", "Jincheng", "Цзиньчэн", "CN", "156", "24", "", "", "", "35.50222", "112.83278", "Asia/Shanghai"),
("1805753", "Jinan", "Цзинань", "CN", "156", "25", "", "", "", "36.66833", "116.99722", "Asia/Shanghai"),
("1805757", "Jimo", "", "CN", "156", "25", "", "", "", "36.38972", "120.46222", "Asia/Shanghai"),
("1805798", "Jijiang", "", "CN", "156", "33", "", "", "", "29.28993", "106.25001", "Asia/Chongqing"),
("1805833", "Jiexiu", "", "CN", "156", "24", "", "", "", "37.02444", "111.9125", "Asia/Shanghai"),
("1805844", "Jieshou", "", "CN", "156", "01", "1810843", "", "", "33.26338", "115.36108", "Asia/Shanghai"),
("1805857", "Jieshi", "", "CN", "156", "30", "", "", "", "22.81027", "115.83058", "Asia/Shanghai"),
("1805884", "Jiehu", "", "CN", "156", "25", "", "", "", "35.54278", "118.455", "Asia/Shanghai"),
("1805935", "Jiazi", "", "CN", "156", "30", "", "", "", "22.87932", "116.07318", "Asia/Shanghai"),
("1805953", "Jiaxing", "Цзясин", "CN", "156", "02", "", "", "", "30.7522", "120.75", "Asia/Shanghai"),
("1805987", "Jiaozuo", "Цзяоцзо", "CN", "156", "09", "", "", "", "35.23972", "113.23306", "Asia/Shanghai"),
("1806096", "Jiaozhou", "", "CN", "156", "25", "", "", "", "36.28389", "120.00333", "Asia/Shanghai"),
("1806097", "Ningde", "", "CN", "156", "07", "", "", "", "26.66167", "119.52278", "Asia/Shanghai"),
("1806167", "Jian'ou", "", "CN", "156", "07", "", "", "", "27.04694", "118.32528", "Asia/Shanghai"),
("1806218", "Jiangyan", "", "CN", "156", "04", "", "", "", "32.50611", "120.14278", "Asia/Shanghai"),
("1806248", "Jianguang", "", "CN", "156", "03", "", "", "", "28.19377", "115.7836", "Asia/Shanghai"),
("1806299", "Jiangmen", "Цзянмэнь", "CN", "156", "30", "", "", "", "22.58333", "113.08333", "Asia/Shanghai"),
("1806327", "Jiangkou", "", "CN", "156", "07", "", "", "", "25.48694", "119.19834", "Asia/Shanghai"),
("1806408", "Yangjiang", "Янцзян", "CN", "156", "30", "", "", "", "21.85564", "111.96272", "Asia/Chongqing"),
("1806445", "Ji'an", "Цзиань", "CN", "156", "03", "", "", "", "27.11716", "114.97927", "Asia/Shanghai"),
("1806466", "Guangyuan", "", "CN", "156", "32", "", "", "", "32.44202", "105.823", "Asia/Chongqing"),
("1806535", "Huzhou", "", "CN", "156", "02", "", "", "", "30.8703", "120.0933", "Asia/Shanghai"),
("1806591", "Hutang", "", "CN", "156", "04", "", "", "", "31.53429", "119.49", "Asia/Shanghai"),
("1806651", "Huoqiu Chengguanzhen", "", "CN", "156", "01", "", "", "", "32.35473", "116.2939", "Asia/Shanghai"),
("1806696", "Humen", "Хумэнь", "CN", "156", "30", "", "", "", "22.81898", "113.67306", "Asia/Shanghai"),
("1806776", "Huizhou", "Хуэйчжоу", "CN", "156", "30", "", "", "", "23.08333", "114.4", "Asia/Shanghai"),
("1806840", "Huilong", "Квидонга", "CN", "156", "04", "", "", "", "31.81111", "121.655", "Asia/Shanghai"),
("1806881", "Huicheng", "", "CN", "156", "30", "", "", "", "23.03845", "116.28988", "Asia/Shanghai"),
("1806882", "Xinhui", "", "CN", "156", "30", "", "", "", "22.456", "113.0482", "Asia/Shanghai"),
("1806960", "Huazhou", "", "CN", "156", "30", "", "", "", "21.63333", "110.58333", "Asia/Urumqi"),
("1807112", "Huangzhou", "Хуанчжоу", "CN", "156", "12", "", "", "", "30.45", "114.8", "Asia/Shanghai"),
("1807143", "Huangyan", "", "CN", "156", "02", "", "", "", "28.6501", "121.26591", "Asia/Shanghai"),
("1807234", "Huangshi", "Хуанши", "CN", "156", "12", "", "", "", "30.24706", "115.04814", "Asia/Shanghai"),
("1807301", "Dasha", "Даша", "CN", "156", "30", "", "", "", "23.11037", "113.4418", "Asia/Shanghai"),
("1807308", "Huangpi", "", "CN", "156", "12", "", "", "", "30.88453", "114.37789", "Asia/Shanghai"),
("1807339", "Huangmei", "", "CN", "156", "12", "", "", "", "30.19235", "116.02496", "Asia/Shanghai"),
("1807508", "Huanggang", "Хуанган", "CN", "156", "30", "", "", "", "23.67704", "116.99961", "Asia/Shanghai"),
("1807544", "Daxing", "Дасин", "CN", "156", "22", "", "", "", "39.74025", "116.32693", "Asia/Shanghai"),
("1807553", "Huangchuan", "", "CN", "156", "09", "", "", "", "32.12722", "115.03944", "Asia/Shanghai"),
("1807645", "Huaiyuan Chengguanzhen", "", "CN", "156", "01", "", "", "", "32.95893", "117.16566", "Asia/Shanghai"),
("1807681", "Huainan", "", "CN", "156", "01", "", "", "", "32.62639", "116.99694", "Asia/Shanghai"),
("1807687", "Huaicheng", "", "CN", "156", "30", "", "", "", "23.91952", "112.17629", "Asia/Shanghai"),
("1807689", "Huaihua", "Хуайхуа", "CN", "156", "11", "", "", "", "27.54944", "109.95917", "Asia/Shanghai"),
("1807695", "Huaidian", "", "CN", "156", "09", "", "", "", "33.43333", "115.03333", "Asia/Shanghai"),
("1807700", "Huaibei", "Хуайбэй", "CN", "156", "01", "", "", "", "33.97444", "116.79167", "Asia/Shanghai"),
("1808106", "Hongjiang", "", "CN", "156", "11", "", "", "", "27.11", "109.99556", "Asia/Shanghai"),
("1808198", "Heze", "Хэцзэ", "CN", "156", "25", "", "", "", "35.23929", "115.47358", "Asia/Shanghai"),
("1808212", "Hechuan", "", "CN", "156", "33", "", "", "", "29.99228", "106.26461", "Asia/Chongqing"),
("1808316", "Yiyang", "Иян", "CN", "156", "11", "", "", "", "28.58917", "112.32833", "Asia/Shanghai"),
("1808336", "Hepo", "Хэпо", "CN", "156", "30", "", "", "", "23.43077", "115.82991", "Asia/Shanghai"),
("1808370", "Hengyang", "Хэнъян", "CN", "156", "11", "1808369", "", "", "26.88946", "112.61888", "Asia/Shanghai"),
("1808392", "Hengshui", "Хэншуй", "CN", "156", "10", "", "", "", "37.73222", "115.70111", "Asia/Shanghai"),
("1808722", "Hefei", "Хэфэй", "CN", "156", "01", "", "", "", "31.86389", "117.28083", "Asia/Shanghai"),
("1808744", "Hede", "Хеде", "CN", "156", "04", "", "", "", "33.7722", "120.26176", "Asia/Shanghai"),
("1808747", "Hecun", "", "CN", "156", "10", "", "", "", "36.53333", "114.11111", "Asia/Shanghai"),
("1808770", "Hebi", "", "CN", "156", "09", "", "", "", "35.89917", "114.1925", "Asia/Shanghai"),
("1808857", "Hanzhong", "Ханьчжун", "CN", "156", "26", "", "", "", "33.07278", "107.03028", "Asia/Chongqing"),
("1808872", "Chengyang", "Фуаня", "CN", "156", "07", "", "", "", "27.08917", "119.64528", "Asia/Shanghai"),
("1808879", "Hanting", "", "CN", "156", "25", "", "", "", "36.77083", "119.21083", "Asia/Shanghai"),
("1808926", "Hangzhou", "Ханчжоу", "CN", "156", "02", "", "", "", "30.29365", "120.16142", "Asia/Shanghai"),
("1808931", "Hangu", "Ханга", "CN", "156", "28", "", "", "", "39.24889", "117.78917", "Asia/Shanghai"),
("1808963", "Handan", "Ханьдань", "CN", "156", "10", "", "", "", "36.60056", "114.46778", "Asia/Shanghai"),
("1808977", "Hanchuan", "", "CN", "156", "12", "", "", "", "30.65", "113.76667", "Asia/Shanghai"),
("1808981", "Hancheng", "", "CN", "156", "26", "", "", "", "35.46028", "110.42917", "Asia/Chongqing"),
("1809003", "Haizhou", "", "CN", "156", "04", "", "", "", "34.58167", "119.12889", "Asia/Shanghai"),
("1809061", "Jiaojiang", "", "CN", "156", "02", "", "", "", "28.68028", "121.44278", "Asia/Shanghai"),
("1809062", "Haimen", "", "CN", "156", "30", "", "", "", "23.19346", "116.61219", "Asia/Shanghai"),
("1809077", "Haikou", "", "CN", "156", "29", "", "", "", "24.77985", "102.57548", "Asia/Chongqing"),
("1809078", "Haikou", "Хайкоу", "CN", "156", "31", "", "", "", "20.04583", "110.34167", "Asia/Chongqing"),
("1809159", "Guye", "", "CN", "156", "10", "", "", "", "39.73333", "118.41667", "Asia/Shanghai"),
("1809263", "Guozhen", "", "CN", "156", "26", "", "", "", "34.36591", "107.35904", "Asia/Chongqing"),
("1809412", "Guli", "Гули", "CN", "156", "02", "", "", "", "28.88162", "120.03308", "Asia/Shanghai"),
("1809461", "Guiyang", "Гуйян", "CN", "156", "18", "", "", "", "26.58333", "106.71667", "Asia/Chongqing"),
("1809483", "Guiren", "", "CN", "156", "04", "", "", "", "33.66972", "118.18889", "Asia/Shanghai"),
("1809486", "Guiping", "", "CN", "156", "16", "", "", "", "23.39336", "110.07437", "Asia/Chongqing"),
("1809498", "Guilin", "Гуйлинь", "CN", "156", "16", "", "", "", "25.28194", "110.28639", "Asia/Chongqing"),
("1809532", "Guigang", "", "CN", "156", "16", "", "", "", "23.09639", "109.60917", "Asia/Chongqing"),
("1809610", "Gucheng Chengguanzhen", "", "CN", "156", "12", "", "", "", "32.26604", "111.63476", "Asia/Shanghai"),
("1809858", "Guangzhou", "Гуанчжоу", "CN", "156", "30", "", "", "", "23.11667", "113.25", "Asia/Shanghai"),
("1809879", "Guangshui", "", "CN", "156", "12", "", "", "", "31.6199", "113.9978", "Asia/Shanghai"),
("1810240", "Gejiu", "", "CN", "156", "29", "", "", "", "23.36085", "103.15372", "Asia/Chongqing"),
("1810295", "Gaozhou", "", "CN", "156", "30", "", "", "", "21.93924", "110.84607", "Asia/Urumqi"),
("1810309", "Gaoyou", "", "CN", "156", "04", "", "", "", "32.78933", "119.44182", "Asia/Shanghai"),
("1810437", "Gaoping", "", "CN", "156", "32", "", "", "", "30.77576", "106.10294", "Asia/Chongqing"),
("1810458", "Gaomi", "", "CN", "156", "25", "", "", "", "36.38333", "119.75278", "Asia/Shanghai"),
("1810553", "Gaogou", "", "CN", "156", "04", "", "", "", "34.0175", "119.18861", "Asia/Shanghai"),
("1810821", "Fuzhou", "Фучжоу", "CN", "156", "07", "", "", "", "26.06139", "119.30611", "Asia/Shanghai"),
("1810845", "Fuyang", "Фуян", "CN", "156", "01", "", "", "", "32.9", "115.81667", "Asia/Shanghai"),
("1810846", "Fuyang", "Фуянь", "CN", "156", "02", "", "", "", "30.05333", "119.95194", "Asia/Shanghai"),
("1810920", "Qingyang", "", "CN", "156", "25", "", "", "", "37.49583", "121.25806", "Asia/Shanghai"),
("1810979", "Fuling", "Фулин", "CN", "156", "33", "", "", "", "29.706", "107.39575", "Asia/Chongqing"),
("1811103", "Foshan", "Фошань", "CN", "156", "30", "", "", "", "23.02677", "113.13148", "Asia/Shanghai"),
("1811114", "Fenyi", "", "CN", "156", "03", "", "", "", "27.81117", "114.66805", "Asia/Shanghai"),
("1811200", "Fengxian", "", "CN", "156", "04", "", "", "", "34.70388", "116.58717", "Asia/Shanghai"),
("1811260", "Fengrun", "", "CN", "156", "10", "", "", "", "39.83333", "118.11667", "Asia/Shanghai"),
("1811305", "Fengkou", "", "CN", "156", "12", "", "", "", "30.08268", "113.33346", "Asia/Shanghai"),
("1811440", "Feicheng", "", "CN", "156", "25", "", "", "", "35.26056", "117.9675", "Asia/Shanghai"),
("1811542", "Fangshan", "", "CN", "156", "22", "", "", "", "39.69833", "115.9925", "Asia/Shanghai"),
("1811619", "Ezhou", "", "CN", "156", "12", "", "", "", "30.4", "114.83333", "Asia/Shanghai"),
("1811720", "Enshi", "Эньши", "CN", "156", "12", "", "", "", "30.3", "109.48333", "Asia/Shanghai"),
("1811729", "Encheng", "Эньпин", "CN", "156", "30", "", "", "", "22.18659", "112.30424", "Asia/Chongqing"),
("1811764", "Duyun", "Дуюн", "CN", "156", "18", "", "", "", "26.26667", "107.51667", "Asia/Chongqing"),
("1811829", "Duobao", "", "CN", "156", "12", "", "", "", "30.67", "112.68952", "Asia/Shanghai"),
("1811929", "Ducheng", "", "CN", "156", "30", "", "", "", "23.24212", "111.5284", "Asia/Chongqing"),
("1812057", "Xinyi", "", "CN", "156", "30", "", "", "", "22.37303", "110.94746", "Asia/Urumqi"),
("1812101", "Dongying", "Дуньин", "CN", "156", "25", "", "", "", "37.45639", "118.48556", "Asia/Shanghai"),
("1812228", "Dongtai", "", "CN", "156", "04", "", "", "", "32.85231", "120.30947", "Asia/Shanghai"),
("1812256", "Dongsheng", "", "CN", "156", "20", "", "", "", "39.81608", "109.97763", "Asia/Chongqing"),
("1812427", "Dongkan", "", "CN", "156", "04", "", "", "", "33.99972", "119.83083", "Asia/Shanghai"),
("1812521", "Donghai", "", "CN", "156", "30", "", "", "", "22.94594", "115.64204", "Asia/Shanghai"),
("1812545", "Dongguan", "Дунгуань", "CN", "156", "30", "", "", "", "23.04889", "113.74472", "Asia/Shanghai"),
("1812597", "Dongdu", "", "CN", "156", "25", "", "", "", "35.85", "117.7", "Asia/Shanghai"),
("1812621", "Dongcun", "", "CN", "156", "25", "", "", "", "36.77667", "121.15972", "Asia/Shanghai"),
("1812728", "Dingzhou", "", "CN", "156", "10", "", "", "", "38.51306", "114.99556", "Asia/Shanghai"),
("1812754", "Dingtao", "", "CN", "156", "25", "", "", "", "35.07436", "115.56582", "Asia/Shanghai"),
("1812955", "Dezhou", "Дэчжоу", "CN", "156", "25", "", "", "", "37.44861", "116.2925", "Asia/Shanghai"),
("1812961", "Deyang", "Дэян", "CN", "156", "32", "", "", "", "31.13019", "104.38198", "Asia/Chongqing"),
("1812981", "Deqing", "", "CN", "156", "02", "", "", "", "30.54485", "119.9599", "Asia/Shanghai"),
("1812988", "Dengzhou", "Пэнлай", "CN", "156", "25", "", "", "", "37.80822", "120.75908", "Asia/Shanghai"),
("1812990", "Dengzhou", "", "CN", "156", "09", "", "", "", "32.68222", "112.08194", "Asia/Shanghai"),
("1813016", "Dengfeng", "", "CN", "156", "09", "", "", "", "34.45528", "113.02806", "Asia/Shanghai"),
("1813088", "Dazhong", "", "CN", "156", "04", "", "", "", "33.19973", "120.4578", "Asia/Shanghai"),
("1813171", "Zhangjiajie", "Чжанцзяцзе", "CN", "156", "11", "", "", "", "29.12944", "110.47833", "Asia/Shanghai"),
("1813206", "Daye", "", "CN", "156", "12", "", "", "", "30.08333", "114.95", "Asia/Shanghai"),
("1813253", "Lijiang", "Лицзян", "CN", "156", "29", "", "", "", "26.86879", "100.22072", "Asia/Chongqing"),
("1813325", "Dazhou", "", "CN", "156", "32", "", "", "", "31.21592", "107.50092", "Asia/Chongqing"),
("1813344", "Dawukou", "", "CN", "156", "21", "", "", "", "39.04194", "106.39583", "Asia/Chongqing"),
("1813451", "Datong", "Датун", "CN", "156", "01", "", "", "", "32.62082", "117.06318", "Asia/Shanghai"),
("1813658", "Fenghua", "", "CN", "156", "02", "", "", "", "29.65628", "121.4064", "Asia/Shanghai"),
("1813775", "Huaxian", "", "CN", "156", "09", "", "", "", "35.56389", "114.50583", "Asia/Shanghai"),
("1813812", "Danshui", "Даньшуем", "CN", "156", "30", "", "", "", "22.7984", "114.46716", "Asia/Shanghai"),
("1813828", "Danjiangkou", "Даньцзянкоу", "CN", "156", "12", "", "", "", "32.54278", "111.50861", "Asia/Shanghai"),
("1813851", "Gushu", "", "CN", "156", "01", "", "", "", "31.56055", "118.48147", "Asia/Shanghai"),
("1813892", "Dancheng", "", "CN", "156", "09", "", "", "", "33.63333", "115.18333", "Asia/Shanghai"),
("1814082", "Daliang", "Далян", "CN", "156", "30", "", "", "", "22.84067", "113.2503", "Asia/Shanghai"),
("1814087", "Dalian", "Далянь", "CN", "156", "19", "1814068", "", "", "38.91222", "121.60222", "Asia/Shanghai"),
("1814093", "Dali", "Дали", "CN", "156", "29", "", "", "", "25.58474", "100.21229", "Asia/Chongqing"),
("1814757", "Chuzhou", "Чучжоу", "CN", "156", "01", "", "", "", "32.32194", "118.29778", "Asia/Shanghai"),
("1814786", "Yangchun", "", "CN", "156", "30", "", "", "", "22.16667", "111.78333", "Asia/Chongqing"),
("1814870", "Yiwu", "", "CN", "156", "02", "", "", "", "29.31506", "120.07676", "Asia/Shanghai"),
("1814906", "Chongqing", "Чунцин", "CN", "156", "33", "", "", "", "29.56278", "106.55278", "Asia/Chongqing"),
("1814919", "Chonglong", "", "CN", "156", "32", "", "", "", "29.78062", "104.85224", "Asia/Chongqing"),
("1814934", "Chizhou", "", "CN", "156", "01", "", "", "", "30.66134", "117.47783", "Asia/Shanghai"),
("1815059", "Chenzhou", "Чэньчжоу", "CN", "156", "11", "1815056", "", "", "25.8", "113.03333", "Asia/Shanghai"),
("1815184", "Chengyang", "", "CN", "156", "25", "", "", "", "35.57944", "118.83278", "Asia/Shanghai"),
("1815251", "Chengjiang", "", "CN", "156", "04", "", "", "", "31.91102", "120.26302", "Asia/Shanghai"),
("1815286", "Chengdu", "Чэнду", "CN", "156", "32", "", "", "", "30.66667", "104.06667", "Asia/Chongqing"),
("1815302", "Chenghua", "", "CN", "156", "30", "", "", "", "23.46132", "116.77007", "Asia/Shanghai"),
("1815395", "Chaozhou", "Чаочжоу", "CN", "156", "30", "", "", "", "23.65396", "116.62262", "Asia/Shanghai"),
("1815427", "Chaohu", "", "CN", "156", "01", "", "", "", "31.6", "117.86667", "Asia/Shanghai"),
("1815456", "Changzhou", "Чанчжоу", "CN", "156", "04", "", "", "", "31.77358", "119.95401", "Asia/Shanghai"),
("1815463", "Changzhi", "Чанчжи", "CN", "156", "24", "", "", "", "35.20889", "111.73861", "Asia/Shanghai"),
("1815577", "Changsha", "Чанша", "CN", "156", "11", "1815551", "", "", "28.19874", "112.97087", "Asia/Shanghai"),
("1815585", "Changqing", "Чанцин", "CN", "156", "25", "", "", "", "36.5575", "116.72722", "Asia/Shanghai"),
("1815656", "Changli", "Чанли", "CN", "156", "10", "", "", "", "39.70417", "119.15056", "Asia/Shanghai"),
("1815667", "Changleng", "", "CN", "156", "03", "", "", "", "28.7", "115.81667", "Asia/Shanghai"),
("1816026", "Caohe", "", "CN", "156", "12", "", "", "", "30.2297", "115.43346", "Asia/Shanghai"),
("1816028", "Weining", "Вэйнин", "CN", "156", "18", "", "", "", "26.85", "104.23333", "Asia/Chongqing"),
("1816080", "Cangzhou", "Цанчжоу", "CN", "156", "10", "", "", "", "38.31667", "116.86667", "Asia/Shanghai"),
("1816176", "Caidian", "", "CN", "156", "12", "", "", "", "30.58333", "114.03333", "Asia/Shanghai"),
("1816221", "Buhe", "Бухэ", "CN", "156", "12", "", "", "", "30.28757", "112.22979", "Asia/Shanghai"),
("1816234", "Bozhou", "Бочжоу", "CN", "156", "01", "", "", "", "33.87722", "115.77028", "Asia/Shanghai"),
("1816256", "Botou", "Бота", "CN", "156", "10", "", "", "", "38.06667", "116.56667", "Asia/Shanghai"),
("1816265", "Boshan", "", "CN", "156", "25", "", "", "", "36.48333", "117.83333", "Asia/Shanghai"),
("1816269", "Baise City", "Бозе", "CN", "156", "16", "", "", "", "23.89972", "106.61333", "Asia/Chongqing"),
("1816336", "Binzhou", "", "CN", "156", "25", "", "", "", "37.36667", "118.01667", "Asia/Shanghai"),
("1816338", "Luxu", "", "CN", "156", "16", "", "", "", "23.22378", "108.80216", "Asia/Chongqing"),
("1816373", "Bijie", "Бицзе", "CN", "156", "18", "", "", "", "27.30193", "105.28627", "Asia/Chongqing"),
("1816406", "Bianzhuang", "", "CN", "156", "25", "", "", "", "34.84861", "118.04472", "Asia/Shanghai"),
("1816440", "Bengbu", "Бэнбу", "CN", "156", "01", "", "", "", "32.94083", "117.36083", "Asia/Shanghai"),
("1816670", "Beijing", "Пекин", "CN", "156", "22", "", "", "", "39.9075", "116.39723", "Asia/Shanghai"),
("1816705", "Beihai", "Бэйхай", "CN", "156", "16", "", "", "", "21.48333", "109.1", "Asia/Chongqing"),
("1816751", "Beidao", "", "CN", "156", "15", "", "", "", "34.56861", "105.89333", "Asia/Chongqing"),
("1816753", "Beidaihehaibin", "Бейдайхэ", "CN", "156", "10", "", "", "", "39.82222", "119.51806", "Asia/Shanghai"),
("1816790", "Beibei", "Бэй", "CN", "156", "33", "", "", "", "29.82739", "106.43645", "Asia/Chongqing"),
("1816890", "Baoying", "", "CN", "156", "04", "", "", "", "33.22917", "119.30917", "Asia/Shanghai"),
("1816924", "Langzhong", "", "CN", "156", "32", "", "", "", "31.55037", "105.99381", "Asia/Chongqing"),
("1816971", "Baoding", "Баодин", "CN", "156", "10", "", "", "", "38.85111", "115.49028", "Asia/Shanghai"),
("1817240", "Baiyin", "", "CN", "156", "15", "", "", "", "36.54696", "104.17023", "Asia/Chongqing"),
("1817701", "Baihe", "", "CN", "156", "16", "", "", "", "22.15", "107.23333", "Asia/Chongqing"),
("1817720", "Shangyu", "", "CN", "156", "02", "", "", "", "30.01556", "120.87111", "Asia/Shanghai"),
("1817858", "Babu", "Бабу", "CN", "156", "16", "", "", "", "24.41667", "111.51667", "Asia/Chongqing"),
("1817952", "Anxiang", "", "CN", "156", "11", "", "", "", "29.4", "112.15", "Asia/Shanghai"),
("1817968", "Anshun", "Аньшунь", "CN", "156", "18", "", "", "", "26.25", "105.93333", "Asia/Chongqing"),
("1817990", "Anqiu", "", "CN", "156", "25", "", "", "", "36.43417", "119.1925", "Asia/Shanghai"),
("1817993", "Anqing", "Аньцин", "CN", "156", "01", "", "", "", "30.51365", "117.04723", "Asia/Shanghai"),
("1818004", "Mabai", "", "CN", "156", "29", "", "", "", "23.01279", "104.45081", "Asia/Chongqing"),
("1818016", "Anlu", "", "CN", "156", "12", "", "", "", "31.2575", "113.67833", "Asia/Shanghai"),
("1818051", "Anjiang", "", "CN", "156", "11", "", "", "", "27.31944", "110.10306", "Asia/Shanghai"),
("1818116", "Anbu", "", "CN", "156", "30", "", "", "", "23.44895", "116.68092", "Asia/Shanghai"),
("1885823", "Jiangyou", "", "CN", "156", "32", "", "", "", "31.76667", "104.71667", "Asia/Chongqing"),
("1886760", "Suzhou", "Сучжоу", "CN", "156", "04", "", "", "", "31.30408", "120.59538", "Asia/Shanghai"),
("1886762", "Zhoushan", "Чжоушань", "CN", "156", "02", "", "", "", "30.01075", "122.20465", "Asia/Shanghai"),
("1898359", "Mudu", "Муду", "CN", "156", "04", "", "", "", "31.25597", "120.51857", "Asia/Shanghai"),
("1898494", "Songling", "Сунлин", "CN", "156", "04", "", "", "", "31.1933", "120.71758", "Asia/Shanghai"),
("1915223", "Zhongshan", "", "CN", "156", "30", "", "", "", "21.31992", "110.5723", "Asia/Urumqi"),
("1919014", "Lianghu", "", "CN", "156", "02", "", "", "", "29.99152", "120.89845", "Asia/Shanghai"),
("1920772", "Zhoucheng", "", "CN", "156", "25", "", "", "", "35.91222", "116.31167", "Asia/Shanghai"),
("1921372", "Dalianwan", "", "CN", "156", "19", "", "", "", "39.02861", "121.695", "Asia/Shanghai"),
("1927639", "Yueyang", "Юэян", "CN", "156", "11", "", "", "", "29.37455", "113.09481", "Asia/Shanghai"),
("1929434", "Bojia", "", "CN", "156", "11", "", "", "", "26.46722", "111.96806", "Asia/Shanghai"),
("2033128", "Zhenlai", "", "CN", "156", "05", "", "", "", "45.84955", "123.2973", "Asia/Harbin"),
("2033135", "Zhengjiatun", "", "CN", "156", "05", "", "", "", "43.50639", "123.50639", "Asia/Harbin"),
("2033147", "Zhaozhou", "Чжаочжоу", "CN", "156", "08", "", "", "", "45.68333", "125.31667", "Asia/Harbin"),
("2033149", "Zhaoyuan", "", "CN", "156", "08", "", "", "", "45.5", "125.13333", "Asia/Harbin"),
("2033168", "Zhaodong", "", "CN", "156", "08", "", "", "", "46.06771", "125.98263", "Asia/Harbin"),
("2033196", "Zhangjiakou", "Чжанцзякоу", "CN", "156", "10", "", "", "", "40.81", "114.87944", "Asia/Shanghai"),
("2033225", "Zalantun", "Чжаланьтунь", "CN", "156", "20", "", "", "", "48", "122.71667", "Asia/Shanghai"),
("2033242", "Yushu", "Юйшу", "CN", "156", "05", "", "", "", "44.8", "126.53333", "Asia/Harbin"),
("2033301", "Youhao", "", "CN", "156", "08", "", "", "", "47.85306", "128.83565", "Asia/Harbin"),
("2033370", "Yingkou", "Инкоу", "CN", "156", "19", "2033369", "", "", "40.66482", "122.22833", "Asia/Shanghai"),
("2033403", "Yilan", "", "CN", "156", "08", "", "", "", "46.31618", "129.55455", "Asia/Harbin"),
("2033413", "Yichun", "Ичунь", "CN", "156", "08", "", "", "", "47.72143", "128.87529", "Asia/Harbin"),
("2033423", "Yebaishou", "", "CN", "156", "19", "", "", "", "41.3975", "119.64083", "Asia/Shanghai"),
("2033449", "Yantongshan", "", "CN", "156", "05", "", "", "", "43.29194", "126.00944", "Asia/Harbin"),
("2033467", "Yanji", "Яньцзи", "CN", "156", "05", "", "", "", "42.9075", "129.50778", "Asia/Harbin"),
("2033536", "Yakeshi", "Якэши", "CN", "156", "20", "", "", "", "49.28333", "120.73333", "Asia/Shanghai"),
("2033574", "Xuanhua", "", "CN", "156", "10", "", "", "", "40.61028", "115.04472", "Asia/Shanghai"),
("2033602", "Xiuyan", "", "CN", "156", "19", "", "", "", "40.29278", "123.27444", "Asia/Shanghai"),
("2033667", "Xinqing", "", "CN", "156", "08", "", "", "", "48.28701", "129.52337", "Asia/Harbin"),
("2033675", "Xinmin", "Синьминь", "CN", "156", "19", "", "", "", "41.99083", "122.82528", "Asia/Shanghai"),
("2033739", "Xinglongshan", "", "CN", "156", "05", "", "", "", "43.95611", "125.46611", "Asia/Harbin"),
("2033766", "Xingcheng", "Синчэн", "CN", "156", "19", "", "", "", "40.61667", "120.71667", "Asia/Shanghai"),
("2033824", "Xilin Hot", "", "CN", "156", "20", "", "", "", "43.96667", "116.03333", "Asia/Shanghai"),
("2033866", "Xifeng", "", "CN", "156", "19", "", "", "", "42.73722", "124.72222", "Asia/Shanghai"),
("2033934", "Xiaoshi", "", "CN", "156", "19", "", "", "", "41.29711", "124.12092", "Asia/Shanghai"),
("2034141", "Wuchang", "Учан", "CN", "156", "08", "", "", "", "44.91428", "127.15001", "Asia/Harbin"),
("2034221", "Wangqing", "Ванцине", "CN", "156", "05", "", "", "", "43.32179", "129.76342", "Asia/Harbin"),
("2034226", "Hepingjie", "", "CN", "156", "05", "", "", "", "42.05972", "126.91583", "Asia/Harbin"),
("2034228", "Wangkui", "", "CN", "156", "08", "", "", "", "46.83283", "126.47768", "Asia/Harbin"),
("2034312", "Ulanhot", "", "CN", "156", "20", "", "", "", "46.08333", "122.08333", "Asia/Shanghai"),
("2034340", "Tumen", "Тюменский", "CN", "156", "05", "", "", "", "42.96611", "129.8425", "Asia/Harbin"),
("2034400", "Tongliao", "", "CN", "156", "20", "", "", "", "43.6125", "122.26528", "Asia/Shanghai"),
("2034439", "Tieling", "Телин", "CN", "156", "19", "2034437", "", "", "42.29306", "123.84139", "Asia/Shanghai"),
("2034440", "Tieli", "", "CN", "156", "08", "", "", "", "46.98043", "128.04498", "Asia/Harbin"),
("2034497", "Guangming", "Таонань", "CN", "156", "05", "", "", "", "45.33333", "122.78333", "Asia/Harbin"),
("2034599", "Tailai", "", "CN", "156", "08", "", "", "", "46.38909", "123.41372", "Asia/Harbin"),
("2034600", "Taikang", "", "CN", "156", "08", "", "", "", "46.86135", "124.442", "Asia/Harbin"),
("2034615", "Tahe", "", "CN", "156", "08", "", "", "", "52.33333", "124.73333", "Asia/Harbin"),
("2034638", "Sujiatun", "Суцзятунь", "CN", "156", "19", "", "", "", "41.65917", "123.33917", "Asia/Shanghai"),
("2034651", "Suileng", "", "CN", "156", "08", "", "", "", "47.24805", "127.09535", "Asia/Harbin"),
("2034655", "Suihua", "", "CN", "156", "08", "", "", "", "46.63954", "126.99508", "Asia/Harbin"),
("2034657", "Suifenhe", "", "CN", "156", "08", "", "", "", "44.4", "131.16667", "Asia/Harbin"),
("2034691", "Songjianghe", "", "CN", "156", "05", "", "", "", "42.1859", "127.47895", "Asia/Harbin"),
("2034714", "Siping", "", "CN", "156", "05", "", "", "", "43.16143", "124.37785", "Asia/Harbin"),
("2034754", "Shunyi", "Шуньи", "CN", "156", "22", "", "", "", "40.12175", "116.64783", "Asia/Shanghai"),
("2034761", "Shulan", "Шулань", "CN", "156", "05", "", "", "", "44.41667", "126.95", "Asia/Harbin"),
("2034786", "Shuangyashan", "", "CN", "156", "08", "", "", "", "46.63611", "131.15389", "Asia/Harbin"),
("2034791", "Shuangyang", "", "CN", "156", "05", "", "", "", "43.52417", "125.67361", "Asia/Harbin"),
("2034834", "Shuangcheng", "", "CN", "156", "08", "", "", "", "45.35", "126.28333", "Asia/Harbin"),
("2034918", "Shiguai", "", "CN", "156", "20", "", "", "", "40.70583", "110.28556", "Asia/Chongqing"),
("2034937", "Shenyang", "Шэньян", "CN", "156", "19", "2034935", "", "", "41.79222", "123.43278", "Asia/Shanghai"),
("2034995", "Shanhetun", "", "CN", "156", "08", "", "", "", "44.7", "127.2", "Asia/Harbin"),
("2035002", "Shangzhi", "", "CN", "156", "08", "", "", "", "45.21406", "127.97426", "Asia/Harbin"),
("2035182", "Sanchazi", "", "CN", "156", "05", "", "", "", "42.08167", "126.60028", "Asia/Harbin"),
("2035196", "Salaqi", "", "CN", "156", "20", "", "", "", "40.54139", "110.51083", "Asia/Chongqing"),
("2035225", "Fendou", "", "CN", "156", "08", "", "", "", "46.64142", "124.86283", "Asia/Harbin"),
("2035261", "Taihe", "", "CN", "156", "08", "", "", "", "45.76195", "130.85131", "Asia/Harbin"),
("2035265", "Qiqihar", "Цицикар", "CN", "156", "08", "", "", "", "47.34088", "123.96045", "Asia/Harbin"),
("2035325", "Qinggang", "", "CN", "156", "08", "", "", "", "46.68469", "126.10595", "Asia/Harbin"),
("2035399", "Qianguo", "", "CN", "156", "05", "", "", "", "45.11712", "124.85676", "Asia/Harbin"),
("2035453", "Pingzhuang", "", "CN", "156", "20", "", "", "", "42.03722", "119.28889", "Asia/Shanghai"),
("2035511", "Panshi", "Паньши", "CN", "156", "05", "", "", "", "42.94222", "126.05611", "Asia/Harbin"),
("2035513", "Panshan", "", "CN", "156", "19", "", "", "", "41.18806", "122.04944", "Asia/Shanghai"),
("2035593", "Nianzishan", "", "CN", "156", "08", "", "", "", "47.51667", "122.88333", "Asia/Harbin"),
("2035601", "Nenjiang", "", "CN", "156", "08", "", "", "", "49.17414", "125.21774", "Asia/Harbin"),
("2035610", "Nehe", "Нэхэ", "CN", "156", "08", "", "", "", "48.48333", "124.83333", "Asia/Harbin"),
("2035635", "Nantai", "", "CN", "156", "19", "", "", "", "40.9241", "122.80437", "Asia/Shanghai"),
("2035644", "Nanpiao", "", "CN", "156", "19", "", "", "", "41.09822", "120.74792", "Asia/Shanghai"),
("2035669", "Lianhe", "", "CN", "156", "08", "", "", "", "47.13333", "129.27426", "Asia/Harbin"),
("2035707", "Mujiayingzi", "", "CN", "156", "20", "", "", "", "42.11667", "118.78333", "Asia/Shanghai"),
("2035715", "Mudanjiang", "Муданьцзян", "CN", "156", "08", "", "", "", "44.58333", "129.6", "Asia/Harbin"),
("2035746", "Mishan", "Мишань", "CN", "156", "08", "", "", "", "45.55", "131.88333", "Asia/Harbin"),
("2035754", "Mingyue", "", "CN", "156", "05", "", "", "", "43.10694", "128.92167", "Asia/Harbin"),
("2035758", "Mingshui", "", "CN", "156", "08", "", "", "", "47.1815", "125.90027", "Asia/Harbin"),
("2035801", "Meihekou", "", "CN", "156", "05", "", "", "", "42.52722", "125.67528", "Asia/Harbin"),
("2035836", "Manzhouli", "Маньчжурия", "CN", "156", "20", "", "", "", "49.6", "117.43333", "Asia/Shanghai"),
("2035966", "Longjing", "", "CN", "156", "05", "", "", "", "42.77139", "129.42333", "Asia/Harbin"),
("2035970", "Longjiang", "Лонцзян", "CN", "156", "08", "", "", "", "47.33072", "123.17816", "Asia/Harbin"),
("2035980", "Longfeng", "", "CN", "156", "08", "", "", "", "46.53168", "125.1038", "Asia/Harbin"),
("2036033", "Liuhe", "Люхэ", "CN", "156", "05", "", "", "", "42.24007", "125.71717", "Asia/Harbin"),
("2036055", "Lishu", "Лишать", "CN", "156", "05", "", "", "", "43.30472", "124.32778", "Asia/Harbin"),
("2036066", "Linkou", "", "CN", "156", "08", "", "", "", "45.28606", "130.26151", "Asia/Harbin"),
("2036069", "Linjiang", "Линьцзяне", "CN", "156", "05", "", "", "", "41.80694", "126.90778", "Asia/Harbin"),
("2036075", "Lingyuan", "", "CN", "156", "19", "", "", "", "41.24", "119.40111", "Asia/Shanghai"),
("2036081", "Lingdong", "", "CN", "156", "08", "", "", "", "46.56694", "131.14528", "Asia/Harbin"),
("2036106", "Liaozhong", "", "CN", "156", "19", "", "", "", "41.50611", "122.72417", "Asia/Shanghai"),
("2036109", "Liaoyuan", "", "CN", "156", "05", "", "", "", "42.90361", "125.13583", "Asia/Harbin"),
("2036113", "Liaoyang", "Ляоян", "CN", "156", "19", "", "", "", "41.27194", "123.17306", "Asia/Shanghai"),
("2036226", "Lanxi", "", "CN", "156", "08", "", "", "", "46.25785", "126.28269", "Asia/Harbin"),
("2036237", "Langxiang", "", "CN", "156", "08", "", "", "", "46.94985", "128.86849", "Asia/Harbin"),
("2036241", "Langtou", "", "CN", "156", "19", "", "", "", "40.02611", "124.32861", "Asia/Shanghai"),
("2036283", "Kuandian", "", "CN", "156", "19", "", "", "", "40.72861", "124.78472", "Asia/Shanghai"),
("2036337", "Kaiyuan", "Кайюань", "CN", "156", "19", "", "", "", "42.53306", "124.04028", "Asia/Shanghai"),
("2036338", "Kaitong", "", "CN", "156", "05", "", "", "", "44.81351", "123.15", "Asia/Harbin"),
("2036389", "Jixi", "Цзиси", "CN", "156", "08", "", "", "", "45.3011", "130.95718", "Asia/Harbin"),
("2036401", "Jiutai", "", "CN", "156", "05", "", "", "", "44.1525", "125.83278", "Asia/Harbin"),
("2036403", "Jiupu", "", "CN", "156", "19", "2038630", "", "", "41.06667", "122.95", "Asia/Shanghai"),
("2036418", "Jishu", "", "CN", "156", "05", "", "", "", "44.31667", "126.8", "Asia/Harbin"),
("2036427", "Jinzhou", "Цзиньчжоу", "CN", "156", "19", "", "", "", "41.10778", "121.14167", "Asia/Shanghai"),
("2036434", "Lianshan", "", "CN", "156", "19", "", "", "", "40.76432", "120.85327", "Asia/Shanghai"),
("2036458", "Jining", "Цзинин", "CN", "156", "20", "", "", "", "41.0275", "113.10583", "Asia/Chongqing"),
("2036502", "Jilin", "Цзилинь", "CN", "156", "05", "", "", "", "43.85083", "126.56028", "Asia/Harbin"),
("2036519", "Jidong", "", "CN", "156", "08", "", "", "", "45.21667", "131.08333", "Asia/Harbin"),
("2036536", "Minzhu", "Цзяохэ", "CN", "156", "05", "", "", "", "43.72144", "127.33402", "Asia/Harbin"),
("2036581", "Jiamusi", "Цзямусы", "CN", "156", "08", "", "", "", "46.79927", "130.31633", "Asia/Harbin"),
("2036595", "Jalai Nur", "Чжалайнор", "CN", "156", "20", "", "", "", "49.45", "117.7", "Asia/Shanghai"),
("2036597", "Jagdaqi", "", "CN", "156", "20", "", "", "", "50.41667", "124.11667", "Asia/Shanghai"),
("2036619", "Hushitai", "", "CN", "156", "19", "", "", "", "41.93222", "123.51139", "Asia/Shanghai"),
("2036653", "Hunchun", "Хуньчунь", "CN", "156", "05", "", "", "", "42.8675", "130.35806", "Asia/Harbin"),
("2036670", "Hulan Ergi", "", "CN", "156", "08", "", "", "", "47.20417", "123.63333", "Asia/Harbin"),
("2036671", "Hulan", "Хулан", "CN", "156", "08", "", "", "", "45.98333", "126.6", "Asia/Harbin"),
("2036685", "Huinan", "", "CN", "156", "05", "", "", "", "42.6225", "126.26139", "Asia/Harbin"),
("2036713", "Huanren", "", "CN", "156", "19", "", "", "", "41.26472", "125.36667", "Asia/Shanghai"),
("2036734", "Huangnihe", "", "CN", "156", "05", "", "", "", "43.55833", "128.02389", "Asia/Harbin"),
("2036753", "Huanan", "", "CN", "156", "08", "", "", "", "46.2207", "130.525", "Asia/Harbin"),
("2036776", "Huadian", "", "CN", "156", "05", "", "", "", "42.96333", "126.74778", "Asia/Harbin"),
("2036876", "Honggang", "", "CN", "156", "08", "", "", "", "46.40124", "124.88322", "Asia/Harbin"),
("2036892", "Hohhot", "Хух-Хото", "CN", "156", "20", "", "", "", "40.81056", "111.65222", "Asia/Chongqing"),
("2036920", "Fendou", "", "CN", "156", "08", "", "", "", "45.21235", "130.90254", "Asia/Harbin"),
("2036933", "Helong", "Хэлуне", "CN", "156", "05", "", "", "", "42.53974", "128.99722", "Asia/Harbin"),
("2036959", "Heishan", "", "CN", "156", "19", "", "", "", "41.68917", "122.11278", "Asia/Shanghai"),
("2036973", "Heihe", "Хэйхэ", "CN", "156", "08", "", "", "", "50.24413", "127.49016", "Asia/Harbin"),
("2036986", "Hegang", "Хэган", "CN", "156", "08", "", "", "", "47.35118", "130.30012", "Asia/Harbin"),
("2037013", "Harbin", "Харбин", "CN", "156", "08", "", "", "", "45.75", "126.65", "Asia/Harbin"),
("2037069", "Hailun", "", "CN", "156", "08", "", "", "", "47.4565", "126.95368", "Asia/Harbin"),
("2037075", "Hailin", "Хайлин", "CN", "156", "08", "", "", "", "44.57149", "129.38539", "Asia/Harbin"),
("2037078", "Hailar", "Хайлар", "CN", "156", "20", "", "", "", "49.2", "119.7", "Asia/Shanghai"),
("2037086", "Haicheng", "", "CN", "156", "19", "", "", "", "40.85158", "122.74754", "Asia/Shanghai"),
("2037222", "Gongzhuling", "Гунчжулина", "CN", "156", "05", "", "", "", "43.50075", "124.81979", "Asia/Harbin"),
("2037240", "Gongchangling", "", "CN", "156", "19", "", "", "", "41.11667", "123.45", "Asia/Shanghai"),
("2037252", "Genhe", "", "CN", "156", "20", "", "", "", "50.78333", "121.51667", "Asia/Shanghai"),
("2037311", "Gannan", "", "CN", "156", "08", "", "", "", "47.91472", "123.50306", "Asia/Harbin"),
("2037330", "Fuyuan", "Фуюань", "CN", "156", "08", "", "", "", "48.36306", "134.28917", "Asia/Harbin"),
("2037334", "Fuyu", "", "CN", "156", "08", "", "", "", "47.79756", "124.45731", "Asia/Harbin"),
("2037335", "Fuyu", "", "CN", "156", "05", "", "", "", "45.18333", "124.81667", "Asia/Harbin"),
("2037345", "Fuxin", "Фусинь", "CN", "156", "19", "", "", "", "42.05889", "121.745", "Asia/Shanghai"),
("2037346", "Fuxin", "Фусинь", "CN", "156", "19", "", "", "", "42.01556", "121.65889", "Asia/Shanghai"),
("2037355", "Fushun", "Фушунь", "CN", "156", "19", "", "", "", "41.85583", "123.92333", "Asia/Shanghai"),
("2037370", "Fuli", "Фули", "CN", "156", "08", "", "", "", "46.72167", "131.13944", "Asia/Harbin"),
("2037375", "Fujin", "Фуцзинь", "CN", "156", "08", "", "", "", "47.26", "132.03222", "Asia/Harbin"),
("2037391", "Beichengqu", "", "CN", "156", "20", "", "", "", "40.43944", "113.15361", "Asia/Chongqing"),
("2037393", "Fengxiang", "Фенгсианг", "CN", "156", "08", "", "", "", "47.57549", "130.82306", "Asia/Harbin"),
("2037411", "Fengcheng", "", "CN", "156", "19", "", "", "", "40.45361", "124.07167", "Asia/Shanghai"),
("2037485", "Erenhot", "", "CN", "156", "20", "", "", "", "43.6475", "111.97667", "Asia/Shanghai"),
("2037494", "Erdaojiang", "", "CN", "156", "05", "", "", "", "41.77639", "126.03194", "Asia/Harbin"),
("2037534", "Dunhua", "Дуньхуа", "CN", "156", "05", "", "", "", "43.3725", "128.2425", "Asia/Harbin"),
("2037611", "Dongning", "", "CN", "156", "08", "", "", "", "44.06219", "131.12075", "Asia/Harbin"),
("2037620", "Dongling", "Донлин", "CN", "156", "19", "", "", "", "41.81444", "123.57583", "Asia/Shanghai"),
("2037658", "Dongfeng", "", "CN", "156", "05", "", "", "", "42.64031", "125.51176", "Asia/Harbin"),
("2037685", "Dongxing", "", "CN", "156", "08", "", "", "", "45.36088", "130.78679", "Asia/Harbin"),
("2037712", "Dehui", "", "CN", "156", "05", "", "", "", "44.53333", "125.7", "Asia/Harbin"),
("2037799", "Datong", "Датун", "CN", "156", "24", "", "", "", "40.09361", "113.29139", "Asia/Shanghai"),
("2037820", "Dashitou", "", "CN", "156", "05", "", "", "", "43.30667", "128.51139", "Asia/Harbin"),
("2037823", "Dashiqiao", "", "CN", "156", "19", "", "", "", "40.63732", "122.50251", "Asia/Shanghai"),
("2037860", "Daqing", "Дацин", "CN", "156", "08", "", "", "", "46.58333", "125", "Asia/Harbin"),
("2037886", "Dandong", "Даньдун", "CN", "156", "19", "", "", "", "40.12917", "124.39472", "Asia/Shanghai"),
("2037913", "Linghai", "", "CN", "156", "19", "", "", "", "41.16528", "121.36667", "Asia/Shanghai"),
("2037930", "Dalai", "", "CN", "156", "05", "", "", "", "45.5", "124.3", "Asia/Harbin"),
("2038067", "Chifeng", "Чифэн", "CN", "156", "20", "", "", "", "42.26833", "118.96361", "Asia/Shanghai"),
("2038080", "Chengzihe", "", "CN", "156", "08", "", "", "", "45.33333", "131.06667", "Asia/Harbin"),
("2038087", "Chengde", "Чэндэ", "CN", "156", "10", "", "", "", "40.9725", "117.93611", "Asia/Shanghai"),
("2038118", "Chaoyang", "Чаоян", "CN", "156", "05", "", "", "", "42.66223", "126.0263", "Asia/Harbin"),
("2038120", "Chaoyang", "Чаоян", "CN", "156", "19", "", "", "", "41.57028", "120.45861", "Asia/Shanghai"),
("2038139", "Changtu", "Чанту", "CN", "156", "19", "", "", "", "42.77884", "124.09545", "Asia/Shanghai"),
("2038154", "Changping", "Чанпин", "CN", "156", "22", "", "", "", "40.21612", "116.23471", "Asia/Shanghai"),
("2038158", "Changling", "", "CN", "156", "05", "", "", "", "44.26532", "124.00045", "Asia/Harbin"),
("2038180", "Changchun", "Чанчунь", "CN", "156", "05", "2038176", "", "", "43.88", "125.32278", "Asia/Harbin"),
("2038198", "Chaihe", "", "CN", "156", "08", "", "", "", "44.7598", "129.67826", "Asia/Harbin"),
("2038274", "Boli", "Боли", "CN", "156", "08", "", "", "", "45.75279", "130.57211", "Asia/Harbin"),
("2038283", "Binzhou", "", "CN", "156", "08", "", "", "", "45.75281", "127.47986", "Asia/Harbin"),
("2038300", "Benxi", "Бэньси", "CN", "156", "19", "", "", "", "41.28861", "123.765", "Asia/Shanghai"),
("2038342", "Beipiao", "", "CN", "156", "19", "", "", "", "41.79194", "120.77917", "Asia/Shanghai"),
("2038365", "Bei'an", "", "CN", "156", "08", "", "", "", "48.26667", "126.6", "Asia/Harbin"),
("2038421", "Bayan", "Баян", "CN", "156", "08", "", "", "", "46.07556", "127.3984", "Asia/Harbin"),
("2038432", "Baotou", "Баотоу", "CN", "156", "20", "", "", "", "40.65222", "109.82222", "Asia/Chongqing"),
("2038438", "Baoshan", "Баошань", "CN", "156", "08", "", "", "", "46.55861", "131.42444", "Asia/Harbin"),
("2038446", "Baoqing", "Баоцин", "CN", "156", "08", "", "", "", "46.33167", "132.21111", "Asia/Harbin"),
("2038482", "Bamiantong", "", "CN", "156", "08", "", "", "", "44.91738", "130.52", "Asia/Harbin"),
("2038529", "Baishishan", "", "CN", "156", "05", "", "", "", "43.58333", "127.56667", "Asia/Harbin"),
("2038541", "Baiquan", "", "CN", "156", "08", "", "", "", "47.60605", "126.08481", "Asia/Harbin"),
("2038569", "Baicheng", "Байчен", "CN", "156", "05", "", "", "", "45.60746", "122.82076", "Asia/Harbin"),
("2038584", "Baishan", "Байшань", "CN", "156", "05", "", "", "", "41.93853", "126.41965", "Asia/Harbin"),
("2038632", "Anshan", "Аньшань", "CN", "156", "19", "2038630", "", "", "41.12361", "122.99", "Asia/Shanghai"),
("2038650", "Anda", "Анда", "CN", "156", "08", "", "", "", "46.40202", "125.31454", "Asia/Harbin"),
("2038665", "Oroqen Zizhiqi", "Алихэ", "CN", "156", "20", "", "", "", "50.56667", "123.71667", "Asia/Shanghai"),
("2038679", "Acheng", "Ахенг", "CN", "156", "08", "", "", "", "45.54545", "126.97703", "Asia/Harbin"),
("2047837", "Songling", "", "CN", "156", "10", "", "", "", "40.30806", "118.27056", "Asia/Shanghai"),
("6825277", "Shilin", "Шилин", "CN", "156", "29", "", "", "", "24.81878", "103.33237", "Asia/Chongqing"),
("7283386", "Changshu City", "", "CN", "156", "04", "", "", "", "31.64615", "120.74221", "Asia/Shanghai"),
("7290013", "Shixing", "", "CN", "156", "30", "", "", "", "24.94824", "114.06572", "Asia/Shanghai"),
("7303248", "Jiashan", "", "CN", "156", "02", "", "", "", "30.84918", "120.92583", "Asia/Shanghai"),
("7304020", "Fenghuang", "Фенхуань", "CN", "156", "11", "", "", "", "27.93557", "109.59961", "Asia/Shanghai"),
("7602670", "Zhu Cheng City", "", "CN", "156", "25", "", "", "", "35.99502", "119.40259", "Asia/Shanghai"),
("7910932", "Shangri-La", "Шангри-Ла", "CN", "156", "29", "1281365", "", "", "27.82511", "99.70779", "Asia/Chongqing"),
("8347664", "Ordos", "Ордос", "CN", "156", "20", "", "", "", "39.6086", "109.78157", "Asia/Chongqing"),
("8505006", "Wenshan City", "", "CN", "156", "29", "1791424", "", "", "23.36306", "104.25047", "Asia/Chongqing"),
("8533133", "Liupanshui", "", "CN", "156", "18", "", "", "", "26.59444", "104.83333", "Asia/Chongqing"),
("3533753", "Yara", "", "CU", "192", "09", "", "", "", "20.2733", "-76.95399", "America/Havana"),
("3533826", "Yaguajay", "", "CU", "192", "14", "", "", "", "22.32722", "-79.23778", "America/Havana"),
("3534094", "Vinales", "Виньялес", "CU", "192", "01", "", "", "", "22.61243", "-83.71136", "America/Havana"),
("3534363", "Vertientes", "", "CU", "192", "05", "", "", "", "21.25528", "-78.15338", "America/Havana"),
("3534432", "Venezuela", "", "CU", "192", "07", "", "", "", "21.73528", "-78.79639", "America/Havana"),
("3534632", "Varadero", "Варадеро", "CU", "192", "03", "", "", "", "23.15678", "-81.24441", "America/Havana"),
("3534749", "Urbano Noris", "", "CU", "192", "12", "", "", "", "20.60101", "-76.13188", "America/Havana"),
("3534761", "Union de Reyes", "", "CU", "192", "03", "", "", "", "22.79528", "-81.5375", "America/Havana"),
("3534915", "Trinidad", "Тринидад", "CU", "192", "14", "", "", "", "21.80194", "-79.98417", "America/Havana"),
("3536259", "Sibanicu", "", "CU", "192", "05", "", "", "", "21.235", "-77.52639", "America/Havana"),
("3536640", "Santo Domingo", "", "CU", "192", "16", "", "", "", "22.58667", "-80.24361", "America/Havana"),
("3536724", "Santiago de las Vegas", "Сантьяго-де-лас-Вегас", "CU", "192", "02", "", "", "", "22.97", "-82.38694", "America/Havana"),
("3536729", "Santiago de Cuba", "Сантьяго-де-Куба", "CU", "192", "15", "3536726", "", "", "20.02472", "-75.82194", "America/Havana"),
("3537840", "Santa Cruz del Sur", "", "CU", "192", "05", "", "", "", "20.71176", "-77.9986", "America/Havana"),
("3537845", "Santa Cruz del Norte", "", "CU", "192", "MA", "", "", "", "23.15374", "-81.92611", "America/Havana"),
("3537906", "Santa Clara", "Санта Клара", "CU", "192", "16", "", "", "", "22.4", "-79.96667", "America/Havana"),
("3538803", "San Miguel del Padron", "", "CU", "192", "02", "", "", "", "23.06639", "-82.29472", "America/Havana"),
("3539093", "San Luis", "", "CU", "192", "15", "", "", "", "20.1875", "-75.85083", "America/Havana"),
("3539560", "San Jose de las Lajas", "", "CU", "192", "MA", "", "", "", "22.96139", "-82.15111", "America/Havana"),
("3540667", "Sancti Spiritus", "Санкти-Спиритус", "CU", "192", "14", "", "", "", "21.92972", "-79.4425", "America/Havana"),
("3540680", "San Cristobal", "", "CU", "192", "AR", "", "", "", "22.71417", "-83.04806", "America/Havana"),
("3540885", "San Antonio de los Banos", "", "CU", "192", "AR", "", "", "", "22.89111", "-82.49917", "America/Havana"),
("3541440", "Sagua la Grande", "", "CU", "192", "16", "", "", "", "22.80667", "-80.07556", "America/Havana"),
("3541446", "Sagua de Tanamo", "", "CU", "192", "12", "", "", "", "20.58194", "-75.24139", "America/Havana"),
("3541999", "Rodas", "Родас", "CU", "192", "08", "", "", "", "22.33794", "-80.55538", "America/Havana"),
("3542137", "Rio Guayabal de Yateras", "", "CU", "192", "10", "", "", "", "20.36667", "-75.01667", "America/Havana"),
("3542167", "Rio Cauto", "", "CU", "192", "09", "", "", "", "20.56284", "-76.92122", "America/Havana"),
("3542455", "Remedios", "Ремедиос", "CU", "192", "16", "", "", "", "22.49303", "-79.54488", "America/Havana"),
("3542502", "Regla", "", "CU", "192", "02", "", "", "", "23.125", "-82.33194", "America/Havana"),
("3542744", "Ranchuelo", "", "CU", "192", "16", "", "", "", "22.37485", "-80.14983", "America/Havana"),
("3543299", "Puerto Padre", "Пуэрто-Падре", "CU", "192", "13", "", "", "", "21.19449", "-76.60355", "America/Havana"),
("3543498", "Primero de Enero", "", "CU", "192", "07", "", "", "", "21.94694", "-78.42833", "America/Havana"),
("3543961", "Placetas", "", "CU", "192", "16", "", "", "", "22.31194", "-79.65333", "America/Havana"),
("3544091", "Pinar del Rio", "Пинар-дель-Рио", "CU", "192", "01", "3544089", "", "", "22.4175", "-83.69806", "America/Havana"),
("3544393", "Perico", "", "CU", "192", "03", "", "", "", "22.76917", "-81.01889", "America/Havana"),
("3544607", "Pedro Betancourt", "", "CU", "192", "03", "", "", "", "22.72467", "-81.28852", "America/Havana"),
("3545040", "Palmira", "", "CU", "192", "08", "", "", "", "22.24167", "-80.39028", "America/Havana"),
("3545064", "Palma Soriano", "", "CU", "192", "15", "", "", "", "20.21238", "-75.99843", "America/Havana"),
("3545841", "Nuevitas", "", "CU", "192", "05", "", "", "", "21.54528", "-77.26444", "America/Havana"),
("3545867", "Nueva Gerona", "Нуэва-Херона", "CU", "192", "04", "", "", "", "21.88333", "-82.8", "America/Havana"),
("3545981", "Niquero", "", "CU", "192", "09", "", "", "", "20.04478", "-77.5851", "America/Havana"),
("3546434", "Moron", "Морон", "CU", "192", "07", "", "", "", "22.10944", "-78.6275", "America/Havana"),
("3546791", "Moa", "Моа", "CU", "192", "12", "", "", "", "20.65694", "-74.94028", "America/Havana"),
("3546882", "Minas de Matahambre", "", "CU", "192", "01", "", "", "", "22.5875", "-83.945", "America/Havana"),
("3546894", "Minas", "Минас", "CU", "192", "05", "", "", "", "21.48833", "-77.61832", "America/Havana"),
("3547260", "Media Luna", "", "CU", "192", "09", "", "", "", "20.14001", "-77.43658", "America/Havana"),
("3547398", "Matanzas", "Матанзас", "CU", "192", "03", "", "", "", "23.04111", "-81.5775", "America/Havana"),
("3547600", "Mariel", "", "CU", "192", "AR", "", "", "", "22.9875", "-82.75361", "America/Havana"),
("3547867", "Manzanillo", "Мансанильо", "CU", "192", "09", "", "", "", "20.34333", "-77.11667", "America/Havana"),
("3547976", "Manicaragua", "", "CU", "192", "16", "", "", "", "22.14944", "-79.97361", "America/Havana"),
("3548441", "Maisi", "", "CU", "192", "10", "", "", "", "20.24673", "-74.15181", "America/Havana"),
("3548529", "Madruga", "", "CU", "192", "MA", "", "", "", "22.91139", "-81.85611", "America/Havana"),
("3548993", "Los Palacios", "", "CU", "192", "01", "", "", "", "22.58722", "-83.24861", "America/Havana"),
("3550598", "Las Tunas", "Лас-Тунас", "CU", "192", "13", "", "", "", "20.96167", "-76.95111", "America/Havana"),
("3551184", "La Sierpe", "", "CU", "192", "14", "", "", "", "21.75722", "-79.24306", "America/Havana"),
("3551608", "La Salud", "Ла Салюд", "CU", "192", "MA", "", "", "", "22.86991", "-82.42193", "America/Havana"),
("3553478", "Havana", "Гавана", "CU", "192", "02", "", "", "", "23.13302", "-82.38304", "America/Havana"),
("3555907", "Jovellanos", "", "CU", "192", "03", "", "", "", "22.80444", "-81.19444", "America/Havana"),
("3556077", "Jobabo", "", "CU", "192", "12", "", "", "", "20.96917", "-76.29944", "America/Havana"),
("3556078", "Jobabo", "", "CU", "192", "13", "", "", "", "20.90508", "-77.28819", "America/Havana"),
("3556168", "Jiguani", "", "CU", "192", "09", "", "", "", "20.36667", "-76.42722", "America/Havana"),
("3556268", "Jesus Menendez", "", "CU", "192", "13", "", "", "", "21.16", "-76.47889", "America/Havana"),
("3556334", "Jatibonico", "", "CU", "192", "14", "", "", "", "21.941", "-79.17484", "America/Havana"),
("3556351", "Jaruco", "", "CU", "192", "MA", "", "", "", "23.04306", "-82.01083", "America/Havana"),
("3556437", "Jaguey Grande", "", "CU", "192", "03", "", "", "", "22.52694", "-81.12861", "America/Havana"),
("3556969", "Holguin", "Ольгин", "CU", "192", "12", "3556966", "", "", "20.88722", "-76.26306", "America/Havana"),
("3557332", "Guisa", "", "CU", "192", "09", "", "", "", "20.25101", "-76.54152", "America/Havana"),
("3557347", "Guira de Melena", "", "CU", "192", "AR", "", "", "", "22.79274", "-82.50823", "America/Havana"),
("3557378", "Gueines", "Гуинес", "CU", "192", "11", "", "", "", "22.83611", "-82.02806", "America/Havana"),
("3557689", "Guantanamo", "Гуантанамо", "CU", "192", "10", "3557686", "", "", "20.14444", "-75.20917", "America/Havana"),
("3557758", "Guane", "", "CU", "192", "01", "", "", "", "22.2025", "-84.0875", "America/Havana"),
("3557801", "Guanajay", "", "CU", "192", "AR", "", "", "", "22.92639", "-82.6875", "America/Havana"),
("3557846", "Guanabacoa", "", "CU", "192", "02", "", "", "", "23.12389", "-82.30028", "America/Havana"),
("3557923", "Guaimaro", "", "CU", "192", "05", "", "", "", "21.05176", "-77.35021", "America/Havana"),
("3558315", "Gibara", "", "CU", "192", "12", "", "", "", "21.10972", "-76.13167", "America/Havana"),
("3558744", "Fomento", "", "CU", "192", "14", "", "", "", "22.1001", "-79.71913", "America/Havana"),
("3558771", "Florida", "Флорида", "CU", "192", "05", "", "", "", "21.52472", "-78.22583", "America/Havana"),
("3558792", "Florencia", "", "CU", "192", "07", "", "", "", "22.14518", "-78.97764", "America/Havana"),
("3559318", "Esmeralda", "Эсмеральда", "CU", "192", "05", "", "", "", "21.85155", "-78.12005", "America/Havana"),
("3559416", "Encrucijada", "", "CU", "192", "16", "", "", "", "22.61611", "-79.86458", "America/Havana"),
("3562827", "Cumanayagua", "", "CU", "192", "08", "", "", "", "22.14944", "-80.20222", "America/Havana"),
("3562895", "Cueto", "", "CU", "192", "12", "", "", "", "20.64511", "-75.9402", "America/Havana"),
("3563145", "Cruces", "Крусес", "CU", "192", "08", "", "", "", "22.34175", "-80.27028", "America/Havana"),
("3563317", "Corralillo", "", "CU", "192", "16", "", "", "", "22.98194", "-80.58556", "America/Havana"),
("3563504", "Contramaestre", "", "CU", "192", "15", "", "", "", "20.29778", "-76.24139", "America/Havana"),
("3563559", "Consolacion del Sur", "", "CU", "192", "01", "", "", "", "22.50528", "-83.51095", "America/Havana"),
("3563609", "Condado", "Кондадо", "CU", "192", "14", "", "", "", "21.87667", "-79.84028", "America/Havana"),
("3563843", "Colon", "", "CU", "192", "03", "", "", "", "22.71917", "-80.90583", "America/Havana"),
("3563856", "Colombia", "", "CU", "192", "13", "", "", "", "20.98806", "-77.42972", "America/Havana"),
("3564084", "Ciro Redondo", "", "CU", "192", "07", "", "", "", "22.01222", "-78.705", "America/Havana"),
("3564114", "Cifuentes", "", "CU", "192", "16", "", "", "", "22.645", "-80.04611", "America/Havana"),
("3564124", "Cienfuegos", "Сьенфуэгос", "CU", "192", "08", "3564121", "", "", "22.14957", "-80.44662", "America/Havana"),
("3564178", "Ciego de Avila", "", "CU", "192", "07", "", "", "", "21.84", "-78.76194", "America/Havana"),
("3564394", "Chambas", "", "CU", "192", "07", "", "", "", "22.18736", "-78.91569", "America/Havana"),
("3564436", "Cerro", "", "CU", "192", "02", "", "", "", "23.10861", "-82.37778", "America/Havana"),
("3564885", "Cauto Cristo", "", "CU", "192", "09", "", "", "", "20.55639", "-76.47444", "America/Havana"),
("3565432", "Cardenas", "Карденас", "CU", "192", "03", "", "", "", "23.0375", "-81.20472", "America/Havana"),
("3565951", "Campechuela", "", "CU", "192", "09", "", "", "", "20.23417", "-77.27889", "America/Havana"),
("3566054", "Camajuani", "", "CU", "192", "16", "", "", "", "22.48333", "-79.75", "America/Havana"),
("3566067", "Camaguey", "Камагуэй", "CU", "192", "05", "", "", "", "21.38083", "-77.91694", "America/Havana"),
("3566134", "Calimete", "", "CU", "192", "03", "", "", "", "22.53166", "-80.9045", "America/Havana"),
("3566356", "Caibarien", "", "CU", "192", "16", "", "", "", "22.52056", "-79.46694", "America/Havana"),
("3566429", "Cacocum", "", "CU", "192", "12", "", "", "", "20.73668", "-76.32646", "America/Havana"),
("3566603", "Cabaiguan", "", "CU", "192", "14", "", "", "", "22.07889", "-79.49917", "America/Havana"),
("3567546", "Bejucal", "", "CU", "192", "MA", "", "", "", "22.92861", "-82.38861", "America/Havana"),
("3567597", "Bayamo", "Баямо", "CU", "192", "09", "", "", "", "20.37917", "-76.64333", "America/Havana"),
("3567612", "Bauta", "", "CU", "192", "AR", "", "", "", "22.98278", "-82.54639", "America/Havana"),
("3567669", "Bartolome Maso", "", "CU", "192", "09", "", "", "", "20.16303", "-76.94443", "America/Havana"),
("3567823", "Baragua", "", "CU", "192", "07", "", "", "", "21.6883", "-78.63606", "America/Havana"),
("3567834", "Baracoa", "", "CU", "192", "10", "", "", "", "20.34659", "-74.49675", "America/Havana"),
("3567869", "Banes", "", "CU", "192", "12", "", "", "", "20.9625", "-75.71861", "America/Havana"),
("3567995", "Bahia Honda", "", "CU", "192", "AR", "", "", "", "22.90361", "-83.15917", "America/Havana"),
("3568312", "Artemisa", "Артемиса", "CU", "192", "AR", "", "", "", "22.81306", "-82.76194", "America/Havana"),
("3568342", "Arroyo Naranjo", "", "CU", "192", "02", "", "", "", "23.03611", "-82.37167", "America/Havana"),
("3569024", "Amancio", "", "CU", "192", "13", "", "", "", "20.8225", "-77.57861", "America/Havana"),
("3569136", "Alquizar", "", "CU", "192", "AR", "", "", "", "22.80583", "-82.58417", "America/Havana"),
("3569370", "Alamar", "Аламар", "CU", "192", "02", "", "", "", "23.15833", "-82.27694", "America/Havana"),
("3569546", "Aguada de Pasajeros", "", "CU", "192", "08", "", "", "", "22.37925", "-80.84898", "America/Havana"),
("3569741", "Abreus", "", "CU", "192", "08", "", "", "", "22.2775", "-80.5675", "America/Havana"),
("3746181", "Habana del Este", "", "CU", "192", "02", "", "", "", "23.15917", "-82.33056", "America/Havana"),
("3746183", "Centro Habana", "", "CU", "192", "02", "3746183", "", "", "23.13833", "-82.36417", "America/Havana"),
("3746184", "La Habana Vieja", "", "CU", "192", "02", "", "", "", "23.13028", "-82.35306", "America/Havana"),
("3746938", "Baguanos", "", "CU", "192", "12", "", "", "", "20.75167", "-76.02694", "America/Havana"),
("3754915", "Jimaguayu", "", "CU", "192", "05", "", "", "", "21.24278", "-77.82778", "America/Havana"),
("6956646", "Arroyo Naranjo", "", "CU", "192", "02", "", "", "", "23.0144", "-82.3031", "America/Havana"),
("6956647", "Boyeros", "", "CU", "192", "02", "", "", "", "23.0072", "-82.4017", "America/Havana"),
("6956648", "Diez de Octubre", "", "CU", "192", "02", "", "", "", "23.0881", "-82.3597", "America/Havana"),
("3374218", "Santa Maria", "", "CV", "132", "08", "", "", "", "16.6", "-22.9", "Atlantic/Cape_Verde"),
("3374333", "Praia", "Прая", "CV", "132", "14", "", "", "", "14.93152", "-23.51254", "Atlantic/Cape_Verde"),
("3374462", "Mindelo", "Минделу", "CV", "132", "11", "", "", "", "16.89014", "-24.98042", "Atlantic/Cape_Verde"),
("3374707", "Cova Figueira", "", "CV", "132", "24", "", "", "", "14.89054", "-24.29343", "Atlantic/Cape_Verde"),
("18918", "Protaras", "Протарас", "CY", "196", "01", "", "", "", "35.0125", "34.05833", "Asia/Nicosia"),
("146214", "Paphos", "Пафос", "CY", "196", "06", "", "", "", "34.77679", "32.42451", "Asia/Nicosia"),
("146268", "Nicosia", "Никосия", "CY", "196", "04", "", "", "", "35.16667", "33.36667", "Asia/Nicosia"),
("146384", "Limassol", "Лимасол", "CY", "196", "05", "", "", "", "34.68406", "33.03794", "Asia/Nicosia"),
("146400", "Larnaca", "Ларнака", "CY", "196", "03", "", "", "", "34.92291", "33.6233", "Asia/Nicosia"),
("146412", "Kyrenia", "Кирения", "CY", "196", "02", "", "", "", "35.34167", "33.31667", "Asia/Nicosia"),
("146617", "Famagusta", "Фамагуста", "CY", "196", "01", "", "", "", "35.125", "33.95", "Asia/Nicosia"),
("3061284", "Dvur Kralove nad Labem", "Двур-Кралове-над-Лабем", "CZ", "203", "82", "", "", "", "50.43172", "15.81402", "Europe/Prague"),
("3061344", "Znojmo", "Зноймо", "CZ", "203", "78", "0627", "", "", "48.8555", "16.0488", "Europe/Prague"),
("3061370", "Zlin", "Злин", "CZ", "203", "90", "0724", "", "", "49.22645", "17.67065", "Europe/Prague"),
("3061692", "Zd'ar nad Sazavou Druhy", "", "CZ", "203", "80", "", "", "", "49.58726", "15.93216", "Europe/Prague"),
("3061695", "Zd'ar nad Sazavou", "Ждяр-над-Сазавоу", "CZ", "203", "80", "0615", "", "", "49.56263", "15.93924", "Europe/Prague"),
("3061822", "Zatec", "Жатец", "CZ", "203", "89", "", "", "", "50.32717", "13.54577", "Europe/Prague"),
("3062283", "Vyskov", "Вышков", "CZ", "203", "78", "0626", "", "", "49.27747", "16.99897", "Europe/Prague"),
("3062339", "Vsetin", "Всетин", "CZ", "203", "90", "0723", "", "", "49.33871", "17.99619", "Europe/Prague"),
("3063375", "Varnsdorf", "Варнсдорф", "CZ", "203", "89", "", "", "", "50.91154", "14.61824", "Europe/Prague"),
("3063447", "Valasske Mezirici", "Мезиржичи", "CZ", "203", "90", "", "", "", "49.47181", "17.97113", "Europe/Prague"),
("3063546", "Usti nad Orlici", "Усти-над-Орлици", "CZ", "203", "86", "0534", "", "", "49.97387", "16.39361", "Europe/Prague"),
("3063548", "Usti nad Labem", "Усти-над-Лабем", "CZ", "203", "89", "0427", "", "", "50.6607", "14.03227", "Europe/Prague"),
("3063736", "Uhersky Brod", "Угерски-Брод", "CZ", "203", "90", "", "", "", "49.02513", "17.64715", "Europe/Prague"),
("3063739", "Uherske Hradiste", "Градиште", "CZ", "203", "90", "0722", "", "", "49.06975", "17.45969", "Europe/Prague"),
("3063907", "Trutnov", "Трутнов", "CZ", "203", "82", "0525", "", "", "50.56101", "15.9127", "Europe/Prague"),
("3064000", "Trinec", "Тршинец", "CZ", "203", "85", "", "", "", "49.67763", "18.67078", "Europe/Prague"),
("3064104", "Trebic", "Тршебич", "CZ", "203", "80", "0614", "", "", "49.21492", "15.88166", "Europe/Prague"),
("3064288", "Teplice", "Теплице", "CZ", "203", "89", "0426", "", "", "50.6404", "13.82451", "Europe/Prague"),
("3064379", "Tabor", "Табор", "CZ", "203", "79", "0317", "", "", "49.41441", "14.6578", "Europe/Prague"),
("3064454", "Svitavy", "Свитави", "CZ", "203", "86", "0533", "", "", "49.75594", "16.46829", "Europe/Prague"),
("3064673", "Sumperk", "Шумперк", "CZ", "203", "84", "0715", "", "", "49.96528", "16.97061", "Europe/Prague"),
("3065067", "Strakonice", "Страконице", "CZ", "203", "79", "", "", "", "49.26141", "13.90237", "Europe/Prague"),
("3065281", "Stary Bohumin", "", "CZ", "203", "85", "", "", "", "49.9169", "18.33619", "Europe/Prague"),
("3065617", "Sokolov", "Соколов", "CZ", "203", "81", "0413", "", "", "50.1813", "12.6401", "Europe/Prague"),
("3065903", "Slany", "", "CZ", "203", "88", "0203", "", "", "50.23046", "14.08693", "Europe/Prague"),
("3066651", "Roznov pod Radhostem", "", "CZ", "203", "90", "0723", "", "", "49.45853", "18.14302", "Europe/Prague"),
("3067051", "Rakovnik", "", "CZ", "203", "88", "", "", "", "50.1037", "13.7334", "Europe/Prague"),
("3067421", "Prostejov", "Простейов", "CZ", "203", "84", "0713", "", "", "49.47188", "17.11184", "Europe/Prague"),
("3067433", "Prosek", "", "CZ", "203", "52", "8378777", "", "", "50.11525", "14.50685", "Europe/Prague"),
("3067542", "Pribram", "Пршибрам", "CZ", "203", "88", "020B", "", "", "49.68988", "14.01043", "Europe/Prague"),
("3067580", "Prerov", "Преров", "CZ", "203", "84", "", "", "", "49.45511", "17.4509", "Europe/Prague"),
("3067696", "Prague", "Прага", "CZ", "203", "52", "", "", "", "50.08804", "14.42076", "Europe/Prague"),
("3068160", "Pilsen", "Пльзень", "CZ", "203", "87", "0323", "", "", "49.74747", "13.37759", "Europe/Prague"),
("3068293", "Pisek", "Писек", "CZ", "203", "79", "0314", "", "", "49.3088", "14.1475", "Europe/Prague"),
("3068445", "Pelhrimov", "", "CZ", "203", "80", "0613", "", "", "49.43134", "15.22336", "Europe/Prague"),
("3068582", "Pardubice", "Пардубице", "CZ", "203", "86", "0532", "", "", "50.04075", "15.77659", "Europe/Prague"),
("3068689", "Otrokovice", "", "CZ", "203", "90", "", "", "", "49.21667", "17.51667", "Europe/Prague"),
("3068690", "Otrokovice", "", "CZ", "203", "90", "0724", "", "", "49.20934", "17.53944", "Europe/Prague"),
("3068766", "Ostrov", "Остров", "CZ", "203", "81", "", "", "", "50.30592", "12.93907", "Europe/Prague"),
("3068799", "Ostrava", "Острава", "CZ", "203", "85", "0806", "", "", "49.83465", "18.28204", "Europe/Prague"),
("3068873", "Orlova", "Орлова", "CZ", "203", "85", "", "", "", "49.84527", "18.43011", "Europe/Prague"),
("3068927", "Opava", "Опава", "CZ", "203", "85", "0805", "", "", "49.93866", "17.90257", "Europe/Prague"),
("3069011", "Olomouc", "Оломоуц", "CZ", "203", "84", "0712", "", "", "49.59552", "17.25175", "Europe/Prague"),
("3069305", "Novy Jicin", "", "CZ", "203", "85", "0804", "", "", "49.59438", "18.01028", "Europe/Prague"),
("3069844", "Neratovice", "", "CZ", "203", "88", "", "", "", "50.25926", "14.51759", "Europe/Prague"),
("3070122", "Nachod", "", "CZ", "203", "82", "0523", "", "", "50.4167", "16.16289", "Europe/Prague"),
("3070291", "Most", "Мост", "CZ", "203", "89", "0425", "", "", "50.50301", "13.63617", "Europe/Prague"),
("3070420", "Modrany", "Модржаны", "CZ", "203", "52", "8378780", "", "", "50.01116", "14.4096", "Europe/Prague"),
("3070544", "Mlada Boleslav", "Млада-Болеслав", "CZ", "203", "88", "0207", "", "", "50.41135", "14.90318", "Europe/Prague"),
("3070862", "Melnik", "Мельник", "CZ", "203", "88", "0206", "", "", "50.3505", "14.47411", "Europe/Prague"),
("3071507", "Louny", "Лоуни", "CZ", "203", "89", "0424", "", "", "50.35699", "13.79667", "Europe/Prague"),
("3071665", "Litvinov", "Литвинов", "CZ", "203", "89", "0425", "", "", "50.6042", "13.61812", "Europe/Prague"),
("3071677", "Litomerice", "Литомержице", "CZ", "203", "89", "0423", "", "", "50.53348", "14.1318", "Europe/Prague"),
("3071961", "Liberec", "Либерец", "CZ", "203", "83", "0513", "", "", "50.76711", "15.05619", "Europe/Prague"),
("3071966", "Liben", "", "CZ", "203", "52", "8378776", "", "", "50.10819", "14.47457", "Europe/Prague"),
("3072137", "Letnany", "", "CZ", "203", "52", "8378788", "", "", "50.13333", "14.51667", "Europe/Prague"),
("3072463", "Kutna Hora", "Кутна-Гора", "CZ", "203", "88", "0205", "", "", "49.94839", "15.26816", "Europe/Prague"),
("3072649", "Kromeriz", "Кромнержиж", "CZ", "203", "90", "0721", "", "", "49.29785", "17.39312", "Europe/Prague"),
("3072656", "Krnov", "Крнов", "CZ", "203", "85", "", "", "", "50.08967", "17.70385", "Europe/Prague"),
("3072929", "Kralupy nad Vltavou", "Кралупи-над-Влтавой", "CZ", "203", "88", "", "", "", "50.24107", "14.31149", "Europe/Prague"),
("3073254", "Koprivnice", "Копршивницах", "CZ", "203", "85", "", "", "", "49.59947", "18.1448", "Europe/Prague"),
("3073371", "Kolin", "Колин", "CZ", "203", "88", "0204", "", "", "50.02814", "15.20057", "Europe/Prague"),
("3073660", "Klatovy", "Клатовы", "CZ", "203", "87", "", "", "", "49.39552", "13.29505", "Europe/Prague"),
("3073668", "Klasterec nad Ohri", "", "CZ", "203", "89", "", "", "", "50.38445", "13.17128", "Europe/Prague"),
("3073699", "Kladno", "Кладно", "CZ", "203", "88", "", "", "", "50.14734", "14.10285", "Europe/Prague"),
("3073789", "Karvina", "Карвина", "CZ", "203", "85", "0803", "", "", "49.854", "18.54169", "Europe/Prague"),
("3073803", "Karlovy Vary", "Карловы Вары", "CZ", "203", "81", "0412", "", "", "50.23271", "12.87117", "Europe/Prague"),
("3074020", "Kadan", "", "CZ", "203", "89", "", "", "", "50.38333", "13.26667", "Europe/Prague"),
("3074039", "Kadan", "Кадань", "CZ", "203", "89", "0422", "", "", "50.37598", "13.27131", "Europe/Prague"),
("3074110", "Jirkov", "Йирков", "CZ", "203", "89", "", "", "", "50.49979", "13.44769", "Europe/Prague"),
("3074149", "Jindrichuv Hradec", "Йиндржихув-Градец", "CZ", "203", "79", "0313", "", "", "49.14404", "15.00301", "Europe/Prague"),
("3074199", "Jihlava", "Йиглава", "CZ", "203", "80", "0612", "", "", "49.3961", "15.59124", "Europe/Prague"),
("3074204", "Jicin", "Йичин", "CZ", "203", "82", "0522", "", "", "50.43723", "15.35162", "Europe/Prague"),
("3074603", "Jablonec nad Nisou", "Яблонец", "CZ", "203", "83", "0512", "", "", "50.72431", "15.17108", "Europe/Prague"),
("3074893", "Hranice", "Границе", "CZ", "203", "84", "0714", "", "", "49.54796", "17.73469", "Europe/Prague"),
("3074967", "Hradec Kralove", "Градец Кралове", "CZ", "203", "82", "0521", "", "", "50.20923", "15.83277", "Europe/Prague"),
("3075654", "Hodonin", "Годонин", "CZ", "203", "78", "", "", "", "48.84893", "17.13244", "Europe/Prague"),
("3075919", "Havlickuv Brod", "Гавличкув-Брод", "CZ", "203", "80", "0611", "", "", "49.60785", "15.58069", "Europe/Prague"),
("3075921", "Havirov", "Гавиржов", "CZ", "203", "85", "", "", "", "49.77984", "18.43688", "Europe/Prague"),
("3076127", "Frydek-Mistek", "Мистек", "CZ", "203", "85", "0802", "", "", "49.68333", "18.35", "Europe/Prague"),
("3077244", "Decin", "Дечин", "CZ", "203", "89", "0421", "", "", "50.78215", "14.21478", "Europe/Prague"),
("3077539", "Chrudim", "Хрудим", "CZ", "203", "86", "0531", "", "", "49.95109", "15.79558", "Europe/Prague"),
("3077685", "Chomutov", "Хомутов", "CZ", "203", "89", "0422", "", "", "50.46048", "13.41779", "Europe/Prague"),
("3077835", "Cheb", "Хеб", "CZ", "203", "81", "0411", "", "", "50.07963", "12.37392", "Europe/Prague"),
("3077882", "Cesky Tesin", "Чески-Тешин", "CZ", "203", "85", "", "", "", "49.74613", "18.62613", "Europe/Prague"),
("3077916", "Ceske Budejovice", "Ческе-Будеёвице", "CZ", "203", "79", "0311", "", "", "48.97447", "14.47434", "Europe/Prague"),
("3077920", "Ceska Trebova", "Ческа-Тршебова", "CZ", "203", "86", "", "", "", "49.90436", "16.44413", "Europe/Prague"),
("3077929", "Ceska Lipa", "Ческа-Липа", "CZ", "203", "83", "0511", "", "", "50.68551", "14.53764", "Europe/Prague"),
("3078545", "Bruntal", "", "CZ", "203", "85", "0801", "", "", "49.98844", "17.4647", "Europe/Prague"),
("3078610", "Brno", "Брно", "CZ", "203", "78", "0622", "", "", "49.19522", "16.60796", "Europe/Prague"),
("3078773", "Breclav", "Бржецлав", "CZ", "203", "78", "0624", "", "", "48.75897", "16.88203", "Europe/Prague"),
("3078833", "Branik", "", "CZ", "203", "52", "", "", "", "50.03597", "14.41235", "Europe/Prague"),
("3078837", "Brandys nad Labem-Stara Boleslav", "", "CZ", "203", "88", "", "", "", "50.18709", "14.66326", "Europe/Prague"),
("3079129", "Bohumin", "Богумин", "CZ", "203", "85", "", "", "", "49.90411", "18.35755", "Europe/Prague"),
("3079273", "Blansko", "Бланско", "CZ", "203", "78", "0621", "", "", "49.36304", "16.64446", "Europe/Prague"),
("3079346", "Bilina Kyselka", "", "CZ", "203", "89", "", "", "", "50.55", "13.76667", "Europe/Prague"),
("3079348", "Bilina", "Билина", "CZ", "203", "89", "", "", "", "50.54854", "13.77535", "Europe/Prague"),
("3079467", "Beroun", "Бероун", "CZ", "203", "88", "0202", "", "", "49.96382", "14.072", "Europe/Prague"),
("3079508", "Benesov", "Бенешов", "CZ", "203", "88", "0201", "", "", "49.78162", "14.68697", "Europe/Prague"),
("6269470", "Cerny Most", "", "CZ", "203", "52", "", "", "", "50.10475", "14.57974", "Europe/Prague"),
("2803560", "Zwickau", "Цвиккау", "DE", "276", "13", "00", "14524", "", "50.72724", "12.48839", "Europe/Berlin"),
("2803620", "Zweibrucken", "Цвайбрюккен", "DE", "276", "08", "00", "07320", "", "49.24686", "7.36977", "Europe/Berlin"),
("2803723", "Zulpich", "Цюльпих", "DE", "276", "07", "", "", "", "50.69447", "6.65414", "Europe/Berlin"),
("2803870", "Zossen", "Цоссен", "DE", "276", "11", "", "", "", "52.216", "13.44909", "Europe/Berlin"),
("2804008", "Zittau", "Циттау", "DE", "276", "13", "00", "", "", "50.89772", "14.80764", "Europe/Berlin"),
("2804034", "Zirndorf", "Цирндорф", "DE", "276", "02", "095", "09573", "09573134", "49.4424", "10.95414", "Europe/Berlin"),
("2804748", "Zerbst", "Цербст", "DE", "276", "14", "", "", "", "51.9662", "12.08517", "Europe/Berlin"),
("2804922", "Zeitz", "Цайц", "DE", "276", "14", "", "", "", "51.04962", "12.1369", "Europe/Berlin"),
("2805059", "Zehlendorf Bezirk", "Целендорф", "DE", "276", "16", "00", "11000", "11000000", "52.43333", "13.25", "Europe/Berlin"),
("2805385", "Xanten", "Ксантен", "DE", "276", "07", "051", "", "", "51.65877", "6.45297", "Europe/Berlin"),
("2805597", "Wurzen", "Вурцен", "DE", "276", "13", "00", "", "", "51.3707", "12.73938", "Europe/Berlin"),
("2805615", "Wuerzburg", "Вюрцбург", "DE", "276", "02", "096", "09663", "09663000", "49.79391", "9.95121", "Europe/Berlin"),
("2805644", "Wurselen", "Вюрзелен", "DE", "276", "07", "053", "", "", "50.81809", "6.1347", "Europe/Berlin"),
("2805753", "Wuppertal", "Вупперталь", "DE", "276", "07", "051", "05124", "", "51.27027", "7.16755", "Europe/Berlin"),
("2805761", "Wunstorf", "Вунсторф", "DE", "276", "06", "", "", "", "52.42376", "9.43585", "Europe/Berlin"),
("2805910", "Wulfrath", "Вюльфрат", "DE", "276", "07", "", "", "", "51.28195", "7.03821", "Europe/Berlin"),
("2806081", "Worth am Rhein", "Вёрт-на-Рейне", "DE", "276", "08", "", "", "", "49.04888", "8.25959", "Europe/Berlin"),
("2806142", "Worms", "Вормс", "DE", "276", "08", "00", "07319", "", "49.63278", "8.35916", "Europe/Berlin"),
("2806654", "Wolfsburg", "Вольфсбург", "DE", "276", "06", "00", "03103", "", "52.42452", "10.7815", "Europe/Berlin"),
("2806768", "Wolfratshausen", "Вольфратсхаузен", "DE", "276", "02", "091", "09173", "09173147", "47.91289", "11.42166", "Europe/Berlin"),
("2806914", "Wolfenbuettel", "Вольфенбюттель", "DE", "276", "06", "00", "03158", "", "52.16442", "10.54095", "Europe/Berlin"),
("2806919", "Wolfen", "Вольфен", "DE", "276", "14", "", "", "", "51.66122", "12.26873", "Europe/Berlin"),
("2807184", "Witzenhausen", "Витценхаузен", "DE", "276", "05", "", "", "", "51.34103", "9.8554", "Europe/Berlin"),
("2807201", "Wittstock", "", "DE", "276", "11", "", "", "", "53.16118", "12.48287", "Europe/Berlin"),
("2807218", "Wittmund", "Витмунд", "DE", "276", "06", "00", "03462", "", "53.57674", "7.77839", "Europe/Berlin"),
("2807240", "Wittlich", "Виттлих", "DE", "276", "08", "00", "07231", "", "49.98596", "6.89308", "Europe/Berlin"),
("2807344", "Wittenberge", "Виттенберге", "DE", "276", "11", "", "", "", "53.00543", "11.75032", "Europe/Berlin"),
("2807360", "Wittenau", "", "DE", "276", "16", "00", "11000", "11000000", "52.59319", "13.32127", "Europe/Berlin"),
("2807363", "Witten", "Виттен", "DE", "276", "07", "", "", "", "51.44362", "7.35258", "Europe/Berlin"),
("2807465", "Wismar", "Висмар", "DE", "276", "12", "00", "13074", "", "53.89314", "11.45286", "Europe/Berlin"),
("2807594", "Wipperfurth", "Випперфюрт", "DE", "276", "07", "", "", "", "51.1161", "7.39865", "Europe/Berlin"),
("2807748", "Winterhude", "", "DE", "276", "04", "", "", "", "53.6", "10", "Europe/Berlin"),
("2807845", "Winsen", "", "DE", "276", "06", "00", "03353", "", "53.35753", "10.21282", "Europe/Berlin"),
("2807872", "Winnenden", "Винненден", "DE", "276", "01", "081", "08119", "08119085", "48.87563", "9.39819", "Europe/Berlin"),
("2808461", "Wilnsdorf", "Вильнсдорф", "DE", "276", "07", "059", "05970", "05970044", "50.81667", "8.1", "Europe/Berlin"),
("2808473", "Wilmersdorf Bezirk", "Вильмерсдорф", "DE", "276", "16", "00", "11000", "11000000", "52.48333", "13.31667", "Europe/Berlin"),
("2808559", "Willich", "Виллих", "DE", "276", "07", "051", "", "", "51.26371", "6.54734", "Europe/Berlin"),
("2808662", "Wilhelmstadt", "", "DE", "276", "16", "00", "11000", "11000000", "52.52462", "13.17707", "Europe/Berlin"),
("2808720", "Wilhelmshaven", "Вильгельмсхафен", "DE", "276", "06", "00", "03405", "", "53.52998", "8.11253", "Europe/Berlin"),
("2808893", "Wildeshausen", "Вильдесхаузен", "DE", "276", "06", "00", "03458", "", "52.89446", "8.43375", "Europe/Berlin"),
("2809138", "Wiesloch", "Вислох", "DE", "276", "01", "082", "08226", "08226098", "49.29504", "8.69846", "Europe/Berlin"),
("2809346", "Wiesbaden", "Висбаден", "DE", "276", "05", "064", "", "", "50.08258", "8.24932", "Europe/Berlin"),
("2809517", "Wiehl", "Виль", "DE", "276", "07", "", "", "", "50.9495", "7.55062", "Europe/Berlin"),
("2809889", "Wetzlar", "Вецлар", "DE", "276", "05", "065", "06532", "", "50.56109", "8.50495", "Europe/Berlin"),
("2809984", "Wetter (Ruhr)", "", "DE", "276", "07", "", "", "", "51.38747", "7.39277", "Europe/Berlin"),
("2810188", "Westerstede", "Вестерстеде", "DE", "276", "06", "00", "03451", "", "53.25682", "7.92737", "Europe/Berlin"),
("2810538", "Westend", "", "DE", "276", "16", "00", "11000", "11000000", "52.51708", "13.27636", "Europe/Berlin"),
("2810612", "Wesseling", "Весселинг", "DE", "276", "07", "", "", "", "50.82709", "6.9747", "Europe/Berlin"),
("2810678", "Wesel", "Везель", "DE", "276", "07", "051", "05170", "", "51.6669", "6.62037", "Europe/Berlin"),
("2810716", "Wertheim", "", "DE", "276", "01", "081", "08128", "08128131", "49.759", "9.50852", "Europe/Berlin"),
("2810808", "Wernigerode", "Вернигероде", "DE", "276", "14", "", "", "", "51.83652", "10.78216", "Europe/Berlin"),
("2810833", "Werne", "Верне", "DE", "276", "07", "", "", "", "51.66446", "7.63421", "Europe/Berlin"),
("2810855", "Wermelskirchen", "Вермельскирхен", "DE", "276", "07", "", "", "", "51.1397", "7.21583", "Europe/Berlin"),
("2810878", "Werl", "Верль", "DE", "276", "07", "059", "05974", "", "51.55493", "7.91403", "Europe/Berlin"),
("2810919", "Werdohl", "Вердоль", "DE", "276", "07", "", "", "", "51.26011", "7.76608", "Europe/Berlin"),
("2810945", "Werder", "Вердер", "DE", "276", "11", "00", "", "", "52.37874", "12.934", "Europe/Berlin"),
("2810969", "Werdau", "Вердау", "DE", "276", "13", "", "", "", "50.73604", "12.37534", "Europe/Berlin"),
("2811204", "Wendlingen am Neckar", "Вендлинген-на-Неккаре", "DE", "276", "01", "081", "08116", "08116071", "48.67124", "9.37632", "Europe/Berlin"),
("2811278", "Wenden", "Венден", "DE", "276", "07", "059", "05966", "05966028", "50.96667", "7.86667", "Europe/Berlin"),
("2811292", "Wendelstein", "", "DE", "276", "02", "095", "09576", "09576151", "49.3523", "11.15069", "Europe/Berlin"),
("2811644", "Weiterstadt", "Вайтерштадт", "DE", "276", "05", "", "", "", "49.9039", "8.58874", "Europe/Berlin"),
("2811698", "Weisswasser", "Вайсвассер", "DE", "276", "13", "", "", "", "51.50403", "14.64017", "Europe/Berlin"),
("2811899", "Weissenfels", "Вайсенфельс", "DE", "276", "14", "", "", "", "51.20148", "11.96843", "Europe/Berlin"),
("2811909", "Weissenburg in Bayern", "Вайсенбург", "DE", "276", "02", "095", "09577", "09577177", "49.03095", "10.97221", "Europe/Berlin"),
("2812145", "Weinstadt-Endersbach", "", "DE", "276", "01", "081", "08119", "08119091", "48.81311", "9.36387", "Europe/Berlin"),
("2812174", "Weinheim", "Вайнхайм", "DE", "276", "01", "082", "08226", "08226096", "49.54887", "8.66697", "Europe/Berlin"),
("2812204", "Weingarten", "Вайнгартен", "DE", "276", "01", "084", "08436", "08436082", "47.81009", "9.63863", "Europe/Berlin"),
("2812482", "Weimar", "Веймар", "DE", "276", "15", "00", "16055", "", "50.9803", "11.32903", "Europe/Berlin"),
("2812515", "Weilheim", "Вайльхайм", "DE", "276", "02", "091", "09190", "09190157", "47.84147", "11.15484", "Europe/Berlin"),
("2812522", "Weilerswist", "Вайлерсвист", "DE", "276", "07", "053", "05366", "05366040", "50.76667", "6.83333", "Europe/Berlin"),
("2812625", "Weil der Stadt", "Вайль-дер-Штадт", "DE", "276", "01", "081", "08115", "08115050", "48.74953", "8.87176", "Europe/Berlin"),
("2812636", "Weil am Rhein", "Вайль-на-Рейне", "DE", "276", "01", "083", "08336", "08336091", "47.59331", "7.62082", "Europe/Berlin"),
("2813040", "Weiden", "Вайден", "DE", "276", "02", "093", "09363", "09363000", "49.67682", "12.15613", "Europe/Berlin"),
("2813187", "Weissensee", "Вайсензее", "DE", "276", "16", "00", "11000", "11000000", "52.55632", "13.46649", "Europe/Berlin"),
("2813390", "Wegberg", "Вегберг", "DE", "276", "07", "", "", "", "51.14221", "6.28436", "Europe/Berlin"),
("2813433", "Weener", "Венер", "DE", "276", "06", "", "", "", "53.16332", "7.35052", "Europe/Berlin"),
("2813464", "Wedel", "Ведель", "DE", "276", "10", "", "", "", "53.58374", "9.69835", "Europe/Berlin"),
("2813472", "Wedding Bezirk", "", "DE", "276", "16", "00", "11000", "11000000", "52.54734", "13.35594", "Europe/Berlin"),
("2813786", "Wassenberg", "Вассенберг", "DE", "276", "07", "053", "", "", "51.10009", "6.15484", "Europe/Berlin"),
("2814005", "Warstein", "Варштайн", "DE", "276", "07", "", "", "", "51.44488", "8.34851", "Europe/Berlin"),
("2814127", "Warendorf", "Варендорф", "DE", "276", "07", "055", "05570", "", "51.95109", "7.98756", "Europe/Berlin"),
("2814131", "Waren", "Варен", "DE", "276", "12", "", "", "", "53.5204", "12.67985", "Europe/Berlin"),
("2814146", "Wardenburg", "Варденбург", "DE", "276", "06", "00", "03458", "03458013", "53.06667", "8.2", "Europe/Berlin"),
("2814153", "Warburg", "Варбург", "DE", "276", "07", "", "", "", "51.49011", "9.14641", "Europe/Berlin"),
("2814270", "Wangen im Allgau", "Ванген-им-Алльгой", "DE", "276", "01", "084", "08436", "08436081", "47.6895", "9.83247", "Europe/Berlin"),
("2814305", "Wandlitz", "Вандлиц", "DE", "276", "11", "00", "12060", "12060269", "52.74196", "13.45799", "Europe/Berlin"),
("2814362", "Waltrop", "Вальтроп", "DE", "276", "07", "", "", "", "51.62125", "7.40238", "Europe/Berlin"),
("2814462", "Walsrode", "Вальсроде", "DE", "276", "06", "", "", "", "52.86147", "9.5926", "Europe/Berlin"),
("2814632", "Wallenhorst", "Валленхорст", "DE", "276", "06", "00", "03459", "03459033", "52.35", "8.01667", "Europe/Berlin"),
("2814791", "Waldshut-Tiengen", "Вальдсхут-Тинген", "DE", "276", "01", "083", "08337", "08337126", "47.62323", "8.21717", "Europe/Berlin"),
("2814874", "Waldkraiburg", "Вальдкрайбург", "DE", "276", "02", "091", "09183", "09183148", "48.20854", "12.39893", "Europe/Berlin"),
("2814883", "Waldkirch", "Вальдкирх", "DE", "276", "01", "083", "08316", "08316056", "48.09585", "7.96371", "Europe/Berlin"),
("2815137", "Waldbrol", "Вальдбрёль", "DE", "276", "07", "", "", "", "50.87576", "7.61688", "Europe/Berlin"),
("2815330", "Waiblingen", "Вайблинген", "DE", "276", "01", "081", "08119", "08119079", "48.83241", "9.31641", "Europe/Berlin"),
("2815487", "Waghausel", "Вагхойзель", "DE", "276", "01", "082", "08215", "08215106", "49.24991", "8.51257", "Europe/Berlin"),
("2815559", "Wadgassen", "", "DE", "276", "09", "00", "10044", "10044120", "49.26667", "6.78333", "Europe/Berlin"),
("2815565", "Wadern", "Вадерн", "DE", "276", "09", "", "", "", "49.54122", "6.88774", "Europe/Berlin"),
("2815678", "Wachtberg", "Вахтберг", "DE", "276", "07", "053", "05382", "05382072", "50.63333", "7.1", "Europe/Berlin"),
("2815824", "Vreden", "Фреден", "DE", "276", "07", "055", "", "", "52.03792", "6.828", "Europe/Berlin"),
("2816630", "Volklingen", "Фёльклинген", "DE", "276", "09", "", "", "", "49.25162", "6.85873", "Europe/Berlin"),
("2817065", "Voerde", "Ферде", "DE", "276", "07", "051", "", "", "51.59703", "6.6863", "Europe/Berlin"),
("2817105", "Vlotho", "Флото", "DE", "276", "07", "057", "", "", "52.1653", "8.85996", "Europe/Berlin"),
("2817202", "Vilshofen", "", "DE", "276", "02", "092", "09275", "09275154", "48.62695", "13.19222", "Europe/Berlin"),
("2817220", "Villingen-Schwenningen", "Виллинген-Швеннинген", "DE", "276", "01", "083", "08326", "08326074", "48.06226", "8.49358", "Europe/Berlin"),
("2817311", "Viersen", "Фирзен", "DE", "276", "07", "051", "05166", "", "51.25435", "6.39441", "Europe/Berlin"),
("2817324", "Viernheim", "Фирнхайм", "DE", "276", "05", "", "", "", "49.54033", "8.5782", "Europe/Berlin"),
("2817537", "Versmold", "Ферсмольд", "DE", "276", "07", "", "", "", "52.04009", "8.15272", "Europe/Berlin"),
("2817576", "Verl", "Ферль", "DE", "276", "07", "057", "05754", "05754044", "51.88333", "8.51667", "Europe/Berlin"),
("2817599", "Verden", "Ферден", "DE", "276", "06", "00", "03361", "", "52.92342", "9.23491", "Europe/Berlin"),
("2817724", "Velbert", "Фельберт", "DE", "276", "07", "051", "", "", "51.33536", "7.04348", "Europe/Berlin"),
("2817812", "Vechta", "Фехта", "DE", "276", "06", "00", "03460", "", "52.72632", "8.28598", "Europe/Berlin"),
("2817813", "Vechelde", "Фехельде", "DE", "276", "06", "00", "03157", "03157007", "52.26038", "10.36491", "Europe/Berlin"),
("2817818", "Vaterstetten", "Фатерштеттен", "DE", "276", "02", "091", "09175", "09175132", "48.10537", "11.76825", "Europe/Berlin"),
("2817873", "Varel", "", "DE", "276", "06", "00", "03455", "03455026", "53.39693", "8.13621", "Europe/Berlin"),
("2817927", "Vaihingen an der Enz", "Файхинген-на-Энце", "DE", "276", "01", "081", "08118", "08118073", "48.93563", "8.96045", "Europe/Berlin"),
("2818067", "Uetersen", "Итерзен", "DE", "276", "10", "", "", "", "53.68769", "9.66394", "Europe/Berlin"),
("2818094", "Uslar", "Услар", "DE", "276", "06", "", "", "", "51.6569", "9.63501", "Europe/Berlin"),
("2818766", "Unterschleissheim", "Унтершлайсхайм", "DE", "276", "02", "091", "09184", "09184149", "48.28038", "11.57684", "Europe/Berlin"),
("2819465", "Unterhaching", "Унтерхахинг", "DE", "276", "02", "091", "09184", "09184148", "48.06598", "11.61564", "Europe/Berlin"),
("2819974", "Unterkrozingen", "", "DE", "276", "01", "083", "08315", "08315006", "47.91933", "7.69045", "Europe/Berlin"),
("2820087", "Unna", "Унна", "DE", "276", "07", "059", "05978", "", "51.53794", "7.68969", "Europe/Berlin"),
("2820256", "Ulm", "Ульм", "DE", "276", "01", "084", "08425", "", "48.39841", "9.99155", "Europe/Berlin"),
("2820456", "Uelzen", "Ильцен", "DE", "276", "06", "00", "03360", "", "52.96572", "10.56111", "Europe/Berlin"),
("2820577", "Uberlingen", "Иберлинген", "DE", "276", "01", "084", "08435", "08435059", "47.76977", "9.17136", "Europe/Berlin"),
("2820621", "Ubach-Palenberg", "Ибах-Паленберг", "DE", "276", "07", "053", "05370", "05370028", "50.93333", "6.11667", "Europe/Berlin"),
("2820693", "Tuttlingen", "Тутлинген", "DE", "276", "01", "083", "08327", "08327050", "47.98464", "8.8177", "Europe/Berlin"),
("2820860", "Tuebingen", "Тюбинген", "DE", "276", "01", "084", "08416", "08416041", "48.52266", "9.05222", "Europe/Berlin"),
("2820973", "Trossingen", "Троссинген", "DE", "276", "01", "083", "08327", "08327049", "48.07667", "8.64409", "Europe/Berlin"),
("2821029", "Troisdorf", "Тройсдорф", "DE", "276", "07", "053", "", "", "50.80901", "7.14968", "Europe/Berlin"),
("2821164", "Trier", "Трир", "DE", "276", "08", "00", "07211", "07211000", "49.75565", "6.63935", "Europe/Berlin"),
("2821515", "Traunstein", "Траунштайн", "DE", "276", "02", "091", "09189", "09189155", "47.86825", "12.64335", "Europe/Berlin"),
("2821517", "Traunreut", "Траунройт", "DE", "276", "02", "091", "09189", "09189154", "47.96269", "12.59231", "Europe/Berlin"),
("2821807", "Torgau", "Торгау", "DE", "276", "13", "00", "14730", "", "51.56016", "12.99617", "Europe/Berlin"),
("2821899", "Tonisvorst", "Тёнисфорст", "DE", "276", "07", "", "", "", "51.32092", "6.49412", "Europe/Berlin"),
("2823368", "Tettnang", "", "DE", "276", "01", "084", "08435", "08435057", "47.66857", "9.59132", "Europe/Berlin"),
("2823533", "Templin", "Темплин", "DE", "276", "11", "", "", "", "53.11865", "13.5022", "Europe/Berlin"),
("2823538", "Tempelhof Bezirk", "Темпельхоф", "DE", "276", "16", "00", "11000", "11000000", "52.46667", "13.4", "Europe/Berlin"),
("2823567", "Teltow", "Тельтов", "DE", "276", "11", "", "", "", "52.4031", "13.26014", "Europe/Berlin"),
("2823590", "Telgte", "Тельгте", "DE", "276", "07", "055", "", "", "51.97995", "7.78293", "Europe/Berlin"),
("2823708", "Tegel", "Тегель", "DE", "276", "16", "00", "11000", "11000000", "52.57601", "13.29389", "Europe/Berlin"),
("2823799", "Taunusstein", "Таунусштайн", "DE", "276", "05", "", "", "", "50.14993", "8.15206", "Europe/Berlin"),
("2823812", "Taufkirchen", "", "DE", "276", "02", "091", "09184", "09184145", "48.0486", "11.61701", "Europe/Berlin"),
("2824461", "Syke", "Зике", "DE", "276", "06", "", "", "", "52.91345", "8.82209", "Europe/Berlin"),
("2824655", "Sundern", "Зундерн", "DE", "276", "07", "059", "", "", "51.3281", "8.00369", "Europe/Berlin"),
("2824801", "Sulzbach-Rosenberg", "Зульцбах-Розенберг", "DE", "276", "02", "093", "09371", "09371151", "49.50126", "11.74598", "Europe/Berlin"),
("2824841", "Sulzbach", "Зульцбах", "DE", "276", "09", "", "", "", "49.29882", "7.05696", "Europe/Berlin"),
("2824948", "Suhl", "Зуль", "DE", "276", "15", "00", "16054", "", "50.60911", "10.69401", "Europe/Berlin"),
("2825297", "Stuttgart", "Штутгарт", "DE", "276", "01", "081", "08111", "08111000", "48.78232", "9.17702", "Europe/Berlin"),
("2825422", "Stuhr", "", "DE", "276", "06", "00", "03251", "03251037", "53.03333", "8.75", "Europe/Berlin"),
("2826082", "Strausberg", "Штраусберг", "DE", "276", "11", "", "", "", "52.57859", "13.88741", "Europe/Berlin"),
("2826099", "Straubing", "Штраубинг", "DE", "276", "02", "092", "09263", "09263000", "48.88126", "12.57385", "Europe/Berlin"),
("2826287", "Stralsund", "Штральзунд", "DE", "276", "12", "00", "13073", "", "54.30911", "13.0818", "Europe/Berlin"),
("2826304", "Straelen", "Штрален", "DE", "276", "07", "", "", "", "51.4419", "6.26639", "Europe/Berlin"),
("2826595", "Stolberg", "Штольберг", "DE", "276", "07", "", "", "", "50.77368", "6.22595", "Europe/Berlin"),
("2826861", "Stockelsdorf", "", "DE", "276", "10", "00", "01055", "01055040", "53.8922", "10.64713", "Europe/Berlin"),
("2826909", "Stockach", "Штоках", "DE", "276", "01", "083", "08335", "08335079", "47.85105", "9.0091", "Europe/Berlin"),
("2827479", "Stendal", "Стендаль", "DE", "276", "14", "00", "15090", "", "52.6069", "11.85867", "Europe/Berlin"),
("2827552", "Stellingen", "", "DE", "276", "04", "", "", "", "53.5922", "9.9287", "Europe/Berlin"),
("2828050", "Steinhagen", "", "DE", "276", "07", "057", "05754", "05754040", "52", "8.4", "Europe/Berlin"),
("2828105", "Steinfurt", "Штайнфурт", "DE", "276", "07", "055", "05566", "", "52.15045", "7.33664", "Europe/Berlin"),
("2828994", "Steilshoop", "", "DE", "276", "04", "", "", "", "53.61028", "10.05917", "Europe/Berlin"),
("2829109", "Steglitz Bezirk", "Штеглиц", "DE", "276", "16", "00", "11000", "11000000", "52.45606", "13.332", "Europe/Berlin"),
("2829422", "Stassfurt", "Штасфурт", "DE", "276", "14", "", "", "", "51.85186", "11.58508", "Europe/Berlin"),
("2829457", "Starnberg", "Штарнберг", "DE", "276", "02", "091", "09188", "09188139", "48.00193", "11.34416", "Europe/Berlin"),
("2829758", "Stadtlohn", "Штадтлон", "DE", "276", "07", "", "", "", "51.99399", "6.91918", "Europe/Berlin"),
("2829777", "Stadthagen", "Штадтхаген", "DE", "276", "06", "00", "03257", "", "52.32333", "9.20311", "Europe/Berlin"),
("2829804", "Stadtallendorf", "Штадталлендорф", "DE", "276", "05", "", "", "", "50.82261", "9.01294", "Europe/Berlin"),
("2829901", "Stade", "Штаде", "DE", "276", "06", "00", "03359", "", "53.59337", "9.47629", "Europe/Berlin"),
("2829962", "Staaken", "", "DE", "276", "16", "00", "11000", "11000000", "52.53661", "13.15056", "Europe/Berlin"),
("2829998", "Sprockhovel", "Шпрокхёфель", "DE", "276", "07", "", "", "", "51.34669", "7.24343", "Europe/Berlin"),
("2830035", "Springe", "Шпринге", "DE", "276", "06", "", "", "", "52.20845", "9.55416", "Europe/Berlin"),
("2830582", "Speyer", "Шпайер", "DE", "276", "08", "00", "07318", "", "49.32083", "8.43111", "Europe/Berlin"),
("2830637", "Spenge", "", "DE", "276", "07", "", "", "", "52.14021", "8.48475", "Europe/Berlin"),
("2831088", "Sonthofen", "Зонтхофен", "DE", "276", "02", "097", "09780", "09780139", "47.51821", "10.28262", "Europe/Berlin"),
("2831250", "Sonneberg", "Зоннеберг", "DE", "276", "15", "00", "16072", "", "50.3592", "11.17463", "Europe/Berlin"),
("2831276", "Sondershausen", "Зондерсхаузен", "DE", "276", "15", "00", "16065", "", "51.36973", "10.87011", "Europe/Berlin"),
("2831403", "Soemmerda", "Зёммерда", "DE", "276", "15", "00", "16068", "", "51.15914", "11.11524", "Europe/Berlin"),
("2831486", "Soltau", "Зольтау", "DE", "276", "06", "", "", "", "52.98638", "9.84338", "Europe/Berlin"),
("2831580", "Solingen", "Золинген", "DE", "276", "07", "051", "05122", "", "51.17343", "7.0845", "Europe/Berlin"),
("2831708", "Soest", "Зоест", "DE", "276", "07", "059", "05974", "", "51.57558", "8.10619", "Europe/Berlin"),
("2831852", "Sinzig", "Зинциг", "DE", "276", "08", "", "", "", "50.54384", "7.24639", "Europe/Berlin"),
("2831872", "Sinsheim", "Зинсхайм", "DE", "276", "01", "082", "08226", "08226085", "49.2529", "8.87867", "Europe/Berlin"),
("2831924", "Singen", "Зинген", "DE", "276", "01", "083", "08335", "08335075", "47.75935", "8.8403", "Europe/Berlin"),
("2831948", "Sindelfingen", "Зиндельфинген", "DE", "276", "01", "081", "08115", "08115045", "48.7", "9.01667", "Europe/Berlin"),
("2832023", "Simmerath", "Зиммерат", "DE", "276", "07", "053", "05334", "05334028", "50.6", "6.3", "Europe/Berlin"),
("2832232", "Sigmaringen", "Зигмаринген", "DE", "276", "01", "084", "08437", "08437104", "48.08829", "9.23033", "Europe/Berlin"),
("2832495", "Siegen", "Зиген", "DE", "276", "07", "059", "05970", "", "50.87482", "8.02431", "Europe/Berlin"),
("2832521", "Siegburg", "Зигбург", "DE", "276", "07", "053", "05382", "", "50.80019", "7.20769", "Europe/Berlin"),
("2833073", "Senftenberg", "Зенфтенберг", "DE", "276", "11", "00", "12066", "", "51.52517", "14.00164", "Europe/Berlin"),
("2833079", "Senden", "", "DE", "276", "07", "055", "05558", "05558044", "51.85", "7.5", "Europe/Berlin"),
("2833080", "Senden", "", "DE", "276", "02", "097", "09775", "09775152", "48.32441", "10.04442", "Europe/Berlin"),
("2833170", "Selm", "Зельм", "DE", "276", "07", "", "", "", "51.69689", "7.46809", "Europe/Berlin"),
("2833242", "Seligenstadt", "Зелигенштадт", "DE", "276", "05", "064", "", "", "50.0432", "8.97394", "Europe/Berlin"),
("2833296", "Selb", "Зельб", "DE", "276", "02", "094", "09479", "09479152", "50.17058", "12.13054", "Europe/Berlin"),
("2833475", "Sehnde", "Зенде", "DE", "276", "06", "00", "", "", "52.31394", "9.9682", "Europe/Berlin"),
("2833564", "Seevetal", "Зеветаль", "DE", "276", "06", "00", "03353", "03353031", "53.4", "9.96667", "Europe/Berlin"),
("2833592", "Seesen", "Зезен", "DE", "276", "06", "", "", "", "51.89096", "10.17847", "Europe/Berlin"),
("2833641", "Seelze", "Зельце", "DE", "276", "06", "", "", "", "52.39635", "9.59727", "Europe/Berlin"),
("2834240", "Schwetzingen", "Шветцинген", "DE", "276", "01", "082", "08226", "08226084", "49.38217", "8.5823", "Europe/Berlin"),
("2834265", "Schwerte", "Шверте", "DE", "276", "07", "", "", "", "51.44387", "7.5675", "Europe/Berlin"),
("2834282", "Schwerin", "Шверин", "DE", "276", "12", "", "", "", "53.62937", "11.41316", "Europe/Berlin"),
("2834372", "Schwelm", "Швельм", "DE", "276", "07", "059", "05954", "", "51.28635", "7.29388", "Europe/Berlin"),
("2834498", "Schweinfurt", "Швайнфурт", "DE", "276", "02", "096", "09662", "09662000", "50.04937", "10.22175", "Europe/Berlin"),
("2834629", "Schwedt (Oder)", "", "DE", "276", "11", "", "", "", "53.05963", "14.28154", "Europe/Berlin"),
("2834978", "Schwarzenberg", "Шварценберг", "DE", "276", "13", "00", "", "", "50.53791", "12.78522", "Europe/Berlin"),
("2835260", "Schwanewede", "Шваневеде", "DE", "276", "06", "00", "03356", "03356009", "53.23333", "8.6", "Europe/Berlin"),
("2835297", "Schwandorf in Bayern", "", "DE", "276", "02", "093", "09376", "09376161", "49.32534", "12.1098", "Europe/Berlin"),
("2835342", "Schwalmtal", "", "DE", "276", "07", "051", "05166", "05166024", "51.21667", "6.26667", "Europe/Berlin"),
("2835345", "Schwalmstadt", "Швальмштадт", "DE", "276", "05", "", "", "", "50.93333", "9.21667", "Europe/Berlin"),
("2835382", "Schwalbach", "", "DE", "276", "09", "00", "10044", "10044118", "49.3", "6.81667", "Europe/Berlin"),
("2835481", "Schwaebisch Hall", "", "DE", "276", "01", "081", "08127", "08127076", "49.11127", "9.73908", "Europe/Berlin"),
("2835482", "Schwabisch Gmund", "Швебиш-Гмюнд", "DE", "276", "01", "081", "08136", "08136065", "48.79947", "9.79809", "Europe/Berlin"),
("2835537", "Schwabach", "Швабах", "DE", "276", "02", "095", "09565", "09565000", "49.33047", "11.02346", "Europe/Berlin"),
("2836084", "Schrobenhausen", "Шробенхаузен", "DE", "276", "02", "091", "09185", "09185158", "48.56067", "11.26071", "Europe/Berlin"),
("2836203", "Schramberg", "Шрамберг", "DE", "276", "01", "083", "08325", "08325053", "48.22399", "8.38583", "Europe/Berlin"),
("2836282", "Schortens", "", "DE", "276", "06", "00", "03455", "03455015", "53.53333", "7.95", "Europe/Berlin"),
("2836320", "Schorndorf", "Шорндорф", "DE", "276", "01", "081", "08119", "08119067", "48.80537", "9.52721", "Europe/Berlin"),
("2836413", "Schopfheim", "Шопфхайм", "DE", "276", "01", "083", "08336", "08336081", "47.65105", "7.82089", "Europe/Berlin"),
("2836788", "Schoneberg Bezirk", "", "DE", "276", "16", "00", "11000", "11000000", "52.46667", "13.35", "Europe/Berlin"),
("2836809", "Schonebeck", "Шёнебек", "DE", "276", "14", "", "", "", "52.01682", "11.7307", "Europe/Berlin"),
("2837291", "Schneverdingen", "Шнефердинген", "DE", "276", "06", "", "", "", "53.11685", "9.79524", "Europe/Berlin"),
("2837470", "Schneeberg", "Шнеберг", "DE", "276", "13", "", "", "", "50.59465", "12.64139", "Europe/Berlin"),
("2837954", "Schmelz", "", "DE", "276", "09", "00", "10044", "10044117", "49.43333", "6.85", "Europe/Berlin"),
("2838009", "Schmargendorf", "", "DE", "276", "16", "00", "11000", "11000000", "52.47517", "13.29071", "Europe/Berlin"),
("2838053", "Schmallenberg", "Шмалленберг", "DE", "276", "07", "059", "", "", "51.15473", "8.28505", "Europe/Berlin"),
("2838059", "Schmalkalden", "Шмалькальден", "DE", "276", "15", "", "", "", "50.72136", "10.44386", "Europe/Berlin"),
("2838201", "Schluchtern", "Шлюхтерн", "DE", "276", "05", "064", "", "", "50.34891", "9.52532", "Europe/Berlin"),
("2838634", "Schleswig", "Шлезвиг", "DE", "276", "10", "00", "01059", "", "54.52156", "9.5586", "Europe/Berlin"),
("2839050", "Schkeuditz", "Шкойдиц", "DE", "276", "13", "", "", "", "51.39678", "12.22141", "Europe/Berlin"),
("2839316", "Schiffweiler", "Шифвайлер", "DE", "276", "09", "00", "10043", "10043116", "49.36667", "7.13333", "Europe/Berlin"),
("2839335", "Schifferstadt", "Шифферштадт", "DE", "276", "08", "", "", "", "49.38417", "8.3775", "Europe/Berlin"),
("2841125", "Saulgau", "", "DE", "276", "01", "084", "08437", "08437100", "48.01676", "9.50064", "Europe/Berlin"),
("2841374", "Sasel", "", "DE", "276", "04", "", "", "", "53.65385", "10.11184", "Europe/Berlin"),
("2841386", "Sarstedt", "Зарштедт", "DE", "276", "06", "", "", "", "52.23495", "9.85411", "Europe/Berlin"),
("2841463", "Sankt Wendel", "Санкт-Вендель", "DE", "276", "09", "00", "10046", "", "49.46633", "7.16814", "Europe/Berlin"),
("2841590", "Sankt Ingbert", "", "DE", "276", "09", "", "", "", "49.27697", "7.11672", "Europe/Berlin"),
("2841648", "Sankt Augustin", "Санкт-Августин", "DE", "276", "07", "", "", "", "50.77538", "7.197", "Europe/Berlin"),
("2841693", "Sangerhausen", "Зангерхаузен", "DE", "276", "14", "00", "15087", "", "51.47221", "11.29533", "Europe/Berlin"),
("2842112", "Salzwedel", "Зальцведель", "DE", "276", "14", "00", "15081", "", "52.85435", "11.1525", "Europe/Berlin"),
("2842131", "Salzkotten", "Зальцкоттен", "DE", "276", "07", "057", "", "", "51.6717", "8.60092", "Europe/Berlin"),
("2842632", "Saarlouis", "Саарлуисе", "DE", "276", "09", "00", "10044", "", "49.31366", "6.75154", "Europe/Berlin"),
("2842647", "Saarbrucken", "Саарбрюккен", "DE", "276", "09", "", "", "", "49.2354", "6.98165", "Europe/Berlin"),
("2842688", "Saalfeld", "Заальфельд", "DE", "276", "15", "00", "16073", "", "50.64826", "11.36536", "Europe/Berlin"),
("2842884", "Russelsheim", "Рюссельсхайм", "DE", "276", "05", "064", "", "", "49.98955", "8.42251", "Europe/Berlin"),
("2843106", "Rummelsburg", "", "DE", "276", "16", "00", "11000", "11000000", "52.50146", "13.4934", "Europe/Berlin"),
("2843350", "Rudow", "", "DE", "276", "16", "00", "11000", "11000000", "52.42407", "13.48529", "Europe/Berlin"),
("2843355", "Rudolstadt", "Рудольштадт", "DE", "276", "15", "", "", "", "50.72043", "11.34046", "Europe/Berlin"),
("2843636", "Rottweil", "Ротвайль", "DE", "276", "01", "083", "08325", "08325049", "48.16783", "8.62719", "Europe/Berlin"),
("2843729", "Rottenburg", "", "DE", "276", "01", "084", "08416", "08416036", "48.47629", "8.93528", "Europe/Berlin"),
("2844265", "Roth", "Рота", "DE", "276", "02", "095", "09576", "09576143", "49.24762", "11.09111", "Europe/Berlin"),
("2844437", "Rotenburg", "Ротенбург", "DE", "276", "06", "00", "03357", "", "53.11125", "9.41082", "Europe/Berlin"),
("2844588", "Rostock", "Росток", "DE", "276", "12", "00", "", "", "54.0887", "12.14049", "Europe/Berlin"),
("2844862", "Rosrath", "Рёсрат", "DE", "276", "07", "053", "", "", "50.89559", "7.18175", "Europe/Berlin"),
("2844988", "Rosenheim", "Розенхайм", "DE", "276", "02", "091", "09163", "09163000", "47.85637", "12.12247", "Europe/Berlin"),
("2845222", "Ronnenberg", "", "DE", "276", "06", "", "", "", "52.31939", "9.65544", "Europe/Berlin"),
("2846523", "Rinteln", "Ринтельн", "DE", "276", "06", "00", "03257", "03257031", "52.18604", "9.07917", "Europe/Berlin"),
("2846843", "Rietberg", "Ритберг", "DE", "276", "07", "", "", "", "51.80924", "8.42841", "Europe/Berlin"),
("2846939", "Riesa", "Риза", "DE", "276", "13", "", "", "", "51.30776", "13.29168", "Europe/Berlin"),
("2847033", "Riegelsberg", "", "DE", "276", "09", "00", "10041", "10041517", "49.3", "6.93333", "Europe/Berlin"),
("2847524", "Ribnitz-Damgarten", "Рибниц-Дамгартен", "DE", "276", "12", "", "", "", "54.2422", "12.45666", "Europe/Berlin"),
("2847639", "Rheinfelden (Baden)", "Райнфельден", "DE", "276", "01", "083", "08336", "08336069", "47.56013", "7.78715", "Europe/Berlin"),
("2847645", "Rheine", "Райн", "DE", "276", "07", "055", "", "", "52.28509", "7.44055", "Europe/Berlin"),
("2847662", "Rheinberg", "", "DE", "276", "07", "", "", "", "51.54649", "6.59524", "Europe/Berlin"),
("2847666", "Rheinbach", "Райнбах", "DE", "276", "07", "053", "", "", "50.62562", "6.94911", "Europe/Berlin"),
("2847689", "Rhede", "Реде", "DE", "276", "07", "055", "", "", "51.83537", "6.69602", "Europe/Berlin"),
("2847690", "Rheda-Wiedenbruck", "Ред-Виденбрюк", "DE", "276", "07", "057", "", "", "51.84967", "8.30017", "Europe/Berlin"),
("2847736", "Reutlingen", "Ройтлинген", "DE", "276", "01", "084", "08415", "08415061", "48.49144", "9.20427", "Europe/Berlin"),
("2848175", "Renningen", "Реннинген", "DE", "276", "01", "081", "08115", "08115041", "48.76974", "8.93871", "Europe/Berlin"),
("2848245", "Rendsburg", "Рендсбург", "DE", "276", "10", "00", "01058", "", "54.30663", "9.66313", "Europe/Berlin"),
("2848273", "Remscheid", "Ремшайд", "DE", "276", "07", "051", "05120", "", "51.17983", "7.1925", "Europe/Berlin"),
("2848335", "Remagen", "Ремаген", "DE", "276", "08", "", "", "", "50.57879", "7.22703", "Europe/Berlin"),
("2848756", "Reinickendorf", "", "DE", "276", "16", "00", "11000", "11000000", "52.56667", "13.33333", "Europe/Berlin"),
("2848762", "Reinheim", "Райнхайм", "DE", "276", "05", "", "", "", "49.82923", "8.83572", "Europe/Berlin"),
("2848845", "Reinbek", "Райнбек", "DE", "276", "10", "", "", "", "53.51703", "10.2488", "Europe/Berlin"),
("2849156", "Reichenbach/Vogtland", "", "DE", "276", "13", "00", "", "", "50.62279", "12.30344", "Europe/Berlin"),
("2849483", "Regensburg", "Регенсбург", "DE", "276", "02", "093", "09362", "09362000", "49.03451", "12.11923", "Europe/Berlin"),
("2849548", "Rees", "Рес", "DE", "276", "07", "", "", "", "51.76263", "6.39778", "Europe/Berlin"),
("2849647", "Recklinghausen", "Реклингхаузен", "DE", "276", "07", "055", "05562", "", "51.61379", "7.19738", "Europe/Berlin"),
("2849802", "Ravensburg", "Равенсбург", "DE", "276", "01", "084", "08436", "08436064", "47.78198", "9.61062", "Europe/Berlin"),
("2850174", "Ratingen", "Ратинген", "DE", "276", "07", "051", "", "", "51.29724", "6.84929", "Europe/Berlin"),
("2850213", "Rathenow", "Ратенов", "DE", "276", "11", "00", "12063", "", "52.60659", "12.33696", "Europe/Berlin"),
("2850235", "Ratekau", "Ратекау", "DE", "276", "10", "00", "01055", "01055035", "53.95", "10.73333", "Europe/Berlin"),
("2850253", "Rastede", "Растеде", "DE", "276", "06", "00", "03451", "03451005", "53.25", "8.2", "Europe/Berlin"),
("2850257", "Rastatt", "Раштатт", "DE", "276", "01", "082", "08216", "08216043", "48.85851", "8.20964", "Europe/Berlin"),
("2850887", "Rahden", "Раден", "DE", "276", "07", "", "", "", "52.43367", "8.61263", "Europe/Berlin"),
("2850954", "Radolfzell am Bodensee", "Радольфцелль", "DE", "276", "01", "083", "08335", "08335063", "47.74194", "8.97098", "Europe/Berlin"),
("2850995", "Radevormwald", "Радеформвальд", "DE", "276", "07", "", "", "", "51.20218", "7.36027", "Europe/Berlin"),
("2851077", "Radebeul", "Радебойль", "DE", "276", "13", "00", "", "", "51.10654", "13.66047", "Europe/Berlin"),
("2851079", "Radeberg", "Радеберг", "DE", "276", "13", "", "", "", "51.11112", "13.91199", "Europe/Berlin"),
("2851343", "Quickborn", "Квикборн", "DE", "276", "10", "", "", "", "53.72831", "9.90934", "Europe/Berlin"),
("2851465", "Quedlinburg", "Кведлинбург", "DE", "276", "14", "", "", "", "51.78843", "11.15006", "Europe/Berlin"),
("2851584", "Puttlingen", "Пютлинген", "DE", "276", "09", "", "", "", "49.2855", "6.88723", "Europe/Berlin"),
("2851746", "Pulheim", "Пульхайм", "DE", "276", "07", "053", "", "", "50.99965", "6.80632", "Europe/Berlin"),
("2851782", "Puchheim", "", "DE", "276", "02", "091", "09179", "09179145", "48.15", "11.35", "Europe/Berlin"),
("2852217", "Prenzlauer Berg Bezirk", "Пренцлауэр-Берг", "DE", "276", "16", "00", "11000", "11000000", "52.53878", "13.42443", "Europe/Berlin"),
("2852218", "Prenzlau", "Пренцлау", "DE", "276", "11", "00", "12073", "", "53.31625", "13.86261", "Europe/Berlin"),
("2852280", "Preetz", "Прец", "DE", "276", "10", "", "", "", "54.2354", "10.27795", "Europe/Berlin"),
("2852458", "Potsdam", "Потсдам", "DE", "276", "11", "", "", "", "52.39886", "13.06566", "Europe/Berlin"),
("2852577", "Porta Westfalica", "", "DE", "276", "07", "", "", "", "52.23779", "8.91901", "Europe/Berlin"),
("2852673", "Poppenbuettel", "", "DE", "276", "04", "", "", "", "53.65917", "10.08472", "Europe/Berlin"),
("2853209", "Plettenberg", "Плеттенберг", "DE", "276", "07", "", "", "", "51.20949", "7.8726", "Europe/Berlin"),
("2853292", "Plauen", "Плауэн", "DE", "276", "13", "00", "14523", "", "50.4973", "12.13782", "Europe/Berlin"),
("2853572", "Pirna", "Пирна", "DE", "276", "13", "00", "14628", "", "50.95843", "13.93702", "Europe/Berlin"),
("2853574", "Pirmasens", "Пирмазенс", "DE", "276", "08", "00", "07340", "", "49.20145", "7.60529", "Europe/Berlin"),
("2853658", "Pinneberg", "Пиннеберг", "DE", "276", "10", "00", "01056", "", "53.66732", "9.78936", "Europe/Berlin"),
("2853924", "Pfungstadt", "Пфунгштадт", "DE", "276", "05", "", "", "", "49.80557", "8.60306", "Europe/Berlin"),
("2853928", "Pfullingen", "Пфуллинген", "DE", "276", "01", "084", "08415", "08415059", "48.46458", "9.22796", "Europe/Berlin"),
("2853969", "Pforzheim", "Пфорцхайм", "DE", "276", "01", "082", "08231", "08231000", "48.88436", "8.69892", "Europe/Berlin"),
("2854386", "Pfaffenhofen an der Ilm", "Пфаффенхофен-ан-дер-Ильм", "DE", "276", "02", "091", "09186", "09186143", "48.53053", "11.505", "Europe/Berlin"),
("2854655", "Petershagen", "Петерсхаген", "DE", "276", "07", "057", "", "", "52.37513", "8.96538", "Europe/Berlin"),
("2854923", "Penzberg", "Пенцберг", "DE", "276", "02", "091", "09190", "09190141", "47.75293", "11.377", "Europe/Berlin"),
("2855047", "Peine", "Пайне", "DE", "276", "06", "00", "03157", "03157006", "52.31928", "10.2352", "Europe/Berlin"),
("2855328", "Passau", "Пассау", "DE", "276", "02", "092", "09262", "09262000", "48.5665", "13.43122", "Europe/Berlin"),
("2855441", "Parchim", "Пархим", "DE", "276", "12", "00", "13076", "", "53.42631", "11.84875", "Europe/Berlin"),
("2855525", "Papenburg", "Папенбург", "DE", "276", "06", "", "", "", "53.07738", "7.40444", "Europe/Berlin"),
("2855598", "Pankow", "Панков", "DE", "276", "16", "00", "11000", "11000000", "52.56926", "13.40186", "Europe/Berlin"),
("2855745", "Paderborn", "Падерборн", "DE", "276", "07", "057", "05774", "", "51.71905", "8.75439", "Europe/Berlin"),
("2855794", "Oyten", "", "DE", "276", "06", "00", "03361", "03361009", "53.05", "9.01667", "Europe/Berlin"),
("2855859", "Overath", "Оверат", "DE", "276", "07", "053", "", "", "50.93275", "7.28389", "Europe/Berlin"),
("2855917", "Ottweiler", "Отвайлер", "DE", "276", "09", "00", "10043", "", "49.40133", "7.16424", "Europe/Berlin"),
("2855935", "Ottobrunn", "Оттобрунн", "DE", "276", "02", "091", "09184", "09184136", "48.06489", "11.66327", "Europe/Berlin"),
("2856500", "Osterholz-Scharmbeck", "Остерхольц-Шармбек", "DE", "276", "06", "00", "03356", "", "53.22698", "8.79528", "Europe/Berlin"),
("2856883", "Osnabrueck", "Оснабрюк", "DE", "276", "06", "00", "03459", "", "52.27264", "8.0498", "Europe/Berlin"),
("2856930", "Oschersleben", "Ошерслебен", "DE", "276", "14", "", "", "", "52.0304", "11.22898", "Europe/Berlin"),
("2856944", "Oschatz", "Ошац", "DE", "276", "13", "", "", "", "51.30001", "13.10984", "Europe/Berlin"),
("2857129", "Oranienburg", "Ораниенбург", "DE", "276", "11", "00", "12065", "", "52.75577", "13.24197", "Europe/Berlin"),
("2857185", "Opladen", "Опладен", "DE", "276", "07", "", "", "", "51.05521", "7.01931", "Europe/Berlin"),
("2857291", "Olsberg", "Ольсберг", "DE", "276", "07", "059", "", "", "51.35613", "8.48899", "Europe/Berlin"),
("2857306", "Olpe", "Ольпе", "DE", "276", "07", "059", "05966", "", "51.02899", "7.85139", "Europe/Berlin"),
("2857458", "Oldenburg", "Ольденбург", "DE", "276", "06", "00", "03403", "", "53.14118", "8.21467", "Europe/Berlin"),
("2857472", "Olching", "Ольхинг", "DE", "276", "02", "091", "09179", "09179142", "48.2", "11.33333", "Europe/Berlin"),
("2857565", "Ohringen", "Эринген", "DE", "276", "01", "081", "08126", "08126066", "49.19884", "9.5072", "Europe/Berlin"),
("2857798", "Offenburg", "Оффенбург", "DE", "276", "01", "083", "08317", "08317096", "48.47377", "7.94495", "Europe/Berlin"),
("2857807", "Offenbach", "", "DE", "276", "05", "064", "06438", "", "50.1006", "8.76647", "Europe/Berlin"),
("2857900", "Oerlinghausen", "Эрлингхаузен", "DE", "276", "07", "057", "", "", "51.95453", "8.6622", "Europe/Berlin"),
("2857904", "Oer-Erkenschwick", "Ор-Эркеншвик", "DE", "276", "07", "", "", "", "51.64198", "7.26451", "Europe/Berlin"),
("2857943", "Oelde", "Ольде", "DE", "276", "07", "", "", "", "51.8289", "8.14724", "Europe/Berlin"),
("2858103", "Odenthal", "Оденталь", "DE", "276", "07", "053", "05378", "05378020", "51.03333", "7.11667", "Europe/Berlin"),
("2858245", "Ochtrup", "Охтруп", "DE", "276", "07", "055", "", "", "52.20802", "7.18988", "Europe/Berlin"),
("2858738", "Oberursel", "", "DE", "276", "05", "064", "", "", "50.20731", "8.57747", "Europe/Berlin"),
("2858763", "Obertshausen", "Обертсхаузен", "DE", "276", "05", "", "", "", "50.07139", "8.85123", "Europe/Berlin"),
("2859103", "Oberschoneweide", "", "DE", "276", "16", "00", "11000", "11000000", "52.46106", "13.52108", "Europe/Berlin"),
("2859380", "Ober-Ramstadt", "Обер-Рамштадт", "DE", "276", "05", "", "", "", "49.83078", "8.74887", "Europe/Berlin"),
("2860080", "Oberkirch", "Оберкирх", "DE", "276", "01", "083", "08317", "08317089", "48.53241", "8.07864", "Europe/Berlin"),
("2860410", "Oberhausen", "Оберхаузен", "DE", "276", "07", "051", "05119", "", "51.47311", "6.88074", "Europe/Berlin"),
("2861402", "Oberasbach", "", "DE", "276", "02", "095", "09573", "09573122", "49.42275", "10.95766", "Europe/Berlin"),
("2861632", "Nurtingen", "Нюртинген", "DE", "276", "01", "081", "08116", "08116049", "48.62565", "9.34203", "Europe/Berlin"),
("2861650", "Nuernberg", "Нюрнберг", "DE", "276", "02", "095", "09564", "09564000", "49.45421", "11.07752", "Europe/Berlin"),
("2861677", "Numbrecht", "Нюмбрехт", "DE", "276", "07", "053", "05374", "05374032", "50.9", "7.55", "Europe/Berlin"),
("2861733", "Nottuln", "Ноттульн", "DE", "276", "07", "055", "05558", "05558032", "51.93333", "7.35", "Europe/Berlin"),
("2861814", "Northeim", "Нортхайм", "DE", "276", "06", "00", "03155", "", "51.70662", "9.99998", "Europe/Berlin"),
("2861914", "Noerdlingen", "Нёрдлинген", "DE", "276", "02", "097", "09779", "09779194", "48.85122", "10.48868", "Europe/Berlin"),
("2861934", "Nordhorn", "Нордхорн", "DE", "276", "06", "00", "03456", "", "52.43081", "7.06833", "Europe/Berlin"),
("2861982", "Nordhausen", "Нордхаузен", "DE", "276", "15", "00", "16062", "", "51.5018", "10.7957", "Europe/Berlin"),
("2862026", "Norderstedt", "Нордерштедт", "DE", "276", "10", "", "", "", "53.6859", "9.98041", "Europe/Berlin"),
("2862104", "Nordenham", "Норденхаме", "DE", "276", "06", "", "", "", "53.4861", "8.48093", "Europe/Berlin"),
("2862118", "Norden", "Норден", "DE", "276", "06", "", "", "", "53.59552", "7.20639", "Europe/Berlin"),
("2862423", "Nikolassee", "", "DE", "276", "16", "00", "11000", "11000000", "52.4344", "13.20095", "Europe/Berlin"),
("2862620", "Nienburg", "Нинбург", "DE", "276", "06", "00", "03256", "", "52.6461", "9.22086", "Europe/Berlin"),
("2862888", "Niederschonhausen", "Нидершёнхаузен", "DE", "276", "16", "00", "11000", "11000000", "52.58483", "13.40272", "Europe/Berlin"),
("2863199", "Niederkruchten", "", "DE", "276", "07", "051", "05166", "05166020", "51.2", "6.21667", "Europe/Berlin"),
("2863223", "Niederkassel", "Нидеркассель", "DE", "276", "07", "", "", "", "50.81503", "7.03777", "Europe/Berlin"),
("2863240", "Nieder-Ingelheim", "", "DE", "276", "08", "", "", "", "49.97756", "8.07246", "Europe/Berlin"),
("2863712", "Nidderau", "Ниддерау", "DE", "276", "05", "", "", "", "50.23805", "8.86704", "Europe/Berlin"),
("2863716", "Nidda", "Нидда", "DE", "276", "05", "064", "", "", "50.4133", "9.00638", "Europe/Berlin"),
("2863795", "Neu Wulmstorf", "", "DE", "276", "06", "00", "03353", "03353026", "53.46667", "9.8", "Europe/Berlin"),
("2863840", "Neuwied", "Нойвид", "DE", "276", "08", "00", "07138", "", "50.4336", "7.47057", "Europe/Berlin"),
("2863941", "Neu-Ulm", "Ной-Ульм", "DE", "276", "02", "097", "09775", "09775135", "48.39279", "10.01112", "Europe/Berlin"),
("2864005", "Neustrelitz", "Нойштрелице", "DE", "276", "12", "", "", "", "53.3613", "13.07292", "Europe/Berlin"),
("2864034", "Neustadt in Holstein", "Нойштадт", "DE", "276", "10", "", "", "", "54.10707", "10.8145", "Europe/Berlin"),
("2864053", "Neustadt bei Coburg", "Нойштадт-Кобург", "DE", "276", "02", "094", "09473", "09473151", "50.32975", "11.12058", "Europe/Berlin"),
("2864054", "Neustadt", "Нойштадт-ан-дер-Вайнштрассе", "DE", "276", "08", "00", "07316", "", "49.35009", "8.13886", "Europe/Berlin"),
("2864058", "Neustadt am Rubenberge", "Нойштадт-ам-Рюбенберге", "DE", "276", "06", "", "", "", "52.50462", "9.45871", "Europe/Berlin"),
("2864072", "Neue Neustadt", "Нойштадт", "DE", "276", "14", "", "", "", "52.15", "11.63333", "Europe/Berlin"),
("2864118", "Neuss", "Нойс", "DE", "276", "07", "051", "05162", "", "51.19807", "6.68504", "Europe/Berlin"),
("2864276", "Neuruppin", "Нойруппин", "DE", "276", "11", "00", "12068", "", "52.92815", "12.80311", "Europe/Berlin"),
("2864435", "Neunkirchen", "Нойнкирхен", "DE", "276", "09", "00", "10043", "", "49.34449", "7.18045", "Europe/Berlin"),
("2864475", "Neumunster", "Ноймюнстер", "DE", "276", "10", "00", "01004", "", "54.07477", "9.98195", "Europe/Berlin"),
("2864549", "Neumarkt in der Oberpfalz", "Ноймаркт", "DE", "276", "02", "093", "09373", "09373113", "49.28028", "11.46278", "Europe/Berlin"),
("2864820", "Neu Isenburg", "Ной-Изенбург", "DE", "276", "05", "064", "", "", "50.04832", "8.69406", "Europe/Berlin"),
("2865376", "Neufahrn bei Freising", "", "DE", "276", "02", "091", "09178", "09178145", "48.31588", "11.66316", "Europe/Berlin"),
("2865716", "Neuenhagen", "", "DE", "276", "11", "", "", "", "52.52985", "13.68914", "Europe/Berlin"),
("2866070", "Neuburg an der Donau", "Нойбург-ан-дер-Донау", "DE", "276", "02", "091", "09185", "09185149", "48.73218", "11.18709", "Europe/Berlin"),
("2866110", "Neubrueck", "", "DE", "276", "07", "051", "", "", "51.13434", "6.63857", "Europe/Berlin"),
("2866135", "Neubrandenburg", "Нойбранденбурге", "DE", "276", "12", "00", "13071", "", "53.56414", "13.27532", "Europe/Berlin"),
("2866280", "Neu-Anspach", "Ной-Анспах", "DE", "276", "05", "064", "06434", "06434007", "50.31667", "8.5", "Europe/Berlin"),
("2866333", "Nettetal", "Неттеталь", "DE", "276", "07", "051", "05166", "05166016", "51.31667", "6.28333", "Europe/Berlin"),
("2866375", "Netphen", "Нетфен", "DE", "276", "07", "", "", "", "50.91667", "8.1", "Europe/Berlin"),
("2866758", "Neckarsulm", "Неккарзульм", "DE", "276", "01", "081", "08125", "08125065", "49.18912", "9.22528", "Europe/Berlin"),
("2866906", "Naumburg", "Наумбург", "DE", "276", "14", "00", "15084", "", "51.14987", "11.80979", "Europe/Berlin"),
("2866930", "Nauen", "Науэн", "DE", "276", "11", "", "", "", "52.60701", "12.87374", "Europe/Berlin"),
("2867164", "Nagold", "Нагольд", "DE", "276", "01", "082", "08235", "08235046", "48.5498", "8.72366", "Europe/Berlin"),
("2867542", "Munster", "Мунстер", "DE", "276", "06", "", "", "", "52.98569", "10.08756", "Europe/Berlin"),
("2867543", "Muenster", "Мюнстер", "DE", "276", "07", "055", "", "", "51.96236", "7.62571", "Europe/Berlin"),
("2867613", "Hannoversch Munden", "", "DE", "276", "06", "", "", "", "51.41505", "9.65046", "Europe/Berlin"),
("2867714", "Munich", "Мюнхен", "DE", "276", "02", "091", "09162", "09162000", "48.13743", "11.57549", "Europe/Berlin"),
("2867770", "Mullheim", "Мюльхайм", "DE", "276", "01", "083", "08315", "08315074", "47.8082", "7.63035", "Europe/Berlin"),
("2867838", "Muelheim (Ruhr)", "Мюльхайм-на-Руре", "DE", "276", "07", "051", "", "", "51.43333", "6.88333", "Europe/Berlin"),
("2867985", "Muehlheim am Main", "Мюльхайм-на-Майне", "DE", "276", "05", "064", "", "", "50.11667", "8.83333", "Europe/Berlin"),
("2867993", "Stuttgart Muehlhausen", "", "DE", "276", "01", "081", "08111", "08111000", "48.84232", "9.23028", "Europe/Berlin"),
("2867996", "Muehlhausen", "Мюльхаузен", "DE", "276", "15", "00", "16064", "", "51.20896", "10.45275", "Europe/Berlin"),
("2868506", "Muehldorf", "", "DE", "276", "02", "091", "09183", "09183128", "48.2467", "12.52155", "Europe/Berlin"),
("2868788", "Muhlacker", "Мюлакер", "DE", "276", "01", "082", "08236", "08236040", "48.94754", "8.83675", "Europe/Berlin"),
("2868936", "Much", "", "DE", "276", "07", "053", "05382", "05382036", "50.91667", "7.4", "Europe/Berlin"),
("2869019", "Mossingen", "Мёссинген", "DE", "276", "01", "084", "08416", "08416025", "48.40567", "9.05419", "Europe/Berlin"),
("2869120", "Mosbach", "", "DE", "276", "01", "082", "08225", "08225058", "49.35357", "9.15106", "Europe/Berlin"),
("2869449", "Moosburg", "", "DE", "276", "02", "091", "09178", "09178143", "48.47089", "11.93811", "Europe/Berlin"),
("2869791", "Monheim am Rhein", "", "DE", "276", "07", "", "", "", "51.09162", "6.89218", "Europe/Berlin"),
("2869894", "Monchengladbach", "Мёнхенгладбах", "DE", "276", "07", "051", "05116", "", "51.18539", "6.44172", "Europe/Berlin"),
("2869994", "Molln", "Мёльн", "DE", "276", "10", "", "", "", "53.61702", "10.68742", "Europe/Berlin"),
("2870221", "Moers", "Мерс", "DE", "276", "07", "051", "", "", "51.45342", "6.6326", "Europe/Berlin"),
("2870310", "Moabit", "Моабит", "DE", "276", "16", "00", "11000", "11000000", "52.52635", "13.33903", "Europe/Berlin"),
("2870318", "Mittweida", "Митвайда", "DE", "276", "13", "", "", "", "50.98622", "12.97538", "Europe/Berlin"),
("2871039", "Minden", "Минден", "DE", "276", "07", "057", "05770", "", "52.28953", "8.91455", "Europe/Berlin"),
("2871284", "Michelstadt", "Михельштадт", "DE", "276", "05", "", "", "", "49.67569", "9.00373", "Europe/Berlin"),
("2871486", "Metzingen", "Метцинген", "DE", "276", "01", "084", "08415", "08415050", "48.53695", "9.2833", "Europe/Berlin"),
("2871535", "Mettmann", "Меттман", "DE", "276", "07", "051", "05158", "", "51.2504", "6.97536", "Europe/Berlin"),
("2871668", "Meschede", "Мешеде", "DE", "276", "07", "059", "05958", "", "51.3502", "8.28332", "Europe/Berlin"),
("2871675", "Merzig", "Мерциге", "DE", "276", "09", "00", "10042", "", "49.44331", "6.63874", "Europe/Berlin"),
("2871736", "Merseburg", "Мерзебург", "DE", "276", "14", "00", "15088", "", "51.35478", "11.98923", "Europe/Berlin"),
("2871845", "Meppen", "Меппен", "DE", "276", "06", "00", "03454", "", "52.69064", "7.29097", "Europe/Berlin"),
("2871983", "Menden", "Менден", "DE", "276", "07", "059", "", "", "51.44337", "7.77824", "Europe/Berlin"),
("2871992", "Memmingen", "Мемминген", "DE", "276", "02", "097", "09764", "09764000", "47.98372", "10.18527", "Europe/Berlin"),
("2872079", "Melle", "Мелле", "DE", "276", "06", "", "", "", "52.20197", "8.33826", "Europe/Berlin"),
("2872155", "Meissen", "Мейсен", "DE", "276", "13", "00", "14627", "", "51.16158", "13.4737", "Europe/Berlin"),
("2872225", "Meiningen", "Майнинген", "DE", "276", "15", "00", "16066", "", "50.56787", "10.41521", "Europe/Berlin"),
("2872237", "Meinerzhagen", "Майнерцхаген", "DE", "276", "07", "", "", "", "51.1074", "7.64838", "Europe/Berlin"),
("2872347", "Meiderich", "", "DE", "276", "07", "", "", "", "51.46667", "6.76667", "Europe/Berlin"),
("2872504", "Meerbusch", "Мербуш", "DE", "276", "07", "051", "", "", "51.26118", "6.6717", "Europe/Berlin"),
("2872519", "Meerane", "Меране", "DE", "276", "13", "00", "", "", "50.84688", "12.46473", "Europe/Berlin"),
("2872582", "Meckenheim", "Меккенхайм", "DE", "276", "07", "", "", "", "50.62388", "7.02942", "Europe/Berlin"),
("2872611", "Mechernich", "Мехерних", "DE", "276", "07", "053", "", "", "50.59304", "6.65224", "Europe/Berlin"),
("2872649", "Mayen", "Майен", "DE", "276", "08", "", "", "", "50.32797", "7.22277", "Europe/Berlin"),
("2873074", "Marzahn", "", "DE", "276", "16", "00", "11000", "11000000", "52.54525", "13.56983", "Europe/Berlin"),
("2873211", "Marsberg", "Марсберг", "DE", "276", "07", "", "", "", "51.46171", "8.84949", "Europe/Berlin"),
("2873263", "Marl", "Марль", "DE", "276", "07", "", "", "", "51.65671", "7.09038", "Europe/Berlin"),
("2873289", "Marktredwitz", "Марктредвиц", "DE", "276", "02", "094", "09479", "09479136", "50.00443", "12.08593", "Europe/Berlin"),
("2873291", "Marktoberdorf", "Марктобердорф", "DE", "276", "02", "097", "09777", "09777151", "47.77964", "10.61713", "Europe/Berlin"),
("2873351", "Markkleeberg West", "", "DE", "276", "13", "", "", "", "51.28333", "12.36667", "Europe/Berlin"),
("2873356", "Markisches Viertel", "", "DE", "276", "16", "00", "11000", "11000000", "52.59841", "13.35766", "Europe/Berlin"),
("2873589", "Marienfelde", "", "DE", "276", "16", "00", "11000", "11000000", "52.41868", "13.36723", "Europe/Berlin"),
("2873606", "Mariendorf", "Мариендорф", "DE", "276", "16", "00", "11000", "11000000", "52.4378", "13.38109", "Europe/Berlin"),
("2873759", "Marburg an der Lahn", "Марбург", "DE", "276", "05", "065", "06534", "", "50.80904", "8.77069", "Europe/Berlin"),
("2873776", "Marbach am Neckar", "Марбах-на-Неккаре", "DE", "276", "01", "081", "08118", "08118049", "48.93964", "9.25995", "Europe/Berlin"),
("2873891", "Mannheim", "Мангейм", "DE", "276", "01", "082", "08222", "08222000", "49.49671", "8.47955", "Europe/Berlin"),
("2874225", "Mainz", "Майнц", "DE", "276", "08", "", "", "", "49.98419", "8.2791", "Europe/Berlin"),
("2874230", "Maintal", "Майнталь", "DE", "276", "05", "064", "", "", "50.15", "8.83333", "Europe/Berlin"),
("2874455", "Mahlsdorf", "", "DE", "276", "16", "00", "11000", "11000000", "52.50935", "13.61373", "Europe/Berlin"),
("2874545", "Magdeburg", "Магдебург", "DE", "276", "14", "00", "15003", "15003000", "52.12773", "11.62916", "Europe/Berlin"),
("2875107", "Lunen", "Люнен", "DE", "276", "07", "", "", "", "51.61634", "7.52872", "Europe/Berlin"),
("2875115", "Lueneburg", "Люнебург", "DE", "276", "06", "00", "03355", "", "53.2509", "10.41409", "Europe/Berlin"),
("2875376", "Ludwigshafen am Rhein", "Людвигсхафен-на-Рейне", "DE", "276", "08", "00", "07338", "", "49.48121", "8.44641", "Europe/Berlin"),
("2875379", "Ludwigsfelde", "Людвигсфельде", "DE", "276", "11", "", "", "", "52.30322", "13.25405", "Europe/Berlin"),
("2875392", "Ludwigsburg", "Людвигсбург", "DE", "276", "01", "081", "08118", "08118048", "48.89731", "9.19161", "Europe/Berlin"),
("2875417", "Ludinghausen", "Людингхаузен", "DE", "276", "07", "", "", "", "51.7683", "7.44379", "Europe/Berlin"),
("2875457", "Luedenscheid", "Люденшайд", "DE", "276", "07", "059", "05962", "", "51.21977", "7.6273", "Europe/Berlin"),
("2875484", "Luckenwalde", "Луккенвальде", "DE", "276", "11", "00", "12072", "", "52.09029", "13.16772", "Europe/Berlin"),
("2875601", "Luebeck", "Любек", "DE", "276", "10", "00", "01003", "", "53.86893", "10.68729", "Europe/Berlin"),
("2875623", "Lubbenau", "Люббенау", "DE", "276", "11", "", "", "", "51.86217", "13.95168", "Europe/Berlin"),
("2875626", "Lubbecke", "Люббекке", "DE", "276", "07", "", "", "", "52.30699", "8.61423", "Europe/Berlin"),
("2875645", "Loxstedt", "Локсштедт", "DE", "276", "06", "00", "03352", "03352032", "53.46667", "8.65", "Europe/Berlin"),
("2875831", "Losheim", "", "DE", "276", "09", "", "", "", "49.5099", "6.74549", "Europe/Berlin"),
("2875881", "Loerrach", "Лёррах", "DE", "276", "01", "083", "08336", "08336050", "47.61497", "7.66457", "Europe/Berlin"),
("2876147", "Lohr am Main", "Лор-на-Майне", "DE", "276", "02", "096", "09677", "09677155", "49.98922", "9.57223", "Europe/Berlin"),
("2876185", "Lohne", "", "DE", "276", "06", "", "", "", "52.66625", "8.2375", "Europe/Berlin"),
("2876218", "Lohmar", "Ломар", "DE", "276", "07", "", "", "", "50.83868", "7.21399", "Europe/Berlin"),
("2876755", "Lobau", "Лёбау", "DE", "276", "13", "", "", "", "51.09954", "14.66738", "Europe/Berlin"),
("2876865", "Lippstadt", "Липпштадте", "DE", "276", "07", "059", "", "", "51.67369", "8.34482", "Europe/Berlin"),
("2877088", "Lingen", "Линген", "DE", "276", "06", "", "", "", "52.52143", "7.31845", "Europe/Berlin"),
("2877142", "Lindlar", "Линдлар", "DE", "276", "07", "053", "05374", "05374020", "51.01959", "7.37758", "Europe/Berlin"),
("2877550", "Lindau", "Линдау", "DE", "276", "02", "097", "09776", "09776116", "47.54612", "9.68431", "Europe/Berlin"),
("2877648", "Limburg an der Lahn", "Лимбург-на-Лане", "DE", "276", "05", "065", "06533", "", "50.3836", "8.0503", "Europe/Berlin"),
("2877673", "Limbach-Oberfrohna", "Лимбах-Оберфрона", "DE", "276", "13", "00", "", "", "50.85882", "12.76165", "Europe/Berlin"),
("2877709", "Lilienthal", "Лилиенталь", "DE", "276", "06", "00", "03356", "03356005", "53.13333", "8.91667", "Europe/Berlin"),
("2878018", "Lichterfelde", "", "DE", "276", "16", "00", "11000", "11000000", "52.4333", "13.30762", "Europe/Berlin"),
("2878044", "Lichtenrade", "", "DE", "276", "16", "00", "11000", "11000000", "52.39844", "13.40637", "Europe/Berlin"),
("2878074", "Lichtenfels", "Лихтенфельс", "DE", "276", "02", "094", "09478", "09478139", "50.14567", "11.05928", "Europe/Berlin"),
("2878102", "Lichtenberg", "", "DE", "276", "16", "00", "11000", "11000000", "52.51395", "13.49975", "Europe/Berlin"),
("2878234", "Leverkusen", "Леверкузен", "DE", "276", "07", "053", "05316", "", "51.0303", "6.98432", "Europe/Berlin"),
("2878270", "Leutkirch im Allgau", "Лойткирх", "DE", "276", "01", "084", "08436", "08436055", "47.82672", "10.0205", "Europe/Berlin"),
("2878673", "Leopoldshohe", "Леопольдсхёэ", "DE", "276", "07", "057", "05766", "05766048", "52.01246", "8.69834", "Europe/Berlin"),
("2878695", "Leonberg", "Леонберг", "DE", "276", "01", "081", "08115", "08115028", "48.8", "9.01667", "Europe/Berlin"),
("2878784", "Lennestadt", "Леннештадт", "DE", "276", "07", "059", "", "", "51.11721", "8.06707", "Europe/Berlin"),
("2878840", "Lengerich", "", "DE", "276", "07", "", "", "", "52.18661", "7.86043", "Europe/Berlin"),
("2878943", "Lemgo", "Лемго", "DE", "276", "07", "057", "05766", "", "52.02786", "8.89901", "Europe/Berlin"),
("2879139", "Leipzig", "Лейпциг", "DE", "276", "13", "00", "14713", "14713000", "51.33962", "12.37129", "Europe/Berlin"),
("2879185", "Leinfelden-Echterdingen", "Лайнфельден-Эхтердинген", "DE", "276", "01", "081", "08116", "08116078", "48.69406", "9.16809", "Europe/Berlin"),
("2879241", "Leimen", "Лаймен", "DE", "276", "01", "082", "08226", "08226041", "49.34737", "8.68733", "Europe/Berlin"),
("2879315", "Leichlingen", "Лайхлинген", "DE", "276", "07", "", "", "", "51.10628", "7.01873", "Europe/Berlin"),
("2879367", "Lehrte", "Лерте", "DE", "276", "06", "", "", "", "52.37539", "9.97155", "Europe/Berlin"),
("2879697", "Leer", "Лер", "DE", "276", "06", "00", "03457", "", "53.23157", "7.461", "Europe/Berlin"),
("2879832", "Lebach", "Лебах", "DE", "276", "09", "", "", "", "49.41122", "6.90988", "Europe/Berlin"),
("2880077", "Laupheim", "Лаупхайм", "DE", "276", "01", "084", "08426", "08426070", "48.22786", "9.87874", "Europe/Berlin"),
("2880144", "Lauf an der Pegnitz", "Лауф-ан-дер-Пегниц", "DE", "276", "02", "095", "09574", "09574138", "49.51386", "11.28247", "Europe/Berlin"),
("2880221", "Lauchhammer", "Лауххаммер", "DE", "276", "11", "", "", "", "51.48813", "13.76623", "Europe/Berlin"),
("2880498", "Lankwitz", "Ланквиц", "DE", "276", "16", "00", "11000", "11000000", "52.43623", "13.3459", "Europe/Berlin"),
("2881018", "Langenhorn", "", "DE", "276", "04", "", "", "", "53.66556", "10.00137", "Europe/Berlin"),
("2881062", "Langenhagen", "Лангенхаген", "DE", "276", "06", "", "", "", "52.44758", "9.73741", "Europe/Berlin"),
("2881085", "Langenfeld", "Лангенфельд", "DE", "276", "07", "051", "", "", "51.10821", "6.94831", "Europe/Berlin"),
("2881276", "Langen", "", "DE", "276", "06", "", "", "", "53.60554", "8.59509", "Europe/Berlin"),
("2881279", "Langen", "Ланген", "DE", "276", "05", "", "", "", "49.98955", "8.66852", "Europe/Berlin"),
("2881485", "Landshut", "Ландсхут", "DE", "276", "02", "092", "09261", "09261000", "48.52961", "12.16179", "Europe/Berlin"),
("2881509", "Landsberg am Lech", "Ландсберг-на-Лехе", "DE", "276", "02", "091", "09181", "09181130", "48.04819", "10.88282", "Europe/Berlin"),
("2881646", "Landau in der Pfalz", "Ландау", "DE", "276", "08", "00", "07337", "", "49.19844", "8.11692", "Europe/Berlin"),
("2881695", "Lampertheim", "Лампертхайм", "DE", "276", "05", "", "", "", "49.59786", "8.4725", "Europe/Berlin"),
("2881885", "Lahr", "Лар", "DE", "276", "01", "083", "08317", "08317065", "48.34042", "7.86886", "Europe/Berlin"),
("2881889", "Lahnstein", "Ланштайн", "DE", "276", "08", "", "", "", "50.3", "7.61667", "Europe/Berlin"),
("2881956", "Lage", "Лаге", "DE", "276", "07", "057", "", "", "51.99223", "8.79301", "Europe/Berlin"),
("2882087", "Laatzen", "Латцен", "DE", "276", "06", "", "", "", "52.31506", "9.79739", "Europe/Berlin"),
("2882091", "Bad Laasphe", "Бад-Ласфе", "DE", "276", "07", "059", "", "", "50.93139", "8.42502", "Europe/Berlin"),
("2882318", "Kurten", "Кюртен", "DE", "276", "07", "053", "05378", "05378012", "51.05", "7.26667", "Europe/Berlin"),
("2882439", "Kuenzelsau", "Кюнцельзау", "DE", "276", "01", "081", "08126", "08126046", "49.2818", "9.68352", "Europe/Berlin"),
("2882440", "Kunzell", "", "DE", "276", "05", "066", "06631", "06631017", "50.5442", "9.71792", "Europe/Berlin"),
("2882588", "Kulmbach", "Кульмбах", "DE", "276", "02", "094", "09477", "09477128", "50.10068", "11.45032", "Europe/Berlin"),
("2883754", "Kronberg", "", "DE", "276", "05", "064", "", "", "50.18424", "8.5232", "Europe/Berlin"),
("2883784", "Kronach", "Кронах", "DE", "276", "02", "094", "09476", "09476145", "50.23963", "11.33308", "Europe/Berlin"),
("2884050", "Kreuztal", "Кройцталь", "DE", "276", "07", "", "", "", "50.96775", "7.98848", "Europe/Berlin"),
("2884161", "Bezirk Kreuzberg", "", "DE", "276", "16", "00", "11000", "11000000", "52.49973", "13.40338", "Europe/Berlin"),
("2884245", "Kreuzau", "Кройцау", "DE", "276", "07", "053", "05358", "05358028", "50.74699", "6.49069", "Europe/Berlin"),
("2884509", "Krefeld", "Крефельд", "DE", "276", "07", "051", "05114", "", "51.33921", "6.58615", "Europe/Berlin"),
("2885237", "Koethen", "Кётен", "DE", "276", "14", "00", "15082", "", "51.75186", "11.97093", "Europe/Berlin"),
("2885397", "Korschenbroich", "Коршенбройх", "DE", "276", "07", "051", "", "", "51.19139", "6.51352", "Europe/Berlin"),
("2885408", "Kornwestheim", "Корнвестхайм", "DE", "276", "01", "081", "08118", "08118046", "48.86158", "9.18569", "Europe/Berlin"),
("2885412", "Korntal", "", "DE", "276", "01", "081", "08118", "08118080", "48.83218", "9.1214", "Europe/Berlin"),
("2885536", "Korbach", "Корбах", "DE", "276", "05", "066", "06635", "", "51.27561", "8.873", "Europe/Berlin"),
("2885656", "Kopenick Bezirk", "Кёпеник", "DE", "276", "16", "00", "11000", "11000000", "52.4455", "13.57455", "Europe/Berlin"),
("2885657", "Berlin Koepenick", "", "DE", "276", "16", "00", "11000", "11000000", "52.44254", "13.58228", "Europe/Berlin"),
("2885672", "Konz", "Конц", "DE", "276", "08", "", "", "", "49.70045", "6.57652", "Europe/Berlin"),
("2885679", "Konstanz", "Констанц", "DE", "276", "01", "083", "08335", "08335043", "47.66033", "9.17582", "Europe/Berlin"),
("2885732", "Konigs Wusterhausen", "Кёнигс-Вустерхаузен", "DE", "276", "11", "", "", "", "52.30141", "13.633", "Europe/Berlin"),
("2885734", "Konigswinter", "Кёнигсвинтер", "DE", "276", "07", "053", "", "", "50.68376", "7.18675", "Europe/Berlin"),
("2885760", "Konigstein im Taunus", "Кёнигштайн", "DE", "276", "05", "064", "06434", "06434005", "50.17943", "8.47132", "Europe/Berlin"),
("2885800", "Konigslutter am Elm", "Кёнигслуттер-ам-Эльм", "DE", "276", "06", "", "", "", "52.25116", "10.81683", "Europe/Berlin"),
("2885908", "Konigsbrunn", "", "DE", "276", "02", "097", "09772", "09772163", "48.27506", "10.89178", "Europe/Berlin"),
("2886242", "Koeln", "Кёльн", "DE", "276", "07", "053", "05315", "05315000", "50.93333", "6.95", "Europe/Berlin"),
("2886446", "Kolbermoor", "Кольбермор", "DE", "276", "02", "091", "09187", "09187150", "47.84965", "12.06696", "Europe/Berlin"),
("2886946", "Koblenz", "Кобленц", "DE", "276", "08", "00", "07137", "", "50.35357", "7.57884", "Europe/Berlin"),
("2887835", "Kleve", "Клеве", "DE", "276", "07", "051", "05154", "", "51.78826", "6.13865", "Europe/Berlin"),
("2888523", "Kleinmachnow", "Клайнмахнов", "DE", "276", "11", "00", "12069", "12069304", "52.40786", "13.22514", "Europe/Berlin"),
("2890158", "Kitzingen", "Китцинген", "DE", "276", "02", "096", "09675", "09675141", "49.73973", "10.15072", "Europe/Berlin"),
("2890425", "Kirchlengern", "Кирхленгерн", "DE", "276", "07", "057", "05758", "05758020", "52.2", "8.63333", "Europe/Berlin"),
("2890473", "Kirchheim unter Teck", "Кирхгайм-унтер-Тек", "DE", "276", "01", "081", "08116", "08116033", "48.64683", "9.45378", "Europe/Berlin"),
("2890504", "Kirchhain", "Кирхгайн", "DE", "276", "05", "065", "", "", "50.8272", "8.92806", "Europe/Berlin"),
("2891014", "Kierspe", "Кирспе", "DE", "276", "07", "", "", "", "51.13402", "7.59075", "Europe/Berlin"),
("2891122", "Kiel", "Киль", "DE", "276", "10", "", "", "", "54.32133", "10.13489", "Europe/Berlin"),
("2891258", "Kevelaer", "Кевелар", "DE", "276", "07", "051", "", "", "51.58243", "6.24603", "Europe/Berlin"),
("2891524", "Kerpen", "Керпен", "DE", "276", "07", "053", "", "", "50.86991", "6.69691", "Europe/Berlin"),
("2891621", "Kempten (Allgaeu)", "", "DE", "276", "02", "097", "09763", "09763000", "47.72674", "10.31389", "Europe/Berlin"),
("2891643", "Kempen", "Кемпен", "DE", "276", "07", "", "", "", "51.36432", "6.41858", "Europe/Berlin"),
("2891832", "Kelkheim (Taunus)", "", "DE", "276", "05", "", "", "", "50.13703", "8.4502", "Europe/Berlin"),
("2891834", "Kelheim", "Кельхайм", "DE", "276", "02", "092", "09273", "09273137", "48.91725", "11.88618", "Europe/Berlin"),
("2891951", "Kehl", "Кель", "DE", "276", "01", "083", "08317", "08317057", "48.57297", "7.81523", "Europe/Berlin"),
("2892051", "Kaulsdorf", "", "DE", "276", "16", "00", "11000", "11000000", "52.51732", "13.58871", "Europe/Berlin"),
("2892080", "Kaufbeuren", "Кауфбойрен", "DE", "276", "02", "097", "09762", "09762000", "47.88238", "10.62192", "Europe/Berlin"),
("2892518", "Kassel", "Кассель", "DE", "276", "05", "066", "06611", "", "51.31667", "9.5", "Europe/Berlin"),
("2892705", "Karow", "", "DE", "276", "16", "00", "11000", "11000000", "52.60904", "13.48117", "Europe/Berlin"),
("2892786", "Karlstadt", "Карлштадт", "DE", "276", "02", "096", "09677", "09677148", "49.96034", "9.77239", "Europe/Berlin"),
("2892794", "Karlsruhe", "Карлсруэ", "DE", "276", "01", "082", "08212", "08212000", "49.00936", "8.40444", "Europe/Berlin"),
("2892811", "Karlshorst", "Карлсхорст", "DE", "276", "16", "00", "11000", "11000000", "52.48419", "13.53185", "Europe/Berlin"),
("2892874", "Karlsfeld", "", "DE", "276", "02", "091", "09174", "09174126", "48.21667", "11.46667", "Europe/Berlin"),
("2892980", "Karben", "Карбен", "DE", "276", "05", "064", "", "", "50.23019", "8.77155", "Europe/Berlin"),
("2893264", "Kamp-Lintfort", "Камп-Линтфорт", "DE", "276", "07", "051", "", "", "51.50467", "6.54588", "Europe/Berlin"),
("2893437", "Kamenz", "Каменц", "DE", "276", "13", "", "", "", "51.26798", "14.09374", "Europe/Berlin"),
("2893438", "Kamen", "Камен", "DE", "276", "07", "", "", "", "51.59231", "7.6638", "Europe/Berlin"),
("2893544", "Kaltenkirchen", "Кальтенкирхен", "DE", "276", "10", "", "", "", "53.83292", "9.9581", "Europe/Berlin"),
("2894003", "Kaiserslautern", "Кайзерслаутерн", "DE", "276", "08", "00", "07312", "", "49.443", "7.77161", "Europe/Berlin"),
("2894375", "Kaarst", "Карст", "DE", "276", "07", "051", "", "", "51.22929", "6.61882", "Europe/Berlin"),
("2894553", "Julich", "Юлих", "DE", "276", "07", "", "", "", "50.92149", "6.36267", "Europe/Berlin"),
("2894637", "Juchen", "Йюхен", "DE", "276", "07", "051", "05162", "05162012", "51.1", "6.5", "Europe/Berlin"),
("2894755", "Johannisthal", "", "DE", "276", "16", "00", "11000", "11000000", "52.44653", "13.5066", "Europe/Berlin"),
("2895044", "Jena", "Йена", "DE", "276", "15", "00", "16053", "", "50.92878", "11.5899", "Europe/Berlin"),
("2895569", "Itzehoe", "Итцехо", "DE", "276", "10", "00", "01061", "", "53.92099", "9.51529", "Europe/Berlin"),
("2895664", "Isernhagen Farster Bauerschaft", "", "DE", "276", "06", "", "", "", "52.47093", "9.84179", "Europe/Berlin"),
("2895669", "Iserlohn", "Изерлон", "DE", "276", "07", "", "", "", "51.37547", "7.70281", "Europe/Berlin"),
("2895992", "Ingolstadt", "Ингольштадт", "DE", "276", "02", "091", "09161", "09161000", "48.76508", "11.42372", "Europe/Berlin"),
("2896514", "Ilmenau", "Ильменау", "DE", "276", "15", "", "", "", "50.68322", "10.91858", "Europe/Berlin"),
("2896538", "Illingen", "", "DE", "276", "09", "", "", "", "49.37362", "7.04758", "Europe/Berlin"),
("2896546", "Illertissen", "Иллертиссен", "DE", "276", "02", "097", "09775", "09775129", "48.22336", "10.10347", "Europe/Berlin"),
("2896736", "Idstein", "Идштайн", "DE", "276", "05", "064", "", "", "50.21774", "8.26679", "Europe/Berlin"),
("2896753", "Idar-Oberstein", "Идар-Оберштайн", "DE", "276", "08", "", "", "", "49.71443", "7.30776", "Europe/Berlin"),
("2896817", "Ibbenburen", "Иббенбюрен", "DE", "276", "07", "", "", "", "52.27964", "7.71457", "Europe/Berlin"),
("2897132", "Husum", "Хузум", "DE", "276", "10", "00", "01054", "", "54.4858", "9.05239", "Europe/Berlin"),
("2897216", "Hurth", "Хюрт", "DE", "276", "07", "053", "", "", "50.87079", "6.86761", "Europe/Berlin"),
("2897436", "Hunfeld", "Хюнфельд", "DE", "276", "05", "066", "", "", "50.67966", "9.76727", "Europe/Berlin"),
("2897674", "Hummelsbuettel", "", "DE", "276", "04", "", "", "", "53.64773", "10.04149", "Europe/Berlin"),
("2898079", "Hude", "", "DE", "276", "06", "", "", "", "53.10766", "8.46322", "Europe/Berlin"),
("2898098", "Huckeswagen", "Хюккесваген", "DE", "276", "07", "", "", "", "51.1498", "7.34471", "Europe/Berlin"),
("2898111", "Huckelhoven", "Хюккельхофен", "DE", "276", "07", "", "", "", "51.0555", "6.22658", "Europe/Berlin"),
("2898304", "Hoyerswerda", "Хойерсверда", "DE", "276", "13", "", "", "", "51.43787", "14.23549", "Europe/Berlin"),
("2898321", "Hoexter", "Хёкстер", "DE", "276", "07", "057", "05762", "05762020", "51.77501", "9.38155", "Europe/Berlin"),
("2898364", "Hovelhof", "Хёфельхоф", "DE", "276", "07", "057", "05774", "05774024", "51.81667", "8.65", "Europe/Berlin"),
("2898603", "Horstel", "Хёрстель", "DE", "276", "07", "055", "", "", "52.29763", "7.58382", "Europe/Berlin"),
("2899101", "Horb am Neckar", "Хорб-на-Неккаре", "DE", "276", "01", "082", "08237", "08237040", "48.44423", "8.6913", "Europe/Berlin"),
("2899449", "Homburg", "", "DE", "276", "09", "00", "10045", "", "49.32637", "7.33867", "Europe/Berlin"),
("2899538", "Holzwickede", "Хольцвиккеде", "DE", "276", "07", "059", "05978", "05978016", "51.5", "7.63333", "Europe/Berlin"),
("2899601", "Holzminden", "Хольцминден", "DE", "276", "06", "00", "03255", "", "51.82798", "9.4455", "Europe/Berlin"),
("2899676", "Holzkirchen", "Хольцкирхен", "DE", "276", "02", "091", "09182", "09182120", "47.87663", "11.70181", "Europe/Berlin"),
("2901420", "Hohenstein-Ernstthal", "Хоэнштайн-Эрнстталь", "DE", "276", "13", "00", "", "", "50.80064", "12.71287", "Europe/Berlin"),
("2901588", "Hohen Neuendorf", "Хоэн-Нойендорф", "DE", "276", "11", "", "", "", "52.67631", "13.27775", "Europe/Berlin"),
("2902533", "Hofheim am Taunus", "Хофхайм-ам-Таунус", "DE", "276", "05", "064", "06436", "", "50.09019", "8.4493", "Europe/Berlin"),
("2902559", "Hofgeismar", "Хофгайсмар", "DE", "276", "05", "066", "", "", "51.49607", "9.385", "Europe/Berlin"),
("2902768", "Hof", "Хоф", "DE", "276", "02", "094", "09464", "09464000", "50.31622", "11.91833", "Europe/Berlin"),
("2902852", "Hockenheim", "Хоккенхайм", "DE", "276", "01", "082", "08226", "08226032", "49.32334", "8.55194", "Europe/Berlin"),
("2903175", "Hochheim am Main", "Хохгайм-на-Майне", "DE", "276", "05", "064", "", "", "50.01436", "8.35218", "Europe/Berlin"),
("2903237", "Hochfeld", "", "DE", "276", "07", "051", "05112", "05112000", "51.41943", "6.75462", "Europe/Berlin"),
("2904725", "Hille", "", "DE", "276", "07", "057", "05770", "05770012", "52.33333", "8.75", "Europe/Berlin"),
("2904789", "Hildesheim", "Хильдесхайм", "DE", "276", "06", "00", "03254", "", "52.15077", "9.95112", "Europe/Berlin"),
("2904795", "Hilden", "Хильден", "DE", "276", "07", "051", "", "", "51.16818", "6.93093", "Europe/Berlin"),
("2904808", "Hilchenbach", "Хильхенбах", "DE", "276", "07", "", "", "", "50.99687", "8.11062", "Europe/Berlin"),
("2904886", "Hiddenhausen", "Хидденхаузен", "DE", "276", "07", "057", "05758", "05758016", "52.16667", "8.61667", "Europe/Berlin"),
("2904985", "Heusweiler", "Хойсвайлер", "DE", "276", "09", "00", "10041", "10041513", "49.35", "6.93333", "Europe/Berlin"),
("2904992", "Heusenstamm", "Хойзенштамм", "DE", "276", "05", "", "", "", "50.05553", "8.80076", "Europe/Berlin"),
("2905206", "Hettstedt", "Хетштедт", "DE", "276", "14", "", "", "", "51.6503", "11.51146", "Europe/Berlin"),
("2905290", "Hessisch Oldendorf", "Хессиш-Ольдендорф", "DE", "276", "06", "", "", "", "52.17269", "9.24913", "Europe/Berlin"),
("2905455", "Herzogenrath", "Херцогенрат", "DE", "276", "07", "053", "05334", "", "50.87067", "6.10136", "Europe/Berlin"),
("2905457", "Herzogenaurach", "Херцогенаурах", "DE", "276", "02", "095", "09572", "09572132", "49.56798", "10.88565", "Europe/Berlin"),
("2905560", "Herten", "Хертен", "DE", "276", "07", "", "", "", "51.59638", "7.14387", "Europe/Berlin"),
("2905826", "Herrenberg", "Херренберг", "DE", "276", "01", "081", "08115", "08115021", "48.59523", "8.86648", "Europe/Berlin"),
("2905891", "Herne", "Херне", "DE", "276", "07", "059", "05916", "", "51.5388", "7.22572", "Europe/Berlin"),
("2905904", "Hermsdorf", "", "DE", "276", "16", "00", "11000", "11000000", "52.61131", "13.31783", "Europe/Berlin"),
("2906121", "Herford", "Херфорд", "DE", "276", "07", "057", "05758", "", "52.11457", "8.67343", "Europe/Berlin"),
("2906152", "Herdecke", "Хердекке", "DE", "276", "07", "", "", "", "51.39999", "7.43584", "Europe/Berlin"),
("2906199", "Herborn", "Херборн", "DE", "276", "05", "", "", "", "50.68135", "8.30369", "Europe/Berlin"),
("2906268", "Heppenheim an der Bergstrasse", "", "DE", "276", "05", "064", "06431", "", "49.64145", "8.63206", "Europe/Berlin"),
("2906331", "Hennigsdorf", "Хеннигсдорф", "DE", "276", "11", "00", "", "", "52.63598", "13.20419", "Europe/Berlin"),
("2906376", "Hennef", "Хеннеф", "DE", "276", "07", "053", "05382", "05382020", "50.77555", "7.28308", "Europe/Berlin"),
("2906530", "Hemmingen", "", "DE", "276", "06", "00", "", "", "52.31425", "9.72359", "Europe/Berlin"),
("2906595", "Hemer", "Хемер", "DE", "276", "07", "", "", "", "51.38707", "7.77019", "Europe/Berlin"),
("2906676", "Helmstedt", "Хельмштедт", "DE", "276", "06", "00", "03154", "03154010", "52.2279", "11.00985", "Europe/Berlin"),
("2906809", "Hellersdorf", "", "DE", "276", "16", "00", "11000", "11000000", "52.53319", "13.6088", "Europe/Berlin"),
("2907201", "Heinsberg", "Хайнсберг", "DE", "276", "07", "053", "05370", "", "51.06358", "6.0998", "Europe/Berlin"),
("2907545", "Heilbad Heiligenstadt", "Хайльбад-Хайлигенштадт", "DE", "276", "15", "00", "16061", "", "51.37819", "10.13744", "Europe/Berlin"),
("2907551", "Heiligensee", "", "DE", "276", "16", "00", "11000", "11000000", "52.61449", "13.24501", "Europe/Berlin"),
("2907585", "Heiligenhaus", "Хайлигенхаус", "DE", "276", "07", "051", "05158", "", "51.32662", "6.97106", "Europe/Berlin"),
("2907669", "Heilbronn", "Хайльбронн", "DE", "276", "01", "081", "08121", "08121000", "49.13995", "9.22054", "Europe/Berlin"),
("2907851", "Heidenheim an der Brenz", "Хайденхайм-на-Бренце", "DE", "276", "01", "081", "08135", "08135019", "48.67798", "10.15162", "Europe/Berlin"),
("2907887", "Heidenau", "Хайденау", "DE", "276", "13", "00", "14628", "", "50.97221", "13.86741", "Europe/Berlin"),
("2907911", "Heidelberg", "Хайдельберг", "DE", "276", "01", "082", "08221", "08221000", "49.40768", "8.69079", "Europe/Berlin"),
("2908032", "Heide", "Хайде", "DE", "276", "10", "00", "01051", "", "54.19579", "9.0988", "Europe/Berlin"),
("2908495", "Hechingen", "Хехинген", "DE", "276", "01", "084", "08417", "08417031", "48.35149", "8.96317", "Europe/Berlin"),
("2909230", "Hattingen", "Хаттинген", "DE", "276", "07", "", "", "", "51.39894", "7.18557", "Europe/Berlin"),
("2909240", "Hattersheim", "", "DE", "276", "05", "064", "", "", "50.07854", "8.47552", "Europe/Berlin"),
("2909313", "Hassloch", "", "DE", "276", "08", "00", "07332", "07332025", "49.36278", "8.25806", "Europe/Berlin"),
("2910278", "Harsewinkel", "Харзевинкель", "DE", "276", "07", "057", "", "", "51.96224", "8.22766", "Europe/Berlin"),
("2910514", "Haren", "", "DE", "276", "06", "", "", "", "52.79262", "7.24142", "Europe/Berlin"),
("2910685", "Harburg", "Харбург", "DE", "276", "04", "", "", "", "53.46057", "9.98388", "Europe/Berlin"),
("2910831", "Hannover", "Ганновер", "DE", "276", "06", "00", "", "", "52.37052", "9.73322", "Europe/Berlin"),
("2911007", "Hanau am Main", "", "DE", "276", "05", "064", "06413", "", "50.13423", "8.91418", "Europe/Berlin"),
("2911051", "Hamminkeln", "Хамминкельн", "DE", "276", "07", "051", "", "", "51.73262", "6.59031", "Europe/Berlin"),
("2911240", "Hamm", "Хамм", "DE", "276", "07", "059", "05915", "05915000", "51.68033", "7.82089", "Europe/Berlin"),
("2911271", "Hameln", "Хамельн", "DE", "276", "06", "00", "03252", "", "52.10397", "9.35623", "Europe/Berlin"),
("2911285", "Wandsbek", "", "DE", "276", "04", "", "", "", "53.56667", "10.1", "Europe/Berlin"),
("2911287", "Marienthal", "", "DE", "276", "04", "", "", "", "53.56667", "10.08333", "Europe/Berlin"),
("2911288", "Hamburg-Mitte", "", "DE", "276", "04", "", "", "", "53.55", "10.01667", "Europe/Berlin"),
("2911293", "Eimsbuettel", "Аймсбюттель", "DE", "276", "04", "", "", "", "53.56667", "9.98333", "Europe/Berlin"),
("2911296", "Altona", "Альтона", "DE", "276", "04", "", "", "", "53.55", "9.93333", "Europe/Berlin"),
("2911298", "Hamburg", "Гамбург", "DE", "276", "04", "", "", "", "53.57532", "10.01534", "Europe/Berlin"),
("2911384", "Halver", "Хальфер", "DE", "276", "07", "", "", "", "51.18612", "7.49817", "Europe/Berlin"),
("2911395", "Haltern", "Хальтерне", "DE", "276", "07", "055", "", "", "51.74297", "7.18163", "Europe/Berlin"),
("2911408", "Halstenbek", "", "DE", "276", "10", "00", "01056", "01056018", "53.63333", "9.85", "Europe/Berlin"),
("2911520", "Halle", "Галле", "DE", "276", "07", "", "", "", "52.06008", "8.36083", "Europe/Berlin"),
("2911522", "Halle (Saale)", "Галле", "DE", "276", "14", "", "", "", "51.5", "12", "Europe/Berlin"),
("2911584", "Haldensleben I", "Хальденслебен", "DE", "276", "14", "00", "15083", "", "52.28906", "11.40982", "Europe/Berlin"),
("2911665", "Halberstadt", "Хальберштадт", "DE", "276", "14", "00", "15085", "", "51.89562", "11.05622", "Europe/Berlin"),
("2911710", "Hakenfelde", "", "DE", "276", "16", "00", "11000", "11000000", "52.55877", "13.20831", "Europe/Berlin"),
("2911964", "Haiger", "Хайгер", "DE", "276", "05", "065", "", "", "50.74162", "8.20778", "Europe/Berlin"),
("2912621", "Hagen", "Хаген", "DE", "276", "07", "059", "05914", "", "51.36081", "7.47168", "Europe/Berlin"),
("2913192", "Haar", "Хар", "DE", "276", "02", "091", "09184", "09184123", "48.10881", "11.72653", "Europe/Berlin"),
("2913195", "Haan", "Хаан", "DE", "276", "07", "", "", "", "51.19382", "7.0133", "Europe/Berlin"),
("2913366", "Guetersloh", "Гютерсло", "DE", "276", "07", "057", "05754", "", "51.90693", "8.37854", "Europe/Berlin"),
("2913433", "Guestrow", "Гюстров", "DE", "276", "12", "00", "13072", "", "53.7972", "12.17337", "Europe/Berlin"),
("2913537", "Gunzenhausen", "Гунценхаузен", "DE", "276", "02", "095", "09577", "09577136", "49.11663", "10.75971", "Europe/Berlin"),
("2913555", "Guenzburg", "Гюнцбург", "DE", "276", "02", "097", "09774", "09774135", "48.45599", "10.27695", "Europe/Berlin"),
("2913761", "Gummersbach", "Гуммерсбах", "DE", "276", "07", "053", "05374", "", "51.02608", "7.56473", "Europe/Berlin"),
("2913922", "Guben", "Губен", "DE", "276", "11", "", "", "", "51.94987", "14.71447", "Europe/Berlin"),
("2914929", "Gross-Umstadt", "Грос-Умштадт", "DE", "276", "05", "", "", "", "49.86899", "8.9321", "Europe/Berlin"),
("2915196", "Grossostheim", "", "DE", "276", "02", "096", "09671", "09671122", "49.91986", "9.07596", "Europe/Berlin"),
("2915613", "Gross-Gerau", "Грос-Герау", "DE", "276", "05", "064", "06433", "", "49.92139", "8.48255", "Europe/Berlin"),
("2916630", "Grossenhain", "Гросенхайн", "DE", "276", "13", "", "", "", "51.28951", "13.5335", "Europe/Berlin"),
("2917138", "Gronau", "Гронау", "DE", "276", "07", "055", "", "", "52.21099", "7.02238", "Europe/Berlin"),
("2917221", "Grobenzell", "", "DE", "276", "02", "091", "09179", "09179126", "48.2", "11.36667", "Europe/Berlin"),
("2917325", "Grimma", "Гримма", "DE", "276", "13", "00", "", "", "51.23367", "12.71959", "Europe/Berlin"),
("2917412", "Griesheim", "", "DE", "276", "05", "", "", "", "49.86085", "8.5725", "Europe/Berlin"),
("2917540", "Grevenbroich", "Гревенброх", "DE", "276", "07", "051", "05162", "", "51.09102", "6.5827", "Europe/Berlin"),
("2917544", "Greven", "Гревен", "DE", "276", "07", "055", "", "", "52.09364", "7.59396", "Europe/Berlin"),
("2917737", "Greiz", "Грайц", "DE", "276", "15", "00", "16076", "", "50.65778", "12.19918", "Europe/Berlin"),
("2917788", "Greifswald", "Грайфсвальд", "DE", "276", "12", "00", "13075", "", "54.09311", "13.38786", "Europe/Berlin"),
("2917816", "Grefrath", "Грефрат", "DE", "276", "07", "051", "05166", "05166008", "51.3363", "6.34072", "Europe/Berlin"),
("2918632", "Goettingen", "Гёттинген", "DE", "276", "06", "00", "03152", "", "51.53443", "9.93228", "Europe/Berlin"),
("2918752", "Gotha", "Гота", "DE", "276", "15", "00", "16067", "", "50.94823", "10.70193", "Europe/Berlin"),
("2918840", "Goslar", "Гослар", "DE", "276", "06", "00", "03153", "", "51.90425", "10.42766", "Europe/Berlin"),
("2918987", "Goerlitz", "Гёрлиц", "DE", "276", "13", "00", "14626", "", "51.15518", "14.98853", "Europe/Berlin"),
("2919054", "Goeppingen", "Гёппинген", "DE", "276", "01", "081", "08117", "08117026", "48.70354", "9.65209", "Europe/Berlin"),
("2919625", "Goch", "Гох", "DE", "276", "07", "051", "", "", "51.67873", "6.15895", "Europe/Berlin"),
("2919880", "Glinde", "", "DE", "276", "10", "", "", "", "53.5441", "10.20048", "Europe/Berlin"),
("2920020", "Glauchau", "Глаухау", "DE", "276", "13", "", "", "", "50.81987", "12.54493", "Europe/Berlin"),
("2920236", "Gladbeck", "Гладбек", "DE", "276", "07", "055", "", "", "51.57077", "6.98593", "Europe/Berlin"),
("2920329", "Ginsheim-Gustavsburg", "Гинсхайм-Густавсбург", "DE", "276", "05", "064", "06433", "06433005", "49.9711", "8.34532", "Europe/Berlin"),
("2920433", "Gilching", "", "DE", "276", "02", "091", "09188", "09188121", "48.10755", "11.2936", "Europe/Berlin"),
("2920478", "Gifhorn", "Гифхорн", "DE", "276", "06", "00", "03151", "", "52.47774", "10.5511", "Europe/Berlin"),
("2920512", "Giessen", "Гиссен", "DE", "276", "05", "065", "", "", "50.58727", "8.67554", "Europe/Berlin"),
("2920620", "Giengen an der Brenz", "Гинген-на-Бренце", "DE", "276", "01", "081", "08135", "08135016", "48.62219", "10.24312", "Europe/Berlin"),
("2920757", "Gevelsberg", "Гефельсберг", "DE", "276", "07", "", "", "", "51.31971", "7.3392", "Europe/Berlin"),
("2920789", "Gesundbrunnen", "", "DE", "276", "16", "00", "11000", "11000000", "52.55035", "13.39139", "Europe/Berlin"),
("2920834", "Geseke", "Гезеке", "DE", "276", "07", "", "", "", "51.64091", "8.5109", "Europe/Berlin"),
("2920842", "Gescher", "Гешер", "DE", "276", "07", "055", "", "", "51.954", "7.00481", "Europe/Berlin"),
("2920891", "Gersthofen", "Герстхофен", "DE", "276", "02", "097", "09772", "09772147", "48.42432", "10.87273", "Europe/Berlin"),
("2921034", "Germersheim", "Гермерсхайм", "DE", "276", "08", "00", "07334", "", "49.22306", "8.36389", "Europe/Berlin"),
("2921039", "Germering", "Гермеринг", "DE", "276", "02", "091", "09179", "09179123", "48.13392", "11.3765", "Europe/Berlin"),
("2921061", "Gerlingen", "Герлинген", "DE", "276", "01", "081", "08118", "08118019", "48.79954", "9.06316", "Europe/Berlin"),
("2921139", "Geretsried", "", "DE", "276", "02", "091", "09173", "09173126", "47.85775", "11.48054", "Europe/Berlin"),
("2921232", "Gera", "Гера", "DE", "276", "15", "", "", "", "50.88029", "12.08187", "Europe/Berlin"),
("2921242", "Georgsmarienhutte", "Георгсмариенхютте", "DE", "276", "06", "", "", "", "52.20296", "8.0448", "Europe/Berlin"),
("2921466", "Gelsenkirchen", "Гельзенкирхен", "DE", "276", "07", "055", "05513", "", "51.5075", "7.12283", "Europe/Berlin"),
("2921473", "Gelnhausen", "Гельнхаузен", "DE", "276", "05", "064", "06435", "", "50.20164", "9.18742", "Europe/Berlin"),
("2921528", "Geldern", "Гельдерн", "DE", "276", "07", "", "", "", "51.51908", "6.32363", "Europe/Berlin"),
("2921653", "Geislingen an der Steige", "Гайслинген-ан-дер-Штайге", "DE", "276", "01", "081", "08117", "08117024", "48.62423", "9.82736", "Europe/Berlin"),
("2921837", "Geilenkirchen", "Гейленкирхен", "DE", "276", "07", "", "", "", "50.96745", "6.11763", "Europe/Berlin"),
("2922102", "Geesthacht", "Гестахт", "DE", "276", "10", "", "", "", "53.43575", "10.3779", "Europe/Berlin"),
("2922230", "Gauting", "", "DE", "276", "02", "091", "09188", "09188120", "48.06919", "11.37703", "Europe/Berlin"),
("2922530", "Garmisch-Partenkirchen", "Гармиш-Партенкирхен", "DE", "276", "02", "091", "09180", "09180117", "47.49209", "11.09576", "Europe/Berlin"),
("2922582", "Garching bei Munchen", "Гархинг", "DE", "276", "02", "091", "09184", "09184119", "48.24896", "11.65101", "Europe/Berlin"),
("2922586", "Garbsen", "Гарбсен", "DE", "276", "06", "", "", "", "52.41371", "9.5899", "Europe/Berlin"),
("2922731", "Ganderkesee", "Гандеркезе", "DE", "276", "06", "00", "03458", "03458005", "53.03333", "8.53333", "Europe/Berlin"),
("2923362", "Gaggenau", "Гаггенау", "DE", "276", "01", "082", "08216", "08216015", "48.8", "8.33333", "Europe/Berlin"),
("2923544", "Furth", "Фюрт", "DE", "276", "02", "095", "09563", "09563000", "49.47593", "10.98856", "Europe/Berlin"),
("2923588", "Furstenwalde", "Фюрстенвальде", "DE", "276", "11", "", "", "", "52.36067", "14.06185", "Europe/Berlin"),
("2923625", "Fuerstenfeldbruck", "Фюрстенфельдбрук", "DE", "276", "02", "091", "09179", "09179121", "48.17904", "11.2547", "Europe/Berlin"),
("2923822", "Fulda", "Фульда", "DE", "276", "05", "066", "06631", "", "50.55162", "9.67518", "Europe/Berlin"),
("2924206", "Frondenberg", "Фрёнденберг-на-Руре", "DE", "276", "07", "059", "", "", "51.47563", "7.76946", "Europe/Berlin"),
("2924302", "Frohnau", "", "DE", "276", "16", "00", "11000", "11000000", "52.63336", "13.29024", "Europe/Berlin"),
("2924360", "Friesoythe", "Фризойте", "DE", "276", "06", "", "", "", "53.0226", "7.85764", "Europe/Berlin"),
("2924573", "Friedrichshain Bezirk", "", "DE", "276", "16", "00", "11000", "11000000", "52.51559", "13.45482", "Europe/Berlin"),
("2924577", "Friedrichshagen", "", "DE", "276", "16", "00", "11000", "11000000", "52.45052", "13.62463", "Europe/Berlin"),
("2924585", "Friedrichshafen", "Фридрихсхафен", "DE", "276", "01", "084", "08435", "08435016", "47.65689", "9.47554", "Europe/Berlin"),
("2924599", "Friedrichsfelde", "", "DE", "276", "16", "00", "11000", "11000000", "52.50575", "13.50812", "Europe/Berlin"),
("2924625", "Friedrichsdorf", "Фридрихсдорф", "DE", "276", "05", "064", "", "", "50.24962", "8.64281", "Europe/Berlin"),
("2924770", "Friedenau", "Фриденау", "DE", "276", "16", "00", "11000", "11000000", "52.47133", "13.32813", "Europe/Berlin"),
("2924802", "Friedberg", "Фридберг", "DE", "276", "05", "064", "06440", "", "50.33739", "8.75591", "Europe/Berlin"),
("2924803", "Friedberg", "Фридберг", "DE", "276", "02", "097", "09771", "09771130", "48.35693", "10.98461", "Europe/Berlin"),
("2924894", "Freudenstadt", "Фройденштадт", "DE", "276", "01", "082", "08237", "08237028", "48.46695", "8.41371", "Europe/Berlin"),
("2924915", "Freudenberg", "", "DE", "276", "07", "", "", "", "50.89741", "7.87414", "Europe/Berlin"),
("2925017", "Freital", "Фрайталь", "DE", "276", "13", "00", "", "", "51.00166", "13.6488", "Europe/Berlin"),
("2925034", "Freising", "Фрайзинг", "DE", "276", "02", "091", "09178", "09178124", "48.40351", "11.74876", "Europe/Berlin"),
("2925080", "Freilassing", "Фрайлассинг", "DE", "276", "02", "091", "09172", "09172118", "47.84085", "12.98114", "Europe/Berlin"),
("2925177", "Freiburg", "Фрайбург", "DE", "276", "01", "083", "08311", "08311000", "47.9959", "7.85222", "Europe/Berlin"),
("2925189", "Freiberg am Neckar", "Фрайберг-на-Неккаре", "DE", "276", "01", "081", "08118", "08118078", "48.93196", "9.2024", "Europe/Berlin"),
("2925192", "Freiberg", "Фрайберг", "DE", "276", "13", "00", "14522", "", "50.91089", "13.33881", "Europe/Berlin"),
("2925259", "Frechen", "Фрехен", "DE", "276", "07", "053", "05362", "", "50.91485", "6.8118", "Europe/Berlin"),
("2925533", "Frankfurt am Main", "Франкфурт-на-Майне", "DE", "276", "05", "064", "06412", "", "50.11552", "8.68417", "Europe/Berlin"),
("2925535", "Frankfurt (Oder)", "Франкфурт-на-Одере", "DE", "276", "11", "", "", "", "52.34714", "14.55062", "Europe/Berlin"),
("2925550", "Frankenthal", "Франкенталь", "DE", "276", "08", "00", "07311", "", "49.53414", "8.35357", "Europe/Berlin"),
("2925629", "Frankenberg", "Франкенберг", "DE", "276", "05", "", "", "", "51.0589", "8.80077", "Europe/Berlin"),
("2925630", "Frankenberg", "Франкенберг", "DE", "276", "13", "", "", "", "50.91297", "13.04011", "Europe/Berlin"),
("2925832", "Forst", "Форст", "DE", "276", "11", "00", "12071", "", "51.73544", "14.63971", "Europe/Berlin"),
("2925910", "Forchheim", "Форххайм", "DE", "276", "02", "094", "09474", "09474126", "49.71754", "11.05877", "Europe/Berlin"),
("2926120", "Florsheim", "", "DE", "276", "05", "064", "", "", "50.01312", "8.42779", "Europe/Berlin"),
("2926271", "Flensburg", "Фленсбург", "DE", "276", "10", "00", "01001", "", "54.78431", "9.43961", "Europe/Berlin"),
("2926670", "Finsterwalde", "Финстервальде", "DE", "276", "11", "", "", "", "51.63388", "13.70662", "Europe/Berlin"),
("2926716", "Finnentrop", "Финнентроп", "DE", "276", "07", "059", "05966", "05966012", "51.16667", "7.96667", "Europe/Berlin"),
("2927043", "Stuttgart Feuerbach", "", "DE", "276", "01", "081", "08111", "08111000", "48.80867", "9.15719", "Europe/Berlin"),
("2927268", "Fellbach", "Фелльбах", "DE", "276", "01", "081", "08119", "08119020", "48.80912", "9.27697", "Europe/Berlin"),
("2927930", "Falkensee", "Фалькензе", "DE", "276", "11", "", "", "", "52.56014", "13.0927", "Europe/Berlin"),
("2928381", "Eutin", "Ойтин", "DE", "276", "10", "00", "01055", "", "54.14054", "10.60751", "Europe/Berlin"),
("2928396", "Euskirchen", "Ойскирхен", "DE", "276", "07", "053", "05366", "", "50.66057", "6.78722", "Europe/Berlin"),
("2928615", "Ettlingen", "Эттлинген", "DE", "276", "01", "082", "08215", "08215017", "48.94094", "8.40763", "Europe/Berlin"),
("2928751", "Esslingen", "Эсслинген-на-Неккаре", "DE", "276", "01", "081", "08116", "08116019", "48.73961", "9.30473", "Europe/Berlin"),
("2928810", "Essen", "Эссен", "DE", "276", "07", "051", "05113", "", "51.45657", "7.01228", "Europe/Berlin"),
("2928874", "Espelkamp", "Эспелькамп", "DE", "276", "07", "", "", "", "52.3825", "8.62127", "Europe/Berlin"),
("2928963", "Eschweiler", "Эшвайлер", "DE", "276", "07", "053", "", "", "50.81854", "6.27184", "Europe/Berlin"),
("2928967", "Eschwege", "Эшвеге", "DE", "276", "05", "066", "06636", "", "51.18386", "10.05329", "Europe/Berlin"),
("2929134", "Eschborn", "Эшборн", "DE", "276", "05", "064", "", "", "50.14328", "8.57111", "Europe/Berlin"),
("2929247", "Erwitte", "Эрвитте", "DE", "276", "07", "", "", "", "51.6127", "8.3384", "Europe/Berlin"),
("2929567", "Erlangen", "Эрланген", "DE", "276", "02", "095", "09562", "09562000", "49.59099", "11.00783", "Europe/Berlin"),
("2929600", "Erkrath", "Эркрат", "DE", "276", "07", "051", "", "", "51.22235", "6.9083", "Europe/Berlin"),
("2929622", "Erkelenz", "Эркеленц", "DE", "276", "07", "", "", "", "51.07947", "6.31531", "Europe/Berlin"),
("2929670", "Erfurt", "Эрфурт", "DE", "276", "15", "", "", "", "50.9787", "11.03283", "Europe/Berlin"),
("2929671", "Erftstadt", "Эрфтштадт", "DE", "276", "07", "", "", "", "50.81481", "6.79386", "Europe/Berlin"),
("2929715", "Erding", "Эрдинг", "DE", "276", "02", "091", "09177", "09177117", "48.30603", "11.90686", "Europe/Berlin"),
("2929831", "Eppingen", "Эппинген", "DE", "276", "01", "081", "08125", "08125026", "49.13644", "8.91229", "Europe/Berlin"),
("2929865", "Eppelborn", "", "DE", "276", "09", "00", "10043", "10043111", "49.4", "6.96667", "Europe/Berlin"),
("2930030", "Ennigerloh", "Эннигерло", "DE", "276", "07", "055", "", "", "51.83843", "8.03093", "Europe/Berlin"),
("2930043", "Ennepetal", "Эннепеталь", "DE", "276", "07", "", "", "", "51.29848", "7.3629", "Europe/Berlin"),
("2930182", "Enger", "Энгер", "DE", "276", "07", "", "", "", "52.14063", "8.55772", "Europe/Berlin"),
("2930216", "Engelskirchen", "Энгельскирхен", "DE", "276", "07", "053", "05374", "05374008", "50.98333", "7.4", "Europe/Berlin"),
("2930449", "Emsdetten", "Эмсдеттен", "DE", "276", "07", "", "", "", "52.1734", "7.52781", "Europe/Berlin"),
("2930509", "Emmerich", "Эммерих", "DE", "276", "07", "051", "", "", "51.83933", "6.24792", "Europe/Berlin"),
("2930523", "Emmendingen", "", "DE", "276", "01", "083", "08316", "08316011", "48.12096", "7.85359", "Europe/Berlin"),
("2930596", "Emden", "Эмден", "DE", "276", "06", "00", "03402", "", "53.36745", "7.20778", "Europe/Berlin"),
("2930646", "Eltville", "", "DE", "276", "05", "064", "", "", "50.02858", "8.11754", "Europe/Berlin"),
("2930778", "Elsdorf", "", "DE", "276", "07", "053", "05362", "05362016", "50.93739", "6.56828", "Europe/Berlin"),
("2930821", "Elmshorn", "Эльмсхорн", "DE", "276", "10", "", "", "", "53.75396", "9.65339", "Europe/Berlin"),
("2930889", "Ellwangen", "Эльванген", "DE", "276", "01", "081", "08136", "08136019", "48.96164", "10.13173", "Europe/Berlin"),
("2931361", "Eitorf", "Айторф", "DE", "276", "07", "053", "05382", "05382016", "50.76667", "7.45", "Europe/Berlin"),
("2931414", "Eislingen", "Айзлинген", "DE", "276", "01", "081", "08117", "08117019", "48.69515", "9.70676", "Europe/Berlin"),
("2931481", "Eisenhuettenstadt", "Айзенхюттенштадт", "DE", "276", "11", "00", "12067", "12067120", "52.15", "14.65", "Europe/Berlin"),
("2931574", "Eisenach", "Айзенах", "DE", "276", "15", "00", "16063", "", "50.9807", "10.31522", "Europe/Berlin"),
("2931804", "Einbeck", "Айнбек", "DE", "276", "06", "", "", "", "51.82018", "9.86961", "Europe/Berlin"),
("2931871", "Eilenburg", "Айленбург", "DE", "276", "13", "00", "14730", "14730110", "51.45984", "12.63338", "Europe/Berlin"),
("2932924", "Ehingen", "Эхинген", "DE", "276", "01", "084", "08425", "08425033", "48.28259", "9.72749", "Europe/Berlin"),
("2933101", "Eggenstein-Leopoldshafen", "", "DE", "276", "01", "082", "08215", "08215102", "49.09006", "8.39879", "Europe/Berlin"),
("2933364", "Edewecht", "Эдевехт", "DE", "276", "06", "", "", "", "53.12699", "7.98406", "Europe/Berlin"),
("2933627", "Eckernforde", "Эккернфёрде", "DE", "276", "10", "", "", "", "54.46854", "9.83824", "Europe/Berlin"),
("2933882", "Eberswalde", "Эберсвальде", "DE", "276", "11", "00", "12060", "", "52.83492", "13.81951", "Europe/Berlin"),
("2933959", "Ebersbach an der Fils", "", "DE", "276", "01", "081", "08117", "08117018", "48.716", "9.5236", "Europe/Berlin"),
("2934020", "Eberbach", "Эбербах", "DE", "276", "01", "082", "08226", "08226013", "49.4668", "8.99016", "Europe/Berlin"),
("2934246", "Dusseldorf", "Дюссельдорф", "DE", "276", "07", "051", "", "", "51.22172", "6.77616", "Europe/Berlin"),
("2934486", "Dueren", "Дюрен", "DE", "276", "07", "053", "05358", "", "50.80434", "6.49299", "Europe/Berlin"),
("2934662", "Dulmen", "Дюльмен", "DE", "276", "07", "055", "", "", "51.83149", "7.28075", "Europe/Berlin"),
("2934691", "Duisburg", "Дуйсбург", "DE", "276", "07", "051", "05112", "", "51.43247", "6.76516", "Europe/Berlin"),
("2934728", "Duderstadt", "Дудерштадт", "DE", "276", "06", "00", "", "", "51.51312", "10.25951", "Europe/Berlin"),
("2935022", "Dresden", "Дрезден", "DE", "276", "13", "00", "", "", "51.05089", "13.73832", "Europe/Berlin"),
("2935042", "Drensteinfurt", "Дренштайнфурт", "DE", "276", "07", "055", "", "", "51.79535", "7.73815", "Europe/Berlin"),
("2935220", "Dreieich", "Драйайх", "DE", "276", "05", "", "", "", "50.01997", "8.69611", "Europe/Berlin"),
("2935517", "Dortmund", "Дортмунд", "DE", "276", "07", "059", "05913", "", "51.51494", "7.466", "Europe/Berlin"),
("2935530", "Dorsten", "Дорстен", "DE", "276", "07", "", "", "", "51.66166", "6.96514", "Europe/Berlin"),
("2935825", "Dormagen", "Дормаген", "DE", "276", "07", "051", "", "", "51.09683", "6.83167", "Europe/Berlin"),
("2936253", "Donauwoerth", "Донаувёрт", "DE", "276", "02", "097", "09779", "09779131", "48.71804", "10.7793", "Europe/Berlin"),
("2936267", "Donaueschingen", "Донауэшинген", "DE", "276", "01", "083", "08326", "08326012", "47.95514", "8.49707", "Europe/Berlin"),
("2936658", "Dobeln", "Дебельн", "DE", "276", "13", "00", "", "", "51.1221", "13.11027", "Europe/Berlin"),
("2936705", "Ditzingen", "Дитцинген", "DE", "276", "01", "081", "08118", "08118011", "48.82672", "9.06703", "Europe/Berlin"),
("2936871", "Dinslaken", "Динслакена", "DE", "276", "07", "051", "", "", "51.56227", "6.7434", "Europe/Berlin"),
("2936909", "Dingolfing", "Дингольфинг", "DE", "276", "02", "092", "09279", "09279112", "48.64244", "12.49283", "Europe/Berlin"),
("2936974", "Dillingen an der Donau", "Диллинген-на-Дунае", "DE", "276", "02", "097", "09773", "09773125", "48.58153", "10.49528", "Europe/Berlin"),
("2936977", "Dillingen", "", "DE", "276", "09", "", "", "", "49.35557", "6.72781", "Europe/Berlin"),
("2936985", "Dillenburg", "Дилленбург", "DE", "276", "05", "", "", "", "50.74114", "8.28699", "Europe/Berlin"),
("2937040", "Dietzenbach", "Дитценбах", "DE", "276", "05", "064", "06413", "", "50.00976", "8.77784", "Europe/Berlin"),
("2937317", "Diepholz", "Дипхольц", "DE", "276", "06", "00", "03251", "", "52.60783", "8.37005", "Europe/Berlin"),
("2937591", "Dieburg", "Дибург", "DE", "276", "05", "", "", "", "49.89738", "8.84613", "Europe/Berlin"),
("2937936", "Detmold", "Детмольд", "DE", "276", "07", "057", "", "", "51.93855", "8.87318", "Europe/Berlin"),
("2937959", "Dessau", "Дессау", "DE", "276", "14", "", "", "", "51.83864", "12.24555", "Europe/Berlin"),
("2938323", "Delmenhorst", "Дельменхорст", "DE", "276", "06", "00", "03401", "", "53.0511", "8.63091", "Europe/Berlin"),
("2938376", "Delitzsch", "Делич", "DE", "276", "13", "00", "", "", "51.52546", "12.34284", "Europe/Berlin"),
("2938389", "Delbruck", "Дельбрюк", "DE", "276", "07", "057", "", "", "51.76502", "8.56223", "Europe/Berlin"),
("2938540", "Deggendorf", "Деггендорф", "DE", "276", "02", "092", "09271", "09271119", "48.84086", "12.96068", "Europe/Berlin"),
("2938784", "Datteln", "Даттельн", "DE", "276", "07", "", "", "", "51.66667", "7.38333", "Europe/Berlin"),
("2938913", "Darmstadt", "Дармштадт", "DE", "276", "05", "064", "", "", "49.87167", "8.65027", "Europe/Berlin"),
("2939167", "Damme", "Дамме", "DE", "276", "06", "", "", "", "52.52157", "8.19793", "Europe/Berlin"),
("2939440", "Dahlem", "Далем", "DE", "276", "16", "00", "11000", "11000000", "52.4581", "13.28702", "Europe/Berlin"),
("2939623", "Dachau", "Дахау", "DE", "276", "02", "091", "09174", "09174115", "48.26", "11.43402", "Europe/Berlin"),
("2939658", "Cuxhaven", "Куксхафен", "DE", "276", "06", "00", "03352", "", "53.87176", "8.69087", "Europe/Berlin"),
("2939747", "Crimmitschau", "Криммичау", "DE", "276", "13", "00", "", "", "50.81644", "12.39045", "Europe/Berlin"),
("2939797", "Crailsheim", "Крайльсхайм", "DE", "276", "01", "081", "08127", "08127014", "49.13444", "10.07193", "Europe/Berlin"),
("2939811", "Cottbus", "Котбус", "DE", "276", "11", "00", "12052", "", "51.75769", "14.32888", "Europe/Berlin"),
("2939820", "Coswig", "Косвиг", "DE", "276", "13", "00", "", "", "51.13204", "13.58312", "Europe/Berlin"),
("2939945", "Coesfeld", "Косфельд", "DE", "276", "07", "055", "05558", "", "51.94349", "7.16809", "Europe/Berlin"),
("2939951", "Coburg", "Кобург", "DE", "276", "02", "094", "09463", "09463000", "50.25937", "10.96384", "Europe/Berlin"),
("2939969", "Cloppenburg", "Клоппенбург", "DE", "276", "06", "00", "03453", "", "52.84754", "8.045", "Europe/Berlin"),
("2939995", "Clausthal-Zellerfeld", "Клаусталь-Целлерфельд", "DE", "276", "06", "", "", "", "51.80949", "10.33821", "Europe/Berlin"),
("2940132", "Chemnitz", "Хемниц", "DE", "276", "13", "00", "14511", "14511000", "50.8357", "12.92922", "Europe/Berlin"),
("2940187", "Charlottenburg Bezirk", "Шарлоттенбург", "DE", "276", "16", "00", "11000", "11000000", "52.51667", "13.28333", "Europe/Berlin"),
("2940204", "Cham", "", "DE", "276", "02", "093", "09372", "09372116", "49.22565", "12.65501", "Europe/Berlin"),
("2940213", "Celle", "Целле", "DE", "276", "06", "00", "03351", "", "52.62264", "10.08047", "Europe/Berlin"),
("2940231", "Castrop-Rauxel", "Кастроп-Рауксель", "DE", "276", "07", "", "", "", "51.55657", "7.31155", "Europe/Berlin"),
("2940383", "Calw", "Кальв", "DE", "276", "01", "082", "08235", "08235085", "48.71419", "8.74031", "Europe/Berlin"),
("2940451", "Buxtehude", "Букстехуде", "DE", "276", "06", "", "", "", "53.46716", "9.68636", "Europe/Berlin"),
("2940512", "Butzbach", "Буцбах", "DE", "276", "05", "064", "", "", "50.43395", "8.67122", "Europe/Berlin"),
("2940938", "Burstadt", "Бюрштадт", "DE", "276", "05", "064", "", "", "49.64266", "8.45936", "Europe/Berlin"),
("2940942", "Burscheid", "Буршайд", "DE", "276", "07", "", "", "", "51.1", "7.11667", "Europe/Berlin"),
("2941279", "Burghausen", "", "DE", "276", "02", "091", "09171", "09171112", "48.16925", "12.83139", "Europe/Berlin"),
("2941405", "Burgdorf", "Бургдорф", "DE", "276", "06", "00", "03241", "03241003", "52.44628", "10.0064", "Europe/Berlin"),
("2941501", "Burg bei Magdeburg", "", "DE", "276", "14", "00", "15086", "", "52.27152", "11.85493", "Europe/Berlin"),
("2941570", "Buren", "Бюрен", "DE", "276", "07", "057", "", "", "51.55109", "8.55956", "Europe/Berlin"),
("2941694", "Buende", "Бюнде", "DE", "276", "07", "", "", "", "52.19837", "8.58644", "Europe/Berlin"),
("2941976", "Buhl", "Бюль", "DE", "276", "01", "082", "08216", "08216007", "48.69676", "8.13523", "Europe/Berlin"),
("2942073", "Budingen", "Бюдинген", "DE", "276", "05", "", "", "", "50.29013", "9.1114", "Europe/Berlin"),
("2942122", "Buckow", "", "DE", "276", "16", "00", "11000", "11000000", "52.432", "13.46018", "Europe/Berlin"),
("2942159", "Buckeburg", "Бюккебург", "DE", "276", "06", "00", "03257", "03257009", "52.26065", "9.04939", "Europe/Berlin"),
("2942323", "Buchholz in der Nordheide", "Бухгольц-ин-дер-Нордхайде", "DE", "276", "06", "", "", "", "53.32641", "9.86812", "Europe/Berlin"),
("2942341", "Buchholz", "", "DE", "276", "16", "00", "11000", "11000000", "52.60242", "13.43019", "Europe/Berlin"),
("2942634", "Buchen", "Бухен", "DE", "276", "01", "082", "08225", "08225014", "49.52416", "9.32293", "Europe/Berlin"),
("2943320", "Bruhl", "Брюль", "DE", "276", "07", "", "", "", "50.82928", "6.90499", "Europe/Berlin"),
("2943336", "Bruggen", "", "DE", "276", "07", "051", "05166", "05166004", "51.24053", "6.18376", "Europe/Berlin"),
("2943408", "Bruckmuhl", "", "DE", "276", "02", "091", "09187", "09187122", "47.87859", "11.91098", "Europe/Berlin"),
("2943560", "Bruchsal", "Брухзаль", "DE", "276", "01", "082", "08215", "08215009", "49.12426", "8.59804", "Europe/Berlin"),
("2943573", "Bruchkobel", "Брухкёбель", "DE", "276", "05", "", "", "", "50.17853", "8.92316", "Europe/Berlin"),
("2944027", "Britz", "", "DE", "276", "16", "00", "11000", "11000000", "52.44293", "13.43388", "Europe/Berlin"),
("2944079", "Brilon", "Брилон", "DE", "276", "07", "059", "", "", "51.39462", "8.57146", "Europe/Berlin"),
("2944200", "Bretten", "Бреттен", "DE", "276", "01", "082", "08215", "08215007", "49.03685", "8.70745", "Europe/Berlin"),
("2944354", "Bremervorde", "Бремерфёрде", "DE", "276", "06", "", "", "", "53.48458", "9.14306", "Europe/Berlin"),
("2944368", "Bremerhaven", "Бремерхафен", "DE", "276", "03", "00", "04012", "", "53.55021", "8.57674", "Europe/Berlin"),
("2944388", "Bremen", "Бремен", "DE", "276", "03", "00", "", "", "53.07516", "8.80777", "Europe/Berlin"),
("2945024", "Braunschweig", "Брауншвейг", "DE", "276", "06", "00", "03101", "", "52.26594", "10.52673", "Europe/Berlin"),
("2945358", "Brandenburg an der Havel", "Бранденбург", "DE", "276", "11", "", "", "", "52.41667", "12.55", "Europe/Berlin"),
("2945474", "Bramsche", "Брамше", "DE", "276", "06", "", "", "", "52.40881", "7.97288", "Europe/Berlin"),
("2945542", "Brakel", "Бракель", "DE", "276", "07", "", "", "", "51.7175", "9.18596", "Europe/Berlin"),
("2945545", "Brake (Unterweser)", "", "DE", "276", "06", "00", "03461", "", "53.33333", "8.48333", "Europe/Berlin"),
("2945591", "Brackenheim", "Бракенхайм", "DE", "276", "01", "081", "08125", "08125013", "49.07787", "9.06601", "Europe/Berlin"),
("2945756", "Bottrop", "Ботроп", "DE", "276", "07", "055", "05512", "", "51.52392", "6.9285", "Europe/Berlin"),
("2946111", "Bornheim", "Борнхайм", "DE", "276", "07", "", "", "", "50.76313", "6.99089", "Europe/Berlin"),
("2946172", "Borna", "Борна", "DE", "276", "13", "00", "14729", "", "51.12416", "12.49638", "Europe/Berlin"),
("2946228", "Borken", "Боркен", "DE", "276", "07", "055", "05554", "", "51.84382", "6.85774", "Europe/Berlin"),
("2946366", "Boppard", "Боппард", "DE", "276", "08", "", "", "", "50.23085", "7.58992", "Europe/Berlin"),
("2946447", "Bonn", "Бонн", "DE", "276", "07", "053", "05314", "", "50.73438", "7.09548", "Europe/Berlin"),
("2946478", "Bonen", "Бёнен", "DE", "276", "07", "059", "05978", "05978008", "51.6", "7.76667", "Europe/Berlin"),
("2947022", "Bogenhausen", "", "DE", "276", "02", "091", "09162", "09162000", "48.15221", "11.61585", "Europe/Berlin"),
("2947416", "Bochum", "Бохум", "DE", "276", "07", "059", "05911", "", "51.48165", "7.21648", "Europe/Berlin"),
("2947421", "Bocholt", "Бохольт", "DE", "276", "07", "051", "", "", "51.83879", "6.61531", "Europe/Berlin"),
("2947444", "Boeblingen", "Бёблинген", "DE", "276", "01", "081", "08115", "08115003", "48.68212", "9.01171", "Europe/Berlin"),
("2947449", "Bobingen", "Бобинген", "DE", "276", "02", "097", "09772", "09772125", "48.27091", "10.8339", "Europe/Berlin"),
("2947641", "Blomberg", "Бломберг", "DE", "276", "07", "057", "", "", "51.94331", "9.09067", "Europe/Berlin"),
("2947739", "Blieskastel", "Блискастель", "DE", "276", "09", "00", "", "", "49.23724", "7.25617", "Europe/Berlin"),
("2948071", "Blankenburg", "Бланкенбург", "DE", "276", "14", "", "", "", "51.79025", "10.95509", "Europe/Berlin"),
("2948164", "Bitterfeld-Wolfen", "Биттерфельд", "DE", "276", "13", "", "", "", "51.62355", "12.32396", "Europe/Berlin"),
("2948825", "Bingen am Rhein", "Бинген-на-Рейне", "DE", "276", "08", "", "", "", "49.96675", "7.8992", "Europe/Berlin"),
("2949012", "Bietigheim-Bissingen", "Битигхайм-Биссинген", "DE", "276", "01", "081", "08118", "08118079", "48.94407", "9.11755", "Europe/Berlin"),
("2949073", "Biesdorf", "", "DE", "276", "16", "00", "11000", "11000000", "52.50906", "13.5534", "Europe/Berlin"),
("2949186", "Bielefeld", "Билефельд", "DE", "276", "07", "057", "05711", "05711000", "52.03333", "8.53333", "Europe/Berlin"),
("2949423", "Biberach an der Riss", "Биберах-на-Рисе", "DE", "276", "01", "084", "08426", "08426021", "48.09345", "9.79053", "Europe/Berlin"),
("2949470", "Bexbach", "Бексбах", "DE", "276", "09", "00", "", "", "49.34615", "7.25527", "Europe/Berlin"),
("2949475", "Beverungen", "Беверунген", "DE", "276", "07", "", "", "", "51.66801", "9.37417", "Europe/Berlin"),
("2950073", "Bernburg", "Бернбург", "DE", "276", "14", "00", "15089", "", "51.79464", "11.7401", "Europe/Berlin"),
("2950096", "Bernau bei Berlin", "Бернау", "DE", "276", "11", "", "", "", "52.67982", "13.58708", "Europe/Berlin"),
("2950159", "Berlin", "Берлин", "DE", "276", "16", "00", "11000", "11000000", "52.52437", "13.41053", "Europe/Berlin"),
("2950294", "Bergneustadt", "Бергнойштадт", "DE", "276", "07", "", "", "", "51.02496", "7.65599", "Europe/Berlin"),
("2950344", "Bergkamen", "Бергкамен", "DE", "276", "07", "", "", "", "51.61633", "7.64451", "Europe/Berlin"),
("2950349", "Bergisch Gladbach", "Бергиш Гладбах", "DE", "276", "07", "053", "05378", "", "50.9856", "7.13298", "Europe/Berlin"),
("2950438", "Bergheim", "Бергем", "DE", "276", "07", "053", "05362", "", "50.95572", "6.63986", "Europe/Berlin"),
("2950978", "Bensheim", "Бенсхайм", "DE", "276", "05", "064", "", "", "49.68369", "8.61839", "Europe/Berlin"),
("2951111", "Bendorf", "Бендорф", "DE", "276", "08", "", "", "", "50.42289", "7.57924", "Europe/Berlin"),
("2951648", "Bedburg", "Бедбург", "DE", "276", "07", "053", "", "", "50.99258", "6.57128", "Europe/Berlin"),
("2951654", "Beckum", "Беккум", "DE", "276", "07", "055", "", "", "51.75571", "8.04075", "Europe/Berlin"),
("2951679", "Beckingen", "", "DE", "276", "09", "00", "10042", "10042111", "49.4", "6.7", "Europe/Berlin"),
("2951825", "Bayreuth", "Байройт", "DE", "276", "02", "094", "09462", "09462000", "49.94782", "11.57894", "Europe/Berlin"),
("2951881", "Bautzen", "Баутцен", "DE", "276", "13", "00", "14625", "", "51.18035", "14.43494", "Europe/Berlin"),
("2951923", "Baunatal", "Баунаталь", "DE", "276", "05", "066", "", "", "51.25182", "9.40747", "Europe/Berlin"),
("2951935", "Baumschulenweg", "", "DE", "276", "16", "00", "11000", "11000000", "52.46582", "13.48524", "Europe/Berlin"),
("2952252", "Bassum", "Бассум", "DE", "276", "06", "", "", "", "52.85059", "8.72791", "Europe/Berlin"),
("2952984", "Bamberg", "Бамберг", "DE", "276", "02", "094", "09461", "09461000", "49.89873", "10.90067", "Europe/Berlin"),
("2953089", "Balingen", "Балинген", "DE", "276", "01", "084", "08417", "08417002", "48.27525", "8.85464", "Europe/Berlin"),
("2953197", "Baiersbronn", "Байрсброн", "DE", "276", "01", "082", "08237", "08237004", "48.50318", "8.37699", "Europe/Berlin"),
("2953269", "Bahnhof Lohne", "", "DE", "276", "07", "", "", "", "52.20737", "8.7149", "Europe/Berlin"),
("2953302", "Baesweiler", "Бесвайлер", "DE", "276", "07", "", "", "", "50.90964", "6.18874", "Europe/Berlin"),
("2953310", "Bad Zwischenahn", "Бад-Цвишенан", "DE", "276", "06", "00", "03451", "03451002", "53.18333", "8", "Europe/Berlin"),
("2953317", "Bad Wildungen", "Бад-Вильдунген", "DE", "276", "05", "066", "", "", "51.11963", "9.12475", "Europe/Berlin"),
("2953320", "Bad Waldsee", "Бад-Вальдзе", "DE", "276", "01", "084", "08436", "08436009", "47.92027", "9.7549", "Europe/Berlin"),
("2953321", "Bad Vilbel", "Бад-Фильбель", "DE", "276", "05", "064", "", "", "50.17866", "8.73756", "Europe/Berlin"),
("2953324", "Bad Toelz", "Бад-Тёльц", "DE", "276", "02", "091", "09173", "09173112", "47.76111", "11.5589", "Europe/Berlin"),
("2953339", "Bad Soden am Taunus", "Бад-Зоден", "DE", "276", "05", "064", "", "", "50.1408", "8.50449", "Europe/Berlin"),
("2953341", "Bad Segeberg", "Бад-Зегеберг", "DE", "276", "10", "00", "01060", "", "53.94313", "10.30215", "Europe/Berlin"),
("2953347", "Bad Schwartau", "Бад-Швартау", "DE", "276", "10", "", "", "", "53.91887", "10.69691", "Europe/Berlin"),
("2953357", "Bad Salzungen", "Бад-Зальцунген", "DE", "276", "15", "00", "16063", "", "50.81342", "10.2361", "Europe/Berlin"),
("2953358", "Bad Salzuflen", "Бад-Зальцуфлен", "DE", "276", "07", "057", "", "", "52.0862", "8.74434", "Europe/Berlin"),
("2953363", "Bad Sackingen", "Бад-Зекинген", "DE", "276", "01", "083", "08337", "08337096", "47.55371", "7.94612", "Europe/Berlin"),
("2953371", "Bad Reichenhall", "Бад-Райхенхалль", "DE", "276", "02", "091", "09172", "09172114", "47.72947", "12.87819", "Europe/Berlin"),
("2953374", "Bad Rappenau", "Бад-Раппенау", "DE", "276", "01", "081", "08125", "08125006", "49.23848", "9.1018", "Europe/Berlin"),
("2953379", "Bad Pyrmont", "Бад-Пирмонт", "DE", "276", "06", "", "", "", "51.9859", "9.25246", "Europe/Berlin"),
("2953385", "Bad Oldesloe", "Бад-Ольдесло", "DE", "276", "10", "00", "01062", "", "53.81167", "10.37417", "Europe/Berlin"),
("2953386", "Bad Oeynhausen", "Бад-Эйнхаузен", "DE", "276", "07", "", "", "", "52.20699", "8.80365", "Europe/Berlin"),
("2953389", "Bad Neustadt an der Saale", "Бад-Нойштадт-ан-дер-Зале", "DE", "276", "02", "096", "09673", "09673114", "50.32174", "10.20673", "Europe/Berlin"),
("2953391", "Bad Neuenahr-Ahrweiler", "Бад-Нойенар-Арвайлер", "DE", "276", "08", "00", "07131", "", "50.54322", "7.1113", "Europe/Berlin"),
("2953395", "Bad Nauheim", "Бад-Наухайм", "DE", "276", "05", "064", "", "", "50.36463", "8.73859", "Europe/Berlin"),
("2953398", "Bad Munstereifel", "Бад-Мюнстерайфель", "DE", "276", "07", "053", "", "", "50.55666", "6.76424", "Europe/Berlin"),
("2953400", "Bad Munder am Deister", "Бад-Мюндер-ам-Дайстер", "DE", "276", "06", "", "", "", "52.19551", "9.46421", "Europe/Berlin"),
("2953402", "Bad Mergentheim", "", "DE", "276", "01", "081", "08128", "08128007", "49.4925", "9.77361", "Europe/Berlin"),
("2953405", "Bad Lippspringe", "Бад-Липшпринге", "DE", "276", "07", "", "", "", "51.78333", "8.81683", "Europe/Berlin"),
("2953413", "Bad Langensalza", "Бад-Лангензальца", "DE", "276", "15", "", "", "", "51.10771", "10.646", "Europe/Berlin"),
("2953416", "Bad Kreuznach", "Бад-Кройцнах", "DE", "276", "08", "00", "07133", "", "49.8414", "7.86713", "Europe/Berlin"),
("2953424", "Bad Kissingen", "Бад-Киссинген", "DE", "276", "02", "096", "09672", "09672114", "50.20228", "10.07784", "Europe/Berlin"),
("2953435", "Bad Honnef", "Бад-Хоннеф", "DE", "276", "07", "053", "05382", "05382008", "50.64336", "7.2278", "Europe/Berlin"),
("2953436", "Bad Homburg vor der Hoehe", "Бад-Хомбург", "DE", "276", "05", "064", "06434", "06434001", "50.22683", "8.61816", "Europe/Berlin"),
("2953439", "Bad Hersfeld", "Бад-Херсфельд", "DE", "276", "05", "066", "06632", "", "50.87197", "9.70891", "Europe/Berlin"),
("2953449", "Bad Harzburg", "Бад-Харцбурге", "DE", "276", "06", "", "", "", "51.88268", "10.56157", "Europe/Berlin"),
("2953464", "Bad Essen", "Бад-Эссен", "DE", "276", "06", "00", "03459", "03459003", "52.31667", "8.33333", "Europe/Berlin"),
("2953504", "Baden-Baden", "Баден-Баден", "DE", "276", "01", "082", "08211", "08211000", "48.7606", "8.23975", "Europe/Berlin"),
("2953522", "Bad Duerkheim", "Бад-Дюркхайм", "DE", "276", "08", "00", "07332", "", "49.4618", "8.17236", "Europe/Berlin"),
("2953525", "Bad Driburg", "Бад-Дрибург", "DE", "276", "07", "057", "", "", "51.73297", "9.01969", "Europe/Berlin"),
("2953545", "Bad Berleburg", "Бад-Берлебург", "DE", "276", "07", "059", "", "", "51.05224", "8.39228", "Europe/Berlin"),
("2953552", "Bad Bentheim", "Бад-Бентхайм", "DE", "276", "06", "", "", "", "52.31814", "7.16343", "Europe/Berlin"),
("2953558", "Bad Aibling", "Бад-Айблинг", "DE", "276", "02", "091", "09187", "09187117", "47.8638", "12.01055", "Europe/Berlin"),
("2953568", "Backnang", "Бакнанг", "DE", "276", "01", "081", "08119", "08119008", "48.94744", "9.43718", "Europe/Berlin"),
("2953770", "Babenhausen", "Бабенхаузен", "DE", "276", "05", "064", "", "", "49.96519", "8.95129", "Europe/Berlin"),
("2954006", "Aurich", "Аурих", "DE", "276", "06", "00", "03452", "", "53.46919", "7.48232", "Europe/Berlin"),
("2954172", "Augsburg", "Аугсбург", "DE", "276", "02", "097", "09761", "09761000", "48.37154", "10.89851", "Europe/Berlin"),
("2954602", "Auerbach", "", "DE", "276", "13", "", "", "", "50.51155", "12.40083", "Europe/Berlin"),
("2954695", "Aue", "Ауэ", "DE", "276", "13", "", "", "", "50.59034", "12.70657", "Europe/Berlin"),
("2954932", "Attendorn", "Аттендорн", "DE", "276", "07", "059", "", "", "51.12645", "7.90333", "Europe/Berlin"),
("2955168", "Aschersleben", "Ашерслебен", "DE", "276", "14", "", "", "", "51.75742", "11.46084", "Europe/Berlin"),
("2955224", "Ascheberg", "Ашеберг", "DE", "276", "07", "055", "05558", "05558004", "51.78333", "7.61667", "Europe/Berlin"),
("2955272", "Aschaffenburg", "Ашаффенбург", "DE", "276", "02", "096", "09661", "09661000", "49.97704", "9.15214", "Europe/Berlin"),
("2955421", "Bad Arolsen", "Бад-Арользен", "DE", "276", "05", "066", "", "", "51.37982", "9.01445", "Europe/Berlin"),
("2955439", "Arnstadt", "Арнштадте", "DE", "276", "15", "00", "16070", "", "50.84048", "10.95198", "Europe/Berlin"),
("2955471", "Arnsberg", "Арнсберге", "DE", "276", "07", "059", "", "", "51.38333", "8.08333", "Europe/Berlin"),
("2955770", "Apolda", "Апольде", "DE", "276", "15", "00", "16071", "", "51.02624", "11.51638", "Europe/Berlin"),
("2955936", "Ansbach", "Ансбах", "DE", "276", "02", "095", "09561", "09561000", "49.30481", "10.5931", "Europe/Berlin"),
("2956005", "Annaberg-Buchholz", "Аннаберг-Буххольц", "DE", "276", "13", "00", "14521", "", "50.57953", "13.00627", "Europe/Berlin"),
("2956093", "Angermunde", "Ангермюнде", "DE", "276", "11", "", "", "", "53.01499", "13.99924", "Europe/Berlin"),
("2956206", "Andernach", "Андернах", "DE", "276", "08", "", "", "", "50.43109", "7.40425", "Europe/Berlin"),
("2956656", "Amberg", "Амберг", "DE", "276", "02", "093", "09361", "09361000", "49.44287", "11.86267", "Europe/Berlin"),
("2956710", "Alzey", "", "DE", "276", "08", "00", "07331", "", "49.74657", "8.11513", "Europe/Berlin"),
("2956715", "Alzenau in Unterfranken", "", "DE", "276", "02", "096", "09671", "09671111", "50.0888", "9.06455", "Europe/Berlin"),
("2957185", "Altglienicke", "", "DE", "276", "16", "00", "11000", "11000000", "52.41116", "13.5355", "Europe/Berlin"),
("2957773", "Altenburg", "Альтенбург", "DE", "276", "15", "00", "16077", "", "50.98763", "12.43684", "Europe/Berlin"),
("2957886", "Altena", "Альтена", "DE", "276", "07", "", "", "", "51.29472", "7.67336", "Europe/Berlin"),
("2958024", "Altdorf", "", "DE", "276", "02", "095", "09574", "09574112", "49.3856", "11.3573", "Europe/Berlin"),
("2958128", "Alsfeld", "Альсфельд", "DE", "276", "05", "065", "", "", "50.75185", "9.27082", "Europe/Berlin"),
("2958141", "Alsdorf", "Альсдорф", "DE", "276", "07", "053", "", "", "50.87672", "6.16399", "Europe/Berlin"),
("2958516", "Alfter", "Альфтер", "DE", "276", "07", "053", "05382", "05382004", "50.73333", "7.01667", "Europe/Berlin"),
("2958533", "Alfeld", "Альфельд", "DE", "276", "06", "", "", "", "51.98382", "9.81989", "Europe/Berlin"),
("2958595", "Albstadt", "Альбштадт", "DE", "276", "01", "084", "08417", "08417079", "48.21644", "9.02596", "Europe/Berlin"),
("2958975", "Aichach", "Айхах", "DE", "276", "02", "097", "09771", "09771113", "48.45755", "11.13413", "Europe/Berlin"),
("2959083", "Ahrensburg", "Аренсбург", "DE", "276", "10", "", "", "", "53.67515", "10.22593", "Europe/Berlin"),
("2959223", "Ahlen", "Ален", "DE", "276", "07", "", "", "", "51.76338", "7.8887", "Europe/Berlin"),
("2959279", "Ahaus", "Ахаус", "DE", "276", "07", "055", "", "", "52.07936", "7.01344", "Europe/Berlin"),
("2959441", "Adlershof", "Адлерсхоф", "DE", "276", "16", "00", "11000", "11000000", "52.43548", "13.54825", "Europe/Berlin"),
("2959681", "Achim", "Ахим", "DE", "276", "06", "00", "03361", "03361001", "53.01416", "9.0263", "Europe/Berlin"),
("2959686", "Achern", "Ахерн", "DE", "276", "01", "083", "08317", "08317001", "48.63115", "8.07607", "Europe/Berlin"),
("2959927", "Aalen", "Ален", "DE", "276", "01", "081", "08136", "08136088", "48.83777", "10.0933", "Europe/Berlin"),
("3207197", "Vellmar", "Фельмар", "DE", "276", "05", "066", "", "", "51.35806", "9.47974", "Europe/Berlin"),
("3207567", "Rehlingen-Siersburg", "", "DE", "276", "09", "00", "10044", "10044114", "49.36667", "6.68333", "Europe/Berlin"),
("3209083", "Henstedt-Ulzburg", "Хенштедт-Ульцбург", "DE", "276", "10", "00", "01060", "01060039", "53.79132", "9.97979", "Europe/Berlin"),
("3247449", "Aachen", "Ахен", "DE", "276", "07", "053", "05334", "05334002", "50.77664", "6.08342", "Europe/Berlin"),
("3272460", "Morfelden-Walldorf", "", "DE", "276", "05", "", "", "", "49.99472", "8.58361", "Europe/Berlin"),
("3272941", "Riedstadt", "Ридштадт", "DE", "276", "05", "064", "", "", "49.83411", "8.49621", "Europe/Berlin"),
("3274966", "Lauda-Konigshofen", "Лауда-Кёнигсхофен", "DE", "276", "01", "081", "08128", "08128139", "49.56526", "9.70816", "Europe/Berlin"),
("3336891", "Filderstadt", "Фильдерштадт", "DE", "276", "01", "081", "08116", "08116077", "48.65698", "9.22049", "Europe/Berlin"),
("3336892", "Ostfildern", "", "DE", "276", "01", "081", "08116", "08116080", "48.72704", "9.24954", "Europe/Berlin"),
("3336893", "Rodgau", "Родгау", "DE", "276", "05", "064", "06438", "06438011", "50.02627", "8.88588", "Europe/Berlin"),
("3337408", "Gropiusstadt", "", "DE", "276", "16", "00", "11000", "11000000", "52.425", "13.46667", "Europe/Berlin"),
("3337504", "Seeheim-Jugenheim", "Зехайм-Югенхайм", "DE", "276", "05", "064", "06432", "06432022", "49.765", "8.65194", "Europe/Berlin"),
("6545288", "Charlottenburg-Nord", "", "DE", "276", "16", "00", "11000", "11000000", "52.53048", "13.29371", "Europe/Berlin"),
("6545310", "Mitte", "", "DE", "276", "16", "00", "11000", "11000000", "52.52003", "13.40489", "Europe/Berlin"),
("6550659", "Spremberg", "Шпремберг", "DE", "276", "11", "00", "12071", "12071372", "51.56971", "14.37355", "Europe/Berlin"),
("6558039", "Rheinstetten", "", "DE", "276", "01", "082", "08215", "08215108", "48.9685", "8.30704", "Europe/Berlin"),
("6691072", "Altstadt Sud", "", "DE", "276", "07", "053", "05315", "05315000", "50.93331", "6.95954", "Europe/Berlin"),
("6691073", "Altstadt Nord", "", "DE", "276", "07", "053", "05315", "05315000", "50.93893", "6.95752", "Europe/Berlin"),
("6691078", "Bilderstoeckchen", "", "DE", "276", "07", "053", "05315", "05315000", "50.96983", "6.92997", "Europe/Berlin"),
("6930414", "Stuttgart-Ost", "", "DE", "276", "01", "081", "08111", "08111000", "48.78363", "9.21032", "Europe/Berlin"),
("6941055", "Bochum-Hordel", "", "DE", "276", "07", "", "", "", "51.50168", "7.1756", "Europe/Berlin"),
("6944296", "St. Pauli", "", "DE", "276", "04", "", "", "", "53.557", "9.964", "Europe/Berlin"),
("7274677", "Eidelstedt", "", "DE", "276", "04", "00", "02000", "", "53.60697", "9.90538", "Europe/Berlin"),
("7289614", "Halle Neustadt", "", "DE", "276", "14", "", "", "", "51.47924", "11.91605", "Europe/Berlin"),
("7290243", "Bergedorf", "Бергедорф", "DE", "276", "04", "", "", "", "53.48462", "10.22904", "Europe/Berlin"),
("7290252", "Spandau", "", "DE", "276", "16", "00", "11000", "11000000", "52.5511", "13.19921", "Europe/Berlin"),
("7290254", "Berlin Schoeneberg", "", "DE", "276", "16", "00", "11000", "11000000", "52.48388", "13.3477", "Europe/Berlin"),
("7290255", "Berlin Treptow", "", "DE", "276", "16", "00", "11000", "11000000", "52.49376", "13.44469", "Europe/Berlin"),
("7290401", "Niederrad", "", "DE", "276", "05", "", "", "", "50.08309", "8.62852", "Europe/Berlin"),
("7302786", "Haselbachtal", "", "DE", "276", "13", "", "", "", "51.2357", "14.02576", "Europe/Berlin"),
("7932342", "Barmbek-Nord", "", "DE", "276", "04", "", "", "", "53.6052", "10.03988", "Europe/Berlin"),
("7932386", "Farmsen-Berne", "", "DE", "276", "04", "", "", "", "53.60639", "10.11972", "Europe/Berlin"),
("8334621", "Falkenhagener Feld", "", "DE", "276", "16", "00", "11000", "11000000", "52.55191", "13.16802", "Europe/Berlin"),
("8334622", "Neu-Hohenschoenhausen", "", "DE", "276", "16", "00", "11000", "11000000", "52.56681", "13.51255", "Europe/Berlin"),
("8334624", "Alt-Hohenschoenhausen", "", "DE", "276", "16", "00", "11000", "11000000", "52.54608", "13.5013", "Europe/Berlin"),
("8334625", "Fennpfuhl", "", "DE", "276", "16", "00", "11000", "11000000", "52.52921", "13.47267", "Europe/Berlin"),
("8354626", "Hamburg-Nord", "", "DE", "276", "04", "", "", "", "53.58935", "9.984", "Europe/Berlin"),
("8378906", "Burg Unter-Falkenstein", "", "DE", "276", "02", "091", "09187", "09187131", "47.7044", "12.10466", "Europe/Berlin"),
("8642860", "Gartenstadt", "", "DE", "276", "08", "", "", "", "49.45937", "8.40377", "Europe/Berlin"),
("2610319", "Viborg", "Виборг", "DK", "208", "18", "791", "", "", "56.45319", "9.40201", "Europe/Copenhagen"),
("2610613", "Vejle", "Вайле", "DK", "208", "21", "630", "", "", "55.70927", "9.5357", "Europe/Copenhagen"),
("2611828", "Taastrup", "Тааструп", "DK", "208", "17", "169", "", "", "55.65173", "12.29216", "Europe/Copenhagen"),
("2612045", "Svendborg", "Свеннборге", "DK", "208", "21", "479", "", "", "55.05982", "10.60677", "Europe/Copenhagen"),
("2612629", "Stenlose", "", "DK", "208", "17", "240", "", "", "55.76828", "12.19723", "Europe/Copenhagen"),
("2613102", "Sonderborg", "Сённенборг", "DK", "208", "21", "540", "", "", "54.90926", "9.80737", "Europe/Copenhagen"),
("2613460", "Slagelse", "Слагельсе", "DK", "208", "20", "330", "", "", "55.40276", "11.35459", "Europe/Copenhagen"),
("2613731", "Skive", "Скиве", "DK", "208", "18", "779", "", "", "56.56381", "9.04024", "Europe/Copenhagen"),
("2614030", "Silkeborg", "Силькеборг", "DK", "208", "18", "740", "", "", "56.1697", "9.54508", "Europe/Copenhagen"),
("2614481", "Roskilde", "Роскилле", "DK", "208", "20", "265", "", "", "55.64152", "12.08035", "Europe/Copenhagen"),
("2614600", "Rodovre", "", "DK", "208", "17", "175", "", "", "55.68062", "12.45373", "Europe/Copenhagen"),
("2614764", "Ringsted", "Рингстед", "DK", "208", "20", "329", "", "", "55.4426", "11.79011", "Europe/Copenhagen"),
("2615006", "Randers", "Рандерс", "DK", "208", "18", "730", "", "", "56.4607", "10.03639", "Europe/Copenhagen"),
("2615876", "Odense", "Оденсе", "DK", "208", "21", "461", "", "", "55.39594", "10.38831", "Europe/Copenhagen"),
("2615961", "Nykobing Falster", "Нюкёбинг Фальстер", "DK", "208", "20", "376", "", "", "54.76906", "11.87425", "Europe/Copenhagen"),
("2616015", "Nyborg", "", "DK", "208", "21", "450", "", "", "55.31274", "10.78964", "Europe/Copenhagen"),
("2616038", "Naestved", "Нествед", "DK", "208", "20", "370", "", "", "55.22992", "11.76092", "Europe/Copenhagen"),
("2617658", "Lillerod", "", "DK", "208", "17", "201", "", "", "55.87496", "12.34579", "Europe/Copenhagen"),
("2618361", "Korsor", "", "DK", "208", "20", "330", "", "", "55.32993", "11.13857", "Europe/Copenhagen"),
("2618415", "Koge", "Кеге", "DK", "208", "20", "259", "", "", "55.45802", "12.18214", "Europe/Copenhagen"),
("2618425", "Copenhagen", "Копенгаген", "DK", "208", "17", "101", "", "", "55.67594", "12.56553", "Europe/Copenhagen"),
("2618528", "Kolding", "Колдинг", "DK", "208", "21", "621", "", "", "55.4904", "9.47216", "Europe/Copenhagen"),
("2619154", "Kalundborg", "", "DK", "208", "20", "326", "", "", "55.67954", "11.08864", "Europe/Copenhagen"),
("2619377", "Ishoj", "", "DK", "208", "17", "183", "", "", "55.61543", "12.35182", "Europe/Copenhagen"),
("2619528", "Hvidovre", "Хвидовре", "DK", "208", "17", "167", "", "", "55.65719", "12.47364", "Europe/Copenhagen"),
("2619771", "Horsens", "Хорсенс", "DK", "208", "18", "615", "", "", "55.86066", "9.85034", "Europe/Copenhagen"),
("2619856", "Horsholm", "Херсхольм", "DK", "208", "17", "223", "", "", "55.88098", "12.50111", "Europe/Copenhagen"),
("2620046", "Holstebro", "Хольстебро", "DK", "208", "18", "661", "", "", "56.36009", "8.61607", "Europe/Copenhagen"),
("2620147", "Holbaek", "Хольбек", "DK", "208", "20", "316", "", "", "55.71354", "11.7169", "Europe/Copenhagen"),
("2620214", "Hjorring", "", "DK", "208", "19", "860", "", "", "57.46417", "9.98229", "Europe/Copenhagen"),
("2620320", "Hillerod", "Хиллерод", "DK", "208", "17", "219", "", "", "55.92791", "12.30081", "Europe/Copenhagen"),
("2620425", "Herning", "Хернинг", "DK", "208", "18", "657", "", "", "56.13932", "8.97378", "Europe/Copenhagen"),
("2620473", "Helsingor", "Хельсингёр", "DK", "208", "17", "217", "", "", "56.03606", "12.6136", "Europe/Copenhagen"),
("2620964", "Haderslev", "Хадерслев", "DK", "208", "21", "510", "", "", "55.25377", "9.48982", "Europe/Copenhagen"),
("2621215", "Greve", "", "DK", "208", "20", "253", "", "", "55.58333", "12.3", "Europe/Copenhagen"),
("2621356", "Glostrup", "", "DK", "208", "17", "161", "", "", "55.6666", "12.40377", "Europe/Copenhagen"),
("2621927", "Frederikshavn", "Фредериксхавн", "DK", "208", "19", "813", "", "", "57.44073", "10.53661", "Europe/Copenhagen"),
("2621942", "Frederiksberg", "Фредериксберг", "DK", "208", "17", "147", "", "", "55.67938", "12.53463", "Europe/Copenhagen"),
("2621951", "Fredericia", "Фредерисия", "DK", "208", "21", "607", "", "", "55.56568", "9.75257", "Europe/Copenhagen"),
("2622306", "Farum", "Фарум", "DK", "208", "17", "190", "", "", "55.80858", "12.36066", "Europe/Copenhagen"),
("2622447", "Esbjerg", "Эсбьерг", "DK", "208", "21", "561", "", "", "55.47028", "8.45187", "Europe/Copenhagen"),
("2623188", "Charlottenlund", "", "DK", "208", "17", "157", "", "", "55.75367", "12.59181", "Europe/Copenhagen"),
("2624112", "Birkerod", "", "DK", "208", "17", "230", "", "", "55.84759", "12.42791", "Europe/Copenhagen"),
("2624341", "Ballerup", "", "DK", "208", "17", "151", "", "", "55.73165", "12.36328", "Europe/Copenhagen"),
("2624652", "Arhus", "Орхус", "DK", "208", "18", "751", "", "", "56.15674", "10.21076", "Europe/Copenhagen"),
("2624886", "Aalborg", "Ольборг", "DK", "208", "19", "851", "", "", "57.048", "9.9187", "Europe/Copenhagen"),
("2624906", "Albertslund", "Альбертслунн", "DK", "208", "17", "165", "", "", "55.65691", "12.36381", "Europe/Copenhagen"),
("2625070", "Aabenraa", "", "DK", "208", "21", "580", "", "", "55.04434", "9.41741", "Europe/Copenhagen"),
("3491941", "Villa Francisca", "", "DO", "214", "34", "", "", "", "18.46667", "-69.9", "America/Santo_Domingo"),
("3491946", "Villa Consuelo", "", "DO", "214", "34", "", "", "", "18.48333", "-69.9", "America/Santo_Domingo"),
("3491948", "Villa Bisono", "", "DO", "214", "25", "", "", "", "19.56378", "-70.87582", "America/Santo_Domingo"),
("3491952", "Villa Altagracia", "Вилья-Альтаграсия", "DO", "214", "33", "", "", "", "18.67297", "-70.17095", "America/Santo_Domingo"),
("3492517", "Tamboril", "", "DO", "214", "25", "", "", "", "19.48538", "-70.61104", "America/Santo_Domingo"),
("3492908", "Santo Domingo", "Санто-Доминго", "DO", "214", "34", "", "", "", "18.50012", "-69.98857", "America/Santo_Domingo"),
("3492914", "Santiago de los Caballeros", "Сантьяго-де-лос-Кабальерос", "DO", "214", "25", "", "", "", "19.4517", "-70.69703", "America/Santo_Domingo"),
("3492984", "Santa Cruz de El Seibo", "", "DO", "214", "28", "", "", "", "18.76559", "-69.03886", "America/Santo_Domingo"),
("3492985", "Santa Cruz de Barahona", "Санта-Крус-де-Бараона", "DO", "214", "03", "", "", "", "18.20854", "-71.10077", "America/Santo_Domingo"),
("3493032", "San Pedro de Macoris", "", "DO", "214", "24", "", "", "", "18.46156", "-69.29718", "America/Santo_Domingo"),
("3493081", "San Juan de la Maguana", "", "DO", "214", "23", "", "", "", "18.80588", "-71.22991", "America/Santo_Domingo"),
("3493100", "San Jose de Ocoa", "", "DO", "214", "36", "", "", "", "18.54661", "-70.50631", "America/Santo_Domingo"),
("3493146", "San Francisco de Macoris", "", "DO", "214", "06", "", "", "", "19.30099", "-70.25259", "America/Santo_Domingo"),
("3493174", "San Fernando de Monte Cristi", "", "DO", "214", "15", "", "", "", "19.84826", "-71.64597", "America/Santo_Domingo"),
("3493175", "Puerto Plata", "", "DO", "214", "18", "3494269", "", "", "19.79344", "-70.6884", "America/Santo_Domingo"),
("3493240", "Salvaleon de Higuey", "", "DO", "214", "10", "", "", "", "18.61501", "-68.70798", "America/Santo_Domingo"),
("3493283", "Salcedo", "", "DO", "214", "19", "", "", "", "19.37762", "-70.41762", "America/Santo_Domingo"),
("3493383", "Sabaneta", "", "DO", "214", "26", "", "", "", "19.47793", "-71.34125", "America/Santo_Domingo"),
("3493482", "Sabana Grande de Boya", "", "DO", "214", "32", "", "", "", "18.94498", "-69.79331", "America/Santo_Domingo"),
("3493769", "Rio Grande", "", "DO", "214", "18", "", "", "", "19.66667", "-70.76667", "America/Santo_Domingo"),
("3494121", "Quisqueya", "", "DO", "214", "24", "", "", "", "18.55542", "-69.40814", "America/Santo_Domingo"),
("3494242", "Punta Cana", "Пунта Кана", "DO", "214", "23", "", "", "", "18.58182", "-68.40431", "America/Santo_Domingo"),
("3495857", "Neiba", "", "DO", "214", "02", "3495858", "", "", "18.48138", "-71.41965", "America/Santo_Domingo"),
("3496021", "Nagua", "Нагуа", "DO", "214", "14", "", "", "", "19.3832", "-69.8474", "America/Santo_Domingo"),
("3496134", "Monte Plata", "Монте Плата", "DO", "214", "32", "", "", "", "18.807", "-69.78399", "America/Santo_Domingo"),
("3496331", "Moca", "", "DO", "214", "08", "3496332", "", "", "19.39352", "-70.52598", "America/Santo_Domingo"),
("3496831", "Mao", "Мао", "DO", "214", "27", "", "", "", "19.55186", "-71.07813", "America/Santo_Domingo"),
("3500370", "Las Matas de Farfan", "Лас-Матас-де-Фарфан", "DO", "214", "23", "", "", "", "18.87309", "-71.51656", "America/Santo_Domingo"),
("3500957", "La Romana", "Ла-Романа", "DO", "214", "12", "", "", "", "18.42734", "-68.97285", "America/Santo_Domingo"),
("3504158", "Jarabacoa", "Харабакоа", "DO", "214", "30", "", "", "", "19.12178", "-70.64218", "America/Santo_Domingo"),
("3504765", "Hato Mayor del Rey", "", "DO", "214", "29", "", "", "", "18.76278", "-69.25681", "America/Santo_Domingo"),
("3505855", "Esperanza", "", "DO", "214", "27", "", "", "", "19.5847", "-70.98489", "America/Santo_Domingo"),
("3508952", "Dajabon", "", "DO", "214", "04", "", "", "", "19.54878", "-71.70829", "America/Santo_Domingo"),
("3509207", "Cotui", "", "DO", "214", "21", "", "", "", "19.05272", "-70.14939", "America/Santo_Domingo"),
("3509363", "Constanza", "Констанция", "DO", "214", "30", "", "", "", "18.90919", "-70.74499", "America/Santo_Domingo"),
("3509382", "Concepcion de La Vega", "", "DO", "214", "30", "", "", "", "19.22207", "-70.52956", "America/Santo_Domingo"),
("3509578", "Ciudad Nueva", "", "DO", "214", "34", "", "", "", "18.46667", "-69.9", "America/Santo_Domingo"),
("3511233", "Bonao", "Бонао", "DO", "214", "31", "", "", "", "18.93687", "-70.40923", "America/Santo_Domingo"),
("3511336", "Boca Chica", "Бока Чика", "DO", "214", "37", "", "", "", "18.45174", "-69.60914", "America/Santo_Domingo"),
("3511540", "San Cristobal", "", "DO", "214", "33", "", "", "", "18.41667", "-70.1", "America/Santo_Domingo"),
("3511550", "Bella Vista", "", "DO", "214", "34", "", "", "", "18.45", "-69.93333", "America/Santo_Domingo"),
("3511626", "Bayaguana", "", "DO", "214", "32", "", "", "", "18.75639", "-69.63616", "America/Santo_Domingo"),
("3512067", "Bani", "Бан", "DO", "214", "35", "", "", "", "18.27964", "-70.33184", "America/Santo_Domingo"),
("3512128", "Bajos de Haina", "", "DO", "214", "33", "", "", "", "18.41538", "-70.03317", "America/Santo_Domingo"),
("3512208", "Azua", "Асуа-де-Компостела", "DO", "214", "01", "3512211", "", "", "18.45319", "-70.7349", "America/Santo_Domingo"),
("7874116", "Santo Domingo Oeste", "", "DO", "214", "37", "", "", "", "18.5", "-70", "America/Santo_Domingo"),
("2474141", "Boumerdas", "Бумердес", "DZ", "12", "40", "", "", "", "36.76639", "3.47717", "Africa/Algiers"),
("2474506", "Zeribet el Oued", "", "DZ", "12", "19", "", "", "", "34.68284", "6.51109", "Africa/Algiers"),
("2474583", "Zeralda", "", "DZ", "12", "55", "", "", "", "36.71169", "2.84244", "Africa/Algiers"),
("2474638", "Zemoura", "", "DZ", "12", "51", "", "", "", "35.72251", "0.75509", "Africa/Algiers"),
("2475475", "Touggourt", "Туггурт", "DZ", "12", "50", "", "", "", "33.10527", "6.05796", "Africa/Algiers"),
("2475612", "Tolga", "Толга", "DZ", "12", "19", "", "", "", "34.72224", "5.37845", "Africa/Algiers"),
("2475687", "Tlemcen", "Тлемсен", "DZ", "12", "15", "", "", "", "34.87833", "-1.315", "Africa/Algiers"),
("2475740", "Tizi Rached", "", "DZ", "12", "14", "", "", "", "36.67176", "4.19176", "Africa/Algiers"),
("2475744", "Tizi Ouzou", "Тизи-Узу", "DZ", "12", "14", "", "", "", "36.71182", "4.04591", "Africa/Algiers"),
("2475752", "Tizi-n-Tleta", "", "DZ", "12", "14", "", "", "", "36.54569", "4.05712", "Africa/Algiers"),
("2475764", "Tizi Gheniff", "", "DZ", "12", "40", "", "", "", "36.58839", "3.77445", "Africa/Algiers"),
("2475860", "Tissemsilt", "", "DZ", "12", "56", "", "", "", "35.60722", "1.81081", "Africa/Algiers"),
("2475921", "Tirmitine", "", "DZ", "12", "14", "", "", "", "36.65393", "3.98143", "Africa/Algiers"),
("2476028", "Tipasa", "Типаса", "DZ", "12", "55", "", "", "", "36.58972", "2.4475", "Africa/Algiers"),
("2476301", "Tindouf", "Тиндуф", "DZ", "12", "54", "", "", "", "27.67111", "-8.14744", "Africa/Algiers"),
("2476396", "Timizart", "", "DZ", "12", "14", "", "", "", "36.8", "4.26667", "Africa/Algiers"),
("2476403", "Timimoun", "", "DZ", "12", "34", "", "", "", "29.26388", "0.23098", "Africa/Algiers"),
("2476412", "el hed", "", "DZ", "12", "18", "", "", "", "36.65", "4.77361", "Africa/Algiers"),
("2476897", "Tiaret", "Тиарет", "DZ", "12", "13", "", "", "", "35.37103", "1.31699", "Africa/Algiers"),
("2476915", "Theniet el Had", "", "DZ", "12", "35", "", "", "", "35.87111", "2.02806", "Africa/Algiers"),
("2476917", "Thenia", "", "DZ", "12", "40", "", "", "", "36.72544", "3.55665", "Africa/Algiers"),
("2477255", "Telerghma", "", "DZ", "12", "48", "", "", "", "36.11653", "6.35434", "Africa/Algiers"),
("2477461", "Tebessa", "Тебесса", "DZ", "12", "33", "", "", "", "35.40417", "8.12417", "Africa/Algiers"),
("2477462", "Tebesbest", "", "DZ", "12", "50", "", "", "", "33.11667", "6.08333", "Africa/Algiers"),
("2477528", "Tazoult-Lambese", "", "DZ", "12", "03", "", "", "", "35.48171", "6.26074", "Africa/Algiers"),
("2478216", "Tamanrasset", "Таманрассете", "DZ", "12", "53", "", "", "", "22.785", "5.52278", "Africa/Algiers"),
("2478226", "Tamalous", "", "DZ", "12", "31", "", "", "", "36.83763", "6.64018", "Africa/Algiers"),
("2478831", "Tadmait", "", "DZ", "12", "40", "", "", "", "36.74413", "3.90045", "Africa/Algiers"),
("2479161", "Sour el Ghozlane", "", "DZ", "12", "21", "", "", "", "36.14766", "3.69123", "Africa/Algiers"),
("2479183", "Souma", "", "DZ", "12", "20", "", "", "", "36.51833", "2.90528", "Africa/Algiers"),
("2479215", "Souk Ahras", "Сук-Ахрас", "DZ", "12", "52", "", "", "", "36.28639", "7.95111", "Africa/Algiers"),
("2479247", "Sougueur", "", "DZ", "12", "13", "", "", "", "35.18568", "1.49612", "Africa/Algiers"),
("2479536", "Skikda", "Скикда", "DZ", "12", "31", "", "", "", "36.87617", "6.90921", "Africa/Algiers"),
("2479609", "Sig", "", "DZ", "12", "26", "", "", "", "35.52832", "-0.19369", "Africa/Algiers"),
("2479916", "Sidi Okba", "", "DZ", "12", "19", "", "", "", "34.74512", "5.89833", "Africa/Algiers"),
("2479966", "Sidi Moussa", "", "DZ", "12", "20", "", "", "", "36.60637", "3.08783", "Africa/Algiers"),
("2480198", "Sidi Merouane", "", "DZ", "12", "48", "", "", "", "36.52056", "6.26111", "Africa/Algiers"),
("2480368", "Sidi Khaled", "", "DZ", "12", "19", "", "", "", "34.387", "4.98785", "Africa/Algiers"),
("2480618", "Sidi ech Chahmi", "", "DZ", "12", "09", "", "", "", "35.65903", "-0.52168", "Africa/Algiers"),
("2481007", "Sidi Bel Abbes", "Сиди-Бель-Аббес", "DZ", "12", "30", "", "", "", "35.18994", "-0.63085", "Africa/Algiers"),
("2481058", "Sidi Amrane", "", "DZ", "12", "50", "", "", "", "33.49885", "6.00803", "Africa/Algiers"),
("2481207", "Sidi Akkacha", "", "DZ", "12", "41", "", "", "", "36.46472", "1.30258", "Africa/Algiers"),
("2481246", "Sidi Aissa", "Сиди-Аисса", "DZ", "12", "27", "", "", "", "35.88548", "3.77236", "Africa/Algiers"),
("2481389", "Sidi Abdelli", "", "DZ", "12", "15", "", "", "", "35.06937", "-1.13706", "Africa/Algiers"),
("2481639", "Sfizef", "", "DZ", "12", "30", "", "", "", "35.23464", "-0.24435", "Africa/Algiers"),
("2481700", "Setif", "Сетиф", "DZ", "12", "12", "", "", "", "36.19112", "5.41373", "Africa/Algiers"),
("2482090", "Sedrata", "", "DZ", "12", "52", "", "", "", "36.12868", "7.53376", "Africa/Algiers"),
("2482159", "Seddouk", "", "DZ", "12", "18", "", "", "", "36.54722", "4.68611", "Africa/Algiers"),
("2482211", "Sebdou", "", "DZ", "12", "15", "", "", "", "34.63703", "-1.33143", "Africa/Algiers"),
("2482390", "Saoula", "", "DZ", "12", "55", "", "", "", "36.70456", "3.02462", "Africa/Algiers"),
("2482447", "Salah Bey", "", "DZ", "12", "12", "", "", "", "35.8545", "5.29053", "Africa/Algiers"),
("2482572", "Saida", "Сайда", "DZ", "12", "10", "", "", "", "34.83034", "0.15171", "Africa/Algiers"),
("2482886", "Rouissat", "", "DZ", "12", "50", "", "", "", "31.92427", "5.35018", "Africa/Algiers"),
("2482908", "Rouiba", "", "DZ", "12", "01", "", "", "", "36.73829", "3.28079", "Africa/Algiers"),
("2482939", "Rouached", "", "DZ", "12", "48", "", "", "", "36.45774", "6.04267", "Africa/Algiers"),
("2483000", "Robbah", "", "DZ", "12", "43", "", "", "", "33.27966", "6.90984", "Africa/Algiers"),
("2483649", "Remchi", "", "DZ", "12", "15", "", "", "", "35.06196", "-1.43362", "Africa/Algiers"),
("2483668", "Relizane", "", "DZ", "12", "51", "", "", "", "35.73734", "0.55599", "Africa/Algiers"),
("2483746", "Reguiba", "", "DZ", "12", "43", "", "", "", "33.56391", "6.70326", "Africa/Algiers"),
("2483757", "Reghaia", "", "DZ", "12", "40", "", "", "", "36.73587", "3.34018", "Africa/Algiers"),
("2483761", "Reggane", "", "DZ", "12", "34", "", "", "", "26.71576", "0.1714", "Africa/Algiers"),
("2483936", "Ras el Oued", "Рас-эль-Уэд", "DZ", "12", "39", "", "", "", "35.9441", "5.03107", "Africa/Algiers"),
("2483968", "Ras el Aioun", "", "DZ", "12", "03", "", "", "", "35.67384", "5.6453", "Africa/Algiers"),
("2484620", "Oum el Bouaghi", "", "DZ", "12", "29", "", "", "", "35.87541", "7.11353", "Africa/Algiers"),
("2484846", "Ouled Mimoun", "", "DZ", "12", "15", "", "", "", "34.90472", "-1.03394", "Africa/Algiers"),
("2485572", "Oued Sly", "", "DZ", "12", "41", "", "", "", "36.10124", "1.19949", "Africa/Algiers"),
("2485582", "Oued Rhiou", "", "DZ", "12", "51", "", "", "", "35.96124", "0.91896", "Africa/Algiers"),
("2485618", "Oued Fodda", "", "DZ", "12", "41", "", "", "", "36.18503", "1.53299", "Africa/Algiers"),
("2485633", "Oued el Alleug", "", "DZ", "12", "55", "", "", "", "36.55528", "2.79028", "Africa/Algiers"),
("2485636", "Oued el Abtal", "Торки-ле-Дюк", "DZ", "12", "26", "", "", "", "35.45595", "0.68778", "Africa/Algiers"),
("2485801", "Ouargla", "Уаргла", "DZ", "12", "50", "", "", "", "31.94932", "5.32502", "Africa/Algiers"),
("2485926", "Oran", "Оран", "DZ", "12", "09", "", "", "", "35.69111", "-0.64167", "Africa/Algiers"),
("2486284", "Nedroma", "", "DZ", "12", "15", "", "", "", "35.01361", "-1.74799", "Africa/Algiers"),
("2486505", "Naciria", "", "DZ", "12", "40", "", "", "", "36.74625", "3.83163", "Africa/Algiers"),
("2486690", "M'Sila", "", "DZ", "12", "27", "", "", "", "35.70583", "4.54194", "Africa/Algiers"),
("2486825", "Mouzaia", "", "DZ", "12", "55", "", "", "", "36.46695", "2.68991", "Africa/Algiers"),
("2487134", "Mostaganem", "Мостаганем", "DZ", "12", "07", "", "", "", "35.93115", "0.08918", "Africa/Algiers"),
("2487452", "Mila", "", "DZ", "12", "48", "", "", "", "36.45028", "6.26444", "Africa/Algiers"),
("2487620", "Metlili Chaamba", "", "DZ", "12", "45", "", "", "", "32.26667", "3.63333", "Africa/Algiers"),
("2487772", "Messaad", "Мессад", "DZ", "12", "22", "", "", "", "34.15429", "3.50309", "Africa/Algiers"),
("2487805", "Meskiana", "", "DZ", "12", "29", "", "", "", "35.63058", "7.66606", "Africa/Algiers"),
("2487852", "Mers el Kebir", "Мерс-эль-Кебир", "DZ", "12", "09", "", "", "", "35.7279", "-0.7081", "Africa/Algiers"),
("2487882", "Merouana", "", "DZ", "12", "03", "", "", "", "35.63106", "5.91186", "Africa/Algiers"),
("2488202", "Melouza", "", "DZ", "12", "39", "", "", "", "35.97999", "4.18665", "Africa/Algiers"),
("2488500", "Mekla", "", "DZ", "12", "14", "", "", "", "36.68178", "4.26378", "Africa/Algiers"),
("2488616", "Mehdia", "Махдия", "DZ", "12", "13", "", "", "", "35.43058", "1.75714", "Africa/Algiers"),
("2488716", "Megarine", "", "DZ", "12", "50", "", "", "", "33.19195", "6.08695", "Africa/Algiers"),
("2488722", "Meftah", "Мефтах", "DZ", "12", "20", "", "", "", "36.6204", "3.22248", "Africa/Algiers"),
("2488835", "Medea", "Медея", "DZ", "12", "06", "", "", "", "36.26417", "2.75393", "Africa/Algiers"),
("2489987", "Mazouna", "", "DZ", "12", "51", "", "", "", "36.12232", "0.89865", "Africa/Algiers"),
("2490098", "Mascara", "", "DZ", "12", "26", "", "", "", "35.39664", "0.14027", "Africa/Algiers"),
("2490180", "Mansourah", "Мансур", "DZ", "12", "39", "", "", "", "36.08725", "4.45192", "Africa/Algiers"),
("2490183", "Mansoura", "Мансура", "DZ", "12", "15", "", "", "", "34.86158", "-1.33935", "Africa/Algiers"),
("2490297", "Makouda", "", "DZ", "12", "40", "", "", "", "36.78567", "4.06273", "Africa/Algiers"),
("2491042", "L'Arbaa Nait Irathen", "", "DZ", "12", "14", "", "", "", "36.63112", "4.19864", "Africa/Algiers"),
("2491050", "Larbaa", "Ларба", "DZ", "12", "03", "", "", "", "36.56471", "3.15434", "Africa/Algiers"),
("2491134", "Lakhdaria", "", "DZ", "12", "21", "", "", "", "36.56463", "3.5933", "Africa/Algiers"),
("2491191", "Laghouat", "Лагуат", "DZ", "12", "25", "", "", "", "33.8", "2.86514", "Africa/Algiers"),
("2491323", "Ksar el Boukhari", "", "DZ", "12", "06", "", "", "", "35.88889", "2.74905", "Africa/Algiers"),
("2491335", "Ksar Chellala", "", "DZ", "12", "13", "", "", "", "35.21222", "2.31889", "Africa/Algiers"),
("2491578", "Kolea", "", "DZ", "12", "55", "", "", "", "36.63888", "2.76845", "Africa/Algiers"),
("2491889", "Khenchela", "", "DZ", "12", "47", "", "", "", "35.43583", "7.14333", "Africa/Algiers"),
("2491911", "Khemis Miliana", "", "DZ", "12", "35", "", "", "", "36.26104", "2.22015", "Africa/Algiers"),
("2491913", "Khemis el Khechna", "", "DZ", "12", "40", "", "", "", "36.64997", "3.3308", "Africa/Algiers"),
("2492345", "Kerkera", "", "DZ", "12", "31", "", "", "", "36.92917", "6.58556", "Africa/Algiers"),
("2492913", "Jijel", "Джиджель", "DZ", "12", "24", "", "", "", "36.82055", "5.76671", "Africa/Algiers"),
("2492920", "Djidiouia", "", "DZ", "12", "51", "", "", "", "35.92989", "0.82871", "Africa/Algiers"),
("2492991", "Isser", "", "DZ", "12", "40", "", "", "", "36.71859", "3.66924", "Africa/Algiers"),
("2493222", "I-n-Salah", "", "DZ", "12", "53", "", "", "", "27.19351", "2.46069", "Africa/Algiers"),
("2493605", "Ighram", "", "DZ", "12", "14", "", "", "", "36.46295", "4.50532", "Africa/Algiers"),
("2493918", "Hennaya", "", "DZ", "12", "15", "", "", "", "34.95139", "-1.36806", "Africa/Algiers"),
("2493956", "Heliopolis", "", "DZ", "12", "23", "", "", "", "36.50361", "7.44278", "Africa/Algiers"),
("2494029", "Hassi Messaoud", "Хасси-Мессауд", "DZ", "12", "50", "", "", "", "31.68041", "6.07286", "Africa/Algiers"),
("2494548", "Hammamet", "Хаммамет", "DZ", "12", "33", "", "", "", "35.44862", "7.95184", "Africa/Algiers"),
("2494554", "Hammam Bou Hadjar", "", "DZ", "12", "36", "", "", "", "35.37889", "-0.96778", "Africa/Algiers"),
("2494610", "Hamma Bouziane", "", "DZ", "12", "04", "", "", "", "36.41205", "6.59603", "Africa/Algiers"),
("2494962", "Hadjout", "", "DZ", "12", "55", "", "", "", "36.51257", "2.41382", "Africa/Algiers"),
("2495662", "Guelma", "Гельма", "DZ", "12", "23", "", "", "", "36.46214", "7.42608", "Africa/Algiers"),
("2496049", "Ghardaia", "Гардая", "DZ", "12", "45", "", "", "", "32.49094", "3.67347", "Africa/Algiers"),
("2496232", "Frenda", "", "DZ", "12", "13", "", "", "", "35.06544", "1.04945", "Africa/Algiers"),
("2496241", "Freha", "", "DZ", "12", "14", "", "", "", "36.75234", "4.3155", "Africa/Algiers"),
("2496573", "Feraoun", "", "DZ", "12", "18", "", "", "", "36.5604", "4.85454", "Africa/Algiers"),
("2497060", "Es Senia", "", "DZ", "12", "09", "", "", "", "35.64779", "-0.62397", "Africa/Algiers"),
("2497323", "El Tarf", "", "DZ", "12", "44", "", "", "", "36.7672", "8.31377", "Africa/Algiers"),
("2497411", "El Oued", "Эль-Уэд", "DZ", "12", "43", "", "", "", "33.35608", "6.86319", "Africa/Algiers"),
("2497714", "El Malah", "", "DZ", "12", "36", "", "", "", "35.39138", "-1.09238", "Africa/Algiers"),
("2497796", "El Kseur", "", "DZ", "12", "18", "", "", "", "36.67942", "4.8555", "Africa/Algiers"),
("2497849", "El Khroub", "", "DZ", "12", "04", "", "", "", "36.26333", "6.69361", "Africa/Algiers"),
("2497988", "El Kala", "Эль-Калы", "DZ", "12", "44", "", "", "", "36.89556", "8.44333", "Africa/Algiers"),
("2498000", "El Idrissia", "", "DZ", "12", "22", "", "", "", "34.44542", "2.52749", "Africa/Algiers"),
("2498172", "El Hadjira", "", "DZ", "12", "50", "", "", "", "32.61336", "5.51259", "Africa/Algiers"),
("2498183", "El Hadjar", "", "DZ", "12", "37", "", "", "", "36.80377", "7.73684", "Africa/Algiers"),
("2498392", "El Eulma", "", "DZ", "12", "12", "", "", "", "36.15281", "5.69016", "Africa/Algiers"),
("2498543", "El Bayadh", "", "DZ", "12", "42", "", "", "", "33.68318", "1.01927", "Africa/Algiers"),
("2498590", "El Attaf", "Эль-Аттафом", "DZ", "12", "35", "", "", "", "36.22393", "1.67187", "Africa/Algiers"),
("2498611", "Chlef", "Шлеф", "DZ", "12", "41", "", "", "", "36.16525", "1.33452", "Africa/Algiers"),
("2498667", "El Aouinet", "", "DZ", "12", "29", "", "", "", "35.86691", "7.88672", "Africa/Algiers"),
("2498704", "El Amria", "", "DZ", "12", "36", "", "", "", "35.52439", "-1.01577", "Africa/Algiers"),
("2498752", "El Affroun", "", "DZ", "12", "55", "", "", "", "36.4701", "2.62528", "Africa/Algiers"),
("2498766", "El Achir", "", "DZ", "12", "39", "", "", "", "36.06386", "4.62744", "Africa/Algiers"),
("2498775", "El Abiodh Sidi Cheikh", "", "DZ", "12", "42", "", "", "", "32.893", "0.54839", "Africa/Algiers"),
("2498782", "El Abadia", "", "DZ", "12", "35", "", "", "", "36.26951", "1.68609", "Africa/Algiers"),
("2498954", "Ech Chettia", "", "DZ", "12", "41", "", "", "", "36.19591", "1.25538", "Africa/Algiers"),
("2499055", "Drean", "", "DZ", "12", "37", "", "", "", "36.68482", "7.75111", "Africa/Algiers"),
("2499104", "Draa el Mizan", "Дра-эль-Мизан", "DZ", "12", "21", "", "", "", "36.53628", "3.8334", "Africa/Algiers"),
("2499116", "Draa Ben Khedda", "", "DZ", "12", "40", "", "", "", "36.73436", "3.96223", "Africa/Algiers"),
("2499193", "Douera", "", "DZ", "12", "55", "", "", "", "36.67", "2.94444", "Africa/Algiers"),
("2500017", "Djelfa", "", "DZ", "12", "22", "", "", "", "34.67279", "3.263", "Africa/Algiers"),
("2500282", "Djamaa", "", "DZ", "12", "50", "", "", "", "33.53388", "5.99306", "Africa/Algiers"),
("2500401", "Didouche Mourad", "", "DZ", "12", "04", "", "", "", "36.4525", "6.63639", "Africa/Algiers"),
("2500583", "Dellys", "", "DZ", "12", "40", "", "", "", "36.91716", "3.91311", "Africa/Algiers"),
("2500737", "Debila", "", "DZ", "12", "43", "", "", "", "33.51667", "6.95", "Africa/Algiers"),
("2500889", "Dar el Beida", "Дар-эль-Бейда", "DZ", "12", "01", "", "", "", "36.71333", "3.2125", "Africa/Algiers"),
("2500904", "Dar Chioukh", "", "DZ", "12", "22", "", "", "", "34.89638", "3.48543", "Africa/Algiers"),
("2501152", "Constantine", "", "DZ", "12", "04", "", "", "", "36.365", "6.61472", "Africa/Algiers"),
("2501289", "Chorfa", "Чорфа", "DZ", "12", "21", "", "", "", "36.36505", "4.32636", "Africa/Algiers"),
("2501323", "Chiffa", "", "DZ", "12", "20", "", "", "", "36.46293", "2.73873", "Africa/Algiers"),
("2501362", "Chetouane", "", "DZ", "12", "15", "", "", "", "34.92129", "-1.29512", "Africa/Algiers"),
("2501404", "Cheria", "", "DZ", "12", "33", "", "", "", "35.27306", "7.75194", "Africa/Algiers"),
("2501465", "Cheraga", "", "DZ", "12", "55", "", "", "", "36.76775", "2.95924", "Africa/Algiers"),
("2501508", "Chemini", "", "DZ", "12", "14", "", "", "", "36.6", "4.61667", "Africa/Algiers"),
("2501541", "Chelghoum el Aid", "", "DZ", "12", "48", "", "", "", "36.16286", "6.16651", "Africa/Algiers"),
("2501680", "Chebli", "", "DZ", "12", "20", "", "", "", "36.57722", "3.00917", "Africa/Algiers"),
("2501767", "Charef", "", "DZ", "12", "22", "", "", "", "34.62098", "2.79503", "Africa/Algiers"),
("2501873", "Chabet el Ameur", "", "DZ", "12", "40", "", "", "", "36.63709", "3.69474", "Africa/Algiers"),
("2502034", "Brezina", "", "DZ", "12", "42", "", "", "", "33.09892", "1.26082", "Africa/Algiers"),
("2502239", "Bou Tlelis", "", "DZ", "12", "09", "", "", "", "35.57272", "-0.8996", "Africa/Algiers"),
("2502686", "Boumahra Ahmed", "", "DZ", "12", "23", "", "", "", "36.45833", "7.51389", "Africa/Algiers"),
("2502924", "Boukadir", "Бу-Кадир", "DZ", "12", "41", "", "", "", "36.06629", "1.12602", "Africa/Algiers"),
("2502939", "Bou Ismail", "Бу-Исмаил", "DZ", "12", "55", "", "", "", "36.64262", "2.69007", "Africa/Algiers"),
("2502958", "Bouira", "", "DZ", "12", "21", "", "", "", "36.37489", "3.902", "Africa/Algiers"),
("2502962", "Bouinan", "", "DZ", "12", "20", "", "", "", "36.53167", "2.99194", "Africa/Algiers"),
("2503033", "Bou Hanifia el Hamamat", "", "DZ", "12", "26", "", "", "", "35.31473", "-0.05037", "Africa/Algiers"),
("2503147", "Bougara", "", "DZ", "12", "20", "", "", "", "36.54178", "3.081", "Africa/Algiers"),
("2503156", "Bougaa", "", "DZ", "12", "12", "", "", "", "36.33293", "5.08843", "Africa/Algiers"),
("2503181", "Boufarik", "", "DZ", "12", "20", "", "", "", "36.57412", "2.91214", "Africa/Algiers"),
("2503229", "Boudouaou", "", "DZ", "12", "40", "", "", "", "36.72735", "3.40995", "Africa/Algiers"),
("2503237", "Boudjima", "", "DZ", "12", "14", "", "", "", "36.80218", "4.15187", "Africa/Algiers"),
("2503468", "Bou Arfa", "", "DZ", "12", "20", "", "", "", "36.46298", "2.81464", "Africa/Algiers"),
("2503620", "Bordj Zemoura", "", "DZ", "12", "39", "", "", "", "36.27462", "4.85668", "Africa/Algiers"),
("2503654", "Bordj Ghdir", "", "DZ", "12", "39", "", "", "", "35.90111", "4.89806", "Africa/Algiers"),
("2503661", "Bordj el Kiffan", "", "DZ", "12", "01", "", "", "", "36.74871", "3.19248", "Africa/Algiers"),
("2503701", "Bordj Bou Arreridj", "", "DZ", "12", "39", "", "", "", "36.07322", "4.76108", "Africa/Algiers"),
("2503755", "Boghni", "", "DZ", "12", "14", "", "", "", "36.54222", "3.95306", "Africa/Algiers"),
("2503769", "Blida", "Блида", "DZ", "12", "20", "", "", "", "36.47004", "2.8277", "Africa/Algiers"),
("2503826", "Biskra", "Бискра", "DZ", "12", "19", "", "", "", "34.85038", "5.72805", "Africa/Algiers"),
("2503847", "Birkhadem", "", "DZ", "12", "01", "", "", "", "36.71499", "3.05002", "Africa/Algiers"),
("2503852", "Birine", "", "DZ", "12", "22", "", "", "", "35.635", "3.225", "Africa/Algiers"),
("2503874", "Bir el Djir", "", "DZ", "12", "09", "", "", "", "35.72", "-0.545", "Africa/Algiers"),
("2503878", "Bir el Ater", "", "DZ", "12", "33", "", "", "", "34.74488", "8.06024", "Africa/Algiers"),
("2504072", "Besbes", "", "DZ", "12", "44", "", "", "", "36.70222", "7.84722", "Africa/Algiers"),
("2504099", "Berrouaghia", "", "DZ", "12", "06", "", "", "", "36.13516", "2.91085", "Africa/Algiers"),
("2504110", "Berriane", "", "DZ", "12", "45", "", "", "", "32.82648", "3.7669", "Africa/Algiers"),
("2504136", "Berrahal", "", "DZ", "12", "37", "", "", "", "36.83528", "7.45333", "Africa/Algiers"),
("2504385", "Bensekrane", "", "DZ", "12", "15", "", "", "", "35.07465", "-1.22431", "Africa/Algiers"),
("2504486", "Ben Mehidi", "", "DZ", "12", "44", "", "", "", "36.76967", "7.9064", "Africa/Algiers"),
("2504581", "Beni Saf", "", "DZ", "12", "36", "", "", "", "35.30099", "-1.38226", "Africa/Algiers"),
("2504616", "Beni Mester", "", "DZ", "12", "15", "", "", "", "34.87045", "-1.42319", "Africa/Algiers"),
("2504622", "Beni Mered", "", "DZ", "12", "20", "", "", "", "36.52389", "2.86131", "Africa/Algiers"),
("2504703", "Beni Douala", "", "DZ", "12", "14", "", "", "", "36.61954", "4.08282", "Africa/Algiers"),
("2504739", "Beni Amrane", "", "DZ", "12", "40", "", "", "", "36.66774", "3.59115", "Africa/Algiers"),
("2505329", "Bejaia", "", "DZ", "12", "18", "", "", "", "36.75587", "5.08433", "Africa/Algiers"),
("2505530", "Bechar", "Бешаре", "DZ", "12", "38", "", "", "", "31.61667", "-2.21667", "Africa/Algiers"),
("2505572", "Batna", "Батна", "DZ", "12", "03", "", "", "", "35.55597", "6.17414", "Africa/Algiers"),
("2505629", "Barika", "Барика", "DZ", "12", "03", "", "", "", "35.38901", "5.36584", "Africa/Algiers"),
("2505651", "Barbacha", "", "DZ", "12", "18", "", "", "", "36.56667", "4.96667", "Africa/Algiers"),
("2505653", "Baraki", "", "DZ", "12", "55", "", "", "", "36.66655", "3.09606", "Africa/Algiers"),
("2505854", "Bab Ezzouar", "", "DZ", "12", "01", "", "", "", "36.72615", "3.18291", "Africa/Algiers"),
("2505915", "Azzaba", "", "DZ", "12", "31", "", "", "", "36.73944", "7.10528", "Africa/Algiers"),
("2506043", "Azazga", "", "DZ", "12", "14", "", "", "", "36.74472", "4.37222", "Africa/Algiers"),
("2506404", "Arris", "", "DZ", "12", "03", "", "", "", "35.25881", "6.34706", "Africa/Algiers"),
("2506519", "Arhribs", "", "DZ", "12", "14", "", "", "", "36.79361", "4.31158", "Africa/Algiers"),
("2506623", "Arbatache", "", "DZ", "12", "40", "", "", "", "36.63773", "3.37127", "Africa/Algiers"),
("2506795", "Aoulef", "", "DZ", "12", "34", "", "", "", "26.96667", "1.08333", "Africa/Algiers"),
("2506999", "Annaba", "Аннаба", "DZ", "12", "37", "", "", "", "36.9", "7.76667", "Africa/Algiers"),
("2507155", "Ammi Moussa", "", "DZ", "12", "51", "", "", "", "35.86781", "1.11143", "Africa/Algiers"),
("2507169", "Amizour", "", "DZ", "12", "18", "", "", "", "36.64022", "4.90131", "Africa/Algiers"),
("2507480", "Algiers", "Алжир", "DZ", "12", "01", "", "", "", "36.7525", "3.04197", "Africa/Algiers"),
("2507646", "Akbou", "", "DZ", "12", "18", "", "", "", "36.4575", "4.53494", "Africa/Algiers"),
("2507877", "Ain Touta", "", "DZ", "12", "03", "", "", "", "35.37675", "5.90001", "Africa/Algiers"),
("2507901", "'Ain Temouchent", "", "DZ", "12", "36", "", "", "", "35.29749", "-1.14037", "Africa/Algiers"),
("2507912", "Ain Taya", "", "DZ", "12", "01", "", "", "", "36.79333", "3.28694", "Africa/Algiers"),
("2507926", "Ain Smara", "", "DZ", "12", "04", "", "", "", "36.2674", "6.50135", "Africa/Algiers"),
("2507943", "Ain Sefra", "", "DZ", "12", "49", "", "", "", "32.75", "-0.58333", "Africa/Algiers"),
("2507972", "Ain Oussera", "", "DZ", "12", "22", "", "", "", "35.45139", "2.90583", "Africa/Algiers"),
("2508010", "'Ain Merane", "", "DZ", "12", "51", "", "", "", "36.16277", "0.97037", "Africa/Algiers"),
("2508059", "Ain Kercha", "", "DZ", "12", "29", "", "", "", "35.92472", "6.69528", "Africa/Algiers"),
("2508102", "Ain Fakroun", "", "DZ", "12", "29", "", "", "", "35.97108", "6.87374", "Africa/Algiers"),
("2508119", "'Ain el Turk", "Айн-эль-Терк", "DZ", "12", "09", "", "", "", "35.74381", "-0.7693", "Africa/Algiers"),
("2508130", "'Ain el Melh", "Айн-эль-Мельх", "DZ", "12", "27", "", "", "", "34.84146", "4.16383", "Africa/Algiers"),
("2508152", "'Ain el Hammam", "Айн-эль-Хаммам", "DZ", "12", "14", "", "", "", "36.56471", "4.30619", "Africa/Algiers"),
("2508157", "`Ain el Hadjel", "", "DZ", "12", "27", "", "", "", "35.67003", "3.88153", "Africa/Algiers"),
("2508174", "Ain el Bya", "", "DZ", "12", "09", "", "", "", "35.80389", "-0.30178", "Africa/Algiers"),
("2508180", "'Ain el Berd", "", "DZ", "12", "30", "", "", "", "35.36395", "-0.51278", "Africa/Algiers"),
("2508184", "'Ain el Bell", "Айн-эль-Белла", "DZ", "12", "22", "", "", "", "34.3438", "3.22475", "Africa/Algiers"),
("2508225", "'Ain Deheb", "", "DZ", "12", "13", "", "", "", "34.84218", "1.54698", "Africa/Algiers"),
("2508228", "Ain Defla", "", "DZ", "12", "35", "", "", "", "36.26406", "1.9679", "Africa/Algiers"),
("2508268", "Ain Bessem", "", "DZ", "12", "21", "", "", "", "36.29333", "3.67319", "Africa/Algiers"),
("2508275", "'Ain Benian", "", "DZ", "12", "55", "", "", "", "36.80277", "2.92185", "Africa/Algiers"),
("2508287", "Ain Beida", "", "DZ", "12", "29", "", "", "", "35.79639", "7.39278", "Africa/Algiers"),
("2508297", "Ain Arnat", "", "DZ", "12", "12", "", "", "", "36.18683", "5.31347", "Africa/Algiers"),
("2508309", "'Ain Abid", "", "DZ", "12", "04", "", "", "", "36.23194", "6.94333", "Africa/Algiers"),
("2508737", "Aflou", "", "DZ", "12", "25", "", "", "", "34.1128", "2.10228", "Africa/Algiers"),
("2508813", "Adrar", "Адрар", "DZ", "12", "34", "", "", "", "27.87429", "-0.29388", "Africa/Algiers"),
("2509031", "Abou el Hassan", "", "DZ", "12", "41", "", "", "", "36.41657", "1.19616", "Africa/Algiers"),
("6698360", "BABOR - VILLE", "", "DZ", "12", "12", "", "", "", "36.48994", "5.5393", "Africa/Algiers"),
("587577", "Viljandi", "Вильянди", "EE", "233", "20", "0897", "", "", "58.36389", "25.59", "Europe/Tallinn"),
("588335", "Tartu", "Тарту", "EE", "233", "18", "0795", "", "", "58.38062", "26.72509", "Europe/Tallinn"),
("588409", "Tallinn", "Таллин", "EE", "233", "01", "0784", "", "", "59.43696", "24.75353", "Europe/Tallinn"),
("588686", "Sillamae", "Силламяэ", "EE", "233", "03", "0735", "", "", "59.39697", "27.76331", "Europe/Tallinn"),
("589165", "Rakvere", "Раквере", "EE", "233", "08", "0663", "", "", "59.34639", "26.35583", "Europe/Tallinn"),
("589580", "Parnu", "Пярну", "EE", "233", "11", "0625", "", "", "58.38588", "24.49711", "Europe/Tallinn"),
("590031", "Narva", "Нарва", "EE", "233", "03", "0511", "", "", "59.37722", "28.19028", "Europe/Tallinn"),
("590447", "Maardu", "Маарду", "EE", "233", "01", "0446", "", "", "59.47667", "25.025", "Europe/Tallinn"),
("591260", "Kohtla-Jarve", "Кохтла-Ярве", "EE", "233", "03", "0322", "", "", "59.39861", "27.27306", "Europe/Tallinn"),
("346030", "Zifta", "Зифта", "EG", "818", "05", "", "", "", "30.7142", "31.24425", "Africa/Cairo"),
("347236", "Toukh", "Тух", "EG", "818", "12", "", "", "", "30.35394", "31.20071", "Africa/Cairo"),
("347497", "Tanda", "Танта", "EG", "818", "05", "", "", "", "30.78847", "31.00192", "Africa/Cairo"),
("347542", "Tamiyah", "", "EG", "818", "04", "", "", "", "29.47639", "30.96119", "Africa/Cairo"),
("347591", "Talkha", "", "EG", "818", "01", "", "", "", "31.0539", "31.37787", "Africa/Cairo"),
("347612", "Tala", "Тале", "EG", "818", "09", "", "", "", "30.68025", "30.94292", "Africa/Cairo"),
("347634", "Tahta", "Тахта", "EG", "818", "24", "", "", "", "26.7693", "31.50214", "Africa/Cairo"),
("347749", "Sumusta as Sultani", "", "EG", "818", "18", "", "", "", "28.91667", "30.85", "Africa/Cairo"),
("347796", "Sohag", "Сохаг", "EG", "818", "24", "", "", "", "26.55695", "31.69478", "Africa/Cairo"),
("348112", "Sidi Salim", "", "EG", "818", "21", "", "", "", "31.27105", "30.78665", "Africa/Cairo"),
("349114", "Shirbin", "", "EG", "818", "01", "", "", "", "31.19688", "31.5243", "Africa/Cairo"),
("349156", "Shibin al Qanatir", "", "EG", "818", "12", "", "", "", "30.31269", "31.32018", "Africa/Cairo"),
("349158", "Shibin al Kawm", "", "EG", "818", "09", "", "", "", "30.55258", "31.00904", "Africa/Cairo"),
("349715", "Samannud", "", "EG", "818", "05", "", "", "", "30.9616", "31.24069", "Africa/Cairo"),
("349717", "Samalut", "", "EG", "818", "10", "", "", "", "28.31214", "30.71007", "Africa/Cairo"),
("350203", "Rosetta", "", "EG", "818", "03", "", "", "", "31.40444", "30.41639", "Africa/Cairo"),
("350370", "Quwaysina", "", "EG", "818", "09", "", "", "", "30.56482", "31.15777", "Africa/Cairo"),
("350376", "Qutur", "", "EG", "818", "05", "", "", "", "30.97225", "30.95614", "Africa/Cairo"),
("350422", "Kousa", "", "EG", "818", "23", "", "", "", "25.91407", "32.76362", "Africa/Cairo"),
("350550", "Qina", "", "EG", "818", "23", "", "", "", "26.16418", "32.72671", "Africa/Cairo"),
("350789", "Qalyub", "Кальюб", "EG", "818", "12", "", "", "", "30.17922", "31.2056", "Africa/Cairo"),
("351434", "Naj` Hammadi", "", "EG", "818", "23", "", "", "", "26.04949", "32.24142", "Africa/Cairo"),
("352344", "Minyat an Nasr", "", "EG", "818", "01", "", "", "", "31.12624", "31.64313", "Africa/Cairo"),
("352354", "Minuf", "", "EG", "818", "09", "", "", "", "30.46579", "30.93164", "Africa/Cairo"),
("352628", "Matay", "", "EG", "818", "10", "", "", "", "28.41899", "30.77924", "Africa/Cairo"),
("352679", "Mashtul as Suq", "", "EG", "818", "14", "", "", "", "30.36056", "31.3776", "Africa/Cairo"),
("352733", "Mersa Matruh", "Марса-Матрух", "EG", "818", "22", "", "", "", "31.3529", "27.23725", "Africa/Cairo"),
("352913", "Manfalut", "", "EG", "818", "17", "", "", "", "27.3104", "30.97004", "Africa/Cairo"),
("352951", "Mallawi", "Маллави", "EG", "818", "10", "", "", "", "27.7314", "30.84165", "Africa/Cairo"),
("353219", "Madinat Sittah Uktubar", "", "EG", "818", "08", "", "", "", "29.81667", "31.05", "Africa/Cairo"),
("353802", "Kawm Umbu", "Ком-Омбо", "EG", "818", "16", "", "", "", "24.47669", "32.94626", "Africa/Cairo"),
("353828", "Kawm Hamadah", "", "EG", "818", "03", "", "", "", "30.76096", "30.69733", "Africa/Cairo"),
("354105", "Kafr Saqr", "", "EG", "818", "14", "", "", "", "30.79336", "31.62575", "Africa/Cairo"),
("354365", "Kafr az Zayyat", "", "EG", "818", "05", "", "", "", "30.8248", "30.81805", "Africa/Cairo"),
("354502", "Kafr ash Shaykh", "", "EG", "818", "21", "", "", "", "31.1143", "30.94012", "Africa/Cairo"),
("354775", "Kafr ad Dawwar", "", "EG", "818", "03", "", "", "", "31.13385", "30.12843", "Africa/Cairo"),
("354981", "Juhaynah", "", "EG", "818", "24", "", "", "", "26.67319", "31.4976", "Africa/Cairo"),
("355026", "Jirja", "", "EG", "818", "24", "", "", "", "26.33826", "31.89161", "Africa/Cairo"),
("355392", "`Izbat al Burj", "", "EG", "818", "01", "", "", "", "31.5084", "31.84106", "Africa/Cairo"),
("355420", "Itsa", "", "EG", "818", "04", "", "", "", "29.2376", "30.78944", "Africa/Cairo"),
("355449", "Isna", "Эсна", "EG", "818", "23", "", "", "", "25.29336", "32.55402", "Africa/Cairo"),
("355628", "Idku", "Идку", "EG", "818", "03", "", "", "", "31.30782", "30.29901", "Africa/Cairo"),
("355648", "Ibshaway", "", "EG", "818", "04", "", "", "", "29.35804", "30.68142", "Africa/Cairo"),
("355795", "Halwan", "Хелуан", "EG", "818", "11", "", "", "", "29.84144", "31.30084", "Africa/Cairo"),
("355939", "Hihya", "", "EG", "818", "14", "", "", "", "30.6713", "31.58801", "Africa/Cairo"),
("356000", "Hawsh `Isa", "", "EG", "818", "03", "", "", "", "30.9128", "30.29018", "Africa/Cairo"),
("356806", "Fuwah", "", "EG", "818", "21", "", "", "", "31.20291", "30.55018", "Africa/Cairo"),
("356933", "Farshut", "", "EG", "818", "23", "", "", "", "26.05494", "32.16329", "Africa/Cairo"),
("356945", "Faraskur", "", "EG", "818", "20", "", "", "", "31.32977", "31.71507", "Africa/Cairo"),
("356989", "Faqus", "", "EG", "818", "14", "", "", "", "30.73006", "31.80182", "Africa/Cairo"),
("358048", "Damietta", "Думьят", "EG", "818", "20", "", "", "", "31.41648", "31.81332", "Africa/Cairo"),
("358095", "Diyarb Najm", "", "EG", "818", "14", "", "", "", "30.75438", "31.44016", "Africa/Cairo"),
("358108", "Disuq", "Дисук", "EG", "818", "21", "", "", "", "31.13305", "30.64649", "Africa/Cairo"),
("358115", "Dishna", "", "EG", "818", "23", "", "", "", "26.12467", "32.47598", "Africa/Cairo"),
("358172", "Dikirnis", "Дикирнис", "EG", "818", "01", "", "", "", "31.08898", "31.59478", "Africa/Cairo"),
("358269", "Dayrut", "", "EG", "818", "17", "", "", "", "27.55602", "30.80764", "Africa/Cairo"),
("358274", "Dayr Mawas", "", "EG", "818", "10", "", "", "", "27.64176", "30.84662", "Africa/Cairo"),
("358448", "Damanhur", "Даманхур", "EG", "818", "03", "", "", "", "31.03408", "30.46823", "Africa/Cairo"),
("358600", "Bush", "", "EG", "818", "18", "", "", "", "29.14816", "31.12733", "Africa/Cairo"),
("358619", "Port Said", "Порт-Саид", "EG", "818", "19", "", "", "", "31.25654", "32.28412", "Africa/Cairo"),
("358620", "Bur Safajah", "Сафага", "EG", "818", "02", "", "", "", "26.72918", "33.93651", "Africa/Cairo"),
("358821", "Bilqas", "", "EG", "818", "01", "", "", "", "31.21452", "31.35798", "Africa/Cairo"),
("358840", "Bilbays", "", "EG", "818", "14", "", "", "", "30.42039", "31.56223", "Africa/Cairo"),
("358970", "Basyun", "", "EG", "818", "05", "", "", "", "30.93976", "30.81338", "Africa/Cairo"),
("359173", "Bani Suwayf", "", "EG", "818", "18", "", "", "", "29.07441", "31.09785", "Africa/Cairo"),
("359212", "Bani Mazar", "", "EG", "818", "10", "", "", "", "28.5036", "30.8004", "Africa/Cairo"),
("359280", "Banha", "Банха", "EG", "818", "12", "", "", "", "30.45906", "31.17858", "Africa/Cairo"),
("359493", "Zagazig", "Эз-Заказик", "EG", "818", "14", "", "", "", "30.58768", "31.502", "Africa/Cairo"),
("359576", "Awsim", "", "EG", "818", "08", "", "", "", "30.12303", "31.13571", "Africa/Cairo"),
("359710", "At Tall al Kabir", "", "EG", "818", "07", "", "", "", "30.54448", "31.78525", "Africa/Cairo"),
("359783", "Asyut", "Асьют", "EG", "818", "17", "", "", "", "27.18096", "31.18368", "Africa/Cairo"),
("359792", "Aswan", "Асуан", "EG", "818", "16", "", "", "", "24.09082", "32.89942", "Africa/Cairo"),
("359796", "Suez", "Суэц", "EG", "818", "15", "", "", "", "29.97371", "32.52627", "Africa/Cairo"),
("359900", "As Saff", "", "EG", "818", "08", "", "", "", "29.56472", "31.28111", "Africa/Cairo"),
("359953", "Ash Shuhada'", "", "EG", "818", "09", "", "", "", "30.59618", "30.89875", "Africa/Cairo"),
("360048", "Ashmun", "", "EG", "818", "09", "", "", "", "30.29857", "30.97635", "Africa/Cairo"),
("360464", "Al Wasitah", "", "EG", "818", "04", "", "", "", "29.33778", "31.20556", "Africa/Cairo"),
("360502", "Luxor", "Луксор", "EG", "818", "28", "", "", "", "25.69893", "32.6421", "Africa/Cairo"),
("360526", "Al Qusiyah", "", "EG", "818", "17", "", "", "", "27.4402", "30.81841", "Africa/Cairo"),
("360531", "Al Qusayr", "Аль-Кусайра", "EG", "818", "02", "", "", "", "26.10426", "34.27793", "Africa/Cairo"),
("360542", "Al Qurayn", "Аль-Эль-Курайн", "EG", "818", "14", "", "", "", "30.61618", "31.73514", "Africa/Cairo"),
("360612", "Al Qanayat", "", "EG", "818", "14", "", "", "", "30.6188", "31.46099", "Africa/Cairo"),
("360615", "Al Qanatir al Khayriyah", "", "EG", "818", "12", "", "", "", "30.19327", "31.13703", "Africa/Cairo"),
("360630", "Cairo", "Каир", "EG", "818", "11", "", "", "", "30.06263", "31.24967", "Africa/Cairo"),
("360686", "Al Minya", "Эль-Минья", "EG", "818", "10", "", "", "", "28.10988", "30.7503", "Africa/Cairo"),
("360716", "Al Matariyah", "", "EG", "818", "01", "", "", "", "31.18287", "32.03108", "Africa/Cairo"),
("360754", "Al Manzilah", "", "EG", "818", "01", "", "", "", "31.15815", "31.937", "Africa/Cairo"),
("360761", "Al Mansurah", "", "EG", "818", "01", "", "", "", "31.03637", "31.38069", "Africa/Cairo"),
("360773", "Al Manshah", "", "EG", "818", "24", "", "", "", "26.47686", "31.8035", "Africa/Cairo"),
("360829", "Al Mahallah al Kubra", "", "EG", "818", "05", "", "", "", "30.97063", "31.1669", "Africa/Cairo"),
("360923", "Al Kharijah", "", "EG", "818", "13", "", "", "", "25.4514", "30.54635", "Africa/Cairo"),
("360928", "Al Khankah", "", "EG", "818", "12", "", "", "", "30.21035", "31.36812", "Africa/Cairo"),
("360995", "Al Jizah", "Гиза", "EG", "818", "08", "", "", "", "30.00808", "31.21093", "Africa/Cairo"),
("361029", "Al Jamaliyah", "", "EG", "818", "01", "", "", "", "31.18086", "31.86518", "Africa/Cairo"),
("361055", "Ismailia", "Исмаилия", "EG", "818", "07", "", "", "", "30.60427", "32.27225", "Africa/Cairo"),
("361058", "Alexandria", "Александрия", "EG", "818", "06", "", "", "", "31.21564", "29.95527", "Africa/Cairo"),
("361103", "Al Ibrahimiyah", "", "EG", "818", "14", "", "", "", "30.71877", "31.56299", "Africa/Cairo"),
("361179", "Al Hawamidiyah", "", "EG", "818", "08", "", "", "", "29.9", "31.25", "Africa/Cairo"),
("361213", "Al Hamul", "", "EG", "818", "21", "", "", "", "31.31146", "31.14766", "Africa/Cairo"),
("361291", "Hurghada", "Хургада", "EG", "818", "02", "", "", "", "27.25738", "33.81291", "Africa/Cairo"),
("361320", "Al Fayyum", "Аль-Фаюм", "EG", "818", "04", "", "", "", "29.30995", "30.8418", "Africa/Cairo"),
("361329", "Al Fashn", "", "EG", "818", "18", "", "", "", "28.82431", "30.89948", "Africa/Cairo"),
("361394", "Al Bawiti", "Бавити", "EG", "818", "08", "", "", "", "28.34919", "28.86591", "Africa/Cairo"),
("361435", "Al Balyana", "", "EG", "818", "24", "", "", "", "26.23568", "32.00347", "Africa/Cairo"),
("361457", "Al Bajur", "", "EG", "818", "09", "", "", "", "30.43026", "31.03681", "Africa/Cairo"),
("361478", "Al Badari", "", "EG", "818", "17", "", "", "", "26.99257", "31.41554", "Africa/Cairo"),
("361495", "Al `Ayyat", "", "EG", "818", "08", "", "", "", "29.61972", "31.2575", "Africa/Cairo"),
("361546", "Arish", "", "EG", "818", "27", "", "", "", "31.13159", "33.79844", "Africa/Cairo"),
("361661", "Akhmim", "Ахмим", "EG", "818", "24", "", "", "", "26.56217", "31.74503", "Africa/Cairo"),
("361702", "Aja", "Айа", "EG", "818", "01", "", "", "", "30.94162", "31.29039", "Africa/Cairo"),
("361827", "Ad Dilinjat", "", "EG", "818", "03", "", "", "", "30.82791", "30.53633", "Africa/Cairo"),
("362004", "Abu Tij", "", "EG", "818", "17", "", "", "", "27.04411", "31.31897", "Africa/Cairo"),
("362277", "Abu Qurqas", "", "EG", "818", "10", "", "", "", "27.9312", "30.83841", "Africa/Cairo"),
("362485", "Abu Kabir", "", "EG", "818", "14", "", "", "", "30.72508", "31.67148", "Africa/Cairo"),
("362882", "Abu al Matamir", "", "EG", "818", "03", "", "", "", "30.91018", "30.17438", "Africa/Cairo"),
("362973", "Abnub", "", "EG", "818", "17", "", "", "", "27.2696", "31.15105", "Africa/Cairo"),
("411165", "Idfu", "", "EG", "818", "16", "", "", "", "24.98028", "32.87472", "Africa/Cairo"),
("419435", "Az Zarqa", "", "EG", "818", "20", "", "", "", "31.20864", "31.63528", "Africa/Cairo"),
("7521348", "Ain Sukhna", "Айн-Сухна", "EG", "818", "15", "", "", "", "29.60018", "32.31671", "Africa/Cairo"),
("2461874", "Smara", "Смара", "EH", "732", "CE", "", "", "", "26.73841", "-11.67194", "Africa/El_Aaiun"),
("2462881", "Laayoune / El Aaiun", "Эль-Аюн", "EH", "732", "00", "", "", "", "27.16224", "-13.20315", "Africa/El_Aaiun"),
("2463447", "Dakhla", "Дахла", "EH", "732", "CE", "", "", "", "23.68477", "-15.95798", "Africa/El_Aaiun"),
("2509305", "Zubia", "", "ES", "724", "51", "GR", "18084", "", "37.11906", "-3.584", "Europe/Madrid"),
("2509377", "Zafra", "Сафра", "ES", "724", "57", "BA", "06158", "", "38.41667", "-6.41667", "Europe/Madrid"),
("2509402", "Yecla", "Екла", "ES", "724", "31", "MU", "30043", "", "38.61365", "-1.11468", "Europe/Madrid"),
("2509463", "Villena", "Вильена", "ES", "724", "60", "A", "03140", "", "38.6373", "-0.86568", "Europe/Madrid"),
("2509491", "Villarrobledo", "Вильярробледо", "ES", "724", "54", "AB", "02081", "", "39.26992", "-2.60118", "Europe/Madrid"),
("2509509", "Vila-real", "Вила-Реал", "ES", "724", "60", "CS", "12032", "", "39.93333", "-0.1", "Europe/Madrid"),
("2509553", "Villanueva de la Serena", "Вильянуэва-де-ла-Серена", "ES", "724", "57", "BA", "06153", "", "38.97655", "-5.7974", "Europe/Madrid"),
("2509588", "Villajoyosa", "", "ES", "724", "60", "A", "03139", "", "38.50754", "-0.23346", "Europe/Madrid"),
("2509650", "Vicar", "Викар", "ES", "724", "51", "AL", "04102", "", "36.83155", "-2.64273", "Europe/Madrid"),
("2509769", "Velez-Malaga", "Велес-Малага", "ES", "724", "51", "MA", "29094", "", "36.77262", "-4.10045", "Europe/Madrid"),
("2509954", "Valencia", "Валенсия", "ES", "724", "60", "V", "46250", "", "39.46975", "-0.37739", "Europe/Madrid"),
("2509982", "Valdepenas", "Вальдепеньясе", "ES", "724", "54", "CR", "13087", "", "38.76211", "-3.38483", "Europe/Madrid"),
("2510073", "Utrera", "Утрера", "ES", "724", "51", "SE", "41095", "", "37.18516", "-5.78093", "Europe/Madrid"),
("2510112", "Ubrique", "", "ES", "724", "51", "CA", "11038", "", "36.67778", "-5.446", "Europe/Madrid"),
("2510116", "Ubeda", "Убеда", "ES", "724", "51", "J", "23092", "", "38.01328", "-3.3705", "Europe/Madrid"),
("2510224", "Totana", "Тотана", "ES", "724", "31", "MU", "30039", "", "37.7688", "-1.50229", "Europe/Madrid"),
("2510245", "Torrox", "Торрокс", "ES", "724", "51", "MA", "29091", "", "36.75793", "-3.95233", "Europe/Madrid"),
("2510253", "Torrevieja", "Торревьеха", "ES", "724", "60", "A", "03133", "", "37.97872", "-0.68222", "Europe/Madrid"),
("2510271", "Torre-Pacheco", "Торре-Пачеко", "ES", "724", "31", "MU", "30030", "", "37.74293", "-0.95396", "Europe/Madrid"),
("2510279", "Torrent", "", "ES", "724", "60", "V", "46244", "", "39.43705", "-0.46546", "Europe/Madrid"),
("2510281", "Torremolinos", "Торремолинос", "ES", "724", "51", "MA", "29901", "", "36.62035", "-4.49976", "Europe/Madrid"),
("2510392", "Tomelloso", "Томельосо", "ES", "724", "54", "CR", "13019", "", "39.15218", "-3.02431", "Europe/Madrid"),
("2510394", "Tomares", "", "ES", "724", "51", "SE", "41093", "", "37.37281", "-6.04589", "Europe/Madrid"),
("2510409", "Toledo", "Толедо", "ES", "724", "54", "TO", "45168", "", "39.8581", "-4.02263", "Europe/Madrid"),
("2510485", "Tias", "", "ES", "724", "53", "GC", "35028", "", "28.96108", "-13.64502", "Atlantic/Canary"),
("2510542", "Telde", "Тельде", "ES", "724", "53", "GC", "35026", "", "27.99242", "-15.41915", "Atlantic/Canary"),
("2510573", "Teguise", "", "ES", "724", "53", "GC", "35024", "", "29.06049", "-13.56398", "Atlantic/Canary"),
("2510599", "Tarifa", "Тарифа", "ES", "724", "51", "CA", "11035", "", "36.01393", "-5.60695", "Europe/Madrid"),
("2510693", "Talavera de la Reina", "Талавера де ла Рейна", "ES", "724", "54", "TO", "45165", "", "39.96348", "-4.83076", "Europe/Madrid"),
("2510725", "Tacoronte", "", "ES", "724", "53", "TF", "38043", "", "28.47688", "-16.41016", "Atlantic/Canary"),
("2510743", "Tavernes de la Valldigna", "", "ES", "724", "60", "V", "46238", "", "39.06667", "-0.26667", "Europe/Madrid"),
("2510764", "Sueca", "", "ES", "724", "60", "V", "46235", "", "39.2026", "-0.31114", "Europe/Madrid"),
("2510880", "Silla", "", "ES", "724", "60", "V", "46230", "", "39.36667", "-0.41667", "Europe/Madrid"),
("2510911", "Sevilla", "Севилья", "ES", "724", "51", "SE", "41091", "", "37.38283", "-5.97317", "Europe/Madrid"),
("2511032", "San Vicent del Raspeig", "", "ES", "724", "60", "A", "03014", "", "38.3964", "-0.5255", "Europe/Madrid"),
("2511050", "Santomera", "", "ES", "724", "31", "MU", "30901", "", "38.06147", "-1.04877", "Europe/Madrid"),
("2511102", "Santa Pola", "Санта-Пола", "ES", "724", "60", "A", "03121", "", "38.19165", "-0.5658", "Europe/Madrid"),
("2511150", "Santa Lucia", "", "ES", "724", "53", "GC", "35019", "", "27.91174", "-15.54071", "Atlantic/Canary"),
("2511162", "Santa Eularia des Riu", "", "ES", "724", "07", "PM", "07054", "", "38.98457", "1.53409", "Europe/Madrid"),
("2511174", "Santa Cruz de Tenerife", "Санта-Крус-де-Тенерифе", "ES", "724", "53", "TF", "38038", "", "28.46824", "-16.25462", "Atlantic/Canary"),
("2511180", "Santa Cruz de la Palma", "", "ES", "724", "53", "TF", "38037", "", "28.68351", "-17.76421", "Atlantic/Canary"),
("2511202", "Santa Brigida", "", "ES", "724", "53", "GC", "35021", "", "28.03197", "-15.50425", "Atlantic/Canary"),
("2511239", "San Roque", "", "ES", "724", "51", "CA", "11033", "", "36.21067", "-5.38415", "Europe/Madrid"),
("2511247", "San Pedro del Pinatar", "", "ES", "724", "31", "MU", "30036", "", "37.83568", "-0.79102", "Europe/Madrid"),
("2511287", "San Miguel", "", "ES", "724", "53", "TF", "38035", "", "28.09826", "-16.61708", "Atlantic/Canary"),
("2511306", "Sanlucar de Barrameda", "Санлукар-де-Баррамеда", "ES", "724", "51", "CA", "11032", "", "36.77808", "-6.3515", "Europe/Madrid"),
("2511329", "San Juan de Aznalfarache", "Сан-Хуан-де-Аснальфараче", "ES", "724", "51", "SE", "41086", "", "37.35812", "-6.03731", "Europe/Madrid"),
("2511330", "San Juan de Alicante", "", "ES", "724", "60", "A", "03014", "", "38.40148", "-0.43623", "Europe/Madrid"),
("2511352", "Sant Josep de sa Talaia", "", "ES", "724", "07", "PM", "07048", "", "38.91667", "1.28333", "Europe/Madrid"),
("2511366", "San Javier", "", "ES", "724", "31", "MU", "30035", "", "37.80626", "-0.83736", "Europe/Madrid"),
("2511371", "San Isidro", "Сан Исидро", "ES", "724", "53", "TF", "38017", "", "28.07617", "-16.558", "Atlantic/Canary"),
("2511388", "San Fernando", "Сан-Фернандо", "ES", "724", "51", "CA", "11031", "", "36.4759", "-6.19817", "Europe/Madrid"),
("2511401", "La Laguna", "Ла-Лагуна", "ES", "724", "53", "TF", "38023", "", "28.4853", "-16.32014", "Atlantic/Canary"),
("2511440", "San Bartolome", "", "ES", "724", "53", "GC", "35019", "", "27.92481", "-15.57329", "Atlantic/Canary"),
("2511447", "San Bartolome", "Сан - Бартоломе", "ES", "724", "53", "GC", "35018", "", "29.00093", "-13.613", "Atlantic/Canary"),
("2511448", "Sant Antoni de Portmany", "Сан-Антонио-Абад", "ES", "724", "07", "PM", "07046", "", "38.98068", "1.30362", "Europe/Madrid"),
("2511619", "Sagunto", "Сагунто", "ES", "724", "60", "V", "46220", "", "39.68333", "-0.26667", "Europe/Madrid"),
("2511700", "Rota", "Рота", "ES", "724", "51", "CA", "11030", "", "36.62545", "-6.3622", "Europe/Madrid"),
("2511716", "Roquetas de Mar", "Рокетас-де-Мар", "ES", "724", "51", "AL", "04079", "", "36.76419", "-2.61475", "Europe/Madrid"),
("2511730", "Ronda", "Ронда", "ES", "724", "51", "MA", "29084", "", "36.74231", "-5.16709", "Europe/Madrid"),
("2511752", "Rojales", "Рохалес", "ES", "724", "60", "A", "03113", "", "38.08799", "-0.72544", "Europe/Madrid"),
("2511852", "Rincon de la Victoria", "Ринкон-де-ла-Виктория", "ES", "724", "51", "MA", "29082", "", "36.71715", "-4.27583", "Europe/Madrid"),
("2511880", "Ribarroja", "", "ES", "724", "60", "V", "46111", "", "39.55", "-0.56667", "Europe/Madrid"),
("2511930", "Requena", "Рекена", "ES", "724", "60", "V", "46213", "", "39.48834", "-1.10044", "Europe/Madrid"),
("2511994", "Realejo Alto", "", "ES", "724", "53", "TF", "38026", "", "28.37645", "-16.58575", "Atlantic/Canary"),
("2512127", "Pucol", "", "ES", "724", "60", "V", "46205", "", "39.61667", "-0.3", "Europe/Madrid"),
("2512169", "Puerto Real", "Пуэрто-Реаль", "ES", "724", "51", "CA", "11028", "", "36.52819", "-6.19011", "Europe/Madrid"),
("2512177", "Puertollano", "Пуэртольяно", "ES", "724", "54", "CR", "13071", "", "38.68712", "-4.10734", "Europe/Madrid"),
("2512186", "Puerto del Rosario", "Пуэрто-дель-Росарио", "ES", "724", "53", "GC", "35017", "", "28.50038", "-13.86272", "Atlantic/Canary"),
("2512196", "Puerto de la Cruz", "Пуэрто-де-ла-Крус", "ES", "724", "53", "TF", "38028", "", "28.41397", "-16.54867", "Atlantic/Canary"),
("2512232", "Puente-Genil", "", "ES", "724", "51", "CO", "14056", "", "37.38943", "-4.76686", "Europe/Madrid"),
("2512251", "La Pobla de Vallbona", "", "ES", "724", "60", "V", "46202", "", "39.6", "-0.55", "Europe/Madrid"),
("2512282", "Priego de Cordoba", "Прьего-де-Кордоба", "ES", "724", "51", "CO", "14055", "", "37.43807", "-4.19523", "Europe/Madrid"),
("2512340", "Pozoblanco", "", "ES", "724", "51", "CO", "14054", "", "38.37906", "-4.84827", "Europe/Madrid"),
("2512432", "Pollenca", "", "ES", "724", "07", "PM", "07042", "", "39.87678", "3.01626", "Europe/Madrid"),
("2512581", "Pilar de la Horadada", "Пилар-де-ла-Орадада", "ES", "724", "60", "A", "03902", "", "37.86591", "-0.79256", "Europe/Madrid"),
("2512620", "Picassent", "", "ES", "724", "60", "V", "46194", "", "39.36667", "-0.45", "Europe/Madrid"),
("2512862", "Paterna", "Патерна", "ES", "724", "60", "V", "46190", "", "39.5", "-0.43333", "Europe/Madrid"),
("2512989", "Palma", "Пальма", "ES", "724", "07", "PM", "07040", "", "39.56939", "2.65024", "Europe/Madrid"),
("2512990", "Palma del Rio", "Пальма-дель-Рио", "ES", "724", "51", "CO", "14036", "", "37.70024", "-5.28121", "Europe/Madrid"),
("2513026", "Pajara", "", "ES", "724", "53", "GC", "35015", "", "28.35039", "-14.1076", "Atlantic/Canary"),
("2513029", "Paiporta", "Пайпорта", "ES", "724", "60", "V", "46186", "", "39.43333", "-0.41667", "Europe/Madrid"),
("2513052", "Osuna", "Осуна", "ES", "724", "51", "SE", "41068", "", "37.23765", "-5.10746", "Europe/Madrid"),
("2513076", "Orihuela", "Ориуэла", "ES", "724", "60", "A", "03099", "", "38.08483", "-0.94401", "Europe/Madrid"),
("2513106", "Ontinyent", "Онтеньенте", "ES", "724", "60", "V", "46184", "", "38.81667", "-0.61667", "Europe/Madrid"),
("2513115", "Onda", "Онда", "ES", "724", "60", "CS", "12084", "", "39.96667", "-0.25", "Europe/Madrid"),
("2513145", "Oliva", "Олива", "ES", "724", "60", "V", "46181", "", "38.91971", "-0.11935", "Europe/Madrid"),
("2513195", "Novelda", "Новельда", "ES", "724", "60", "A", "03093", "", "38.38479", "-0.76773", "Europe/Madrid"),
("2513222", "Nijar", "Нихар", "ES", "724", "51", "AL", "04066", "", "36.96655", "-2.20595", "Europe/Madrid"),
("2513240", "Nerja", "", "ES", "724", "51", "MA", "29075", "", "36.75278", "-3.8744", "Europe/Madrid"),
("2513324", "Navalmoral de la Mata", "Навальмораль-де-ла-Мата", "ES", "724", "57", "CC", "10131", "", "39.89158", "-5.54064", "Europe/Madrid"),
("2513416", "Murcia", "Мурсия", "ES", "724", "31", "MU", "30030", "", "37.98704", "-1.13004", "Europe/Madrid"),
("2513436", "Mula", "", "ES", "724", "31", "MU", "30029", "", "38.04094", "-1.49014", "Europe/Madrid"),
("2513465", "Muchamiel", "", "ES", "724", "60", "A", "03014", "", "38.4158", "-0.44529", "Europe/Madrid"),
("2513477", "Motril", "Мотриль", "ES", "724", "51", "GR", "18140", "", "36.75066", "-3.5179", "Europe/Madrid"),
("2513509", "Moron de la Frontera", "Морон-де-ла-Фронтера", "ES", "724", "51", "SE", "41065", "", "37.12084", "-5.45403", "Europe/Madrid"),
("2513601", "Montilla", "Монтилья", "ES", "724", "51", "CO", "14042", "", "37.58627", "-4.63805", "Europe/Madrid"),
("2513604", "Montijo", "", "ES", "724", "57", "BA", "06088", "", "38.90839", "-6.61785", "Europe/Madrid"),
("2513703", "Moncada", "Монкада", "ES", "724", "60", "V", "46171", "", "39.54555", "-0.39551", "Europe/Madrid"),
("2513759", "Molina de Segura", "Молина-де-Сегура", "ES", "724", "31", "MU", "30027", "", "38.05456", "-1.20763", "Europe/Madrid"),
("2513791", "Moguer", "Могер", "ES", "724", "51", "H", "21050", "", "37.27559", "-6.83851", "Europe/Madrid"),
("2513798", "Mogan", "", "ES", "724", "53", "GC", "35012", "", "27.88385", "-15.72538", "Atlantic/Canary"),
("2513811", "Mislata", "Мислата", "ES", "724", "60", "V", "46169", "", "39.47523", "-0.41825", "Europe/Madrid"),
("2513882", "Mijas", "Михас", "ES", "724", "51", "MA", "29070", "", "36.59575", "-4.63728", "Europe/Madrid"),
("2513917", "Merida", "Мерида", "ES", "724", "57", "BA", "06083", "", "38.91611", "-6.34366", "Europe/Madrid"),
("2513947", "Melilla", "Мелилья", "ES", "724", "ML", "ME", "52001", "", "35.29369", "-2.93833", "Africa/Ceuta"),
("2513983", "Mazarron", "Масаррон", "ES", "724", "31", "MU", "30026", "", "37.5992", "-1.31493", "Europe/Madrid"),
("2514042", "Maspalomas", "Маспаломас", "ES", "724", "53", "GC", "35019", "", "27.76056", "-15.58602", "Atlantic/Canary"),
("2514066", "Massamagrell", "", "ES", "724", "60", "V", "46164", "", "39.56667", "-0.33333", "Europe/Madrid"),
("2514073", "Martos", "Мартос", "ES", "724", "51", "J", "23060", "", "37.72107", "-3.97264", "Europe/Madrid"),
("2514097", "Marratxi", "Маррачи", "ES", "724", "07", "PM", "07036", "", "39.64208", "2.75388", "Europe/Madrid"),
("2514158", "Marchena", "", "ES", "724", "51", "SE", "41060", "", "37.329", "-5.41682", "Europe/Madrid"),
("2514169", "Marbella", "Марбелья", "ES", "724", "51", "MA", "29069", "", "36.51543", "-4.88583", "Europe/Madrid"),
("2514176", "Maracena", "", "ES", "724", "51", "GR", "18127", "", "37.20764", "-3.63493", "Europe/Madrid"),
("2514190", "Manzanares", "", "ES", "724", "54", "CR", "13053", "", "38.99915", "-3.36991", "Europe/Madrid"),
("2514197", "Manises", "Манисес", "ES", "724", "60", "V", "46159", "", "39.49139", "-0.46349", "Europe/Madrid"),
("2514216", "Manacor", "Манакор", "ES", "724", "07", "PM", "07033", "", "39.56964", "3.20955", "Europe/Madrid"),
("2514256", "Malaga", "Малага", "ES", "724", "51", "MA", "29067", "", "36.72016", "-4.42034", "Europe/Madrid"),
("2514287", "Mairena del Aljarafe", "Майрена-дель-Альхарафе", "ES", "724", "51", "SE", "41059", "", "37.34461", "-6.06391", "Europe/Madrid"),
("2514288", "Mairena del Alcor", "", "ES", "724", "51", "SE", "41058", "", "37.37301", "-5.74952", "Europe/Madrid"),
("2514301", "Mao", "Мао", "ES", "724", "07", "PM", "07032", "", "39.88853", "4.26583", "Europe/Madrid"),
("2514392", "Lucena", "", "ES", "724", "51", "CO", "14038", "", "37.40881", "-4.48522", "Europe/Madrid"),
("2514553", "Los Palacios y Villafranca", "", "ES", "724", "51", "SE", "41069", "", "37.16181", "-5.92433", "Europe/Madrid"),
("2514651", "Los Llanos de Aridane", "Лос-Льянос-де-Аридане", "ES", "724", "53", "TF", "38024", "", "28.65851", "-17.91821", "Atlantic/Canary"),
("2514824", "Los Barrios", "Лос-Барриос", "ES", "724", "51", "CA", "11035", "", "36.18482", "-5.49213", "Europe/Madrid"),
("2514868", "Los Alcazares", "", "ES", "724", "31", "MU", "30902", "", "37.74425", "-0.85041", "Europe/Madrid"),
("2514891", "Lorca", "Лорка", "ES", "724", "31", "MU", "30024", "", "37.67119", "-1.7017", "Europe/Madrid"),
("2514893", "Lora del Rio", "Лора-дель-Рио", "ES", "724", "51", "SE", "41055", "", "37.65896", "-5.52751", "Europe/Madrid"),
("2514946", "Loja", "Лоха", "ES", "724", "51", "GR", "18122", "", "37.16887", "-4.15129", "Europe/Madrid"),
("2514984", "Llucmajor", "", "ES", "724", "07", "PM", "07031", "", "39.49093", "2.89108", "Europe/Madrid"),
("2515036", "Lliria", "", "ES", "724", "60", "V", "46148", "", "39.63333", "-0.6", "Europe/Madrid"),
("2515045", "Linares", "Линарес", "ES", "724", "51", "J", "23055", "", "38.09519", "-3.63602", "Europe/Madrid"),
("2515072", "Lepe", "Лепе", "ES", "724", "51", "H", "21044", "", "37.25482", "-7.20433", "Europe/Madrid"),
("2515096", "Lebrija", "Лебриха", "ES", "724", "51", "SE", "41053", "", "36.92077", "-6.07529", "Europe/Madrid"),
("2515151", "La Union", "", "ES", "724", "31", "MU", "30041", "", "37.61915", "-0.87799", "Europe/Madrid"),
("2515219", "Las Torres de Cotillas", "", "ES", "724", "31", "MU", "30038", "", "38.02822", "-1.24188", "Europe/Madrid"),
("2515270", "Las Palmas de Gran Canaria", "Лас-Пальмас-де-Гран-Канария", "ES", "724", "53", "GC", "35016", "", "28.09973", "-15.41343", "Atlantic/Canary"),
("2515284", "La Solana", "", "ES", "724", "54", "CR", "13079", "", "38.94422", "-3.2381", "Europe/Madrid"),
("2515493", "Las Cabezas de San Juan", "", "ES", "724", "51", "SE", "41020", "", "36.9838", "-5.93933", "Europe/Madrid"),
("2515555", "La Roda", "Ла-Рода", "ES", "724", "54", "AB", "02069", "", "39.21667", "-2.15", "Europe/Madrid"),
("2515562", "La Rinconada", "Ла-Ринконада", "ES", "724", "51", "SE", "41081", "", "37.48613", "-5.98091", "Europe/Madrid"),
("2515692", "La Orotava", "Ла-Оротава", "ES", "724", "53", "TF", "38026", "", "28.39076", "-16.52309", "Atlantic/Canary"),
("2515698", "La Oliva", "", "ES", "724", "53", "GC", "35014", "", "28.61052", "-13.92912", "Atlantic/Canary"),
("2515701", "la Nucia", "Ла-Нусиа", "ES", "724", "60", "A", "03094", "", "38.61372", "-0.1269", "Europe/Madrid"),
("2515812", "La Linea de la Concepcion", "Ла-Линеа-де-ла-Консепсьон", "ES", "724", "51", "CA", "11022", "", "36.16809", "-5.34777", "Europe/Madrid"),
("2516004", "L'Eliana", "", "ES", "724", "60", "V", "46116", "", "39.56667", "-0.53333", "Europe/Madrid"),
("2516088", "La Carolina", "", "ES", "724", "51", "J", "23021", "", "38.27559", "-3.61534", "Europe/Madrid"),
("2516255", "Jumilla", "Хумилье", "ES", "724", "31", "MU", "30022", "", "38.47917", "-1.325", "Europe/Madrid"),
("2516326", "Jerez de la Frontera", "Херес-де-ла-Фронтера", "ES", "724", "51", "CA", "11020", "", "36.68645", "-6.13606", "Europe/Madrid"),
("2516336", "Javea", "", "ES", "724", "60", "A", "03063", "", "38.78333", "0.16667", "Europe/Madrid"),
("2516345", "Xativa", "Хатива", "ES", "724", "60", "V", "46145", "", "38.98333", "-0.51667", "Europe/Madrid"),
("2516395", "Jaen", "Хаэн", "ES", "724", "51", "J", "23050", "", "37.76922", "-3.79028", "Europe/Madrid"),
("2516431", "Isla Cristina", "Исла-Кристина", "ES", "724", "51", "H", "21042", "", "37.2", "-7.31667", "Europe/Madrid"),
("2516443", "Ingenio", "", "ES", "724", "53", "GC", "35011", "", "27.92086", "-15.4406", "Atlantic/Canary"),
("2516452", "Inca", "Инка", "ES", "724", "07", "PM", "07027", "", "39.7211", "2.91093", "Europe/Madrid"),
("2516474", "Icod de los Vinos", "", "ES", "724", "53", "TF", "38022", "", "28.37241", "-16.71188", "Atlantic/Canary"),
("2516479", "Ibiza", "Ибица", "ES", "724", "07", "PM", "07026", "", "38.90883", "1.43296", "Europe/Madrid"),
("2516480", "Ibi", "Иби", "ES", "724", "60", "A", "03079", "", "38.62533", "-0.57225", "Europe/Madrid"),
("2516542", "Huercal-Overa", "Уэркаль-Овера", "ES", "724", "51", "AL", "04053", "", "37.38897", "-1.94536", "Europe/Madrid"),
("2516548", "Huelva", "Уэльва", "ES", "724", "51", "H", "21041", "", "37.26638", "-6.94004", "Europe/Madrid"),
("2516797", "Hellin", "Эльине", "ES", "724", "54", "AB", "02037", "", "38.5106", "-1.70096", "Europe/Madrid"),
("2516852", "Guimar", "", "ES", "724", "53", "TF", "38020", "", "28.3039", "-16.43254", "Atlantic/Canary"),
("2516860", "Guia de Isora", "Гиа-де-Исора", "ES", "724", "53", "TF", "38019", "", "28.21154", "-16.77947", "Atlantic/Canary"),
("2516902", "Guardamar del Segura", "", "ES", "724", "60", "A", "03076", "", "38.09031", "-0.65556", "Europe/Madrid"),
("2516925", "Guadix", "Гвадикс", "ES", "724", "51", "GR", "18089", "", "37.29932", "-3.13922", "Europe/Madrid"),
("2517111", "Granadilla de Abona", "Гранадилья-де-Абона", "ES", "724", "53", "TF", "38017", "", "28.11882", "-16.57599", "Atlantic/Canary"),
("2517117", "Granada", "Гранада", "ES", "724", "51", "GR", "18087", "", "37.18817", "-3.60667", "Europe/Madrid"),
("2517367", "Gandia", "Гандия", "ES", "724", "60", "V", "46131", "", "38.96667", "-0.18333", "Europe/Madrid"),
("2517436", "Galdar", "Гальдар", "ES", "724", "53", "GC", "35009", "", "28.14701", "-15.6502", "Atlantic/Canary"),
("2517595", "Fuengirola", "Фуэнхирола", "ES", "724", "51", "MA", "29054", "", "36.53998", "-4.62473", "Europe/Madrid"),
("2517750", "Felanitx", "", "ES", "724", "07", "PM", "07022", "", "39.4696", "3.14831", "Europe/Madrid"),
("2517816", "Estepona", "Эстепона", "ES", "724", "51", "MA", "29051", "", "36.42764", "-5.14589", "Europe/Madrid"),
("2518040", "El Viso del Alcor", "", "ES", "724", "51", "SE", "41102", "", "37.39106", "-5.71993", "Europe/Madrid"),
("2518207", "El Puerto de Santa Maria", "Эль-Пуэрто-де-Санта-Мария", "ES", "724", "51", "CA", "11027", "", "36.59389", "-6.23298", "Europe/Madrid"),
("2518494", "El Ejido", "Эль-Эхидо", "ES", "724", "51", "AL", "04013", "", "36.77629", "-2.81456", "Europe/Madrid"),
("2518505", "Elda", "Эльда", "ES", "724", "60", "A", "03066", "", "38.47783", "-0.79157", "Europe/Madrid"),
("2518559", "Elche", "Эльч", "ES", "724", "60", "A", "03065", "", "38.26218", "-0.70107", "Europe/Madrid"),
("2518729", "El Arahal", "", "ES", "724", "51", "SE", "41011", "", "37.26273", "-5.5453", "Europe/Madrid"),
("2518770", "Ecija", "Эсиха", "ES", "724", "51", "SE", "41039", "", "37.5422", "-5.0826", "Europe/Madrid"),
("2518794", "Dos Hermanas", "", "ES", "724", "51", "SE", "41038", "", "37.28287", "-5.92088", "Europe/Madrid"),
("2518820", "Don Benito", "Дон-Бенито", "ES", "724", "57", "BA", "06044", "", "38.95627", "-5.86162", "Europe/Madrid"),
("2518878", "Denia", "Дения", "ES", "724", "60", "A", "03063", "", "38.84078", "0.10574", "Europe/Madrid"),
("2518924", "Daimiel", "Даймьель", "ES", "724", "54", "CR", "13039", "", "39.07004", "-3.61498", "Europe/Madrid"),
("2518949", "Cullera", "Кульера", "ES", "724", "60", "V", "46105", "", "39.16667", "-0.25", "Europe/Madrid"),
("2519068", "Quart de Poblet", "Куарт-де-Поблет", "ES", "724", "60", "V", "46102", "", "39.48139", "-0.43937", "Europe/Madrid"),
("2519110", "Crevillente", "Кревильенте", "ES", "724", "60", "A", "03059", "", "38.24994", "-0.80975", "Europe/Madrid"),
("2519233", "Coria del Rio", "Кориа-дель-Рио", "ES", "724", "51", "SE", "41034", "", "37.28766", "-6.0541", "Europe/Madrid"),
("2519240", "Cordoba", "Кордова", "ES", "724", "51", "CO", "14021", "", "37.89155", "-4.77275", "Europe/Madrid"),
("2519289", "Conil de la Frontera", "", "ES", "724", "51", "CA", "11014", "", "36.27719", "-6.0885", "Europe/Madrid"),
("2519367", "Coin", "", "ES", "724", "51", "MA", "29042", "", "36.65947", "-4.75639", "Europe/Madrid"),
("2519402", "Ciudad Real", "Сьюдад-Реаль", "ES", "724", "54", "CR", "13034", "", "38.98626", "-3.92907", "Europe/Madrid"),
("2519425", "Cieza", "Сьеса", "ES", "724", "31", "MU", "30019", "", "38.23998", "-1.41987", "Europe/Madrid"),
("2519466", "Xirivella", "Чиривелья", "ES", "724", "60", "V", "46110", "", "39.46588", "-0.42589", "Europe/Madrid"),
("2519477", "Chipiona", "Чипиона", "ES", "724", "51", "CA", "11016", "", "36.73663", "-6.43703", "Europe/Madrid"),
("2519513", "Chiclana de la Frontera", "Чиклана-де-ла-Фронтера", "ES", "724", "51", "CA", "11015", "", "36.41915", "-6.14941", "Europe/Madrid"),
("2519651", "Cehegin", "", "ES", "724", "31", "MU", "30028", "", "38.09242", "-1.7985", "Europe/Madrid"),
("2519690", "Catarroja", "Катаррох", "ES", "724", "60", "V", "46094", "", "39.4", "-0.4", "Europe/Madrid"),
("2519738", "Castilleja de la Cuesta", "", "ES", "724", "51", "SE", "41029", "", "37.38594", "-6.05258", "Europe/Madrid"),
("2519752", "Castello de la Plana", "Кастельон-де-ла-Плана", "ES", "724", "60", "CS", "12040", "", "39.98333", "-0.03333", "Europe/Madrid"),
("2520052", "Cartaya", "", "ES", "724", "51", "H", "21021", "", "37.28114", "-7.15071", "Europe/Madrid"),
("2520055", "Cartama", "Картама", "ES", "724", "51", "MA", "29038", "", "36.71068", "-4.63297", "Europe/Madrid"),
("2520058", "Cartagena", "Картахена", "ES", "724", "31", "MU", "30016", "", "37.60512", "-0.98623", "Europe/Madrid"),
("2520118", "Carmona", "Кармона", "ES", "724", "51", "SE", "41024", "", "37.47125", "-5.64608", "Europe/Madrid"),
("2520121", "Carlet", "", "ES", "724", "60", "V", "46085", "", "39.23333", "-0.51667", "Europe/Madrid"),
("2520150", "Carcaixent", "Каркахенте", "ES", "724", "60", "V", "46083", "", "39.13333", "-0.45", "Europe/Madrid"),
("2520171", "Caravaca", "", "ES", "724", "31", "MU", "30028", "", "38.10558", "-1.86342", "Europe/Madrid"),
("2520283", "Candelaria", "Канделарии", "ES", "724", "53", "TF", "38011", "", "28.3548", "-16.37268", "Atlantic/Canary"),
("2520413", "Campo de Criptana", "", "ES", "724", "54", "CR", "13028", "", "39.40463", "-3.12492", "Europe/Madrid"),
("2520425", "Campina", "", "ES", "724", "51", "J", "23097", "", "38.21896", "-2.9807", "Europe/Madrid"),
("2520447", "el Campello", "", "ES", "724", "60", "A", "03050", "", "38.42885", "-0.39774", "Europe/Madrid"),
("2520477", "Camas", "Камас", "ES", "724", "51", "SE", "41021", "", "37.40202", "-6.03314", "Europe/Madrid"),
("2520493", "Calvia", "Кальвиа", "ES", "724", "07", "PM", "07011", "", "39.5657", "2.50621", "Europe/Madrid"),
("2520496", "Calp", "Кальп", "ES", "724", "60", "A", "03047", "", "38.6447", "0.0445", "Europe/Madrid"),
("2520502", "Callosa de Segura", "Кальоса-де-Сегура", "ES", "724", "60", "A", "03049", "", "38.12497", "-0.87822", "Europe/Madrid"),
("2520600", "Cadiz", "Кадис", "ES", "724", "51", "CA", "11012", "", "36.52978", "-6.29465", "Europe/Madrid"),
("2520611", "Caceres", "Касерес", "ES", "724", "57", "CC", "10037", "", "39.47649", "-6.37224", "Europe/Madrid"),
("2520645", "Cabra", "Кабра", "ES", "724", "51", "CO", "14013", "", "37.47249", "-4.44206", "Europe/Madrid"),
("2520709", "Burriana", "Бурриана", "ES", "724", "60", "CS", "12032", "", "39.88901", "-0.08499", "Europe/Madrid"),
("2520712", "Burjassot", "Бурхасот", "ES", "724", "60", "V", "46078", "", "39.51667", "-0.41667", "Europe/Madrid"),
("2520833", "Bormujos", "", "ES", "724", "51", "SE", "41017", "", "37.37358", "-6.07232", "Europe/Madrid"),
("2520968", "Betera", "", "ES", "724", "60", "V", "46070", "", "39.58333", "-0.45", "Europe/Madrid"),
("2521016", "Berja", "Берха", "ES", "724", "51", "AL", "04029", "", "36.84693", "-2.94966", "Europe/Madrid"),
("2521088", "Benidorm", "Бенидорм", "ES", "724", "60", "A", "03031", "", "38.53816", "-0.13098", "Europe/Madrid"),
("2521105", "Benetusser", "", "ES", "724", "60", "V", "46054", "", "39.41667", "-0.4", "Europe/Madrid"),
("2521139", "Benalmadena", "Бенальмадена", "ES", "724", "51", "MA", "29025", "", "36.59548", "-4.56937", "Europe/Madrid"),
("2521215", "Baza", "База", "ES", "724", "51", "GR", "18023", "", "37.49073", "-2.77259", "Europe/Madrid"),
("2521335", "Barbate de Franco", "", "ES", "724", "51", "CA", "11007", "", "36.19237", "-5.92186", "Europe/Madrid"),
("2521410", "Bailen", "Байлен", "ES", "724", "51", "J", "23010", "", "38.09639", "-3.77786", "Europe/Madrid"),
("2521413", "Baeza", "", "ES", "724", "51", "J", "23009", "", "37.99384", "-3.47103", "Europe/Madrid"),
("2521415", "Baena", "Баэна", "ES", "724", "51", "CO", "14007", "", "37.6167", "-4.32245", "Europe/Madrid"),
("2521420", "Badajoz", "Бадахос", "ES", "724", "57", "BA", "06015", "", "38.87789", "-6.97061", "Europe/Madrid"),
("2521456", "Ayamonte", "Айямонте", "ES", "724", "51", "H", "21010", "", "37.20994", "-7.40266", "Europe/Madrid"),
("2521485", "Atarfe", "", "ES", "724", "51", "GR", "18022", "", "37.22479", "-3.68686", "Europe/Madrid"),
("2521510", "Aspe", "Аспе", "ES", "724", "60", "A", "03019", "", "38.34511", "-0.76722", "Europe/Madrid"),
("2521519", "Arucas", "Арукас", "ES", "724", "53", "GC", "35006", "", "28.11983", "-15.52325", "Atlantic/Canary"),
("2521570", "Arrecife", "Аресифе", "ES", "724", "53", "GC", "35004", "", "28.96302", "-13.54769", "Atlantic/Canary"),
("2521582", "Arona", "Арон", "ES", "724", "53", "TF", "38006", "", "28.09962", "-16.68102", "Atlantic/Canary"),
("2521590", "Armilla", "", "ES", "724", "51", "GR", "18021", "", "37.14102", "-3.61854", "Europe/Madrid"),
("2521665", "Arcos de la Frontera", "Аркос-де-ла-Фронтера", "ES", "724", "51", "CA", "11006", "", "36.75075", "-5.81056", "Europe/Madrid"),
("2521676", "Archena", "", "ES", "724", "31", "MU", "30009", "", "38.11631", "-1.30043", "Europe/Madrid"),
("2521710", "Antequera", "Антекера", "ES", "724", "51", "MA", "29015", "", "37.01938", "-4.56123", "Europe/Madrid"),
("2521738", "Andujar", "Андухар", "ES", "724", "51", "J", "23005", "", "38.03922", "-4.05078", "Europe/Madrid"),
("2521804", "Altea", "", "ES", "724", "60", "A", "03018", "", "38.59885", "-0.05139", "Europe/Madrid"),
("2521847", "Almunecar", "Альмуньекар", "ES", "724", "51", "GR", "18017", "", "36.73393", "-3.69072", "Europe/Madrid"),
("2521855", "Almoradi", "Альморади", "ES", "724", "60", "A", "03099", "", "38.10879", "-0.79197", "Europe/Madrid"),
("2521857", "Almonte", "", "ES", "724", "51", "H", "21005", "", "37.2647", "-6.51667", "Europe/Madrid"),
("2521886", "Almeria", "Альмерия", "ES", "724", "51", "AL", "04013", "", "36.83814", "-2.45974", "Europe/Madrid"),
("2521893", "Almendralejo", "Альмендралехо", "ES", "724", "57", "BA", "06011", "", "38.68316", "-6.40747", "Europe/Madrid"),
("2521909", "Almassora", "", "ES", "724", "60", "CS", "12040", "", "39.95", "-0.05", "Europe/Madrid"),
("2521923", "Almansa", "Альманса", "ES", "724", "54", "AB", "02009", "", "38.86917", "-1.09713", "Europe/Madrid"),
("2521964", "Aljaraque", "", "ES", "724", "51", "H", "21002", "", "37.2699", "-7.02312", "Europe/Madrid"),
("2521978", "Alicante", "Аликанте", "ES", "724", "60", "A", "03014", "", "38.34517", "-0.48149", "Europe/Madrid"),
("2521985", "Alhaurin el Grande", "Алаурин-эль-Гранде", "ES", "724", "51", "MA", "29008", "", "36.643", "-4.68728", "Europe/Madrid"),
("2521986", "Alhaurin de la Torre", "", "ES", "724", "51", "MA", "29007", "", "36.66401", "-4.56139", "Europe/Madrid"),
("2521992", "Alhama de Murcia", "Альхама-де-Мурсия", "ES", "724", "31", "MU", "30008", "", "37.85103", "-1.42507", "Europe/Madrid"),
("2522012", "Algemesi", "Альхемеси", "ES", "724", "60", "V", "46029", "", "39.18333", "-0.43333", "Europe/Madrid"),
("2522013", "Algeciras", "Альхесирас", "ES", "724", "51", "CA", "11004", "", "36.13326", "-5.45051", "Europe/Madrid"),
("2522057", "Alfafar", "Альфафар", "ES", "724", "60", "V", "46022", "", "39.41667", "-0.38333", "Europe/Madrid"),
("2522077", "Aldaia", "Альдайя", "ES", "724", "60", "V", "46021", "", "39.46569", "-0.46005", "Europe/Madrid"),
("2522091", "Alcudia", "", "ES", "724", "07", "PM", "07003", "", "39.85316", "3.12138", "Europe/Madrid"),
("2522098", "Alcoy", "Алька", "ES", "724", "60", "A", "03009", "", "38.70545", "-0.47432", "Europe/Madrid"),
("2522129", "Alzira", "Альсира", "ES", "724", "60", "V", "46017", "", "39.15", "-0.43333", "Europe/Madrid"),
("2522131", "Alcazar de San Juan", "Алькасар-де-Сан-Хуан", "ES", "724", "54", "CR", "13005", "", "39.39011", "-3.20827", "Europe/Madrid"),
("2522152", "Alcantarilla", "Алькантарилья", "ES", "724", "31", "MU", "30005", "", "37.96939", "-1.21714", "Europe/Madrid"),
("2522160", "Alcala la Real", "Алькала-ла-Реаль", "ES", "724", "51", "J", "23002", "", "37.4614", "-3.92301", "Europe/Madrid"),
("2522165", "Alcala de Guadaira", "Алькала-де-Гвадаира", "ES", "724", "51", "SE", "41004", "", "37.33791", "-5.83951", "Europe/Madrid"),
("2522203", "Alboraya", "Альборайя", "ES", "724", "60", "V", "46013", "", "39.5", "-0.35", "Europe/Madrid"),
("2522208", "Albolote", "", "ES", "724", "51", "GR", "18003", "", "37.23088", "-3.6551", "Europe/Madrid"),
("2522250", "Albal", "", "ES", "724", "60", "V", "46007", "", "39.4", "-0.41667", "Europe/Madrid"),
("2522258", "Albacete", "Альбасете", "ES", "724", "54", "AB", "02003", "", "38.99424", "-1.85643", "Europe/Madrid"),
("2522297", "Alaquas", "Алакуас", "ES", "724", "60", "V", "46005", "", "39.45568", "-0.461", "Europe/Madrid"),
("2522325", "Aguimes", "Агуимес", "ES", "724", "53", "GC", "35002", "", "27.90539", "-15.44609", "Atlantic/Canary"),
("2522333", "Aguilas", "Агилас", "ES", "724", "31", "MU", "30003", "", "37.4063", "-1.58289", "Europe/Madrid"),
("2522430", "Adra", "Адра", "ES", "724", "51", "AL", "04003", "", "36.74961", "-3.02055", "Europe/Madrid"),
("2522437", "Adeje", "Адехе", "ES", "724", "53", "TF", "38001", "", "28.12271", "-16.726", "Atlantic/Canary"),
("2567529", "Groa de Murviedro", "", "ES", "724", "60", "V", "46220", "", "39.64167", "-0.23889", "Europe/Madrid"),
("3104316", "Zarautz", "", "ES", "724", "59", "SS", "20079", "", "43.28444", "-2.16992", "Europe/Madrid"),
("3104324", "Zaragoza", "Сарагоса", "ES", "724", "52", "Z", "50297", "", "41.65606", "-0.87734", "Europe/Madrid"),
("3104342", "Zamora", "Самора", "ES", "724", "55", "ZA", "49275", "", "41.50633", "-5.74456", "Europe/Madrid"),
("3104475", "Viveiro", "", "ES", "724", "58", "LU", "27066", "", "43.66228", "-7.59344", "Europe/Madrid"),
("3104499", "Gasteiz / Vitoria", "", "ES", "724", "59", "VI", "01059", "", "42.84998", "-2.67268", "Europe/Madrid"),
("3104584", "Vinaros", "Винаросе", "ES", "724", "60", "CS", "12138", "", "40.47033", "0.47559", "Europe/Madrid"),
("3104703", "Villaviciosa de Odon", "Вильявисиоса-де-Одон", "ES", "724", "29", "M", "28181", "", "40.35692", "-3.90011", "Europe/Madrid"),
("3104748", "Villaverde", "", "ES", "724", "29", "M", "28079", "", "40.35", "-3.7", "Europe/Madrid"),
("3105148", "Villaquilambre", "Вильякиламбре", "ES", "724", "55", "LE", "24222", "", "42.64685", "-5.55835", "Europe/Madrid"),
("3105184", "Vilanova i la Geltru", "", "ES", "724", "56", "B", "08307", "", "41.22392", "1.72511", "Europe/Madrid"),
("3105214", "Villanueva del Pardillo", "", "ES", "724", "29", "M", "28177", "", "40.48333", "-3.96667", "Europe/Madrid"),
("3105247", "Villanueva de la Canada", "", "ES", "724", "29", "M", "28176", "", "40.4469", "-4.00428", "Europe/Madrid"),
("3105522", "Vilalba", "", "ES", "724", "58", "LU", "27065", "", "43.3", "-7.68333", "Europe/Madrid"),
("3105575", "Vilagarcia de Arousa", "", "ES", "724", "58", "PO", "36060", "", "42.59631", "-8.76426", "Europe/Madrid"),
("3105600", "Vilafranca del Penedes", "Вильяфранка-дель-Пенедес", "ES", "724", "56", "B", "08305", "", "41.35", "1.7", "Europe/Madrid"),
("3105803", "Vila-seca", "", "ES", "724", "56", "T", "43123", "", "41.11667", "1.15", "Europe/Madrid"),
("3105805", "Vilaseca", "Вила-сека", "ES", "724", "56", "B", "08150", "", "42.06174", "2.25528", "Europe/Madrid"),
("3105935", "Viladecans", "Виладеканс", "ES", "724", "56", "B", "08089", "", "41.31405", "2.01427", "Europe/Madrid"),
("3105976", "Vigo", "Виго", "ES", "724", "58", "PO", "36057", "", "42.23282", "-8.72264", "Europe/Madrid"),
("3106050", "Vic", "", "ES", "724", "56", "B", "08298", "", "41.93012", "2.25486", "Europe/Madrid"),
("3106054", "Vicalvaro", "", "ES", "724", "29", "M", "28079", "", "40.4", "-3.6", "Europe/Madrid"),
("3106180", "El Vendrell", "Вендрель", "ES", "724", "56", "T", "43163", "", "41.21667", "1.53333", "Europe/Madrid"),
("3106492", "Valls", "Вальс", "ES", "724", "56", "T", "43161", "", "41.28612", "1.24993", "Europe/Madrid"),
("3106672", "Valladolid", "Вальядолид", "ES", "724", "55", "VA", "47186", "", "41.65518", "-4.72372", "Europe/Madrid"),
("3106868", "Valdemoro", "Вальдеморо", "ES", "724", "29", "M", "28161", "", "40.19081", "-3.67887", "Europe/Madrid"),
("3107112", "Vaciamadrid", "Васиамадрид", "ES", "724", "29", "M", "28123", "", "40.32605", "-3.51088", "Europe/Madrid"),
("3107139", "Utebo", "", "ES", "724", "52", "Z", "50272", "", "41.71394", "-0.99487", "Europe/Madrid"),
("3107364", "Tui", "", "ES", "724", "58", "PO", "36055", "", "42.04713", "-8.64435", "Europe/Madrid"),
("3107418", "Tudela", "Тудела", "ES", "724", "32", "NA", "31232", "", "42.06166", "-1.60452", "Europe/Madrid"),
("3107677", "Tortosa", "Тортоса", "ES", "724", "56", "T", "43155", "", "40.81249", "0.5216", "Europe/Madrid"),
("3107765", "Torrelodones", "", "ES", "724", "29", "M", "28152", "", "40.57654", "-3.92658", "Europe/Madrid"),
("3107775", "Torrelavega", "Торрелавега", "ES", "724", "39", "S", "39087", "", "43.34944", "-4.04785", "Europe/Madrid"),
("3107784", "Torrejon de Ardoz", "Торрехон-де-Ардос", "ES", "724", "29", "M", "28148", "", "40.45535", "-3.46973", "Europe/Madrid"),
("3107807", "Torredembarra", "", "ES", "724", "56", "T", "43153", "", "41.14505", "1.39861", "Europe/Madrid"),
("3107955", "Tordera", "", "ES", "724", "56", "B", "08284", "", "41.69914", "2.71888", "Europe/Madrid"),
("3108008", "Tolosa", "", "ES", "724", "59", "SS", "20071", "", "43.13484", "-2.07801", "Europe/Madrid"),
("3108118", "Tetuan de las Victorias", "", "ES", "724", "29", "M", "28079", "", "40.46667", "-3.71667", "Europe/Madrid"),
("3108126", "Teruel", "Теруэль", "ES", "724", "52", "TE", "44216", "", "40.3456", "-1.10646", "Europe/Madrid"),
("3108165", "Teo", "", "ES", "724", "58", "C", "15082", "", "42.75", "-8.5", "Europe/Madrid"),
("3108285", "Tarrega", "", "ES", "724", "56", "L", "25217", "", "41.64704", "1.13957", "Europe/Madrid"),
("3108286", "Terrassa", "Террасса", "ES", "724", "56", "B", "08279", "", "41.56667", "2.01667", "Europe/Madrid"),
("3108288", "Tarragona", "Таррагона", "ES", "724", "56", "T", "43148", "", "41.11667", "1.25", "Europe/Madrid"),
("3108317", "Tarancon", "Таранкон", "ES", "724", "54", "CU", "16203", "", "40.00851", "-3.00731", "Europe/Madrid"),
("3108681", "Soria", "Сория", "ES", "724", "55", "SO", "42173", "", "41.76401", "-2.46883", "Europe/Madrid"),
("3108877", "Sitges", "Ситжес", "ES", "724", "56", "B", "08270", "", "41.23506", "1.81193", "Europe/Madrid"),
("3109041", "Sestao", "Сестао", "ES", "724", "59", "BI", "48084", "", "43.30975", "-3.00716", "Europe/Madrid"),
("3109050", "Sesena", "", "ES", "724", "54", "TO", "45161", "", "40.10473", "-3.69793", "Europe/Madrid"),
("3109256", "Segovia", "Сеговия", "ES", "724", "55", "SG", "40194", "", "40.94808", "-4.11839", "Europe/Madrid"),
("3109402", "Cerdanyola del Valles", "", "ES", "724", "56", "B", "08266", "", "41.49109", "2.14079", "Europe/Madrid"),
("3109442", "Sant Vicenc dels Horts", "", "ES", "724", "56", "B", "08263", "", "41.39317", "2.00689", "Europe/Madrid"),
("3109453", "Barakaldo", "", "ES", "724", "59", "BI", "48013", "", "43.29564", "-2.99729", "Europe/Madrid"),
("3109481", "Santurtzi", "", "ES", "724", "59", "BI", "48082", "", "43.32842", "-3.03248", "Europe/Madrid"),
("3109546", "Sant Just Desvern", "", "ES", "724", "56", "B", "08019", "", "41.38602", "2.07573", "Europe/Madrid"),
("3109642", "Santiago de Compostela", "Сантьяго-де-Компостела", "ES", "724", "58", "C", "15078", "", "42.88052", "-8.54569", "Europe/Madrid"),
("3109689", "Santa Perpetua de Mogoda", "", "ES", "724", "56", "B", "08260", "", "41.53333", "2.18333", "Europe/Madrid"),
("3109718", "Santander", "Сантандер", "ES", "724", "39", "S", "39075", "", "43.46472", "-3.80444", "Europe/Madrid"),
("3109804", "Barbera del Valles", "", "ES", "724", "56", "B", "08252", "", "41.5159", "2.12457", "Europe/Madrid"),
("3109981", "Santa Coloma de Gramenet", "Санта-Колома-де-Граманет", "ES", "724", "56", "B", "08125", "", "41.45152", "2.2081", "Europe/Madrid"),
("3110040", "San Sebastian de los Reyes", "Сан-Себастиан-де-лос-Рейес", "ES", "724", "29", "M", "28134", "", "40.54433", "-3.61588", "Europe/Madrid"),
("3110044", "San Sebastian", "Сан-Себастьян", "ES", "724", "59", "SS", "20069", "", "43.31283", "-1.97499", "Europe/Madrid"),
("3110101", "Sant Quirze del Valles", "", "ES", "724", "56", "B", "08238", "", "41.53333", "2.08333", "Europe/Madrid"),
("3110143", "Sant Pere de Ribes", "", "ES", "724", "56", "B", "08270", "", "41.26667", "1.76667", "Europe/Madrid"),
("3110360", "San Martin de la Vega", "Сан-Мартин-де-ла-Вега", "ES", "724", "29", "M", "28132", "", "40.20735", "-3.57063", "Europe/Madrid"),
("3110458", "San Lorenzo de El Escorial", "Сан-Лоренсо-де-Эль-Эскориаль", "ES", "724", "29", "M", "28131", "", "40.59144", "-4.14738", "Europe/Madrid"),
("3110516", "Vilassar de Mar", "", "ES", "724", "56", "B", "08219", "", "41.50961", "2.39365", "Europe/Madrid"),
("3110519", "Sant Joan Despi", "Sant Joan Despí", "ES", "724", "56", "B", "08019", "", "41.36667", "2.06667", "Europe/Madrid"),
("3110610", "Sanxenxo", "", "ES", "724", "58", "PO", "36051", "", "42.39996", "-8.80698", "Europe/Madrid"),
("3110627", "San Fernando de Henares", "", "ES", "724", "29", "M", "28130", "", "40.42386", "-3.53261", "Europe/Madrid"),
("3110642", "Sant Feliu de Llobregat", "Фелиу-де-Льобрегат", "ES", "724", "56", "B", "08211", "", "41.38333", "2.05", "Europe/Madrid"),
("3110643", "Sant Feliu de Guixols", "", "ES", "724", "56", "GI", "17160", "", "41.78333", "3.03333", "Europe/Madrid"),
("3110718", "Sant Cugat del Valles", "", "ES", "724", "56", "B", "08205", "", "41.46667", "2.08333", "Europe/Madrid"),
("3110813", "Sant Celoni", "", "ES", "724", "56", "B", "08202", "", "41.68333", "2.48333", "Europe/Madrid"),
("3110821", "Sant Carles de la Rapita", "Сан-Карлос-де-ла-Рапита", "ES", "724", "56", "T", "43136", "", "40.61667", "0.6", "Europe/Madrid"),
("3110834", "Sant Boi de Llobregat", "", "ES", "724", "56", "B", "08200", "", "41.34357", "2.03659", "Europe/Madrid"),
("3110876", "Sant Andreu de Palomar", "", "ES", "724", "56", "B", "08019", "", "41.43541", "2.18982", "Europe/Madrid"),
("3110880", "San Andres del Rabanedo", "Сан-Андрес-дель-Рабанедо", "ES", "724", "55", "LE", "24089", "", "42.61174", "-5.61671", "Europe/Madrid"),
("3110885", "Sant Andreu de la Barca", "", "ES", "724", "56", "B", "08054", "", "41.44659", "1.97187", "Europe/Madrid"),
("3110921", "Sant Adria de Besos", "", "ES", "724", "56", "B", "08019", "", "41.43073", "2.21855", "Europe/Madrid"),
("3110962", "Sama", "Саме", "ES", "724", "34", "O", "33031", "", "43.29568", "-5.68416", "Europe/Madrid"),
("3110983", "Salt", "", "ES", "724", "56", "GI", "17155", "", "41.97489", "2.79281", "Europe/Madrid"),
("3110986", "Salou", "Салоу", "ES", "724", "56", "T", "43171", "", "41.07663", "1.14163", "Europe/Madrid"),
("3111108", "Salamanca", "Саламанка", "ES", "724", "55", "SA", "37274", "", "40.96882", "-5.66388", "Europe/Madrid"),
("3111199", "Sabadell", "", "ES", "724", "56", "B", "08187", "", "41.54329", "2.10942", "Europe/Madrid"),
("3111294", "Rubi", "Руби", "ES", "724", "56", "B", "08184", "", "41.49226", "2.03305", "Europe/Madrid"),
("3111348", "Roses", "Росас", "ES", "724", "56", "GI", "17152", "", "42.26199", "3.17689", "Europe/Madrid"),
("3111605", "Ripollet", "", "ES", "724", "56", "B", "08180", "", "41.49686", "2.15739", "Europe/Madrid"),
("3111807", "Ribeira", "", "ES", "724", "58", "C", "15089", "", "42.7461", "-8.44392", "Europe/Madrid"),
("3111933", "Reus", "Реус", "ES", "724", "56", "T", "43123", "", "41.15612", "1.10687", "Europe/Madrid"),
("3112011", "Errenteria", "", "ES", "724", "59", "SS", "20067", "", "43.31195", "-1.90234", "Europe/Madrid"),
("3112154", "Redondela", "Редондела", "ES", "724", "58", "PO", "36045", "", "42.28337", "-8.6096", "Europe/Madrid"),
("3112737", "Puente de Vallecas", "", "ES", "724", "29", "M", "28079", "", "40.39354", "-3.662", "Europe/Madrid"),
("3112761", "Ponteareas", "", "ES", "724", "58", "PO", "36042", "", "42.18333", "-8.5", "Europe/Madrid"),
("3112866", "Premia de Mar", "Премия-де-Мар", "ES", "724", "56", "B", "08172", "", "41.49206", "2.36524", "Europe/Madrid"),
("3112989", "Pozuelo de Alarcon", "Посуэло-де-Аларкон", "ES", "724", "29", "M", "28115", "", "40.43293", "-3.81338", "Europe/Madrid"),
("3113035", "Poio", "", "ES", "724", "58", "PO", "36038", "", "42.44423", "-8.71482", "Europe/Madrid"),
("3113082", "Portugalete", "Португалете", "ES", "724", "59", "BI", "48078", "", "43.32099", "-3.02064", "Europe/Madrid"),
("3113157", "Porrino", "", "ES", "724", "58", "PO", "36039", "", "42.16156", "-8.6198", "Europe/Madrid"),
("3113209", "Pontevedra", "Понтеведра", "ES", "724", "58", "PO", "36038", "", "42.431", "-8.64435", "Europe/Madrid"),
("3113236", "Ponferrada", "Понферрада", "ES", "724", "55", "LE", "24115", "", "42.54664", "-6.59619", "Europe/Madrid"),
("3113268", "Pola de Siero", "Пола-де-Сьеро", "ES", "724", "34", "O", "33066", "", "43.39228", "-5.66335", "Europe/Madrid"),
("3113331", "Plasencia", "Пласенсиа", "ES", "724", "57", "CC", "10148", "", "40.03116", "-6.08845", "Europe/Madrid"),
("3113415", "Pinto", "Пинто", "ES", "724", "29", "M", "28113", "", "40.24147", "-3.69999", "Europe/Madrid"),
("3113526", "Pineda de Mar", "Пинеда де Мар", "ES", "724", "56", "B", "08163", "", "41.62763", "2.6889", "Europe/Madrid"),
("3114256", "Parla", "Парла", "ES", "724", "29", "M", "28106", "", "40.23604", "-3.76752", "Europe/Madrid"),
("3114267", "Parets del Valles", "", "ES", "724", "56", "B", "08107", "", "41.57481", "2.23306", "Europe/Madrid"),
("3114472", "Pamplona", "Памплона", "ES", "724", "32", "NA", "31201", "", "42.81687", "-1.64323", "Europe/Madrid"),
("3114531", "Palencia", "Паленсия", "ES", "724", "55", "P", "34120", "", "42.00955", "-4.52406", "Europe/Madrid"),
("3114566", "Palamos", "", "ES", "724", "56", "GI", "17118", "", "41.84843", "3.12912", "Europe/Madrid"),
("3114567", "Palafrugell", "Палафружель", "ES", "724", "56", "GI", "17117", "", "41.91738", "3.1631", "Europe/Madrid"),
("3114711", "Oviedo", "Овьедо", "ES", "724", "34", "O", "33044", "", "43.36029", "-5.84476", "Europe/Madrid"),
("3114957", "Oria", "", "ES", "724", "59", "SS", "20902", "", "43.25541", "-2.01873", "Europe/Madrid"),
("3114965", "Ourense", "Оренсе", "ES", "724", "58", "OR", "32054", "", "42.33669", "-7.86407", "Europe/Madrid"),
("3115093", "Olot", "Олот", "ES", "724", "56", "GI", "17114", "", "42.18096", "2.49012", "Europe/Madrid"),
("3115171", "Olesa de Montserrat", "", "ES", "724", "56", "B", "08076", "", "41.54372", "1.89408", "Europe/Madrid"),
("3115177", "Oleiros", "Олейрос", "ES", "724", "58", "C", "15058", "", "43.33333", "-8.31667", "Europe/Madrid"),
("3115463", "Nigran", "Нигран", "ES", "724", "58", "PO", "36035", "", "42.14153", "-8.80656", "Europe/Madrid"),
("3115659", "Navalcarnero", "Навалькарнеро", "ES", "724", "29", "M", "28096", "", "40.28908", "-4.01197", "Europe/Madrid"),
("3115739", "Naron", "Нарон", "ES", "724", "58", "C", "15054", "", "43.51667", "-8.15278", "Europe/Madrid"),
("3115907", "Mungia", "", "ES", "724", "59", "BI", "48069", "", "43.35", "-2.83333", "Europe/Madrid"),
("3116025", "Mostoles", "Мостолес", "ES", "724", "29", "M", "28092", "", "40.32234", "-3.86496", "Europe/Madrid"),
("3116156", "Moratalaz", "", "ES", "724", "29", "M", "28079", "", "40.41667", "-3.65", "Europe/Madrid"),
("3116224", "Monzon", "", "ES", "724", "52", "HU", "22158", "", "41.91084", "0.19406", "Europe/Madrid"),
("3116262", "Montornes del Valles", "", "ES", "724", "56", "B", "08136", "", "41.53333", "2.26667", "Europe/Madrid"),
("3116478", "Monforte de Lemos", "Монфорте-де-Лемос", "ES", "724", "58", "LU", "27031", "", "42.52165", "-7.51422", "Europe/Madrid"),
("3116503", "Arrasate / Mondragon", "", "ES", "724", "59", "SS", "20055", "", "43.06441", "-2.48977", "Europe/Madrid"),
("3116527", "Montcada i Reixac", "", "ES", "724", "56", "B", "08125", "", "41.48333", "2.18333", "Europe/Madrid"),
("3116553", "Mollet del Valles", "", "ES", "724", "56", "B", "08125", "", "41.54026", "2.21306", "Europe/Madrid"),
("3116562", "Molins de Rei", "", "ES", "724", "56", "B", "08205", "", "41.41667", "2.01667", "Europe/Madrid"),
("3116653", "Moana", "Моания", "ES", "724", "58", "PO", "36029", "", "42.28333", "-8.75", "Europe/Madrid"),
("3116689", "Miranda de Ebro", "Миранда-де-Эбро", "ES", "724", "55", "BU", "09219", "", "42.6865", "-2.94695", "Europe/Madrid"),
("3116789", "Mieres", "Мьерес", "ES", "724", "34", "O", "33037", "", "43.25", "-5.76667", "Europe/Madrid"),
("3116963", "Mejorada del Campo", "", "ES", "724", "29", "M", "28084", "", "40.39283", "-3.48194", "Europe/Madrid"),
("3117010", "Medina del Campo", "Медина-дель-Кампо", "ES", "724", "55", "VA", "47085", "", "41.31239", "-4.91413", "Europe/Madrid"),
("3117164", "Mataro", "Матаро", "ES", "724", "56", "B", "08121", "", "41.54211", "2.4445", "Europe/Madrid"),
("3117232", "El Masnou", "", "ES", "724", "56", "B", "08118", "", "41.47978", "2.3188", "Europe/Madrid"),
("3117331", "Martorell", "Марторелле", "ES", "724", "56", "B", "08114", "", "41.47402", "1.93062", "Europe/Madrid"),
("3117409", "Marin", "", "ES", "724", "58", "PO", "36026", "", "42.38333", "-8.7", "Europe/Madrid"),
("3117533", "Manresa", "Манреса", "ES", "724", "56", "B", "08213", "", "41.72498", "1.82656", "Europe/Madrid"),
("3117539", "Manlleu", "Манльеу", "ES", "724", "56", "B", "08112", "", "42.00228", "2.28476", "Europe/Madrid"),
("3117636", "Malgrat de Mar", "", "ES", "724", "56", "B", "08110", "", "41.64662", "2.74135", "Europe/Madrid"),
("3117667", "Majadahonda", "Махадаонда", "ES", "724", "29", "M", "28080", "", "40.47353", "-3.87182", "Europe/Madrid"),
("3117735", "Madrid", "Мадрид", "ES", "724", "29", "M", "28079", "", "40.4165", "-3.70256", "Europe/Madrid"),
("3117814", "Lugo", "Луго", "ES", "724", "58", "LU", "27028", "", "43.00992", "-7.55602", "Europe/Madrid"),
("3118150", "Logrono", "Логроньо", "ES", "724", "27", "LO", "26089", "", "42.46667", "-2.45", "Europe/Madrid"),
("3118212", "Lloret de Mar", "Льорет-де-Мар", "ES", "724", "56", "GI", "17095", "", "41.69993", "2.84565", "Europe/Madrid"),
("3118228", "Llodio", "", "ES", "724", "59", "VI", "01036", "", "43.14322", "-2.96204", "Europe/Madrid"),
("3118514", "Lleida", "Лерида", "ES", "724", "56", "L", "25120", "", "41.61674", "0.62218", "Europe/Madrid"),
("3118532", "Leon", "Леон", "ES", "724", "55", "LE", "24089", "", "42.60003", "-5.57032", "Europe/Madrid"),
("3118554", "Leioa", "", "ES", "724", "59", "BI", "48054", "", "43.33333", "-2.98333", "Europe/Madrid"),
("3118594", "Leganes", "Леганес", "ES", "724", "29", "M", "28074", "", "40.32718", "-3.7635", "Europe/Madrid"),
("3118848", "Las Rozas de Madrid", "Лас-Росас-де-Мадрид", "ES", "724", "29", "M", "28127", "", "40.49292", "-3.87371", "Europe/Madrid"),
("3119027", "Lasarte", "", "ES", "724", "59", "SS", "20902", "", "43.26774", "-2.02169", "Europe/Madrid"),
("3119231", "La Pineda", "Ла Пинеда", "ES", "724", "56", "B", "08056", "", "41.07625", "1.18515", "Europe/Madrid"),
("3119536", "Lalin", "Лалин", "ES", "724", "58", "PO", "36024", "", "42.66085", "-8.11285", "Europe/Madrid"),
("3119631", "Laguna de Duero", "Лагуна-де-Дуэро", "ES", "724", "55", "VA", "47076", "", "41.58151", "-4.72332", "Europe/Madrid"),
("3119746", "A Estrada", "", "ES", "724", "58", "PO", "36017", "", "42.68333", "-8.48333", "Europe/Madrid"),
("3119841", "A Coruna", "Ла-Корунья", "ES", "724", "58", "C", "15030", "", "43.37135", "-8.396", "Europe/Madrid"),
("3120304", "Irun", "Ирун", "ES", "724", "59", "SS", "20045", "", "43.33904", "-1.78938", "Europe/Madrid"),
("3120410", "Illescas", "Ильескас", "ES", "724", "54", "TO", "45081", "", "40.12213", "-3.84704", "Europe/Madrid"),
("3120431", "Igualada", "Игуалада", "ES", "724", "56", "B", "08250", "", "41.58098", "1.6172", "Europe/Madrid"),
("3120501", "Humanes de Madrid", "", "ES", "724", "29", "M", "28073", "", "40.25038", "-3.83062", "Europe/Madrid"),
("3120514", "Huesca", "Уэска", "ES", "724", "52", "HU", "22125", "", "42.13615", "-0.4087", "Europe/Madrid"),
("3120619", "L'Hospitalet de Llobregat", "Оспиталет-де-Льобрегат", "ES", "724", "56", "B", "08019", "", "41.35967", "2.10028", "Europe/Madrid"),
("3120635", "Hortaleza", "", "ES", "724", "29", "M", "28079", "", "40.47444", "-3.6411", "Europe/Madrid"),
("3120811", "Hernani", "Эрнани", "ES", "724", "59", "SS", "20040", "", "43.26615", "-1.97615", "Europe/Madrid"),
("3120989", "Gernika-Lumo", "", "ES", "724", "59", "BI", "48046", "", "43.31667", "-2.68333", "Europe/Madrid"),
("3121007", "Getxo", "", "ES", "724", "59", "BI", "48044", "", "43.35689", "-3.01146", "Europe/Madrid"),
("3121070", "Guadalajara", "Гвадалахара", "ES", "724", "54", "GU", "19130", "", "40.62862", "-3.16185", "Europe/Madrid"),
("3121145", "Granollers", "", "ES", "724", "56", "B", "08181", "", "41.60797", "2.28773", "Europe/Madrid"),
("3121245", "Gracia", "", "ES", "724", "56", "B", "08019", "", "41.40237", "2.15641", "Europe/Madrid"),
("3121424", "Gijon", "Хихон", "ES", "724", "34", "O", "33024", "", "43.53573", "-5.66152", "Europe/Madrid"),
("3121437", "Getafe", "Хетафе", "ES", "724", "29", "M", "28065", "", "40.30571", "-3.73295", "Europe/Madrid"),
("3121456", "Girona", "Жерона", "ES", "724", "56", "GI", "17079", "", "41.98311", "2.82493", "Europe/Madrid"),
("3121519", "Gava", "Гава", "ES", "724", "56", "B", "08089", "", "41.30605", "2.00123", "Europe/Madrid"),
("3121751", "Galdakao", "Гальдакано", "ES", "724", "59", "BI", "48036", "", "43.23333", "-2.83333", "Europe/Madrid"),
("3121766", "Galapagar", "Галапагар", "ES", "724", "29", "M", "28061", "", "40.5783", "-4.00426", "Europe/Madrid"),
("3121881", "Fuenterrabia", "", "ES", "724", "59", "SS", "20036", "", "43.36859", "-1.79622", "Europe/Madrid"),
("3121960", "Fuenlabrada", "Фуэнлабрада", "ES", "724", "29", "M", "28058", "", "40.28419", "-3.79415", "Europe/Madrid"),
("3122452", "Figueras", "Фигейрас", "ES", "724", "34", "O", "33017", "", "43.53943", "-7.02559", "Europe/Madrid"),
("3122453", "Figueres", "Фигерас", "ES", "724", "56", "GI", "17066", "", "42.26645", "2.96163", "Europe/Madrid"),
("3122826", "Esplugues de Llobregat", "", "ES", "724", "56", "B", "08019", "", "41.37732", "2.08809", "Europe/Madrid"),
("3122912", "Esparreguera", "", "ES", "724", "56", "B", "08076", "", "41.53333", "1.86667", "Europe/Madrid"),
("3123063", "Ermua", "Эрмуа", "ES", "724", "59", "BI", "48034", "", "43.18333", "-2.5", "Europe/Madrid"),
("3123104", "Erandio", "Эрандио", "ES", "724", "59", "BI", "48902", "", "43.30788", "-2.94502", "Europe/Madrid"),
("3123329", "El Prat de Llobregat", "Эль Прат", "ES", "724", "56", "B", "08169", "", "41.32784", "2.09472", "Europe/Madrid"),
("3123493", "Ferrol", "", "ES", "724", "58", "C", "15036", "", "43.48321", "-8.23689", "Europe/Madrid"),
("3123667", "El Astillero", "Эль-Астильеро", "ES", "724", "39", "S", "39008", "", "43.40094", "-3.82051", "Europe/Madrid"),
("3123688", "Ejea de los Caballeros", "Эхеа-де-лос-Кабальерос", "ES", "724", "52", "Z", "50095", "", "42.12632", "-1.13716", "Europe/Madrid"),
("3123709", "Eibar", "Эйбар", "ES", "724", "59", "SS", "20030", "", "43.18493", "-2.47158", "Europe/Madrid"),
("3123773", "Durango", "Дуранго", "ES", "724", "59", "BI", "48027", "", "43.17124", "-2.6338", "Europe/Madrid"),
("3124041", "Culleredo", "Кульередо", "ES", "724", "58", "C", "15031", "", "43.28788", "-8.38858", "Europe/Madrid"),
("3124132", "Cuenca", "Куэнка", "ES", "724", "54", "CU", "16078", "", "40.06667", "-2.13333", "Europe/Madrid"),
("3124408", "Coslada", "Кослада", "ES", "724", "29", "M", "28049", "", "40.42378", "-3.56129", "Europe/Madrid"),
("3124432", "Corvera", "", "ES", "724", "39", "S", "39056", "", "43.26697", "-3.9471", "Europe/Madrid"),
("3124569", "Cornella de Llobregat", "", "ES", "724", "56", "B", "08019", "", "41.35", "2.08333", "Europe/Madrid"),
("3124765", "Colmenar Viejo", "Кольменар-Вьехо", "ES", "724", "29", "M", "28045", "", "40.65909", "-3.76762", "Europe/Madrid"),
("3124794", "Collado-Villalba", "Кольядо-Вильяльба", "ES", "724", "29", "M", "28047", "", "40.63506", "-4.00486", "Europe/Madrid"),
("3124964", "Ciudad Lineal", "", "ES", "724", "29", "M", "28079", "", "40.45455", "-3.64808", "Europe/Madrid"),
("3124967", "Ciutadella", "", "ES", "724", "07", "PM", "07015", "", "40.00112", "3.84144", "Europe/Madrid"),
("3125082", "Ciempozuelos", "", "ES", "724", "29", "M", "28040", "", "40.15913", "-3.62103", "Europe/Madrid"),
("3125239", "Chamartin", "", "ES", "724", "29", "M", "28079", "", "40.46206", "-3.6766", "Europe/Madrid"),
("3125621", "Castro-Urdiales", "", "ES", "724", "39", "S", "39020", "", "43.38286", "-3.22043", "Europe/Madrid"),
("3125723", "Castrillon", "", "ES", "724", "34", "O", "33007", "", "43.39788", "-6.79217", "Europe/Madrid"),
("3125897", "Castelldefels", "", "ES", "724", "56", "B", "08056", "", "41.27794", "1.97033", "Europe/Madrid"),
("3125915", "Castellar del Valles", "", "ES", "724", "56", "B", "08051", "", "41.61667", "2.08333", "Europe/Madrid"),
("3126317", "Cardedeu", "", "ES", "724", "56", "B", "08181", "", "41.63976", "2.35739", "Europe/Madrid"),
("3126369", "Carballo", "Карбальо", "ES", "724", "58", "C", "15019", "", "43.213", "-8.69104", "Europe/Madrid"),
("3126534", "Canovelles", "", "ES", "724", "56", "B", "08086", "", "41.61667", "2.28333", "Europe/Madrid"),
("3126577", "Cangas", "", "ES", "724", "58", "PO", "36008", "", "42.26413", "-8.78462", "Europe/Madrid"),
("3126888", "Cambrils", "Камбрилс", "ES", "724", "56", "T", "43038", "", "41.07479", "1.05244", "Europe/Madrid"),
("3126890", "Cambre", "", "ES", "724", "58", "C", "15017", "", "43.29438", "-8.34736", "Europe/Madrid"),
("3126917", "Camargo", "Камарго", "ES", "724", "39", "S", "39052", "", "43.40744", "-3.88498", "Europe/Madrid"),
("3127007", "Calella", "", "ES", "724", "56", "B", "08035", "", "41.61802", "2.66781", "Europe/Madrid"),
("3127035", "Caldes de Montbui", "", "ES", "724", "56", "B", "08033", "", "41.63333", "2.16667", "Europe/Madrid"),
("3127047", "Calatayud", "Калатаюд", "ES", "724", "52", "Z", "50067", "", "41.35353", "-1.64318", "Europe/Madrid"),
("3127065", "Calahorra", "Калаорра", "ES", "724", "27", "LO", "26036", "", "42.30506", "-1.96521", "Europe/Madrid"),
("3127066", "Calafell", "", "ES", "724", "56", "T", "43037", "", "41.19997", "1.5683", "Europe/Madrid"),
("3127451", "Burlata", "", "ES", "724", "32", "NA", "31086", "", "42.82562", "-1.61671", "Europe/Madrid"),
("3127461", "Burgos", "Бургос", "ES", "724", "55", "BU", "09059", "", "42.35022", "-3.67527", "Europe/Madrid"),
("3127889", "Boiro", "", "ES", "724", "58", "C", "15011", "", "42.65", "-8.9", "Europe/Madrid"),
("3127958", "Boadilla del Monte", "", "ES", "724", "29", "M", "28022", "", "40.405", "-3.87835", "Europe/Madrid"),
("3127978", "Blanes", "Бланес", "ES", "724", "56", "GI", "17023", "", "41.67419", "2.79036", "Europe/Madrid"),
("3128026", "Bilbao", "Бильбао", "ES", "724", "59", "BI", "48020", "", "43.26271", "-2.92528", "Europe/Madrid"),
("3128174", "Bermeo", "Бермео", "ES", "724", "59", "BI", "48017", "", "43.42088", "-2.72152", "Europe/Madrid"),
("3128201", "Berga", "", "ES", "724", "56", "B", "08022", "", "42.10429", "1.84628", "Europe/Madrid"),
("3128272", "Benicassim", "", "ES", "724", "60", "CS", "12028", "", "40.05", "0.06667", "Europe/Madrid"),
("3128273", "Benicarlo", "Беникарло", "ES", "724", "60", "CS", "12027", "", "40.4165", "0.42709", "Europe/Madrid"),
("3128291", "Benavente", "", "ES", "724", "55", "ZA", "49021", "", "42.00249", "-5.67826", "Europe/Madrid"),
("3128382", "Bejar", "Бехар", "ES", "724", "55", "SA", "37046", "", "40.38641", "-5.76341", "Europe/Madrid"),
("3128760", "Barcelona", "Барселона", "ES", "724", "56", "B", "08019", "", "41.38879", "2.15899", "Europe/Madrid"),
("3128795", "Barbastro", "Барбастро", "ES", "724", "52", "HU", "22048", "", "42.03565", "0.12686", "Europe/Madrid"),
("3128824", "Baranain", "Бараньяйн", "ES", "724", "32", "NA", "31901", "", "42.80567", "-1.67731", "Europe/Madrid"),
("3128832", "Barajas de Madrid", "", "ES", "724", "29", "M", "28079", "", "40.47366", "-3.57777", "Europe/Madrid"),
("3128885", "Banyoles", "", "ES", "724", "56", "GI", "17015", "", "42.11667", "2.76667", "Europe/Madrid"),
("3128978", "Balaguer", "", "ES", "724", "56", "L", "25040", "", "41.79117", "0.81094", "Europe/Madrid"),
("3129028", "Badalona", "Бадалона", "ES", "724", "56", "B", "08015", "", "41.45004", "2.24741", "Europe/Madrid"),
("3129046", "Azuqueca de Henares", "Асукека-де-Энарес", "ES", "724", "54", "GU", "19046", "", "40.56688", "-3.25992", "Europe/Madrid"),
("3129135", "Aviles", "Авилес", "ES", "724", "34", "O", "33004", "", "43.55473", "-5.92483", "Europe/Madrid"),
("3129136", "Avila", "Авила", "ES", "724", "55", "AV", "05019", "", "40.65724", "-4.69951", "Europe/Madrid"),
("3129329", "Arteixo", "", "ES", "724", "58", "C", "15005", "", "43.30482", "-8.50749", "Europe/Madrid"),
("3129636", "Arganda", "Арганда", "ES", "724", "29", "M", "28014", "", "40.30076", "-3.43722", "Europe/Madrid"),
("3129857", "Aranjuez", "Аранхуэс", "ES", "724", "29", "M", "28013", "", "40.03108", "-3.60246", "Europe/Madrid"),
("3129877", "Aranda de Duero", "Аранда-де-Дуэро", "ES", "724", "55", "BU", "09018", "", "41.67041", "-3.6892", "Europe/Madrid"),
("3130131", "Amposta", "", "ES", "724", "56", "T", "43014", "", "40.71308", "0.58103", "Europe/Madrid"),
("3130137", "Amorebieta", "", "ES", "724", "59", "BI", "48003", "", "43.21667", "-2.73333", "Europe/Madrid"),
("3130155", "Ames", "Эймса", "ES", "724", "58", "C", "15013", "", "42.9", "-8.63333", "Europe/Madrid"),
("3130380", "Algorta", "", "ES", "724", "59", "BI", "48044", "", "43.34927", "-3.0094", "Europe/Madrid"),
("3130383", "Algete", "", "ES", "724", "29", "M", "28009", "", "40.59711", "-3.49743", "Europe/Madrid"),
("3130564", "Alcorcon", "Алькоркон", "ES", "724", "29", "M", "28007", "", "40.34582", "-3.82487", "Europe/Madrid"),
("3130583", "Alcobendas", "Алькобендас", "ES", "724", "29", "M", "28006", "", "40.54746", "-3.64197", "Europe/Madrid"),
("3130606", "Alcaniz", "Альканьис", "ES", "724", "52", "TE", "44013", "", "41.05", "-0.13333", "Europe/Madrid"),
("3130616", "Alcala de Henares", "Алькала-де-Энарес", "ES", "724", "29", "M", "28005", "", "40.48205", "-3.35996", "Europe/Madrid"),
("6252065", "Nou Barris", "", "ES", "724", "56", "B", "08019", "", "41.44163", "2.17727", "Europe/Madrid"),
("6324376", "Pinar de Chamartin", "", "ES", "724", "29", "M", "28079", "", "40.47903", "-3.66836", "Europe/Madrid"),
("6354969", "Playa del Ingles", "Плая дель Инглес", "ES", "724", "53", "GC", "35019", "", "27.7567", "-15.5787", "Atlantic/Canary"),
("6355013", "Puerto del Carmen", "Пуэрто-дель-Кармен", "ES", "724", "53", "GC", "35028", "", "28.92313", "-13.66579", "Atlantic/Canary"),
("6362987", "Ceuta", "Сеута", "ES", "724", "CE", "CE", "51001", "", "35.88933", "-5.31979", "Africa/Ceuta"),
("6544099", "Moncloa-Aravaca", "", "ES", "724", "29", "M", "28079", "", "40.43547", "-3.7317", "Europe/Madrid"),
("6544100", "Eixample", "Эшампле", "ES", "724", "56", "B", "08019", "", "41.38896", "2.16179", "Europe/Madrid"),
("6544101", "les Corts", "", "ES", "724", "56", "B", "08019", "", "41.38712", "2.13007", "Europe/Madrid"),
("6544102", "Sarria-Sant Gervasi", "", "ES", "724", "56", "B", "08019", "", "41.40104", "2.1394", "Europe/Madrid"),
("6544103", "Horta-Guinardo", "", "ES", "724", "56", "B", "08019", "", "41.41849", "2.1677", "Europe/Madrid"),
("6544104", "Sants-Montjuic", "", "ES", "724", "56", "B", "08019", "", "41.37263", "2.1546", "Europe/Madrid"),
("6544105", "Sant Marti", "", "ES", "724", "56", "B", "08019", "", "41.41814", "2.19933", "Europe/Madrid"),
("6544106", "Ciutat Vella", "", "ES", "724", "56", "B", "08019", "", "41.38022", "2.17319", "Europe/Madrid"),
("6544487", "Arganzuela", "", "ES", "724", "29", "M", "28079", "", "40.40021", "-3.69618", "Europe/Madrid"),
("6544488", "San Blas", "", "ES", "724", "29", "M", "28079", "", "40.43893", "-3.61537", "Europe/Madrid"),
("6544489", "Latina", "", "ES", "724", "29", "M", "28079", "", "40.38897", "-3.74569", "Europe/Madrid"),
("6544490", "Usera", "", "ES", "724", "29", "M", "28079", "", "40.38866", "-3.70035", "Europe/Madrid"),
("6544491", "Salamanca", "Саламанка", "ES", "724", "29", "M", "28079", "", "40.42972", "-3.67975", "Europe/Madrid"),
("6544492", "Chamberi", "", "ES", "724", "29", "M", "28079", "", "40.43404", "-3.70379", "Europe/Madrid"),
("6544493", "Carabanchel", "", "ES", "724", "29", "M", "28079", "", "40.39094", "-3.7242", "Europe/Madrid"),
("6544494", "City Center", "", "ES", "724", "29", "M", "28079", "", "40.41831", "-3.70275", "Europe/Madrid"),
("6544495", "Retiro", "", "ES", "724", "29", "M", "28079", "", "40.41317", "-3.68307", "Europe/Madrid"),
("6559503", "l'Alfas del Pi", "", "ES", "724", "60", "A", "03011", "", "38.58055", "-0.10321", "Europe/Madrid"),
("6559641", "Las Gabias", "", "ES", "724", "51", "GR", "18905", "", "37.13296", "-3.69765", "Europe/Madrid"),
("6615440", "Delicias", "", "ES", "724", "52", "Z", "50297", "", "41.64928", "-0.90757", "Europe/Madrid"),
("6615442", "Almozara", "Альмозара", "ES", "724", "52", "Z", "50297", "", "41.66124", "-0.90169", "Europe/Madrid"),
("6615443", "Montecanal", "", "ES", "724", "52", "Z", "50297", "", "41.62965", "-0.93873", "Europe/Madrid"),
("6615444", "Oliver-Valdefierro, Oliver, Valdefierro", "", "ES", "724", "52", "Z", "50297", "", "41.64454", "-0.93349", "Europe/Madrid"),
("6618856", "Santutxu", "", "ES", "724", "59", "BI", "48020", "", "43.25347", "-2.9161", "Europe/Madrid"),
("6692471", "Los Realejos", "", "ES", "724", "53", "TF", "38031", "", "28.36739", "-16.58335", "Atlantic/Canary"),
("6693088", "Pasaia", "Пасахес", "ES", "724", "59", "SS", "20064", "", "43.3253", "-1.92707", "Europe/Madrid"),
("6697039", "Basauri", "Басаури", "ES", "724", "59", "BI", "48015", "", "43.2397", "-2.8858", "Europe/Madrid"),
("6943537", "Llefia", "", "ES", "724", "56", "B", "08015", "", "41.43806", "2.2195", "Europe/Madrid"),
("7115111", "Corvera de Asturias", "Корвера-де-Астуриас", "ES", "724", "34", "O", "33020", "", "43.51062", "-5.8691", "Europe/Madrid"),
("7521822", "Alpujarra Granadina", "", "ES", "724", "51", "GR", "18121", "", "36.93068", "-3.19565", "Europe/Madrid"),
("8050879", "Iturrama", "", "ES", "724", "32", "NA", "31201", "", "42.80847", "-1.65825", "Europe/Madrid"),
("8050880", "Ermitagana", "", "ES", "724", "32", "NA", "31201", "", "42.81084", "-1.66409", "Europe/Madrid"),
("8050888", "Primer Ensanche", "", "ES", "724", "32", "NA", "31201", "", "42.81483", "-1.64898", "Europe/Madrid"),
("8050889", "Segundo Ensanche", "", "ES", "724", "32", "NA", "31201", "", "42.8139", "-1.64295", "Europe/Madrid"),
("8285534", "Fuencarral-El Pardo", "", "ES", "724", "29", "M", "28079", "", "40.4984", "-3.7314", "Europe/Madrid"),
("8285535", "Villa de Vallecas", "", "ES", "724", "29", "M", "28079", "", "40.36695", "-3.60146", "Europe/Madrid"),
("8629192", "Natahoyo", "", "ES", "724", "34", "O", "33024", "", "43.54035", "-5.68233", "Europe/Madrid"),
("8629435", "MeteOlot", "", "ES", "724", "56", "GI", "17114", "", "42.18539", "2.48805", "Europe/Madrid"),
("325579", "Ziway", "", "ET", "231", "51", "", "", "", "7.93333", "38.71667", "Africa/Addis_Ababa"),
("325780", "Yirga `Alem", "", "ET", "231", "54", "", "", "", "6.75", "38.41667", "Africa/Addis_Ababa"),
("326036", "Yabelo", "", "ET", "231", "51", "", "", "", "4.88333", "38.08333", "Africa/Addis_Ababa"),
("326206", "Werota", "", "ET", "231", "46", "", "", "", "11.91667", "37.7", "Africa/Addis_Ababa"),
("326308", "Wenji", "", "ET", "231", "51", "", "", "", "8.45", "39.28333", "Africa/Addis_Ababa"),
("327694", "Tippi", "", "ET", "231", "54", "", "", "", "7.2", "35.45", "Africa/Addis_Ababa"),
("328689", "Shashemene", "", "ET", "231", "51", "", "", "", "7.2", "38.6", "Africa/Addis_Ababa"),
("328709", "Shambu", "", "ET", "231", "51", "", "", "", "9.56667", "37.1", "Africa/Addis_Ababa"),
("328716", "Shakiso", "", "ET", "231", "51", "", "", "", "5.75", "38.91667", "Africa/Addis_Ababa"),
("329114", "Sebeta", "", "ET", "231", "51", "", "", "", "8.91667", "38.61667", "Africa/Addis_Ababa"),
("329586", "Robit", "", "ET", "231", "46", "", "", "", "12.01667", "39.63333", "Africa/Addis_Ababa"),
("330120", "Nejo", "", "ET", "231", "51", "", "", "", "9.5", "35.5", "Africa/Addis_Ababa"),
("330186", "Nazret", "", "ET", "231", "51", "", "", "", "8.55", "39.26667", "Africa/Addis_Ababa"),
("330491", "Mojo", "", "ET", "231", "51", "", "", "", "8.6", "39.11667", "Africa/Addis_Ababa"),
("330764", "Metu", "", "ET", "231", "51", "", "", "", "8.3", "35.58333", "Africa/Addis_Ababa"),
("330811", "Metahara", "", "ET", "231", "51", "", "", "", "8.9", "39.91667", "Africa/Addis_Ababa"),
("331038", "Mendi", "Менди", "ET", "231", "51", "", "", "", "9.8", "35.1", "Africa/Addis_Ababa"),
("331180", "Mekele", "", "ET", "231", "53", "", "", "", "13.49667", "39.47528", "Africa/Addis_Ababa"),
("331416", "Maych'ew", "", "ET", "231", "53", "", "", "", "12.7875", "39.54222", "Africa/Addis_Ababa"),
("332746", "Korem", "", "ET", "231", "53", "", "", "", "12.50583", "39.52278", "Africa/Addis_Ababa"),
("332880", "K'olito", "", "ET", "231", "54", "", "", "", "7.31667", "38.08333", "Africa/Addis_Ababa"),
("333103", "Kibre Mengist", "", "ET", "231", "51", "", "", "", "5.88333", "38.98333", "Africa/Addis_Ababa"),
("333356", "Kemise", "", "ET", "231", "46", "", "", "", "10.71668", "39.86997", "Africa/Addis_Ababa"),
("333373", "Kombolcha", "Комбольча", "ET", "231", "46", "", "", "", "11.08155", "39.74339", "Africa/Addis_Ababa"),
("333750", "Jinka", "", "ET", "231", "54", "", "", "", "5.65", "36.65", "Africa/Addis_Ababa"),
("333772", "Jima", "", "ET", "231", "51", "", "", "", "7.66667", "36.83333", "Africa/Addis_Ababa"),
("333795", "Jijiga", "Джиджига", "ET", "231", "52", "", "", "", "9.35", "42.8", "Africa/Addis_Ababa"),
("334227", "Inda Silase", "", "ET", "231", "53", "", "", "", "14.10307", "38.28289", "Africa/Addis_Ababa"),
("335035", "Harar", "Харэр", "ET", "231", "50", "", "", "", "9.31387", "42.11815", "Africa/Addis_Ababa"),
("335288", "Hagere Hiywet", "", "ET", "231", "51", "", "", "", "8.98333", "37.85", "Africa/Addis_Ababa"),
("336014", "Gondar", "Гондэр", "ET", "231", "46", "", "", "", "12.6", "37.46667", "Africa/Addis_Ababa"),
("336350", "Goba", "Гоба", "ET", "231", "51", "", "", "", "7.01667", "39.98333", "Africa/Addis_Ababa"),
("336372", "Giyon", "", "ET", "231", "51", "", "", "", "8.53333", "37.98333", "Africa/Addis_Ababa"),
("336454", "Ginir", "", "ET", "231", "51", "", "", "", "7.13952", "40.71083", "Africa/Addis_Ababa"),
("336496", "Gimbi", "", "ET", "231", "51", "", "", "", "9.17031", "35.83491", "Africa/Addis_Ababa"),
("336931", "Genet", "Женя", "ET", "231", "51", "", "", "", "9.06667", "38.5", "Africa/Addis_Ababa"),
("337010", "Gelemso", "", "ET", "231", "51", "", "", "", "8.81667", "40.51667", "Africa/Addis_Ababa"),
("337152", "Gebre Guracha", "", "ET", "231", "51", "", "", "", "9.8", "38.4", "Africa/Addis_Ababa"),
("337405", "Gambela", "Гамбеле", "ET", "231", "49", "", "", "", "8.25", "34.58333", "Africa/Addis_Ababa"),
("337712", "Finote Selam", "", "ET", "231", "46", "", "", "", "10.7", "37.26667", "Africa/Addis_Ababa"),
("337771", "Fiche", "", "ET", "231", "51", "", "", "", "9.8", "38.73333", "Africa/Addis_Ababa"),
("337853", "Felege Neway", "", "ET", "231", "54", "", "", "", "6.3", "36.88333", "Africa/Addis_Ababa"),
("338554", "Dubti", "", "ET", "231", "45", "", "", "", "11.73292", "41.082", "Africa/Addis_Ababa"),
("338726", "Dodola", "Додола", "ET", "231", "51", "", "", "", "6.98333", "39.18333", "Africa/Addis_Ababa"),
("338832", "Dire Dawa", "Диредавы", "ET", "231", "48", "", "", "", "9.59306", "41.86611", "Africa/Addis_Ababa"),
("338998", "Dila", "Дила", "ET", "231", "54", "", "", "", "6.41667", "38.31667", "Africa/Addis_Ababa"),
("339219", "Dese", "", "ET", "231", "46", "", "", "", "11.13333", "39.63333", "Africa/Addis_Ababa"),
("339448", "Dembi Dolo", "", "ET", "231", "51", "", "", "", "8.53333", "34.8", "Africa/Addis_Ababa"),
("339666", "Debre Zeyit", "", "ET", "231", "51", "", "", "", "8.75", "38.98333", "Africa/Addis_Ababa"),
("339686", "Debre Tabor", "", "ET", "231", "46", "", "", "", "11.85", "38.01667", "Africa/Addis_Ababa"),
("339708", "Debre Mark'os", "", "ET", "231", "46", "", "", "", "10.35", "37.73333", "Africa/Addis_Ababa"),
("339734", "Debre Birhan", "", "ET", "231", "46", "", "", "", "9.67954", "39.53262", "Africa/Addis_Ababa"),
("339823", "Debark'", "", "ET", "231", "46", "", "", "", "13.15611", "37.89806", "Africa/Addis_Ababa"),
("341297", "Butajira", "", "ET", "231", "54", "", "", "", "8.11667", "38.36667", "Africa/Addis_Ababa"),
("341397", "Bure", "Буря", "ET", "231", "46", "", "", "", "10.7", "37.06667", "Africa/Addis_Ababa"),
("341742", "Bonga", "Бонга", "ET", "231", "54", "", "", "", "7.28333", "36.23333", "Africa/Addis_Ababa"),
("341877", "Boditi", "", "ET", "231", "54", "", "", "", "6.96667", "37.86667", "Africa/Addis_Ababa"),
("342190", "Bichena", "", "ET", "231", "46", "", "", "", "10.45", "38.2", "Africa/Addis_Ababa"),
("342559", "Bedesa", "", "ET", "231", "51", "", "", "", "8.9", "40.78333", "Africa/Addis_Ababa"),
("342567", "Bedele", "", "ET", "231", "51", "", "", "", "8.456", "36.35302", "Africa/Addis_Ababa"),
("342641", "Bati", "", "ET", "231", "46", "", "", "", "11.19152", "40.01675", "Africa/Addis_Ababa"),
("342856", "Bako", "Бако", "ET", "231", "54", "", "", "", "5.78333", "36.56667", "Africa/Addis_Ababa"),
("342884", "Bahir Dar", "Бахр-Дар", "ET", "231", "46", "", "", "", "11.59364", "37.39077", "Africa/Addis_Ababa"),
("343137", "Hawassa", "Авасе", "ET", "231", "54", "", "", "", "7.06205", "38.47635", "Africa/Addis_Ababa"),
("343292", "Asosa", "", "ET", "231", "47", "343291", "", "", "10.06667", "34.53333", "Africa/Addis_Ababa"),
("343402", "Asbe Teferi", "", "ET", "231", "51", "", "", "", "9.08569", "40.86708", "Africa/Addis_Ababa"),
("343409", "Asaita", "Асайита", "ET", "231", "45", "", "", "", "11.56838", "41.43869", "Africa/Addis_Ababa"),
("343413", "Asasa", "", "ET", "231", "51", "", "", "", "7.1", "39.2", "Africa/Addis_Ababa"),
("343593", "Areka", "", "ET", "231", "54", "", "", "", "7.06667", "37.7", "Africa/Addis_Ababa"),
("343663", "Arba Minch'", "", "ET", "231", "54", "", "", "", "6.03333", "37.55", "Africa/Addis_Ababa"),
("344420", "Aksum", "", "ET", "231", "53", "", "", "", "14.12448", "38.72444", "Africa/Addis_Ababa"),
("344620", "Hagere Maryam", "", "ET", "231", "51", "", "", "", "5.63418", "38.23603", "Africa/Addis_Ababa"),
("344661", "Agaro", "", "ET", "231", "51", "", "", "", "7.85", "36.65", "Africa/Addis_Ababa"),
("344923", "Adis Zemen", "", "ET", "231", "46", "", "", "", "12.11667", "37.78333", "Africa/Addis_Ababa"),
("344979", "Addis Ababa", "Аддис-Абеба", "ET", "231", "44", "", "", "", "9.02497", "38.74689", "Africa/Addis_Ababa"),
("345149", "Adigrat", "", "ET", "231", "53", "", "", "", "14.277", "39.462", "Africa/Addis_Ababa"),
("345353", "Addiet Canna", "", "ET", "231", "46", "", "", "", "11.26667", "37.48333", "Africa/Addis_Ababa"),
("345704", "Abomsa", "", "ET", "231", "46", "", "", "", "9.98333", "39.98333", "Africa/Addis_Ababa"),
("630752", "Ylojarvi", "", "FI", "246", "15", "06", "980", "", "61.55632", "23.59606", "Europe/Helsinki"),
("631707", "Vihti", "Вихти", "FI", "246", "13", "01", "927", "", "60.41699", "24.31965", "Europe/Helsinki"),
("632370", "Varkaus", "Варкаус", "FI", "246", "14", "11", "915", "", "62.31533", "27.873", "Europe/Helsinki"),
("632453", "Vantaa", "Вантаа", "FI", "246", "13", "01", "092", "", "60.29414", "25.04099", "Europe/Helsinki"),
("632672", "Valkeakoski", "Валкеакоски", "FI", "246", "15", "06", "908", "", "61.26421", "24.03122", "Europe/Helsinki"),
("632978", "Vaasa", "Вааса", "FI", "246", "15", "15", "905", "", "63.096", "21.61577", "Europe/Helsinki"),
("633221", "Uusikaupunki", "Уусикаупунки", "FI", "246", "15", "02", "895", "", "60.80043", "21.40841", "Europe/Helsinki"),
("633591", "Tuusula", "Туусула", "FI", "246", "13", "01", "858", "", "60.40368", "25.02638", "Europe/Helsinki"),
("633679", "Turku", "Турку", "FI", "246", "15", "02", "853", "", "60.45148", "22.26869", "Europe/Helsinki"),
("634093", "Tornio", "Торнио", "FI", "246", "06", "19", "851", "", "65.84811", "24.14662", "Europe/Helsinki"),
("634963", "Tampere", "Тампере", "FI", "246", "15", "06", "837", "", "61.49911", "23.78712", "Europe/Helsinki"),
("636947", "Siilinjarvi", "Силинъярви", "FI", "246", "14", "11", "749", "", "63.08333", "27.66667", "Europe/Helsinki"),
("637067", "Sibbo", "", "FI", "246", "13", "01", "753", "", "60.37752", "25.26906", "Europe/Helsinki"),
("637219", "Seinaejoki", "", "FI", "246", "15", "14", "743", "", "62.79446", "22.82822", "Europe/Helsinki"),
("637292", "Savonlinna", "Савонлинна", "FI", "246", "14", "10", "740", "", "61.8699", "28.87999", "Europe/Helsinki"),
("637948", "Salo", "Сало", "FI", "246", "15", "02", "734", "", "60.38333", "23.13333", "Europe/Helsinki"),
("638936", "Rovaniemi", "Рованиеми", "FI", "246", "06", "19", "698", "", "66.5", "25.71667", "Europe/Helsinki"),
("639406", "Riihimaki", "Рийхимяки", "FI", "246", "13", "05", "694", "", "60.73769", "24.77726", "Europe/Helsinki"),
("639734", "Rauma", "Раума", "FI", "246", "15", "04", "684", "", "61.12724", "21.51127", "Europe/Helsinki"),
("640124", "Raisio", "", "FI", "246", "15", "02", "680", "", "60.48592", "22.16895", "Europe/Helsinki"),
("640276", "Raahe", "Рахе", "FI", "246", "08", "17", "678", "", "64.68333", "24.48333", "Europe/Helsinki"),
("640999", "Pori", "Пори", "FI", "246", "15", "04", "609", "", "61.48333", "21.78333", "Europe/Helsinki"),
("641489", "Pirkkala", "", "FI", "246", "15", "06", "604", "", "61.46125", "23.63228", "Europe/Helsinki"),
("643492", "Oulu", "Оулу", "FI", "246", "08", "17", "564", "", "65.01236", "25.46816", "Europe/Helsinki"),
("644171", "Nurmijarvi", "Нурмиярви", "FI", "246", "13", "01", "543", "", "60.46407", "24.8073", "Europe/Helsinki"),
("644450", "Nokia", "Нокиа", "FI", "246", "15", "06", "536", "", "61.46667", "23.5", "Europe/Helsinki"),
("646005", "Mikkeli", "Миккели", "FI", "246", "14", "10", "491", "", "61.68857", "27.27227", "Europe/Helsinki"),
("646723", "Mantsala", "Мянтсяля", "FI", "246", "13", "01", "505", "", "60.63333", "25.31667", "Europe/Helsinki"),
("647751", "Lohja", "", "FI", "246", "13", "01", "444", "", "60.24859", "24.06534", "Europe/Helsinki"),
("648056", "Lieto", "", "FI", "246", "15", "02", "423", "", "60.51032", "22.46176", "Europe/Helsinki"),
("648366", "Lempaala", "", "FI", "246", "15", "06", "418", "", "61.31667", "23.75", "Europe/Helsinki"),
("648738", "Laukaa", "Лаука", "FI", "246", "15", "13", "410", "", "62.41407", "25.95194", "Europe/Helsinki"),
("648900", "Lappeenranta", "Лаппенранта", "FI", "246", "13", "09", "405", "", "61.05871", "28.18871", "Europe/Helsinki"),
("649360", "Lahti", "Лахти", "FI", "246", "13", "07", "398", "", "60.98267", "25.66151", "Europe/Helsinki"),
("649630", "Kirkkonummi", "", "FI", "246", "13", "01", "257", "", "60.12381", "24.43853", "Europe/Helsinki"),
("649924", "Kuusamo", "Куусамо", "FI", "246", "08", "17", "305", "", "65.96667", "29.18333", "Europe/Helsinki"),
("650224", "Kuopio", "Куопио", "FI", "246", "14", "11", "297", "", "62.89238", "27.67703", "Europe/Helsinki"),
("650859", "Kouvola", "Коувола", "FI", "246", "13", "08", "286", "", "60.86667", "26.7", "Europe/Helsinki"),
("650946", "Kotka", "Котка", "FI", "246", "13", "08", "285", "", "60.46667", "26.91667", "Europe/Helsinki"),
("651299", "Korsholm", "", "FI", "246", "15", "15", "499", "", "63.11418", "21.68216", "Europe/Helsinki"),
("651943", "Kokkola", "Коккола", "FI", "246", "15", "16", "272", "", "63.83847", "23.13066", "Europe/Helsinki"),
("653185", "Kerava", "Керава", "FI", "246", "13", "01", "245", "", "60.40338", "25.105", "Europe/Helsinki"),
("653281", "Kemi", "Кеми", "FI", "246", "06", "19", "240", "", "65.73641", "24.56371", "Europe/Helsinki"),
("654137", "Karhula", "Кархула", "FI", "246", "13", "08", "285", "", "60.51667", "26.95", "Europe/Helsinki"),
("654440", "Kangasala", "Кангасала", "FI", "246", "15", "06", "211", "", "61.46383", "24.07602", "Europe/Helsinki"),
("654899", "Kajaani", "Каяни", "FI", "246", "08", "18", "205", "", "64.22728", "27.72846", "Europe/Helsinki"),
("655130", "Kaarina", "Каарина", "FI", "246", "15", "02", "202", "", "60.40724", "22.36904", "Europe/Helsinki"),
("655194", "Jyvaeskylae", "Ювяскюля", "FI", "246", "15", "13", "179", "", "62.24147", "25.72088", "Europe/Helsinki"),
("655808", "Joensuu", "Йоэнсуу", "FI", "246", "14", "12", "167", "", "62.60118", "29.76316", "Europe/Helsinki"),
("655958", "Jarvenpaa", "Ярвенпяя", "FI", "246", "13", "01", "186", "", "60.47369", "25.08992", "Europe/Helsinki"),
("656073", "Janakkala", "Янаккала", "FI", "246", "13", "05", "165", "", "60.9", "24.6", "Europe/Helsinki"),
("656083", "Jamsa", "Йямся", "FI", "246", "15", "13", "182", "", "61.8642", "25.19002", "Europe/Helsinki"),
("656130", "Jakobstad", "Якобстад", "FI", "246", "15", "15", "598", "", "63.67486", "22.70256", "Europe/Helsinki"),
("656688", "Imatra", "Иматра", "FI", "246", "13", "09", "153", "", "61.17185", "28.75242", "Europe/Helsinki"),
("656820", "Iisalmi", "Исалми", "FI", "246", "14", "11", "140", "", "63.55915", "27.19067", "Europe/Helsinki"),
("656913", "Hyvinkaa", "Хювинкяя", "FI", "246", "13", "01", "106", "", "60.63333", "24.86667", "Europe/Helsinki"),
("657530", "Hollola", "Холлола", "FI", "246", "13", "07", "098", "", "61.05", "25.43333", "Europe/Helsinki"),
("658225", "Helsinki", "Хельсинки", "FI", "246", "13", "01", "091", "", "60.16952", "24.93545", "Europe/Helsinki"),
("658288", "Heinola", "Хейнола", "FI", "246", "13", "07", "111", "", "61.20564", "26.03811", "Europe/Helsinki"),
("658629", "Haukipudas", "Хаукипудас", "FI", "246", "08", "17", "564", "", "65.17654", "25.35233", "Europe/Helsinki"),
("659169", "Hamina", "Хамина", "FI", "246", "13", "08", "075", "", "60.56974", "27.19794", "Europe/Helsinki"),
("659180", "Hameenlinna", "Хямеэнлинна", "FI", "246", "13", "05", "109", "", "60.99596", "24.46434", "Europe/Helsinki"),
("659935", "Forssa", "Форсса", "FI", "246", "13", "05", "061", "", "60.81462", "23.62146", "Europe/Helsinki"),
("660158", "Espoo", "Эспоо", "FI", "246", "13", "01", "049", "", "60.2052", "24.6522", "Europe/Helsinki"),
("660561", "Porvoo", "Порвоо", "FI", "246", "13", "01", "638", "", "60.39233", "25.66507", "Europe/Helsinki"),
("661164", "Anjala", "Анъяла", "FI", "246", "13", "08", "286", "", "60.68333", "26.83333", "Europe/Helsinki"),
("7911309", "Laensi-Turunmaa", "", "FI", "246", "15", "02", "445", "", "60.29972", "22.3004", "Europe/Helsinki"),
("2967245", "Yerres", "Йер", "FR", "250", "A8", "91", "912", "91691", "48.71785", "2.49338", "Europe/Paris"),
("2967318", "Wittenheim", "", "FR", "250", "C1", "68", "684", "68376", "47.8078", "7.33702", "Europe/Paris"),
("2967421", "Wattrelos", "Ваттрело", "FR", "250", "B4", "59", "595", "59650", "50.70118", "3.21812", "Europe/Paris"),
("2967438", "Wasquehal", "Васкеаль", "FR", "250", "B4", "59", "595", "59646", "50.67043", "3.13382", "Europe/Paris"),
("2967758", "Voiron", "Вуарон", "FR", "250", "B9", "38", "381", "38563", "45.36395", "5.59209", "Europe/Paris"),
("2967849", "Vitry-sur-Seine", "Витри-сюр-Сен", "FR", "250", "A8", "94", "941", "94081", "48.78716", "2.40332", "Europe/Paris"),
("2967856", "Vitry-le-Francois", "Витри-ле-Франсуа", "FR", "250", "A4", "51", "514", "51649", "48.73333", "4.58333", "Europe/Paris"),
("2967870", "Vitrolles", "Витроль", "FR", "250", "B8", "13", "134", "13117", "43.46", "5.24861", "Europe/Paris"),
("2967879", "Vitre", "Витрэ", "FR", "250", "A2", "35", "351", "35360", "48.11776", "-1.20577", "Europe/Paris"),
("2967917", "Viry-Chatillon", "Вири-Шатиллон", "FR", "250", "A8", "91", "912", "91687", "48.67212", "2.39318", "Europe/Paris"),
("2967934", "Viroflay", "Вирофле", "FR", "250", "A8", "78", "784", "78686", "48.80078", "2.16181", "Europe/Paris"),
("2968054", "Vincennes", "Венсен", "FR", "250", "A8", "94", "942", "94080", "48.8486", "2.43769", "Europe/Paris"),
("2968142", "Villiers-sur-Marne", "Вилье-сюр-Марн", "FR", "250", "A8", "94", "942", "94079", "48.831", "2.54844", "Europe/Paris"),
("2968176", "Villiers-le-Bel", "Вилье-ле-Бель", "FR", "250", "A8", "95", "952", "95680", "49.00875", "2.39819", "Europe/Paris"),
("2968254", "Villeurbanne", "Вийёрбан", "FR", "250", "B9", "69", "691", "69266", "45.76667", "4.88333", "Europe/Paris"),
("2968368", "Villers-les-Nancy", "Виллер-ле-Нанси", "FR", "250", "B2", "54", "543", "54578", "48.67103", "6.15083", "Europe/Paris"),
("2968482", "Villepinte", "", "FR", "250", "A8", "93", "932", "93078", "48.96203", "2.53253", "Europe/Paris"),
("2968496", "Villeparisis", "Вильпаризи", "FR", "250", "A8", "77", "775", "77514", "48.94208", "2.61463", "Europe/Paris"),
("2968515", "Villeneuve-sur-Lot", "Вильнев-сюр-Ло", "FR", "250", "97", "47", "473", "47323", "44.40854", "0.70415", "Europe/Paris"),
("2968529", "Villeneuve-Saint-Georges", "Вильнёв-Сен-Жорж", "FR", "250", "A8", "94", "941", "94078", "48.73219", "2.44925", "Europe/Paris"),
("2968546", "Villeneuve-le-Roi", "", "FR", "250", "A8", "94", "941", "94077", "48.73684", "2.40081", "Europe/Paris"),
("2968555", "Villeneuve-la-Garenne", "", "FR", "250", "A8", "92", "922", "92078", "48.93935", "2.31478", "Europe/Paris"),
("2968620", "Villenave-d'Ornon", "", "FR", "250", "97", "33", "332", "33550", "44.77327", "-0.5442", "Europe/Paris"),
("2968653", "Villemomble", "", "FR", "250", "A8", "93", "931", "93077", "48.88333", "2.5", "Europe/Paris"),
("2968705", "Villejuif", "Вильжюиф", "FR", "250", "A8", "94", "943", "94076", "48.7939", "2.35992", "Europe/Paris"),
("2968748", "Villefranche-sur-Saone", "Вильфранш-сюр-Сон", "FR", "250", "B9", "69", "692", "69264", "45.98333", "4.71667", "Europe/Paris"),
("2968771", "Villefontaine", "", "FR", "250", "B9", "38", "382", "38553", "45.6125", "5.14558", "Europe/Paris"),
("2969109", "Vigneux-sur-Seine", "", "FR", "250", "A8", "91", "912", "91657", "48.70291", "2.41357", "Europe/Paris"),
("2969257", "Vierzon", "Вьерзон", "FR", "250", "A3", "18", "183", "18279", "47.21667", "2.08333", "Europe/Paris"),
("2969284", "Vienne", "Вьенн", "FR", "250", "B9", "38", "383", "38544", "45.51667", "4.86667", "Europe/Paris"),
("2969392", "Vichy", "Виши", "FR", "250", "98", "03", "033", "03310", "46.11667", "3.41667", "Europe/Paris"),
("2969562", "Vesoul", "Везуль", "FR", "250", "A6", "70", "702", "70550", "47.63333", "6.16667", "Europe/Paris"),
("2969612", "Vertou", "", "FR", "250", "B5", "44", "442", "44215", "47.16869", "-1.46929", "Europe/Paris"),
("2969679", "Versailles", "Версаль", "FR", "250", "A8", "78", "784", "78646", "48.8", "2.13333", "Europe/Paris"),
("2969692", "Verrieres-le-Buisson", "", "FR", "250", "A8", "91", "913", "91645", "48.74565", "2.26796", "Europe/Paris"),
("2969766", "Vernon", "", "FR", "250", "A7", "27", "273", "27681", "49.09292", "1.46332", "Europe/Paris"),
("2969796", "Verneuil-sur-Seine", "", "FR", "250", "A8", "78", "783", "78642", "48.97388", "1.9648", "Europe/Paris"),
("2969958", "Verdun", "Верден", "FR", "250", "B2", "55", "553", "55545", "49.16667", "5.38333", "Europe/Paris"),
("2970072", "Venissieux", "Венисье", "FR", "250", "B9", "69", "691", "69259", "45.70254", "4.87147", "Europe/Paris"),
("2970110", "Vendome", "Вандом", "FR", "250", "A3", "41", "412", "41269", "47.8", "1.06667", "Europe/Paris"),
("2970148", "Vence", "", "FR", "250", "B8", "06", "061", "06157", "43.72162", "7.11232", "Europe/Paris"),
("2970203", "Velizy-Villacoublay", "", "FR", "250", "A8", "78", "784", "78640", "48.78198", "2.19395", "Europe/Paris"),
("2970432", "Vaureal", "Вореаль", "FR", "250", "A8", "95", "953", "95637", "49.03333", "2.03333", "Europe/Paris"),
("2970456", "Vaulx-en-Velin", "", "FR", "250", "B9", "69", "691", "69256", "45.7818", "4.92085", "Europe/Paris"),
("2970761", "Vanves", "Ванв", "FR", "250", "A8", "92", "921", "92075", "48.82345", "2.29025", "Europe/Paris"),
("2970777", "Vannes", "Ванн", "FR", "250", "A2", "56", "563", "56260", "47.66667", "-2.75", "Europe/Paris"),
("2970797", "Vandoeuvre-les-Nancy", "Вандёвр-ле-Нанси", "FR", "250", "B2", "54", "543", "54547", "48.65", "6.18333", "Europe/Paris"),
("2970962", "Vallauris", "Валлорис", "FR", "250", "B8", "06", "061", "06155", "43.57803", "7.05451", "Europe/Paris"),
("2971041", "Valenciennes", "Валансьен", "FR", "250", "B4", "59", "596", "59606", "50.35", "3.53333", "Europe/Paris"),
("2971053", "Valence", "", "FR", "250", "B9", "26", "263", "26362", "44.93333", "4.9", "Europe/Paris"),
("2971482", "Tulle", "Тюль", "FR", "250", "B1", "19", "192", "19272", "45.26667", "1.76667", "Europe/Paris"),
("2971549", "Troyes", "Труа", "FR", "250", "A4", "10", "103", "10387", "48.3", "4.08333", "Europe/Paris"),
("2971874", "Tremblay-en-France", "Трамбле-ан-Франс", "FR", "250", "A8", "93", "932", "93073", "48.94956", "2.5684", "Europe/Paris"),
("2972049", "Trappes", "", "FR", "250", "A8", "78", "784", "78621", "48.77413", "2.01781", "Europe/Paris"),
("2972191", "Tours", "Тур", "FR", "250", "A3", "37", "372", "37261", "47.38333", "0.68333", "Europe/Paris"),
("2972237", "Tournefeuille", "", "FR", "250", "B3", "31", "313", "31557", "43.58872", "1.31922", "Europe/Paris"),
("2972270", "Tourlaville", "", "FR", "250", "99", "50", "502", "50602", "49.63828", "-1.56639", "Europe/Paris"),
("2972284", "Tourcoing", "Туркуэн", "FR", "250", "B4", "59", "595", "59599", "50.72391", "3.16117", "Europe/Paris"),
("2972315", "Toulouse", "Тулуза", "FR", "250", "B3", "31", "313", "31555", "43.60426", "1.44367", "Europe/Paris"),
("2972328", "Toulon", "Тулон", "FR", "250", "B8", "83", "832", "83137", "43.11667", "5.93333", "Europe/Paris"),
("2972350", "Toul", "Туль", "FR", "250", "B2", "54", "544", "54528", "48.68333", "5.9", "Europe/Paris"),
("2972444", "Torcy", "", "FR", "250", "A8", "77", "775", "77468", "48.85", "2.65", "Europe/Paris"),
("2972742", "Thonon-les-Bains", "Тонон-ле-Бен", "FR", "250", "B9", "74", "744", "74281", "46.36667", "6.48333", "Europe/Paris"),
("2972811", "Thionville", "Тьонвиль", "FR", "250", "B2", "57", "577", "57672", "49.36667", "6.16667", "Europe/Paris"),
("2972893", "Thiais", "Тие", "FR", "250", "A8", "94", "943", "94073", "48.76496", "2.3961", "Europe/Paris"),
("2973146", "Tergnier", "Тернье", "FR", "250", "B6", "02", "022", "02738", "49.65607", "3.30107", "Europe/Paris"),
("2973258", "Taverny", "Таверни", "FR", "250", "A8", "95", "953", "95607", "49.02542", "2.21691", "Europe/Paris"),
("2973317", "Tassin-la-Demi-Lune", "", "FR", "250", "B9", "69", "691", "69123", "45.75499", "4.78812", "Europe/Paris"),
("2973385", "Tarbes", "Тарб", "FR", "250", "B3", "65", "653", "65440", "43.23333", "0.08333", "Europe/Paris"),
("2973495", "Talence", "Таланс", "FR", "250", "97", "33", "332", "33522", "44.80477", "-0.59543", "Europe/Paris"),
("2973675", "Suresnes", "Сюрен", "FR", "250", "A8", "92", "922", "92073", "48.87143", "2.22929", "Europe/Paris"),
("2973745", "Sucy-en-Brie", "", "FR", "250", "A8", "94", "941", "94071", "48.76872", "2.53474", "Europe/Paris"),
("2973783", "Strasbourg", "Страсбург", "FR", "250", "C1", "67", "678", "67482", "48.58392", "7.74553", "Europe/Paris"),
("2973841", "Stains", "", "FR", "250", "A8", "93", "933", "93072", "48.95", "2.38333", "Europe/Paris"),
("2974153", "Sotteville-les-Rouen", "Соттевиль-ле-Руан", "FR", "250", "A7", "76", "763", "76681", "49.40972", "1.09006", "Europe/Paris"),
("2974188", "Sorgues", "", "FR", "250", "B8", "84", "842", "84129", "44.01023", "4.87381", "Europe/Paris"),
("2974385", "Soisy-sous-Montmorency", "Суази-су-Монморанси", "FR", "250", "A8", "95", "952", "95598", "48.98813", "2.30156", "Europe/Paris"),
("2974389", "Soissons", "Суассон", "FR", "250", "B6", "02", "024", "02722", "49.38167", "3.32361", "Europe/Paris"),
("2974427", "Six-Fours-les-Plages", "", "FR", "250", "B8", "83", "832", "83129", "43.1", "5.85", "Europe/Paris"),
("2974494", "Sin-le-Noble", "", "FR", "250", "B4", "59", "593", "59569", "50.36159", "3.13113", "Europe/Paris"),
("2974655", "Seynod", "", "FR", "250", "B9", "74", "741", "74268", "45.88549", "6.08831", "Europe/Paris"),
("2974678", "Sevres", "Севр", "FR", "250", "A8", "92", "923", "92072", "48.82292", "2.21757", "Europe/Paris"),
("2974681", "Sevran", "", "FR", "250", "A8", "93", "932", "93071", "48.94472", "2.52746", "Europe/Paris"),
("2974733", "Sete", "Сет", "FR", "250", "A9", "34", "343", "34301", "43.4028", "3.69278", "Europe/Paris"),
("2975050", "Sens", "", "FR", "250", "A1", "89", "893", "89387", "48.2", "3.28333", "Europe/Paris"),
("2975088", "Senlis", "", "FR", "250", "B6", "60", "604", "60612", "49.2", "2.58333", "Europe/Paris"),
("2975233", "Selestat", "Селеста", "FR", "250", "C1", "67", "675", "67462", "48.26667", "7.45", "Europe/Paris"),
("2975349", "Sedan", "Седан", "FR", "250", "A4", "08", "083", "08409", "49.7", "4.95", "Europe/Paris"),
("2975446", "Schiltigheim", "", "FR", "250", "C1", "67", "676", "67447", "48.60749", "7.74931", "Europe/Paris"),
("2975469", "Sceaux", "", "FR", "250", "A8", "92", "921", "92071", "48.77644", "2.29026", "Europe/Paris"),
("2975525", "Savigny-sur-Orge", "Савиньи-сюр-Орж", "FR", "250", "A8", "91", "913", "91589", "48.67678", "2.34835", "Europe/Paris"),
("2975536", "Savigny-le-Temple", "Савиньи-ле-храм", "FR", "250", "A8", "77", "772", "77445", "48.57409", "2.58287", "Europe/Paris"),
("2975758", "Saumur", "Сомюр", "FR", "250", "B5", "49", "493", "49328", "47.26667", "-0.08333", "Europe/Paris"),
("2975921", "Sartrouville", "", "FR", "250", "A8", "78", "783", "78586", "48.9482", "2.19169", "Europe/Paris"),
("2975964", "Sarreguemines", "Саргемин", "FR", "250", "B2", "57", "576", "57631", "49.10995", "7.06747", "Europe/Paris"),
("2976043", "Sarcelles", "Сарсель", "FR", "250", "A8", "95", "952", "95585", "49", "2.38333", "Europe/Paris"),
("2976050", "Saran", "", "FR", "250", "A3", "45", "452", "45302", "47.95013", "1.87601", "Europe/Paris"),
("2976179", "Sannois", "Саннуа", "FR", "250", "A8", "95", "951", "95582", "48.96667", "2.25", "Europe/Paris"),
("2976258", "Sanary-sur-Mer", "Санари-сюр-Мер", "FR", "250", "B8", "83", "832", "83123", "43.11784", "5.80006", "Europe/Paris"),
("2976341", "Salon-de-Provence", "Салон-де-Прованс", "FR", "250", "B8", "13", "131", "13103", "43.64074", "5.09545", "Europe/Paris"),
("2976406", "Sallanches", "", "FR", "250", "B9", "74", "742", "74256", "45.94423", "6.63162", "Europe/Paris"),
("2976984", "Saint-Sebastien-sur-Loire", "Санкт-Себастьян-сюр-Луар", "FR", "250", "B5", "44", "442", "44190", "47.20768", "-1.50332", "Europe/Paris"),
("2977246", "Saint-Raphael", "Сент-Рафаэль", "FR", "250", "B8", "83", "831", "83118", "43.42332", "6.7735", "Europe/Paris"),
("2977295", "Saint-Quentin", "", "FR", "250", "B6", "02", "023", "02691", "49.84889", "3.28757", "Europe/Paris"),
("2977356", "Saint-Priest", "", "FR", "250", "B9", "69", "691", "69290", "45.69612", "4.93892", "Europe/Paris"),
("2977388", "Saint-Pol-sur-Mer", "Сен-Поль-сюр-Мер", "FR", "250", "B4", "59", "594", "59183", "51.03116", "2.33984", "Europe/Paris"),
("2977491", "Saint-Pierre-des-Corps", "", "FR", "250", "A3", "37", "372", "37233", "47.38623", "0.74849", "Europe/Paris"),
("2977800", "Saint-Ouen-l'Aumone", "Сент-Уан-л'Омон", "FR", "250", "A8", "95", "953", "95572", "49.04353", "2.12134", "Europe/Paris"),
("2977824", "Saint-Ouen", "Санкт-Оуэн", "FR", "250", "A8", "75", "751", "75056", "48.9", "2.33333", "Europe/Paris"),
("2977845", "Saint-Omer", "", "FR", "250", "B4", "62", "625", "62765", "50.75", "2.25", "Europe/Paris"),
("2977921", "Saint-Nazaire", "Сен-Назер", "FR", "250", "B5", "44", "443", "44184", "47.28333", "-2.2", "Europe/Paris"),
("2977952", "Saint-Michel-sur-Orge", "Сен-Мишель-сюр-Орж", "FR", "250", "A8", "91", "913", "91570", "48.63479", "2.30831", "Europe/Paris"),
("2978072", "Saint-Medard-en-Jalles", "Санкт-Медард-ан-Жалль", "FR", "250", "97", "33", "332", "33449", "44.89692", "-0.72136", "Europe/Paris"),
("2978100", "Saint-Maximin-la-Sainte-Baume", "", "FR", "250", "B8", "83", "833", "83116", "43.45214", "5.86219", "Europe/Paris"),
("2978179", "Saint-Maur-des-Fosses", "Сен-Мор-де-Фоссе", "FR", "250", "A8", "94", "941", "94068", "48.79394", "2.49323", "Europe/Paris"),
("2978317", "Saint-Martin-d'Heres", "Сен-Мартен-д'Эр", "FR", "250", "B9", "38", "381", "38421", "45.16528", "5.76337", "Europe/Paris"),
("2978621", "Saint-Mande", "Санкт-Манде", "FR", "250", "A8", "94", "942", "94067", "48.83864", "2.41579", "Europe/Paris"),
("2978640", "Saint-Malo", "Сен-Мало", "FR", "250", "A2", "35", "354", "35288", "48.65", "-2.01667", "Europe/Paris"),
("2978742", "Saint-Louis", "Сен-Луи", "FR", "250", "C1", "68", "684", "68297", "47.58836", "7.56247", "Europe/Paris"),
("2978758", "Saint-Lo", "Сен-Ло", "FR", "250", "99", "50", "504", "50502", "49.11624", "-1.09031", "Europe/Paris"),
("2978768", "Saint-Leu-la-Foret", "Сен-Лё-ла-Форе", "FR", "250", "A8", "95", "953", "95563", "49.01667", "2.25", "Europe/Paris"),
("2978771", "Saint-Leu", "", "FR", "250", "A1", "71", "712", "71436", "46.7306", "4.50083", "Europe/Paris"),
("2978891", "Saint-Laurent-du-Var", "Сен-Лоран-дю-Вар", "FR", "250", "B8", "06", "061", "06123", "43.67097", "7.17606", "Europe/Paris"),
("2979316", "Saint-Jean-de-la-Ruelle", "", "FR", "250", "A3", "45", "452", "45285", "47.91127", "1.86483", "Europe/Paris"),
("2979341", "Saint-Jean-de-Braye", "", "FR", "250", "A3", "45", "452", "45284", "47.91303", "1.97705", "Europe/Paris"),
("2979590", "Saint-Herblain", "", "FR", "250", "B5", "44", "442", "44162", "47.21765", "-1.64841", "Europe/Paris"),
("2979627", "Saint-Gratien", "", "FR", "250", "A8", "95", "952", "95555", "48.9735", "2.28729", "Europe/Paris"),
("2979783", "Saint-Germain-en-Laye", "Сен-Жермен-ан-Ле", "FR", "250", "A8", "78", "783", "78551", "48.9", "2.08333", "Europe/Paris"),
("2979985", "Saint-Genis-Laval", "Сен-Жени-Лаваль", "FR", "250", "B9", "69", "691", "69204", "45.69558", "4.7934", "Europe/Paris"),
("2980097", "Saint-Fons", "", "FR", "250", "B9", "69", "691", "69199", "45.7088", "4.86057", "Europe/Paris"),
("2980236", "Saint-Etienne-du-Rouvray", "Сент-Этьен-дю-Руврэ", "FR", "250", "A7", "76", "763", "76575", "49.37794", "1.10467", "Europe/Paris"),
("2980291", "Saint-Etienne", "Сент-Этьен", "FR", "250", "B9", "42", "423", "42218", "45.43333", "4.4", "Europe/Paris"),
("2980340", "Saintes", "", "FR", "250", "B7", "17", "174", "17415", "45.75", "-0.63333", "Europe/Paris"),
("2980558", "Sainte-Genevieve-des-Bois", "Сент-Женевьев-де-Буа", "FR", "250", "A8", "91", "913", "91549", "48.64682", "2.31965", "Europe/Paris"),
("2980586", "Sainte-Foy-les-Lyon", "Сент-Фуа-ле-Лион", "FR", "250", "B9", "69", "691", "69202", "45.73692", "4.79688", "Europe/Paris"),
("2980636", "Saint-Egreve", "", "FR", "250", "B9", "38", "381", "38382", "45.23333", "5.68333", "Europe/Paris"),
("2980816", "Saint-Dizier", "Санкт-Дизье", "FR", "250", "A4", "52", "523", "52448", "48.63333", "4.95", "Europe/Paris"),
("2980827", "Saint-Die-des-Vosges", "Сен-Дье-де-Вож", "FR", "250", "B2", "88", "883", "88413", "48.28333", "6.95", "Europe/Paris"),
("2980916", "Saint-Denis", "Сен-Дени", "FR", "250", "A8", "93", "933", "93066", "48.93333", "2.36667", "Europe/Paris"),
("2980935", "Saint-Cyr-sur-Loire", "", "FR", "250", "A3", "37", "372", "37214", "47.4", "0.66667", "Europe/Paris"),
("2980942", "Saint-Cyr-l'Ecole", "Сен-Сир-Леколь", "FR", "250", "A8", "78", "784", "78545", "48.79865", "2.06814", "Europe/Paris"),
("2981041", "Saint-Cloud", "Сен-Клу", "FR", "250", "A8", "92", "923", "92064", "48.84598", "2.20289", "Europe/Paris"),
("2981206", "Saint-Chamond", "Сен-Шамон", "FR", "250", "B9", "42", "423", "42207", "45.47365", "4.52541", "Europe/Paris"),
("2981280", "Saint-Brieuc", "Сент-Брие", "FR", "250", "A2", "22", "224", "22278", "48.51513", "-2.76838", "Europe/Paris"),
("2981492", "Saint-Avold", "", "FR", "250", "B2", "57", "573", "57606", "49.1027", "6.70064", "Europe/Paris"),
("2981512", "Saint-Avertin", "", "FR", "250", "A3", "37", "372", "37208", "47.36357", "0.73993", "Europe/Paris"),
("2981839", "Saint-Amand-les-Eaux", "Сент-Аман-лез-О", "FR", "250", "B4", "59", "596", "59526", "50.44718", "3.43076", "Europe/Paris"),
("2982235", "Rueil-Malmaison", "Рюэй-Мальмезон", "FR", "250", "A8", "92", "922", "92063", "48.8765", "2.18967", "Europe/Paris"),
("2982343", "Royan", "Руайян", "FR", "250", "B7", "17", "172", "17306", "45.62846", "-1.0281", "Europe/Paris"),
("2982652", "Rouen", "Руан", "FR", "250", "A7", "76", "763", "76540", "49.44313", "1.09932", "Europe/Paris"),
("2982681", "Roubaix", "Рубе", "FR", "250", "B4", "59", "595", "59512", "50.69421", "3.17456", "Europe/Paris"),
("2982757", "Rosny-sous-Bois", "Рони-су-Буа", "FR", "250", "A8", "93", "931", "93064", "48.87017", "2.4991", "Europe/Paris"),
("2982944", "Ronchin", "", "FR", "250", "B4", "59", "595", "59507", "50.59883", "3.09056", "Europe/Paris"),
("2982967", "Romorantin-Lanthenay", "Роморантен-Лантене", "FR", "250", "A3", "41", "413", "41194", "47.36667", "1.75", "Europe/Paris"),
("2983011", "Romans-sur-Isere", "Роман-сюр-Изер", "FR", "250", "B9", "26", "263", "26281", "45.04639", "5.0562", "Europe/Paris"),
("2983026", "Romainville", "Роменвиль", "FR", "250", "A8", "93", "931", "93063", "48.8854", "2.43482", "Europe/Paris"),
("2983074", "Roissy-en-Brie", "Руасси-ан-Бри", "FR", "250", "A8", "77", "775", "77390", "48.79159", "2.64747", "Europe/Paris"),
("2983154", "Rodez", "Родез", "FR", "250", "B3", "12", "122", "12202", "44.35258", "2.57338", "Europe/Paris"),
("2983276", "Rochefort", "Рошфор", "FR", "250", "B7", "17", "172", "17299", "45.93333", "-0.98333", "Europe/Paris"),
("2983362", "Roanne", "Роанн", "FR", "250", "B9", "42", "422", "42187", "46.03333", "4.06667", "Europe/Paris"),
("2983440", "Ris-Orangis", "", "FR", "250", "A8", "91", "912", "91521", "48.6511", "2.41406", "Europe/Paris"),
("2983489", "Riom", "Рьом", "FR", "250", "98", "63", "634", "63300", "45.9", "3.11667", "Europe/Paris"),
("2983536", "Rillieux-la-Pape", "Риллиэукс-ла-Пап", "FR", "250", "B9", "69", "691", "69286", "45.81667", "4.9", "Europe/Paris"),
("2983770", "Reze", "Реза", "FR", "250", "B5", "44", "442", "44143", "47.18144", "-1.54965", "Europe/Paris"),
("2983990", "Rennes", "Ренн", "FR", "250", "A2", "35", "353", "35238", "48.11198", "-1.67429", "Europe/Paris"),
("2984114", "Reims", "Реймс", "FR", "250", "A4", "51", "513", "51454", "49.25", "4.03333", "Europe/Paris"),
("2984513", "Rambouillet", "Рамбуйе", "FR", "250", "A8", "78", "782", "78517", "48.65", "1.83333", "Europe/Paris"),
("2984701", "Quimper", "Кемпер", "FR", "250", "A2", "29", "294", "29232", "48", "-4.1", "Europe/Paris"),
("2985034", "Puteaux", "Пюто", "FR", "250", "A8", "92", "922", "92062", "48.88341", "2.23894", "Europe/Paris"),
("2986025", "Port-de-Bouc", "", "FR", "250", "B8", "13", "134", "13077", "43.40657", "4.9809", "Europe/Paris"),
("2986140", "Pontoise", "Понтуаз", "FR", "250", "A8", "95", "953", "95500", "49.05", "2.1", "Europe/Paris"),
("2986160", "Pontivy", "Понтиви", "FR", "250", "A2", "56", "562", "56178", "48.06667", "-2.98333", "Europe/Paris"),
("2986302", "Pontarlier", "Понтарлье", "FR", "250", "A6", "25", "253", "25462", "46.90347", "6.35542", "Europe/Paris"),
("2986306", "Pont-a-Mousson", "Понт-а-Муссон", "FR", "250", "B2", "54", "543", "54431", "48.90786", "6.0589", "Europe/Paris"),
("2986495", "Poitiers", "Пуатье", "FR", "250", "B7", "86", "863", "86194", "46.58333", "0.33333", "Europe/Paris"),
("2986501", "Poissy", "Пуасси", "FR", "250", "A8", "78", "783", "78498", "48.92902", "2.04952", "Europe/Paris"),
("2986732", "Ploemeur", "", "FR", "250", "A2", "56", "561", "56162", "47.73333", "-3.43333", "Europe/Paris"),
("2986930", "Plaisir", "", "FR", "250", "A8", "78", "784", "78490", "48.82319", "1.9541", "Europe/Paris"),
("2986933", "Plaisance-du-Touch", "", "FR", "250", "B3", "31", "313", "31424", "43.56566", "1.29749", "Europe/Paris"),
("2987271", "Pierrefitte-sur-Seine", "", "FR", "250", "A8", "93", "933", "93059", "48.96691", "2.36104", "Europe/Paris"),
("2987805", "Pessac", "Пессаке", "FR", "250", "97", "33", "332", "33318", "44.81011", "-0.64129", "Europe/Paris"),
("2987825", "Pertuis", "", "FR", "250", "B8", "84", "841", "84089", "43.69252", "5.50285", "Europe/Paris"),
("2987914", "Perpignan", "Перпиньян", "FR", "250", "A9", "66", "662", "66136", "42.69764", "2.89541", "Europe/Paris"),
("2987967", "Perigueux", "Периге", "FR", "250", "97", "24", "243", "24322", "45.18333", "0.71667", "Europe/Paris"),
("2988358", "Pau", "Пау", "FR", "250", "97", "64", "643", "64445", "43.3", "-0.36667", "Europe/Paris"),
("2988507", "Paris", "Париж", "FR", "250", "A8", "75", "751", "75056", "48.85341", "2.3488", "Europe/Paris"),
("2988621", "Pantin", "Пантин", "FR", "250", "A8", "93", "931", "93055", "48.89437", "2.40935", "Europe/Paris"),
("2988670", "Pamiers", "Памье", "FR", "250", "B3", "09", "092", "09225", "43.11667", "1.6", "Europe/Paris"),
("2988758", "Palaiseau", "Палезо", "FR", "250", "A8", "91", "913", "91477", "48.71667", "2.25", "Europe/Paris"),
("2988867", "Ozoir-la-Ferriere", "", "FR", "250", "A8", "77", "775", "77350", "48.76699", "2.66871", "Europe/Paris"),
("2988888", "Oyonnax", "Ойонна", "FR", "250", "B9", "01", "014", "01283", "46.25917", "5.65727", "Europe/Paris"),
("2988936", "Outreau", "", "FR", "250", "B4", "62", "623", "62643", "50.70535", "1.5897", "Europe/Paris"),
("2988998", "Oullins", "", "FR", "250", "B9", "69", "691", "69149", "45.71774", "4.80382", "Europe/Paris"),
("2989130", "Osny", "Они", "FR", "250", "A8", "95", "953", "95476", "49.05937", "2.06183", "Europe/Paris"),
("2989170", "Orvault", "Орво", "FR", "250", "B5", "44", "442", "44114", "47.27095", "-1.6219", "Europe/Paris"),
("2989204", "Orsay", "Орсе", "FR", "250", "A8", "91", "913", "91471", "48.69572", "2.18727", "Europe/Paris"),
("2989297", "Orly", "", "FR", "250", "A8", "94", "941", "94054", "48.74792", "2.39252", "Europe/Paris"),
("2989317", "Orleans", "Орлеан", "FR", "250", "A3", "45", "452", "45234", "47.90289", "1.90389", "Europe/Paris"),
("2989460", "Orange", "Оранж", "FR", "250", "B8", "84", "842", "84087", "44.1392", "4.80791", "Europe/Paris"),
("2989611", "Olivet", "Олива", "FR", "250", "A3", "45", "452", "45232", "47.86219", "1.8991", "Europe/Paris"),
("2989755", "Octeville", "", "FR", "250", "99", "50", "502", "50129", "49.62612", "-1.64349", "Europe/Paris"),
("2989877", "Noyon", "Нуайон", "FR", "250", "B6", "60", "603", "60471", "49.58333", "3", "Europe/Paris"),
("2990187", "Noisy-le-Sec", "Шумная-ле-Сек", "FR", "250", "A8", "93", "931", "93053", "48.89148", "2.46451", "Europe/Paris"),
("2990189", "Noisy-le-Grand", "Шумная-ле-Гран", "FR", "250", "A8", "93", "932", "93051", "48.84979", "2.56266", "Europe/Paris"),
("2990192", "Noisiel", "", "FR", "250", "A8", "77", "775", "77337", "48.84868", "2.62435", "Europe/Paris"),
("2990264", "Nogent-sur-Oise", "Ножан-сюр-Уаз", "FR", "250", "B6", "60", "604", "60463", "49.27158", "2.47074", "Europe/Paris"),
("2990265", "Nogent-sur-Marne", "Ножан-сюр-Марн", "FR", "250", "A8", "94", "942", "94052", "48.83333", "2.48333", "Europe/Paris"),
("2990355", "Niort", "Ньор", "FR", "250", "B7", "79", "792", "79191", "46.32313", "-0.45877", "Europe/Paris"),
("2990363", "Nimes", "Ним", "FR", "250", "A9", "30", "302", "30189", "43.83333", "4.35", "Europe/Paris"),
("2990440", "Nice", "Ницца", "FR", "250", "B8", "06", "062", "06088", "43.70313", "7.26608", "Europe/Paris"),
("2990474", "Nevers", "Невер", "FR", "250", "A1", "58", "583", "58194", "46.98956", "3.159", "Europe/Paris"),
("2990611", "Neuilly-sur-Seine", "Нёйи-сюр-Сен", "FR", "250", "A8", "92", "922", "92051", "48.8846", "2.26965", "Europe/Paris"),
("2990612", "Neuilly-sur-Marne", "Нейи-сюр-Марн", "FR", "250", "A8", "93", "932", "93050", "48.85373", "2.54903", "Europe/Paris"),
("2990616", "Neuilly-Plaisance", "", "FR", "250", "A8", "93", "932", "93049", "48.86342", "2.506", "Europe/Paris"),
("2990919", "Narbonne", "Нарбонна", "FR", "250", "A9", "11", "113", "11262", "43.18333", "3", "Europe/Paris"),
("2990969", "Nantes", "Нант", "FR", "250", "B5", "44", "442", "44109", "47.21725", "-1.55336", "Europe/Paris"),
("2990970", "Nanterre", "Нантер", "FR", "250", "A8", "92", "922", "92050", "48.89198", "2.20675", "Europe/Paris"),
("2990999", "Nancy", "Нанси", "FR", "250", "B2", "54", "543", "54395", "48.68439", "6.18496", "Europe/Paris"),
("2991153", "Muret", "Мюре", "FR", "250", "B3", "31", "311", "31395", "43.46667", "1.35", "Europe/Paris"),
("2991214", "Mulhouse", "Мюлуз", "FR", "250", "C1", "68", "684", "68224", "47.75", "7.33333", "Europe/Paris"),
("2991481", "Moulins", "Мулин", "FR", "250", "98", "03", "032", "03190", "46.56667", "3.33333", "Europe/Paris"),
("2991551", "Mougins", "Мужен", "FR", "250", "B8", "06", "061", "06085", "43.59873", "7.00434", "Europe/Paris"),
("2991719", "Morsang-sur-Orge", "", "FR", "250", "A8", "91", "912", "91434", "48.6618", "2.35338", "Europe/Paris"),
("2991772", "Morlaix", "Морле", "FR", "250", "A2", "29", "293", "29151", "48.58333", "-3.83333", "Europe/Paris"),
("2992003", "Mont-Saint-Aignan", "", "FR", "250", "A7", "76", "763", "76451", "49.46307", "1.09364", "Europe/Paris"),
("2992017", "Montrouge", "Монруж", "FR", "250", "A8", "92", "921", "92049", "48.8162", "2.31394", "Europe/Paris"),
("2992090", "Montreuil", "Монтрей", "FR", "250", "A8", "93", "931", "93048", "48.86415", "2.44322", "Europe/Paris"),
("2992166", "Montpellier", "Монпелье", "FR", "250", "A9", "34", "343", "34172", "43.61092", "3.87723", "Europe/Paris"),
("2992229", "Montmorency", "Монморанси", "FR", "250", "A8", "95", "952", "95428", "48.98826", "2.3434", "Europe/Paris"),
("2992292", "Montlucon", "Монлюсон", "FR", "250", "98", "03", "031", "03185", "46.33333", "2.6", "Europe/Paris"),
("2992367", "Montivilliers", "", "FR", "250", "A7", "76", "762", "76447", "49.54518", "0.18769", "Europe/Paris"),
("2992402", "Montigny-les-Metz", "", "FR", "250", "B2", "57", "574", "57480", "49.09435", "6.15167", "Europe/Paris"),
("2992404", "Montigny-les-Cormeilles", "", "FR", "250", "A8", "95", "951", "95424", "48.98202", "2.20035", "Europe/Paris"),
("2992415", "Montigny-le-Bretonneux", "Монтиньи-ле-Бретоннё", "FR", "250", "A8", "78", "784", "78423", "48.76636", "2.03405", "Europe/Paris"),
("2992536", "Montgeron", "Монжероне", "FR", "250", "A8", "91", "912", "91421", "48.70543", "2.45039", "Europe/Paris"),
("2992616", "Montfermeil", "Монфермей", "FR", "250", "A8", "93", "932", "93047", "48.8982", "2.57913", "Europe/Paris"),
("2992650", "Montesson", "", "FR", "250", "A8", "78", "783", "78418", "48.90924", "2.13754", "Europe/Paris"),
("2992671", "Montereau-Fault-Yonne", "Монтро-Фо-Йонна", "FR", "250", "A8", "77", "773", "77305", "48.38333", "2.95", "Europe/Paris"),
("2992703", "Montelimar", "Монтелимаре", "FR", "250", "B9", "26", "262", "26198", "44.55838", "4.75094", "Europe/Paris"),
("2992771", "Mont-de-Marsan", "Мон-де-Марсан", "FR", "250", "97", "40", "402", "40192", "43.89022", "-0.49713", "Europe/Paris"),
("2992863", "Montceau-les-Mines", "Монке-ле-Мине", "FR", "250", "A1", "71", "712", "71306", "46.66667", "4.36667", "Europe/Paris"),
("2992890", "Montbrison", "", "FR", "250", "B9", "42", "421", "42147", "45.6", "4.05", "Europe/Paris"),
("2992938", "Montbeliard", "Монбельяр", "FR", "250", "A6", "25", "252", "25388", "47.51667", "6.8", "Europe/Paris"),
("2993002", "Montauban", "Монтобан", "FR", "250", "B3", "82", "822", "82121", "44.01667", "1.35", "Europe/Paris"),
("2993024", "Montargis", "Монтаржи", "FR", "250", "A3", "45", "451", "45208", "48", "2.75", "Europe/Paris"),
("2993207", "Mons-en-Baroeul", "", "FR", "250", "B4", "59", "595", "59410", "50.63333", "3.11667", "Europe/Paris"),
("2993572", "Moissy-Cramayel", "", "FR", "250", "A8", "77", "772", "77296", "48.62605", "2.60125", "Europe/Paris"),
("2993679", "Mitry-Mory", "", "FR", "250", "A8", "77", "771", "77294", "48.98333", "2.61667", "Europe/Paris"),
("2993760", "Miramas", "Мирама", "FR", "250", "B8", "13", "134", "13063", "43.58666", "5.00464", "Europe/Paris"),
("2993875", "Millau", "Мийо", "FR", "250", "B3", "12", "121", "12145", "44.1", "3.08333", "Europe/Paris"),
("2994048", "Meyzieu", "", "FR", "250", "B9", "69", "691", "69282", "45.76667", "5", "Europe/Paris"),
("2994087", "Meylan", "Мелан", "FR", "250", "B9", "38", "381", "38229", "45.21988", "5.79007", "Europe/Paris"),
("2994144", "Meudon", "Мёдон", "FR", "250", "A8", "92", "923", "92048", "48.81381", "2.235", "Europe/Paris"),
("2994160", "Metz", "Мец", "FR", "250", "B2", "57", "579", "57463", "49.11911", "6.17269", "Europe/Paris"),
("2994393", "Merignac", "", "FR", "250", "97", "33", "332", "33281", "44.83248", "-0.63381", "Europe/Paris"),
("2994497", "Menton", "Ментона", "FR", "250", "B8", "06", "062", "06083", "43.77649", "7.50435", "Europe/Paris"),
("2994651", "Melun", "Мелён", "FR", "250", "A8", "77", "772", "77288", "48.53333", "2.66667", "Europe/Paris"),
("2994798", "Meaux", "Мо", "FR", "250", "A8", "77", "771", "77284", "48.96014", "2.87885", "Europe/Paris"),
("2994935", "Mayenne", "", "FR", "250", "B5", "53", "533", "53147", "48.3", "-0.61667", "Europe/Paris"),
("2995041", "Maurepas", "", "FR", "250", "A8", "78", "782", "78383", "48.76486", "1.92923", "Europe/Paris"),
("2995121", "Mauguio", "", "FR", "250", "A9", "34", "343", "34154", "43.6181", "4.00739", "Europe/Paris"),
("2995150", "Maubeuge", "Мобёж", "FR", "250", "B4", "59", "591", "59392", "50.27875", "3.97267", "Europe/Paris"),
("2995206", "Massy", "Масси", "FR", "250", "A8", "91", "913", "91377", "48.72692", "2.28301", "Europe/Paris"),
("2995387", "Martigues", "Мартиг", "FR", "250", "B8", "13", "134", "13056", "43.40735", "5.05526", "Europe/Paris"),
("2995469", "Marseille", "Марсель", "FR", "250", "B8", "13", "133", "13055", "43.29695", "5.38107", "Europe/Paris"),
("2995642", "Marmande", "Марманд", "FR", "250", "97", "47", "472", "47157", "44.5", "0.16667", "Europe/Paris"),
("2995652", "Marly-le-Roi", "Марли-ле-Руа", "FR", "250", "A8", "78", "783", "78372", "48.86667", "2.08333", "Europe/Paris"),
("2995750", "Marignane", "Мариньян", "FR", "250", "B8", "13", "134", "13054", "43.41604", "5.21453", "Europe/Paris"),
("2995908", "Marcq-en-Baroeul", "Марк-ан-Барёль", "FR", "250", "B4", "59", "595", "59378", "50.66667", "3.08333", "Europe/Paris"),
("2996146", "Mantes-la-Ville", "", "FR", "250", "A8", "78", "781", "78362", "48.97374", "1.70253", "Europe/Paris"),
("2996148", "Mantes-la-Jolie", "Мант-ля-Жоли", "FR", "250", "A8", "78", "781", "78361", "48.98333", "1.71667", "Europe/Paris"),
("2996180", "Manosque", "Маноске", "FR", "250", "B8", "04", "044", "04112", "43.82883", "5.78688", "Europe/Paris"),
("2996255", "Mandelieu-la-Napoule", "", "FR", "250", "B8", "06", "061", "06079", "43.55", "6.93333", "Europe/Paris"),
("2996514", "Malakoff", "", "FR", "250", "A8", "92", "921", "92046", "48.81999", "2.29998", "Europe/Paris"),
("2996564", "Maisons-Laffitte", "Мезон-Лафит", "FR", "250", "A8", "78", "783", "78358", "48.95264", "2.14521", "Europe/Paris"),
("2996568", "Maisons-Alfort", "Мезон-Альфор", "FR", "250", "A8", "94", "941", "94046", "48.81171", "2.43945", "Europe/Paris"),
("2996882", "Macon", "Макон", "FR", "250", "A1", "71", "715", "71270", "46.3", "4.83333", "Europe/Paris"),
("2996944", "Lyon", "Лион", "FR", "250", "B9", "69", "691", "69123", "45.74846", "4.84671", "Europe/Paris"),
("2997110", "Luneville", "Люневиль", "FR", "250", "B2", "54", "542", "54329", "48.6", "6.5", "Europe/Paris"),
("2997116", "Lunel", "Люнель", "FR", "250", "A9", "34", "343", "34145", "43.67778", "4.13611", "Europe/Paris"),
("2997246", "Luce", "", "FR", "250", "A3", "28", "281", "28218", "48.4369", "1.46359", "Europe/Paris"),
("2997336", "Louviers", "", "FR", "250", "A7", "27", "271", "27375", "49.21667", "1.16667", "Europe/Paris"),
("2997395", "Lourdes", "Лурд", "FR", "250", "B3", "65", "651", "65286", "43.1", "-0.05", "Europe/Paris"),
("2997556", "Lormont", "Лормон", "FR", "250", "97", "33", "332", "33249", "44.87495", "-0.51782", "Europe/Paris"),
("2997577", "Lorient", "Лорьян", "FR", "250", "A2", "56", "561", "56121", "47.75", "-3.36667", "Europe/Paris"),
("2997620", "Loos", "", "FR", "250", "B4", "59", "595", "59360", "50.60982", "3.01874", "Europe/Paris"),
("2997626", "Lons-le-Saunier", "Лон-ле-Сонье", "FR", "250", "A6", "39", "392", "39300", "46.66667", "5.55", "Europe/Paris"),
("2997712", "Longjumeau", "Лонжюмо", "FR", "250", "A8", "91", "913", "91345", "48.69503", "2.30736", "Europe/Paris"),
("2997803", "Lomme", "Ломм", "FR", "250", "B4", "59", "595", "59350", "50.64358", "2.98715", "Europe/Paris"),
("2997904", "Lognes", "", "FR", "250", "A8", "77", "775", "77258", "48.83541", "2.62998", "Europe/Paris"),
("2998056", "Livry-Gargan", "", "FR", "250", "A8", "93", "932", "93046", "48.9193", "2.54305", "Europe/Paris"),
("2998127", "L'Isle-sur-la-Sorgue", "Л'Иль-сюр-ла-Сорг", "FR", "250", "B8", "84", "842", "84054", "43.91915", "5.05092", "Europe/Paris"),
("2998150", "Lisieux", "Лизьё", "FR", "250", "99", "14", "143", "14366", "49.1466", "0.22925", "Europe/Paris"),
("2998224", "Lingolsheim", "", "FR", "250", "C1", "67", "676", "67267", "48.55752", "7.68253", "Europe/Paris"),
("2998286", "Limoges", "Лимож", "FR", "250", "B1", "87", "872", "87085", "45.83153", "1.2578", "Europe/Paris"),
("2998305", "Limeil-Brevannes", "", "FR", "250", "A8", "94", "941", "94044", "48.7448", "2.48705", "Europe/Paris"),
("2998311", "Limay", "", "FR", "250", "A8", "78", "781", "78335", "48.99553", "1.74081", "Europe/Paris"),
("2998324", "Lille", "Лилль", "FR", "250", "B4", "59", "595", "59350", "50.63297", "3.05858", "Europe/Paris"),
("2998431", "Lievin", "Лиевен", "FR", "250", "B4", "62", "627", "62510", "50.4198", "2.78068", "Europe/Paris"),
("2998517", "Libourne", "Либурн", "FR", "250", "97", "33", "335", "33243", "44.91667", "-0.23333", "Europe/Paris"),
("2998632", "L'Hay-les-Roses", "", "FR", "250", "A8", "94", "943", "94038", "48.78333", "2.33333", "Europe/Paris"),
("2998854", "Le Vesinet", "Ле-Везине", "FR", "250", "A8", "78", "783", "78650", "48.89281", "2.13308", "Europe/Paris"),
("2998975", "Levallois-Perret", "Леваллуа-Перре", "FR", "250", "A8", "92", "922", "92044", "48.89389", "2.28864", "Europe/Paris"),
("2999683", "Les Sables-d'Olonne", "Ле-Сабль-д’Олон", "FR", "250", "B5", "85", "853", "85194", "46.5", "-1.78333", "Europe/Paris"),
("3000047", "Les Pennes-Mirabeau", "", "FR", "250", "B8", "13", "131", "13071", "43.41028", "5.31306", "Europe/Paris"),
("3000060", "Les Pavillons-sous-Bois", "", "FR", "250", "A8", "93", "931", "93057", "48.90683", "2.50648", "Europe/Paris"),
("3000192", "Les Mureaux", "", "FR", "250", "A8", "78", "781", "78440", "48.99173", "1.90972", "Europe/Paris"),
("3000491", "Les Lilas", "", "FR", "250", "A8", "93", "931", "93045", "48.87992", "2.42057", "Europe/Paris"),
("3000648", "Les Herbiers", "", "FR", "250", "B5", "85", "852", "85109", "46.86667", "-1.01667", "Europe/Paris"),
("3001402", "Les Clayes-sous-Bois", "", "FR", "250", "A8", "78", "784", "78165", "48.82206", "1.98677", "Europe/Paris"),
("3002465", "Le Puy-en-Velay", "Пюи-ан-Веле", "FR", "250", "98", "43", "432", "43157", "45.04366", "3.88523", "Europe/Paris"),
("3002499", "Le Pre-Saint-Gervais", "", "FR", "250", "A8", "93", "931", "93061", "48.88549", "2.40422", "Europe/Paris"),
("3002570", "Le Pontet", "", "FR", "250", "B8", "84", "842", "84092", "43.96119", "4.86008", "Europe/Paris"),
("3002647", "Le Plessis-Trevise", "", "FR", "250", "A8", "94", "942", "94059", "48.81074", "2.57363", "Europe/Paris"),
("3002650", "Le Plessis-Robinson", "Ле-Плесси-Робинсон", "FR", "250", "A8", "92", "921", "92060", "48.78889", "2.27078", "Europe/Paris"),
("3002880", "Le Petit-Quevilly", "", "FR", "250", "A7", "76", "763", "76498", "49.41338", "1.06155", "Europe/Paris"),
("3002965", "Le Perreux-sur-Marne", "", "FR", "250", "A8", "94", "942", "94058", "48.85", "2.5", "Europe/Paris"),
("3002984", "Le Pecq", "", "FR", "250", "A8", "78", "783", "78481", "48.89317", "2.10371", "Europe/Paris"),
("3003093", "Lens", "", "FR", "250", "B4", "62", "627", "62498", "50.43302", "2.82791", "Europe/Paris"),
("3003481", "Le Mee-sur-Seine", "", "FR", "250", "A8", "77", "772", "77285", "48.53157", "2.62829", "Europe/Paris"),
("3003603", "Le Mans", "Ле-Ман", "FR", "250", "B5", "72", "723", "72181", "48", "0.2", "Europe/Paris"),
("3003737", "Le Kremlin-Bicetre", "Ле-Кремлен-Бисетр", "FR", "250", "A8", "94", "943", "94043", "48.81471", "2.36073", "Europe/Paris"),
("3003796", "Le Havre", "Гавр", "FR", "250", "A7", "76", "762", "76351", "49.4938", "0.10767", "Europe/Paris"),
("3003952", "Le Grand-Quevilly", "Гран-Кевилли", "FR", "250", "A7", "76", "763", "76322", "49.40076", "1.04582", "Europe/Paris"),
("3004427", "Le Creusot", "Ле-Крёзо", "FR", "250", "A1", "71", "711", "71153", "46.80714", "4.41632", "Europe/Paris"),
("3004630", "Le Chesnay", "Ле-Шене", "FR", "250", "A8", "78", "784", "78158", "48.8222", "2.12213", "Europe/Paris"),
("3004871", "Le Cannet", "Ле-Канне", "FR", "250", "B8", "06", "061", "06030", "43.57662", "7.01912", "Europe/Paris"),
("3005066", "Le Bouscat", "Ле-Буска", "FR", "250", "97", "33", "332", "33069", "44.866", "-0.59411", "Europe/Paris"),
("3005269", "Le Blanc-Mesnil", "Ле-Блан-Мениль", "FR", "250", "A8", "93", "932", "93007", "48.93872", "2.46138", "Europe/Paris"),
("3005417", "Laxou", "Лаксу", "FR", "250", "B2", "54", "543", "54304", "48.68315", "6.148", "Europe/Paris"),
("3005825", "La Valette-du-Var", "", "FR", "250", "B8", "83", "832", "83144", "43.13741", "5.98314", "Europe/Paris"),
("3005866", "Laval", "Лаваль", "FR", "250", "B5", "53", "532", "53130", "48.06667", "-0.76667", "Europe/Paris"),
("3006121", "Lattes", "", "FR", "250", "A9", "34", "343", "34129", "43.56752", "3.9046", "Europe/Paris"),
("3006283", "La Teste-de-Buch", "Ла-Тест-де-Буха", "FR", "250", "97", "33", "336", "33529", "44.62875", "-1.14059", "Europe/Paris"),
("3006414", "La Seyne-sur-Mer", "Ла-Сейн-сюр-Мер", "FR", "250", "B8", "83", "832", "83126", "43.09818", "5.88472", "Europe/Paris"),
("3006767", "La Roche-sur-Yon", "Ла-Рош-сюр-Йон", "FR", "250", "B5", "85", "852", "85191", "46.66667", "-1.43333", "Europe/Paris"),
("3006787", "La Rochelle", "Ла-Рошель", "FR", "250", "B7", "17", "173", "17300", "46.16667", "-1.15", "Europe/Paris"),
("3007477", "Laon", "Лана", "FR", "250", "B6", "02", "022", "02408", "49.56667", "3.61667", "Europe/Paris"),
("3007609", "Lannion", "Ланнион", "FR", "250", "A2", "22", "223", "22113", "48.73333", "-3.46667", "Europe/Paris"),
("3007794", "Lanester", "", "FR", "250", "A2", "56", "561", "56098", "47.76132", "-3.33965", "Europe/Paris"),
("3007874", "Landerneau", "", "FR", "250", "A2", "29", "291", "29103", "48.45252", "-4.25252", "Europe/Paris"),
("3008218", "Lambersart", "Ламберсар", "FR", "250", "B4", "59", "595", "59328", "50.65", "3.03333", "Europe/Paris"),
("3008379", "La Madeleine", "Мадлен", "FR", "250", "B4", "59", "595", "59368", "50.64603", "3.07585", "Europe/Paris"),
("3009071", "Lagny-sur-Marne", "", "FR", "250", "A8", "77", "775", "77243", "48.86667", "2.71667", "Europe/Paris"),
("3009169", "La Garenne-Colombes", "", "FR", "250", "A8", "92", "922", "92035", "48.90472", "2.2469", "Europe/Paris"),
("3009223", "La Garde", "", "FR", "250", "B8", "83", "832", "83062", "43.12277", "6.00745", "Europe/Paris"),
("3009443", "La Fleche", "Ла-Флеш", "FR", "250", "B5", "72", "721", "72154", "47.69815", "-0.07553", "Europe/Paris"),
("3009791", "La Crau", "", "FR", "250", "B8", "83", "832", "83047", "43.14981", "6.07425", "Europe/Paris"),
("3009824", "La Courneuve", "Ла-Курнев", "FR", "250", "A8", "93", "933", "93027", "48.92805", "2.39627", "Europe/Paris"),
("3010025", "La Ciotat", "Ла-Сьота", "FR", "250", "B8", "13", "133", "13028", "43.17476", "5.60449", "Europe/Paris"),
("3010237", "La Chapelle-sur-Erdre", "", "FR", "250", "B5", "44", "442", "44035", "47.29584", "-1.55309", "Europe/Paris"),
("3010529", "La Celle-Saint-Cloud", "", "FR", "250", "A8", "78", "783", "78126", "48.85029", "2.14523", "Europe/Paris"),
("3012162", "Jouy-le-Moutier", "Жуи-ле-Мутье", "FR", "250", "A8", "95", "953", "95323", "49.01068", "2.04028", "Europe/Paris"),
("3012219", "Joue-les-Tours", "Жу-ле-Тур", "FR", "250", "A3", "37", "372", "37122", "47.35223", "0.66906", "Europe/Paris"),
("3012313", "Joinville-le-Pont", "", "FR", "250", "A8", "94", "942", "94042", "48.82538", "2.47458", "Europe/Paris"),
("3012621", "Ivry-sur-Seine", "Иври-сюр-Сен", "FR", "250", "A8", "94", "941", "94041", "48.81568", "2.38487", "Europe/Paris"),
("3012647", "Istres", "Истра", "FR", "250", "B8", "13", "134", "13047", "43.51667", "4.98333", "Europe/Paris"),
("3012649", "Issy-les-Moulineaux", "Исси-ле-Мулино", "FR", "250", "A8", "92", "923", "92040", "48.82104", "2.27718", "Europe/Paris"),
("3012664", "Issoire", "Иссуар", "FR", "250", "98", "63", "633", "63178", "45.55", "3.25", "Europe/Paris"),
("3012829", "Illzach", "", "FR", "250", "C1", "68", "684", "68154", "47.78088", "7.34662", "Europe/Paris"),
("3012834", "Illkirch-Graffenstaden", "Ийкирш-Граффанштадан", "FR", "250", "C1", "67", "676", "67218", "48.52894", "7.71523", "Europe/Paris"),
("3012937", "Hyeres", "Иер", "FR", "250", "B8", "83", "832", "83069", "43.11954", "6.13897", "Europe/Paris"),
("3013097", "Houilles", "", "FR", "250", "A8", "78", "783", "78311", "48.92161", "2.19263", "Europe/Paris"),
("3013403", "Herouville-Saint-Clair", "Эрувиль-Сен-Клер", "FR", "250", "99", "14", "142", "14327", "49.21088", "-0.30653", "Europe/Paris"),
("3013477", "Herblay", "Эрбле", "FR", "250", "A8", "95", "951", "95306", "48.98994", "2.1699", "Europe/Paris"),
("3013525", "Henin-Beaumont", "Энен-Бомон", "FR", "250", "B4", "62", "627", "62427", "50.41359", "2.96485", "Europe/Paris"),
("3013549", "Hem", "", "FR", "250", "B4", "59", "595", "59299", "50.65256", "3.18681", "Europe/Paris"),
("3013619", "Hazebrouck", "Азбрук", "FR", "250", "B4", "59", "594", "59295", "50.72374", "2.53729", "Europe/Paris"),
("3013627", "Hayange", "", "FR", "250", "B2", "57", "578", "57306", "49.33428", "6.05268", "Europe/Paris"),
("3013681", "Hautmont", "Отмон", "FR", "250", "B4", "59", "591", "59291", "50.25077", "3.92143", "Europe/Paris"),
("3013701", "Yutz", "", "FR", "250", "B2", "57", "577", "57757", "49.35571", "6.1926", "Europe/Paris"),
("3013862", "Haubourdin", "Обурден", "FR", "250", "B4", "59", "595", "59286", "50.60826", "2.99143", "Europe/Paris"),
("3014034", "Halluin", "Аллюэн", "FR", "250", "B4", "59", "595", "59279", "50.78628", "3.12611", "Europe/Paris"),
("3014078", "Haguenau", "Агно", "FR", "250", "C1", "67", "672", "67180", "48.81557", "7.79051", "Europe/Paris"),
("3014143", "Guyancourt", "Гвианкур", "FR", "250", "A8", "78", "784", "78297", "48.77334", "2.07393", "Europe/Paris"),
("3014175", "Gujan-Mestras", "", "FR", "250", "97", "33", "336", "33199", "44.63333", "-1.06667", "Europe/Paris"),
("3014383", "Gueret", "Гере", "FR", "250", "B1", "23", "232", "23096", "46.16667", "1.86667", "Europe/Paris"),
("3014392", "Guerande", "", "FR", "250", "B5", "44", "443", "44069", "47.32911", "-2.42829", "Europe/Paris"),
("3014646", "Grigny", "", "FR", "250", "A8", "91", "912", "91286", "48.65412", "2.39343", "Europe/Paris"),
("3014728", "Grenoble", "Грeнобль", "FR", "250", "B9", "38", "381", "38185", "45.16667", "5.71667", "Europe/Paris"),
("3014856", "Grasse", "Грас", "FR", "250", "B8", "06", "061", "06069", "43.66667", "6.91667", "Europe/Paris"),
("3015160", "Grande-Synthe", "Гранд-Сент", "FR", "250", "B4", "59", "594", "59271", "51.0154", "2.29975", "Europe/Paris"),
("3015419", "Gradignan", "Градиньян", "FR", "250", "97", "33", "332", "33192", "44.77262", "-0.61393", "Europe/Paris"),
("3015490", "Goussainville", "", "FR", "250", "A8", "95", "952", "95280", "49.01367", "2.46595", "Europe/Paris"),
("3015689", "Gonesse", "Гонесс", "FR", "250", "A8", "95", "952", "95277", "48.98693", "2.44892", "Europe/Paris"),
("3015902", "Givors", "Живор", "FR", "250", "B9", "69", "691", "69091", "45.58415", "4.77256", "Europe/Paris"),
("3016078", "Gif-sur-Yvette", "Жиф-сюр-Иветт", "FR", "250", "A8", "91", "913", "91272", "48.68333", "2.13333", "Europe/Paris"),
("3016097", "Gien", "", "FR", "250", "A3", "45", "451", "45155", "47.69332", "2.63094", "Europe/Paris"),
("3016292", "Gentilly", "", "FR", "250", "A8", "94", "943", "94037", "48.81294", "2.3417", "Europe/Paris"),
("3016321", "Gennevilliers", "Женвилье", "FR", "250", "A8", "92", "922", "92036", "48.93333", "2.3", "Europe/Paris"),
("3016621", "Garges-les-Gonesse", "Гарж-ле-Гонесс", "FR", "250", "A8", "95", "952", "95268", "48.96791", "2.39781", "Europe/Paris"),
("3016667", "Gardanne", "", "FR", "250", "B8", "13", "131", "13041", "43.45491", "5.46913", "Europe/Paris"),
("3016675", "Garches", "Гарш", "FR", "250", "A8", "92", "922", "92033", "48.84226", "2.18232", "Europe/Paris"),
("3016702", "Gap", "", "FR", "250", "B8", "05", "052", "05061", "44.56667", "6.08333", "Europe/Paris"),
("3016830", "Gagny", "", "FR", "250", "A8", "93", "932", "93032", "48.88333", "2.53333", "Europe/Paris"),
("3016956", "Frontignan", "Фронтиньян", "FR", "250", "A9", "34", "343", "34108", "43.44848", "3.754", "Europe/Paris"),
("3017178", "Fresnes", "Френ", "FR", "250", "A8", "94", "943", "94034", "48.75568", "2.32241", "Europe/Paris"),
("3017253", "Frejus", "Фрежюс", "FR", "250", "B8", "83", "831", "83061", "43.43286", "6.73524", "Europe/Paris"),
("3017341", "Franconville", "", "FR", "250", "A8", "95", "953", "95252", "48.98333", "2.23333", "Europe/Paris"),
("3017609", "Fougeres", "Фужер", "FR", "250", "A2", "35", "351", "35115", "48.35", "-1.2", "Europe/Paris"),
("3017651", "Fos-sur-Mer", "", "FR", "250", "B8", "13", "134", "13039", "43.43774", "4.94457", "Europe/Paris"),
("3017805", "Forbach", "Форбах", "FR", "250", "B2", "57", "573", "57227", "49.18333", "6.9", "Europe/Paris"),
("3017910", "Fontenay-sous-Bois", "Фонтене-су-Буа", "FR", "250", "A8", "94", "942", "94033", "48.85442", "2.48268", "Europe/Paris"),
("3017921", "Fontenay-le-Comte", "Фонтене-ле-Конт", "FR", "250", "B5", "85", "851", "85092", "46.46667", "-0.81667", "Europe/Paris"),
("3017924", "Fontenay-aux-Roses", "Фонтене-о-Роз", "FR", "250", "A8", "92", "921", "92032", "48.79325", "2.29275", "Europe/Paris"),
("3018074", "Fontainebleau", "Фонтенбло", "FR", "250", "A8", "77", "774", "77186", "48.4", "2.7", "Europe/Paris"),
("3018095", "Fontaine", "Фонтейн", "FR", "250", "B9", "38", "381", "38169", "45.19839", "5.68265", "Europe/Paris"),
("3018246", "Floirac", "", "FR", "250", "97", "33", "332", "33167", "44.83238", "-0.51411", "Europe/Paris"),
("3018280", "Fleury-les-Aubrais", "", "FR", "250", "A3", "45", "452", "45147", "47.93328", "1.91811", "Europe/Paris"),
("3018339", "Flers", "", "FR", "250", "99", "61", "612", "61169", "48.73722", "-0.57466", "Europe/Paris"),
("3018455", "Firminy", "", "FR", "250", "B9", "42", "423", "42095", "45.38732", "4.29074", "Europe/Paris"),
("3018794", "Fecamp", "Фекан", "FR", "250", "A7", "76", "762", "76259", "49.75787", "0.37457", "Europe/Paris"),
("3019153", "Faches-Thumesnil", "", "FR", "250", "B4", "59", "595", "59220", "50.58333", "3.06667", "Europe/Paris"),
("3019193", "Eysines", "", "FR", "250", "97", "33", "332", "33162", "44.88352", "-0.64686", "Europe/Paris"),
("3019256", "Evry", "", "FR", "250", "A8", "91", "912", "91228", "48.63333", "2.45", "Europe/Paris"),
("3019265", "Evreux", "Эврё", "FR", "250", "A7", "27", "273", "27229", "49.02414", "1.15082", "Europe/Paris"),
("3019459", "Etampes", "Этамп", "FR", "250", "A8", "91", "911", "91223", "48.43333", "2.15", "Europe/Paris"),
("3019766", "La Baule-Escoublac", "Ла-Боль", "FR", "250", "B5", "44", "443", "44055", "47.29221", "-2.36395", "Europe/Paris"),
("3019897", "Ermont", "Эрмон", "FR", "250", "A8", "95", "953", "95219", "48.99004", "2.25804", "Europe/Paris"),
("3019952", "Eragny", "", "FR", "250", "A8", "95", "953", "95218", "49.01667", "2.1", "Europe/Paris"),
("3019960", "Equeurdreville-Hainneville", "", "FR", "250", "99", "50", "502", "50173", "49.64868", "-1.65306", "Europe/Paris"),
("3020020", "Epinay-sur-Seine", "Эпине-сюр-Сен", "FR", "250", "A8", "93", "933", "93031", "48.9535", "2.31514", "Europe/Paris"),
("3020035", "Epinal", "Эпиналь", "FR", "250", "B2", "88", "881", "88160", "48.18333", "6.45", "Europe/Paris"),
("3020062", "Epernay", "Эперне", "FR", "250", "A4", "51", "512", "51230", "49.05", "3.95", "Europe/Paris"),
("3020307", "Elbeuf", "Эльбёф", "FR", "250", "A7", "76", "763", "76231", "49.28669", "1.00288", "Europe/Paris"),
("3020310", "Elancourt", "", "FR", "250", "A8", "78", "782", "78208", "48.7842", "1.9552", "Europe/Paris"),
("3020392", "Ecully", "", "FR", "250", "B9", "69", "691", "69081", "45.77726", "4.77481", "Europe/Paris"),
("3020495", "Echirolles", "Эшироль", "FR", "250", "B9", "38", "381", "38151", "45.1439", "5.72883", "Europe/Paris"),
("3020601", "Eaubonne", "Обонн", "FR", "250", "A8", "95", "953", "95203", "48.99712", "2.28249", "Europe/Paris"),
("3020686", "Dunkerque", "Дюнкерк", "FR", "250", "B4", "59", "594", "59183", "51.03297", "2.377", "Europe/Paris"),
("3020810", "Dreux", "Дрё", "FR", "250", "A3", "28", "283", "28134", "48.73333", "1.36667", "Europe/Paris"),
("3020832", "Draveil", "", "FR", "250", "A8", "91", "912", "91201", "48.68466", "2.41418", "Europe/Paris"),
("3020839", "Drancy", "Дранси", "FR", "250", "A8", "93", "931", "93029", "48.92578", "2.44533", "Europe/Paris"),
("3020850", "Draguignan", "Драгиньян", "FR", "250", "B8", "83", "831", "83050", "43.53333", "6.46667", "Europe/Paris"),
("3020996", "Douarnenez", "Дуарнене", "FR", "250", "A2", "29", "294", "29046", "48.09542", "-4.32904", "Europe/Paris"),
("3021000", "Douai", "Дуэ", "FR", "250", "B4", "59", "593", "59178", "50.36667", "3.06667", "Europe/Paris"),
("3021150", "Domont", "Домон", "FR", "250", "A8", "95", "952", "95199", "49.02782", "2.32638", "Europe/Paris"),
("3021263", "Dole", "Доля", "FR", "250", "A6", "39", "391", "39198", "47.1", "5.5", "Europe/Paris"),
("3021372", "Dijon", "Дижон", "FR", "250", "A1", "21", "212", "21231", "47.31667", "5.01667", "Europe/Paris"),
("3021382", "Digne-les-Bains", "Динь-ле-Бен", "FR", "250", "B8", "04", "043", "04070", "44.09252", "6.23199", "Europe/Paris"),
("3021411", "Dieppe", "Дьеп", "FR", "250", "A7", "76", "761", "76217", "49.93333", "1.08333", "Europe/Paris"),
("3021516", "Deuil-la-Barre", "Дёй-ла-Барр", "FR", "250", "A8", "95", "952", "95197", "48.97674", "2.32722", "Europe/Paris"),
("3021605", "Denain", "Денен", "FR", "250", "B4", "59", "596", "59172", "50.3293", "3.3943", "Europe/Paris"),
("3021662", "Decines-Charpieu", "", "FR", "250", "B9", "69", "691", "69275", "45.76899", "4.97277", "Europe/Paris"),
("3021670", "Dax", "", "FR", "250", "97", "40", "401", "40088", "43.71032", "-1.05366", "Europe/Paris"),
("3021852", "Dammarie-les-Lys", "", "FR", "250", "A8", "77", "772", "77152", "48.51667", "2.65", "Europe/Paris"),
("3022151", "Cugnaux", "", "FR", "250", "B3", "31", "313", "31157", "43.53635", "1.34428", "Europe/Paris"),
("3022376", "Croix", "", "FR", "250", "B4", "59", "595", "59163", "50.67846", "3.1493", "Europe/Paris"),
("3022530", "Creteil", "Кретей", "FR", "250", "A8", "94", "941", "94028", "48.78333", "2.46667", "Europe/Paris"),
("3022569", "Crepy-en-Valois", "Крепи-ан-Валуа", "FR", "250", "B6", "60", "604", "60176", "49.23359", "2.88807", "Europe/Paris"),
("3022610", "Creil", "Крей", "FR", "250", "B6", "60", "604", "60175", "49.25672", "2.48477", "Europe/Paris"),
("3022700", "Cran-Gevrier", "", "FR", "250", "B9", "74", "741", "74093", "45.9", "6.1", "Europe/Paris"),
("3022988", "Cournon-d'Auvergne", "", "FR", "250", "98", "63", "632", "63124", "45.73543", "3.19608", "Europe/Paris"),
("3023141", "Courbevoie", "Курбевуа", "FR", "250", "A8", "92", "922", "92026", "48.89672", "2.25666", "Europe/Paris"),
("3023240", "Coulommiers", "", "FR", "250", "A8", "77", "771", "77131", "48.81451", "3.08498", "Europe/Paris"),
("3023324", "Coueron", "", "FR", "250", "B5", "44", "442", "44047", "47.21508", "-1.72171", "Europe/Paris"),
("3023356", "Coudekerque-Branche", "Кудкерк-Бранш", "FR", "250", "B4", "59", "594", "59155", "51.02288", "2.39359", "Europe/Paris"),
("3023645", "Cormeilles-en-Parisis", "Кормей-ан-Паризи", "FR", "250", "A8", "95", "951", "95176", "48.97111", "2.20491", "Europe/Paris"),
("3023763", "Corbeil-Essonnes", "Корбей-Эссон", "FR", "250", "A8", "91", "912", "91174", "48.60603", "2.48757", "Europe/Paris"),
("3023924", "Conflans-Sainte-Honorine", "Конфлан-Сент-Онорин", "FR", "250", "A8", "78", "783", "78172", "49.00158", "2.09694", "Europe/Paris"),
("3024035", "Concarneau", "Конкарно", "FR", "250", "A2", "29", "294", "29039", "47.87502", "-3.92245", "Europe/Paris"),
("3024066", "Compiegne", "Компьень", "FR", "250", "B6", "60", "603", "60159", "49.41794", "2.82606", "Europe/Paris"),
("3024107", "Combs-la-Ville", "", "FR", "250", "A8", "77", "772", "77122", "48.66497", "2.56957", "Europe/Paris"),
("3024195", "Pontault-Combault", "", "FR", "250", "A8", "77", "775", "77373", "48.79813", "2.60676", "Europe/Paris"),
("3024223", "Colomiers", "", "FR", "250", "B3", "31", "313", "31149", "43.61247", "1.33278", "Europe/Paris"),
("3024266", "Colombes", "Коломб", "FR", "250", "A8", "92", "922", "92025", "48.91882", "2.25404", "Europe/Paris"),
("3024297", "Colmar", "Кольмар", "FR", "250", "C1", "68", "682", "68066", "48.08333", "7.36667", "Europe/Paris"),
("3024440", "Cognac", "Коньяк", "FR", "250", "B7", "16", "162", "16102", "45.7", "-0.33333", "Europe/Paris"),
("3024532", "Cluses", "", "FR", "250", "B9", "74", "742", "74081", "46.06251", "6.57497", "Europe/Paris"),
("3024596", "Clichy-sous-Bois", "Клиши-су-Буа", "FR", "250", "A8", "93", "932", "93014", "48.9102", "2.55324", "Europe/Paris"),
("3024597", "Clichy", "Клиши", "FR", "250", "A8", "92", "922", "92024", "48.90018", "2.30952", "Europe/Paris"),
("3024635", "Clermont-Ferrand", "Клермон-Ферран", "FR", "250", "98", "63", "632", "63113", "45.77966", "3.08628", "Europe/Paris"),
("3024783", "Clamart", "Кламар", "FR", "250", "A8", "92", "921", "92023", "48.80299", "2.26692", "Europe/Paris"),
("3025053", "Cholet", "Шоле", "FR", "250", "B5", "49", "492", "49099", "47.06667", "-0.88333", "Europe/Paris"),
("3025055", "Choisy-le-Roi", "Шуази-ле-Руа", "FR", "250", "A8", "94", "941", "94022", "48.76846", "2.41874", "Europe/Paris"),
("3025144", "Chilly-Mazarin", "", "FR", "250", "A8", "91", "913", "91161", "48.71489", "2.31638", "Europe/Paris"),
("3025314", "Chevilly-Larue", "Шевильи-Ларю", "FR", "250", "A8", "94", "943", "94021", "48.76476", "2.3503", "Europe/Paris"),
("3025466", "Cherbourg-Octeville", "Шербур-Октевиль", "FR", "250", "99", "50", "502", "50129", "49.63984", "-1.61636", "Europe/Paris"),
("3025496", "Chenove", "", "FR", "250", "A1", "21", "212", "21166", "47.29323", "5.00457", "Europe/Paris"),
("3025509", "Chennevieres-sur-Marne", "", "FR", "250", "A8", "94", "942", "94019", "48.79702", "2.54046", "Europe/Paris"),
("3025622", "Chelles", "", "FR", "250", "A8", "77", "775", "77108", "48.88109", "2.59295", "Europe/Paris"),
("3025715", "Chaville", "Шавиль", "FR", "250", "A8", "92", "923", "92022", "48.80565", "2.18864", "Europe/Paris"),
("3025892", "Chaumont", "Шомон", "FR", "250", "A4", "52", "521", "52121", "48.11121", "5.14134", "Europe/Paris"),
("3026033", "Chatou", "Шату", "FR", "250", "A8", "78", "783", "78146", "48.8898", "2.15863", "Europe/Paris"),
("3026083", "Chatillon", "", "FR", "250", "A8", "92", "921", "92020", "48.8024", "2.29346", "Europe/Paris"),
("3026108", "Chatenay-Malabry", "Шатне-Малабри", "FR", "250", "A8", "92", "921", "92019", "48.76507", "2.26655", "Europe/Paris"),
("3026141", "Chatellerault", "Шательро", "FR", "250", "B7", "86", "861", "86066", "46.8", "0.53333", "Europe/Paris"),
("3026194", "Chateau-Thierry", "Шато-Тьерри", "FR", "250", "B6", "02", "021", "02168", "49.05", "3.4", "Europe/Paris"),
("3026204", "Chateauroux", "Шатору", "FR", "250", "A3", "36", "362", "36044", "46.81667", "1.7", "Europe/Paris"),
("3026285", "Chateaudun", "Шатодён", "FR", "250", "A3", "28", "282", "28088", "48.08333", "1.33333", "Europe/Paris"),
("3026467", "Chartres", "Шартр", "FR", "250", "A3", "28", "281", "28085", "48.44685", "1.48925", "Europe/Paris"),
("3026613", "Charleville-Mezieres", "Шарлевиль-Мезьер", "FR", "250", "A4", "08", "081", "08105", "49.76667", "4.71667", "Europe/Paris"),
("3026637", "Charenton-le-Pont", "Шарантон-ле-Пон", "FR", "250", "A8", "94", "941", "94018", "48.82209", "2.41217", "Europe/Paris"),
("3027014", "Champs-sur-Marne", "Шан-сюр-Марн", "FR", "250", "A8", "77", "775", "77083", "48.85", "2.6", "Europe/Paris"),
("3027105", "Champigny-sur-Marne", "Шампиньи-сюр-Марн", "FR", "250", "A8", "94", "942", "94017", "48.81642", "2.49366", "Europe/Paris"),
("3027422", "Chambery", "Шамбери", "FR", "250", "B9", "73", "732", "73065", "45.56667", "5.93333", "Europe/Paris"),
("3027453", "Chamalieres", "Шамальер", "FR", "250", "98", "63", "632", "63075", "45.77559", "3.0631", "Europe/Paris"),
("3027484", "Chalon-sur-Saone", "Шалон-сюр-Сон", "FR", "250", "A1", "71", "712", "71076", "46.78333", "4.85", "Europe/Paris"),
("3027487", "Chalons-en-Champagne", "Шалон-ан-Шампань", "FR", "250", "A4", "51", "511", "51108", "48.95393", "4.36724", "Europe/Paris"),
("3027513", "Challans", "", "FR", "250", "B5", "85", "853", "85047", "46.84363", "-1.8749", "Europe/Paris"),
("3027763", "Cestas", "", "FR", "250", "97", "33", "332", "33122", "44.74345", "-0.67905", "Europe/Paris"),
("3027767", "Cesson-Sevigne", "", "FR", "250", "A2", "35", "353", "35051", "48.1212", "-1.603", "Europe/Paris"),
("3027883", "Cergy", "Сержи", "FR", "250", "A8", "95", "953", "95127", "49.03645", "2.07613", "Europe/Paris"),
("3027950", "Cenon", "Сенон", "FR", "250", "97", "33", "332", "33119", "44.8559", "-0.51839", "Europe/Paris"),
("3028097", "Cayenne", "", "FR", "250", "A7", "76", "", "", "49.55858", "1.62803", "Europe/Paris"),
("3028134", "Cavaillon", "Кавайон", "FR", "250", "B8", "84", "841", "84035", "43.83125", "5.03586", "Europe/Paris"),
("3028263", "Castres", "Кастр", "FR", "250", "B3", "81", "812", "81065", "43.6", "2.25", "Europe/Paris"),
("3028337", "Castelnau-le-Lez", "", "FR", "250", "A9", "34", "343", "34057", "43.63333", "3.9", "Europe/Paris"),
("3028486", "Carvin", "Карвен", "FR", "250", "B4", "62", "627", "62215", "50.49235", "2.95815", "Europe/Paris"),
("3028521", "Carrieres-sous-Poissy", "", "FR", "250", "A8", "78", "783", "78123", "48.94952", "2.04068", "Europe/Paris"),
("3028535", "Carquefou", "", "FR", "250", "B5", "44", "442", "44026", "47.29822", "-1.49024", "Europe/Paris"),
("3028542", "Carpentras", "Карпантрас", "FR", "250", "B8", "84", "843", "84031", "44.05", "5.05", "Europe/Paris"),
("3028641", "Carcassonne", "Каркасон", "FR", "250", "A9", "11", "111", "11069", "43.21667", "2.35", "Europe/Paris"),
("3028779", "Canteleu", "", "FR", "250", "A7", "76", "763", "76157", "49.44065", "1.02459", "Europe/Paris"),
("3028808", "Cannes", "Канны", "FR", "250", "B8", "06", "061", "06029", "43.55135", "7.01275", "Europe/Paris"),
("3029030", "Cambrai", "Камбре", "FR", "250", "B4", "59", "592", "59122", "50.16667", "3.23333", "Europe/Paris"),
("3029096", "Caluire-et-Cuire", "", "FR", "250", "B9", "69", "691", "69034", "45.79041", "4.84112", "Europe/Paris"),
("3029162", "Calais", "Кале", "FR", "250", "B4", "62", "626", "62193", "50.95194", "1.85635", "Europe/Paris"),
("3029213", "Cahors", "Каор", "FR", "250", "B3", "46", "461", "46042", "44.4491", "1.43663", "Europe/Paris"),
("3029227", "Cagnes-sur-Mer", "Кань-сюр-Мер", "FR", "250", "B8", "06", "061", "06027", "43.6646", "7.15339", "Europe/Paris"),
("3029241", "Caen", "Кан", "FR", "250", "99", "14", "142", "14118", "49.18585", "-0.35912", "Europe/Paris"),
("3029276", "Cachan", "Кашан", "FR", "250", "A8", "94", "943", "94016", "48.79632", "2.33661", "Europe/Paris"),
("3029706", "Bry-sur-Marne", "Бри-сюр-Марн", "FR", "250", "A8", "94", "942", "94015", "48.83811", "2.52488", "Europe/Paris"),
("3029748", "Brunoy", "Брюнуа", "FR", "250", "A8", "91", "912", "91114", "48.6942", "2.49223", "Europe/Paris"),
("3029825", "Bruay-la-Buissiere", "Брюэ-ла-Бюисьер", "FR", "250", "B4", "62", "622", "62178", "50.48333", "2.55", "Europe/Paris"),
("3029931", "Bron", "Брон", "FR", "250", "B9", "69", "691", "69029", "45.73333", "4.91667", "Europe/Paris"),
("3029974", "Brive-la-Gaillarde", "Бриве-ла-Гаилларде", "FR", "250", "B1", "19", "191", "19031", "45.15", "1.53333", "Europe/Paris"),
("3030057", "Brignoles", "Бриньоль", "FR", "250", "B8", "83", "833", "83023", "43.4", "6.06667", "Europe/Paris"),
("3030101", "Brie-Comte-Robert", "", "FR", "250", "A8", "77", "772", "77053", "48.68333", "2.61667", "Europe/Paris"),
("3030257", "Bretigny-sur-Orge", "", "FR", "250", "A8", "91", "913", "91103", "48.61135", "2.30593", "Europe/Paris"),
("3030300", "Brest", "Брест", "FR", "250", "A2", "29", "291", "29019", "48.4", "-4.48333", "Europe/Paris"),
("3030303", "Bressuire", "Брессюир", "FR", "250", "B7", "79", "791", "79049", "46.85", "-0.48333", "Europe/Paris"),
("3030960", "Bourgoin", "", "FR", "250", "B9", "38", "382", "38053", "45.58333", "5.28333", "Europe/Paris"),
("3030985", "Bourg-les-Valence", "", "FR", "250", "B9", "26", "263", "26058", "44.95601", "4.91023", "Europe/Paris"),
("3030990", "Bourg-la-Reine", "", "FR", "250", "A8", "92", "921", "92014", "48.77888", "2.31781", "Europe/Paris"),
("3031005", "Bourges", "Бурж", "FR", "250", "A3", "18", "181", "18033", "47.08333", "2.4", "Europe/Paris"),
("3031009", "Bourg-en-Bresse", "Бурк-ан-Брес", "FR", "250", "B9", "01", "012", "01053", "46.20574", "5.2258", "Europe/Paris"),
("3031133", "Boulogne-sur-Mer", "Булонь-сюр-Мер", "FR", "250", "B4", "62", "623", "62160", "50.71667", "1.61667", "Europe/Paris"),
("3031137", "Boulogne-Billancourt", "Булонь-Бийанкур", "FR", "250", "A8", "92", "923", "92012", "48.83333", "2.25", "Europe/Paris"),
("3031268", "Bouguenais", "", "FR", "250", "B5", "44", "442", "44020", "47.17762", "-1.62143", "Europe/Paris"),
("3031582", "Bordeaux", "Бордо", "FR", "250", "97", "33", "332", "33063", "44.84044", "-0.5805", "Europe/Paris"),
("3031709", "Bonneuil-sur-Marne", "", "FR", "250", "A8", "94", "941", "94011", "48.7695", "2.4793", "Europe/Paris"),
("3031815", "Bondy", "Бонди", "FR", "250", "A8", "93", "931", "93010", "48.9018", "2.48931", "Europe/Paris"),
("3031898", "Boissy-Saint-Leger", "", "FR", "250", "A8", "94", "941", "94004", "48.7515", "2.51163", "Europe/Paris"),
("3032070", "Bois-Colombes", "", "FR", "250", "A8", "92", "922", "92009", "48.91936", "2.27484", "Europe/Paris"),
("3032179", "Bobigny", "Бобиньи", "FR", "250", "A8", "93", "931", "93008", "48.9", "2.45", "Europe/Paris"),
("3032213", "Blois", "Блуа", "FR", "250", "A3", "41", "411", "41018", "47.58333", "1.33333", "Europe/Paris"),
("3032340", "Blanquefort", "", "FR", "250", "97", "33", "332", "33056", "44.91248", "-0.63663", "Europe/Paris"),
("3032469", "Blagnac", "Бланьяк", "FR", "250", "B3", "31", "313", "31069", "43.63276", "1.39399", "Europe/Paris"),
("3032551", "Bischheim", "", "FR", "250", "C1", "67", "676", "67043", "48.61612", "7.75343", "Europe/Paris"),
("3032797", "Biarritz", "Биарриц", "FR", "250", "97", "64", "641", "64122", "43.48012", "-1.55558", "Europe/Paris"),
("3032824", "Bezons", "Безон", "FR", "250", "A8", "95", "951", "95063", "48.92426", "2.2128", "Europe/Paris"),
("3032833", "Beziers", "Безье", "FR", "250", "A9", "34", "341", "34032", "43.34122", "3.21402", "Europe/Paris"),
("3033002", "Bethune", "Бетюн", "FR", "250", "B4", "62", "622", "62119", "50.53333", "2.63333", "Europe/Paris"),
("3033123", "Besancon", "Безансон", "FR", "250", "A6", "25", "251", "25056", "47.24878", "6.01815", "Europe/Paris"),
("3033391", "Bergerac", "", "FR", "250", "97", "24", "241", "24037", "44.85", "0.48333", "Europe/Paris"),
("3033415", "Berck", "", "FR", "250", "B4", "62", "624", "62108", "50.4", "1.6", "Europe/Paris"),
("3033416", "Berck-Plage", "", "FR", "250", "B4", "62", "624", "62108", "50.40704", "1.56446", "Europe/Paris"),
("3033791", "Belfort", "Бельфор", "FR", "250", "A6", "90", "901", "90010", "47.63333", "6.86667", "Europe/Paris"),
("3033881", "Begles", "Беглесе", "FR", "250", "97", "33", "332", "33039", "44.80845", "-0.54809", "Europe/Paris"),
("3034006", "Beauvais", "Бове", "FR", "250", "B6", "60", "601", "60057", "49.43333", "2.08333", "Europe/Paris"),
("3034126", "Beaune", "Бон", "FR", "250", "A1", "21", "211", "21054", "47.03333", "4.83333", "Europe/Paris"),
("3034475", "Bayonne", "Байонна", "FR", "250", "97", "64", "641", "64102", "43.48333", "-1.48333", "Europe/Paris"),
("3034483", "Bayeux", "Байё", "FR", "250", "99", "14", "141", "14047", "49.27732", "-0.7039", "Europe/Paris"),
("3034640", "Bastia", "Бастия", "FR", "250", "A5", "2B", "2B2", "2B033", "42.70278", "9.45", "Europe/Paris"),
("3034911", "Bar-le-Duc", "Бар-ле-Дюк", "FR", "250", "B2", "55", "551", "55029", "48.78333", "5.16667", "Europe/Paris"),
("3035204", "Balma", "", "FR", "250", "B3", "31", "313", "31044", "43.61111", "1.49944", "Europe/Paris"),
("3035396", "Bagnols-sur-Ceze", "Баньоль-сюр-Сез", "FR", "250", "A9", "30", "302", "30028", "44.1599", "4.61776", "Europe/Paris"),
("3035403", "Bagnolet", "Баньоле", "FR", "250", "A8", "93", "931", "93006", "48.86667", "2.41667", "Europe/Paris"),
("3035409", "Bagneux", "", "FR", "250", "A8", "92", "921", "92007", "48.79564", "2.30796", "Europe/Paris"),
("3035654", "Avon", "", "FR", "250", "A8", "77", "774", "77014", "48.4022", "2.72022", "Europe/Paris"),
("3035667", "Avion", "", "FR", "250", "B4", "62", "627", "62065", "50.41038", "2.83053", "Europe/Paris"),
("3035681", "Avignon", "Авиньон", "FR", "250", "B8", "84", "842", "84007", "43.94834", "4.80892", "Europe/Paris"),
("3035843", "Auxerre", "Осер", "FR", "250", "A1", "89", "891", "89024", "47.8", "3.56667", "Europe/Paris"),
("3035883", "Autun", "Отён", "FR", "250", "A1", "71", "711", "71014", "46.95", "4.3", "Europe/Paris"),
("3036016", "Aurillac", "Орийак", "FR", "250", "98", "15", "151", "15014", "44.91667", "2.45", "Europe/Paris"),
("3036145", "Aulnay-sous-Bois", "Оне-су-Буа", "FR", "250", "A8", "93", "932", "93005", "48.93814", "2.49402", "Europe/Paris"),
("3036240", "Audincourt", "", "FR", "250", "A6", "25", "252", "25031", "47.48327", "6.85341", "Europe/Paris"),
("3036281", "Auch", "Ош", "FR", "250", "B3", "32", "321", "32013", "43.65", "0.58333", "Europe/Paris"),
("3036386", "Aubervilliers", "Обервилье", "FR", "250", "A8", "93", "933", "93001", "48.91667", "2.38333", "Europe/Paris"),
("3036433", "Aubagne", "Обань", "FR", "250", "B8", "13", "133", "13005", "43.29276", "5.57067", "Europe/Paris"),
("3036460", "Athis-Mons", "", "FR", "250", "A8", "91", "913", "91027", "48.70522", "2.39147", "Europe/Paris"),
("3036572", "Asnieres-sur-Seine", "Аньер-сюр-Сен", "FR", "250", "A8", "92", "922", "92004", "48.91667", "2.28333", "Europe/Paris"),
("3036784", "Arras", "Аррас", "FR", "250", "B4", "62", "621", "62041", "50.29301", "2.78186", "Europe/Paris"),
("3036903", "Armentieres", "Армантьер", "FR", "250", "B4", "59", "595", "59017", "50.68568", "2.88214", "Europe/Paris"),
("3036938", "Arles", "Арль", "FR", "250", "B8", "13", "132", "13004", "43.67681", "4.63031", "Europe/Paris"),
("3037044", "Argenteuil", "Аржантей", "FR", "250", "A8", "95", "951", "95018", "48.95", "2.25", "Europe/Paris"),
("3037051", "Argentan", "Аржантан", "FR", "250", "99", "61", "612", "61006", "48.75", "-0.01667", "Europe/Paris"),
("3037157", "Arcueil", "", "FR", "250", "A8", "94", "943", "94003", "48.79993", "2.33256", "Europe/Paris"),
("3037423", "Antony", "", "FR", "250", "A8", "92", "921", "92002", "48.75", "2.3", "Europe/Paris"),
("3037456", "Antibes", "Антиб", "FR", "250", "B8", "06", "061", "06004", "43.56241", "7.12777", "Europe/Paris"),
("3037514", "Annonay", "Анноне", "FR", "250", "B9", "07", "073", "07010", "45.2397", "4.67075", "Europe/Paris"),
("3037538", "Annemasse", "", "FR", "250", "B9", "74", "743", "74012", "46.19439", "6.23775", "Europe/Paris"),
("3037540", "Annecy-le-Vieux", "Аннеси-ле-Вье", "FR", "250", "B9", "74", "741", "74011", "45.91972", "6.14393", "Europe/Paris"),
("3037543", "Annecy", "Анси", "FR", "250", "B9", "74", "741", "74010", "45.9", "6.11667", "Europe/Paris"),
("3037598", "Angouleme", "Ангулем", "FR", "250", "B7", "16", "161", "16015", "45.65", "0.15", "Europe/Paris"),
("3037612", "Anglet", "Англет", "FR", "250", "97", "64", "641", "64024", "43.47664", "-1.51346", "Europe/Paris"),
("3037656", "Angers", "Анже", "FR", "250", "B5", "49", "491", "49007", "47.46667", "-0.55", "Europe/Paris"),
("3037854", "Amiens", "Амьен", "FR", "250", "B6", "80", "802", "80021", "49.9", "2.3", "Europe/Paris"),
("3038159", "Allauch", "Аллош", "FR", "250", "B8", "13", "133", "13002", "43.33573", "5.48201", "Europe/Paris"),
("3038213", "Alfortville", "Альфорвилль", "FR", "250", "A8", "94", "941", "94002", "48.80575", "2.4204", "Europe/Paris"),
("3038224", "Ales", "Алес", "FR", "250", "A9", "30", "301", "30007", "44.13333", "4.08333", "Europe/Paris"),
("3038230", "Alencon", "Алансон", "FR", "250", "99", "61", "611", "61001", "48.43333", "0.08333", "Europe/Paris"),
("3038261", "Albi", "Альби", "FR", "250", "B3", "81", "811", "81004", "43.9298", "2.148", "Europe/Paris"),
("3038266", "Albertville", "Альбервиль", "FR", "250", "B9", "73", "731", "73011", "45.67452", "6.39061", "Europe/Paris"),
("3038334", "Ajaccio", "Аяччо", "FR", "250", "A5", "2A", "2A1", "2A004", "41.92723", "8.73462", "Europe/Paris"),
("3038350", "Aix-les-Bains", "Экс-ле-Бен", "FR", "250", "B9", "73", "732", "73008", "45.68338", "5.92241", "Europe/Paris"),
("3038354", "Aix-en-Provence", "Экс-ан-Прованс", "FR", "250", "B8", "13", "131", "13001", "43.5283", "5.44973", "Europe/Paris"),
("3038634", "Agen", "Ажен", "FR", "250", "97", "47", "471", "47001", "44.2", "0.63333", "Europe/Paris"),
("3038638", "Agde", "Агд", "FR", "250", "A9", "34", "341", "34003", "43.31083", "3.47583", "Europe/Paris"),
("3038712", "Acheres", "", "FR", "250", "A8", "78", "783", "78005", "48.96116", "2.06882", "Europe/Paris"),
("3038789", "Abbeville", "Абвиль", "FR", "250", "B6", "80", "801", "80001", "50.1", "1.83333", "Europe/Paris"),
("6543862", "Villeneuve-d'Ascq", "Вильнёв-д’Аск", "FR", "250", "B4", "59", "595", "59009", "50.61669", "3.16664", "Europe/Paris"),
("6615536", "Les Ulis", "Лез-Юлис", "FR", "250", "A8", "91", "913", "91692", "48.68167", "2.16944", "Europe/Paris"),
("6615539", "Bourgoin-Jallieu", "Бургуин-Жалльё", "FR", "250", "B9", "38", "382", "38053", "45.58611", "5.27361", "Europe/Paris"),
("7284882", "Marseille 01", "", "FR", "250", "B8", "13", "133", "13055", "43.29814", "5.38407", "Europe/Paris"),
("7284883", "Marseille 02", "", "FR", "250", "B8", "13", "133", "13055", "43.29664", "5.37034", "Europe/Paris"),
("7284884", "Marseille 03", "", "FR", "250", "B8", "13", "133", "13055", "43.30257", "5.37583", "Europe/Paris"),
("7284885", "Marseille 04", "", "FR", "250", "B8", "13", "133", "13055", "43.30213", "5.40141", "Europe/Paris"),
("7284886", "Marseille 05", "", "FR", "250", "B8", "13", "133", "13055", "43.29551", "5.40055", "Europe/Paris"),
("7284887", "Marseille 06", "", "FR", "250", "B8", "13", "133", "13055", "43.29114", "5.38244", "Europe/Paris"),
("7284888", "Marseille 07", "", "FR", "250", "B8", "13", "133", "13055", "43.28889", "5.36485", "Europe/Paris"),
("7284889", "Marseille 08", "", "FR", "250", "B8", "13", "133", "13055", "43.27083", "5.3821", "Europe/Paris"),
("7284890", "Marseille 10", "", "FR", "250", "B8", "13", "133", "13055", "43.27889", "5.41523", "Europe/Paris"),
("7284891", "Marseille 09", "", "FR", "250", "B8", "13", "133", "13055", "43.25433", "5.4057", "Europe/Paris"),
("7284892", "Marseille 11", "", "FR", "250", "B8", "13", "133", "13055", "43.2907", "5.4384", "Europe/Paris"),
("7284893", "Marseille 12", "", "FR", "250", "B8", "13", "133", "13055", "43.29614", "5.43617", "Europe/Paris"),
("7284894", "Marseille 13", "", "FR", "250", "B8", "13", "133", "13055", "43.31856", "5.40836", "Europe/Paris"),
("7284895", "Marseille 14", "", "FR", "250", "B8", "13", "133", "13055", "43.34447", "5.38004", "Europe/Paris"),
("7284896", "Marseille 15", "", "FR", "250", "B8", "13", "133", "13055", "43.37224", "5.35386", "Europe/Paris"),
("7284897", "Marseille 16", "", "FR", "250", "B8", "13", "133", "13055", "43.35982", "5.33421", "Europe/Paris"),
("8504417", "La Defense", "Ля Дефанс", "FR", "250", "A8", "92", "922", "92062", "48.89198", "2.23881", "Europe/Paris"),
("8533870", "Saint-Quentin-en-Yvelines", "", "FR", "250", "A8", "78", "784", "78423", "48.77186", "2.01891", "Europe/Paris"),
("8555643", "Cergy-Pontoise", "", "FR", "250", "A8", "95", "953", "95127", "49.03894", "2.07805", "Europe/Paris"),
("2396253", "Tchibanga", "", "GA", "266", "05", "", "", "", "-2.85", "11.03333", "Africa/Libreville"),
("2396518", "Port-Gentil", "", "GA", "266", "08", "", "", "", "-0.71933", "8.78151", "Africa/Libreville"),
("2396646", "Oyem", "", "GA", "266", "09", "", "", "", "1.5995", "11.57933", "Africa/Libreville"),
("2398073", "Mouila", "", "GA", "266", "04", "", "", "", "-1.86846", "11.05594", "Africa/Libreville"),
("2398269", "Moanda", "", "GA", "266", "02", "", "", "", "-1.55746", "13.21775", "Africa/Libreville"),
("2399697", "Libreville", "Либревиль", "GA", "266", "01", "", "", "", "0.39241", "9.45356", "Africa/Libreville"),
("2399888", "Lambarene", "Ламбарене", "GA", "266", "03", "", "", "", "-0.7001", "10.24055", "Africa/Libreville"),
("2399959", "Koulamoutou", "", "GA", "266", "07", "", "", "", "-1.13032", "12.47359", "Africa/Libreville"),
("2400555", "Franceville", "Франсвиль", "GA", "266", "02", "", "", "", "-1.63333", "13.58357", "Africa/Libreville"),
("2633352", "York", "Йорк", "GB", "826", "ENG", "Q5", "", "", "53.95763", "-1.08271", "Europe/London"),
("2633373", "Yeovil", "Йеовиль", "GB", "826", "ENG", "M3", "40UD", "", "50.94159", "-2.63211", "Europe/London"),
("2633397", "Yeadon", "", "GB", "826", "ENG", "H3", "", "", "53.86437", "-1.68743", "Europe/London"),
("2633406", "Yate", "", "GB", "826", "ENG", "M6", "00HD044", "", "51.54074", "-2.41839", "Europe/London"),
("2633485", "Wrexham", "Рексем", "GB", "826", "WLS", "Z4", "00NL007", "", "53.04664", "-2.99132", "Europe/London"),
("2633521", "Worthing", "", "GB", "826", "ENG", "P6", "45UH", "", "50.81448", "-0.37126", "Europe/London"),
("2633551", "Worksop", "Уорксоп", "GB", "826", "ENG", "J9", "37UC", "", "53.30182", "-1.12404", "Europe/London"),
("2633553", "Workington", "", "GB", "826", "ENG", "C9", "16UB", "", "54.6425", "-3.54413", "Europe/London"),
("2633563", "Worcester", "Вустер", "GB", "826", "ENG", "Q4", "47UE", "", "52.18935", "-2.22001", "Europe/London"),
("2633655", "Woodford Green", "", "GB", "826", "ENG", "GLA", "K8", "", "51.60938", "0.02329", "Europe/London"),
("2633681", "Wombwell", "", "GB", "826", "ENG", "A3", "", "", "53.52189", "-1.39698", "Europe/London"),
("2633691", "Wolverhampton", "Вулвергемптон", "GB", "826", "ENG", "Q3", "41UF", "", "52.58547", "-2.12296", "Europe/London"),
("2633708", "Wokingham", "Уокингхем", "GB", "826", "ENG", "Q2", "", "", "51.4112", "-0.83565", "Europe/London"),
("2633709", "Woking", "Уокинге", "GB", "826", "ENG", "N7", "43UM", "", "51.31903", "-0.55893", "Europe/London"),
("2633729", "Witney", "Уитни", "GB", "826", "ENG", "K2", "38UF", "", "51.7836", "-1.4854", "Europe/London"),
("2633749", "Witham", "", "GB", "826", "ENG", "E4", "22UC", "", "51.80007", "0.64038", "Europe/London"),
("2633765", "Wishaw", "", "GB", "826", "SCT", "V8", "", "", "55.76667", "-3.91667", "Europe/London"),
("2633771", "Wisbech", "Визбич", "GB", "826", "ENG", "C3", "12UD", "", "52.66622", "0.15938", "Europe/London"),
("2633810", "Winsford", "", "GB", "826", "ENG", "Z8", "00EW163", "", "53.18333", "-2.51667", "Europe/London"),
("2633842", "Windsor", "Виндзор", "GB", "826", "ENG", "P9", "", "", "51.48333", "-0.6", "Europe/London"),
("2633858", "Winchester", "Винчестер", "GB", "826", "ENG", "F2", "24UP", "", "51.06513", "-1.3187", "Europe/London"),
("2633883", "Wilmslow", "", "GB", "826", "ENG", "Z7", "00EQ004", "", "53.32803", "-2.23148", "Europe/London"),
("2633912", "Willenhall", "", "GB", "826", "ENG", "O8", "", "", "52.6", "-2.03333", "Europe/London"),
("2633936", "Wigston Magna", "", "GB", "826", "ENG", "H5", "31UJ", "", "52.58128", "-1.09248", "Europe/London"),
("2633948", "Wigan", "Уиган", "GB", "826", "ENG", "P7", "", "", "53.53333", "-2.61667", "Europe/London"),
("2633954", "Widnes", "", "GB", "826", "ENG", "E9", "00ET005", "", "53.3618", "-2.73406", "Europe/London"),
("2633976", "Wickford", "", "GB", "826", "ENG", "E4", "22UB", "", "51.61101", "0.52331", "Europe/London"),
("2634021", "Whitstable", "Уитстабл", "GB", "826", "ENG", "G5", "6945807", "", "51.3607", "1.0257", "Europe/London"),
("2634032", "Whitley Bay", "", "GB", "826", "ENG", "J5", "00EM167", "", "55.03973", "-1.44713", "Europe/London"),
("2634096", "Whitehaven", "", "GB", "826", "ENG", "C9", "16UE", "", "54.54897", "-3.58412", "Europe/London"),
("2634103", "Whitefield", "", "GB", "826", "ENG", "C1", "", "", "53.55", "-2.3", "Europe/London"),
("2634155", "Whickham", "", "GB", "826", "ENG", "E5", "00CH002", "", "54.94561", "-1.67635", "Europe/London"),
("2634202", "Weymouth", "Уэймут", "GB", "826", "ENG", "D6", "19UJ", "", "50.61136", "-2.45334", "Europe/London"),
("2634204", "Weybridge", "Вейбридж", "GB", "826", "ENG", "N7", "43UB", "", "51.37216", "-0.45297", "Europe/London"),
("2634308", "Weston-super-Mare", "Уэстон-сьюпер-Мэр", "GB", "826", "ENG", "J4", "00HC038", "", "51.34603", "-2.97665", "Europe/London"),
("2634340", "West Molesey", "", "GB", "826", "ENG", "N7", "43UB", "", "51.39985", "-0.37997", "Europe/London"),
("2634387", "Westhoughton", "", "GB", "826", "ENG", "B1", "00BL003", "", "53.54899", "-2.52464", "Europe/London"),
("2634491", "West Bromwich", "Уэст-Бромидж", "GB", "826", "ENG", "L7", "47UB", "", "52.51868", "-1.9945", "Europe/London"),
("2634493", "West Bridgford", "", "GB", "826", "ENG", "J9", "37UJ", "", "52.92979", "-1.12537", "Europe/London"),
("2634552", "Welwyn Garden City", "Уэлин-Гарден-Сити", "GB", "826", "ENG", "F8", "26UL", "", "51.80174", "-0.20691", "Europe/London"),
("2634573", "Wellington", "Веллингтон", "GB", "826", "ENG", "O2", "00GF026", "", "52.7", "-2.51667", "Europe/London"),
("2634578", "Wellingborough", "Веллингборо", "GB", "826", "ENG", "J1", "34UH", "", "52.30273", "-0.69446", "Europe/London"),
("2634579", "Welling", "", "GB", "826", "ENG", "GLA", "A6", "", "51.46246", "0.10759", "Europe/London"),
("2634616", "Wednesfield", "", "GB", "826", "ENG", "Q3", "", "", "52.6", "-2.08333", "Europe/London"),
("2634617", "Wednesbury", "", "GB", "826", "ENG", "L7", "41UF", "", "52.5514", "-2.02355", "Europe/London"),
("2634672", "Wath upon Dearne", "", "GB", "826", "ENG", "L3", "00CF003", "", "53.50291", "-1.3458", "Europe/London"),
("2634677", "Watford", "Уотфорд", "GB", "826", "ENG", "F8", "26UK", "", "51.65531", "-0.39602", "Europe/London"),
("2634686", "Waterlooville", "Уотерлувиль", "GB", "826", "ENG", "F2", "24UH", "", "50.88067", "-1.0304", "Europe/London"),
("2634715", "Washington", "Вашингтон", "GB", "826", "ENG", "N6", "", "", "54.9", "-1.51667", "Europe/London"),
("2634725", "Warwick", "Уорик", "GB", "826", "ENG", "P3", "44UF", "", "52.28333", "-1.58333", "Europe/London"),
("2634739", "Warrington", "Уоррингтон", "GB", "826", "ENG", "P2", "", "", "53.39254", "-2.58024", "Europe/London"),
("2634755", "Warminster", "", "GB", "826", "ENG", "P8", "00HY231", "", "51.20434", "-2.17873", "Europe/London"),
("2634777", "Ware", "", "GB", "826", "ENG", "F8", "26UD", "", "51.81265", "-0.02832", "Europe/London"),
("2634825", "Walton-on-Thames", "", "GB", "826", "ENG", "N7", "43UB", "", "51.38533", "-0.42066", "Europe/London"),
("2634843", "Waltham Abbey", "", "GB", "826", "ENG", "E4", "22UH", "", "51.687", "-0.00421", "Europe/London"),
("2634853", "Walsall", "Уолсолл", "GB", "826", "ENG", "O8", "41UF", "", "52.58528", "-1.98396", "Europe/London"),
("2634864", "Wallsend", "Уолсенд", "GB", "826", "ENG", "J5", "", "", "54.99111", "-1.53397", "Europe/London"),
("2634873", "Wallasey", "Уолласи", "GB", "826", "ENG", "Q1", "00CA009", "", "53.42324", "-3.06497", "Europe/London"),
("2634887", "Walkden", "", "GB", "826", "ENG", "L5", "", "", "53.51667", "-2.4", "Europe/London"),
("2634910", "Wakefield", "", "GB", "826", "ENG", "O7", "", "", "53.68331", "-1.49768", "Europe/London"),
("2635062", "Urmston", "", "GB", "826", "ENG", "O6", "00BU001", "", "53.44852", "-2.35419", "Europe/London"),
("2635243", "Uckfield", "", "GB", "826", "ENG", "E2", "21UH", "", "50.96948", "0.09589", "Europe/London"),
("2635269", "Tynemouth", "", "GB", "826", "ENG", "J5", "00EM167", "", "55.01788", "-1.42559", "Europe/London"),
("2635281", "Tyldesley", "", "GB", "826", "ENG", "P7", "00BL003", "", "53.51393", "-2.46754", "Europe/London"),
("2635412", "Truro", "Труро", "GB", "826", "ENG", "C6", "00HE202", "", "50.26526", "-5.05436", "Europe/London"),
("2635427", "Trowbridge", "Троубридже", "GB", "826", "ENG", "P8", "", "", "51.31889", "-2.20861", "Europe/London"),
("2635603", "Totton", "", "GB", "826", "ENG", "F2", "24UJ", "", "50.91877", "-1.49037", "Europe/London"),
("2635650", "Torquay", "Торки", "GB", "826", "ENG", "O4", "", "", "50.46384", "-3.51434", "Europe/London"),
("2635703", "Tonbridge", "Тонбридж", "GB", "826", "ENG", "G5", "29UP", "", "51.19242", "0.27532", "Europe/London"),
("2635762", "Tiverton", "", "GB", "826", "ENG", "D4", "18UD", "", "50.9", "-3.48333", "Europe/London"),
("2635785", "Tipton", "", "GB", "826", "ENG", "L7", "41UF", "", "52.52956", "-2.06773", "Europe/London"),
("2636005", "Thornaby-on-Tees", "", "GB", "826", "ENG", "K9", "", "", "54.53333", "-1.3", "Europe/London"),
("2636032", "Thetford", "Тетфорд", "GB", "826", "ENG", "I9", "33UB", "", "52.41667", "0.75", "Europe/London"),
("2636049", "Thatcham", "", "GB", "826", "ENG", "P4", "00MB049", "", "51.40366", "-1.26049", "Europe/London"),
("2636132", "Teignmouth", "Тинмут", "GB", "826", "ENG", "D4", "18UH", "", "50.54768", "-3.49637", "Europe/London"),
("2636177", "Taunton", "Тонтон", "GB", "826", "ENG", "M3", "40UE", "", "51.01494", "-3.10293", "Europe/London"),
("2636276", "Tamworth", "", "GB", "826", "ENG", "M9", "41UK", "", "52.63399", "-1.69587", "Europe/London"),
("2636333", "Tadley", "", "GB", "826", "ENG", "F2", "24UB", "", "51.35045", "-1.1285", "Europe/London"),
("2636373", "Swinton", "", "GB", "826", "ENG", "I2", "", "", "53.5", "-2.35", "Europe/London"),
("2636389", "Swindon", "Свиндон", "GB", "826", "ENG", "N9", "00HX015", "", "51.55797", "-1.78116", "Europe/London"),
("2636432", "Swansea", "Суонси", "GB", "826", "WLS", "Z1", "", "", "51.62079", "-3.94323", "Europe/London"),
("2636433", "Swanscombe", "", "GB", "826", "ENG", "G5", "29UD", "", "51.44713", "0.31028", "Europe/London"),
("2636439", "Swanley", "", "GB", "826", "ENG", "G5", "6945814", "", "51.39717", "0.17321", "Europe/London"),
("2636465", "Swadlincote", "", "GB", "826", "ENG", "D3", "17UK", "", "52.774", "-1.55744", "Europe/London"),
("2636484", "Sutton in Ashfield", "", "GB", "826", "ENG", "J9", "37UB", "", "53.12542", "-1.26135", "Europe/London"),
("2636486", "Sutton Coldfield", "", "GB", "826", "ENG", "A7", "", "", "52.56667", "-1.81667", "Europe/London"),
("2636503", "Sutton", "Саттон", "GB", "826", "ENG", "GLA", "N8", "", "51.35", "-0.2", "Europe/London"),
("2636531", "Sunderland", "Сандерленд", "GB", "826", "ENG", "N6", "", "", "54.90465", "-1.38222", "Europe/London"),
("2636534", "Sunbury-on-Thames", "", "GB", "826", "ENG", "N7", "43UB", "", "51.40606", "-0.4137", "Europe/London"),
("2636616", "Stroud", "Страуд", "GB", "826", "ENG", "E6", "23UF", "", "51.75", "-2.2", "Europe/London"),
("2636619", "Strood", "", "GB", "826", "ENG", "G5", "", "", "51.39594", "0.49361", "Europe/London"),
("2636663", "Stretford", "Стретфорд", "GB", "826", "ENG", "O6", "", "", "53.45", "-2.31667", "Europe/London"),
("2636713", "Stratford-upon-Avon", "Стратфорд-на-Эйвоне", "GB", "826", "ENG", "P3", "44UE", "", "52.19166", "-1.70734", "Europe/London"),
("2636749", "Stowmarket", "", "GB", "826", "ENG", "N5", "42UE", "", "52.18893", "0.99774", "Europe/London"),
("2636767", "Stourport-on-Severn", "", "GB", "826", "ENG", "Q4", "47UG", "", "52.35", "-2.26667", "Europe/London"),
("2636769", "Stourbridge", "Стоурбридж", "GB", "826", "ENG", "D7", "47UB", "", "52.45608", "-2.14317", "Europe/London"),
("2636841", "Stoke-on-Trent", "Сток-он-Трент", "GB", "826", "ENG", "N4", "", "", "53.00415", "-2.18538", "Europe/London"),
("2636876", "Stockton-on-Tees", "Стоктон-он-Тис", "GB", "826", "ENG", "N3", "", "", "54.56848", "-1.3187", "Europe/London"),
("2636882", "Stockport", "Стокпорт", "GB", "826", "ENG", "N2", "", "", "53.40979", "-2.15761", "Europe/London"),
("2636910", "Stirling", "Стерлинг", "GB", "826", "SCT", "W6", "", "", "56.11903", "-3.93682", "Europe/London"),
("2636940", "Stevenage", "Стивенедж", "GB", "826", "ENG", "F8", "26UH", "", "51.90224", "-0.20256", "Europe/London"),
("2636995", "Staveley", "", "GB", "826", "ENG", "D3", "17UD", "", "53.26667", "-1.35", "Europe/London"),
("2637104", "Stamford", "Стамфорд", "GB", "826", "ENG", "H7", "32UG", "", "52.65", "-0.48333", "Europe/London"),
("2637106", "Stalybridge", "Сталибридж", "GB", "826", "ENG", "O1", "00BT001", "", "53.48414", "-2.05908", "Europe/London"),
("2637126", "Staines", "", "GB", "826", "ENG", "N7", "43UH", "", "51.43092", "-0.50606", "Europe/London"),
("2637142", "Stafford", "Стаффорд", "GB", "826", "ENG", "M9", "41UG", "", "52.80521", "-2.11636", "Europe/London"),
("2637235", "Spennymoor", "", "GB", "826", "ENG", "D8", "00EJ107", "", "54.6988", "-1.60229", "Europe/London"),
("2637265", "Spalding", "", "GB", "826", "ENG", "H7", "32UF", "", "52.78709", "-0.15141", "Europe/London"),
("2637329", "South Shields", "Саут-Шилдс", "GB", "826", "ENG", "M7", "00EM167", "", "54.99859", "-1.4323", "Europe/London"),
("2637330", "Southsea", "", "GB", "826", "ENG", "K6", "", "", "50.79205", "-1.08593", "Europe/London"),
("2637343", "Southport", "", "GB", "826", "ENG", "L8", "", "", "53.64779", "-3.00648", "Europe/London"),
("2637355", "South Ockendon", "", "GB", "826", "ENG", "E4", "", "", "51.50799", "0.28333", "Europe/London"),
("2637433", "Southend-on-Sea", "Саутенд-он-Си", "GB", "826", "ENG", "M5", "", "", "51.53782", "0.71433", "Europe/London"),
("2637435", "South Elmsall", "", "GB", "826", "ENG", "O7", "00DB020", "", "53.59709", "-1.28034", "Europe/London"),
("2637476", "South Benfleet", "", "GB", "826", "ENG", "E4", "22UE", "", "51.55295", "0.55962", "Europe/London"),
("2637487", "Southampton", "Саутгемптон", "GB", "826", "ENG", "M4", "24UJ", "", "50.90395", "-1.40428", "Europe/London"),
("2637490", "Southall", "", "GB", "826", "ENG", "GLA", "D9", "", "51.50896", "-0.3713", "Europe/London"),
("2637546", "Solihull", "Солихалл", "GB", "826", "ENG", "M2", "00CT008", "", "52.41426", "-1.78094", "Europe/London"),
("2637627", "Slough", "Слау", "GB", "826", "ENG", "M1", "", "", "51.50949", "-0.59541", "Europe/London"),
("2637659", "Sleaford", "", "GB", "826", "ENG", "H7", "32UE", "", "52.99826", "-0.40941", "Europe/London"),
("2637752", "Skelmersdale", "", "GB", "826", "ENG", "H2", "30UP", "", "53.55024", "-2.77348", "Europe/London"),
("2637762", "Skegness", "", "GB", "826", "ENG", "H7", "32UC", "", "53.14362", "0.3363", "Europe/London"),
("2637802", "Sittingbourne", "", "GB", "826", "ENG", "G5", "29UM", "", "51.34128", "0.73282", "Europe/London"),
("2637891", "Shrewsbury", "Шрусбери", "GB", "826", "ENG", "L6", "", "", "52.71009", "-2.75208", "Europe/London"),
("2637916", "Shoreham-by-Sea", "", "GB", "826", "ENG", "P6", "45UB", "45UB002", "50.83413", "-0.27431", "Europe/London"),
("2637917", "Shoreham", "", "GB", "826", "ENG", "G5", "B8", "", "51.3334", "0.17801", "Europe/London"),
("2637958", "Shipley", "", "GB", "826", "ENG", "B4", "", "", "53.83333", "-1.76667", "Europe/London"),
("2638077", "Sheffield", "Шеффилд", "GB", "826", "ENG", "L9", "", "", "53.38297", "-1.4659", "Europe/London"),
("2638187", "Sevenoaks", "Севенокс", "GB", "826", "ENG", "G5", "6945814", "", "51.26997", "0.19278", "Europe/London"),
("2638235", "Selby", "Селби", "GB", "826", "ENG", "J7", "36UH", "", "53.78333", "-1.06667", "Europe/London"),
("2638302", "Seaham", "Сихем", "GB", "826", "ENG", "D8", "00EJ096", "", "54.83903", "-1.34575", "Europe/London"),
("2638311", "Seaford", "", "GB", "826", "ENG", "E2", "21UF", "", "50.77141", "0.10268", "Europe/London"),
("2638324", "Scunthorpe", "Сканторпе", "GB", "826", "ENG", "J3", "", "", "53.57905", "-0.65437", "Europe/London"),
("2638419", "Scarborough", "Скарборо", "GB", "826", "ENG", "J7", "36UG", "", "54.27966", "-0.40443", "Europe/London"),
("2638568", "Sandown", "Сандаун", "GB", "826", "ENG", "G2", "00MW018", "", "50.65158", "-1.16103", "Europe/London"),
("2638600", "Sandbach", "", "GB", "826", "ENG", "Z7", "00EQ113", "", "53.14515", "-2.36251", "Europe/London"),
("2638664", "Salisbury", "Солсбери", "GB", "826", "ENG", "P8", "00HY261", "", "51.06931", "-1.79569", "Europe/London"),
("2638671", "Salford", "Солфорд", "GB", "826", "ENG", "L5", "", "", "53.48771", "-2.29042", "Europe/London"),
("2638678", "Sale", "Сейл", "GB", "826", "ENG", "O6", "00BU001", "", "53.42519", "-2.32443", "Europe/London"),
("2638717", "Saint Neots", "", "GB", "826", "ENG", "C3", "12UE", "", "52.21667", "-0.26667", "Europe/London"),
("2638785", "St Helens", "Сент-Хеленс", "GB", "826", "ENG", "N1", "", "", "53.45", "-2.73333", "Europe/London"),
("2638853", "St Austell", "", "GB", "826", "ENG", "C6", "00HE131", "", "50.3425", "-4.77442", "Europe/London"),
("2638864", "Saint Andrews", "Сент-Андрус", "GB", "826", "SCT", "V1", "", "", "56.33871", "-2.79902", "Europe/London"),
("2638867", "St Albans", "Сент-Олбанс", "GB", "826", "ENG", "F8", "6615330", "", "51.75", "-0.33333", "Europe/London"),
("2638894", "Ryton", "", "GB", "826", "ENG", "L6", "00GG155", "", "52.61667", "-2.35", "Europe/London"),
("2638911", "Ryde", "Райд", "GB", "826", "ENG", "G2", "00MW032", "", "50.72999", "-1.1621", "Europe/London"),
("2638926", "Rutherglen", "", "GB", "826", "SCT", "W5", "", "", "55.82885", "-4.21376", "Europe/London"),
("2638946", "Rushden", "", "GB", "826", "ENG", "J1", "34UD", "", "52.29139", "-0.59923", "Europe/London"),
("2638960", "Runcorn", "", "GB", "826", "ENG", "E9", "00ET005", "", "53.34174", "-2.73124", "Europe/London"),
("2638976", "Ruislip", "", "GB", "826", "ENG", "GLA", "F9", "", "51.57344", "-0.42341", "Europe/London"),
("2638977", "Rugeley", "", "GB", "826", "ENG", "M9", "41UB", "", "52.7593", "-1.93694", "Europe/London"),
("2638978", "Rugby", "Рагби", "GB", "826", "ENG", "P3", "44UD", "", "52.37092", "-1.26417", "Europe/London"),
("2639015", "Royton", "", "GB", "826", "ENG", "K1", "00BP002", "", "53.56507", "-2.12267", "Europe/London"),
("2639022", "Royal Tunbridge Wells", "", "GB", "826", "ENG", "G5", "29UQ", "", "51.13245", "0.26333", "Europe/London"),
("2639069", "Rottingdean", "", "GB", "826", "ENG", "B6", "00ML001", "", "50.80984", "-0.05939", "Europe/London"),
("2639093", "Rotherham", "Ротерем", "GB", "826", "ENG", "L3", "00CF004", "", "53.43012", "-1.35678", "Europe/London"),
("2639189", "Romsey", "", "GB", "826", "ENG", "F2", "24UN", "", "50.98906", "-1.49989", "Europe/London"),
("2639265", "Rochford", "", "GB", "826", "ENG", "E4", "22UL", "", "51.58198", "0.70673", "Europe/London"),
("2639268", "Rochester", "Рочестер", "GB", "826", "ENG", "I3", "", "", "51.38764", "0.50546", "Europe/London"),
("2639272", "Rochdale", "Рочдейл", "GB", "826", "ENG", "L2", "30UM", "", "53.61766", "-2.1552", "Europe/London"),
("2639317", "Risca", "", "GB", "826", "WLS", "X4", "00PK023", "", "51.60799", "-3.10081", "Europe/London"),
("2639323", "Ripon", "Рипон", "GB", "826", "ENG", "J7", "36UD", "", "54.13521", "-1.52122", "Europe/London"),
("2639325", "Ripley", "Рипли", "GB", "826", "ENG", "D3", "17UB", "", "53.03333", "-1.4", "Europe/London"),
("2639409", "Rhyl", "Рил", "GB", "826", "WLS", "X9", "00NG035", "", "53.31955", "-3.48862", "Europe/London"),
("2639447", "Rhondda", "", "GB", "826", "WLS", "Y9", "00PF007", "", "51.65896", "-3.44885", "Europe/London"),
("2639495", "Renfrew", "Ренфру", "GB", "826", "SCT", "W2", "", "", "55.87197", "-4.39253", "Europe/London"),
("2639506", "Reigate", "Райгейт", "GB", "826", "ENG", "N7", "43UF", "", "51.23758", "-0.2078", "Europe/London"),
("2639545", "Redhill", "", "GB", "826", "ENG", "N7", "43UF", "", "51.24048", "-0.17044", "Europe/London"),
("2639557", "Redditch", "Реддитч", "GB", "826", "ENG", "Q4", "47UD", "", "52.3065", "-1.94569", "Europe/London"),
("2639563", "Redcar", "", "GB", "826", "ENG", "K9", "00EE004", "", "54.61657", "-1.05999", "Europe/London"),
("2639577", "Reading", "Рединг", "GB", "826", "ENG", "K7", "", "", "51.45625", "-0.97113", "Europe/London"),
("2639583", "Rayleigh", "", "GB", "826", "ENG", "E4", "22UL", "", "51.58571", "0.60459", "Europe/London"),
("2639586", "Rawtenstall", "", "GB", "826", "ENG", "H2", "30UM", "", "53.70076", "-2.28442", "Europe/London"),
("2639588", "Rawmarsh", "", "GB", "826", "ENG", "L3", "00CF024", "", "53.46062", "-1.34437", "Europe/London"),
("2639660", "Ramsgate", "Рамсгейт", "GB", "826", "ENG", "G5", "2636057", "29UN010", "51.33576", "1.41552", "Europe/London"),
("2639668", "Ramsbottom", "", "GB", "826", "ENG", "C1", "", "", "53.64789", "-2.31683", "Europe/London"),
("2639842", "Purley", "", "GB", "826", "ENG", "GLA", "C8", "", "51.33678", "-0.11201", "Europe/London"),
("2639866", "Pudsey", "", "GB", "826", "ENG", "H3", "", "", "53.79538", "-1.66134", "Europe/London"),
("2639896", "Prestwick", "Престуик", "GB", "826", "SCT", "W4", "", "", "55.48333", "-4.61667", "Europe/London"),
("2639897", "Prestwich", "", "GB", "826", "ENG", "C1", "", "", "53.53333", "-2.28333", "Europe/London"),
("2639912", "Preston", "Престон", "GB", "826", "ENG", "H2", "30UK", "", "53.76667", "-2.71667", "Europe/London"),
("2639926", "Prestatyn", "", "GB", "826", "WLS", "X9", "00NG033", "", "53.33748", "-3.40776", "Europe/London"),
("2639928", "Prescot", "", "GB", "826", "ENG", "G9", "00BX004", "", "53.42948", "-2.80031", "Europe/London"),
("2639958", "Poulton le Fylde", "", "GB", "826", "ENG", "H2", "30UQ", "", "53.83333", "-2.98333", "Europe/London"),
("2639970", "Potters Bar", "", "GB", "826", "ENG", "F8", "26UE", "", "51.69353", "-0.17835", "Europe/London"),
("2639996", "Portsmouth", "Портсмут", "GB", "826", "ENG", "K6", "00MR001", "", "50.79899", "-1.09125", "Europe/London"),
("2639998", "Portslade", "", "GB", "826", "ENG", "E2", "", "", "50.84335", "-0.21544", "Europe/London"),
("2640037", "Portishead", "", "GB", "826", "ENG", "J4", "00HC027", "", "51.48199", "-2.76973", "Europe/London"),
("2640054", "Porthcawl", "", "GB", "826", "WLS", "X3", "00PB017", "", "51.47903", "-3.70362", "Europe/London"),
("2640060", "Port Glasgow", "", "GB", "826", "SCT", "V4", "", "", "55.93464", "-4.6895", "Europe/London"),
("2640101", "Poole", "Пул", "GB", "826", "ENG", "K5", "", "", "50.71667", "-2", "Europe/London"),
("2640104", "Pontypridd", "Понтиприте", "GB", "826", "WLS", "Y9", "00PF023", "", "51.6021", "-3.34211", "Europe/London"),
("2640106", "Pontypool", "", "GB", "826", "WLS", "Z2", "", "", "51.70111", "-3.04444", "Europe/London"),
("2640132", "Pontefract", "", "GB", "826", "ENG", "O7", "", "", "53.69107", "-1.31269", "Europe/London"),
("2640155", "Polmont", "Полмонте", "GB", "826", "SCT", "U9", "", "", "55.9905", "-3.70737", "Europe/London"),
("2640190", "Plymstock", "", "GB", "826", "ENG", "K4", "18UG", "", "50.35999", "-4.09049", "Europe/London"),
("2640194", "Plymouth", "Плимут", "GB", "826", "ENG", "K4", "", "", "50.37153", "-4.14305", "Europe/London"),
("2640246", "Pitsea", "", "GB", "826", "ENG", "E4", "22UB", "", "51.56387", "0.50859", "Europe/London"),
("2640275", "Pinner", "", "GB", "826", "ENG", "GLA", "F4", "", "51.59384", "-0.38216", "Europe/London"),
("2640349", "Peterlee", "Петерли", "GB", "826", "ENG", "D8", "00EJ088", "", "54.76032", "-1.33649", "Europe/London"),
("2640351", "Peterhead", "", "GB", "826", "SCT", "T6", "", "", "57.50584", "-1.79806", "Europe/London"),
("2640354", "Peterborough", "Питерборо", "GB", "826", "ENG", "K3", "00JA016", "", "52.57364", "-0.24777", "Europe/London"),
("2640358", "Perth", "Перт", "GB", "826", "SCT", "W1", "", "", "56.39522", "-3.43139", "Europe/London"),
("2640377", "Penzance", "Пензанс", "GB", "826", "ENG", "C6", "00HE107", "", "50.11861", "-5.53715", "Europe/London"),
("2640465", "Penicuik", "", "GB", "826", "SCT", "V5", "", "", "55.83166", "-3.22423", "Europe/London"),
("2640496", "Penarth", "", "GB", "826", "WLS", "Z3", "00PD014", "", "51.4386", "-3.17342", "Europe/London"),
("2640677", "Paisley", "Пейсли", "GB", "826", "SCT", "W2", "", "", "55.83173", "-4.43254", "Europe/London"),
("2640681", "Paignton", "Пэйнтон", "GB", "826", "ENG", "O4", "18UG", "", "50.43565", "-3.56789", "Europe/London"),
("2640729", "Oxford", "Оксфорд", "GB", "826", "ENG", "K2", "38UC", "", "51.75222", "-1.25596", "Europe/London"),
("2640861", "Oswestry", "Освестри", "GB", "826", "ENG", "L6", "00GG140", "", "52.86195", "-3.05497", "Europe/London"),
("2640869", "Ossett", "Оссетт", "GB", "826", "ENG", "O7", "", "", "53.67978", "-1.58006", "Europe/London"),
("2640894", "Orpington", "", "GB", "826", "ENG", "GLA", "B8", "", "51.37457", "0.09785", "Europe/London"),
("2640908", "Ormskirk", "", "GB", "826", "ENG", "H2", "30UP", "", "53.56685", "-2.88178", "Europe/London"),
("2640967", "Omagh", "Ома", "GB", "826", "NIR", "T3", "", "", "54.6", "-7.3", "Europe/London"),
("2641022", "Oldham", "Олдем", "GB", "826", "ENG", "K1", "", "", "53.54051", "-2.1183", "Europe/London"),
("2641134", "Oadby", "", "GB", "826", "ENG", "H5", "31UJ", "", "52.60621", "-1.08354", "Europe/London"),
("2641157", "Nuneaton", "Нанитон", "GB", "826", "ENG", "P3", "44UC", "", "52.52323", "-1.46523", "Europe/London"),
("2641170", "Nottingham", "Ноттингем", "GB", "826", "ENG", "J8", "", "", "52.9536", "-1.15047", "Europe/London"),
("2641181", "Norwich", "Норидж", "GB", "826", "ENG", "I9", "33UG", "", "52.62783", "1.29834", "Europe/London"),
("2641224", "Northwich", "Нортвич", "GB", "826", "ENG", "Z8", "00EW119", "", "53.26138", "-2.51225", "Europe/London"),
("2641267", "North Shields", "", "GB", "826", "ENG", "J5", "", "", "55.01646", "-1.44925", "Europe/London"),
("2641290", "Northolt", "", "GB", "826", "ENG", "GLA", "D9", "", "51.54855", "-0.36778", "Europe/London"),
("2641319", "Lancing", "", "GB", "826", "ENG", "P6", "45UB", "", "50.82882", "-0.32247", "Europe/London"),
("2641430", "Northampton", "Нортгемптон", "GB", "826", "ENG", "J1", "34UF", "", "52.25", "-0.88333", "Europe/London"),
("2641435", "Northallerton", "", "GB", "826", "ENG", "J7", "36UC", "", "54.33901", "-1.43243", "Europe/London"),
("2641519", "Newtownards", "Ньютаунардс", "GB", "826", "NIR", "Q7", "", "", "54.59236", "-5.69092", "Europe/London"),
("2641520", "Newtownabbey", "Ньютонэббей", "GB", "826", "NIR", "T1", "", "", "54.65983", "-5.90858", "Europe/London"),
("2641544", "Newton Mearns", "", "GB", "826", "SCT", "U7", "", "", "55.77334", "-4.33339", "Europe/London"),
("2641546", "Newton-le-Willows", "", "GB", "826", "ENG", "N1", "", "", "53.45", "-2.6", "Europe/London"),
("2641555", "Newton Aycliffe", "", "GB", "826", "ENG", "D8", "00EJ045", "", "54.61842", "-1.5719", "Europe/London"),
("2641557", "Newton Abbot", "Ньютон-Эббот", "GB", "826", "ENG", "D4", "18UH", "", "50.52858", "-3.61186", "Europe/London"),
("2641581", "Newry", "Ньюри", "GB", "826", "NIR", "S9", "", "", "54.17841", "-6.33739", "Europe/London"),
("2641589", "Newquay", "", "GB", "826", "ENG", "C6", "00HE097", "", "50.41317", "-5.08186", "Europe/London"),
("2641591", "Newport Pagnell", "", "GB", "826", "ENG", "I6", "00MG022", "", "52.08731", "-0.72218", "Europe/London"),
("2641598", "Newport", "Ньюпорт", "GB", "826", "WLS", "Y6", "", "", "51.58774", "-2.99835", "Europe/London"),
("2641599", "Newport", "Ньюпорт", "GB", "826", "ENG", "G2", "", "", "50.70146", "-1.29124", "Europe/London"),
("2641609", "New Milton", "", "GB", "826", "ENG", "F2", "24UJ", "", "50.75601", "-1.6658", "Europe/London"),
("2641616", "Newmarket", "Ньюмаркет", "GB", "826", "ENG", "N5", "42UC", "", "52.24467", "0.40418", "Europe/London"),
("2641617", "New Malden", "", "GB", "826", "ENG", "GLA", "G7", "", "51.39915", "-0.2556", "Europe/London"),
("2641673", "Newcastle upon Tyne", "Ньюкасл", "GB", "826", "ENG", "I7", "", "", "54.97328", "-1.61396", "Europe/London"),
("2641674", "Newcastle under Lyme", "", "GB", "826", "ENG", "M9", "41UE", "", "53", "-2.23333", "Europe/London"),
("2641689", "Newbury", "Ньюбери", "GB", "826", "ENG", "P4", "00MB062", "", "51.40033", "-1.32059", "Europe/London"),
("2641690", "Newburn", "", "GB", "826", "ENG", "I7", "00EM073", "", "54.9876", "-1.74415", "Europe/London"),
("2641731", "Newark on Trent", "", "GB", "826", "ENG", "J9", "37UG", "", "53.06667", "-0.81667", "Europe/London"),
("2641810", "Nelson", "", "GB", "826", "ENG", "H2", "30UJ", "", "53.83333", "-2.2", "Europe/London"),
("2641843", "Neath", "Нит", "GB", "826", "WLS", "Y5", "00NZ020", "", "51.66317", "-3.80443", "Europe/London"),
("2641913", "Nailsea", "", "GB", "826", "ENG", "J4", "00HC025", "", "51.43239", "-2.75847", "Europe/London"),
("2641942", "Musselburgh", "Масселборо", "GB", "826", "SCT", "U6", "", "", "55.9417", "-3.04991", "Europe/London"),
("2642135", "Motherwell", "Мазервелл", "GB", "826", "SCT", "V8", "", "", "55.78924", "-3.99187", "Europe/London"),
("2642189", "Morley", "", "GB", "826", "ENG", "H3", "00DA030", "", "53.74013", "-1.59877", "Europe/London"),
("2642204", "Moreton", "", "GB", "826", "ENG", "Q1", "", "", "53.4", "-3.11667", "Europe/London"),
("2642214", "Morecambe", "Моркам", "GB", "826", "ENG", "H2", "30UH", "", "54.06835", "-2.86108", "Europe/London"),
("2642414", "Mitcham", "", "GB", "826", "ENG", "GLA", "I4", "", "51.40474", "-0.16404", "Europe/London"),
("2642423", "Mirfield", "", "GB", "826", "ENG", "G8", "00CZ005", "", "53.67343", "-1.69636", "Europe/London"),
("2642465", "Milton Keynes", "Милтон-Кинс", "GB", "826", "ENG", "I6", "", "", "52.04172", "-0.75583", "Europe/London"),
("2642593", "Middleton", "", "GB", "826", "ENG", "L2", "", "", "53.55", "-2.2", "Europe/London"),
("2642607", "Middlesbrough", "Мидлсбро", "GB", "826", "ENG", "I5", "00EF019", "", "54.57623", "-1.23483", "Europe/London"),
("2642683", "Mexborough", "", "GB", "826", "ENG", "D5", "00CE017", "", "53.49389", "-1.29243", "Europe/London"),
("2642705", "Merthyr Tydfil", "Мертир-Тидвил", "GB", "826", "WLS", "Y3", "00PH009", "", "51.74794", "-3.37779", "Europe/London"),
("2642763", "Melton Mowbray", "", "GB", "826", "ENG", "H5", "31UG", "", "52.76588", "-0.88693", "Europe/London"),
("2642999", "Marple", "", "GB", "826", "ENG", "N2", "00EQ047", "", "53.39452", "-2.06292", "Europe/London"),
("2643003", "Marlow", "", "GB", "826", "ENG", "B9", "11UF", "", "51.56933", "-0.77415", "Europe/London"),
("2643027", "Market Harborough", "", "GB", "826", "ENG", "H5", "31UD", "", "52.4776", "-0.92053", "Europe/London"),
("2643044", "Margate", "Маргит", "GB", "826", "ENG", "G5", "2636057", "", "51.38132", "1.38617", "Europe/London"),
("2643071", "March", "", "GB", "826", "ENG", "C3", "12UD", "", "52.55131", "0.08828", "Europe/London"),
("2643096", "Mansfield Woodhouse", "", "GB", "826", "ENG", "J9", "37UF", "", "53.16495", "-1.19384", "Europe/London"),
("2643097", "Mansfield", "Мэнсфилд", "GB", "826", "ENG", "J9", "37UF", "", "53.13333", "-1.2", "Europe/London"),
("2643116", "Mangotsfield", "", "GB", "826", "ENG", "M6", "00HD045", "", "51.4878", "-2.50403", "Europe/London"),
("2643123", "Manchester", "Манчестер", "GB", "826", "ENG", "I2", "", "", "53.48095", "-2.23743", "Europe/London"),
("2643144", "Maltby", "", "GB", "826", "ENG", "L3", "00CF029", "", "53.41667", "-1.2", "Europe/London"),
("2643160", "Maldon", "Мелдона", "GB", "826", "ENG", "E4", "22UK", "", "51.7311", "0.67463", "Europe/London"),
("2643179", "Maidstone", "Мейдстон", "GB", "826", "ENG", "G5", "29UH", "", "51.26667", "0.51667", "Europe/London"),
("2643186", "Maidenhead", "Мейденхед", "GB", "826", "ENG", "P9", "", "", "51.52279", "-0.71986", "Europe/London"),
("2643198", "Maghull", "", "GB", "826", "ENG", "L8", "00CA005", "", "53.51619", "-2.94117", "Europe/London"),
("2643218", "Maesteg", "", "GB", "826", "WLS", "X3", "00PB012", "", "51.60926", "-3.65823", "Europe/London"),
("2643266", "Macclesfield", "", "GB", "826", "ENG", "Z7", "00EQ124", "", "53.26023", "-2.12564", "Europe/London"),
("2643339", "Luton", "Лутон", "GB", "826", "ENG", "I1", "00KC039", "", "51.87967", "-0.41748", "Europe/London"),
("2643490", "Lowestoft", "Лоустофт", "GB", "826", "ENG", "N5", "42UH", "", "52.4752", "1.75159", "Europe/London"),
("2643553", "Louth", "Лаут", "GB", "826", "ENG", "H7", "32UC", "", "53.36664", "-0.00438", "Europe/London"),
("2643567", "Loughborough", "Лафборо", "GB", "826", "ENG", "H5", "31UC", "", "52.76667", "-1.2", "Europe/London"),
("2643696", "Longfield", "", "GB", "826", "ENG", "G5", "29UD", "", "51.3969", "0.30212", "Europe/London"),
("2643697", "Long Eaton", "", "GB", "826", "ENG", "D3", "17UG", "", "52.89855", "-1.27136", "Europe/London"),
("2643734", "Londonderry County Borough", "", "GB", "826", "NIR", "", "", "", "54.99721", "-7.30917", "Europe/London"),
("2643736", "Derry", "Дерри", "GB", "826", "NIR", "S6", "", "", "54.9981", "-7.30934", "Europe/London"),
("2643741", "City of London", "Сити", "GB", "826", "ENG", "GLA", "H9", "", "51.51279", "-0.09184", "Europe/London"),
("2643743", "London", "Лондон", "GB", "826", "ENG", "GLA", "", "", "51.50853", "-0.12574", "Europe/London"),
("2643776", "Lofthouse", "", "GB", "826", "ENG", "H3", "", "", "53.72947", "-1.49697", "Europe/London"),
("2644100", "Llanelli", "Лланелли", "GB", "826", "WLS", "X7", "00NU032", "", "51.68195", "-4.16191", "Europe/London"),
("2644120", "Llandudno", "Лландидно", "GB", "826", "WLS", "X8", "00NE018", "", "53.32498", "-3.83148", "Europe/London"),
("2644204", "Livingston", "Ливингстон", "GB", "826", "SCT", "W9", "", "", "55.90288", "-3.52261", "Europe/London"),
("2644210", "Liverpool", "Ливерпуль", "GB", "826", "ENG", "H8", "", "", "53.41058", "-2.97794", "Europe/London"),
("2644319", "Littlehampton", "", "GB", "826", "ENG", "P6", "45UC", "", "50.80691", "-0.53782", "Europe/London"),
("2644386", "Litherland", "", "GB", "826", "ENG", "L8", "00CA007", "", "53.46993", "-2.99809", "Europe/London"),
("2644411", "Lisburn", "Лисберн", "GB", "826", "NIR", "S5", "", "", "54.52337", "-6.03527", "Europe/London"),
("2644487", "Lincoln", "Линкольн", "GB", "826", "ENG", "H7", "32UD", "", "53.22683", "-0.53792", "Europe/London"),
("2644531", "Lichfield", "Личфилд", "GB", "826", "ENG", "M9", "41UD", "", "52.68154", "-1.82549", "Europe/London"),
("2644547", "Leyland", "", "GB", "826", "ENG", "H2", "30UN", "", "53.69786", "-2.68758", "Europe/London"),
("2644559", "Lewes", "Льюис", "GB", "826", "ENG", "E2", "21UF", "", "50.87363", "0.01133", "Europe/London"),
("2644597", "Letchworth", "Лечуорт", "GB", "826", "ENG", "F8", "26UF", "", "51.97944", "-0.2284", "Europe/London"),
("2644652", "Leighton Buzzard", "", "GB", "826", "ENG", "Z6", "00KC042", "", "51.91722", "-0.65802", "Europe/London"),
("2644660", "Leigh", "", "GB", "826", "ENG", "P7", "", "", "53.48333", "-2.51667", "Europe/London"),
("2644668", "Leicester", "Лестер", "GB", "826", "ENG", "H4", "31UC", "", "52.6386", "-1.13169", "Europe/London"),
("2644684", "Leek", "", "GB", "826", "ENG", "M9", "41UH", "", "53.10434", "-2.02207", "Europe/London"),
("2644688", "Leeds", "Лидс", "GB", "826", "ENG", "H3", "", "", "53.79648", "-1.54785", "Europe/London"),
("2644726", "Leatherhead", "", "GB", "826", "ENG", "N7", "43UE", "", "51.29593", "-0.3259", "Europe/London"),
("2644737", "Royal Leamington Spa", "Лемингтон Спа", "GB", "826", "ENG", "P3", "44UF", "", "52.3", "-1.53333", "Europe/London"),
("2644849", "Larne", "Ларн", "GB", "826", "NIR", "S3", "", "", "54.85", "-5.81667", "Europe/London"),
("2644853", "Larkhall", "", "GB", "826", "SCT", "W5", "", "", "55.73333", "-3.96667", "Europe/London"),
("2644972", "Lancaster", "Ланкастер", "GB", "826", "ENG", "H2", "30UH", "", "54.04649", "-2.79988", "Europe/London"),
("2645261", "Kirkintilloch", "Керкинтиллох", "GB", "826", "SCT", "U5", "", "", "55.93933", "-4.15262", "Europe/London"),
("2645298", "Kirkcaldy", "Керколди", "GB", "826", "SCT", "V1", "", "", "56.10982", "-3.16149", "Europe/London"),
("2645309", "Kirkby in Ashfield", "", "GB", "826", "ENG", "J9", "37UB", "", "53.09982", "-1.24379", "Europe/London"),
("2645313", "Kirkby", "Керби", "GB", "826", "ENG", "G9", "", "", "53.48333", "-2.9", "Europe/London"),
("2645418", "Kingswood", "Кингсвуд", "GB", "826", "ENG", "M6", "", "", "51.45278", "-2.50833", "Europe/London"),
("2645420", "Kingswinford", "", "GB", "826", "ENG", "D7", "41UF", "", "52.49755", "-2.16889", "Europe/London"),
("2645425", "Hull", "Кингстон-апон-Халл", "GB", "826", "ENG", "G6", "", "", "53.7446", "-0.33525", "Europe/London"),
("2645456", "King's Lynn", "Кингслинн", "GB", "826", "ENG", "I9", "33UE", "", "52.75172", "0.39516", "Europe/London"),
("2645541", "Kilwinning", "Килуиннинг", "GB", "826", "SCT", "V7", "", "", "55.65333", "-4.70666", "Europe/London"),
("2645605", "Kilmarnock", "Килмарнок", "GB", "826", "SCT", "U4", "", "", "55.61171", "-4.49581", "Europe/London"),
("2645721", "Kidsgrove", "", "GB", "826", "ENG", "M9", "41UE", "", "53.08691", "-2.23777", "Europe/London"),
("2645722", "Kidlington", "", "GB", "826", "ENG", "K2", "38UB", "", "51.82166", "-1.2886", "Europe/London"),
("2645724", "Kidderminster", "", "GB", "826", "ENG", "Q4", "47UG", "", "52.38819", "-2.25", "Europe/London"),
("2645733", "Keynsham", "", "GB", "826", "ENG", "A4", "00HA026", "", "51.41387", "-2.4978", "Europe/London"),
("2645753", "Kettering", "Кеттеринг", "GB", "826", "ENG", "J1", "34UE", "", "52.39836", "-0.72571", "Europe/London"),
("2645822", "Kenilworth", "", "GB", "826", "ENG", "P3", "44UF", "", "52.34286", "-1.58015", "Europe/London"),
("2645826", "Kendal", "Кендал", "GB", "826", "ENG", "C9", "16UG", "", "54.32681", "-2.74757", "Europe/London"),
("2645831", "Kempston", "", "GB", "826", "ENG", "Z5", "00KB018", "", "52.11599", "-0.50044", "Europe/London"),
("2645889", "Keighley", "Кейли", "GB", "826", "ENG", "B4", "00CX009", "", "53.86791", "-1.90664", "Europe/London"),
("2645951", "Johnstone", "", "GB", "826", "SCT", "W2", "", "", "55.82906", "-4.51605", "Europe/London"),
("2645972", "Jarrow", "Джарроу", "GB", "826", "ENG", "M7", "00EM167", "", "54.98036", "-1.48423", "Europe/London"),
("2646003", "Islington", "Ислингтон", "GB", "826", "ENG", "GLA", "G3", "", "51.53622", "-0.10304", "Europe/London"),
("2646004", "Isleworth", "", "GB", "826", "ENG", "GLA", "G1", "", "51.47518", "-0.34246", "Europe/London"),
("2646032", "Irvine", "Эрвин", "GB", "826", "SCT", "V7", "", "", "55.6194", "-4.65508", "Europe/London"),
("2646042", "Irlam", "", "GB", "826", "ENG", "L5", "00BU001", "", "53.44253", "-2.42323", "Europe/London"),
("2646057", "Ipswich", "Ипсуич", "GB", "826", "ENG", "N5", "42UD", "", "52.05917", "1.15545", "Europe/London"),
("2646088", "Inverness", "Инвернесс", "GB", "826", "SCT", "V3", "", "", "57.47908", "-4.22398", "Europe/London"),
("2646274", "Ilkeston", "", "GB", "826", "ENG", "D3", "17UG", "", "52.97055", "-1.30951", "Europe/London"),
("2646317", "Hythe", "", "GB", "826", "ENG", "F2", "24UJ", "", "50.86004", "-1.40162", "Europe/London"),
("2646327", "Hyde", "", "GB", "826", "ENG", "O1", "", "", "53.45131", "-2.07943", "Europe/London"),
("2646329", "Huyton", "Хейтон", "GB", "826", "ENG", "G9", "00BX006", "", "53.4115", "-2.83935", "Europe/London"),
("2646393", "Huntingdon", "The Huntingdon", "GB", "826", "ENG", "C3", "12UE", "12UE046", "52.33049", "-0.18651", "Europe/London"),
("2646458", "Huddersfield", "Хаддерсфилд", "GB", "826", "ENG", "G8", "00CZ003", "", "53.64904", "-1.78416", "Europe/London"),
("2646460", "Hucknall", "", "GB", "826", "ENG", "J9", "37UB", "", "53.03333", "-1.2", "Europe/London"),
("2646471", "Hoyland Nether", "", "GB", "826", "ENG", "A3", "", "", "53.5", "-1.45", "Europe/London"),
("2646504", "Hove", "Хов", "GB", "826", "ENG", "B6", "45UG", "", "50.83088", "-0.1672", "Europe/London"),
("2646525", "Houghton-le-Spring", "", "GB", "826", "ENG", "D8", "", "", "54.84034", "-1.46427", "Europe/London"),
("2646542", "Horwich", "", "GB", "826", "ENG", "B1", "00BL002", "", "53.60126", "-2.54975", "Europe/London"),
("2646557", "Horsham", "Хоршэм", "GB", "826", "ENG", "P6", "45UF", "", "51.06395", "-0.32719", "Europe/London"),
("2646558", "Horsforth", "", "GB", "826", "ENG", "H3", "00DA032", "", "53.83797", "-1.64036", "Europe/London"),
("2646606", "Horley", "", "GB", "826", "ENG", "N7", "43UF", "", "51.17423", "-0.15919", "Europe/London"),
("2646807", "Hoddesdon", "Ходдсдон", "GB", "826", "ENG", "F8", "26UB", "", "51.76148", "-0.01144", "Europe/London"),
("2646826", "Hitchin", "", "GB", "826", "ENG", "F8", "26UF", "", "51.95314", "-0.26519", "Europe/London"),
("2646862", "Hindley", "", "GB", "826", "ENG", "P7", "", "", "53.53333", "-2.58333", "Europe/London"),
("2646867", "Hinckley", "Хинкли", "GB", "826", "ENG", "H5", "31UE", "", "52.5389", "-1.37613", "Europe/London"),
("2646914", "High Wycombe", "Хай-Уиком", "GB", "826", "ENG", "B9", "11UF", "", "51.62907", "-0.74934", "Europe/London"),
("2646979", "High Blantyre", "", "GB", "826", "SCT", "W5", "", "", "55.78438", "-4.10007", "Europe/London"),
("2647026", "Heswall", "", "GB", "826", "ENG", "Q1", "00EW114", "", "53.32733", "-3.09648", "Europe/London"),
("2647044", "Hertford", "Хертфорд", "GB", "826", "ENG", "F8", "26UD", "", "51.79588", "-0.07854", "Europe/London"),
("2647057", "Herne Bay", "", "GB", "826", "ENG", "G5", "6945807", "", "51.373", "1.12857", "Europe/London"),
("2647074", "Hereford", "Херефорде", "GB", "826", "ENG", "F7", "00GA240", "", "52.05684", "-2.71482", "Europe/London"),
("2647138", "Hemel Hempstead", "", "GB", "826", "ENG", "F8", "26UC", "", "51.75369", "-0.47517", "Europe/London"),
("2647209", "Hebburn", "", "GB", "826", "ENG", "M7", "", "", "54.97302", "-1.51546", "Europe/London"),
("2647227", "Heanor", "", "GB", "826", "ENG", "D3", "17UB", "", "53.01372", "-1.35383", "Europe/London"),
("2647246", "Hazel Grove", "", "GB", "826", "ENG", "N2", "", "", "53.38333", "-2.11667", "Europe/London"),
("2647248", "Haywards Heath", "", "GB", "826", "ENG", "P6", "45UG", "", "50.99769", "-0.10313", "Europe/London"),
("2647261", "Hayes", "", "GB", "826", "ENG", "GLA", "F9", "", "51.51579", "-0.4234", "Europe/London"),
("2647265", "Haydock", "", "GB", "826", "ENG", "N1", "00EU003", "", "53.46723", "-2.68166", "Europe/London"),
("2647303", "Hawarden", "Хаварден", "GB", "826", "WLS", "Y1", "00NJ012", "", "53.18478", "-3.02578", "Europe/London"),
("2647310", "Haverhill", "", "GB", "826", "ENG", "N5", "42UF", "", "52.08226", "0.43891", "Europe/London"),
("2647317", "Havant", "Хавант", "GB", "826", "ENG", "F2", "24UH", "", "50.8567", "-0.98559", "Europe/London"),
("2647349", "Hatfield", "", "GB", "826", "ENG", "F8", "26UL", "", "51.76338", "-0.22419", "Europe/London"),
("2647356", "Hastings", "Гастингс", "GB", "826", "ENG", "E2", "21UD", "", "50.85519", "0.57292", "Europe/London"),
("2647363", "Haslingden", "", "GB", "826", "ENG", "H2", "30UM", "", "53.70326", "-2.32382", "Europe/London"),
("2647383", "Harwich", "Харвич", "GB", "826", "ENG", "E4", "22UN", "", "51.94194", "1.28437", "Europe/London"),
("2647400", "Hartlepool", "Хартлпул", "GB", "826", "ENG", "F5", "", "", "54.68611", "-1.2125", "Europe/London"),
("2647428", "Harrogate", "Харрогейт", "GB", "826", "ENG", "J7", "36UD", "", "53.99078", "-1.5373", "Europe/London"),
("2647451", "Harpenden", "", "GB", "826", "ENG", "F8", "6615330", "", "51.81684", "-0.35706", "Europe/London"),
("2647461", "Harlow", "Харлоу", "GB", "826", "ENG", "E4", "22UJ", "", "51.77655", "0.11158", "Europe/London"),
("2647550", "Hampton", "", "GB", "826", "ENG", "GLA", "L1", "", "51.41334", "-0.36701", "Europe/London"),
("2647570", "Hamilton", "Гамильтон", "GB", "826", "SCT", "W5", "", "", "55.76667", "-4.03333", "Europe/London"),
("2647632", "Halifax", "Галифакс", "GB", "826", "ENG", "C2", "", "", "53.71667", "-1.85", "Europe/London"),
("2647639", "Halesowen", "Хейлсовен", "GB", "826", "ENG", "D7", "47UB", "", "52.44859", "-2.04938", "Europe/London"),
("2647644", "Hale", "", "GB", "826", "ENG", "N7", "43UL", "", "51.21667", "-0.78333", "Europe/London"),
("2647655", "Hailsham", "", "GB", "826", "ENG", "E2", "21UH", "", "50.8622", "0.25775", "Europe/London"),
("2647679", "Hadleigh", "", "GB", "826", "ENG", "E4", "22UE", "", "51.55269", "0.60983", "Europe/London"),
("2647784", "Guiseley", "", "GB", "826", "ENG", "H3", "", "", "53.87561", "-1.71232", "Europe/London"),
("2647785", "Guisborough", "", "GB", "826", "ENG", "K9", "00EE001", "", "54.53478", "-1.05606", "Europe/London"),
("2647793", "Guildford", "Гилфорд", "GB", "826", "ENG", "N7", "43UD", "", "51.23536", "-0.57427", "Europe/London"),
("2647837", "Grove", "", "GB", "826", "ENG", "K2", "38UE", "", "51.60954", "-1.42187", "Europe/London"),
("2647948", "Greenock", "Гринок", "GB", "826", "SCT", "V4", "", "", "55.94838", "-4.76121", "Europe/London"),
("2647972", "Greenford", "", "GB", "826", "ENG", "GLA", "D9", "", "51.52866", "-0.35508", "Europe/London"),
("2647984", "Great Yarmouth", "Грейт-Ярмут", "GB", "826", "ENG", "I9", "33UD", "", "52.60831", "1.73052", "Europe/London"),
("2647985", "Great Wyrley", "", "GB", "826", "ENG", "M9", "41UF", "", "52.66277", "-2.01111", "Europe/London"),
("2648026", "Great Sankey", "", "GB", "826", "ENG", "P2", "00EU008", "", "53.39234", "-2.63994", "Europe/London"),
("2648063", "Great Malvern", "", "GB", "826", "ENG", "Q4", "47UC", "", "52.11161", "-2.32515", "Europe/London"),
("2648182", "Grays", "", "GB", "826", "ENG", "O3", "29UG", "", "51.47566", "0.32521", "Europe/London"),
("2648187", "Gravesend", "Грейвзенд", "GB", "826", "ENG", "G5", "29UG", "", "51.44138", "0.37371", "Europe/London"),
("2648208", "Grantham", "Гранты", "GB", "826", "ENG", "H7", "32UG", "", "52.91149", "-0.64184", "Europe/London"),
("2648215", "Grangemouth", "", "GB", "826", "SCT", "U9", "", "", "56.01141", "-3.72183", "Europe/London"),
("2648272", "Gosport", "Госпорт", "GB", "826", "ENG", "F2", "24UF", "", "50.79509", "-1.12902", "Europe/London"),
("2648273", "Gosforth", "", "GB", "826", "ENG", "I7", "", "", "55", "-1.61667", "Europe/London"),
("2648290", "Gorseinon", "", "GB", "826", "WLS", "Z1", "00NX009", "", "51.66931", "-4.04163", "Europe/London"),
("2648319", "Goole", "Гул", "GB", "826", "ENG", "E1", "00FB059", "", "53.71667", "-0.86667", "Europe/London"),
("2648356", "Golborne", "", "GB", "826", "ENG", "P7", "00EU017", "", "53.47693", "-2.59651", "Europe/London"),
("2648372", "Godalming", "Годалминге", "GB", "826", "ENG", "N7", "43UL", "", "51.18462", "-0.61725", "Europe/London"),
("2648404", "Gloucester", "Глостер", "GB", "826", "ENG", "E6", "23UE", "", "51.86568", "-2.2431", "Europe/London"),
("2648405", "Glossop", "", "GB", "826", "ENG", "D3", "17UH", "", "53.44325", "-1.949", "Europe/London"),
("2648438", "Glenrothes", "Гленротес", "GB", "826", "SCT", "V1", "", "", "56.19514", "-3.17316", "Europe/London"),
("2648579", "Glasgow", "Глазго", "GB", "826", "SCT", "V2", "", "", "55.86515", "-4.25763", "Europe/London"),
("2648657", "Gillingham", "Джиллингем", "GB", "826", "ENG", "G5", "", "", "51.38914", "0.54863", "Europe/London"),
("2648683", "Giffnock", "Гиффнок", "GB", "826", "SCT", "U7", "", "", "55.80373", "-4.29488", "Europe/London"),
("2648728", "Gelligaer", "", "GB", "826", "WLS", "X4", "00PK012", "", "51.66444", "-3.25611", "Europe/London"),
("2648773", "Gateshead", "Гейтсхед", "GB", "826", "ENG", "E5", "00CH002", "", "54.96209", "-1.60168", "Europe/London"),
("2648875", "Garforth", "", "GB", "826", "ENG", "H3", "", "", "53.79173", "-1.38067", "Europe/London"),
("2648945", "Gainsborough", "", "GB", "826", "ENG", "H7", "32UH", "", "53.38333", "-0.76667", "Europe/London"),
("2648970", "Fylde", "", "GB", "826", "ENG", "H2", "30UF", "", "53.83333", "-2.91667", "Europe/London"),
("2649024", "Frome", "Фрум", "GB", "826", "ENG", "M3", "40UB", "", "51.22834", "-2.32211", "Europe/London"),
("2649049", "Frinton-on-Sea", "", "GB", "826", "ENG", "E4", "22UN", "", "51.83877", "1.24625", "Europe/London"),
("2649198", "Formby", "", "GB", "826", "ENG", "L8", "00CA010", "", "53.55364", "-3.06816", "Europe/London"),
("2649258", "Folkestone", "Фолкстон", "GB", "826", "ENG", "G5", "6945806", "", "51.08333", "1.18333", "Europe/London"),
("2649312", "Fleetwood", "", "GB", "826", "ENG", "H2", "30UQ", "", "53.92527", "-3.01085", "Europe/London"),
("2649322", "Fleet", "", "GB", "826", "ENG", "F2", "24UG", "", "51.28333", "-0.83333", "Europe/London"),
("2649571", "Feltham", "", "GB", "826", "ENG", "GLA", "G1", "", "51.4462", "-0.41388", "Europe/London"),
("2649578", "Felling", "", "GB", "826", "ENG", "E5", "00CH002", "", "54.95297", "-1.57152", "Europe/London"),
("2649579", "Felixstowe", "Филикстоу", "GB", "826", "ENG", "N5", "42UG", "", "51.96375", "1.3511", "Europe/London"),
("2649622", "Faversham", "", "GB", "826", "ENG", "G5", "29UM", "", "51.3148", "0.88856", "Europe/London"),
("2649650", "Farnworth", "", "GB", "826", "ENG", "B1", "", "", "53.55", "-2.4", "Europe/London"),
("2649660", "Farnham", "", "GB", "826", "ENG", "N7", "43UL", "", "51.21433", "-0.79587", "Europe/London"),
("2649672", "Farnborough", "Фарнборо", "GB", "826", "ENG", "F2", "24UL", "", "51.29424", "-0.75565", "Europe/London"),
("2649692", "Fareham", "", "GB", "826", "ENG", "F2", "24UE", "", "50.85162", "-1.17929", "Europe/London"),
("2649715", "Falmouth", "Фалмут", "GB", "826", "ENG", "C6", "00HE035", "", "50.15441", "-5.07113", "Europe/London"),
("2649723", "Falkirk", "Фалкирк", "GB", "826", "SCT", "U9", "", "", "55.99917", "-3.78713", "Europe/London"),
("2649800", "Exmouth", "Эксмут", "GB", "826", "ENG", "D4", "18UB", "", "50.61723", "-3.40233", "Europe/London"),
("2649808", "Exeter", "Эксетер", "GB", "826", "ENG", "D4", "18UC", "", "50.7236", "-3.52751", "Europe/London"),
("2649833", "Evesham", "", "GB", "826", "ENG", "Q4", "47UF", "", "52.09237", "-1.94887", "Europe/London"),
("2649911", "Esher", "Эшер", "GB", "826", "ENG", "N7", "43UB", "", "51.36926", "-0.36572", "Europe/London"),
("2649957", "Epsom", "Эпсом", "GB", "826", "ENG", "N7", "43UC", "", "51.3305", "-0.27011", "Europe/London"),
("2650004", "Emsworth", "", "GB", "826", "ENG", "F2", "24UH", "", "50.84779", "-0.93697", "Europe/London"),
("2650096", "Ellesmere Port", "", "GB", "826", "ENG", "Z8", "00EW100", "", "53.27875", "-2.90134", "Europe/London"),
("2650122", "Elgin", "Элгин", "GB", "826", "SCT", "V6", "", "", "57.65", "-3.33333", "Europe/London"),
("2650188", "Egham", "Эгхем", "GB", "826", "ENG", "N7", "43UG", "", "51.43158", "-0.55239", "Europe/London"),
("2650225", "Edinburgh", "Эдинбург", "GB", "826", "SCT", "U8", "", "", "55.95206", "-3.19648", "Europe/London"),
("2650278", "Eccles", "", "GB", "826", "ENG", "L5", "", "", "53.48333", "-2.33333", "Europe/London"),
("2650285", "Ebbw Vale", "", "GB", "826", "WLS", "X2", "00PL005", "", "51.77714", "-3.20792", "Europe/London"),
("2650309", "Eastwood", "", "GB", "826", "ENG", "J9", "37UD", "", "53", "-1.3", "Europe/London"),
("2650346", "Retford", "", "GB", "826", "ENG", "J9", "37UC", "", "53.32213", "-0.94315", "Europe/London"),
("2650376", "East Molesey", "", "GB", "826", "ENG", "N7", "43UB", "", "51.39872", "-0.34916", "Europe/London"),
("2650396", "Eastleigh", "", "GB", "826", "ENG", "F2", "24UD", "", "50.96667", "-1.35", "Europe/London"),
("2650405", "East Kilbride", "", "GB", "826", "SCT", "W5", "", "", "55.76412", "-4.17669", "Europe/London"),
("2650435", "East Grinstead", "", "GB", "826", "ENG", "P6", "45UG", "", "51.12382", "-0.0061", "Europe/London"),
("2650470", "East Dereham", "", "GB", "826", "ENG", "I9", "33UB", "", "52.68333", "0.93333", "Europe/London"),
("2650497", "Eastbourne", "Истборн", "GB", "826", "ENG", "E2", "21UC", "", "50.76871", "0.28453", "Europe/London"),
("2650628", "Durham", "Дарем", "GB", "826", "ENG", "D8", "", "", "54.77676", "-1.57566", "Europe/London"),
("2650657", "Dunstable", "", "GB", "826", "ENG", "Z6", "00KC018", "", "51.886", "-0.52099", "Europe/London"),
("2650732", "Dunfermline", "Данфермлин", "GB", "826", "SCT", "V1", "", "", "56.07156", "-3.45887", "Europe/London"),
("2650752", "Dundee", "Данди", "GB", "826", "SCT", "U3", "", "", "56.46913", "-2.97489", "Europe/London"),
("2650802", "Dumbarton", "Дамбартон", "GB", "826", "SCT", "W7", "", "", "55.94433", "-4.57061", "Europe/London"),
("2650815", "Dukinfield", "", "GB", "826", "ENG", "O1", "", "", "53.47497", "-2.08809", "Europe/London"),
("2650839", "Dudley", "Дадли", "GB", "826", "ENG", "D7", "", "", "52.5", "-2.08333", "Europe/London"),
("2650962", "Droylsden", "", "GB", "826", "ENG", "O1", "00BS001", "", "53.48005", "-2.14543", "Europe/London"),
("2650967", "Dronfield", "", "GB", "826", "ENG", "D3", "17UJ", "", "53.30221", "-1.47507", "Europe/London"),
("2650983", "Droitwich", "", "GB", "826", "ENG", "Q4", "47UF", "", "52.26667", "-2.15", "Europe/London"),
("2651048", "Dover", "Дувр", "GB", "826", "ENG", "G5", "29UE", "", "51.13333", "1.3", "Europe/London"),
("2651095", "Dorking", "Доркинг", "GB", "826", "ENG", "N7", "43UE", "", "51.2329", "-0.32942", "Europe/London"),
("2651101", "Dorchester", "Дорчестер", "GB", "826", "ENG", "D6", "19UH", "", "50.71667", "-2.43333", "Europe/London"),
("2651123", "Doncaster", "Донкастер", "GB", "826", "ENG", "D5", "", "", "53.52327", "-1.13691", "Europe/London"),
("2651269", "Didcot", "Дидкот", "GB", "826", "ENG", "K2", "38UD", "", "51.60928", "-1.24214", "Europe/London"),
("2651286", "Dewsbury", "Дьюсбери", "GB", "826", "ENG", "G8", "", "", "53.69076", "-1.62907", "Europe/London"),
("2651347", "Derby", "Дерби", "GB", "826", "ENG", "D2", "", "", "52.92277", "-1.47663", "Europe/London"),
("2651357", "Denton", "", "GB", "826", "ENG", "O1", "", "", "53.45678", "-2.11822", "Europe/London"),
("2651468", "Deal", "", "GB", "826", "ENG", "G5", "29UE", "", "51.22322", "1.40432", "Europe/London"),
("2651485", "Daventry", "Давентри", "GB", "826", "ENG", "J1", "34UC", "", "52.25688", "-1.16066", "Europe/London"),
("2651495", "Darwen", "Дарвен", "GB", "826", "ENG", "A8", "00EX001", "", "53.69803", "-2.46494", "Europe/London"),
("2651497", "Darton", "", "GB", "826", "ENG", "A3", "", "", "53.58705", "-1.52676", "Europe/London"),
("2651500", "Dartford", "Дартфорде", "GB", "826", "ENG", "G5", "29UD", "", "51.44352", "0.21964", "Europe/London"),
("2651513", "Darlington", "Дарлингтон", "GB", "826", "ENG", "D1", "00EH013", "", "54.52429", "-1.55039", "Europe/London"),
("2651558", "Dalserf", "", "GB", "826", "SCT", "W5", "", "", "55.73333", "-3.91667", "Europe/London"),
("2651621", "Dagenham", "", "GB", "826", "ENG", "GLA", "A1", "", "51.55", "0.16667", "Europe/London"),
("2651654", "Cwmbran", "", "GB", "826", "WLS", "Z2", "00PM004", "", "51.65446", "-3.02281", "Europe/London"),
("2651715", "Cumbernauld", "", "GB", "826", "SCT", "V8", "", "", "55.94685", "-3.99051", "Europe/London"),
("2651831", "Crowthorne", "", "GB", "826", "ENG", "B3", "00MA003", "", "51.37027", "-0.79219", "Europe/London"),
("2651852", "Crowborough", "", "GB", "826", "ENG", "E2", "21UH", "", "51.06044", "0.16171", "Europe/London"),
("2652002", "Crewe", "Кру", "GB", "826", "ENG", "Z7", "00EQ114", "", "53.09787", "-2.44161", "Europe/London"),
("2652053", "Crawley", "Кроули", "GB", "826", "ENG", "P6", "45UE", "", "51.11303", "-0.18312", "Europe/London"),
("2652095", "Cramlington", "Крамлингтон", "GB", "826", "ENG", "J6", "00EM166", "", "55.08652", "-1.58598", "Europe/London"),
("2652191", "Cowley", "", "GB", "826", "ENG", "K2", "38UC", "", "51.73139", "-1.20742", "Europe/London"),
("2652204", "Cowes", "Каус", "GB", "826", "ENG", "G2", "00MW007", "", "50.76306", "-1.29772", "Europe/London"),
("2652221", "Coventry", "Ковентри", "GB", "826", "ENG", "C7", "", "", "52.40656", "-1.51217", "Europe/London"),
("2652249", "Coulsdon", "", "GB", "826", "ENG", "GLA", "C8", "", "51.32002", "-0.14088", "Europe/London"),
("2652381", "Corby", "Корби", "GB", "826", "ENG", "J1", "34UB", "", "52.49637", "-0.68939", "Europe/London"),
("2652437", "Consett", "Консетт", "GB", "826", "ENG", "D8", "00EJ053", "", "54.85404", "-1.8316", "Europe/London"),
("2652458", "Conisbrough", "", "GB", "826", "ENG", "D5", "00CE016", "", "53.48188", "-1.23214", "Europe/London"),
("2652464", "Congleton", "Конглтон", "GB", "826", "ENG", "Z7", "00EQ043", "", "53.16314", "-2.21253", "Europe/London"),
("2652513", "Colwyn Bay", "", "GB", "826", "WLS", "X8", "00NE009", "", "53.29483", "-3.72674", "Europe/London"),
("2652544", "Colne", "", "GB", "826", "ENG", "H2", "30UJ", "", "53.85713", "-2.16851", "Europe/London"),
("2652586", "Coleraine", "Колрэйн", "GB", "826", "NIR", "R6", "", "", "55.13333", "-6.66667", "Europe/London"),
("2652618", "Colchester", "Колчестер", "GB", "826", "ENG", "E4", "22UG", "", "51.88921", "0.90421", "Europe/London"),
("2652622", "Coity", "", "GB", "826", "WLS", "X3", "00PB004", "", "51.522", "-3.55531", "Europe/London"),
("2652689", "Cobham", "", "GB", "826", "ENG", "N7", "43UB", "", "51.32997", "-0.4113", "Europe/London"),
("2652696", "Coatbridge", "Котбридж", "GB", "826", "SCT", "V8", "", "", "55.86216", "-4.02469", "Europe/London"),
("2652698", "Coalville", "", "GB", "826", "ENG", "H5", "6896157", "", "52.72247", "-1.3702", "Europe/London"),
("2652730", "Clydebank", "", "GB", "826", "SCT", "W7", "", "", "55.90137", "-4.4057", "Europe/London"),
("2652734", "Clydach", "", "GB", "826", "WLS", "Z1", "00NX005", "", "51.68333", "-3.9", "Europe/London"),
("2652819", "Clitheroe", "", "GB", "826", "ENG", "H2", "30UL", "", "53.86667", "-2.4", "Europe/London"),
("2652861", "Clevedon", "", "GB", "826", "ENG", "J4", "00HC013", "", "51.44057", "-2.85745", "Europe/London"),
("2652885", "Cleethorpes", "Клитхорпс", "GB", "826", "ENG", "J2", "00FC016", "", "53.56047", "-0.03225", "Europe/London"),
("2652890", "Cleckheaton", "", "GB", "826", "ENG", "G8", "00CZ005", "", "53.72405", "-1.71294", "Europe/London"),
("2652974", "Clacton-on-Sea", "Клактон-он-Си", "GB", "826", "ENG", "E4", "22UN", "", "51.78967", "1.15597", "Europe/London"),
("2652995", "Cirencester", "", "GB", "826", "ENG", "E6", "23UC", "", "51.71708", "-1.96825", "Europe/London"),
("2653075", "Christchurch", "Крайстчерч", "GB", "826", "ENG", "D6", "19UC", "", "50.73306", "-1.77567", "Europe/London"),
("2653086", "Chorley", "", "GB", "826", "ENG", "H2", "30UE", "", "53.65", "-2.61667", "Europe/London"),
("2653123", "Chislehurst", "Чизлхёрст", "GB", "826", "ENG", "GLA", "B8", "", "51.41709", "0.06858", "Europe/London"),
("2653137", "Chipping Sodbury", "", "GB", "826", "ENG", "M6", "00HD034", "", "51.53813", "-2.39379", "Europe/London"),
("2653144", "Chippenham", "Чиппенем", "GB", "826", "ENG", "P8", "00HY056", "", "51.46", "-2.12472", "Europe/London"),
("2653192", "Chichester", "Чичестер", "GB", "826", "ENG", "P6", "45UD", "", "50.83673", "-0.78003", "Europe/London"),
("2653224", "Chester-le-Street", "", "GB", "826", "ENG", "D8", "00EJ084", "", "54.85862", "-1.57408", "Europe/London"),
("2653225", "Chesterfield", "Честерфилд", "GB", "826", "ENG", "D3", "17UD", "", "53.25", "-1.41667", "Europe/London"),
("2653228", "Chester", "Честер", "GB", "826", "ENG", "Z8", "", "", "53.1905", "-2.89189", "Europe/London"),
("2653229", "Chessington", "", "GB", "826", "ENG", "GLA", "G7", "", "51.3624", "-0.30427", "Europe/London"),
("2653232", "Cheshunt", "", "GB", "826", "ENG", "F8", "26UB", "", "51.70791", "-0.03739", "Europe/London"),
("2653235", "Chesham", "", "GB", "826", "ENG", "B9", "11UC", "", "51.7", "-0.6", "Europe/London"),
("2653261", "Cheltenham", "Челтнем", "GB", "826", "ENG", "E6", "23UB", "", "51.9", "-2.08333", "Europe/London"),
("2653265", "Chelsea", "Челси", "GB", "826", "ENG", "GLA", "G4", "", "51.48755", "-0.16936", "Europe/London"),
("2653266", "Chelmsford", "Челмсфорд", "GB", "826", "ENG", "E4", "22UF", "", "51.73575", "0.46958", "Europe/London"),
("2653290", "Cheadle Hulme", "", "GB", "826", "ENG", "N2", "", "", "53.3761", "-2.1897", "Europe/London"),
("2653305", "Chatham", "Чатем", "GB", "826", "ENG", "G5", "", "", "51.37891", "0.52786", "Europe/London"),
("2653353", "Chapletown", "", "GB", "826", "ENG", "L9", "", "", "53.46506", "-1.47217", "Europe/London"),
("2653379", "Chandlers Ford", "", "GB", "826", "ENG", "F2", "24UD", "", "51.01219", "-1.38136", "Europe/London"),
("2653393", "Chalfont Saint Peter", "", "GB", "826", "ENG", "B9", "11UC", "", "51.60885", "-0.55618", "Europe/London"),
("2653520", "Caterham", "", "GB", "826", "ENG", "N7", "43UK", "", "51.2823", "-0.07889", "Europe/London"),
("2653558", "Castlereagh", "", "GB", "826", "NIR", "R5", "", "", "54.5735", "-5.88472", "Europe/London"),
("2653584", "Castleford", "", "GB", "826", "ENG", "O7", "", "", "53.72587", "-1.36256", "Europe/London"),
("2653646", "Carshalton", "", "GB", "826", "ENG", "GLA", "N8", "", "51.36829", "-0.16755", "Europe/London"),
("2653680", "Carrickfergus", "Каррикфергус", "GB", "826", "NIR", "R4", "", "", "54.7158", "-5.8058", "Europe/London"),
("2653755", "Carmarthen", "Кармартен", "GB", "826", "WLS", "X7", "00NU006", "", "51.85552", "-4.30535", "Europe/London"),
("2653775", "Carlisle", "Карлайл", "GB", "826", "ENG", "C9", "16UD", "", "54.8951", "-2.9382", "Europe/London"),
("2653822", "Cardiff", "Кардифф", "GB", "826", "WLS", "X5", "", "", "51.48", "-3.18", "Europe/London"),
("2653877", "Canterbury", "Кентербери", "GB", "826", "ENG", "G5", "6945807", "", "51.27904", "1.07992", "Europe/London"),
("2653883", "Cannock", "Каннок", "GB", "826", "ENG", "M9", "41UB", "", "52.69045", "-2.03085", "Europe/London"),
("2653941", "Cambridge", "Кембридж", "GB", "826", "ENG", "C3", "12UB", "", "52.2", "0.11667", "Europe/London"),
("2653945", "Camborne", "", "GB", "826", "ENG", "C6", "00HE015", "", "50.21306", "-5.29731", "Europe/London"),
("2653947", "Camberley", "Кемберли", "GB", "826", "ENG", "N7", "43UJ", "", "51.33705", "-0.74261", "Europe/London"),
("2654089", "Caerphilly", "Керфили", "GB", "826", "WLS", "X4", "00PK007", "", "51.57452", "-3.218", "Europe/London"),
("2654141", "Buxton", "", "GB", "826", "ENG", "D3", "17UH", "", "53.25741", "-1.90982", "Europe/London"),
("2654179", "Bushey", "", "GB", "826", "ENG", "F8", "26UE", "", "51.64316", "-0.36053", "Europe/London"),
("2654186", "Bury St Edmunds", "Бери-Сент-Эдмендс", "GB", "826", "ENG", "N5", "42UF", "", "52.2463", "0.71111", "Europe/London"),
("2654187", "Bury", "Бери", "GB", "826", "ENG", "C1", "", "", "53.6", "-2.3", "Europe/London"),
("2654200", "Burton upon Trent", "Бертон-апон-Трент", "GB", "826", "ENG", "M9", "41UC", "", "52.80728", "-1.64263", "Europe/London"),
("2654252", "Burntwood", "", "GB", "826", "ENG", "M9", "41UD", "", "52.68075", "-1.92759", "Europe/London"),
("2654264", "Burnley", "Бернли", "GB", "826", "ENG", "H2", "30UD", "", "53.8", "-2.23333", "Europe/London"),
("2654269", "Burnham-on-Sea", "", "GB", "826", "ENG", "M3", "40UC", "", "51.23862", "-2.9978", "Europe/London"),
("2654308", "Burgess Hill", "", "GB", "826", "ENG", "P6", "45UG", "", "50.95843", "-0.13287", "Europe/London"),
("2654394", "Buckley", "", "GB", "826", "WLS", "Y1", "00NJ004", "", "53.16667", "-3.08333", "Europe/London"),
("2654415", "Buckhaven", "", "GB", "826", "SCT", "V1", "", "", "56.17149", "-3.03377", "Europe/London"),
("2654450", "Brymbo", "", "GB", "826", "WLS", "Z4", "00NL006", "", "53.06667", "-3.06667", "Europe/London"),
("2654490", "Brownhills", "Браунхиллс", "GB", "826", "ENG", "O8", "", "", "52.63333", "-1.93333", "Europe/London"),
("2654579", "Bromsgrove", "", "GB", "826", "ENG", "Q4", "47UB", "", "52.33574", "-2.05983", "Europe/London"),
("2654635", "Broadstairs", "", "GB", "826", "ENG", "G5", "2636057", "", "51.35908", "1.43938", "Europe/London"),
("2654663", "Brixham", "", "GB", "826", "ENG", "O4", "00HH001", "", "50.39431", "-3.51585", "Europe/London"),
("2654668", "Briton Ferry", "", "GB", "826", "WLS", "Y5", "00NZ006", "", "51.63106", "-3.81898", "Europe/London"),
("2654675", "Bristol", "Бристоль", "GB", "826", "ENG", "B7", "", "", "51.45523", "-2.59665", "Europe/London"),
("2654710", "Brighton", "Брайтон", "GB", "826", "ENG", "B6", "", "", "50.82838", "-0.13947", "Europe/London"),
("2654715", "Brighouse", "", "GB", "826", "ENG", "C2", "00CZ003", "", "53.70322", "-1.78428", "Europe/London"),
("2654724", "Brierley Hill", "", "GB", "826", "ENG", "D7", "", "", "52.48173", "-2.12139", "Europe/London"),
("2654728", "Bridlington", "", "GB", "826", "ENG", "E1", "00FB169", "", "54.08306", "-0.19192", "Europe/London"),
("2654730", "Bridgwater", "Бриджуотер", "GB", "826", "ENG", "M3", "40UC", "", "51.12837", "-3.00356", "Europe/London"),
("2654755", "Bridgend", "Бридженд", "GB", "826", "WLS", "X3", "", "", "51.50583", "-3.57722", "Europe/London"),
("2654782", "Brentwood", "Брентвуд", "GB", "826", "ENG", "E4", "22UD", "", "51.62127", "0.30556", "Europe/London"),
("2654814", "Bredbury", "", "GB", "826", "ENG", "N2", "", "", "53.41667", "-2.11667", "Europe/London"),
("2654927", "Bramhall", "", "GB", "826", "ENG", "N2", "00EQ107", "", "53.35801", "-2.16539", "Europe/London"),
("2654938", "Braintree", "", "GB", "826", "ENG", "E4", "22UC", "", "51.87819", "0.55292", "Europe/London"),
("2654993", "Bradford", "Брадфорд", "GB", "826", "ENG", "B4", "", "", "53.79391", "-1.75206", "Europe/London"),
("2655009", "Bracknell", "", "GB", "826", "ENG", "B3", "00MA002", "", "51.41363", "-0.75054", "Europe/London"),
("2655095", "Bournemouth", "Борнмут", "GB", "826", "ENG", "B2", "19UC", "", "50.72048", "-1.8795", "Europe/London"),
("2655138", "Boston", "Бостон", "GB", "826", "ENG", "H7", "32UB", "", "52.97633", "-0.02664", "Europe/London"),
("2655186", "Borehamwood", "", "GB", "826", "ENG", "F8", "26UE", "", "51.65468", "-0.27762", "Europe/London"),
("2655198", "Bootle", "Бутл", "GB", "826", "ENG", "L8", "", "", "53.46667", "-3.01667", "Europe/London"),
("2655237", "Bolton", "Болтон", "GB", "826", "ENG", "B1", "", "", "53.58333", "-2.43333", "Europe/London"),
("2655262", "Bognor Regis", "", "GB", "826", "ENG", "P6", "45UC", "", "50.78206", "-0.67978", "Europe/London"),
("2655315", "Blyth", "Блит", "GB", "826", "ENG", "J6", "00EM165", "", "55.12708", "-1.50856", "Europe/London"),
("2655329", "Bloxwich", "", "GB", "826", "ENG", "O8", "41UF", "", "52.61806", "-2.00431", "Europe/London"),
("2655351", "Bletchley", "", "GB", "826", "ENG", "B9", "", "", "51.99334", "-0.73471", "Europe/London"),
("2655459", "Blackpool", "Блэкпул", "GB", "826", "ENG", "A9", "", "", "53.81667", "-3.05", "Europe/London"),
("2655524", "Blackburn", "Блэкберн", "GB", "826", "ENG", "A8", "", "", "53.75", "-2.48333", "Europe/London"),
("2655557", "Bishopstoke", "", "GB", "826", "ENG", "F2", "24UD", "", "50.96643", "-1.32832", "Europe/London"),
("2655562", "Bishops Stortford", "", "GB", "826", "ENG", "F8", "26UD", "", "51.87113", "0.15868", "Europe/London"),
("2655582", "Bishopbriggs", "Бишопбриггс", "GB", "826", "SCT", "U5", "", "", "55.90669", "-4.21869", "Europe/London"),
("2655583", "Bishop Auckland", "Бишоп-Окленд", "GB", "826", "ENG", "D8", "00EJ006", "", "54.65554", "-1.67706", "Europe/London"),
("2655603", "Birmingham", "Бирмингем", "GB", "826", "ENG", "A7", "", "", "52.48142", "-1.89983", "Europe/London"),
("2655613", "Birkenhead", "Биркенхед", "GB", "826", "ENG", "Q1", "00EW114", "", "53.39337", "-3.01479", "Europe/London"),
("2655642", "Bingley", "", "GB", "826", "ENG", "B4", "00CX017", "", "53.84861", "-1.83857", "Europe/London"),
("2655664", "Billingham", "Биллингем", "GB", "826", "ENG", "N3", "00EF019", "", "54.58881", "-1.29034", "Europe/London"),
("2655672", "Billericay", "Биллерикей", "GB", "826", "ENG", "E4", "22UB", "", "51.62867", "0.41963", "Europe/London"),
("2655689", "Biggleswade", "", "GB", "826", "ENG", "Z6", "00KC008", "", "52.08652", "-0.26493", "Europe/London"),
("2655707", "Bideford", "", "GB", "826", "ENG", "D4", "18UK", "", "51.01787", "-4.20458", "Europe/London"),
("2655708", "Biddulph", "", "GB", "826", "ENG", "M9", "41UH", "", "53.11724", "-2.17584", "Europe/London"),
("2655729", "Bicester", "", "GB", "826", "ENG", "K2", "38UB", "", "51.89998", "-1.15357", "Europe/London"),
("2655775", "Bexley", "", "GB", "826", "ENG", "GLA", "A6", "", "51.44162", "0.14866", "Europe/London"),
("2655777", "Bexhill-on-Sea", "", "GB", "826", "ENG", "E2", "21UG", "", "50.85023", "0.47095", "Europe/London"),
("2655785", "Beverley", "", "GB", "826", "ENG", "E1", "", "", "53.84587", "-0.42332", "Europe/London"),
("2655819", "Berwick-Upon-Tweed", "Бервик-апон-Твид", "GB", "826", "ENG", "J6", "", "", "55.78333", "-2", "Europe/London"),
("2655858", "Berkhamsted", "", "GB", "826", "ENG", "F8", "26UC", "26UC002", "51.7604", "-0.56528", "Europe/London"),
("2655882", "Bentley", "", "GB", "826", "ENG", "D5", "", "", "53.53333", "-1.15", "Europe/London"),
("2655942", "Belper", "Белпер", "GB", "826", "ENG", "D3", "17UB", "", "53.0233", "-1.48119", "Europe/London"),
("2655952", "Bellshill", "", "GB", "826", "SCT", "V8", "", "", "55.81667", "-4.01667", "Europe/London"),
("2655984", "Belfast", "Белфаст", "GB", "826", "NIR", "R3", "", "", "54.58333", "-5.93333", "Europe/London"),
("2656031", "Bedworth", "Бедворс", "GB", "826", "ENG", "P3", "44UC", "", "52.4791", "-1.46909", "Europe/London"),
("2656039", "Bedlington", "", "GB", "826", "ENG", "J6", "", "", "55.13061", "-1.59319", "Europe/London"),
("2656046", "Bedford", "Бедфорд", "GB", "826", "ENG", "Z5", "", "", "52.13459", "-0.46632", "Europe/London"),
("2656065", "Beckenham", "", "GB", "826", "ENG", "GLA", "B8", "", "51.40878", "-0.02526", "Europe/London"),
("2656070", "Bebington", "", "GB", "826", "ENG", "Q1", "", "", "53.35", "-3.01667", "Europe/London"),
("2656086", "Bearsden", "Берсден", "GB", "826", "SCT", "U5", "", "", "55.91536", "-4.33279", "Europe/London"),
("2656168", "Batley", "", "GB", "826", "ENG", "G8", "", "", "53.70291", "-1.6337", "Europe/London"),
("2656169", "Bathgate", "", "GB", "826", "SCT", "W9", "", "", "55.90204", "-3.64398", "Europe/London"),
("2656173", "Bath", "Бат", "GB", "826", "ENG", "A4", "", "", "51.3751", "-2.36172", "Europe/London"),
("2656192", "Basingstoke", "", "GB", "826", "ENG", "F2", "24UB", "", "51.26249", "-1.08708", "Europe/London"),
("2656194", "Basildon", "Басилдон", "GB", "826", "ENG", "E4", "22UB", "", "51.56844", "0.45782", "Europe/London"),
("2656235", "Barry", "Барри", "GB", "826", "WLS", "Z3", "", "", "51.40667", "-3.26944", "Europe/London"),
("2656241", "Barrow-in-Furness", "", "GB", "826", "ENG", "C9", "16UC", "", "54.11094", "-3.22758", "Europe/London"),
("2656258", "Barrhead", "Баррхед", "GB", "826", "SCT", "U7", "", "", "55.79916", "-4.39285", "Europe/London"),
("2656281", "Barnstaple", "Барнстапл", "GB", "826", "ENG", "D4", "18UE", "", "51.08022", "-4.05808", "Europe/London"),
("2656284", "Barnsley", "Барнсли", "GB", "826", "ENG", "A3", "", "", "53.55", "-1.48333", "Europe/London"),
("2656295", "Barnet", "Барнет", "GB", "826", "ENG", "GLA", "A2", "", "51.65", "-0.2", "Europe/London"),
("2656333", "Barking", "", "GB", "826", "ENG", "GLA", "A1", "", "51.53333", "0.08333", "Europe/London"),
("2656379", "Banstead", "", "GB", "826", "ENG", "N7", "43UF", "", "51.32503", "-0.19569", "Europe/London"),
("2656396", "Bangor", "Бангор", "GB", "826", "NIR", "T2", "", "", "54.65338", "-5.66895", "Europe/London"),
("2656397", "Bangor", "Бангор", "GB", "826", "WLS", "Y2", "00NC006", "", "53.22647", "-4.13459", "Europe/London"),
("2656406", "Banbury", "Банбери", "GB", "826", "ENG", "K2", "38UB", "", "52.0602", "-1.34029", "Europe/London"),
("2656407", "Banbridge", "Банбридж", "GB", "826", "NIR", "R2", "", "", "54.35", "-6.28333", "Europe/London"),
("2656490", "Ballymena", "Бэллимена", "GB", "826", "NIR", "Q9", "", "", "54.86357", "-6.27628", "Europe/London"),
("2656627", "Baildon", "", "GB", "826", "ENG", "B4", "00CX016", "", "53.84711", "-1.78785", "Europe/London"),
("2656708", "Ayr", "Эр", "GB", "826", "SCT", "W4", "", "", "55.46273", "-4.63393", "Europe/London"),
("2656719", "Aylesbury", "Эйлсбери", "GB", "826", "ENG", "B9", "11UB", "", "51.81665", "-0.81458", "Europe/London"),
("2656847", "Atherton", "", "GB", "826", "ENG", "P7", "00BL003", "", "53.52371", "-2.49354", "Europe/London"),
("2656915", "Ashton-under-Lyne", "Эштон-андер-Лайн", "GB", "826", "ENG", "O1", "", "", "53.48876", "-2.0989", "Europe/London"),
("2656918", "Ashton in Makerfield", "", "GB", "826", "ENG", "P7", "", "", "53.48333", "-2.65", "Europe/London"),
("2656955", "Ashford", "Эшфорд", "GB", "826", "ENG", "G5", "29UB", "", "51.14586", "0.87281", "Europe/London"),
("2656992", "Ascot", "Аскот", "GB", "826", "ENG", "P9", "", "", "51.41082", "-0.6748", "Europe/London"),
("2657030", "Arnold", "Арнольд", "GB", "826", "ENG", "J9", "37UE", "", "53", "-1.13333", "Europe/London"),
("2657215", "Arbroath", "Арброт", "GB", "826", "SCT", "T7", "", "", "56.56317", "-2.58736", "Europe/London"),
("2657255", "Antrim", "Антрим", "GB", "826", "NIR", "Q6", "", "", "54.7", "-6.2", "Europe/London"),
("2657324", "Andover", "Андовер", "GB", "826", "ENG", "F2", "24UN", "", "51.20828", "-1.48246", "Europe/London"),
("2657356", "Amersham", "Амершам", "GB", "826", "ENG", "B9", "11UC", "", "51.66667", "-0.61667", "Europe/London"),
("2657402", "Altrincham", "", "GB", "826", "ENG", "O6", "00EQ008", "", "53.38752", "-2.34848", "Europe/London"),
("2657408", "Alton", "", "GB", "826", "ENG", "F2", "24UC", "", "51.14931", "-0.97469", "Europe/London"),
("2657471", "Alloa", "Аллоа", "GB", "826", "SCT", "U1", "", "", "56.11586", "-3.78997", "Europe/London"),
("2657508", "Alfreton", "Алфретон", "GB", "826", "ENG", "D3", "17UB", "", "53.0961", "-1.38832", "Europe/London"),
("2657528", "Aldridge", "", "GB", "826", "ENG", "O8", "41UD", "", "52.60549", "-1.91715", "Europe/London"),
("2657540", "Aldershot", "Олдершот", "GB", "826", "ENG", "F2", "24UL", "", "51.24827", "-0.76389", "Europe/London"),
("2657613", "Airdrie", "", "GB", "826", "SCT", "V8", "", "", "55.86602", "-3.98025", "Europe/London"),
("2657697", "Acton", "", "GB", "826", "ENG", "GLA", "D9", "", "51.50901", "-0.2762", "Europe/London"),
("2657703", "Acocks Green", "", "GB", "826", "ENG", "A7", "", "", "52.45", "-1.81667", "Europe/London"),
("2657770", "Accrington", "Аккрингтон", "GB", "826", "ENG", "H2", "30UG", "", "53.75379", "-2.35863", "Europe/London"),
("2657780", "Abingdon", "Абингдон", "GB", "826", "ENG", "K2", "38UE", "", "51.67109", "-1.28278", "Europe/London"),
("2657782", "Aberystwyth", "Аберистуит", "GB", "826", "WLS", "X6", "00NQ003", "", "52.41548", "-4.08292", "Europe/London"),
("2657812", "Abergele", "Абергеле", "GB", "826", "WLS", "X8", "00NE001", "", "53.28436", "-3.5822", "Europe/London"),
("2657832", "Aberdeen", "Абердин", "GB", "826", "SCT", "T5", "", "", "57.14369", "-2.09814", "Europe/London"),
("2657835", "Aberdare", "Абердэйр", "GB", "826", "WLS", "Y9", "00PF003", "", "51.71438", "-3.44918", "Europe/London"),
("3209584", "Crosby", "", "GB", "826", "ENG", "L8", "", "", "53.47778", "-3.03333", "Europe/London"),
("3345317", "Blackwood", "", "GB", "826", "WLS", "X4", "00PK006", "", "51.66778", "-3.2075", "Europe/London"),
("3345432", "Neston", "", "GB", "826", "ENG", "P8", "", "", "51.41222", "-2.20056", "Europe/London"),
("3345437", "Camden Town", "", "GB", "826", "ENG", "GLA", "C4", "", "51.54057", "-0.14334", "Europe/London"),
("3345439", "Telford", "Телфорд", "GB", "826", "ENG", "O2", "", "", "52.67659", "-2.44926", "Europe/London"),
("3345440", "Craigavon", "Крейгавон", "GB", "826", "NIR", "R8", "", "", "54.44709", "-6.387", "Europe/London"),
("6545243", "Bayswater", "", "GB", "826", "ENG", "GLA", "P5", "", "51.51116", "-0.18426", "Europe/London"),
("6620293", "Yateley", "", "GB", "826", "ENG", "F2", "24UG", "", "51.34305", "-0.82985", "Europe/London"),
("6620355", "Bowthorpe", "", "GB", "826", "ENG", "I9", "33UG", "", "52.63884", "1.21885", "Europe/London"),
("6620360", "Hedge End", "", "GB", "826", "ENG", "F2", "24UD", "", "50.91234", "-1.30076", "Europe/London"),
("6639623", "Erskine", "", "GB", "826", "SCT", "W2", "", "", "55.9005", "-4.45028", "Europe/London"),
("6640028", "Hale", "", "GB", "826", "ENG", "I2", "", "", "53.37831", "-2.33271", "Europe/London"),
("6690592", "Amersham on the Hill", "", "GB", "826", "ENG", "B9", "11UC", "", "51.67468", "-0.60742", "Europe/London"),
("6690602", "Battersea", "", "GB", "826", "ENG", "GLA", "P1", "", "51.47475", "-0.15547", "Europe/London"),
("6690862", "South Croydon", "", "GB", "826", "ENG", "GLA", "C8", "", "51.36217", "-0.09421", "Europe/London"),
("6690863", "Hornchurch", "", "GB", "826", "ENG", "GLA", "F6", "", "51.55685", "0.21664", "Europe/London"),
("6690866", "Surbiton", "Сурбитон", "GB", "826", "ENG", "GLA", "G7", "", "51.39148", "-0.29825", "Europe/London"),
("6690867", "Ewell", "", "GB", "826", "ENG", "N7", "43UC", "", "51.34948", "-0.2494", "Europe/London"),
("6690870", "Becontree", "", "GB", "826", "ENG", "GLA", "A1", "", "51.5529", "0.129", "Europe/London"),
("6690877", "Brixton", "Брикстон", "GB", "826", "ENG", "GLA", "H1", "", "51.46593", "-0.10652", "Europe/London"),
("6690989", "Bethnal Green", "", "GB", "826", "ENG", "GLA", "O5", "", "51.52718", "-0.06109", "Europe/London"),
("6691219", "Failsworth", "Фэйлзуорт", "GB", "826", "ENG", "I2", "", "", "53.50484", "-2.16568", "Europe/London"),
("6691227", "Radcliffe", "", "GB", "826", "ENG", "C1", "", "", "53.56178", "-2.32455", "Europe/London"),
("6691235", "Heywood", "", "GB", "826", "ENG", "I2", "", "", "53.59245", "-2.21941", "Europe/London"),
("6691766", "Longsight", "", "GB", "826", "ENG", "I2", "", "", "53.45801", "-2.20104", "Europe/London"),
("6691884", "Heavitree", "", "GB", "826", "ENG", "D4", "18UC", "", "50.72044", "-3.49646", "Europe/London"),
("6691927", "Ferndown", "", "GB", "826", "ENG", "D6", "19UD", "", "50.80743", "-1.89975", "Europe/London"),
("6693470", "Lytham St Annes", "", "GB", "826", "ENG", "H2", "30UF", "", "53.7426", "-2.997", "Europe/London"),
("6693771", "Hadley Wood", "", "GB", "826", "ENG", "GLA", "E3", "", "51.66669", "-0.16981", "Europe/London"),
("6695247", "Chapel Allerton", "", "GB", "826", "ENG", "H3", "", "", "53.82901", "-1.53834", "Europe/London"),
("6947041", "Blackheath", "", "GB", "826", "ENG", "GLA", "H6", "", "51.4647", "0.0079", "Europe/London"),
("6947168", "Kempston Hardwick", "", "GB", "826", "ENG", "Z5", "00KB038", "", "52.08956", "-0.49908", "Europe/London"),
("6947756", "Mendip", "", "GB", "826", "ENG", "M3", "40UB", "", "51.2372", "-2.6266", "Europe/London"),
("7290015", "Lower Earley", "", "GB", "826", "ENG", "Q2", "00MF004", "", "51.42708", "-0.91979", "Europe/London"),
("7302130", "Bartley Green", "", "GB", "826", "ENG", "A7", "47UB", "", "52.43532", "-1.99707", "Europe/London"),
("8063096", "Earlsfield", "", "GB", "826", "ENG", "GLA", "P1", "", "51.4439", "-0.1854", "Europe/London"),
("8224216", "Letchworth Garden City", "", "GB", "826", "ENG", "F8", "26UF", "26UF035", "51.97938", "-0.22664", "Europe/London"),
("8224782", "Shirley", "", "GB", "826", "ENG", "M2", "", "", "52.41074", "-1.81952", "Europe/London"),
("8224783", "Stanley", "", "GB", "826", "ENG", "D8", "00EJ110", "", "54.86796", "-1.69846", "Europe/London"),
("8299614", "Rossendale", "", "GB", "826", "ENG", "H2", "30UM", "", "53.68456", "-2.2769", "Europe/London"),
("8299615", "Thornton-Cleveleys", "", "GB", "826", "ENG", "L8", "00CA008", "", "53.87389", "-3.02244", "Europe/London"),
("8299616", "Deeside", "", "GB", "826", "WLS", "Y1", "00NJ030", "", "53.20053", "-3.03841", "Europe/London"),
("8299617", "High Peak", "", "GB", "826", "ENG", "D3", "17UH", "17UH010", "53.36797", "-1.84536", "Europe/London"),
("8299619", "Hayling Island", "", "GB", "826", "ENG", "F2", "24UH", "", "50.7838", "-0.96869", "Europe/London"),
("8299620", "Isle of Lewis", "", "GB", "826", "SCT", "W8", "", "", "58.21901", "-6.38803", "Europe/London"),
("8299621", "Shetland", "", "GB", "826", "SCT", "W3", "", "", "60.15456", "-1.14899", "Europe/London"),
("8299623", "Orkney", "Оркнейские острова", "GB", "826", "SCT", "V9", "", "", "58.98465", "-2.95953", "Europe/London"),
("8315400", "Holloway", "", "GB", "826", "ENG", "GLA", "G3", "", "51.55237", "-0.12497", "Europe/London"),
("8581595", "Harringay", "", "GB", "826", "ENG", "GLA", "F3", "", "51.5824", "-0.09956", "Europe/London"),
("610824", "Zugdidi", "Зугдиди", "GE", "268", "71", "610823", "", "", "42.5088", "41.87088", "Asia/Tbilisi"),
("610864", "Zestap'oni", "Зестафони", "GE", "268", "66", "", "", "", "42.11", "43.0525", "Asia/Tbilisi"),
("611403", "Ts'khinvali", "Цхинвали", "GE", "268", "73", "", "", "", "42.22764", "43.96861", "Asia/Tbilisi"),
("611583", "Tqvarch'eli", "Ткуарчал", "GE", "268", "02", "", "", "", "42.84035", "41.68007", "Asia/Tbilisi"),
("611694", "Telavi", "Телави", "GE", "268", "67", "7667581", "", "", "41.91978", "45.47315", "Asia/Tbilisi"),
("611717", "Tbilisi", "Тбилиси", "GE", "268", "51", "", "", "", "41.69411", "44.83368", "Asia/Tbilisi"),
("611847", "Sokhumi", "Сухум", "GE", "268", "02", "", "", "", "43.00697", "40.9893", "Asia/Tbilisi"),
("612053", "Senak'i", "Сенаки", "GE", "268", "71", "", "", "", "42.27042", "42.0675", "Asia/Tbilisi"),
("612126", "Samtredia", "Самтредиа", "GE", "268", "66", "", "", "", "42.1537", "42.33517", "Asia/Tbilisi"),
("612287", "Rust'avi", "Рустави", "GE", "268", "68", "", "", "", "41.54949", "44.99323", "Asia/Tbilisi"),
("612366", "P'ot'i", "Поти", "GE", "268", "71", "", "", "", "42.14616", "41.67197", "Asia/Tbilisi"),
("612536", "Ozurgeti", "Озургети", "GE", "268", "65", "", "", "", "41.92442", "42.00682", "Asia/Tbilisi"),
("612652", "Och'amch'ire", "Очамчира", "GE", "268", "02", "", "", "", "42.71232", "41.46863", "Asia/Tbilisi"),
("613074", "Marneuli", "Марнеули", "GE", "268", "68", "7667578", "", "", "41.47588", "44.80894", "Asia/Tbilisi"),
("613607", "K'ut'aisi", "Кутаиси", "GE", "268", "66", "", "", "", "42.26791", "42.69459", "Asia/Tbilisi"),
("613762", "Kobuleti", "Кобулети", "GE", "268", "04", "", "", "", "41.82", "41.77528", "Asia/Tbilisi"),
("613988", "Khashuri", "Хашури", "GE", "268", "73", "613987", "", "", "41.99414", "43.59994", "Asia/Tbilisi"),
("614455", "Gori", "Гори", "GE", "268", "73", "", "", "", "41.98422", "44.11578", "Asia/Tbilisi"),
("615532", "Batumi", "Батуми", "GE", "268", "04", "", "", "", "41.64228", "41.63392", "Asia/Tbilisi"),
("615860", "Akhaltsikhe", "Ахалцихе", "GE", "268", "72", "", "", "", "41.63901", "42.98262", "Asia/Tbilisi"),
("615912", "Stantsiya Novyy Afon", "Новый Афон", "GE", "268", "02", "", "", "", "43.08056", "40.83833", "Asia/Tbilisi"),
("824288", "Tsqaltubo", "Цхалтубо", "GE", "268", "66", "", "", "", "42.34129", "42.5976", "Asia/Tbilisi"),
("3421319", "Nuuk", "Нуук", "GL", "304", "07", "", "", "", "64.18347", "-51.72157", "America/Godthab"),
("2414545", "Tougue", "", "GN", "324", "L", "28", "", "", "11.45", "-11.68333", "Africa/Conakry"),
("2414926", "Telimele", "", "GN", "324", "D", "27", "", "", "10.9", "-13.03333", "Africa/Conakry"),
("2415703", "Siguiri", "Сигири", "GN", "324", "K", "39", "", "", "11.42282", "-9.16852", "Africa/Conakry"),
("2416443", "Pita", "", "GN", "324", "M", "25", "", "", "11.08333", "-12.4", "Africa/Conakry"),
("2416969", "Nzerekore", "Нзерекоре", "GN", "324", "N", "38", "", "", "7.75624", "-8.8179", "Africa/Conakry"),
("2417833", "Mamou", "", "GN", "324", "M", "23", "", "", "10.37546", "-12.09148", "Africa/Conakry"),
("2417988", "Macenta", "Масента", "GN", "324", "N", "21", "", "", "8.54351", "-9.47099", "Africa/Conakry"),
("2418362", "Labe", "Лаба", "GN", "324", "L", "34", "", "", "11.31823", "-12.28332", "Africa/Conakry"),
("2419472", "Kissidougou", "Кисидугу", "GN", "324", "F", "17", "", "", "9.1848", "-10.09987", "Africa/Conakry"),
("2419533", "Kindia", "Киндиа", "GN", "324", "D", "16", "", "", "10.05692", "-12.86576", "Africa/Conakry"),
("2419992", "Kankan", "", "GN", "324", "K", "32", "", "", "10.38542", "-9.30568", "Africa/Conakry"),
("2420056", "Kamsar", "Комсар", "GN", "324", "B", "03", "", "", "10.66667", "-14.6", "Africa/Conakry"),
("2420562", "Gueckedou", "", "GN", "324", "N", "13", "", "", "8.56744", "-10.1336", "Africa/Conakry"),
("2420884", "Fria", "Фриа", "GN", "324", "B", "11", "", "", "10.45", "-13.53333", "Africa/Conakry"),
("2422457", "Coyah", "", "GN", "324", "D", "30", "", "", "9.70556", "-13.37694", "Africa/Conakry"),
("2422465", "Conakry", "Конакри", "GN", "324", "04", "", "", "", "9.53795", "-13.67729", "Africa/Conakry"),
("2422488", "Camayenne", "", "GN", "324", "04", "", "", "", "9.535", "-13.68778", "Africa/Conakry"),
("2422924", "Boke", "", "GN", "324", "B", "03", "", "", "10.94094", "-14.29665", "Africa/Conakry"),
("2309332", "Ebebiyin", "Эбебьин", "GQ", "226", "07", "", "", "", "2.15106", "11.33528", "Africa/Malabo"),
("2309527", "Malabo", "Малабо", "GQ", "226", "04", "", "", "", "3.75", "8.78333", "Africa/Malabo"),
("2310046", "Bata", "Бата", "GQ", "226", "08", "", "", "", "1.86391", "9.76582", "Africa/Malabo"),
("251780", "Voula", "Вуле", "GR", "300", "ESYE31", "445406", "9216", "", "37.84221", "23.77651", "Europe/Athens"),
("251833", "Volos", "", "GR", "300", "ESYE14", "24", "9105", "", "39.36667", "22.94583", "Europe/Athens"),
("251948", "Vyronas", "", "GR", "300", "ESYE31", "445408", "9186", "", "37.96105", "23.753", "Europe/Athens"),
("252601", "Tripoli", "Триполи", "GR", "300", "ESYE25", "41", "9241", "", "37.50889", "22.37944", "Europe/Athens"),
("252664", "Trikala", "Трикала", "GR", "300", "ESYE14", "22", "9114", "", "39.55528", "21.7675", "Europe/Athens"),
("252910", "Thivai", "", "GR", "300", "ESYE24", "33", "9144", "", "38.325", "23.31889", "Europe/Athens"),
("253394", "Sparti", "", "GR", "300", "ESYE25", "42", "9252", "", "37.07333", "22.42972", "Europe/Athens"),
("254144", "Salamis", "Саламина", "GR", "300", "ESYE31", "406101", "9211", "", "37.96427", "23.49649", "Europe/Athens"),
("254352", "Rethymno", "Ретимнон", "GR", "300", "ESYE43", "44", "9318", "", "35.36687", "24.47487", "Europe/Athens"),
("254698", "Preveza", "", "GR", "300", "ESYE21", "19", "9090", "", "38.95617", "20.7505", "Europe/Athens"),
("255229", "Pyrgos", "Пиргос", "GR", "300", "ESYE23", "39", "9141", "", "37.67513", "21.44102", "Europe/Athens"),
("255274", "Piraeus", "Пирей", "GR", "300", "ESYE31", "35", "", "", "37.94745", "23.63708", "Europe/Athens"),
("255377", "Petroupolis", "Петроуполис", "GR", "300", "ESYE31", "445408", "9184", "", "38.04187", "23.68494", "Europe/Athens"),
("255524", "Peristeri", "Перистерион", "GR", "300", "ESYE31", "445408", "9183", "", "38.01667", "23.7", "Europe/Athens"),
("255588", "Perama", "Перама", "GR", "300", "ESYE31", "406101", "9206", "", "37.96775", "23.5721", "Europe/Athens"),
("255683", "Patra", "", "GR", "300", "ESYE23", "38", "9134", "", "38.24444", "21.73444", "Europe/Athens"),
("256075", "Palaio Faliro", "", "GR", "300", "ESYE31", "445408", "9201", "", "37.92066", "23.70916", "Europe/Athens"),
("256429", "Nikaia", "", "GR", "300", "ESYE31", "406101", "9204", "", "37.96667", "23.65", "Europe/Athens"),
("256575", "Nea Smyrni", "", "GR", "300", "ESYE31", "445408", "9200", "", "37.94504", "23.71416", "Europe/Athens"),
("256598", "Nea Makri", "", "GR", "300", "ESYE31", "445406", "9220", "", "38.08733", "23.97642", "Europe/Athens"),
("256601", "Ilion", "", "GR", "300", "ESYE31", "445408", "9182", "", "38.03333", "23.7", "Europe/Athens"),
("256614", "Nea Ionia", "", "GR", "300", "ESYE31", "445408", "9174", "", "38.03333", "23.75", "Europe/Athens"),
("256621", "Nea Filadelfeia", "", "GR", "300", "ESYE31", "445408", "9193", "", "38.03333", "23.73333", "Europe/Athens"),
("256622", "Nea Erythraia", "", "GR", "300", "ESYE31", "445408", "9171", "", "38.1", "23.81667", "Europe/Athens"),
("256750", "Moskhaton", "", "GR", "300", "ESYE31", "406101", "9205", "", "37.94718", "23.67708", "Europe/Athens"),
("256866", "Mytilini", "Митилини", "GR", "300", "ESYE41", "51", "9261", "", "39.11", "26.55472", "Europe/Athens"),
("257302", "Melissia", "Мелиссия", "GR", "300", "ESYE31", "445408", "9176", "", "38.05", "23.83333", "Europe/Athens"),
("257365", "Megara", "Мегара", "GR", "300", "ESYE31", "445407", "9231", "", "37.99471", "23.34324", "Europe/Athens"),
("258038", "Artemida", "", "GR", "300", "ESYE31", "445406", "9226", "", "37.96667", "24", "Europe/Athens"),
("258463", "Livadeia", "Левадия", "GR", "300", "ESYE24", "33", "9145", "", "38.435", "22.87389", "Europe/Athens"),
("258576", "Larisa", "Лариса", "GR", "300", "ESYE14", "21", "9100", "", "39.63722", "22.42028", "Europe/Athens"),
("258620", "Lamia", "Ламия", "GR", "300", "ESYE24", "29", "9160", "", "38.9", "22.43333", "Europe/Athens"),
("259245", "Kos", "Кос", "GR", "300", "ESYE42", "47", "9284", "", "36.89333", "27.28889", "Europe/Athens"),
("259251", "Koropi", "", "GR", "300", "ESYE31", "445406", "9218", "", "37.89886", "23.87181", "Europe/Athens"),
("259289", "Korinthos", "Коринф", "GR", "300", "ESYE25", "37", "9243", "", "37.94068", "22.95734", "Europe/Athens"),
("259824", "Kifisia", "", "GR", "300", "ESYE31", "445408", "9171", "", "38.07438", "23.81106", "Europe/Athens"),
("259949", "Cholargos", "", "GR", "300", "ESYE31", "445408", "9175", "", "38", "23.8", "Europe/Athens"),
("259973", "Chios", "Хиос", "GR", "300", "ESYE41", "50", "9266", "", "38.36778", "26.13583", "Europe/Athens"),
("260114", "Chania", "Ханья", "GR", "300", "ESYE43", "43", "9325", "", "35.51124", "24.02921", "Europe/Athens"),
("260133", "Chalkida", "Халкида", "GR", "300", "ESYE24", "34", "9155", "", "38.46361", "23.59944", "Europe/Athens"),
("260172", "Khalandrion", "", "GR", "300", "ESYE31", "445408", "9178", "", "38.03058", "23.79793", "Europe/Athens"),
("260204", "Keratsini", "", "GR", "300", "ESYE31", "406101", "9202", "", "37.9625", "23.61972", "Europe/Athens"),
("260989", "Karditsa", "Кардица", "GR", "300", "ESYE14", "23", "9092", "", "39.36556", "21.92167", "Europe/Athens"),
("261414", "Kallithea", "Каллифея", "GR", "300", "ESYE31", "445408", "9198", "", "37.95", "23.7", "Europe/Athens"),
("261604", "Kalamata", "Каламата", "GR", "300", "ESYE25", "40", "9254", "", "37.03889", "22.11417", "Europe/Athens"),
("261614", "Alimos", "", "GR", "300", "ESYE31", "445408", "9195", "", "37.91033", "23.72361", "Europe/Athens"),
("261678", "Kaisariani", "Кесариани", "GR", "300", "ESYE31", "445408", "9190", "", "37.96667", "23.8", "Europe/Athens"),
("261743", "Irakleio", "", "GR", "300", "ESYE31", "445408", "9173", "", "38.05282", "23.76523", "Europe/Athens"),
("261745", "Irakleion", "Ираклион", "GR", "300", "ESYE43", "45", "9305", "", "35.32787", "25.14341", "Europe/Athens"),
("261779", "Ioannina", "", "GR", "300", "ESYE21", "17", "9084", "", "39.66486", "20.85189", "Europe/Athens"),
("262135", "Galatsi", "", "GR", "300", "ESYE31", "445408", "9188", "", "38.01667", "23.75", "Europe/Athens"),
("262719", "Elliniko", "", "GR", "300", "ESYE31", "445408", "9197", "", "37.88333", "23.73333", "Europe/Athens"),
("262752", "Elefsina", "", "GR", "300", "ESYE31", "445407", "9229", "", "38.04135", "23.54295", "Europe/Athens"),
("264111", "Agia Varvara", "", "GR", "300", "ESYE31", "445408", "9179", "", "37.98333", "23.66667", "Europe/Athens"),
("264194", "Agia Paraskevi", "", "GR", "300", "ESYE31", "445408", "9167", "", "38.01667", "23.83333", "Europe/Athens"),
("264371", "Athens", "Афины", "GR", "300", "ESYE31", "445408", "9186", "", "37.97945", "23.71622", "Europe/Athens"),
("264445", "Aspropyrgos", "", "GR", "300", "ESYE31", "445407", "9228", "", "38.06134", "23.58971", "Europe/Athens"),
("264559", "Arta", "", "GR", "300", "ESYE21", "20", "9073", "", "39.16056", "20.98528", "Europe/Athens"),
("264670", "Argos", "Аргос", "GR", "300", "ESYE25", "36", "9233", "", "37.63333", "22.73333", "Europe/Athens"),
("264888", "Ano Liosia", "", "GR", "300", "ESYE31", "445407", "9232", "", "38.08333", "23.7", "Europe/Athens"),
("265243", "Marousi", "", "GR", "300", "ESYE31", "445408", "9168", "", "38.05", "23.8", "Europe/Athens"),
("265252", "Amaliada", "", "GR", "300", "ESYE23", "39", "9139", "", "37.8", "21.35", "Europe/Athens"),
("265488", "Acharnes", "", "GR", "300", "ESYE31", "445406", "9215", "", "38.08333", "23.73333", "Europe/Athens"),
("265500", "Aigio", "Эйо", "GR", "300", "ESYE23", "38", "9130", "", "38.24861", "22.08194", "Europe/Athens"),
("265533", "Aigaleo", "", "GR", "300", "ESYE31", "445408", "9181", "", "37.98333", "23.68333", "Europe/Athens"),
("265560", "Agrinio", "Агринион", "GR", "300", "ESYE23", "31", "9123", "", "38.62139", "21.40778", "Europe/Athens"),
("400666", "Rodos", "Родос", "GR", "300", "ESYE42", "47", "9296", "", "36.44083", "28.2225", "Europe/Athens"),
("733776", "Giannitsa", "Яница", "GR", "300", "ESYE12", "07", "9044", "", "40.79194", "22.4075", "Europe/Athens"),
("733840", "Xanthi", "Ксанти", "GR", "300", "ESYE11", "03", "9017", "", "41.13488", "24.888", "Europe/Athens"),
("733905", "Veroia", "Верия", "GR", "300", "ESYE12", "12", "9024", "", "40.52437", "22.20242", "Europe/Athens"),
("734077", "Thessaloniki", "Салоники", "GR", "300", "ESYE12", "13", "9031", "", "40.64362", "22.93086", "Europe/Athens"),
("734301", "Sykies", "", "GR", "300", "ESYE12", "13", "9035", "", "40.64944", "22.95083", "Europe/Athens"),
("734330", "Serres", "", "GR", "300", "ESYE12", "05", "9054", "", "41.08499", "23.54757", "Europe/Athens"),
("734426", "Ptolemaida", "", "GR", "300", "ESYE13", "11", "9067", "", "40.51472", "21.67861", "Europe/Athens"),
("734538", "Polichni", "Полихни", "GR", "300", "ESYE12", "13", "9036", "", "40.66671", "22.94881", "Europe/Athens"),
("734643", "Pylaia", "Пилеа", "GR", "300", "ESYE12", "13", "9037", "", "40.59918", "22.98613", "Europe/Athens"),
("734712", "Peraia", "", "GR", "300", "ESYE12", "13", "9029", "", "40.49874", "22.92617", "Europe/Athens"),
("734771", "Panorama", "", "GR", "300", "ESYE12", "13", "9037", "", "40.58779", "23.0315", "Europe/Athens"),
("734880", "Orestiada", "", "GR", "300", "ESYE11", "01", "9008", "", "41.50306", "26.52972", "Europe/Athens"),
("734883", "Oraiokastro", "", "GR", "300", "ESYE12", "13", "9039", "", "40.73083", "22.91722", "Europe/Athens"),
("735030", "Naousa", "", "GR", "300", "ESYE12", "12", "9025", "", "40.62944", "22.06806", "Europe/Athens"),
("735215", "Menemeni", "", "GR", "300", "ESYE12", "13", "9026", "", "40.65829", "22.89712", "Europe/Athens"),
("735563", "Kozani", "Козани", "GR", "300", "ESYE13", "11", "9068", "", "40.30068", "21.78896", "Europe/Athens"),
("735640", "Komotini", "Комотини", "GR", "300", "ESYE11", "02", "9021", "", "41.11917", "25.40535", "Europe/Athens"),
("735736", "Kilkis", "", "GR", "300", "ESYE12", "06", "9040", "", "40.99302", "22.87433", "Europe/Athens"),
("735861", "Kavala", "Кавала", "GR", "300", "ESYE11", "14", "9012", "", "40.93959", "24.40687", "Europe/Athens"),
("735914", "Katerini", "", "GR", "300", "ESYE12", "16", "9047", "", "40.26956", "22.50608", "Europe/Athens"),
("736083", "Kalamaria", "Каламария", "GR", "300", "ESYE12", "13", "9032", "", "40.5825", "22.95028", "Europe/Athens"),
("736229", "Florina", "", "GR", "300", "ESYE13", "08", "9072", "", "40.78197", "21.40981", "Europe/Athens"),
("736357", "Edessa", "", "GR", "300", "ESYE12", "07", "9043", "", "40.8026", "22.04751", "Europe/Athens"),
("736364", "Drama", "", "GR", "300", "ESYE11", "04", "9002", "", "41.15283", "24.1473", "Europe/Athens"),
("736928", "Alexandroupoli", "Александруполис", "GR", "300", "ESYE11", "01", "9006", "", "40.84995", "25.87644", "Europe/Athens"),
("2463679", "Kerkyra", "Корфу", "GR", "300", "ESYE22", "25", "9118", "", "39.62", "19.91972", "Europe/Athens"),
("6324534", "Vrilissia", "", "GR", "300", "ESYE31", "445408", "9169", "", "38.03381", "23.82962", "Europe/Athens"),
("7522530", "Marousi", "", "GR", "300", "ESYE31", "445408", "9168", "", "38.05404", "23.806", "Europe/Athens"),
("8201845", "Gerakas", "", "GR", "300", "ESYE31", "", "", "", "38.02277", "23.8576", "Europe/Athens"),
("8310183", "Korydallos", "", "GR", "300", "ESYE31", "", "", "", "37.98468", "23.64711", "Europe/Athens"),
("8358544", "Zografos", "", "GR", "300", "ESYE31", "35", "", "", "37.97332", "23.7909", "Europe/Athens"),
("8478257", "Agios Ioannis Rentis", "", "GR", "300", "ESYE31", "406101", "9204", "", "37.96491", "23.66511", "Europe/Athens"),
("9034728", "Nea Ionia", "", "GR", "300", "ESYE14", "24", "9105", "", "39.37312", "22.93375", "Europe/Athens"),
("3186781", "Zapresic", "Запрешич", "HR", "191", "20", "", "", "", "45.85639", "15.80778", "Europe/Zagreb"),
("3186886", "Zagreb", "Загреб", "HR", "191", "21", "3186885", "", "", "45.81444", "15.97798", "Europe/Zagreb"),
("3186952", "Zadar", "Задар", "HR", "191", "19", "", "", "", "44.11972", "15.24222", "Europe/Zagreb"),
("3187047", "Vukovar", "Вуковар", "HR", "191", "18", "", "", "", "45.34333", "18.99972", "Europe/Zagreb"),
("3187694", "Virovitica", "", "HR", "191", "17", "3187693", "", "", "45.83194", "17.38389", "Europe/Zagreb"),
("3187719", "Vinkovci", "Винковцы", "HR", "191", "18", "", "", "", "45.28833", "18.80472", "Europe/Zagreb"),
("3188244", "Velika Gorica", "Велика-Горица", "HR", "191", "20", "3188243", "", "", "45.7125", "16.07556", "Europe/Zagreb"),
("3188383", "Varazdin", "Вараждин", "HR", "191", "16", "", "", "", "46.30444", "16.33778", "Europe/Zagreb"),
("3190261", "Split", "Сплит", "HR", "191", "15", "3190259", "", "", "43.50891", "16.43915", "Europe/Zagreb"),
("3190359", "Solin", "Солин", "HR", "191", "15", "", "", "", "43.5432", "16.49314", "Europe/Zagreb"),
("3190586", "Slavonski Brod", "Славонски-Брод", "HR", "191", "02", "3190585", "", "", "45.16028", "18.01556", "Europe/Zagreb"),
("3190589", "Pozega", "Пожега", "HR", "191", "11", "", "", "", "45.34028", "17.68528", "Europe/Zagreb"),
("3190813", "Sisak", "Сисак", "HR", "191", "14", "3190812", "", "", "45.46611", "16.37833", "Europe/Zagreb"),
("3190941", "Sibenik", "Шибеник", "HR", "191", "13", "3190938", "", "", "43.72722", "15.90583", "Europe/Zagreb"),
("3190966", "Sesvete", "Сесвете", "HR", "191", "21", "3190965", "", "", "45.83111", "16.11639", "Europe/Zagreb"),
("3191316", "Samobor", "", "HR", "191", "20", "3191315", "", "", "45.80306", "15.71806", "Europe/Zagreb"),
("3191648", "Rijeka", "Риека", "HR", "191", "12", "", "", "", "45.34306", "14.40917", "Europe/Zagreb"),
("3192224", "Pula", "Пула", "HR", "191", "04", "3192222", "", "", "44.86833", "13.84806", "Europe/Zagreb"),
("3193935", "Osijek", "Осиек", "HR", "191", "10", "3193934", "", "", "45.55111", "18.69389", "Europe/Zagreb"),
("3197728", "Koprivnica", "Копривница", "HR", "191", "06", "3197726", "", "", "46.16278", "16.8275", "Europe/Zagreb"),
("3198259", "Karlovac", "Карловац", "HR", "191", "05", "3198257", "", "", "45.48722", "15.54778", "Europe/Zagreb"),
("3201047", "Dubrovnik", "Дубровник", "HR", "191", "03", "7577034", "", "", "42.64807", "18.09216", "Europe/Zagreb"),
("3202888", "Cakovec", "Чаковец", "HR", "191", "09", "", "", "", "46.38444", "16.43389", "Europe/Zagreb"),
("3203982", "Bjelovar", "Беловар", "HR", "191", "01", "", "", "", "45.89861", "16.84889", "Europe/Zagreb"),
("3209380", "Stenjevec", "", "HR", "191", "21", "", "", "", "45.80846", "15.88245", "Europe/Zagreb"),
("6618983", "Zagreb - Centar", "", "HR", "191", "21", "3186885", "", "", "45.81313", "15.97753", "Europe/Zagreb"),
("714581", "Torokszentmiklos", "Тороксентмиклош", "HU", "348", "20", "", "", "", "47.18333", "20.41667", "Europe/Budapest"),
("714697", "Tiszaujvaros", "", "HU", "348", "04", "", "", "", "47.93333", "21.08333", "Europe/Budapest"),
("715126", "Szolnok", "Сольнок", "HU", "348", "20", "", "", "", "47.18333", "20.2", "Europe/Budapest"),
("715338", "Szentes", "", "HU", "348", "06", "", "", "", "46.65627", "20.27201", "Europe/Budapest"),
("715429", "Szeged", "", "HU", "348", "06", "", "", "", "46.253", "20.14824", "Europe/Budapest"),
("715466", "Szarvas", "Сарваш", "HU", "348", "03", "", "", "", "46.86667", "20.55", "Europe/Budapest"),
("715839", "Satoraljaujhely", "Шаторальяуйхей", "HU", "348", "04", "", "", "", "48.39492", "21.65871", "Europe/Budapest"),
("716301", "Puspokladany", "", "HU", "348", "10", "", "", "", "47.31667", "21.11667", "Europe/Budapest"),
("716671", "Ozd", "Озд", "HU", "348", "04", "", "", "", "48.21667", "20.3", "Europe/Budapest"),
("716736", "Oroshaza", "Орошхаза", "HU", "348", "03", "", "", "", "46.56667", "20.66667", "Europe/Budapest"),
("716935", "Nyiregyhaza", "Ньиредьхаза", "HU", "348", "18", "", "", "", "47.95539", "21.71671", "Europe/Budapest"),
("717582", "Miskolc", "Мишкольц", "HU", "348", "04", "", "", "", "48.1", "20.78333", "Europe/Budapest"),
("717635", "Mezotur", "", "HU", "348", "20", "", "", "", "47", "20.63333", "Europe/Budapest"),
("717652", "Mezokovesd", "", "HU", "348", "04", "", "", "", "47.81667", "20.58333", "Europe/Budapest"),
("717771", "Mateszalka", "", "HU", "348", "18", "", "", "", "47.95528", "22.32348", "Europe/Budapest"),
("717902", "Mako", "Мако", "HU", "348", "06", "", "", "", "46.21667", "20.48333", "Europe/Budapest"),
("718739", "Kisvarda", "", "HU", "348", "18", "", "", "", "48.21667", "22.08333", "Europe/Budapest"),
("719311", "Kazincbarcika", "Казинцбарцика", "HU", "348", "04", "", "", "", "48.25", "20.63333", "Europe/Budapest"),
("719404", "Karcag", "Карцаге", "HU", "348", "20", "", "", "", "47.31667", "20.93333", "Europe/Budapest"),
("719965", "Hodmezovasarhely", "Ходмезевашархей", "HU", "348", "06", "", "", "", "46.41667", "20.33333", "Europe/Budapest"),
("720276", "Hajduszoboszlo", "Хайдусобосло", "HU", "348", "10", "", "", "", "47.45", "21.4", "Europe/Budapest"),
("720284", "Hajdunanas", "", "HU", "348", "10", "", "", "", "47.85", "21.43333", "Europe/Budapest"),
("720292", "Hajduboszormeny", "", "HU", "348", "10", "", "", "", "47.66667", "21.51667", "Europe/Budapest"),
("720334", "Gyula", "Дьюла", "HU", "348", "03", "", "", "", "46.65", "21.28333", "Europe/Budapest"),
("720364", "Gyomaendrod", "", "HU", "348", "03", "", "", "", "46.93333", "20.83333", "Europe/Budapest"),
("721239", "Eger", "Эгер", "HU", "348", "11", "", "", "", "47.90265", "20.37329", "Europe/Budapest"),
("721472", "Debrecen", "Дебрецен", "HU", "348", "10", "", "", "", "47.53333", "21.63333", "Europe/Budapest"),
("721592", "Csongrad", "", "HU", "348", "06", "", "", "", "46.71332", "20.14242", "Europe/Budapest"),
("722324", "Berettyoujfalu", "", "HU", "348", "10", "", "", "", "47.21667", "21.55", "Europe/Budapest"),
("722437", "Bekescsaba", "Бекешчаба", "HU", "348", "03", "", "", "", "46.68333", "21.1", "Europe/Budapest"),
("722439", "Bekes", "Бекеш", "HU", "348", "03", "", "", "", "46.76667", "21.13333", "Europe/Budapest"),
("722636", "Balmazujvaros", "", "HU", "348", "10", "", "", "", "47.61667", "21.35", "Europe/Budapest"),
("723030", "Abony", "", "HU", "348", "16", "", "", "", "47.1899", "20.00476", "Europe/Budapest"),
("3042638", "Zalaegerszeg", "Залаэгерсег", "HU", "348", "24", "", "", "", "46.84", "16.84389", "Europe/Budapest"),
("3042929", "Veszprem", "Веспрем", "HU", "348", "23", "", "", "", "47.09327", "17.91149", "Europe/Budapest"),
("3043019", "Vecses", "", "HU", "348", "16", "", "", "", "47.40705", "19.28648", "Europe/Budapest"),
("3043095", "Varpalota", "", "HU", "348", "23", "", "", "", "47.19936", "18.13954", "Europe/Budapest"),
("3043293", "Vac", "Вац", "HU", "348", "16", "", "", "", "47.77591", "19.13612", "Europe/Budapest"),
("3044082", "Tatabanya", "Татабанья", "HU", "348", "12", "", "", "", "47.58494", "18.39325", "Europe/Budapest"),
("3044083", "Tata", "", "HU", "348", "12", "", "", "", "47.65289", "18.31838", "Europe/Budapest"),
("3044141", "Tapolca", "", "HU", "348", "23", "", "", "", "46.88152", "17.44117", "Europe/Budapest"),
("3044310", "Szombathely", "Сомбатхей", "HU", "348", "22", "", "", "", "47.23088", "16.62155", "Europe/Budapest"),
("3044475", "Szigetszentmiklos", "Сигетсентмиклош", "HU", "348", "16", "", "", "", "47.34382", "19.04335", "Europe/Budapest"),
("3044681", "Szentendre", "Сентендре", "HU", "348", "16", "", "", "", "47.66943", "19.07561", "Europe/Budapest"),
("3044760", "Szekszard", "Сексард", "HU", "348", "21", "", "", "", "46.35014", "18.70905", "Europe/Budapest"),
("3044774", "Szekesfehervar", "Секешфехервар", "HU", "348", "08", "", "", "", "47.18995", "18.41034", "Europe/Budapest"),
("3044821", "Szazhalombatta", "", "HU", "348", "16", "", "", "", "47.32579", "18.92142", "Europe/Budapest"),
("3045190", "Sopron", "Шопрон", "HU", "348", "09", "", "", "", "47.68501", "16.59049", "Europe/Budapest"),
("3045332", "Siofok", "Шиофок", "HU", "348", "17", "", "", "", "46.90412", "18.058", "Europe/Budapest"),
("3045487", "Sarvar", "", "HU", "348", "22", "", "", "", "47.25395", "16.93525", "Europe/Budapest"),
("3045643", "Salgotarjan", "Шальготарьян", "HU", "348", "14", "", "", "", "48.09872", "19.80303", "Europe/Budapest"),
("3046526", "Pecs", "Печ", "HU", "348", "02", "", "", "", "46.08333", "18.23333", "Europe/Budapest"),
("3046619", "Paradsasvar", "Парадшашвар", "HU", "348", "11", "", "", "", "47.9126", "19.97709", "Europe/Budapest"),
("3046686", "Papa", "Папы", "HU", "348", "23", "", "", "", "47.33004", "17.4674", "Europe/Budapest"),
("3046768", "Paks", "", "HU", "348", "21", "", "", "", "46.62648", "18.85962", "Europe/Budapest"),
("3046888", "Oroszlany", "Орослане", "HU", "348", "12", "", "", "", "47.48671", "18.31225", "Europe/Budapest"),
("3047651", "Nagykoros", "", "HU", "348", "16", "", "", "", "47.03419", "19.77857", "Europe/Budapest"),
("3047679", "Nagykanizsa", "Надьканижа", "HU", "348", "24", "", "", "", "46.45347", "16.99104", "Europe/Budapest"),
("3047896", "Mosonmagyarovar", "Мошонмадьяровар", "HU", "348", "09", "", "", "", "47.86788", "17.26994", "Europe/Budapest"),
("3047942", "Monor", "", "HU", "348", "16", "", "", "", "47.35133", "19.44734", "Europe/Budapest"),
("3047967", "Mohacs", "Мохач", "HU", "348", "02", "", "", "", "45.99306", "18.68306", "Europe/Budapest"),
("3049512", "Komlo", "", "HU", "348", "02", "", "", "", "46.19278", "18.26494", "Europe/Budapest"),
("3049519", "Komarom", "", "HU", "348", "12", "", "", "", "47.74318", "18.11913", "Europe/Budapest"),
("3049880", "Kiskunhalas", "Кишкунхалаш", "HU", "348", "01", "", "", "", "46.43402", "19.4848", "Europe/Budapest"),
("3049885", "Kiskunfelegyhaza", "", "HU", "348", "01", "", "", "", "46.71213", "19.84458", "Europe/Budapest"),
("3049896", "Kiskoros", "", "HU", "348", "01", "", "", "", "46.62139", "19.28528", "Europe/Budapest"),
("3050212", "Keszthely", "Кестхей", "HU", "348", "24", "", "", "", "46.76812", "17.24317", "Europe/Budapest"),
("3050434", "Kecskemet", "Кечкемет", "HU", "348", "01", "", "", "", "46.90618", "19.69128", "Europe/Budapest"),
("3050616", "Kaposvar", "Капошвар", "HU", "348", "17", "", "", "", "46.36667", "17.8", "Europe/Budapest"),
("3050719", "Kalocsa", "Калоча", "HU", "348", "01", "", "", "", "46.52639", "18.98583", "Europe/Budapest"),
("3050907", "Jaszbereny", "", "HU", "348", "20", "", "", "", "47.5", "19.91667", "Europe/Budapest"),
("3051621", "Hatvan", "", "HU", "348", "11", "", "", "", "47.66667", "19.68333", "Europe/Budapest"),
("3052009", "Gyor", "Дьёр", "HU", "348", "09", "", "", "", "47.68333", "17.63512", "Europe/Budapest"),
("3052040", "Gyongyos", "Дьёндьёш", "HU", "348", "11", "", "", "", "47.78257", "19.928", "Europe/Budapest"),
("3052101", "Gyal", "", "HU", "348", "16", "", "", "", "47.38449", "19.2214", "Europe/Budapest"),
("3052236", "Godollo", "Гёдёллё", "HU", "348", "16", "", "", "", "47.59657", "19.35515", "Europe/Budapest"),
("3052241", "God", "", "HU", "348", "16", "", "", "", "47.68324", "19.13417", "Europe/Budapest"),
("3052542", "Fot", "", "HU", "348", "16", "", "", "", "47.6177", "19.1887", "Europe/Budapest"),
("3053163", "Esztergom", "Эстергом", "HU", "348", "12", "", "", "", "47.7928", "18.74148", "Europe/Budapest"),
("3053281", "Erd", "Эрд", "HU", "348", "16", "", "", "", "47.39489", "18.9136", "Europe/Budapest"),
("3053438", "Dunaujvaros", "Дунауйварош", "HU", "348", "08", "", "", "", "46.98333", "18.93333", "Europe/Budapest"),
("3053476", "Dunakeszi", "", "HU", "348", "16", "", "", "", "47.6364", "19.13864", "Europe/Budapest"),
("3053485", "Dunaharaszti", "", "HU", "348", "16", "", "", "", "47.3545", "19.09822", "Europe/Budapest"),
("3053590", "Dombovar", "", "HU", "348", "21", "", "", "", "46.37657", "18.13696", "Europe/Budapest"),
("3053836", "Dabas", "", "HU", "348", "16", "", "", "", "47.18594", "19.31091", "Europe/Budapest"),
("3054543", "Cegled", "Цеглед", "HU", "348", "16", "", "", "", "47.17266", "19.79952", "Europe/Budapest"),
("3054643", "Budapest", "Будапешт", "HU", "348", "05", "", "", "", "47.49801", "19.03991", "Europe/Budapest"),
("3054646", "Budaors", "", "HU", "348", "16", "", "", "", "47.46181", "18.95845", "Europe/Budapest"),
("3055601", "Balassagyarmat", "", "HU", "348", "14", "", "", "", "48.07296", "19.29614", "Europe/Budapest"),
("3055685", "Baja", "Бая", "HU", "348", "01", "", "", "", "46.17496", "18.95639", "Europe/Budapest"),
("3056357", "Ajka", "Айка", "HU", "348", "23", "", "", "", "47.10196", "17.55892", "Europe/Budapest"),
("7284823", "Budapest XII. keruelet", "", "HU", "348", "05", "", "", "", "47.49192", "19.01493", "Europe/Budapest"),
("7284824", "Budapest XI. keruelet", "", "HU", "348", "05", "", "", "", "47.47603", "19.03605", "Europe/Budapest"),
("7284825", "Budapest IX. keruelet", "", "HU", "348", "05", "", "", "", "47.48299", "19.06591", "Europe/Budapest"),
("7284826", "Budapest VIII. keruelet", "", "HU", "348", "05", "", "", "", "47.48919", "19.07012", "Europe/Budapest"),
("7284827", "Budapest VII. keruelet", "", "HU", "348", "05", "", "", "", "47.50045", "19.06875", "Europe/Budapest"),
("7284828", "Budapest VI. keruelet", "", "HU", "348", "05", "", "", "", "47.50369", "19.06583", "Europe/Budapest"),
("7284829", "Budapest XIV. keruelet", "", "HU", "348", "05", "", "", "", "47.5183", "19.10789", "Europe/Budapest"),
("7284830", "Budapest XIII. keruelet", "", "HU", "348", "05", "", "", "", "47.52978", "19.08068", "Europe/Budapest"),
("7284831", "Budapest IV. keruelet", "", "HU", "348", "05", "", "", "", "47.56182", "19.08909", "Europe/Budapest"),
("7284832", "Budapest XV. keruelet", "", "HU", "348", "05", "", "", "", "47.56263", "19.11681", "Europe/Budapest"),
("7284833", "Budapest XVI. keruelet", "", "HU", "348", "05", "", "", "", "47.51482", "19.17028", "Europe/Budapest"),
("7284834", "Budapest X. keruelet", "", "HU", "348", "05", "", "", "", "47.4791", "19.15835", "Europe/Budapest"),
("7284835", "Budapest XIX. keruelet", "", "HU", "348", "05", "", "", "", "47.45293", "19.14943", "Europe/Budapest"),
("7284836", "Budapest XVIII. keruelet", "", "HU", "348", "05", "", "", "", "47.44417", "19.17595", "Europe/Budapest"),
("7284837", "Budapest XXIII. keruelet", "", "HU", "348", "05", "", "", "", "47.39788", "19.11492", "Europe/Budapest"),
("7284838", "Budapest XXII. keruelet", "", "HU", "348", "05", "", "", "", "47.42698", "19.04016", "Europe/Budapest"),
("7284839", "Budapest XXI. keruelet", "", "HU", "348", "05", "", "", "", "47.43047", "19.07098", "Europe/Budapest"),
("7284840", "Budapest XX. keruelet", "", "HU", "348", "05", "", "", "", "47.43674", "19.10093", "Europe/Budapest"),
("7284841", "Budapest XVII. keruelet", "", "HU", "348", "05", "", "", "", "47.47997", "19.25388", "Europe/Budapest"),
("7284842", "Budapest III. keruelet", "", "HU", "348", "05", "", "", "", "47.54157", "19.04501", "Europe/Budapest"),
("7284843", "Budapest II. keruelet", "", "HU", "348", "05", "", "", "", "47.51291", "19.03184", "Europe/Budapest"),
("7284844", "Budapest I. keruelet", "", "HU", "348", "05", "", "", "", "47.49705", "19.03961", "Europe/Budapest"),
("1213493", "Teluk Nibung", "", "ID", "360", "26", "", "", "", "3.001", "99.8164", "Asia/Jakarta"),
("1213500", "Tebingtinggi", "", "ID", "360", "26", "", "", "", "3.3285", "99.1625", "Asia/Jakarta"),
("1213530", "Tanjungtiram", "", "ID", "360", "26", "", "", "", "4.0613", "98.3699", "Asia/Jakarta"),
("1213547", "Tanjungbalai", "", "ID", "360", "26", "", "", "", "2.96667", "99.8", "Asia/Jakarta"),
("1213614", "Sunggal", "", "ID", "360", "26", "", "", "", "3.5765", "98.6151", "Asia/Jakarta"),
("1213655", "Stabat", "", "ID", "360", "26", "", "", "", "3.761", "98.4513", "Asia/Jakarta"),
("1213821", "Sigli", "", "ID", "360", "01", "", "", "", "5.3848", "95.9609", "Asia/Jakarta"),
("1213855", "Sibolga", "Сиболга", "ID", "360", "26", "", "", "", "1.74016", "98.78117", "Asia/Jakarta"),
("1214026", "Sabang", "", "ID", "360", "01", "", "", "", "5.88969", "95.31644", "Asia/Jakarta"),
("1214055", "Reuleuet", "", "ID", "360", "01", "", "", "", "5.21667", "96.28333", "Asia/Jakarta"),
("1214073", "Rantauprapat", "", "ID", "360", "26", "", "", "", "2.1", "99.83333", "Asia/Jakarta"),
("1214189", "Percut", "", "ID", "360", "26", "", "", "", "3.6253", "98.864", "Asia/Jakarta"),
("1214191", "Perbaungan", "", "ID", "360", "26", "", "", "", "3.5679", "98.956", "Asia/Jakarta"),
("1214204", "Pematangsiantar", "", "ID", "360", "26", "", "", "", "2.9595", "99.0687", "Asia/Jakarta"),
("1214302", "Pangkalan Brandan", "", "ID", "360", "26", "", "", "", "4.0238", "98.2782", "Asia/Jakarta"),
("1214369", "Padangsidempuan", "", "ID", "360", "26", "", "", "", "1.37952", "99.27146", "Asia/Jakarta"),
("1214488", "Meulaboh", "Мелабоха", "ID", "360", "01", "", "", "", "4.1363", "96.1285", "Asia/Jakarta"),
("1214520", "Medan", "Медан", "ID", "360", "26", "", "", "", "3.58333", "98.66667", "Asia/Jakarta"),
("1214658", "Lhokseumawe", "Локсеумаве", "ID", "360", "01", "", "", "", "5.1801", "97.1507", "Asia/Jakarta"),
("1214724", "Langsa", "", "ID", "360", "01", "", "", "", "4.4683", "97.9683", "Asia/Jakarta"),
("1214800", "Labuhan Deli", "", "ID", "360", "26", "", "", "", "3.7278", "98.6738", "Asia/Jakarta"),
("1214882", "Kisaran", "", "ID", "360", "26", "", "", "", "2.9845", "99.6158", "Asia/Jakarta"),
("1214965", "Kabanjahe", "", "ID", "360", "26", "", "", "", "3.1001", "98.4908", "Asia/Jakarta"),
("1215199", "Deli Tua", "", "ID", "360", "26", "", "", "", "3.5078", "98.6839", "Asia/Jakarta"),
("1215350", "Bireun", "", "ID", "360", "01", "", "", "", "5.203", "96.7009", "Asia/Jakarta"),
("1215355", "Binjai", "", "ID", "360", "26", "", "", "", "3.6001", "98.4854", "Asia/Jakarta"),
("1215412", "Belawan", "", "ID", "360", "26", "", "", "", "3.7755", "98.6832", "Asia/Jakarta"),
("1215498", "Bandar", "", "ID", "360", "26", "", "", "", "2.05", "99.75", "Asia/Jakarta"),
("1215502", "Banda Aceh", "Банда-Ачех", "ID", "360", "01", "1171", "", "", "5.5577", "95.3222", "Asia/Jakarta"),
("1621177", "Yogyakarta", "Джокьякарта", "ID", "360", "10", "", "", "", "-7.78278", "110.36083", "Asia/Jakarta"),
("1621395", "Wonosobo", "", "ID", "360", "07", "", "", "", "-7.36", "109.9025", "Asia/Jakarta"),
("1621416", "Wonopringgo", "", "ID", "360", "07", "", "", "", "-6.98333", "109.61667", "Asia/Jakarta"),
("1621439", "Wongsorejo", "", "ID", "360", "08", "", "", "", "-7.9908", "114.4009", "Asia/Jakarta"),
("1621520", "Wiradesa", "", "ID", "360", "07", "", "", "", "-6.8922", "109.619", "Asia/Jakarta"),
("1621613", "Weru", "", "ID", "360", "30", "", "", "", "-6.711", "108.5037", "Asia/Jakarta"),
("1621655", "Weleri", "", "ID", "360", "07", "", "", "", "-6.9713", "110.0666", "Asia/Jakarta"),
("1621659", "Welahan", "", "ID", "360", "07", "", "", "", "-6.8", "110.71667", "Asia/Jakarta"),
("1621678", "Wedi", "", "ID", "360", "07", "", "", "", "-7.74306", "110.57944", "Asia/Jakarta"),
("1621884", "Watampone", "", "ID", "360", "38", "", "", "", "-4.5386", "120.3279", "Asia/Makassar"),
("1622090", "Wangon", "", "ID", "360", "07", "", "", "", "-7.51611", "109.05389", "Asia/Jakarta"),
("1622138", "Wanaraja", "", "ID", "360", "30", "", "", "", "-7.1749", "107.9808", "Asia/Jakarta"),
("1622318", "Waingapu", "", "ID", "360", "18", "", "", "", "-9.6567", "120.2641", "Asia/Makassar"),
("1622636", "Ungaran", "", "ID", "360", "07", "", "", "", "-7.13972", "110.405", "Asia/Jakarta"),
("1622786", "Makassar", "Макассар", "ID", "360", "38", "", "", "", "-5.14", "119.4221", "Asia/Makassar"),
("1622846", "Ubud", "Убуд", "ID", "360", "02", "", "", "", "-8.5098", "115.2654", "Asia/Makassar"),
("1623080", "Tulungagung", "", "ID", "360", "08", "", "", "", "-8.0657", "111.9025", "Asia/Jakarta"),
("1623096", "Tulangan Utara", "", "ID", "360", "08", "", "", "", "-7.4737", "112.6505", "Asia/Jakarta"),
("1623180", "Tuban", "Тубан", "ID", "360", "08", "", "", "", "-6.8976", "112.0649", "Asia/Jakarta"),
("1623197", "Tual", "", "ID", "360", "28", "", "", "", "-5.6193", "132.7886", "Asia/Jayapura"),
("1623223", "Trucuk", "", "ID", "360", "07", "", "", "", "-7.71833", "110.65889", "Asia/Jakarta"),
("1623251", "Trenggalek", "", "ID", "360", "08", "", "", "", "-8.0764", "111.70641", "Asia/Jakarta"),
("1623424", "Tondano", "", "ID", "360", "31", "", "", "", "1.3054", "124.91261", "Asia/Makassar"),
("1623446", "Tomohon", "", "ID", "360", "31", "", "", "", "1.31678", "124.80379", "Asia/Makassar"),
("1624041", "Ternate", "Тернате", "ID", "360", "29", "", "", "", "0.79065", "127.38424", "Asia/Jayapura"),
("1624058", "Terbanggi Besar", "", "ID", "360", "15", "", "", "", "-4.87898", "105.21818", "Asia/Jakarta"),
("1624494", "Tegal", "", "ID", "360", "07", "", "", "", "-6.8694", "109.1402", "Asia/Jakarta"),
("1624545", "Tayu", "", "ID", "360", "07", "", "", "", "-6.5397", "111.0518", "Asia/Jakarta"),
("1624647", "Tasikmalaya", "", "ID", "360", "30", "", "", "", "-7.3274", "108.2207", "Asia/Jakarta"),
("1624668", "Tarub", "", "ID", "360", "07", "", "", "", "-6.93333", "109.16667", "Asia/Jakarta"),
("1624725", "Tarakan", "Таракан", "ID", "360", "42", "", "", "", "3.31332", "117.59152", "Asia/Makassar"),
("1624863", "Tanjungpinang", "", "ID", "360", "40", "", "", "", "0.91667", "104.45", "Asia/Jakarta"),
("1624877", "Tanjung Pandan", "", "ID", "360", "35", "", "", "", "-2.73353", "107.63477", "Asia/Jakarta"),
("1624917", "Bandarlampung", "", "ID", "360", "15", "", "", "", "-5.42544", "105.25803", "Asia/Jakarta"),
("1624987", "Tanjungagung", "", "ID", "360", "32", "", "", "", "-3.93728", "103.80465", "Asia/Jakarta"),
("1625067", "Tanggulangin", "", "ID", "360", "08", "", "", "", "-7.49958", "112.69992", "Asia/Jakarta"),
("1625084", "Tangerang", "Тангеранг", "ID", "360", "33", "", "", "", "-6.17806", "106.63", "Asia/Jakarta"),
("1625708", "Tabanan", "", "ID", "360", "02", "", "", "", "-8.5413", "115.12522", "Asia/Makassar"),
("1625812", "Surakarta", "Суракарте", "ID", "360", "07", "", "", "", "-7.55611", "110.83167", "Asia/Jakarta"),
("1625822", "Surabaya", "Сурабая", "ID", "360", "08", "3578", "", "", "-7.24917", "112.75083", "Asia/Jakarta"),
("1625908", "Sungai Raya", "", "ID", "360", "11", "", "", "", "0.7", "108.9", "Asia/Pontianak"),
("1625929", "Sungai Penuh", "", "ID", "360", "05", "", "", "", "-2.0561", "101.3913", "Asia/Jakarta"),
("1625958", "Sungailiat", "", "ID", "360", "35", "", "", "", "-1.85442", "106.12215", "Asia/Jakarta"),
("1626099", "Sumenep", "", "ID", "360", "08", "", "", "", "-7.01667", "113.86667", "Asia/Jakarta"),
("1626100", "Sumedang Utara", "", "ID", "360", "00", "", "", "", "-6.85", "107.91667", "Asia/Jakarta"),
("1626134", "Sumberpucung", "", "ID", "360", "08", "", "", "", "-8.15856", "112.48292", "Asia/Jakarta"),
("1626183", "Sumber", "", "ID", "360", "30", "", "", "", "-6.76028", "108.48306", "Asia/Jakarta"),
("1626185", "Sumbawa Besar", "", "ID", "360", "17", "Sumbawa (undefined)", "7377422", "", "-8.49317", "117.42024", "Asia/Makassar"),
("1626312", "Sokaraja", "", "ID", "360", "07", "", "", "", "-7.45806", "109.28806", "Asia/Jakarta"),
("1626381", "Sukabumi", "Сукабуми", "ID", "360", "30", "", "", "", "-6.91806", "106.92667", "Asia/Jakarta"),
("1626486", "Srono", "", "ID", "360", "08", "", "", "", "-8.40003", "114.26661", "Asia/Jakarta"),
("1626493", "Srandakan", "", "ID", "360", "10", "", "", "", "-7.93861", "110.25056", "Asia/Jakarta"),
("1626498", "Sragen", "", "ID", "360", "07", "", "", "", "-7.42639", "111.02222", "Asia/Jakarta"),
("1626542", "Sorong", "Соронг", "ID", "360", "39", "", "", "", "-0.87956", "131.26104", "Asia/Jayapura"),
("1626560", "Soreang", "", "ID", "360", "30", "", "", "", "-7.03306", "107.51833", "Asia/Jakarta"),
("1626649", "Solok", "", "ID", "360", "24", "", "", "", "-0.8006", "100.6571", "Asia/Jakarta"),
("1626673", "Soko", "", "ID", "360", "08", "", "", "", "-7.48315", "112.42704", "Asia/Jakarta"),
("1626698", "Sofifi", "", "ID", "360", "29", "", "", "", "0.73333", "127.55", "Asia/Jayapura"),
("1626703", "Soe", "Сое", "ID", "360", "18", "", "", "", "-9.86071", "124.28395", "Asia/Makassar"),
("1626754", "Sleman", "", "ID", "360", "10", "", "", "", "-7.71556", "110.35556", "Asia/Jakarta"),
("1626758", "Slawi", "", "ID", "360", "07", "", "", "", "-6.9816", "109.1407", "Asia/Jakarta"),
("1626801", "Situbondo", "", "ID", "360", "08", "", "", "", "-7.70623", "114.00976", "Asia/Jakarta"),
("1626895", "Sinjai", "", "ID", "360", "38", "", "", "", "-5.1241", "120.253", "Asia/Makassar"),
("1626899", "Singosari", "Сингосари", "ID", "360", "08", "", "", "", "-7.8924", "112.6658", "Asia/Jakarta"),
("1626903", "Singojuruh", "", "ID", "360", "08", "", "", "", "-8.31667", "114.23333", "Asia/Jakarta"),
("1626916", "Singkawang", "", "ID", "360", "11", "", "", "", "0.90925", "108.98463", "Asia/Pontianak"),
("1626921", "Sengkang", "", "ID", "360", "38", "", "", "", "-4.1279", "120.0297", "Asia/Makassar"),
("1626932", "Singaraja", "Сингараджа", "ID", "360", "02", "", "", "", "-8.112", "115.08818", "Asia/Makassar"),
("1626936", "Singaparna", "", "ID", "360", "30", "", "", "", "-7.3515", "108.111", "Asia/Jakarta"),
("1627035", "Simpang", "", "ID", "360", "05", "", "", "", "-1.26424", "104.09701", "Asia/Jakarta"),
("1627185", "Sijunjung", "", "ID", "360", "24", "", "", "", "-0.7005", "100.9774", "Asia/Jakarta"),
("1627253", "Sidoarjo", "", "ID", "360", "08", "", "", "", "-7.4478", "112.7183", "Asia/Jakarta"),
("1627267", "Sidareja", "", "ID", "360", "07", "", "", "", "-7.4846", "108.7923", "Asia/Jakarta"),
("1627357", "Sewon", "", "ID", "360", "10", "", "", "", "-7.87639", "110.35889", "Asia/Jakarta"),
("1627459", "Serpong", "", "ID", "360", "30", "", "", "", "-6.31694", "106.66417", "Asia/Jakarta"),
("1627549", "Serang", "", "ID", "360", "33", "", "", "", "-6.1149", "106.1502", "Asia/Jakarta"),
("1627610", "Sepatan", "", "ID", "360", "30", "", "", "", "-6.11889", "106.575", "Asia/Jakarta"),
("1627896", "Semarang", "Семаранг", "ID", "360", "07", "", "", "", "-6.9932", "110.4203", "Asia/Jakarta"),
("1627969", "Selogiri", "", "ID", "360", "07", "", "", "", "-7.78333", "110.86667", "Asia/Jakarta"),
("1628453", "Sawangan", "", "ID", "360", "30", "", "", "", "-6.40278", "106.77444", "Asia/Jakarta"),
("1628884", "Sampit", "", "ID", "360", "13", "", "", "", "-2.5315", "112.9496", "Asia/Pontianak"),
("1628899", "Sampang", "", "ID", "360", "08", "", "", "", "-7.1872", "113.2394", "Asia/Jakarta"),
("1629001", "Samarinda", "Самаринда", "ID", "360", "14", "", "", "", "-0.48585", "117.1466", "Asia/Makassar"),
("1629131", "Salatiga", "", "ID", "360", "07", "", "", "", "-7.33194", "110.49278", "Asia/Jakarta"),
("1629380", "Ruteng", "", "ID", "360", "18", "", "", "", "-8.6136", "120.4721", "Asia/Makassar"),
("1629710", "Rengasdengklok", "", "ID", "360", "30", "", "", "", "-6.15917", "107.29806", "Asia/Jakarta"),
("1629749", "Rembangan", "", "ID", "360", "07", "", "", "", "-6.7036", "111.3416", "Asia/Jakarta"),
("1629974", "Rantepao", "", "ID", "360", "38", "", "", "", "-2.9701", "119.8978", "Asia/Makassar"),
("1630058", "Rangkasbitung", "", "ID", "360", "33", "", "", "", "-6.3591", "106.2494", "Asia/Jakarta"),
("1630088", "Randudongkal", "", "ID", "360", "07", "", "", "", "-7.0981", "109.3243", "Asia/Jakarta"),
("1630200", "Rajapolah", "", "ID", "360", "30", "", "", "", "-7.221", "108.1896", "Asia/Jakarta"),
("1630328", "Purwokerto", "", "ID", "360", "07", "", "", "", "-7.42139", "109.23444", "Asia/Jakarta"),
("1630333", "Purwodadi", "", "ID", "360", "07", "", "", "", "-7.0868", "110.9158", "Asia/Jakarta"),
("1630341", "Purwakarta", "", "ID", "360", "30", "", "", "", "-6.55694", "107.44333", "Asia/Jakarta"),
("1630366", "Purbalingga", "", "ID", "360", "07", "", "", "", "-7.38806", "109.36389", "Asia/Jakarta"),
("1630416", "Pundong", "", "ID", "360", "10", "", "", "", "-7.95222", "110.34861", "Asia/Jakarta"),
("1630634", "Probolinggo", "", "ID", "360", "08", "", "", "", "-7.7543", "113.2159", "Asia/Jakarta"),
("1630649", "Prigen", "", "ID", "360", "08", "", "", "", "-7.68333", "112.61667", "Asia/Jakarta"),
("1630662", "Praya", "Прая", "ID", "360", "17", "Lombok (undefined)", "", "", "-8.70536", "116.27036", "Asia/Makassar"),
("1630681", "Candi Prambanan", "", "ID", "360", "07", "", "", "", "-7.75", "110.49417", "Asia/Jakarta"),
("1630723", "Poso", "Посо", "ID", "360", "21", "", "", "", "-1.3959", "120.7524", "Asia/Makassar"),
("1630789", "Pontianak", "Понтианак", "ID", "360", "11", "", "", "", "-0.03109", "109.32199", "Asia/Pontianak"),
("1630798", "Ponorogo", "", "ID", "360", "08", "", "", "", "-7.8685", "111.462", "Asia/Jakarta"),
("1630935", "Polewali", "", "ID", "360", "41", "", "", "", "-3.4324", "119.3435", "Asia/Makassar"),
("1630997", "Plumbon", "", "ID", "360", "30", "", "", "", "-6.705", "108.47278", "Asia/Jakarta"),
("1631271", "Petarukan", "", "ID", "360", "07", "", "", "", "-6.88333", "109.43333", "Asia/Jakarta"),
("1631393", "Prabumulih", "", "ID", "360", "32", "", "", "", "-3.43447", "104.23056", "Asia/Jakarta"),
("1631637", "Pemangkat", "", "ID", "360", "11", "", "", "", "1.16667", "108.96667", "Asia/Pontianak"),
("1631648", "Pemalang", "", "ID", "360", "07", "", "", "", "-6.9", "109.36667", "Asia/Jakarta"),
("1631733", "Pelabuhanratu", "", "ID", "360", "30", "", "", "", "-6.9875", "106.55139", "Asia/Jakarta"),
("1631761", "Pekanbaru", "Пеканбару", "ID", "360", "37", "", "", "", "0.53333", "101.45", "Asia/Jakarta"),
("1631766", "Pekalongan", "", "ID", "360", "07", "", "", "", "-6.8886", "109.6753", "Asia/Jakarta"),
("1631851", "Pecangaan", "", "ID", "360", "07", "", "", "", "-6.6978", "110.7107", "Asia/Jakarta"),
("1631905", "Payakumbuh", "", "ID", "360", "24", "", "", "", "-0.2159", "100.6334", "Asia/Jakarta"),
("1631992", "Pati", "Пати", "ID", "360", "07", "", "", "", "-6.7559", "111.038", "Asia/Jakarta"),
("1632033", "Pasuruan", "", "ID", "360", "08", "", "", "", "-7.6453", "112.9075", "Asia/Jakarta"),
("1632197", "Paseh", "", "ID", "360", "30", "", "", "", "-7.1026", "107.7641", "Asia/Jakarta"),
("1632228", "Pasarkemis", "", "ID", "360", "30", "", "", "", "-6.17028", "106.53028", "Asia/Jakarta"),
("1632276", "Parung", "", "ID", "360", "30", "", "", "", "-6.42139", "106.73306", "Asia/Jakarta"),
("1632334", "Pariaman", "", "ID", "360", "24", "", "", "", "-0.61898", "100.11997", "Asia/Jakarta"),
("1632353", "Parepare", "", "ID", "360", "38", "", "", "", "-4.0135", "119.6255", "Asia/Makassar"),
("1632358", "Pare", "", "ID", "360", "08", "", "", "", "-7.7679", "112.198", "Asia/Jakarta"),
("1632566", "Panji", "", "ID", "360", "08", "", "", "", "-7.72528", "114.09954", "Asia/Jakarta"),
("1632654", "Pangkalpinang", "", "ID", "360", "35", "", "", "", "-2.12914", "106.11377", "Asia/Jakarta"),
("1632694", "Pangkalanbuun", "", "ID", "360", "13", "", "", "", "-2.6832", "111.6259", "Asia/Pontianak"),
("1632823", "Pandeglang", "", "ID", "360", "33", "", "", "", "-6.3084", "106.1067", "Asia/Jakarta"),
("1632859", "Pandaan", "", "ID", "360", "08", "", "", "", "-7.65268", "112.6875", "Asia/Jakarta"),
("1632861", "Pandak", "", "ID", "360", "10", "", "", "", "-7.91306", "110.29361", "Asia/Jakarta"),
("1632903", "Panarukan", "", "ID", "360", "08", "", "", "", "-7.70181", "113.91844", "Asia/Jakarta"),
("1632937", "Pamulang", "", "ID", "360", "30", "", "", "", "-6.34278", "106.73833", "Asia/Jakarta"),
("1632974", "Pameungpeuk", "", "ID", "360", "30", "", "", "", "-7.01833", "107.60389", "Asia/Jakarta"),
("1632978", "Pamekasan", "", "ID", "360", "08", "", "", "", "-7.1568", "113.4746", "Asia/Jakarta"),
("1632998", "Pamanukan", "", "ID", "360", "30", "", "", "", "-6.28417", "107.81056", "Asia/Jakarta"),
("1633034", "Palu", "Пал", "ID", "360", "21", "", "", "", "-0.8917", "119.8707", "Asia/Makassar"),
("1633037", "Palopo", "", "ID", "360", "38", "", "", "", "-2.9925", "120.19694", "Asia/Makassar"),
("1633056", "Palimanan", "", "ID", "360", "30", "", "", "", "-6.70694", "108.42417", "Asia/Jakarta"),
("1633070", "Palembang", "Палембанг", "ID", "360", "32", "", "", "", "-2.91673", "104.7458", "Asia/Jakarta"),
("1633118", "Palangkaraya", "", "ID", "360", "13", "", "", "", "-2.2136", "113.9108", "Asia/Pontianak"),
("1633182", "Pakisaji", "", "ID", "360", "08", "", "", "", "-8.0665", "112.5981", "Asia/Jakarta"),
("1633308", "Pageralam", "", "ID", "360", "32", "", "", "", "-4.02177", "103.25093", "Asia/Jakarta"),
("1633419", "Padang", "Паданг", "ID", "360", "24", "", "", "", "-0.94924", "100.35427", "Asia/Jakarta"),
("1633442", "Paciran", "", "ID", "360", "08", "", "", "", "-6.87666", "112.37606", "Asia/Jakarta"),
("1633986", "Ngunut", "", "ID", "360", "08", "", "", "", "-8.1058", "112.01591", "Asia/Jakarta"),
("1634010", "Ngoro", "", "ID", "360", "08", "", "", "", "-7.68386", "112.25804", "Asia/Jakarta"),
("1634098", "Ngawi", "", "ID", "360", "30", "", "", "", "-7.4038", "111.4461", "Asia/Jakarta"),
("1634131", "Nganjuk", "", "ID", "360", "08", "", "", "", "-7.6051", "111.9035", "Asia/Jakarta"),
("1634266", "Negara", "", "ID", "360", "02", "", "", "", "-8.35694", "114.61694", "Asia/Makassar"),
("1634614", "Nabire", "", "ID", "360", "36", "", "", "", "-3.35989", "135.50074", "Asia/Jayapura"),
("1634678", "Muntok", "", "ID", "360", "35", "", "", "", "-2.06719", "105.16228", "Asia/Jakarta"),
("1634680", "Muntilan", "", "ID", "360", "07", "", "", "", "-7.58111", "110.29278", "Asia/Jakarta"),
("1634718", "Muncar", "", "ID", "360", "08", "", "", "", "-8.43333", "114.33333", "Asia/Jakarta"),
("1634954", "Mranggen", "", "ID", "360", "07", "", "", "", "-7.0268", "110.5158", "Asia/Jakarta"),
("1635111", "Mojokerto", "", "ID", "360", "08", "", "", "", "-7.4664", "112.4338", "Asia/Jakarta"),
("1635116", "Mojoagung", "", "ID", "360", "08", "", "", "", "-7.56667", "112.35", "Asia/Jakarta"),
("1635164", "Mlonggo", "", "ID", "360", "07", "", "", "", "-6.53333", "110.7", "Asia/Jakarta"),
("1635283", "Metro", "Метро", "ID", "360", "15", "", "", "", "-5.11306", "105.30667", "Asia/Jakarta"),
("1635342", "Mertoyudan", "", "ID", "360", "07", "", "", "", "-7.52", "110.22639", "Asia/Jakarta"),
("1635660", "Melati", "", "ID", "360", "10", "", "", "", "-7.73333", "110.36667", "Asia/Jakarta"),
("1635815", "Maumere", "", "ID", "360", "18", "", "", "", "-8.6199", "122.2111", "Asia/Makassar"),
("1635882", "Mataram", "Матарам", "ID", "360", "17", "Lombok (undefined)", "", "", "-8.58333", "116.11667", "Asia/Makassar"),
("1636022", "Martapura", "", "ID", "360", "12", "", "", "", "-3.4109", "114.8642", "Asia/Makassar"),
("1636121", "Margasari", "", "ID", "360", "07", "", "", "", "-7.1", "109.01667", "Asia/Jakarta"),
("1636125", "Margahayukencana", "", "ID", "360", "30", "", "", "", "-6.97083", "107.5675", "Asia/Jakarta"),
("1636308", "Manokwari", "Маноквари", "ID", "360", "39", "", "", "", "-0.86667", "134.08333", "Asia/Jayapura"),
("1636322", "Manismata", "", "ID", "360", "11", "", "", "", "-2.46667", "111.03333", "Asia/Pontianak"),
("1636426", "Manggar", "", "ID", "360", "35", "", "", "", "-2.88333", "108.26667", "Asia/Jakarta"),
("1636507", "Mendaha", "", "ID", "360", "05", "", "", "", "-1.0163", "103.59331", "Asia/Jakarta"),
("1636544", "Manado", "Манадо", "ID", "360", "31", "", "", "", "1.48218", "124.84892", "Asia/Makassar"),
("1636722", "Malang", "Маланг", "ID", "360", "08", "", "", "", "-7.9797", "112.6304", "Asia/Jakarta"),
("1636806", "Majene", "", "ID", "360", "41", "", "", "", "-3.5403", "118.9707", "Asia/Makassar"),
("1636808", "Majenang", "", "ID", "360", "07", "", "", "", "-7.2975", "108.7642", "Asia/Jakarta"),
("1636816", "Majalengka", "", "ID", "360", "30", "", "", "", "-6.83611", "108.22778", "Asia/Jakarta"),
("1636884", "Magelang", "Магеланг", "ID", "360", "07", "", "", "", "-7.47056", "110.21778", "Asia/Jakarta"),
("1636930", "Madiun", "", "ID", "360", "08", "", "", "", "-7.6298", "111.5239", "Asia/Jakarta"),
("1637001", "Luwuk", "", "ID", "360", "21", "", "", "", "-0.9516", "122.7875", "Asia/Makassar"),
("1637090", "Lumajang", "", "ID", "360", "08", "", "", "", "-8.1335", "113.2248", "Asia/Jakarta"),
("1637158", "Lubuklinggau", "", "ID", "360", "32", "", "", "", "-3.2945", "102.8614", "Asia/Jakarta"),
("1637510", "Loa Janan", "", "ID", "360", "14", "", "", "", "-0.58295", "117.09503", "Asia/Makassar"),
("1638063", "Lembang", "Лембанге", "ID", "360", "30", "", "", "", "-6.81167", "107.6175", "Asia/Jakarta"),
("1638217", "Lebaksiu", "", "ID", "360", "07", "", "", "", "-7.0496", "109.1441", "Asia/Jakarta"),
("1638284", "Lawang", "", "ID", "360", "08", "", "", "", "-7.8353", "112.6947", "Asia/Jakarta"),
("1638352", "Lasem", "", "ID", "360", "07", "", "", "", "-6.6922", "111.4527", "Asia/Jakarta"),
("1638562", "Lamongan", "", "ID", "360", "08", "", "", "", "-7.11667", "112.41667", "Asia/Jakarta"),
("1638775", "Lahat", "", "ID", "360", "32", "", "", "", "-3.78514", "103.54279", "Asia/Jakarta"),
("1638868", "Labuhanbajo", "Лабуанбаджо", "ID", "360", "18", "", "", "", "-8.4964", "119.8877", "Asia/Makassar"),
("1638870", "Labuan", "", "ID", "360", "33", "", "", "", "-6.3784", "105.83", "Asia/Jakarta"),
("1638981", "Kutoarjo", "", "ID", "360", "07", "", "", "", "-7.71694", "109.91278", "Asia/Jakarta"),
("1639002", "Kuta", "Кута", "ID", "360", "02", "", "", "", "-8.72332", "115.17234", "Asia/Makassar"),
("1639094", "Kuningan", "", "ID", "360", "30", "", "", "", "-6.97583", "108.48306", "Asia/Jakarta"),
("1639215", "Kudus", "", "ID", "360", "07", "", "", "", "-6.8048", "110.8405", "Asia/Jakarta"),
("1639286", "Kualatungkal", "", "ID", "360", "05", "", "", "", "-0.81623", "103.46111", "Asia/Jakarta"),
("1639304", "Kualakapuas", "", "ID", "360", "13", "", "", "", "-3.00913", "114.38759", "Asia/Pontianak"),
("1639337", "Kroya", "", "ID", "360", "07", "", "", "", "-7.63306", "109.24611", "Asia/Jakarta"),
("1639356", "Krian", "", "ID", "360", "08", "", "", "", "-7.4104", "112.5792", "Asia/Jakarta"),
("1639362", "Kresek", "", "ID", "360", "30", "", "", "", "-6.13139", "106.37972", "Asia/Jakarta"),
("1639431", "Kraksaan", "", "ID", "360", "08", "", "", "", "-7.75845", "113.39624", "Asia/Jakarta"),
("1639524", "Kotabumi", "", "ID", "360", "15", "", "", "", "-4.82505", "104.8817", "Asia/Jakarta"),
("1639850", "Klungkung", "", "ID", "360", "02", "", "", "", "-8.53333", "115.4", "Asia/Makassar"),
("1639900", "Klaten", "", "ID", "360", "07", "", "", "", "-7.70583", "110.60639", "Asia/Jakarta"),
("1639925", "Klangenan", "", "ID", "360", "30", "", "", "", "-6.70944", "108.44", "Asia/Jakarta"),
("1640044", "Kijang", "", "ID", "360", "40", "", "", "", "0.9", "104.63333", "Asia/Jakarta"),
("1640138", "Ketanggungan", "", "ID", "360", "07", "", "", "", "-6.9383", "108.891", "Asia/Jakarta"),
("1640185", "Kertosono", "", "ID", "360", "08", "", "", "", "-7.58333", "112.1", "Asia/Jakarta"),
("1640296", "Kepanjen", "", "ID", "360", "08", "", "", "", "-8.1303", "112.5727", "Asia/Jakarta"),
("1640344", "Kendari", "Кендари", "ID", "360", "22", "", "", "", "-3.9778", "122.51507", "Asia/Makassar"),
("1640354", "Kencong", "", "ID", "360", "08", "", "", "", "-8.28333", "113.36667", "Asia/Jakarta"),
("1640576", "Kefamenanu", "", "ID", "360", "18", "", "", "", "-9.44667", "124.47806", "Asia/Makassar"),
("1640581", "Kedungwuni", "", "ID", "360", "07", "", "", "", "-6.97038", "109.64794", "Asia/Jakarta"),
("1640585", "Kedungwaru", "", "ID", "360", "08", "", "", "", "-8.06667", "111.91667", "Asia/Jakarta"),
("1640660", "Kediri", "", "ID", "360", "08", "", "", "", "-7.81667", "112.01667", "Asia/Jakarta"),
("1640755", "Kebonarun", "", "ID", "360", "07", "", "", "", "-7.70028", "110.56306", "Asia/Jakarta"),
("1640765", "Kebomas", "", "ID", "360", "08", "", "", "", "-7.16667", "112.6333", "Asia/Jakarta"),
("1640902", "Kawalu", "", "ID", "360", "30", "", "", "", "-7.3817", "108.2082", "Asia/Jakarta"),
("1640972", "Katabu", "", "ID", "360", "22", "", "", "", "-4.9333", "122.5167", "Asia/Makassar"),
("1641184", "Karangsembung", "", "ID", "360", "30", "", "", "", "-6.8487", "108.6422", "Asia/Jakarta"),
("1641301", "Karangasem", "Денпасар", "ID", "360", "02", "", "", "", "-8.45", "115.61667", "Asia/Makassar"),
("1641333", "Karanganom", "", "ID", "360", "07", "", "", "", "-7.64889", "110.625", "Asia/Jakarta"),
("1641342", "Karangampel", "", "ID", "360", "30", "", "", "", "-6.46222", "108.45194", "Asia/Jakarta"),
("1641792", "Kamal", "Камаль", "ID", "360", "08", "", "", "", "-7.16778", "112.71917", "Asia/Jakarta"),
("1641977", "Kalianget", "", "ID", "360", "08", "", "", "", "-7.0537", "113.94244", "Asia/Jakarta"),
("1642317", "Juwana", "", "ID", "360", "07", "", "", "", "-6.715", "111.1514", "Asia/Jakarta"),
("1642414", "Jombang", "", "ID", "360", "08", "", "", "", "-7.54595", "112.23307", "Asia/Jakarta"),
("1642437", "Jogonalan", "", "ID", "360", "07", "", "", "", "-7.70361", "110.53611", "Asia/Jakarta"),
("1642588", "Jember", "", "ID", "360", "08", "", "", "", "-8.17211", "113.69953", "Asia/Jakarta"),
("1642628", "Jekulo", "", "ID", "360", "07", "", "", "", "-6.8057", "110.9262", "Asia/Jakarta"),
("1642684", "Jatiwangi", "", "ID", "360", "30", "", "", "", "-6.73361", "108.26278", "Asia/Jakarta"),
("1642692", "Jatiroto", "", "ID", "360", "07", "", "", "", "-7.88333", "111.11667", "Asia/Jakarta"),
("1642726", "Jatibarang", "", "ID", "360", "30", "", "", "", "-6.47472", "108.31528", "Asia/Jakarta"),
("1642754", "Jaten", "", "ID", "360", "07", "", "", "", "-7.57722", "110.8975", "Asia/Jakarta"),
("1642858", "Jambi City", "Джамби", "ID", "360", "05", "", "", "", "-1.6", "103.61667", "Asia/Jakarta"),
("1642911", "Jakarta", "Джакарта", "ID", "360", "04", "", "", "", "-6.21462", "106.84513", "Asia/Jakarta"),
("1643078", "Indramayu", "", "ID", "360", "30", "", "", "", "-6.32639", "108.32", "Asia/Jakarta"),
("1643761", "Grogol", "", "ID", "360", "07", "", "", "", "-7.60111", "110.81861", "Asia/Jakarta"),
("1643776", "Gresik", "", "ID", "360", "08", "", "", "", "-7.15389", "112.65611", "Asia/Jakarta"),
("1643837", "Gorontalo", "Горонтало", "ID", "360", "34", "", "", "", "0.5412", "123.0595", "Asia/Makassar"),
("1643898", "Gongdanglegi Kulon", "", "ID", "360", "08", "", "", "", "-8.17529", "112.63594", "Asia/Jakarta"),
("1643920", "Gombong", "", "ID", "360", "07", "", "", "", "-7.60722", "109.51417", "Asia/Jakarta"),
("1643981", "Godean", "", "ID", "360", "10", "", "", "", "-7.76972", "110.29389", "Asia/Jakarta"),
("1644178", "Genteng", "", "ID", "360", "08", "", "", "", "-8.36667", "114.15", "Asia/Jakarta"),
("1644349", "Gedangan", "", "ID", "360", "08", "", "", "", "-7.39083", "112.72667", "Asia/Jakarta"),
("1644360", "Gebog", "", "ID", "360", "07", "", "", "", "-6.735", "110.8444", "Asia/Jakarta"),
("1644522", "Gampengrejo", "", "ID", "360", "08", "", "", "", "-7.76667", "112.01667", "Asia/Jakarta"),
("1644557", "Gambiran Satu", "", "ID", "360", "08", "", "", "", "-8.3939", "114.1464", "Asia/Jakarta"),
("1644605", "Galesong", "", "ID", "360", "38", "", "", "", "-5.3166", "119.3661", "Asia/Makassar"),
("1644932", "Ende", "", "ID", "360", "18", "", "", "", "-8.8432", "121.6623", "Asia/Makassar"),
("1645133", "Dumai", "Думай", "ID", "360", "37", "", "", "", "1.66711", "101.44316", "Asia/Jakarta"),
("1645154", "Dukuhturi", "", "ID", "360", "07", "", "", "", "-6.9", "109.08333", "Asia/Jakarta"),
("1645220", "Driyorejo", "", "ID", "360", "08", "", "", "", "-7.3659", "112.6219", "Asia/Jakarta"),
("1645428", "Diwek", "", "ID", "360", "08", "", "", "", "-7.57897", "112.23109", "Asia/Jakarta"),
("1645518", "Depok", "", "ID", "360", "10", "", "", "", "-7.7625", "110.43167", "Asia/Jakarta"),
("1645524", "Depok", "", "ID", "360", "30", "", "", "", "-6.4", "106.81861", "Asia/Jakarta"),
("1645528", "Denpasar", "Денпасар", "ID", "360", "02", "", "", "", "-8.65", "115.21667", "Asia/Makassar"),
("1645559", "Demak", "Демак", "ID", "360", "07", "", "", "", "-6.8909", "110.6396", "Asia/Jakarta"),
("1645565", "Delanggu", "", "ID", "360", "07", "", "", "", "-7.61667", "110.68333", "Asia/Jakarta"),
("1645749", "Dampit", "", "ID", "360", "08", "", "", "", "-8.21162", "112.74934", "Asia/Jakarta"),
("1645875", "Curup", "", "ID", "360", "03", "", "", "", "-3.4703", "102.5207", "Asia/Jakarta"),
("1645895", "Curug", "", "ID", "360", "33", "", "", "", "-6.26583", "106.55639", "Asia/Jakarta"),
("1645976", "Comal", "", "ID", "360", "07", "", "", "", "-6.9053", "109.5347", "Asia/Jakarta"),
("1645978", "Colomadu", "", "ID", "360", "07", "", "", "", "-7.53333", "110.75", "Asia/Jakarta"),
("1646034", "Citeureup", "", "ID", "360", "30", "", "", "", "-6.48556", "106.88194", "Asia/Jakarta"),
("1646170", "Cirebon", "Чиребон", "ID", "360", "30", "", "", "", "-6.7063", "108.557", "Asia/Jakarta"),
("1646194", "Ciputat", "", "ID", "360", "30", "", "", "", "-6.2375", "106.69556", "Asia/Jakarta"),
("1646448", "Cimahi", "", "ID", "360", "30", "", "", "", "-6.87222", "107.5425", "Asia/Jakarta"),
("1646492", "Cileunyi", "", "ID", "360", "30", "", "", "", "-6.93889", "107.75278", "Asia/Jakarta"),
("1646494", "Cileungsir", "", "ID", "360", "30", "", "", "", "-6.39472", "106.95917", "Asia/Jakarta"),
("1646678", "Cikarang", "", "ID", "360", "30", "", "", "", "-6.26111", "107.15278", "Asia/Jakarta"),
("1646698", "Cikampek", "", "ID", "360", "30", "", "", "", "-6.41972", "107.45583", "Asia/Jakarta"),
("1646893", "Cicurug", "", "ID", "360", "30", "", "", "", "-6.78139", "106.7825", "Asia/Jakarta"),
("1647003", "Cibinong", "Сибинонге", "ID", "360", "30", "", "", "", "-6.48167", "106.85417", "Asia/Jakarta"),
("1647149", "Ciamis", "", "ID", "360", "30", "", "", "", "-7.3257", "108.3534", "Asia/Jakarta"),
("1647179", "Cepu", "", "ID", "360", "07", "", "", "", "-7.1475", "111.5906", "Asia/Jakarta"),
("1647187", "Ceper", "", "ID", "360", "07", "", "", "", "-7.67417", "110.67889", "Asia/Jakarta"),
("1647298", "Caringin", "", "ID", "360", "30", "", "", "", "-6.70611", "106.82139", "Asia/Jakarta"),
("1647383", "Ciampea", "", "ID", "360", "30", "", "", "", "-6.55472", "106.70083", "Asia/Jakarta"),
("1647834", "Bulakamba", "", "ID", "360", "07", "", "", "", "-6.8748", "108.9559", "Asia/Jakarta"),
("1647866", "Bukittinggi", "", "ID", "360", "24", "", "", "", "-0.30907", "100.37055", "Asia/Jakarta"),
("1647936", "Buduran", "", "ID", "360", "08", "", "", "", "-7.4281", "112.7234", "Asia/Jakarta"),
("1647991", "Buaran", "", "ID", "360", "07", "", "", "", "-7.05", "109.55", "Asia/Jakarta"),
("1648082", "Boyolangu", "", "ID", "360", "08", "", "", "", "-8.1181", "111.8935", "Asia/Jakarta"),
("1648084", "Boyolali", "", "ID", "360", "07", "", "", "", "-7.53306", "110.59583", "Asia/Jakarta"),
("1648186", "Bontang", "", "ID", "360", "14", "", "", "", "0.1324", "117.4854", "Asia/Makassar"),
("1648266", "Bondowoso", "", "ID", "360", "08", "", "", "", "-7.91346", "113.82145", "Asia/Jakarta"),
("1648451", "Bojonegoro", "", "ID", "360", "08", "", "", "", "-7.1502", "111.8817", "Asia/Jakarta"),
("1648473", "Bogor", "Богор", "ID", "360", "30", "", "", "", "-6.59444", "106.78917", "Asia/Jakarta"),
("1648568", "Blora", "", "ID", "360", "07", "", "", "", "-6.9698", "111.4186", "Asia/Jakarta"),
("1648580", "Blitar", "", "ID", "360", "08", "", "", "", "-8.0983", "112.1681", "Asia/Jakarta"),
("1648636", "Bitung", "", "ID", "360", "31", "", "", "", "1.45697", "125.1895", "Asia/Makassar"),
("1648759", "Bima", "Бим", "ID", "360", "17", "Bima City (undefined)", "", "", "-8.46006", "118.72667", "Asia/Makassar"),
("1648918", "Besuki", "", "ID", "360", "08", "", "", "", "-7.73379", "113.69785", "Asia/Jakarta"),
("1649150", "Bengkulu", "Бенгкулу", "ID", "360", "03", "", "", "", "-3.80044", "102.26554", "Asia/Jakarta"),
("1649378", "Bekasi", "Бекаси", "ID", "360", "30", "", "", "", "-6.2349", "106.9896", "Asia/Jakarta"),
("1649593", "Baturaja", "", "ID", "360", "32", "", "", "", "-4.12891", "104.16695", "Asia/Jakarta"),
("1649595", "Baturaden", "", "ID", "360", "07", "", "", "", "-7.3", "109.21667", "Asia/Jakarta"),
("1649824", "Batu", "Батый", "ID", "360", "08", "", "", "", "-7.87", "112.52833", "Asia/Jakarta"),
("1649881", "Batang", "", "ID", "360", "07", "", "", "", "-6.4846", "110.7083", "Asia/Jakarta"),
("1650064", "Barabai", "", "ID", "360", "12", "", "", "", "-2.58333", "115.38333", "Asia/Makassar"),
("1650077", "Banyuwangi", "", "ID", "360", "08", "", "", "", "-8.2325", "114.35755", "Asia/Jakarta"),
("1650095", "Banyumas", "", "ID", "360", "07", "", "", "", "-7.51417", "109.29417", "Asia/Jakarta"),
("1650119", "Bantul", "", "ID", "360", "10", "", "", "", "-7.88806", "110.32889", "Asia/Jakarta"),
("1650213", "Banjarmasin", "", "ID", "360", "12", "", "", "", "-3.31987", "114.59075", "Asia/Makassar"),
("1650227", "Banjaran", "", "ID", "360", "30", "", "", "", "-7.04528", "107.58778", "Asia/Jakarta"),
("1650232", "Banjar", "", "ID", "360", "02", "", "", "", "-8.19", "114.9675", "Asia/Makassar"),
("1650234", "Banjar", "", "ID", "360", "30", "", "", "", "-7.1955", "107.4313", "Asia/Jakarta"),
("1650298", "Bangkalan", "", "ID", "360", "08", "", "", "", "-7.0455", "112.7351", "Asia/Jakarta"),
("1650319", "Bangil", "", "ID", "360", "08", "", "", "", "-7.59939", "112.8186", "Asia/Jakarta"),
("1650357", "Bandung", "Бандунг", "ID", "360", "30", "", "", "", "-6.90389", "107.61861", "Asia/Jakarta"),
("1650434", "Bambanglipuro", "", "ID", "360", "10", "", "", "", "-7.95", "110.28333", "Asia/Jakarta"),
("1650460", "Balung", "", "ID", "360", "08", "", "", "", "-7.73333", "113.91667", "Asia/Jakarta"),
("1650527", "Balikpapan", "Баликпапан", "ID", "360", "14", "", "", "", "-1.26753", "116.82887", "Asia/Makassar"),
("1650572", "Balapulang", "", "ID", "360", "07", "", "", "", "-7.05", "109.08333", "Asia/Jakarta"),
("1650600", "Balaipungut", "", "ID", "360", "37", "", "", "", "1.05949", "101.29054", "Asia/Jakarta"),
("1650670", "Baki", "", "ID", "360", "07", "", "", "", "-7.61278", "110.78389", "Asia/Jakarta"),
("1650815", "Baekrajan", "Бэ", "ID", "360", "07", "", "", "", "-6.7674", "110.8541", "Asia/Jakarta"),
("1650888", "Babat", "Бабат", "ID", "360", "08", "", "", "", "-7.11282", "112.16354", "Asia/Jakarta"),
("1651103", "Atambua", "Атамбуа", "ID", "360", "18", "", "", "", "-9.10611", "124.8925", "Asia/Makassar"),
("1651112", "Astanajapura", "", "ID", "360", "30", "", "", "", "-6.8017", "108.6311", "Asia/Jakarta"),
("1651226", "Arjawinangun", "", "ID", "360", "30", "", "", "", "-6.64528", "108.41028", "Asia/Jakarta"),
("1651461", "Amuntai", "", "ID", "360", "12", "", "", "", "-2.41773", "115.24941", "Asia/Makassar"),
("1651531", "Ambon", "Амбон", "ID", "360", "28", "", "", "", "-3.69543", "128.1814", "Asia/Jayapura"),
("1651555", "Ambarawa", "", "ID", "360", "07", "", "", "", "-7.26333", "110.3975", "Asia/Jakarta"),
("1651591", "Amahai", "", "ID", "360", "28", "", "", "", "-3.33984", "128.91975", "Asia/Jayapura"),
("1651887", "Adiwerna", "", "ID", "360", "07", "", "", "", "-6.9375", "109.1325", "Asia/Jakarta"),
("1963770", "Padalarang", "", "ID", "360", "30", "", "", "", "-6.83778", "107.47278", "Asia/Jakarta"),
("1964032", "Ciranjang-hilir", "", "ID", "360", "30", "", "", "", "-6.82", "107.25722", "Asia/Jakarta"),
("1985663", "Cikupa", "", "ID", "360", "30", "", "", "", "-6.23639", "106.50833", "Asia/Jakarta"),
("1990589", "Teluknaga", "", "ID", "360", "30", "", "", "", "-6.09889", "106.63806", "Asia/Jakarta"),
("2002872", "Wonosari", "", "ID", "360", "10", "", "", "", "-7.96556", "110.60361", "Asia/Jakarta"),
("2005057", "Gamping Lor", "", "ID", "360", "10", "", "", "", "-7.79556", "110.32639", "Asia/Jakarta"),
("2005237", "Kasihan", "", "ID", "360", "10", "", "", "", "-7.82694", "110.32917", "Asia/Jakarta"),
("2010971", "Ngemplak", "", "ID", "360", "07", "", "", "", "-7.54972", "110.71639", "Asia/Jakarta"),
("2010985", "Kartasura", "", "ID", "360", "07", "", "", "", "-7.55194", "110.73778", "Asia/Jakarta"),
("2011457", "Gatak", "", "ID", "360", "07", "", "", "", "-7.59083", "110.70444", "Asia/Jakarta"),
("2057087", "Kupang", "Купанге", "ID", "360", "18", "", "", "", "-10.1718", "123.6075", "Asia/Makassar"),
("2082600", "Jayapura", "Джаяпура", "ID", "360", "36", "", "", "", "-2.53371", "140.71813", "Asia/Jayapura"),
("2082727", "Abepura", "", "ID", "360", "36", "", "", "", "-2.5964", "140.6324", "Asia/Jayapura"),
("7084521", "Seririt", "Серирит", "ID", "360", "02", "", "", "", "-8.1928", "114.9388", "Asia/Makassar"),
("7870153", "Masjid Jamie Baitul Muttaqien", "", "ID", "360", "30", "", "", "", "-6.36836", "107.9558", "Asia/Jakarta"),
("8224624", "City of Balikpapan", "", "ID", "360", "14", "", "", "", "-1.24204", "116.89419", "Asia/Makassar"),
("8449493", "Pekan Bahapal", "", "ID", "360", "26", "", "", "", "3.11313", "99.17352", "Asia/Jakarta"),
("8581443", "South Tangerang", "", "ID", "360", "33", "", "", "", "-6.28862", "106.71789", "Asia/Jakarta"),
("2960964", "Loch Garman", "", "IE", "372", "L", "30", "", "", "52.33417", "-6.4575", "Europe/Dublin"),
("2960992", "Waterford", "Уотерфорд", "IE", "372", "M", "27", "", "", "52.25833", "-7.11194", "Europe/Dublin"),
("2961123", "Tralee", "Трали", "IE", "372", "M", "11", "", "", "52.27042", "-9.70264", "Europe/Dublin"),
("2961284", "Tallaght", "Талла", "IE", "372", "L", "07", "", "", "53.2859", "-6.37344", "Europe/Dublin"),
("2961297", "Swords", "Сордс", "IE", "372", "L", "35", "", "", "53.45972", "-6.21806", "Europe/Dublin"),
("2961423", "Sligo", "Слайго", "IE", "372", "C", "25", "", "", "54.26969", "-8.46943", "Europe/Dublin"),
("2962290", "Droichead Nua", "", "IE", "372", "L", "12", "", "", "53.18194", "-6.79667", "Europe/Dublin"),
("2962308", "Navan", "Ан-Уавь", "IE", "372", "L", "21", "", "", "53.65278", "-6.68139", "Europe/Dublin"),
("2962334", "Naas", "", "IE", "372", "L", "12", "", "", "53.21583", "-6.66694", "Europe/Dublin"),
("2962361", "An Muileann gCearr", "", "IE", "372", "L", "29", "", "", "53.53333", "-7.35", "Europe/Dublin"),
("2962725", "Malahide", "Малахайд", "IE", "372", "L", "07", "", "", "53.45083", "-6.15444", "Europe/Dublin"),
("2962785", "Lucan", "", "IE", "372", "L", "07", "", "", "53.35736", "-6.44859", "Europe/Dublin"),
("2962943", "Luimneach", "Лимерик", "IE", "372", "M", "16", "", "", "52.66472", "-8.62306", "Europe/Dublin"),
("2962961", "Letterkenny", "Леттеркенни", "IE", "372", "U", "06", "", "", "54.95", "-7.73333", "Europe/Dublin"),
("2962974", "Leixlip", "Лейкслип", "IE", "372", "L", "12", "", "", "53.36583", "-6.49556", "Europe/Dublin"),
("2963398", "Kilkenny", "Килкенни", "IE", "372", "L", "13", "", "", "52.65417", "-7.25222", "Europe/Dublin"),
("2964180", "Gaillimh", "Голуэй", "IE", "372", "C", "10", "", "", "53.27194", "-9.04889", "Europe/Dublin"),
("2964303", "Finglas", "", "IE", "372", "L", "33", "", "", "53.38917", "-6.29694", "Europe/Dublin"),
("2964405", "Ennis", "Эннис", "IE", "372", "M", "03", "", "", "52.84361", "-8.98639", "Europe/Dublin"),
("2964506", "Dun Laoghaire", "Дун-Лэаре", "IE", "372", "L", "34", "", "", "53.29395", "-6.13586", "Europe/Dublin"),
("2964540", "Dundalk", "Дандолк", "IE", "372", "L", "19", "", "", "54", "-6.41667", "Europe/Dublin"),
("2964574", "Dublin", "Дублин", "IE", "372", "L", "33", "", "", "53.33306", "-6.24889", "Europe/Dublin"),
("2964661", "Drogheda", "Дроэда", "IE", "372", "L", "19", "", "", "53.71889", "-6.34778", "Europe/Dublin"),
("2965140", "Cork", "Корк", "IE", "372", "M", "04", "", "", "51.89797", "-8.47061", "Europe/Dublin"),
("2965353", "Cluain Meala", "", "IE", "372", "M", "40", "", "", "52.355", "-7.70389", "Europe/Dublin"),
("2965529", "Celbridge", "Селбридж", "IE", "372", "L", "12", "", "", "53.33861", "-6.54361", "Europe/Dublin"),
("2965768", "Carlow", "", "IE", "372", "L", "01", "", "", "52.84083", "-6.92611", "Europe/Dublin"),
("2966110", "Blanchardstown", "", "IE", "372", "L", "35", "", "", "53.38806", "-6.37556", "Europe/Dublin"),
("2966794", "Balbriggan", "Балбригган", "IE", "372", "L", "07", "", "", "53.61278", "-6.18194", "Europe/Dublin"),
("2966839", "Athlone", "", "IE", "372", "L", "29", "", "", "53.43333", "-7.95", "Europe/Dublin"),
("3315278", "Sandyford", "", "IE", "372", "L", "07", "", "", "53.2747", "-6.2253", "Europe/Dublin"),
("6691033", "Donaghmede", "", "IE", "372", "L", "", "", "", "53.39845", "-6.16179", "Europe/Dublin"),
("281184", "Jerusalem", "Иерусалим", "IL", "376", "06", "", "", "", "31.76904", "35.21633", "Asia/Jerusalem"),
("293100", "Safed", "Цфат", "IL", "376", "03", "", "", "", "32.96465", "35.496", "Asia/Jerusalem"),
("293207", "Yehud", "Йехуд", "IL", "376", "02", "", "", "", "32.03317", "34.89091", "Asia/Jerusalem"),
("293222", "Yavne", "Явне", "IL", "376", "02", "", "", "", "31.88078", "34.73843", "Asia/Jerusalem"),
("293253", "Yafo", "Яффа", "IL", "376", "05", "", "", "", "32.05043", "34.75224", "Asia/Jerusalem"),
("293286", "Umm el Fahm", "", "IL", "376", "04", "", "", "", "32.51725", "35.15349", "Asia/Jerusalem"),
("293308", "Tirat Karmel", "Тират Кармель", "IL", "376", "04", "", "", "", "32.76021", "34.97183", "Asia/Jerusalem"),
("293322", "Tiberias", "Тверия", "IL", "376", "03", "", "", "", "32.7922", "35.53124", "Asia/Jerusalem"),
("293397", "Tel Aviv", "Тель-Авив", "IL", "376", "05", "", "", "", "32.08088", "34.78057", "Asia/Jerusalem"),
("293420", "maalot Tarshiha", "Маалот-Таршиха", "IL", "376", "03", "", "", "", "33.01667", "35.26667", "Asia/Jerusalem"),
("293426", "Tamra", "Тамра", "IL", "376", "03", "", "", "", "32.85301", "35.1987", "Asia/Jerusalem"),
("293619", "Sederot", "Сдерот", "IL", "376", "01", "", "", "", "31.525", "34.59693", "Asia/Jerusalem"),
("293655", "Sakhnin", "Сахнин", "IL", "376", "03", "", "", "", "32.86422", "35.29707", "Asia/Jerusalem"),
("293690", "Rosh Ha'Ayin", "", "IL", "376", "02", "", "", "", "32.09556", "34.95664", "Asia/Jerusalem"),
("293703", "Rishon LeZiyyon", "Ришон-ле-Цион", "IL", "376", "02", "", "", "", "31.97102", "34.78939", "Asia/Jerusalem"),
("293768", "Ramla", "Рамла", "IL", "376", "02", "", "", "", "31.92923", "34.86563", "Asia/Jerusalem"),
("293783", "Ramat HaSharon", "", "IL", "376", "05", "", "", "", "32.14613", "34.8394", "Asia/Jerusalem"),
("293788", "Ramat Gan", "Рамат-Ган", "IL", "376", "05", "", "", "", "32.08227", "34.81065", "Asia/Jerusalem"),
("293807", "Ra'anana", "", "IL", "376", "02", "", "", "", "32.1836", "34.87386", "Asia/Jerusalem"),
("293822", "Qiryat Yam", "Кирьят-Ям", "IL", "376", "04", "", "", "", "32.84966", "35.06973", "Asia/Jerusalem"),
("293825", "Qiryat Shemona", "Кирьят-Шмона", "IL", "376", "03", "", "", "", "33.20733", "35.57212", "Asia/Jerusalem"),
("293831", "Qiryat Motzkin", "Кирьят-Моцкин", "IL", "376", "04", "", "", "", "32.83706", "35.0776", "Asia/Jerusalem"),
("293842", "Qiryat Gat", "Кирьят-Гат", "IL", "376", "01", "", "", "", "31.60998", "34.76422", "Asia/Jerusalem"),
("293844", "Qiryat Bialik", "Кирьят-Бялик", "IL", "376", "04", "", "", "", "32.8275", "35.08583", "Asia/Jerusalem"),
("293845", "Qiryat Ata", "Кирьят-Ата", "IL", "376", "04", "", "", "", "32.81034", "35.11255", "Asia/Jerusalem"),
("293896", "Qalansuwa", "", "IL", "376", "02", "", "", "", "32.28493", "34.98106", "Asia/Jerusalem"),
("293918", "Petah Tiqwa", "", "IL", "376", "02", "", "", "", "32.08708", "34.88747", "Asia/Jerusalem"),
("293962", "Or Yehuda", "", "IL", "376", "05", "", "", "", "32.02923", "34.85788", "Asia/Jerusalem"),
("293992", "Ofaqim", "", "IL", "376", "01", "", "", "", "31.3141", "34.62025", "Asia/Jerusalem"),
("294068", "Netivot", "Нетивот", "IL", "376", "01", "", "", "", "31.42215", "34.58858", "Asia/Jerusalem"),
("294071", "Netanya", "Нетания", "IL", "376", "02", "", "", "", "32.33292", "34.85992", "Asia/Jerusalem"),
("294074", "Ness Ziona", "", "IL", "376", "02", "", "", "", "31.92933", "34.79868", "Asia/Jerusalem"),
("294078", "Nesher", "Нешер", "IL", "376", "04", "", "", "", "32.76651", "35.05003", "Asia/Jerusalem"),
("294098", "Nazareth", "Назарет", "IL", "376", "03", "", "", "", "32.69925", "35.30483", "Asia/Jerusalem"),
("294117", "Nahariya", "Нагария", "IL", "376", "03", "", "", "", "33.01135", "35.09467", "Asia/Jerusalem"),
("294210", "Migdal Ha`Emeq", "Мигдаль ХаЭмек", "IL", "376", "03", "", "", "", "32.67597", "35.23986", "Asia/Jerusalem"),
("294244", "Mevo Betar", "", "IL", "376", "06", "", "", "", "31.72177", "35.10669", "Asia/Jerusalem"),
("294387", "Maghar", "", "IL", "376", "03", "", "", "", "32.88984", "35.40703", "Asia/Jerusalem"),
("294421", "Lod", "Лод", "IL", "376", "02", "", "", "", "31.9467", "34.8903", "Asia/Jerusalem"),
("294514", "Kfar Saba", "Кефар-Сава", "IL", "376", "02", "", "", "", "32.175", "34.90694", "Asia/Jerusalem"),
("294577", "Karmi'el", "Кармиэль", "IL", "376", "03", "", "", "", "32.91669", "35.29918", "Asia/Jerusalem"),
("294604", "Kafr Qasim", "", "IL", "376", "02", "", "", "", "32.11406", "34.97624", "Asia/Jerusalem"),
("294608", "Kafr Manda", "", "IL", "376", "03", "", "", "", "32.81034", "35.26009", "Asia/Jerusalem"),
("294610", "Kafr Kanna", "", "IL", "376", "03", "", "", "", "32.7466", "35.34242", "Asia/Jerusalem"),
("294622", "Judieda Makr", "", "IL", "376", "03", "", "", "", "32.9282", "35.15705", "Asia/Jerusalem"),
("294751", "Holon", "Холон", "IL", "376", "05", "", "", "", "32.01034", "34.77918", "Asia/Jerusalem"),
("294760", "Hod HaSharon", "Ход-ха-Шарон", "IL", "376", "02", "", "", "", "32.15934", "34.8932", "Asia/Jerusalem"),
("294778", "Herzliyya", "Герцлия", "IL", "376", "05", "", "", "", "32.16627", "34.82536", "Asia/Jerusalem"),
("294801", "Haifa", "Хайфа", "IL", "376", "04", "", "", "", "32.81841", "34.9885", "Asia/Jerusalem"),
("294946", "Hadera", "Хадера", "IL", "376", "04", "", "", "", "32.43645", "34.91956", "Asia/Jerusalem"),
("294981", "Giv`at Shemu'el", "", "IL", "376", "05", "", "", "", "32.07817", "34.84858", "Asia/Jerusalem"),
("294999", "Giv`atayim", "Гиватаим", "IL", "376", "05", "", "", "", "32.07225", "34.81253", "Asia/Jerusalem"),
("295127", "Tirah", "", "IL", "376", "02", "", "", "", "32.2341", "34.95023", "Asia/Jerusalem"),
("295130", "Et Taiyiba", "", "IL", "376", "02", "", "", "", "32.26616", "35.00893", "Asia/Jerusalem"),
("295174", "Er Reina", "", "IL", "376", "03", "", "", "", "32.72339", "35.31622", "Asia/Jerusalem"),
("295277", "Eilat", "Эйлат", "IL", "376", "01", "", "", "", "29.55805", "34.94821", "Asia/Jerusalem"),
("295328", "Dimona", "Димона", "IL", "376", "01", "", "", "", "31.07127", "35.0337", "Asia/Jerusalem"),
("295365", "Daliyat el Karmil", "Кармель", "IL", "376", "04", "", "", "", "32.69383", "35.04686", "Asia/Jerusalem"),
("295432", "Bet Shemesh", "Бейт-Шемеш", "IL", "376", "06", "", "", "", "31.73072", "34.99293", "Asia/Jerusalem"),
("295435", "Bet She'an", "Бейт-Шеан", "IL", "376", "03", "", "", "", "32.49728", "35.49632", "Asia/Jerusalem"),
("295514", "Bene Beraq", "", "IL", "376", "05", "", "", "", "32.08074", "34.8338", "Asia/Jerusalem"),
("295530", "Beersheba", "Беэр-Шева", "IL", "376", "01", "", "", "", "31.25181", "34.7913", "Asia/Jerusalem"),
("295548", "Bat Yam", "Бат-Ям", "IL", "376", "05", "", "", "", "32.02379", "34.75185", "Asia/Jerusalem"),
("295620", "Ashqelon", "Ашкелон", "IL", "376", "01", "", "", "", "31.66926", "34.57149", "Asia/Jerusalem"),
("295629", "Ashdod", "Ашдод", "IL", "376", "01", "", "", "", "31.79213", "34.64966", "Asia/Jerusalem"),
("295657", "'Arad", "Арад", "IL", "376", "01", "", "", "", "31.25882", "35.21282", "Asia/Jerusalem"),
("295721", "`Akko", "Акко", "IL", "376", "03", "", "", "", "32.92814", "35.07647", "Asia/Jerusalem"),
("295739", "`Afula `Illit", "", "IL", "376", "03", "", "", "", "32.63323", "35.32522", "Asia/Jerusalem"),
("6693679", "Modiin", "", "IL", "376", "02", "", "", "", "31.89825", "35.01051", "Asia/Jerusalem"),
("6945291", "Old City", "", "IL", "376", "06", "", "", "", "31.77667", "35.23417", "Asia/Jerusalem"),
("7498240", "West Jerusalem", "", "IL", "376", "06", "", "", "", "31.78199", "35.21961", "Asia/Jerusalem"),
("8199378", "Modiin Ilit", "", "IL", "376", "06", "", "", "", "31.93221", "35.04416", "Asia/Jerusalem"),
("8199394", "Ariel", "", "IL", "376", "06", "", "", "", "32.1065", "35.18449", "Asia/Jerusalem"),
("1167718", "Punch", "", "IN", "356", "12", "", "", "", "33.76969", "74.09212", "Asia/Kolkata"),
("1252646", "Keelakarai", "", "IN", "356", "25", "", "", "", "9.23183", "78.78545", "Asia/Kolkata"),
("1252653", "Zunheboto", "", "IN", "356", "20", "", "", "", "25.96667", "94.51667", "Asia/Kolkata"),
("1252692", "Zamania", "", "IN", "356", "36", "", "", "", "25.41961", "83.55786", "Asia/Kolkata"),
("1252698", "Zaidpur", "", "IN", "356", "36", "", "", "", "26.82964", "81.32978", "Asia/Kolkata"),
("1252699", "Zahirabad", "", "IN", "356", "02", "", "", "", "17.68138", "77.60743", "Asia/Kolkata"),
("1252738", "Yeola", "", "IN", "356", "16", "", "", "", "20.04262", "74.48991", "Asia/Kolkata"),
("1252744", "Yellapur", "", "IN", "356", "19", "", "", "", "14.96584", "74.71034", "Asia/Kolkata"),
("1252745", "Yellandu", "", "IN", "356", "02", "", "", "", "17.59064", "80.32146", "Asia/Kolkata"),
("1252758", "Yelahanka", "", "IN", "356", "19", "", "", "", "13.10129", "77.59626", "Asia/Kolkata"),
("1252770", "Yavatmal", "", "IN", "356", "16", "", "", "", "20.39684", "78.13064", "Asia/Kolkata"),
("1252773", "Yaval", "", "IN", "356", "16", "", "", "", "21.16753", "75.69761", "Asia/Kolkata"),
("1252795", "Yanam", "Янам", "IN", "356", "02", "", "", "", "16.73308", "82.21364", "Asia/Kolkata"),
("1252797", "Yamunanagar", "", "IN", "356", "10", "", "", "", "30.12913", "77.28049", "Asia/Kolkata"),
("1252822", "Yadgir", "", "IN", "356", "19", "", "", "", "16.77023", "77.13754", "Asia/Kolkata"),
("1252840", "Wokha", "", "IN", "356", "20", "", "", "", "26.09716", "94.25817", "Asia/Kolkata"),
("1252885", "Wer", "", "IN", "356", "24", "", "", "", "27.0186", "77.17636", "Asia/Kolkata"),
("1252887", "Wellington", "Веллингтон", "IN", "356", "25", "", "", "", "11.36389", "76.78525", "Asia/Kolkata"),
("1252892", "Wazirganj", "", "IN", "356", "36", "", "", "", "28.21109", "79.05651", "Asia/Kolkata"),
("1252908", "Washim", "", "IN", "356", "16", "", "", "", "20.11152", "77.13221", "Asia/Kolkata"),
("1252919", "Warud", "", "IN", "356", "35", "", "", "", "21.47076", "78.26858", "Asia/Kolkata"),
("1252925", "Warora", "", "IN", "356", "16", "", "", "", "20.23014", "79.00161", "Asia/Kolkata"),
("1252930", "Waris Aliganj", "", "IN", "356", "34", "", "", "", "25.0172", "85.64048", "Asia/Kolkata"),
("1252942", "Wardha", "Вардха", "IN", "356", "16", "", "", "", "20.73807", "78.5967", "Asia/Kolkata"),
("1252946", "Waraseoni", "", "IN", "356", "35", "", "", "", "21.76454", "80.04631", "Asia/Kolkata"),
("1252948", "Warangal", "Варангал", "IN", "356", "02", "", "", "", "18", "79.58333", "Asia/Kolkata"),
("1252956", "Wanparti", "", "IN", "356", "02", "", "", "", "16.36738", "78.06889", "Asia/Kolkata"),
("1252958", "Wankaner", "", "IN", "356", "09", "", "", "", "22.61198", "70.94379", "Asia/Kolkata"),
("1252960", "Wani", "Ваня", "IN", "356", "16", "", "", "", "20.05556", "78.95345", "Asia/Kolkata"),
("1252997", "Walajapet", "", "IN", "356", "25", "", "", "", "12.9251", "79.36626", "Asia/Kolkata"),
("1253013", "Wai", "Вай", "IN", "356", "16", "", "", "", "17.95276", "73.89058", "Asia/Kolkata"),
("1253041", "Wadi", "Вади", "IN", "356", "19", "", "", "", "17.05206", "76.99024", "Asia/Kolkata"),
("1253074", "Vyara", "", "IN", "356", "09", "", "", "", "21.11079", "73.39365", "Asia/Kolkata"),
("1253077", "Vuyyuru", "", "IN", "356", "02", "", "", "", "16.36188", "80.84573", "Asia/Kolkata"),
("1253079", "Vrindavan", "Вриндаван", "IN", "356", "36", "", "", "", "27.57823", "77.69806", "Asia/Kolkata"),
("1253080", "Vriddhachalam", "", "IN", "356", "25", "", "", "", "11.51528", "79.32186", "Asia/Kolkata"),
("1253084", "Vizianagaram", "Визианагарам", "IN", "356", "02", "7626859", "", "", "18.11692", "83.41148", "Asia/Kolkata"),
("1253091", "Vite", "Вита", "IN", "356", "16", "", "", "", "17.27343", "74.53792", "Asia/Kolkata"),
("1253095", "Visnagar", "", "IN", "356", "09", "", "", "", "23.69855", "72.5521", "Asia/Kolkata"),
("1253102", "Visakhapatnam", "Вишакхапатнам", "IN", "356", "02", "1253103", "", "", "17.68009", "83.20161", "Asia/Kolkata"),
("1253105", "Visavadar", "", "IN", "356", "09", "", "", "", "21.33954", "70.74966", "Asia/Kolkata"),
("1253113", "Virudunagar", "", "IN", "356", "25", "", "", "", "9.58509", "77.95787", "Asia/Kolkata"),
("1253127", "Viravanallur", "", "IN", "356", "25", "", "", "", "8.6961", "77.51895", "Asia/Kolkata"),
("1253132", "Virarajendrapet", "", "IN", "356", "19", "", "", "", "12.19583", "75.80355", "Asia/Kolkata"),
("1253133", "Virar", "", "IN", "356", "16", "", "", "", "19.4559", "72.81136", "Asia/Kolkata"),
("1253150", "Vinukonda", "", "IN", "356", "02", "", "", "", "16.0518", "79.74017", "Asia/Kolkata"),
("1253166", "Villupuram", "", "IN", "356", "25", "", "", "", "11.93975", "79.49244", "Asia/Kolkata"),
("1253182", "Vikarabad", "", "IN", "356", "02", "", "", "", "17.3381", "77.90441", "Asia/Kolkata"),
("1253184", "Vijayawada", "Виджаявада", "IN", "356", "02", "", "", "", "16.51928", "80.63049", "Asia/Kolkata"),
("1253193", "Vijapur", "", "IN", "356", "09", "", "", "", "23.5623", "72.74848", "Asia/Kolkata"),
("1253200", "Vidisha", "", "IN", "356", "35", "", "", "", "23.52435", "77.80972", "Asia/Kolkata"),
("1253216", "Vettur", "", "IN", "356", "13", "", "", "", "8.7", "76.73333", "Asia/Kolkata"),
("1253219", "Vettaikkaranpudur", "", "IN", "356", "25", "", "", "", "10.56207", "76.91305", "Asia/Kolkata"),
("1253220", "Vetapalem", "", "IN", "356", "02", "", "", "", "15.78204", "80.30665", "Asia/Kolkata"),
("1253237", "Veraval", "", "IN", "356", "09", "", "", "", "20.9077", "70.36786", "Asia/Kolkata"),
("1253242", "Vepagunta", "", "IN", "356", "02", "", "", "", "17.77844", "83.21577", "Asia/Kolkata"),
("1253251", "Venkatagiri", "", "IN", "356", "02", "", "", "", "13.96065", "79.58024", "Asia/Kolkata"),
("1253275", "Vemalwada", "", "IN", "356", "02", "", "", "", "18.46523", "78.86894", "Asia/Kolkata"),
("1253278", "Velur", "", "IN", "356", "25", "", "", "", "11.10825", "78.00113", "Asia/Kolkata"),
("1253286", "Vellore", "Веллор", "IN", "356", "25", "", "", "", "12.9184", "79.13255", "Asia/Kolkata"),
("1253315", "Vejalpur", "", "IN", "356", "09", "", "", "", "22.69021", "73.56299", "Asia/Kolkata"),
("1253330", "Vedaraniyam", "", "IN", "356", "25", "", "", "", "10.37208", "79.85095", "Asia/Kolkata"),
("1253340", "Vayalar", "", "IN", "356", "13", "", "", "", "9.7", "76.33333", "Asia/Kolkata"),
("1253352", "Vattalkundu", "", "IN", "356", "25", "", "", "", "10.16069", "77.75883", "Asia/Kolkata"),
("1253357", "Vasudevanallur", "", "IN", "356", "25", "", "", "", "9.23921", "77.41132", "Asia/Kolkata"),
("1253363", "Vasind", "", "IN", "356", "16", "", "", "", "19.40844", "73.26285", "Asia/Kolkata"),
("1253367", "Vasco Da Gama", "Васко-да-Гама", "IN", "356", "33", "", "", "", "15.39585", "73.81568", "Asia/Kolkata"),
("1253374", "Vasa", "", "IN", "356", "09", "", "", "", "22.66079", "72.75519", "Asia/Kolkata"),
("1253392", "Varkala", "Варкала", "IN", "356", "13", "", "", "", "8.7333", "76.7167", "Asia/Kolkata"),
("1253403", "Varangaon", "", "IN", "356", "16", "", "", "", "21.01649", "75.90991", "Asia/Kolkata"),
("1253405", "Varanasi", "Варанаси", "IN", "356", "36", "", "", "", "25.31668", "83.01042", "Asia/Kolkata"),
("1253437", "Vaniyambadi", "", "IN", "356", "25", "", "", "", "12.68162", "78.62014", "Asia/Kolkata"),
("1253452", "Vandavasi", "", "IN", "356", "25", "", "", "", "12.50429", "79.60556", "Asia/Kolkata"),
("1253468", "Valsad", "", "IN", "356", "09", "", "", "", "20.61728", "72.92843", "Asia/Kolkata"),
("1253472", "Valparai", "", "IN", "356", "25", "", "", "", "10.32691", "76.95116", "Asia/Kolkata"),
("1253482", "Vallabh Vidyanagar", "", "IN", "356", "09", "", "", "", "22.53333", "72.9", "Asia/Kolkata"),
("1253512", "Valabhipur", "", "IN", "356", "09", "", "", "", "21.88868", "71.87935", "Asia/Kolkata"),
("1253544", "Vaikam", "", "IN", "356", "13", "", "", "", "9.74713", "76.39522", "Asia/Kolkata"),
("1253545", "Vaijapur", "", "IN", "356", "16", "", "", "", "19.92672", "74.7275", "Asia/Kolkata"),
("1253573", "Vadodara", "Вадодара", "IN", "356", "09", "", "", "", "22.2994", "73.20812", "Asia/Kolkata"),
("1253577", "Vadnagar", "", "IN", "356", "09", "", "", "", "23.78593", "72.63893", "Asia/Kolkata"),
("1253578", "Vadlapudi", "", "IN", "356", "02", "", "", "", "14.3097", "79.80296", "Asia/Kolkata"),
("1253579", "Vadippatti", "", "IN", "356", "25", "", "", "", "10.08481", "77.96113", "Asia/Kolkata"),
("1253595", "Vadamadurai", "", "IN", "356", "25", "", "", "", "10.44026", "78.09999", "Asia/Kolkata"),
("1253605", "Vadakku Valliyur", "", "IN", "356", "25", "", "", "", "8.38095", "77.6132", "Asia/Kolkata"),
("1253610", "Vada", "", "IN", "356", "16", "", "", "", "19.65347", "73.14811", "Asia/Kolkata"),
("1253623", "Uttiramerur", "", "IN", "356", "25", "", "", "", "12.61433", "79.75748", "Asia/Kolkata"),
("1253628", "Uttarkashi", "", "IN", "356", "39", "", "", "", "30.72986", "78.44342", "Asia/Kolkata"),
("1253635", "Uttamapalaiyam", "", "IN", "356", "25", "", "", "", "9.80701", "77.32718", "Asia/Kolkata"),
("1253638", "Utraula", "", "IN", "356", "36", "", "", "", "27.31929", "82.41838", "Asia/Kolkata"),
("1253671", "Usilampatti", "", "IN", "356", "25", "", "", "", "9.96936", "77.78621", "Asia/Kolkata"),
("1253673", "Usehat", "", "IN", "356", "36", "", "", "", "27.79817", "79.23682", "Asia/Kolkata"),
("1253698", "Uravakonda", "", "IN", "356", "02", "", "", "", "14.9456", "77.25928", "Asia/Kolkata"),
("1253702", "Uran", "Уран", "IN", "356", "16", "", "", "", "18.87813", "72.93924", "Asia/Kolkata"),
("1253736", "Upleta", "", "IN", "356", "09", "", "", "", "21.74015", "70.28256", "Asia/Kolkata"),
("1253744", "Uppal Kalan", "", "IN", "356", "02", "", "", "", "17.40577", "78.55911", "Asia/Kolkata"),
("1253747", "Unnao", "", "IN", "356", "36", "", "", "", "26.54706", "80.48781", "Asia/Kolkata"),
("1253750", "Unjha", "", "IN", "356", "09", "", "", "", "23.80366", "72.39102", "Asia/Kolkata"),
("1253754", "Unhel", "", "IN", "356", "35", "", "", "", "23.33794", "75.55931", "Asia/Kolkata"),
("1253782", "Una", "", "IN", "356", "11", "", "", "", "31.46493", "76.26914", "Asia/Kolkata"),
("1253783", "Una", "", "IN", "356", "09", "", "", "", "20.82318", "71.03795", "Asia/Kolkata"),
("1253785", "Un", "", "IN", "356", "36", "", "", "", "29.58594", "77.25398", "Asia/Kolkata"),
("1253786", "Un", "", "IN", "356", "09", "", "", "", "23.88745", "71.76975", "Asia/Kolkata"),
("1253805", "Umreth", "", "IN", "356", "09", "", "", "", "22.69881", "73.11561", "Asia/Kolkata"),
("1253807", "Umred", "", "IN", "356", "16", "", "", "", "20.85409", "79.3242", "Asia/Kolkata"),
("1253860", "Umarkot", "", "IN", "356", "37", "", "", "", "19.66529", "82.20629", "Asia/Kolkata"),
("1253861", "Umarkhed", "", "IN", "356", "16", "", "", "", "19.60144", "77.68878", "Asia/Kolkata"),
("1253863", "Umaria", "", "IN", "356", "35", "", "", "", "23.52684", "80.83745", "Asia/Kolkata"),
("1253870", "Umarga", "", "IN", "356", "16", "", "", "", "17.83841", "76.62331", "Asia/Kolkata"),
("1253888", "Ullal", "", "IN", "356", "19", "", "", "", "12.8108", "74.8629", "Asia/Kolkata"),
("1253894", "Ulhasnagar", "", "IN", "356", "16", "", "", "", "19.21667", "73.15", "Asia/Kolkata"),
("1253914", "Ujjain", "Удджайн", "IN", "356", "35", "", "", "", "23.18239", "75.77643", "Asia/Kolkata"),
("1253918", "Ujhani", "", "IN", "356", "36", "", "", "", "28.00203", "79.00926", "Asia/Kolkata"),
("1253944", "Udumalaippettai", "", "IN", "356", "25", "", "", "", "10.58806", "77.24779", "Asia/Kolkata"),
("1253952", "Udipi", "", "IN", "356", "19", "", "", "", "13.33467", "74.74617", "Asia/Kolkata"),
("1253956", "Udhampur", "", "IN", "356", "12", "", "", "", "32.92431", "75.13573", "Asia/Kolkata"),
("1253958", "Udgir", "", "IN", "356", "16", "", "", "", "18.39258", "77.11756", "Asia/Kolkata"),
("1253972", "Udankudi", "", "IN", "356", "25", "", "", "", "8.43048", "78.02882", "Asia/Kolkata"),
("1253977", "Udalguri", "", "IN", "356", "03", "", "", "", "26.75367", "92.10215", "Asia/Kolkata"),
("1253984", "Udaipura", "", "IN", "356", "35", "", "", "", "23.07564", "78.51115", "Asia/Kolkata"),
("1253985", "Udaipur", "", "IN", "356", "24", "", "", "", "27.72297", "75.47178", "Asia/Kolkata"),
("1253986", "Udaipur", "Удайпур", "IN", "356", "24", "", "", "", "24.57117", "73.69183", "Asia/Kolkata"),
("1253987", "Udaipur", "Удайпур", "IN", "356", "26", "", "", "", "23.53333", "91.48333", "Asia/Kolkata"),
("1253993", "Ooty", "Утакаманд", "IN", "356", "25", "", "", "", "11.4134", "76.69521", "Asia/Kolkata"),
("1254000", "Uchana", "", "IN", "356", "10", "", "", "", "29.46856", "76.176", "Asia/Kolkata"),
("1254043", "Turaiyur", "", "IN", "356", "25", "", "", "", "11.14985", "78.59888", "Asia/Kolkata"),
("1254046", "Tura", "", "IN", "356", "18", "", "", "", "25.51933", "90.22284", "Asia/Kolkata"),
("1254054", "Tuni", "", "IN", "356", "02", "", "", "", "17.35967", "82.54616", "Asia/Kolkata"),
("1254069", "Tundla", "", "IN", "356", "36", "", "", "", "27.21384", "78.23604", "Asia/Kolkata"),
("1254080", "Tumsar", "", "IN", "356", "16", "", "", "", "21.38333", "79.73333", "Asia/Kolkata"),
("1254089", "Tumkur", "", "IN", "356", "19", "", "", "", "13.34149", "77.101", "Asia/Kolkata"),
("1254102", "Tulsipur", "", "IN", "356", "36", "", "", "", "27.5337", "82.41653", "Asia/Kolkata"),
("1254111", "Tuljapur", "", "IN", "356", "16", "", "", "", "18.00804", "76.07011", "Asia/Kolkata"),
("1254131", "Tufanganj", "", "IN", "356", "28", "", "", "", "26.31688", "89.66549", "Asia/Kolkata"),
("1254133", "Tuensang", "", "IN", "356", "20", "", "", "", "26.26704", "94.82415", "Asia/Kolkata"),
("1254163", "Thiruvananthapuram", "Тируванантапурам", "IN", "356", "13", "", "", "", "8.4855", "76.94924", "Asia/Kolkata"),
("1254187", "Trichur", "Тричура", "IN", "356", "13", "1254188", "", "", "10.51667", "76.21667", "Asia/Kolkata"),
("1254241", "Tonk", "", "IN", "356", "24", "", "", "", "26.16638", "75.78824", "Asia/Kolkata"),
("1254249", "Tondi", "", "IN", "356", "25", "", "", "", "9.74172", "79.01774", "Asia/Kolkata"),
("1254274", "Tohana", "", "IN", "356", "10", "", "", "", "29.71179", "75.90284", "Asia/Kolkata"),
("1254282", "Todaraisingh", "", "IN", "356", "24", "", "", "", "26.02401", "75.48182", "Asia/Kolkata"),
("1254283", "Todabhim", "", "IN", "356", "24", "", "", "", "26.91667", "76.81667", "Asia/Kolkata"),
("1254304", "Titlagarh", "", "IN", "356", "21", "", "", "", "20.28961", "83.15233", "Asia/Kolkata"),
("1254309", "Titagarh", "", "IN", "356", "28", "", "", "", "22.74252", "88.37326", "Asia/Kolkata"),
("1254317", "Tisaiyanvilai", "", "IN", "356", "25", "", "", "", "8.33248", "77.86586", "Asia/Kolkata"),
("1254320", "Tiruvottiyur", "", "IN", "356", "25", "", "", "", "13.15823", "80.30181", "Asia/Kolkata"),
("1254322", "Cheyyar", "", "IN", "356", "25", "", "", "", "12.66052", "79.54308", "Asia/Kolkata"),
("1254327", "Tiruvannamalai", "Тируваннамалай", "IN", "356", "25", "", "", "", "12.22662", "79.07461", "Asia/Kolkata"),
("1254331", "Tiruvallur", "Тируваллур", "IN", "356", "25", "", "", "", "13.14376", "79.90889", "Asia/Kolkata"),
("1254335", "Tiruvalla", "", "IN", "356", "13", "", "", "", "9.3816", "76.57489", "Asia/Kolkata"),
("1254342", "Thiruthani", "", "IN", "356", "25", "", "", "", "13.17594", "79.61637", "Asia/Kolkata"),
("1254343", "Tiruttangal", "", "IN", "356", "25", "", "", "", "9.48333", "77.83333", "Asia/Kolkata"),
("1254346", "Tirur", "", "IN", "356", "13", "", "", "", "10.91607", "75.91862", "Asia/Kolkata"),
("1254347", "Tiruppuvanam", "", "IN", "356", "25", "", "", "", "9.82556", "78.25792", "Asia/Kolkata"),
("1254348", "Tiruppur", "Тируппур", "IN", "356", "25", "", "", "", "11.11541", "77.35456", "Asia/Kolkata"),
("1254356", "Tirupparangunram", "", "IN", "356", "25", "", "", "", "9.88085", "78.07252", "Asia/Kolkata"),
("1254360", "Tirupati", "Тирупати", "IN", "356", "02", "1274034", "", "", "13.6355", "79.41989", "Asia/Kolkata"),
("1254361", "Tirunelveli", "Тирунелвели", "IN", "356", "25", "", "", "", "8.72518", "77.68452", "Asia/Kolkata"),
("1254373", "Tirumala", "", "IN", "356", "02", "", "", "", "13.68333", "79.35", "Asia/Kolkata"),
("1254377", "Tirukkoyilur", "", "IN", "356", "25", "", "", "", "11.9662", "79.20259", "Asia/Kolkata"),
("1254385", "Tiruchengode", "", "IN", "356", "25", "", "", "", "11.38016", "77.89444", "Asia/Kolkata"),
("1254388", "Tiruchirappalli", "Тируччираппалли", "IN", "356", "25", "", "", "", "10.8155", "78.69651", "Asia/Kolkata"),
("1254390", "Tiruchchendur", "", "IN", "356", "25", "", "", "", "8.49725", "78.11906", "Asia/Kolkata"),
("1254396", "Tirthahalli", "", "IN", "356", "19", "", "", "", "13.68835", "75.24548", "Asia/Kolkata"),
("1254420", "Tiptur", "", "IN", "356", "19", "", "", "", "13.2563", "76.47768", "Asia/Kolkata"),
("1254432", "Tinsukia", "", "IN", "356", "03", "", "", "", "27.48905", "95.35992", "Asia/Kolkata"),
("1254436", "Tinnanur", "", "IN", "356", "25", "", "", "", "13.11448", "80.02713", "Asia/Kolkata"),
("1254444", "Tindivanam", "", "IN", "356", "25", "", "", "", "12.234", "79.65551", "Asia/Kolkata"),
("1254481", "Tilhar", "", "IN", "356", "36", "", "", "", "27.9614", "79.73962", "Asia/Kolkata"),
("1254534", "Tikamgarh", "", "IN", "356", "36", "", "", "", "24.74413", "78.83141", "Asia/Kolkata"),
("1254538", "Tijara", "", "IN", "356", "24", "", "", "", "27.93413", "76.85573", "Asia/Kolkata"),
("1254570", "Thoubal", "", "IN", "356", "17", "", "", "", "24.6388", "93.99638", "Asia/Kolkata"),
("1254589", "Thiruvarur", "", "IN", "356", "25", "", "", "", "10.77269", "79.6368", "Asia/Kolkata"),
("1254624", "Thasra", "", "IN", "356", "09", "", "", "", "22.79831", "73.21174", "Asia/Kolkata"),
("1254638", "Tharad", "", "IN", "356", "09", "", "", "", "24.39597", "71.62577", "Asia/Kolkata"),
("1254649", "Thanjavur", "Тханджавур", "IN", "356", "25", "", "", "", "10.78523", "79.13909", "Asia/Kolkata"),
("1254657", "Thanesar", "", "IN", "356", "10", "", "", "", "29.97415", "76.83201", "Asia/Kolkata"),
("1254661", "Thane", "Таня", "IN", "356", "16", "", "", "", "19.19704", "72.96356", "Asia/Kolkata"),
("1254673", "Thana Bhawan", "", "IN", "356", "36", "", "", "", "29.58653", "77.41712", "Asia/Kolkata"),
("1254675", "Than", "", "IN", "356", "09", "", "", "", "22.57422", "71.19942", "Asia/Kolkata"),
("1254694", "Thakurganj", "", "IN", "356", "34", "", "", "", "26.42742", "88.13112", "Asia/Kolkata"),
("1254695", "Thakurdwara", "", "IN", "356", "36", "", "", "", "29.19203", "78.86145", "Asia/Kolkata"),
("1254710", "Tezpur", "Тезпур", "IN", "356", "03", "", "", "", "26.63333", "92.8", "Asia/Kolkata"),
("1254727", "Terdal", "", "IN", "356", "19", "", "", "", "16.49379", "75.04667", "Asia/Kolkata"),
("1254732", "Teonthar", "", "IN", "356", "35", "", "", "", "24.98209", "81.64224", "Asia/Kolkata"),
("1254744", "Thenkasi", "", "IN", "356", "25", "", "", "", "8.96003", "77.31525", "Asia/Kolkata"),
("1254745", "Teni", "Тхени", "IN", "356", "25", "", "", "", "10.01531", "77.482", "Asia/Kolkata"),
("1254780", "Thalassery", "", "IN", "356", "13", "", "", "", "11.74776", "75.49338", "Asia/Kolkata"),
("1254787", "Telhara", "", "IN", "356", "16", "", "", "", "21.02694", "76.83889", "Asia/Kolkata"),
("1254794", "Tekkali", "", "IN", "356", "02", "", "", "", "18.6057", "84.23546", "Asia/Kolkata"),
("1254795", "Tekkalakote", "", "IN", "356", "19", "", "", "", "15.53466", "76.87562", "Asia/Kolkata"),
("1254797", "Tekari", "", "IN", "356", "34", "", "", "", "24.94216", "84.843", "Asia/Kolkata"),
("1254808", "Tehri", "Техри", "IN", "356", "39", "", "", "", "30.39086", "78.4803", "Asia/Kolkata"),
("1254813", "Teghra", "", "IN", "356", "34", "", "", "", "25.49109", "85.94166", "Asia/Kolkata"),
("1254858", "Tasgaon", "", "IN", "356", "16", "", "", "", "17.037", "74.60171", "Asia/Kolkata"),
("1254868", "Tarn Taran", "", "IN", "356", "23", "", "", "", "31.45112", "74.92538", "Asia/Kolkata"),
("1254880", "Tarikere", "", "IN", "356", "19", "", "", "", "13.70954", "75.81382", "Asia/Kolkata"),
("1254904", "Tharangambadi", "", "IN", "356", "25", "", "", "", "11.02764", "79.85425", "Asia/Kolkata"),
("1254908", "Taranagar", "", "IN", "356", "24", "", "", "", "28.6686", "75.03207", "Asia/Kolkata"),
("1254909", "Tarana", "Тарана", "IN", "356", "35", "", "", "", "23.33508", "76.04156", "Asia/Kolkata"),
("1254910", "Taramangalam", "", "IN", "356", "25", "", "", "", "11.7", "77.98333", "Asia/Kolkata"),
("1254912", "Tarakeswar", "", "IN", "356", "28", "", "", "", "22.88605", "88.01363", "Asia/Kolkata"),
("1254948", "Taoru", "", "IN", "356", "10", "", "", "", "28.2122", "76.94954", "Asia/Kolkata"),
("1254953", "Tanuku", "", "IN", "356", "02", "", "", "", "16.75319", "81.68456", "Asia/Kolkata"),
("1255004", "Tandur", "", "IN", "356", "02", "", "", "", "17.24849", "77.57698", "Asia/Kolkata"),
("1255023", "Tanda", "", "IN", "356", "36", "", "", "", "28.97474", "78.94243", "Asia/Kolkata"),
("1255024", "Tanda", "", "IN", "356", "36", "", "", "", "26.55063", "82.65802", "Asia/Kolkata"),
("1255027", "Tanakpur", "", "IN", "356", "39", "", "", "", "29.06925", "80.1126", "Asia/Kolkata"),
("1255046", "Tamluk", "", "IN", "356", "28", "", "", "", "22.30083", "87.92592", "Asia/Kolkata"),
("1255076", "Talwara", "", "IN", "356", "23", "", "", "", "31.9498", "75.86645", "Asia/Kolkata"),
("1255082", "Talwandi Bhai", "", "IN", "356", "23", "", "", "", "30.85612", "74.92944", "Asia/Kolkata"),
("1255104", "Taloda", "", "IN", "356", "16", "", "", "", "21.5606", "74.21258", "Asia/Kolkata"),
("1255121", "Taliparamba", "", "IN", "356", "13", "", "", "", "12.03454", "75.36161", "Asia/Kolkata"),
("1255122", "Talikota", "", "IN", "356", "19", "", "", "", "16.47632", "76.31087", "Asia/Kolkata"),
("1255131", "Taleigao", "", "IN", "356", "33", "", "", "", "15.46915", "73.83285", "Asia/Kolkata"),
("1255134", "Talegaon Dabhade", "", "IN", "356", "16", "", "", "", "18.73502", "73.67561", "Asia/Kolkata"),
("1255143", "Talcher", "", "IN", "356", "21", "", "", "", "20.94927", "85.23354", "Asia/Kolkata"),
("1255175", "Talaja", "", "IN", "356", "09", "", "", "", "21.3527", "72.03524", "Asia/Kolkata"),
("1255211", "Taki", "Такой", "IN", "356", "28", "", "", "", "22.58868", "88.93253", "Asia/Kolkata"),
("1255212", "Takhatpur", "", "IN", "356", "37", "", "", "", "22.12879", "81.86974", "Asia/Kolkata"),
("1255213", "Takhatgarh", "", "IN", "356", "24", "", "", "", "25.3227", "73.00322", "Asia/Kolkata"),
("1255224", "Tajpur", "", "IN", "356", "36", "", "", "", "29.16348", "78.48403", "Asia/Kolkata"),
("1255254", "Tadpatri", "", "IN", "356", "02", "", "", "", "14.90813", "78.01108", "Asia/Kolkata"),
("1255264", "Tadepallegudem", "", "IN", "356", "02", "", "", "", "16.81304", "81.52874", "Asia/Kolkata"),
("1255265", "Tadepalle", "", "IN", "356", "02", "", "", "", "16.48333", "80.6", "Asia/Kolkata"),
("1255344", "Suriapet", "", "IN", "356", "02", "", "", "", "17.14054", "79.62044", "Asia/Kolkata"),
("1255346", "Surianwan", "", "IN", "356", "36", "", "", "", "25.46333", "82.42058", "Asia/Kolkata"),
("1255349", "Surendranagar", "", "IN", "356", "09", "", "", "", "22.72706", "71.64856", "Asia/Kolkata"),
("1255361", "Suratgarh", "Суратгарх", "IN", "356", "24", "", "", "", "29.3215", "73.89979", "Asia/Kolkata"),
("1255364", "Surat", "", "IN", "356", "09", "", "", "", "21.19594", "72.83023", "Asia/Kolkata"),
("1255372", "Surandai", "", "IN", "356", "25", "", "", "", "8.97574", "77.41923", "Asia/Kolkata"),
("1255383", "Surajgarh", "", "IN", "356", "24", "", "", "", "28.31005", "75.73271", "Asia/Kolkata"),
("1255396", "Supaul", "", "IN", "356", "34", "", "", "", "26.11503", "86.59527", "Asia/Kolkata"),
("1255425", "Sunel", "", "IN", "356", "24", "", "", "", "24.37066", "75.95708", "Asia/Kolkata"),
("1255434", "Sundarnagar", "", "IN", "356", "11", "", "", "", "31.53276", "76.90594", "Asia/Kolkata"),
("1255437", "Sundargarh", "", "IN", "356", "21", "", "", "", "22.11667", "84.03333", "Asia/Kolkata"),
("1255449", "Sunam", "", "IN", "356", "23", "", "", "", "30.1297", "75.80715", "Asia/Kolkata"),
("1255482", "Sulya", "", "IN", "356", "19", "", "", "", "12.56458", "75.39085", "Asia/Kolkata"),
("1255483", "Suluru", "", "IN", "356", "02", "", "", "", "13.7", "80.01667", "Asia/Kolkata"),
("1255484", "Sulur", "", "IN", "356", "25", "", "", "", "11.02427", "77.12565", "Asia/Kolkata"),
("1255488", "Sultanpur Lodhi", "", "IN", "356", "23", "", "", "", "31.21448", "75.19563", "Asia/Kolkata"),
("1255491", "Sultanpur", "", "IN", "356", "36", "", "", "", "26.25996", "82.07314", "Asia/Kolkata"),
("1255551", "Suket", "", "IN", "356", "24", "", "", "", "24.64933", "76.04423", "Asia/Kolkata"),
("1255560", "Sujangarh", "", "IN", "356", "24", "", "", "", "27.7", "74.46667", "Asia/Kolkata"),
("1255597", "Suar", "Суар", "IN", "356", "36", "", "", "", "29.02668", "79.0576", "Asia/Kolkata"),
("1255616", "Srivilliputhur", "", "IN", "356", "25", "", "", "", "9.51272", "77.63369", "Asia/Kolkata"),
("1255619", "Srivardhan", "", "IN", "356", "16", "", "", "", "18.04592", "73.01552", "Asia/Kolkata"),
("1255620", "Srivaikuntam", "", "IN", "356", "25", "", "", "", "8.62931", "77.91281", "Asia/Kolkata"),
("1255621", "Srisailam", "", "IN", "356", "02", "", "", "", "16.07277", "78.8692", "Asia/Kolkata"),
("1255625", "Sriramnagar", "", "IN", "356", "02", "", "", "", "17.26652", "78.25544", "Asia/Kolkata"),
("1255630", "Sriperumbudur", "", "IN", "356", "25", "", "", "", "12.96763", "79.94197", "Asia/Kolkata"),
("1255631", "Srinivaspur", "", "IN", "356", "19", "", "", "", "13.33933", "78.2119", "Asia/Kolkata"),
("1255634", "Srinagar", "Шринагар", "IN", "356", "12", "", "", "", "34.08842", "74.80298", "Asia/Kolkata"),
("1255635", "Srinagar", "Шринагар", "IN", "356", "39", "", "", "", "30.22242", "78.78341", "Asia/Kolkata"),
("1255643", "Sri Madhopur", "", "IN", "356", "24", "", "", "", "27.46599", "75.59736", "Asia/Kolkata"),
("1255646", "Karanpur", "", "IN", "356", "24", "", "", "", "29.84042", "73.45519", "Asia/Kolkata"),
("1255647", "Srikakulam", "", "IN", "356", "02", "", "", "", "18.29692", "83.89732", "Asia/Kolkata"),
("1255654", "Sri Dungargarh", "", "IN", "356", "24", "", "", "", "28.09712", "74.00937", "Asia/Kolkata"),
("1255667", "Soygaon", "", "IN", "356", "16", "", "", "", "20.59611", "75.61781", "Asia/Kolkata"),
("1255704", "Soron", "Сорон", "IN", "356", "36", "", "", "", "27.89012", "78.7467", "Asia/Kolkata"),
("1255705", "Soro", "", "IN", "356", "21", "", "", "", "21.27851", "86.68833", "Asia/Kolkata"),
("1255712", "Sorada", "", "IN", "356", "21", "", "", "", "19.76082", "84.42997", "Asia/Kolkata"),
("1255714", "Sopur", "", "IN", "356", "12", "", "", "", "34.28787", "74.47219", "Asia/Kolkata"),
("1255744", "Sonipat", "", "IN", "356", "10", "", "", "", "28.99587", "77.01165", "Asia/Kolkata"),
("1255762", "Songadh", "", "IN", "356", "09", "", "", "", "21.16966", "73.56357", "Asia/Kolkata"),
("1255763", "Sonepur", "", "IN", "356", "21", "", "", "", "20.83333", "83.91667", "Asia/Kolkata"),
("1255788", "Sonari", "", "IN", "356", "03", "", "", "", "27.02462", "95.01629", "Asia/Kolkata"),
("1255792", "Sonamukhi", "", "IN", "356", "28", "", "", "", "23.3052", "87.41336", "Asia/Kolkata"),
("1255816", "Sompeta", "", "IN", "356", "02", "", "", "", "18.94419", "84.58449", "Asia/Kolkata"),
("1255823", "Someshwar", "", "IN", "356", "19", "", "", "", "13.49112", "75.06646", "Asia/Kolkata"),
("1255850", "Solan", "Солана", "IN", "356", "11", "", "", "", "30.9086", "77.10873", "Asia/Kolkata"),
("1255858", "Sojitra", "", "IN", "356", "09", "", "", "", "22.53884", "72.71984", "Asia/Kolkata"),
("1255860", "Sojat", "", "IN", "356", "24", "", "", "", "25.92493", "73.66633", "Asia/Kolkata"),
("1255870", "Sohna", "", "IN", "356", "10", "", "", "", "28.24737", "77.06544", "Asia/Kolkata"),
("1255884", "Sohagpur", "", "IN", "356", "35", "", "", "", "22.70133", "78.19895", "Asia/Kolkata"),
("1255925", "Siwana", "", "IN", "356", "24", "", "", "", "25.65154", "72.42244", "Asia/Kolkata"),
("1255927", "Siwan", "Сиван", "IN", "356", "34", "", "", "", "26.22152", "84.35879", "Asia/Kolkata"),
("1255947", "Sivakasi", "", "IN", "356", "25", "", "", "", "9.44999", "77.79797", "Asia/Kolkata"),
("1255950", "Sivagiri", "", "IN", "356", "25", "", "", "", "11.1194", "77.78788", "Asia/Kolkata"),
("1255951", "Sivagiri", "", "IN", "356", "25", "", "", "", "9.34461", "77.42911", "Asia/Kolkata"),
("1255953", "Sivaganga", "Шиваганга", "IN", "356", "25", "", "", "", "9.84701", "78.48358", "Asia/Kolkata"),
("1255955", "Siuri", "", "IN", "356", "28", "", "", "", "23.90806", "87.52773", "Asia/Kolkata"),
("1255963", "Sitarganj", "", "IN", "356", "39", "", "", "", "28.93214", "79.70452", "Asia/Kolkata"),
("1255969", "Sitapur", "", "IN", "356", "36", "", "", "", "27.56192", "80.68265", "Asia/Kolkata"),
("1255983", "Sitamarhi", "", "IN", "356", "34", "", "", "", "26.59356", "85.4906", "Asia/Kolkata"),
("1255995", "Siswa Bazar", "", "IN", "356", "36", "", "", "", "27.14652", "83.75803", "Asia/Kolkata"),
("1256003", "Sisauli", "", "IN", "356", "36", "", "", "", "29.41448", "77.46877", "Asia/Kolkata"),
("1256025", "Sirur", "", "IN", "356", "16", "", "", "", "18.8276", "74.37475", "Asia/Kolkata"),
("1256027", "Sirumugai", "", "IN", "356", "25", "1273866", "", "", "11.32137", "77.00521", "Asia/Kolkata"),
("1256029", "Siruguppa", "", "IN", "356", "19", "", "", "", "15.63138", "76.89271", "Asia/Kolkata"),
("1256039", "Sirsilla", "", "IN", "356", "02", "", "", "", "18.38865", "78.81048", "Asia/Kolkata"),
("1256040", "Sirsi", "", "IN", "356", "36", "", "", "", "28.63933", "78.64152", "Asia/Kolkata"),
("1256047", "Sirsi", "", "IN", "356", "19", "", "", "", "14.61686", "74.83087", "Asia/Kolkata"),
("1256050", "Sirsaganj", "", "IN", "356", "36", "", "", "", "27.05745", "78.68665", "Asia/Kolkata"),
("1256052", "Sirsa", "", "IN", "356", "10", "", "", "", "29.53489", "75.02898", "Asia/Kolkata"),
("1256064", "Sironj", "", "IN", "356", "35", "", "", "", "24.1038", "77.68959", "Asia/Kolkata"),
("1256067", "Sirohi", "", "IN", "356", "24", "", "", "", "24.88838", "72.84794", "Asia/Kolkata"),
("1256075", "Sirkazhi", "", "IN", "356", "25", "", "", "", "11.23725", "79.73585", "Asia/Kolkata"),
("1256087", "Sirhind", "", "IN", "356", "23", "", "", "", "30.64332", "76.38489", "Asia/Kolkata"),
("1256104", "Sira", "", "IN", "356", "19", "", "", "", "13.74155", "76.9043", "Asia/Kolkata"),
("1256119", "Sinnar", "Синнар", "IN", "356", "16", "", "", "", "19.84505", "73.99866", "Asia/Kolkata"),
("1256124", "Singur", "", "IN", "356", "28", "", "", "", "22.80917", "88.22944", "Asia/Kolkata"),
("1256176", "Singarayakonda", "", "IN", "356", "02", "", "", "", "15.23094", "80.02802", "Asia/Kolkata"),
("1256184", "Singanallur", "", "IN", "356", "25", "", "", "", "10.99816", "77.03375", "Asia/Kolkata"),
("1256207", "Sindhnur", "", "IN", "356", "19", "", "", "", "15.76982", "76.75581", "Asia/Kolkata"),
("1256214", "Sindgi", "", "IN", "356", "19", "", "", "", "16.91845", "76.23336", "Asia/Kolkata"),
("1256237", "Shimla", "Шимла", "IN", "356", "11", "", "", "", "31.10442", "77.16662", "Asia/Kolkata"),
("1256246", "Simdega", "", "IN", "356", "38", "", "", "", "22.61523", "84.50208", "Asia/Kolkata"),
("1256259", "Silvassa", "", "IN", "356", "06", "", "", "", "20.27386", "72.99673", "Asia/Kolkata"),
("1256269", "Sillod", "", "IN", "356", "16", "", "", "", "20.30303", "75.65284", "Asia/Kolkata"),
("1256287", "Silchar", "Силчар", "IN", "356", "03", "", "", "", "24.82733", "92.79787", "Asia/Kolkata"),
("1256295", "Silao", "Силао", "IN", "356", "34", "", "", "", "25.08317", "85.42782", "Asia/Kolkata"),
("1256320", "Sikar", "", "IN", "356", "24", "", "", "", "27.61206", "75.13996", "Asia/Kolkata"),
("1256322", "Sikandra Rao", "", "IN", "356", "36", "", "", "", "27.68806", "78.38114", "Asia/Kolkata"),
("1256328", "Sikandarpur", "", "IN", "356", "36", "", "", "", "26.04306", "84.05426", "Asia/Kolkata"),
("1256329", "Sikandarabad", "", "IN", "356", "36", "", "", "", "28.45341", "77.69807", "Asia/Kolkata"),
("1256333", "Sikka", "", "IN", "356", "09", "", "", "", "22.43218", "69.84158", "Asia/Kolkata"),
("1256335", "Sijua", "", "IN", "356", "38", "", "", "", "23.77617", "86.33028", "Asia/Kolkata"),
("1256340", "Sihora", "", "IN", "356", "35", "", "", "", "23.48872", "80.10348", "Asia/Kolkata"),
("1256343", "Sihor", "", "IN", "356", "09", "", "", "", "21.71134", "71.96179", "Asia/Kolkata"),
("1256363", "Sidlaghatta", "", "IN", "356", "19", "", "", "", "13.39141", "77.86488", "Asia/Kolkata"),
("1256369", "Sidhi", "Сидхи", "IN", "356", "35", "", "", "", "24.39329", "81.87935", "Asia/Kolkata"),
("1256372", "Sidhauli", "", "IN", "356", "36", "", "", "", "27.26761", "80.81029", "Asia/Kolkata"),
("1256377", "Siddipet", "", "IN", "356", "02", "", "", "", "18.10483", "78.84858", "Asia/Kolkata"),
("1256382", "Siddhapur", "", "IN", "356", "09", "", "", "", "23.91783", "72.37212", "Asia/Kolkata"),
("1256388", "Sibsagar", "Сибсагар", "IN", "356", "03", "", "", "", "26.98427", "94.63784", "Asia/Kolkata"),
("1256409", "Shyamnagar", "", "IN", "356", "28", "8335144", "", "", "22.83333", "88.36667", "Asia/Kolkata"),
("1256418", "Shujalpur", "", "IN", "356", "35", "", "", "", "23.40659", "76.70951", "Asia/Kolkata"),
("1256421", "Shrirangapattana", "", "IN", "356", "19", "", "", "", "12.42264", "76.68439", "Asia/Kolkata"),
("1256422", "Shrirampur", "", "IN", "356", "28", "", "", "", "22.75278", "88.34222", "Asia/Kolkata"),
("1256426", "Shrigonda", "", "IN", "356", "16", "", "", "", "18.61527", "74.69895", "Asia/Kolkata"),
("1256431", "Shorapur", "", "IN", "356", "19", "", "", "", "16.521", "76.75738", "Asia/Kolkata"),
("1256432", "Shoranur", "", "IN", "356", "13", "", "", "", "10.76097", "76.27001", "Asia/Kolkata"),
("1256435", "Sholinghur", "", "IN", "356", "25", "", "", "", "13.1181", "79.42025", "Asia/Kolkata"),
("1256436", "Solapur", "Солапур", "IN", "356", "16", "", "", "", "17.67152", "75.91044", "Asia/Kolkata"),
("1256451", "Shivpuri", "", "IN", "356", "35", "", "", "", "25.42348", "77.66067", "Asia/Kolkata"),
("1256468", "Shishgarh", "", "IN", "356", "36", "", "", "", "28.73178", "79.3139", "Asia/Kolkata"),
("1256475", "Shirpur", "Ширпуре", "IN", "356", "16", "", "", "", "21.35161", "74.88037", "Asia/Kolkata"),
("1256483", "Shirhatti", "", "IN", "356", "19", "", "", "", "15.23352", "75.57996", "Asia/Kolkata"),
("1256489", "Shirdi", "Ширди", "IN", "356", "16", "", "", "", "19.76616", "74.47738", "Asia/Kolkata"),
("1256515", "Shimoga", "", "IN", "356", "19", "", "", "", "13.93157", "75.56791", "Asia/Kolkata"),
("1256523", "Shillong", "Шиллонг", "IN", "356", "18", "", "", "", "25.56892", "91.88313", "Asia/Kolkata"),
("1256525", "Shiliguri", "Силигури", "IN", "356", "28", "", "", "", "26.71004", "88.42851", "Asia/Kolkata"),
("1256529", "Shikohabad", "", "IN", "356", "36", "", "", "", "27.10813", "78.58675", "Asia/Kolkata"),
("1256532", "Shikarpur", "", "IN", "356", "36", "", "", "", "28.28178", "78.01111", "Asia/Kolkata"),
("1256537", "Shikarpur", "", "IN", "356", "19", "", "", "", "14.2698", "75.35643", "Asia/Kolkata"),
("1256539", "Shiggaon", "", "IN", "356", "19", "", "", "", "14.99053", "75.22498", "Asia/Kolkata"),
("1256558", "Shertallai", "", "IN", "356", "13", "", "", "", "9.68428", "76.35337", "Asia/Kolkata"),
("1256569", "Sherkot", "", "IN", "356", "36", "", "", "", "29.32627", "78.57448", "Asia/Kolkata"),
("1256572", "Sherghati", "", "IN", "356", "34", "", "", "", "24.55971", "84.79344", "Asia/Kolkata"),
("1256593", "Sheopur", "", "IN", "356", "35", "", "", "", "25.66677", "76.69612", "Asia/Kolkata"),
("1256597", "Sheohar", "", "IN", "356", "34", "", "", "", "26.51393", "85.2934", "Asia/Kolkata"),
("1256598", "Sheoganj", "", "IN", "356", "24", "", "", "", "25.13915", "73.06784", "Asia/Kolkata"),
("1256620", "Shegaon", "", "IN", "356", "16", "", "", "", "20.7932", "76.69921", "Asia/Kolkata"),
("1256639", "Shantipur", "", "IN", "356", "28", "", "", "", "23.24722", "88.43302", "Asia/Kolkata"),
("1256659", "Shamsabad", "", "IN", "356", "36", "", "", "", "27.53733", "79.43622", "Asia/Kolkata"),
("1256660", "Shamsabad", "", "IN", "356", "36", "", "", "", "27.01628", "78.12348", "Asia/Kolkata"),
("1256671", "Shamli", "", "IN", "356", "36", "", "", "", "29.44934", "77.31282", "Asia/Kolkata"),
("1256673", "Shamgarh", "", "IN", "356", "35", "", "", "", "24.18817", "75.63903", "Asia/Kolkata"),
("1256693", "Shajapur", "", "IN", "356", "35", "", "", "", "23.42688", "76.27772", "Asia/Kolkata"),
("1256698", "Shaikhpura", "", "IN", "356", "34", "", "", "", "25.14067", "85.84332", "Asia/Kolkata"),
("1256705", "Shahpura", "", "IN", "356", "24", "", "", "", "27.3912", "75.95956", "Asia/Kolkata"),
("1256706", "Shahpura", "", "IN", "356", "24", "", "", "", "25.62094", "74.92487", "Asia/Kolkata"),
("1256713", "Shahpur", "Шахпура", "IN", "356", "36", "", "", "", "29.35014", "77.55062", "Asia/Kolkata"),
("1256715", "Shahpur", "", "IN", "356", "34", "", "", "", "25.60213", "84.40412", "Asia/Kolkata"),
("1256720", "Shahpur", "", "IN", "356", "35", "", "", "", "21.2372", "76.22562", "Asia/Kolkata"),
("1256722", "Shahpur", "Шахпура", "IN", "356", "19", "", "", "", "16.70056", "76.84136", "Asia/Kolkata"),
("1256728", "Shahjahanpur", "", "IN", "356", "36", "", "", "", "27.88142", "79.9109", "Asia/Kolkata"),
("1256731", "Shahi", "", "IN", "356", "36", "", "", "", "28.54946", "79.3169", "Asia/Kolkata"),
("1256735", "Shahganj", "", "IN", "356", "36", "", "", "", "26.05263", "82.68134", "Asia/Kolkata"),
("1256739", "Shahdol", "", "IN", "356", "35", "", "", "", "23.29356", "81.3619", "Asia/Kolkata"),
("1256750", "Shahada", "", "IN", "356", "16", "", "", "", "21.54537", "74.47132", "Asia/Kolkata"),
("1256752", "Shahabad", "", "IN", "356", "10", "", "", "", "30.16794", "76.86977", "Asia/Kolkata"),
("1256753", "Shahabad", "", "IN", "356", "36", "", "", "", "28.56681", "79.00956", "Asia/Kolkata"),
("1256755", "Shahabad", "", "IN", "356", "36", "", "", "", "27.64327", "79.93908", "Asia/Kolkata"),
("1256759", "Shahabad", "", "IN", "356", "19", "", "", "", "17.1307", "76.94361", "Asia/Kolkata"),
("1256812", "Serchhip", "", "IN", "356", "31", "", "", "", "23.29312", "92.84679", "Asia/Kolkata"),
("1256814", "Seram", "Серам", "IN", "356", "19", "", "", "", "17.17859", "77.28998", "Asia/Kolkata"),
("1256823", "Seoni Malwa", "", "IN", "356", "35", "", "", "", "22.45", "77.46667", "Asia/Kolkata"),
("1256826", "Seoni", "", "IN", "356", "35", "", "", "", "22.08664", "79.55044", "Asia/Kolkata"),
("1256828", "Seondha", "", "IN", "356", "35", "", "", "", "26.15422", "78.7812", "Asia/Kolkata"),
("1256832", "Seohara", "", "IN", "356", "36", "", "", "", "29.2088", "78.58695", "Asia/Kolkata"),
("1256854", "Sendhwa", "", "IN", "356", "35", "", "", "", "21.68586", "75.0975", "Asia/Kolkata"),
("1256913", "Sehore", "", "IN", "356", "35", "", "", "", "23.2", "77.08333", "Asia/Kolkata"),
("1256922", "Secunderabad", "", "IN", "356", "02", "", "", "", "17.50427", "78.54263", "Asia/Kolkata"),
("1256929", "Sayla", "", "IN", "356", "09", "", "", "", "22.54925", "71.48324", "Asia/Kolkata"),
("1256949", "Sawai Madhopur", "", "IN", "356", "24", "", "", "", "26.02301", "76.34408", "Asia/Kolkata"),
("1256959", "Savda", "", "IN", "356", "16", "", "", "", "21.15035", "75.88898", "Asia/Kolkata"),
("1256967", "Savanur", "", "IN", "356", "19", "", "", "", "14.97335", "75.33724", "Asia/Kolkata"),
("1256968", "Savantvadi", "", "IN", "356", "16", "", "", "", "15.90412", "73.82191", "Asia/Kolkata"),
("1256974", "Sausar", "", "IN", "356", "35", "", "", "", "21.65688", "78.79738", "Asia/Kolkata"),
("1256983", "Saundatti", "", "IN", "356", "19", "", "", "", "15.76615", "75.11778", "Asia/Kolkata"),
("1256989", "Sathyamangalam", "", "IN", "356", "25", "", "", "", "11.50526", "77.23826", "Asia/Kolkata"),
("1256995", "Sattur", "", "IN", "356", "25", "", "", "", "9.35592", "77.92457", "Asia/Kolkata"),
("1257001", "Sattenapalle", "", "IN", "356", "02", "", "", "", "16.39395", "80.15135", "Asia/Kolkata"),
("1257022", "Satna", "", "IN", "356", "35", "1257023", "", "", "24.58224", "80.8248", "Asia/Kolkata"),
("1257055", "Satara", "Сатара", "IN", "356", "16", "", "", "", "17.68589", "73.99333", "Asia/Kolkata"),
("1257060", "Satana", "", "IN", "356", "16", "", "", "", "20.59375", "74.20338", "Asia/Kolkata"),
("1257066", "Sasvad", "", "IN", "356", "16", "", "", "", "18.34351", "74.03102", "Asia/Kolkata"),
("1257093", "Sarwar", "", "IN", "356", "24", "", "", "", "26.06272", "75.01104", "Asia/Kolkata"),
("1257149", "Sarkhej", "", "IN", "356", "09", "", "", "", "22.98297", "72.50196", "Asia/Kolkata"),
("1257191", "Sardulgarh", "", "IN", "356", "23", "", "", "", "29.69224", "75.23608", "Asia/Kolkata"),
("1257196", "Sardhana", "", "IN", "356", "36", "", "", "", "29.14614", "77.61266", "Asia/Kolkata"),
("1257198", "Sardarshahr", "", "IN", "356", "24", "", "", "", "28.44062", "74.491", "Asia/Kolkata"),
("1257219", "Sarauli", "", "IN", "356", "36", "", "", "", "28.4929", "79.0914", "Asia/Kolkata"),
("1257237", "Sarangpur", "", "IN", "356", "35", "", "", "", "23.56645", "76.47194", "Asia/Kolkata"),
("1257259", "Saraipali", "", "IN", "356", "37", "", "", "", "21.31506", "83.00548", "Asia/Kolkata"),
("1257260", "Sarai Mir", "", "IN", "356", "36", "", "", "", "26.02796", "82.91795", "Asia/Kolkata"),
("1257268", "Sarai Akil", "", "IN", "356", "36", "", "", "", "25.37841", "81.5113", "Asia/Kolkata"),
("1257307", "Saoner", "", "IN", "356", "16", "", "", "", "21.38586", "78.92087", "Asia/Kolkata"),
("1257354", "Sankrail", "", "IN", "356", "28", "", "", "", "22.54997", "88.22515", "Asia/Kolkata"),
("1257369", "Sankeshwar", "", "IN", "356", "19", "", "", "", "16.25649", "74.48195", "Asia/Kolkata"),
("1257402", "Sangrur", "", "IN", "356", "23", "", "", "", "30.24608", "75.84686", "Asia/Kolkata"),
("1257409", "Sangola", "", "IN", "356", "16", "", "", "", "17.43948", "75.19379", "Asia/Kolkata"),
("1257410", "Sangod", "", "IN", "356", "24", "", "", "", "24.92707", "76.28649", "Asia/Kolkata"),
("1257416", "Sangli", "", "IN", "356", "16", "", "", "", "16.85438", "74.56417", "Asia/Kolkata"),
("1257429", "Sangaria", "", "IN", "356", "10", "", "", "", "29.79601", "74.4628", "Asia/Kolkata"),
("1257431", "Sangareddi", "", "IN", "356", "02", "", "", "", "17.62478", "78.08669", "Asia/Kolkata"),
("1257436", "Sangamner", "", "IN", "356", "16", "", "", "", "19.56784", "74.21154", "Asia/Kolkata"),
("1257456", "Sandur", "", "IN", "356", "19", "", "", "", "15.08613", "76.54692", "Asia/Kolkata"),
("1257459", "Sandila", "", "IN", "356", "36", "", "", "", "27.07042", "80.5146", "Asia/Kolkata"),
("1257461", "Sandi", "", "IN", "356", "36", "", "", "", "27.2884", "79.95204", "Asia/Kolkata"),
("1257476", "Sancoale", "", "IN", "356", "33", "", "", "", "15.37794", "73.90352", "Asia/Kolkata"),
("1257477", "Sanchor", "", "IN", "356", "24", "", "", "", "24.7536", "71.7728", "Asia/Kolkata"),
("1257481", "Sanawad", "", "IN", "356", "35", "", "", "", "22.17146", "76.07072", "Asia/Kolkata"),
("1257482", "Sanaur", "", "IN", "356", "23", "", "", "", "30.30145", "76.457", "Asia/Kolkata"),
("1257486", "Sanand", "", "IN", "356", "09", "", "", "", "22.99227", "72.38177", "Asia/Kolkata"),
("1257498", "Samthar", "", "IN", "356", "35", "", "", "", "25.84331", "78.90582", "Asia/Kolkata"),
("1257503", "Samrala", "", "IN", "356", "23", "", "", "", "30.83642", "76.19262", "Asia/Kolkata"),
("1257528", "Samdari", "", "IN", "356", "24", "", "", "", "25.81299", "72.57879", "Asia/Kolkata"),
("1257539", "Sambhar", "Самбхара", "IN", "356", "24", "", "", "", "26.90806", "75.19137", "Asia/Kolkata"),
("1257540", "Sambhal", "", "IN", "356", "36", "", "", "", "28.58323", "78.56689", "Asia/Kolkata"),
("1257542", "Sambalpur", "Самбалпур", "IN", "356", "21", "", "", "", "21.45", "83.96667", "Asia/Kolkata"),
("1257545", "Samba", "", "IN", "356", "12", "", "", "", "32.56113", "75.12494", "Asia/Kolkata"),
("1257551", "Samastipur", "", "IN", "356", "34", "", "", "", "25.86077", "85.78971", "Asia/Kolkata"),
("1257565", "Samalkot", "", "IN", "356", "02", "", "", "", "17.05359", "82.17216", "Asia/Kolkata"),
("1257566", "Samalkha", "", "IN", "356", "10", "", "", "", "29.23578", "77.0138", "Asia/Kolkata"),
("1257587", "Salur", "", "IN", "356", "02", "", "", "", "18.51652", "83.20515", "Asia/Kolkata"),
("1257588", "Salumbar", "", "IN", "356", "24", "", "", "", "24.13524", "74.04442", "Asia/Kolkata"),
("1257629", "Salem", "Салем", "IN", "356", "25", "", "", "", "11.65116", "78.15867", "Asia/Kolkata"),
("1257638", "Salaya", "", "IN", "356", "09", "", "", "", "22.31038", "69.60376", "Asia/Kolkata"),
("1257673", "Sakti", "Шакти", "IN", "356", "37", "", "", "", "22.0271", "82.96108", "Asia/Kolkata"),
("1257698", "Sakleshpur", "", "IN", "356", "19", "", "", "", "12.94005", "75.78388", "Asia/Kolkata"),
("1257749", "Saint Thomas Mount", "", "IN", "356", "25", "", "", "", "13.00334", "80.19614", "Asia/Kolkata"),
("1257751", "Sainthia", "", "IN", "356", "28", "", "", "", "23.94826", "87.68045", "Asia/Kolkata"),
("1257762", "Sailu", "", "IN", "356", "16", "", "", "", "19.45514", "76.43946", "Asia/Kolkata"),
("1257771", "Saiha", "", "IN", "356", "31", "", "", "", "22.49183", "92.98142", "Asia/Kolkata"),
("1257776", "Saidpur", "", "IN", "356", "36", "", "", "", "25.53834", "83.22122", "Asia/Kolkata"),
("1257794", "Sahibganj", "", "IN", "356", "38", "", "", "", "25.24237", "87.64908", "Asia/Kolkata"),
("1257799", "Sahawar", "", "IN", "356", "36", "", "", "", "27.79593", "78.83358", "Asia/Kolkata"),
("1257800", "Sahaswan", "", "IN", "356", "36", "", "", "", "28.07245", "78.7493", "Asia/Kolkata"),
("1257802", "Sahaspur", "", "IN", "356", "36", "", "", "", "29.12067", "78.62148", "Asia/Kolkata"),
("1257804", "Saharsa", "", "IN", "356", "34", "", "", "", "25.88504", "86.59471", "Asia/Kolkata"),
("1257806", "Saharanpur", "", "IN", "356", "36", "", "", "", "29.9679", "77.54522", "Asia/Kolkata"),
("1257830", "Sagauli", "", "IN", "356", "34", "", "", "", "26.77137", "84.74197", "Asia/Kolkata"),
("1257845", "Sagar", "Сагар", "IN", "356", "35", "", "", "", "23.84251", "78.74386", "Asia/Kolkata"),
("1257851", "Sagar", "", "IN", "356", "19", "", "", "", "14.16498", "75.02901", "Asia/Kolkata"),
("1257854", "Safipur", "", "IN", "356", "36", "", "", "", "26.73783", "80.3435", "Asia/Kolkata"),
("1257855", "Safidon", "", "IN", "356", "10", "", "", "", "29.40572", "76.6694", "Asia/Kolkata"),
("1257865", "Sadri", "", "IN", "356", "24", "", "", "", "25.18625", "73.45286", "Asia/Kolkata"),
("1257890", "Sadaseopet", "", "IN", "356", "02", "1263231", "", "", "17.61925", "77.95263", "Asia/Kolkata"),
("1257895", "Sadalgi", "", "IN", "356", "19", "", "", "", "16.5587", "74.53211", "Asia/Kolkata"),
("1257896", "Sadabad", "", "IN", "356", "36", "", "", "", "27.43978", "78.03667", "Asia/Kolkata"),
("1257928", "Sabalgarh", "", "IN", "356", "35", "", "", "", "26.24918", "77.40786", "Asia/Kolkata"),
("1257936", "Rusera", "", "IN", "356", "34", "", "", "", "25.75355", "86.02597", "Asia/Kolkata"),
("1257940", "Rura", "", "IN", "356", "36", "", "", "", "26.487", "79.90243", "Asia/Kolkata"),
("1257951", "Rupnagar", "", "IN", "356", "23", "", "", "", "30.96878", "76.52557", "Asia/Kolkata"),
("1258012", "Rudarpur", "", "IN", "356", "36", "", "", "", "26.44335", "83.61238", "Asia/Kolkata"),
("1258044", "Roorkee", "Рурки", "IN", "356", "39", "", "", "", "29.86313", "77.89126", "Asia/Kolkata"),
("1258061", "Ron", "Рона", "IN", "356", "19", "", "", "", "15.69935", "75.73408", "Asia/Kolkata"),
("1258076", "Rohtak", "Рохтак", "IN", "356", "10", "", "", "", "28.88838", "76.5754", "Asia/Kolkata"),
("1258099", "Roha", "", "IN", "356", "16", "", "", "", "18.43687", "73.11964", "Asia/Kolkata"),
("1258109", "Robertsonpet", "", "IN", "356", "19", "", "", "", "12.95629", "78.27543", "Asia/Kolkata"),
("1258111", "Robertsganj", "", "IN", "356", "36", "", "", "", "24.6889", "83.06632", "Asia/Kolkata"),
("1258124", "Risod", "", "IN", "356", "16", "", "", "", "19.9755", "76.78844", "Asia/Kolkata"),
("1258126", "Rishra", "", "IN", "356", "28", "", "", "", "22.72394", "88.34563", "Asia/Kolkata"),
("1258128", "Rishikesh", "Ришикеш", "IN", "356", "39", "", "", "", "30.10778", "78.29255", "Asia/Kolkata"),
("1258140", "Ringas", "", "IN", "356", "24", "", "", "", "27.3636", "75.56838", "Asia/Kolkata"),
("1258164", "Richha", "", "IN", "356", "36", "", "", "", "28.6937", "79.5219", "Asia/Kolkata"),
("1258178", "Rewari", "", "IN", "356", "10", "", "", "", "28.19721", "76.61757", "Asia/Kolkata"),
("1258182", "Rewa", "Рева", "IN", "356", "35", "", "", "", "24.53398", "81.29596", "Asia/Kolkata"),
("1258186", "Revelganj", "", "IN", "356", "34", "", "", "", "25.78553", "84.64038", "Asia/Kolkata"),
("1258201", "Repalle", "Репалле", "IN", "356", "02", "", "", "", "16.0184", "80.82958", "Asia/Kolkata"),
("1258203", "Reoti", "", "IN", "356", "34", "", "", "", "25.85017", "84.37794", "Asia/Kolkata"),
("1258207", "Renukut", "", "IN", "356", "36", "", "", "", "24.21641", "83.0358", "Asia/Kolkata"),
("1258213", "Renigunta", "", "IN", "356", "02", "", "", "", "13.63682", "79.5039", "Asia/Kolkata"),
("1258229", "Remuna", "", "IN", "356", "21", "", "", "", "21.52798", "86.87156", "Asia/Kolkata"),
("1258247", "Rehli", "", "IN", "356", "35", "", "", "", "23.63628", "79.06233", "Asia/Kolkata"),
("1258270", "Razam", "", "IN", "356", "02", "", "", "", "18.44799", "83.65672", "Asia/Kolkata"),
("1258278", "Raybag", "", "IN", "356", "19", "", "", "", "16.49178", "74.77391", "Asia/Kolkata"),
("1258290", "Rayadrug", "", "IN", "356", "02", "", "", "", "14.69743", "76.85769", "Asia/Kolkata"),
("1258291", "Rayachoti", "", "IN", "356", "02", "", "", "", "14.0568", "78.75127", "Asia/Kolkata"),
("1258292", "Raya", "Рая", "IN", "356", "36", "", "", "", "27.55668", "77.79017", "Asia/Kolkata"),
("1258294", "Raxaul", "Раксаул", "IN", "356", "34", "", "", "", "26.9832", "84.85109", "Asia/Kolkata"),
("1258295", "Rawatsar", "", "IN", "356", "24", "", "", "", "29.26724", "74.40288", "Asia/Kolkata"),
("1258297", "Rawatbhata", "", "IN", "356", "24", "", "", "", "24.92981", "75.59209", "Asia/Kolkata"),
("1258307", "Raver", "", "IN", "356", "16", "", "", "", "21.24749", "76.03483", "Asia/Kolkata"),
("1258338", "Ratnagiri", "Ратнагири", "IN", "356", "16", "8131499", "1258340", "", "16.99154", "73.31022", "Asia/Kolkata"),
("1258342", "Ratlam", "", "IN", "356", "35", "", "", "", "23.33033", "75.04032", "Asia/Kolkata"),
("1258347", "Ratia", "Ратиа", "IN", "356", "10", "", "", "", "29.6854", "75.57461", "Asia/Kolkata"),
("1258352", "Rath", "Рата", "IN", "356", "36", "", "", "", "25.59453", "79.56632", "Asia/Kolkata"),
("1258362", "Ratanpur", "", "IN", "356", "37", "", "", "", "22.28785", "82.16767", "Asia/Kolkata"),
("1258366", "Ratangarh", "", "IN", "356", "24", "", "", "", "28.08137", "74.61854", "Asia/Kolkata"),
("1258380", "Rasra", "", "IN", "356", "36", "", "", "", "25.85691", "83.85455", "Asia/Kolkata"),
("1258386", "Rasipuram", "", "IN", "356", "25", "6640313", "", "", "11.46009", "78.18635", "Asia/Kolkata"),
("1258406", "Rapar", "", "IN", "356", "09", "", "", "", "23.57267", "70.64718", "Asia/Kolkata"),
("1258449", "Ranipur", "", "IN", "356", "36", "", "", "", "25.25102", "79.06231", "Asia/Kolkata"),
("1258455", "Ranikhet", "", "IN", "356", "39", "", "", "", "29.64232", "79.4334", "Asia/Kolkata"),
("1258470", "Raniganj", "Ранигандже", "IN", "356", "28", "", "", "", "23.6164", "87.13061", "Asia/Kolkata"),
("1258474", "Ranibennur", "", "IN", "356", "19", "", "", "", "14.6224", "75.62951", "Asia/Kolkata"),
("1258477", "Rania", "Рания", "IN", "356", "10", "", "", "", "29.52454", "74.83689", "Asia/Kolkata"),
("1258492", "Rangia", "", "IN", "356", "03", "", "", "", "26.44931", "91.61356", "Asia/Kolkata"),
("1258501", "Rangapara", "", "IN", "356", "03", "", "", "", "26.83772", "92.66876", "Asia/Kolkata"),
("1258526", "Ranchi", "Ранчи", "IN", "356", "38", "", "", "", "23.34777", "85.33856", "Asia/Kolkata"),
("1258534", "Ranavav", "", "IN", "356", "09", "", "", "", "21.68734", "69.74485", "Asia/Kolkata"),
("1258546", "Ranaghat", "", "IN", "356", "28", "", "", "", "23.17623", "88.56666", "Asia/Kolkata"),
("1258553", "Ramtek", "Рамтек", "IN", "356", "16", "", "", "", "21.39551", "79.32702", "Asia/Kolkata"),
("1258581", "Rampur Hat", "", "IN", "356", "28", "", "", "", "24.17737", "87.78275", "Asia/Kolkata"),
("1258584", "Rampura", "", "IN", "356", "23", "", "", "", "30.25506", "75.24064", "Asia/Kolkata"),
("1258592", "Rampura", "", "IN", "356", "35", "", "", "", "24.467", "75.43996", "Asia/Kolkata"),
("1258598", "Rampur", "", "IN", "356", "36", "", "", "", "29.8058", "77.45146", "Asia/Kolkata"),
("1258599", "Rampur", "", "IN", "356", "36", "", "", "", "28.80904", "79.02896", "Asia/Kolkata"),
("1258637", "Ramnagar", "", "IN", "356", "39", "", "", "", "29.39484", "79.12693", "Asia/Kolkata"),
("1258639", "Ramnagar", "", "IN", "356", "34", "", "", "", "27.16576", "84.32308", "Asia/Kolkata"),
("1258642", "Ramnagar", "", "IN", "356", "36", "", "", "", "25.26873", "83.02934", "Asia/Kolkata"),
("1258658", "Ramjibanpur", "", "IN", "356", "28", "", "", "", "22.82815", "87.60888", "Asia/Kolkata"),
("1258662", "Ramgundam", "", "IN", "356", "02", "", "", "", "18.80084", "79.45206", "Asia/Kolkata"),
("1258677", "Ramgarh", "", "IN", "356", "24", "", "", "", "27.25097", "75.17893", "Asia/Kolkata"),
("1258686", "Ramgarh", "", "IN", "356", "38", "", "", "", "23.63018", "85.51926", "Asia/Kolkata"),
("1258692", "Ramganj Mandi", "", "IN", "356", "24", "", "", "", "24.64648", "75.94325", "Asia/Kolkata"),
("1258698", "Rameswaram", "Рамешварам", "IN", "356", "25", "", "", "", "9.2885", "79.31271", "Asia/Kolkata"),
("1258726", "Ramapuram", "", "IN", "356", "02", "", "", "", "13.10089", "79.18417", "Asia/Kolkata"),
("1258740", "Ramanathapuram", "Раманатхапурама", "IN", "356", "25", "", "", "", "9.37158", "78.83077", "Asia/Kolkata"),
("1258744", "Ramanagaram", "Раманагарам", "IN", "356", "19", "", "", "", "12.72031", "77.28176", "Asia/Kolkata"),
("1258756", "Ramachandrapuram", "", "IN", "356", "02", "", "", "", "16.83636", "82.02871", "Asia/Kolkata"),
("1258786", "Rajura", "", "IN", "356", "16", "", "", "", "19.77921", "79.36266", "Asia/Kolkata"),
("1258795", "Rajula", "", "IN", "356", "09", "", "", "", "21.03854", "71.44345", "Asia/Kolkata"),
("1258797", "Rajsamand", "", "IN", "356", "24", "", "", "", "25.07145", "73.8798", "Asia/Kolkata"),
("1258803", "Rajpura", "", "IN", "356", "23", "", "", "", "30.47276", "76.58671", "Asia/Kolkata"),
("1258815", "Rajpur", "", "IN", "356", "35", "", "", "", "22.30428", "74.35511", "Asia/Kolkata"),
("1258816", "Rajpur", "", "IN", "356", "35", "", "", "", "21.93954", "75.13612", "Asia/Kolkata"),
("1258819", "Rajpipla", "", "IN", "356", "09", "", "", "", "21.86667", "73.5", "Asia/Kolkata"),
("1258831", "Raj Nandgaon", "", "IN", "356", "37", "", "", "", "21.1", "81.03333", "Asia/Kolkata"),
("1258843", "Rajmahal", "", "IN", "356", "28", "", "", "", "25.05303", "87.83048", "Asia/Kolkata"),
("1258847", "Rajkot", "Раджкот", "IN", "356", "09", "", "", "", "22.29161", "70.79322", "Asia/Kolkata"),
("1258859", "Rajgurunagar", "", "IN", "356", "16", "", "", "", "18.86667", "73.9", "Asia/Kolkata"),
("1258864", "Rajgir", "Раджгир", "IN", "356", "34", "", "", "", "25.0277", "85.42133", "Asia/Kolkata"),
("1258868", "Rajgarh", "", "IN", "356", "24", "", "", "", "28.64201", "75.38612", "Asia/Kolkata"),
("1258869", "Rajgarh", "", "IN", "356", "24", "", "", "", "27.23731", "76.62243", "Asia/Kolkata"),
("1258875", "Rajgarh", "", "IN", "356", "35", "", "", "", "24.00826", "76.7325", "Asia/Kolkata"),
("1258876", "Rajgarh", "", "IN", "356", "35", "", "", "", "22.67756", "74.94481", "Asia/Kolkata"),
("1258891", "Rajauri", "", "IN", "356", "12", "", "", "", "33.37541", "74.30838", "Asia/Kolkata"),
("1258916", "Rajapalaiyam", "", "IN", "356", "25", "", "", "", "9.45296", "77.55335", "Asia/Kolkata"),
("1258922", "Rajampet", "", "IN", "356", "02", "", "", "", "14.19508", "79.15914", "Asia/Kolkata"),
("1258928", "Rajaldesar", "", "IN", "356", "24", "", "", "", "28.02822", "74.47304", "Asia/Kolkata"),
("1258930", "Rajakhera", "", "IN", "356", "24", "", "", "", "26.89802", "78.171", "Asia/Kolkata"),
("1258932", "Rajahmundry", "Раджамандри", "IN", "356", "02", "", "", "", "17.00517", "81.77784", "Asia/Kolkata"),
("1258950", "Raisinghnagar", "", "IN", "356", "24", "", "", "", "29.53583", "73.44917", "Asia/Kolkata"),
("1258952", "Raisen", "", "IN", "356", "35", "", "", "", "23.33058", "77.78206", "Asia/Kolkata"),
("1258967", "Raipur", "", "IN", "356", "39", "", "", "", "30.31162", "78.0934", "Asia/Kolkata"),
("1258972", "Raipur", "", "IN", "356", "24", "", "", "", "26.04259", "74.02373", "Asia/Kolkata"),
("1258980", "Raipur", "", "IN", "356", "37", "", "", "", "21.23333", "81.63333", "Asia/Kolkata"),
("1258993", "Raikot", "", "IN", "356", "23", "", "", "", "30.65", "75.6", "Asia/Kolkata"),
("1259005", "Raigarh", "Райгарх", "IN", "356", "37", "", "", "", "21.9", "83.4", "Asia/Kolkata"),
("1259009", "Raiganj", "", "IN", "356", "28", "", "", "", "25.61281", "88.12449", "Asia/Kolkata"),
("1259012", "Raichur", "Райчур", "IN", "356", "19", "", "", "", "16.2047", "77.354", "Asia/Kolkata"),
("1259019", "Rahuri", "", "IN", "356", "16", "", "", "", "19.39069", "74.64979", "Asia/Kolkata"),
("1259026", "Rahimatpur", "", "IN", "356", "16", "", "", "", "17.5921", "74.19966", "Asia/Kolkata"),
("1259034", "Rahatgarh", "", "IN", "356", "35", "", "", "", "23.78816", "78.39411", "Asia/Kolkata"),
("1259049", "Raghunathpur", "", "IN", "356", "28", "", "", "", "23.53878", "86.6735", "Asia/Kolkata"),
("1259056", "Raghogarh", "", "IN", "356", "35", "", "", "", "24.44406", "77.19824", "Asia/Kolkata"),
("1259060", "Rafiganj", "", "IN", "356", "34", "", "", "", "24.81705", "84.63324", "Asia/Kolkata"),
("1259064", "Rae Bareli", "", "IN", "356", "36", "", "", "", "26.2191", "81.24499", "Asia/Kolkata"),
("1259069", "Radhanpur", "", "IN", "356", "09", "", "", "", "23.83238", "71.6047", "Asia/Kolkata"),
("1259083", "Rabkavi", "", "IN", "356", "19", "", "", "", "16.47567", "75.1106", "Asia/Kolkata"),
("1259091", "Kollam", "Квилон", "IN", "356", "13", "7909821", "", "", "8.88113", "76.58469", "Asia/Kolkata"),
("1259108", "Kasba", "", "IN", "356", "34", "", "", "", "25.85643", "87.53836", "Asia/Kolkata"),
("1259110", "Qadian", "", "IN", "356", "23", "", "", "", "31.82198", "75.37663", "Asia/Kolkata"),
("1259123", "Puttur", "", "IN", "356", "02", "", "", "", "13.44189", "79.55314", "Asia/Kolkata"),
("1259124", "Puttur", "", "IN", "356", "19", "", "", "", "12.75975", "75.20169", "Asia/Kolkata"),
("1259148", "Pushkar", "", "IN", "356", "24", "", "", "", "26.49061", "74.55419", "Asia/Kolkata"),
("1259154", "Pusad", "", "IN", "356", "16", "", "", "", "19.9089", "77.56825", "Asia/Kolkata"),
("1259157", "Purwa", "", "IN", "356", "36", "", "", "", "26.45811", "80.77416", "Asia/Kolkata"),
("1259163", "Puruliya", "", "IN", "356", "28", "", "", "", "23.33062", "86.36303", "Asia/Kolkata"),
("1259166", "Purnia", "Пурния", "IN", "356", "34", "", "", "", "25.77895", "87.47422", "Asia/Kolkata"),
("1259177", "Purna", "Пурна", "IN", "356", "16", "", "", "", "19.1798", "77.02595", "Asia/Kolkata"),
("1259184", "Puri", "Пури", "IN", "356", "21", "", "", "", "19.79825", "85.82494", "Asia/Kolkata"),
("1259190", "Puranpur", "", "IN", "356", "36", "", "", "", "28.51283", "80.14829", "Asia/Kolkata"),
("1259210", "Pupri", "", "IN", "356", "34", "", "", "", "26.47079", "85.70311", "Asia/Kolkata"),
("1259222", "Punjai Puliyampatti", "", "IN", "356", "25", "", "", "", "11.35163", "77.16671", "Asia/Kolkata"),
("1259228", "Punganuru", "", "IN", "356", "02", "", "", "", "13.36488", "78.57141", "Asia/Kolkata"),
("1259229", "Pune", "Пуна", "IN", "356", "16", "8131502", "", "", "18.51957", "73.85535", "Asia/Kolkata"),
("1259231", "Pundri", "", "IN", "356", "10", "", "", "", "29.76142", "76.55849", "Asia/Kolkata"),
("1259239", "Punasa", "", "IN", "356", "35", "", "", "", "22.23544", "76.39295", "Asia/Kolkata"),
("1259243", "Punalur", "", "IN", "356", "13", "", "", "", "9.02165", "76.93265", "Asia/Kolkata"),
("1259244", "Punahana", "", "IN", "356", "10", "", "", "", "27.86348", "77.20434", "Asia/Kolkata"),
("1259251", "Pulwama", "", "IN", "356", "12", "", "", "", "33.87405", "74.89955", "Asia/Kolkata"),
("1259263", "Puliyangudi", "", "IN", "356", "25", "", "", "", "9.17489", "77.39799", "Asia/Kolkata"),
("1259264", "Pulivendla", "", "IN", "356", "02", "", "", "", "14.42166", "78.22573", "Asia/Kolkata"),
("1259272", "Pulgaon", "", "IN", "356", "16", "", "", "", "20.72081", "78.32086", "Asia/Kolkata"),
("1259283", "Pukhrayan", "", "IN", "356", "36", "", "", "", "26.22287", "79.83718", "Asia/Kolkata"),
("1259297", "Pudukkottai", "Пудуккоттай", "IN", "356", "25", "", "", "", "10.38128", "78.82141", "Asia/Kolkata"),
("1259312", "Proddatur", "", "IN", "356", "02", "", "", "", "14.7502", "78.54813", "Asia/Kolkata"),
("1259338", "Pratapgarh", "", "IN", "356", "24", "", "", "", "24.03215", "74.78162", "Asia/Kolkata"),
("1259385", "Port Blair", "Порт-Блэр", "IN", "356", "01", "", "", "", "11.66667", "92.75", "Asia/Kolkata"),
("1259388", "Porsa", "Порса", "IN", "356", "35", "", "", "", "26.67324", "78.37085", "Asia/Kolkata"),
("1259395", "Porbandar", "Порбандаром", "IN", "356", "09", "", "", "", "21.64219", "69.60929", "Asia/Kolkata"),
("1259400", "Poonamalle", "", "IN", "356", "25", "", "", "", "13.04888", "80.11488", "Asia/Kolkata"),
("1259408", "Ponnuru", "", "IN", "356", "02", "", "", "", "16.06547", "80.55203", "Asia/Kolkata"),
("1259409", "Ponneri", "", "IN", "356", "25", "", "", "", "13.33868", "80.19487", "Asia/Kolkata"),
("1259411", "Ponnani", "", "IN", "356", "13", "", "", "", "10.76695", "75.92523", "Asia/Kolkata"),
("1259425", "Puducherry", "Пондишери", "IN", "356", "22", "", "", "", "11.93381", "79.82979", "Asia/Kolkata"),
("1259429", "Ponda", "", "IN", "356", "33", "", "", "", "15.40341", "74.01519", "Asia/Kolkata"),
("1259434", "Polur", "", "IN", "356", "25", "", "", "", "12.51217", "79.12405", "Asia/Kolkata"),
("1259440", "Pollachi", "", "IN", "356", "25", "", "", "", "10.65825", "77.0085", "Asia/Kolkata"),
("1259444", "Polavaram", "", "IN", "356", "02", "", "", "", "17.25", "81.63333", "Asia/Kolkata"),
("1259446", "Polasara", "", "IN", "356", "21", "", "", "", "19.69386", "84.81401", "Asia/Kolkata"),
("1259460", "Pokaran", "", "IN", "356", "24", "", "", "", "26.92007", "71.91631", "Asia/Kolkata"),
("1259503", "Pithoragarh", "", "IN", "356", "39", "", "", "", "29.58349", "80.20947", "Asia/Kolkata"),
("1259508", "Pithapuram", "", "IN", "356", "02", "", "", "", "17.1168", "82.25284", "Asia/Kolkata"),
("1259530", "Piro", "", "IN", "356", "34", "", "", "", "25.32989", "84.40803", "Asia/Kolkata"),
("1259535", "Piriyapatna", "", "IN", "356", "19", "", "", "", "12.33573", "76.10003", "Asia/Kolkata"),
("1259541", "Piravam", "", "IN", "356", "13", "", "", "", "9.86667", "76.5", "Asia/Kolkata"),
("1259552", "Pipri", "", "IN", "356", "16", "", "", "", "19.79372", "75.53519", "Asia/Kolkata"),
("1259554", "Pipraich", "", "IN", "356", "36", "", "", "", "26.82799", "83.52689", "Asia/Kolkata"),
("1259592", "Pipili", "", "IN", "356", "21", "", "", "", "20.11357", "85.83147", "Asia/Kolkata"),
("1259608", "Pipar", "", "IN", "356", "24", "", "", "", "26.38441", "73.54394", "Asia/Kolkata"),
("1259630", "Pinjaur", "", "IN", "356", "10", "", "", "", "30.7974", "76.91888", "Asia/Kolkata"),
("1259638", "Pindwara", "", "IN", "356", "24", "", "", "", "24.79749", "73.05505", "Asia/Kolkata"),
("1259647", "Pinahat", "", "IN", "356", "36", "", "", "", "26.88513", "78.37496", "Asia/Kolkata"),
("1259652", "Pimpri", "", "IN", "356", "16", "", "", "", "18.62292", "73.80696", "Asia/Kolkata"),
("1259680", "Pilkhua", "", "IN", "356", "36", "", "", "", "28.71348", "77.65539", "Asia/Kolkata"),
("1259686", "Pilibhit", "Пилибхит", "IN", "356", "36", "", "", "", "28.63098", "79.80338", "Asia/Kolkata"),
("1259688", "Pilibangan", "", "IN", "356", "24", "", "", "", "29.44964", "74.10093", "Asia/Kolkata"),
("1259693", "Pilani", "", "IN", "356", "24", "", "", "", "28.3654", "75.60296", "Asia/Kolkata"),
("1259701", "Pihani", "", "IN", "356", "36", "", "", "", "27.62332", "80.19986", "Asia/Kolkata"),
("1259735", "Phulpur", "", "IN", "356", "36", "", "", "", "25.54842", "82.08978", "Asia/Kolkata"),
("1259744", "Phulera", "", "IN", "356", "24", "", "", "", "26.87401", "75.24171", "Asia/Kolkata"),
("1259756", "Phulabani", "", "IN", "356", "21", "", "", "", "20.47916", "84.23162", "Asia/Kolkata"),
("1259773", "Phirangipuram", "", "IN", "356", "02", "", "", "", "16.29078", "80.26234", "Asia/Kolkata"),
("1259775", "Phillaur", "", "IN", "356", "23", "", "", "", "31.02071", "75.78766", "Asia/Kolkata"),
("1259784", "Phek", "", "IN", "356", "17", "", "", "", "25.66667", "94.5", "Asia/Kolkata"),
("1259801", "Phaphund", "", "IN", "356", "36", "", "", "", "26.59941", "79.46392", "Asia/Kolkata"),
("1259811", "Phaltan", "", "IN", "356", "16", "", "", "", "17.99113", "74.43177", "Asia/Kolkata"),
("1259813", "Phalodi", "", "IN", "356", "24", "", "", "", "27.13102", "72.36826", "Asia/Kolkata"),
("1259818", "Phalauda", "", "IN", "356", "36", "", "", "", "29.18766", "77.82893", "Asia/Kolkata"),
("1259827", "Phagwara", "", "IN", "356", "23", "", "", "", "31.2185", "75.77166", "Asia/Kolkata"),
("1259841", "Petlad", "", "IN", "356", "09", "", "", "", "22.47681", "72.79995", "Asia/Kolkata"),
("1259855", "Perundurai", "", "IN", "356", "25", "", "", "", "11.27564", "77.58794", "Asia/Kolkata"),
("1259857", "Perumpavur", "", "IN", "356", "13", "", "", "", "10.11136", "76.47478", "Asia/Kolkata"),
("1259878", "Periyanayakkanpalaiyam", "", "IN", "356", "25", "", "", "", "11.15255", "76.95159", "Asia/Kolkata"),
("1259879", "Periyakulam", "", "IN", "356", "25", "", "", "", "10.12127", "77.54392", "Asia/Kolkata"),
("1259890", "Peravurani", "", "IN", "356", "25", "", "", "", "10.29035", "79.20156", "Asia/Kolkata"),
("1259892", "Peranampattu", "", "IN", "356", "25", "", "", "", "12.9343", "78.7189", "Asia/Kolkata"),
("1259896", "Perambalur", "", "IN", "356", "25", "", "", "", "11.23333", "78.88333", "Asia/Kolkata"),
("1259905", "Penukonda", "", "IN", "356", "02", "", "", "", "14.08339", "77.59588", "Asia/Kolkata"),
("1259907", "Penugonda", "", "IN", "356", "02", "", "", "", "16.65363", "81.7455", "Asia/Kolkata"),
("1259916", "Pennagaram", "", "IN", "356", "25", "", "", "", "12.1345", "77.89514", "Asia/Kolkata"),
("1259917", "Pennadam", "", "IN", "356", "25", "", "", "", "11.40316", "79.24103", "Asia/Kolkata"),
("1259931", "Pen", "", "IN", "356", "16", "", "", "", "18.73734", "73.09603", "Asia/Kolkata"),
("1259939", "Pehowa", "", "IN", "356", "10", "", "", "", "29.98178", "76.58305", "Asia/Kolkata"),
("1259954", "Peddapuram", "", "IN", "356", "02", "", "", "", "17.07575", "82.13905", "Asia/Kolkata"),
("1259961", "Peddapalli", "", "IN", "356", "02", "", "", "", "18.61357", "79.37442", "Asia/Kolkata"),
("1259986", "Pedana", "", "IN", "356", "02", "", "", "", "16.25582", "81.14378", "Asia/Kolkata"),
("1259994", "Payyannur", "", "IN", "356", "13", "", "", "", "12.0935", "75.20249", "Asia/Kolkata"),
("1260003", "Pawayan", "", "IN", "356", "36", "", "", "", "28.06626", "80.10305", "Asia/Kolkata"),
("1260014", "Pavagada", "", "IN", "356", "19", "", "", "", "14.10009", "77.28151", "Asia/Kolkata"),
("1260016", "Pauri", "", "IN", "356", "39", "", "", "", "30.15356", "78.76998", "Asia/Kolkata"),
("1260022", "Pauni", "", "IN", "356", "16", "", "", "", "20.79205", "79.63583", "Asia/Kolkata"),
("1260035", "Patur", "", "IN", "356", "16", "", "", "", "20.46093", "76.93724", "Asia/Kolkata"),
("1260040", "Pattukkottai", "", "IN", "356", "25", "", "", "", "10.42358", "79.31949", "Asia/Kolkata"),
("1260045", "Patti", "", "IN", "356", "23", "", "", "", "31.28083", "74.85722", "Asia/Kolkata"),
("1260082", "Patnagarh", "", "IN", "356", "21", "", "", "", "20.70833", "83.13263", "Asia/Kolkata"),
("1260086", "Patna", "Патна", "IN", "356", "34", "", "", "", "25.60222", "85.11936", "Asia/Kolkata"),
("1260107", "Patiala", "Патьяла", "IN", "356", "23", "", "", "", "30.32715", "76.40266", "Asia/Kolkata"),
("1260120", "Pathri", "Патри", "IN", "356", "16", "", "", "", "19.25946", "76.43354", "Asia/Kolkata"),
("1260129", "Patharia", "", "IN", "356", "35", "", "", "", "23.89824", "79.19392", "Asia/Kolkata"),
("1260134", "Pathardih", "", "IN", "356", "38", "", "", "", "23.6658", "86.43166", "Asia/Kolkata"),
("1260135", "Pathardi", "", "IN", "356", "16", "", "", "", "19.17279", "75.17425", "Asia/Kolkata"),
("1260137", "Pathankot", "Патханкот", "IN", "356", "23", "", "", "", "32.27306", "75.65256", "Asia/Kolkata"),
("1260138", "Pathanamthitta", "", "IN", "356", "13", "", "", "", "9.26667", "76.78333", "Asia/Kolkata"),
("1260141", "Pathalgaon", "", "IN", "356", "37", "", "", "", "22.55656", "83.46355", "Asia/Kolkata"),
("1260156", "Pataudi", "", "IN", "356", "10", "", "", "", "28.32547", "76.77858", "Asia/Kolkata"),
("1260168", "Patancheru", "", "IN", "356", "02", "", "", "", "17.53334", "78.2645", "Asia/Kolkata"),
("1260173", "Patan", "Патан", "IN", "356", "09", "", "", "", "23.8507", "72.12963", "Asia/Kolkata"),
("1260178", "Patamundai", "", "IN", "356", "21", "", "", "", "20.57806", "86.56063", "Asia/Kolkata"),
("1260206", "Pasighat", "", "IN", "356", "30", "", "", "", "28.06631", "95.32678", "Asia/Kolkata"),
("1260210", "Pasan", "", "IN", "356", "37", "", "", "", "22.8436", "82.19919", "Asia/Kolkata"),
("1260221", "Parvatsar", "", "IN", "356", "24", "", "", "", "26.88604", "74.76602", "Asia/Kolkata"),
("1260222", "Parvatipuram", "", "IN", "356", "02", "", "", "", "18.78303", "83.42668", "Asia/Kolkata"),
("1260228", "Partur", "", "IN", "356", "16", "", "", "", "19.59943", "76.21491", "Asia/Kolkata"),
("1260274", "Parola", "", "IN", "356", "16", "", "", "", "20.88025", "75.11723", "Asia/Kolkata"),
("1260290", "Parli Vaijnath", "", "IN", "356", "16", "", "", "", "18.85018", "76.53211", "Asia/Kolkata"),
("1260296", "Parlakimidi", "", "IN", "356", "02", "", "", "", "18.78113", "84.08836", "Asia/Kolkata"),
("1260304", "Pariyapuram", "", "IN", "356", "13", "", "", "", "11.01667", "75.86667", "Asia/Kolkata"),
("1260313", "Parichhatgarh", "", "IN", "356", "36", "", "", "", "28.97809", "77.93306", "Asia/Kolkata"),
("1260335", "Pardi", "", "IN", "356", "09", "", "", "", "20.5087", "72.94569", "Asia/Kolkata"),
("1260341", "Parbhani", "", "IN", "356", "16", "", "", "", "19.26855", "76.77081", "Asia/Kolkata"),
("1260354", "Paravur", "", "IN", "356", "13", "", "", "", "8.78333", "76.7", "Asia/Kolkata"),
("1260368", "Parasia", "", "IN", "356", "35", "", "", "", "22.19137", "78.7579", "Asia/Kolkata"),
("1260387", "Paramagudi", "", "IN", "356", "25", "", "", "", "9.54633", "78.5907", "Asia/Kolkata"),
("1260393", "Paradip Garh", "", "IN", "356", "21", "", "", "", "20.31641", "86.6085", "Asia/Kolkata"),
("1260406", "Pappinisseri", "", "IN", "356", "13", "", "", "", "11.95", "75.35", "Asia/Kolkata"),
("1260417", "Papanasam", "", "IN", "356", "25", "", "", "", "10.92687", "79.27056", "Asia/Kolkata"),
("1260421", "Paonta Sahib", "", "IN", "356", "11", "", "", "", "30.43853", "77.62479", "Asia/Kolkata"),
("1260434", "Panvel", "", "IN", "356", "16", "", "", "", "18.98878", "73.11013", "Asia/Kolkata"),
("1260448", "Panruti", "", "IN", "356", "25", "", "", "", "11.77662", "79.55269", "Asia/Kolkata"),
("1260454", "Panna", "", "IN", "356", "35", "", "", "", "24.72147", "80.18808", "Asia/Kolkata"),
("1260456", "Panmana", "", "IN", "356", "13", "", "", "", "9.01667", "76.51667", "Asia/Kolkata"),
("1260476", "Panipat", "Панипата", "IN", "356", "10", "", "", "", "29.39005", "76.96949", "Asia/Kolkata"),
("1260482", "Panihati", "", "IN", "356", "28", "", "", "", "22.69089", "88.37404", "Asia/Kolkata"),
("1260527", "Pandua", "", "IN", "356", "28", "", "", "", "23.07492", "88.28637", "Asia/Kolkata"),
("1260543", "Pandhurna", "", "IN", "356", "35", "", "", "", "21.59302", "78.52888", "Asia/Kolkata"),
("1260546", "Pandharpur", "Пандхарпур", "IN", "356", "16", "", "", "", "17.67924", "75.33098", "Asia/Kolkata"),
("1260553", "Pandavapura", "", "IN", "356", "19", "", "", "", "12.50083", "76.67452", "Asia/Kolkata"),
("1260607", "Panaji", "Панаджи", "IN", "356", "33", "", "", "", "15.49574", "73.82624", "Asia/Kolkata"),
("1260612", "Panagar", "", "IN", "356", "35", "", "", "", "23.28552", "79.99465", "Asia/Kolkata"),
("1260637", "Palwal", "", "IN", "356", "10", "", "", "", "28.14327", "77.32698", "Asia/Kolkata"),
("1260667", "Paloncha", "", "IN", "356", "02", "", "", "", "17.60184", "80.70509", "Asia/Kolkata"),
("1260671", "Palani", "Палани", "IN", "356", "25", "", "", "", "10.45034", "77.5209", "Asia/Kolkata"),
("1260674", "Palmaner", "", "IN", "356", "02", "", "", "", "13.20074", "78.74681", "Asia/Kolkata"),
("1260681", "Pallippatti", "", "IN", "356", "25", "", "", "", "11.93956", "78.40152", "Asia/Kolkata"),
("1260685", "Pallikondai", "", "IN", "356", "25", "", "", "", "12.90816", "78.94195", "Asia/Kolkata"),
("1260692", "Pallavaram", "", "IN", "356", "25", "", "", "", "12.96796", "80.15025", "Asia/Kolkata"),
("1260694", "Pallappatti", "", "IN", "356", "25", "", "", "", "10.72057", "77.87951", "Asia/Kolkata"),
("1260697", "Palladam", "", "IN", "356", "25", "", "", "", "10.99175", "77.28633", "Asia/Kolkata"),
("1260702", "Palkonda", "", "IN", "356", "02", "", "", "", "18.60354", "83.75504", "Asia/Kolkata"),
("1260707", "Palitana", "Палитана", "IN", "356", "09", "", "", "", "21.52519", "71.82308", "Asia/Kolkata"),
("1260713", "Palia Kalan", "", "IN", "356", "36", "", "", "", "28.43205", "80.58137", "Asia/Kolkata"),
("1260716", "Pali", "Пали", "IN", "356", "24", "", "", "", "25.77276", "73.32335", "Asia/Kolkata"),
("1260718", "Pali", "Пали", "IN", "356", "35", "", "", "", "23.36453", "81.04374", "Asia/Kolkata"),
("1260728", "Palakkad", "Палаккад", "IN", "356", "13", "", "", "", "10.7744", "76.65625", "Asia/Kolkata"),
("1260730", "Palghar", "", "IN", "356", "16", "", "", "", "19.69693", "72.76543", "Asia/Kolkata"),
("1260734", "Palera", "", "IN", "356", "35", "", "", "", "25.02023", "79.2318", "Asia/Kolkata"),
("1260771", "Palasa", "", "IN", "356", "02", "", "", "", "18.77257", "84.41012", "Asia/Kolkata"),
("1260777", "Palanpur", "", "IN", "356", "09", "", "", "", "24.17097", "72.43821", "Asia/Kolkata"),
("1260792", "Palakollu", "", "IN", "356", "02", "", "", "", "16.5167", "81.73", "Asia/Kolkata"),
("1260793", "Palakkodu", "", "IN", "356", "25", "", "", "", "12.30696", "78.07022", "Asia/Kolkata"),
("1260824", "Pakaur", "", "IN", "356", "28", "", "", "", "24.63846", "87.83893", "Asia/Kolkata"),
("1260830", "Pakala", "", "IN", "356", "02", "", "", "", "13.44917", "79.11749", "Asia/Kolkata"),
("1260833", "Paithan", "", "IN", "356", "16", "", "", "", "19.47506", "75.38558", "Asia/Kolkata"),
("1260868", "Pahasu", "", "IN", "356", "36", "", "", "", "28.17222", "78.06358", "Asia/Kolkata"),
("1260909", "Padrauna", "", "IN", "356", "36", "", "", "", "26.90424", "83.98104", "Asia/Kolkata"),
("1260911", "Padra", "", "IN", "356", "09", "", "", "", "22.2398", "73.08451", "Asia/Kolkata"),
("1260918", "Padmanabhapuram", "", "IN", "356", "25", "", "", "", "8.24462", "77.32581", "Asia/Kolkata"),
("1260938", "Padampur", "", "IN", "356", "24", "", "", "", "29.70885", "73.62539", "Asia/Kolkata"),
("1260940", "Padampur", "", "IN", "356", "21", "", "", "", "20.98333", "83.06667", "Asia/Kolkata"),
("1260942", "Padam", "", "IN", "356", "12", "", "", "", "33.46658", "76.88488", "Asia/Kolkata"),
("1260954", "Pachperwa", "", "IN", "356", "36", "", "", "", "27.51234", "82.64297", "Asia/Kolkata"),
("1260959", "Pachora", "", "IN", "356", "16", "", "", "", "20.66714", "75.35183", "Asia/Kolkata"),
("1261008", "Ottappalam", "", "IN", "356", "13", "", "", "", "10.77094", "76.37844", "Asia/Kolkata"),
("1261012", "Osmanabad", "Османабад", "IN", "356", "16", "Marathwada (undefined)", "1261013", "", "18.18158", "76.0389", "Asia/Kolkata"),
("1261039", "Orai", "", "IN", "356", "36", "", "", "", "25.99074", "79.45315", "Asia/Kolkata"),
("1261045", "Ongole", "Онголе", "IN", "356", "02", "", "", "", "15.50642", "80.04867", "Asia/Kolkata"),
("1261066", "Okha", "Оха", "IN", "356", "09", "", "", "", "22.46756", "69.07002", "Asia/Kolkata"),
("1261068", "Ozar", "", "IN", "356", "16", "8131501", "", "", "20.09473", "73.92816", "Asia/Kolkata"),
("1261086", "Obra", "", "IN", "356", "36", "", "", "", "24.41656", "82.9859", "Asia/Kolkata"),
("1261110", "Nuzvid", "", "IN", "356", "02", "", "", "", "16.78806", "80.84646", "Asia/Kolkata"),
("1261122", "Nurpur", "", "IN", "356", "36", "", "", "", "29.14984", "78.40917", "Asia/Kolkata"),
("1261162", "Nowrangapur", "", "IN", "356", "21", "8908677", "", "", "19.23114", "82.54826", "Asia/Kolkata"),
("1261181", "North Lakhimpur", "", "IN", "356", "03", "", "", "", "27.23517", "94.10357", "Asia/Kolkata"),
("1261186", "North Guwahati", "", "IN", "356", "03", "", "", "", "26.1975", "91.7202", "Asia/Kolkata"),
("1261205", "Nongstoin", "", "IN", "356", "18", "7701511", "", "", "25.51704", "91.26484", "Asia/Kolkata"),
("1261227", "Nokha", "", "IN", "356", "24", "", "", "", "27.56155", "73.47141", "Asia/Kolkata"),
("1261234", "Nohar", "", "IN", "356", "24", "", "", "", "29.18351", "74.77045", "Asia/Kolkata"),
("1261242", "Noamundi", "", "IN", "356", "38", "", "", "", "22.16094", "85.50416", "Asia/Kolkata"),
("1261258", "Nizamabad", "", "IN", "356", "02", "", "", "", "18.67154", "78.0988", "Asia/Kolkata"),
("1261285", "Nirmali", "", "IN", "356", "34", "", "", "", "26.31397", "86.58537", "Asia/Kolkata"),
("1261288", "Nirmal", "Нирмала", "IN", "356", "02", "", "", "", "19.09685", "78.34406", "Asia/Kolkata"),
("1261309", "Nipani", "", "IN", "356", "16", "", "", "", "16.399", "74.38285", "Asia/Kolkata"),
("1261342", "Neem ka Thana", "", "IN", "356", "24", "", "", "", "27.73976", "75.78652", "Asia/Kolkata"),
("1261369", "Nimbahera", "", "IN", "356", "24", "", "", "", "24.62166", "74.67999", "Asia/Kolkata"),
("1261375", "Nimaparha", "", "IN", "356", "21", "", "", "", "20.05756", "86.00436", "Asia/Kolkata"),
("1261378", "Nimbaj", "", "IN", "356", "24", "", "", "", "26.15006", "74.00152", "Asia/Kolkata"),
("1261382", "Nilokheri", "", "IN", "356", "10", "", "", "", "29.83671", "76.9319", "Asia/Kolkata"),
("1261394", "Nileshwar", "", "IN", "356", "13", "", "", "", "12.2649", "75.13914", "Asia/Kolkata"),
("1261396", "Nilanga", "", "IN", "356", "16", "", "", "", "18.11675", "76.75279", "Asia/Kolkata"),
("1261401", "Nilakottai", "", "IN", "356", "25", "", "", "", "10.165", "77.85024", "Asia/Kolkata"),
("1261402", "Nilgiri", "", "IN", "356", "21", "", "", "", "21.46236", "86.76794", "Asia/Kolkata"),
("1261415", "Nihtaur", "", "IN", "356", "36", "", "", "", "29.32396", "78.38673", "Asia/Kolkata"),
("1261446", "Nidadavole", "", "IN", "356", "02", "", "", "", "16.9027", "81.67451", "Asia/Kolkata"),
("1261451", "Nichlaul", "", "IN", "356", "36", "", "", "", "27.31247", "83.7253", "Asia/Kolkata"),
("1261470", "Neyyattinkara", "", "IN", "356", "13", "", "", "", "8.39854", "77.08586", "Asia/Kolkata"),
("1261481", "New Delhi", "Нью-Дели", "IN", "356", "07", "", "", "", "28.63576", "77.22445", "Asia/Kolkata"),
("1261512", "Neral", "", "IN", "356", "16", "", "", "", "19.02475", "73.31688", "Asia/Kolkata"),
("1261517", "Nepa Nagar", "", "IN", "356", "35", "", "", "", "21.45525", "76.3934", "Asia/Kolkata"),
("1261529", "Nellore", "Неллор", "IN", "356", "02", "", "", "", "14.45363", "79.98674", "Asia/Kolkata"),
("1261532", "Nellikkuppam", "", "IN", "356", "25", "", "", "", "11.77577", "79.66789", "Asia/Kolkata"),
("1261539", "Nelamangala", "", "IN", "356", "19", "", "", "", "13.09795", "77.39575", "Asia/Kolkata"),
("1261553", "Nedumangad", "", "IN", "356", "13", "", "", "", "8.60267", "77.00139", "Asia/Kolkata"),
("1261567", "Nayudupeta", "", "IN", "356", "02", "", "", "", "13.90777", "79.89649", "Asia/Kolkata"),
("1261580", "Nayagarh", "", "IN", "356", "21", "", "", "", "20.12856", "85.09563", "Asia/Kolkata"),
("1261598", "Nawashahr", "", "IN", "356", "23", "", "", "", "31.12612", "76.11633", "Asia/Kolkata"),
("1261613", "Nawalgarh", "", "IN", "356", "24", "", "", "", "27.85161", "75.27384", "Asia/Kolkata"),
("1261614", "Niwai", "", "IN", "356", "24", "", "", "", "26.36073", "75.91836", "Asia/Kolkata"),
("1261631", "Nawada", "", "IN", "356", "34", "", "", "", "24.8867", "85.54364", "Asia/Kolkata"),
("1261639", "Nawabganj", "", "IN", "356", "36", "", "", "", "28.53966", "79.63282", "Asia/Kolkata"),
("1261641", "Nawabganj", "", "IN", "356", "36", "", "", "", "26.93109", "81.19934", "Asia/Kolkata"),
("1261642", "Nawabganj", "", "IN", "356", "36", "", "", "", "26.86452", "82.14016", "Asia/Kolkata"),
("1261647", "Nawa", "", "IN", "356", "24", "", "", "", "27.0195", "75.00226", "Asia/Kolkata"),
("1261667", "Navalgund", "", "IN", "356", "19", "", "", "", "15.55877", "75.35305", "Asia/Kolkata"),
("1261669", "Navadwip", "Навадвип", "IN", "356", "28", "", "", "", "23.4067", "88.3686", "Asia/Kolkata"),
("1261672", "Nautanwa", "", "IN", "356", "36", "", "", "", "27.42752", "83.41789", "Asia/Kolkata"),
("1261696", "Naugachhia", "", "IN", "356", "34", "", "", "", "25.38706", "87.09856", "Asia/Kolkata"),
("1261705", "Nattam", "", "IN", "356", "25", "", "", "", "10.22776", "78.22969", "Asia/Kolkata"),
("1261711", "Nathdwara", "", "IN", "356", "24", "", "", "", "24.93805", "73.82392", "Asia/Kolkata"),
("1261721", "Nasrullahganj", "", "IN", "356", "35", "", "", "", "22.68411", "77.26887", "Asia/Kolkata"),
("1261722", "Nasriganj", "", "IN", "356", "34", "", "", "", "25.0503", "84.32762", "Asia/Kolkata"),
("1261726", "Naspur", "", "IN", "356", "02", "", "", "", "18.84577", "79.46165", "Asia/Kolkata"),
("1261727", "Nasirabad", "", "IN", "356", "24", "", "", "", "26.30473", "74.73364", "Asia/Kolkata"),
("1261731", "Nashik", "Насик", "IN", "356", "16", "8131501", "", "", "19.99727", "73.79096", "Asia/Kolkata"),
("1261736", "Narwar", "", "IN", "356", "35", "", "", "", "25.6439", "77.9129", "Asia/Kolkata"),
("1261739", "Narwana", "", "IN", "356", "10", "", "", "", "29.59489", "76.11816", "Asia/Kolkata"),
("1261748", "Narsipatnam", "", "IN", "356", "02", "", "", "", "17.66727", "82.61044", "Asia/Kolkata"),
("1261752", "Narsinghgarh", "", "IN", "356", "35", "", "", "", "23.70758", "77.09318", "Asia/Kolkata"),
("1261754", "Narsimhapur", "", "IN", "356", "35", "", "", "", "22.95078", "79.184", "Asia/Kolkata"),
("1261771", "Narnaund", "", "IN", "356", "10", "", "", "", "29.22123", "76.14171", "Asia/Kolkata"),
("1261772", "Narnaul", "", "IN", "356", "10", "", "", "", "28.04444", "76.10833", "Asia/Kolkata"),
("1261800", "Nargund", "", "IN", "356", "19", "", "", "", "15.72299", "75.38666", "Asia/Kolkata"),
("1261810", "Naregal", "", "IN", "356", "19", "", "", "", "15.57316", "75.80804", "Asia/Kolkata"),
("1261823", "Narayanpet", "", "IN", "356", "02", "", "", "", "16.74799", "77.4954", "Asia/Kolkata"),
("1261828", "Narayangarh", "", "IN", "356", "10", "", "", "", "30.47696", "77.12653", "Asia/Kolkata"),
("1261835", "Naravarikuppam", "", "IN", "356", "25", "", "", "", "13.19133", "80.18473", "Asia/Kolkata"),
("1261837", "Naraura", "", "IN", "356", "36", "", "", "", "28.19994", "78.38472", "Asia/Kolkata"),
("1261839", "Narauli", "", "IN", "356", "36", "", "", "", "28.48451", "78.71291", "Asia/Kolkata"),
("1261848", "Narasaraopet", "", "IN", "356", "02", "", "", "", "16.2347", "80.04711", "Asia/Kolkata"),
("1261852", "Narasapur", "", "IN", "356", "02", "", "", "", "16.4361", "81.70159", "Asia/Kolkata"),
("1261853", "Narasannapeta", "", "IN", "356", "02", "", "", "", "18.41428", "84.04463", "Asia/Kolkata"),
("1261871", "Naraini", "", "IN", "356", "35", "", "", "", "25.19032", "80.475", "Asia/Kolkata"),
("1261872", "Naraina", "", "IN", "356", "24", "", "", "", "26.79069", "75.20608", "Asia/Kolkata"),
("1261882", "Napasar", "", "IN", "356", "24", "", "", "", "27.96059", "73.55913", "Asia/Kolkata"),
("1261901", "Nanpara", "", "IN", "356", "36", "", "", "", "27.86459", "81.50036", "Asia/Kolkata"),
("1261910", "Nanjangud", "", "IN", "356", "19", "", "", "", "12.11802", "76.68411", "Asia/Kolkata"),
("1261913", "Nangloi Jat", "", "IN", "356", "07", "", "", "", "28.6786", "77.06749", "Asia/Kolkata"),
("1261922", "Nangal Township", "Нангал", "IN", "356", "23", "", "", "", "31.38966", "76.37574", "Asia/Kolkata"),
("1261927", "Nandyal", "", "IN", "356", "02", "", "", "", "15.48879", "78.48648", "Asia/Kolkata"),
("1261931", "Nandurbar", "", "IN", "356", "16", "", "", "", "21.36608", "74.23955", "Asia/Kolkata"),
("1261932", "Nandura", "", "IN", "356", "16", "", "", "", "20.83528", "76.45839", "Asia/Kolkata"),
("1261957", "Nandikotkur", "", "IN", "356", "02", "", "", "", "15.85668", "78.26569", "Asia/Kolkata"),
("1261960", "Nandigama", "", "IN", "356", "02", "", "", "", "16.77222", "80.28554", "Asia/Kolkata"),
("1261971", "Nandgaon", "", "IN", "356", "16", "", "", "", "20.30713", "74.65733", "Asia/Kolkata"),
("1261977", "Nanded", "Нандед", "IN", "356", "16", "Marathwada (undefined)", "1261978", "", "19.16023", "77.31497", "Asia/Kolkata"),
("1261998", "Nanauta", "", "IN", "356", "36", "", "", "", "29.71256", "77.4174", "Asia/Kolkata"),
("1262013", "Namrup", "", "IN", "356", "03", "", "", "", "27.19395", "95.31929", "Asia/Kolkata"),
("1262034", "Nambiyur", "", "IN", "356", "25", "", "", "", "11.35833", "77.32099", "Asia/Kolkata"),
("1262039", "Namakkal", "", "IN", "356", "25", "", "", "", "11.22126", "78.16524", "Asia/Kolkata"),
("1262040", "Namagiripettai", "", "IN", "356", "25", "", "", "", "11.455", "78.269", "Asia/Kolkata"),
("1262065", "Nalhati", "", "IN", "356", "28", "", "", "", "24.3", "87.81667", "Asia/Kolkata"),
("1262067", "Nalgonda", "Налгонда", "IN", "356", "02", "", "", "", "17.05439", "79.26707", "Asia/Kolkata"),
("1262073", "Naldurg", "", "IN", "356", "16", "", "", "", "17.81667", "76.28182", "Asia/Kolkata"),
("1262089", "Nakur", "", "IN", "356", "36", "", "", "", "29.91972", "77.30397", "Asia/Kolkata"),
("1262092", "Naksalbari", "", "IN", "356", "28", "", "", "", "26.6827", "88.22", "Asia/Kolkata"),
("1262097", "Nakodar", "", "IN", "356", "23", "", "", "", "31.1259", "75.47586", "Asia/Kolkata"),
("1262109", "Najibabad", "", "IN", "356", "36", "", "", "", "29.61207", "78.34338", "Asia/Kolkata"),
("1262115", "Nainwa", "", "IN", "356", "24", "", "", "", "25.77145", "75.84978", "Asia/Kolkata"),
("1262116", "Nainpur", "", "IN", "356", "35", "", "", "", "22.42743", "80.10875", "Asia/Kolkata"),
("1262117", "Naini Tal", "", "IN", "356", "39", "", "", "", "29.39743", "79.44686", "Asia/Kolkata"),
("1262131", "Naihati", "", "IN", "356", "28", "", "", "", "22.89396", "88.4152", "Asia/Kolkata"),
("1262140", "Nahorkatiya", "", "IN", "356", "03", "", "", "", "27.28912", "95.3418", "Asia/Kolkata"),
("1262151", "Nahan", "", "IN", "356", "11", "", "", "", "30.56056", "77.29403", "Asia/Kolkata"),
("1262180", "Nagpur", "Нагпур", "IN", "356", "16", "8131500", "", "", "21.14631", "79.08491", "Asia/Kolkata"),
("1262187", "Nagod", "", "IN", "356", "35", "", "", "", "24.5705", "80.58655", "Asia/Kolkata"),
("1262200", "Nagina", "", "IN", "356", "36", "", "", "", "29.44439", "78.43488", "Asia/Kolkata"),
("1262204", "Nagercoil", "", "IN", "356", "25", "", "", "", "8.17731", "77.43437", "Asia/Kolkata"),
("1262209", "Nagda", "", "IN", "356", "35", "", "", "", "23.45834", "75.41759", "Asia/Kolkata"),
("1262216", "Nagaur", "", "IN", "356", "24", "", "", "", "27.20201", "73.73394", "Asia/Kolkata"),
("1262230", "Nagar Karnul", "", "IN", "356", "02", "", "", "", "16.4821", "78.32471", "Asia/Kolkata"),
("1262240", "Nagari", "", "IN", "356", "02", "", "", "", "13.32139", "79.58557", "Asia/Kolkata"),
("1262253", "Nagar", "", "IN", "356", "24", "", "", "", "27.42397", "77.09922", "Asia/Kolkata"),
("1262260", "Nagappattinam", "", "IN", "356", "25", "", "", "", "10.76393", "79.84454", "Asia/Kolkata"),
("1262266", "Nagamangala", "", "IN", "356", "19", "", "", "", "12.81938", "76.75485", "Asia/Kolkata"),
("1262285", "Naduvannur", "", "IN", "356", "13", "", "", "", "11.48772", "75.77511", "Asia/Kolkata"),
("1262292", "Nadiad", "", "IN", "356", "09", "", "", "", "22.69385", "72.86157", "Asia/Kolkata"),
("1262296", "Nadbai", "", "IN", "356", "24", "", "", "", "27.22288", "77.19569", "Asia/Kolkata"),
("1262302", "Nadapuram", "", "IN", "356", "13", "", "", "", "11.7", "75.66667", "Asia/Kolkata"),
("1262318", "Nabinagar", "", "IN", "356", "34", "", "", "", "24.60658", "84.12719", "Asia/Kolkata"),
("1262319", "Nabha", "", "IN", "356", "23", "", "", "", "30.37475", "76.15077", "Asia/Kolkata"),
("1262321", "Mysore", "Майсур", "IN", "356", "19", "", "", "", "12.29791", "76.63925", "Asia/Kolkata"),
("1262330", "Muzaffarpur", "", "IN", "356", "34", "", "", "", "26.12259", "85.39055", "Asia/Kolkata"),
("1262332", "Muzaffarnagar", "", "IN", "356", "36", "", "", "", "29.47394", "77.70414", "Asia/Kolkata"),
("1262338", "Muvattupula", "", "IN", "356", "13", "", "", "", "9.98493", "76.57728", "Asia/Kolkata"),
("1262346", "Muttupet", "", "IN", "356", "25", "", "", "", "10.39531", "79.49425", "Asia/Kolkata"),
("1262374", "Mussoorie", "Муссури", "IN", "356", "39", "", "", "", "30.4571", "78.05498", "Asia/Kolkata"),
("1262380", "Musiri", "", "IN", "356", "25", "", "", "", "10.95299", "78.44427", "Asia/Kolkata"),
("1262382", "Mushabani", "", "IN", "356", "38", "", "", "", "22.51136", "86.45713", "Asia/Kolkata"),
("1262395", "Murwara", "", "IN", "356", "35", "", "", "", "23.83677", "80.39482", "Asia/Kolkata"),
("1262410", "Murtajapur", "", "IN", "356", "16", "", "", "", "20.73263", "77.36714", "Asia/Kolkata"),
("1262412", "Murshidabad", "Муршидабад", "IN", "356", "28", "", "", "", "24.1839", "88.27171", "Asia/Kolkata"),
("1262419", "Murliganj", "", "IN", "356", "34", "", "", "", "25.8969", "86.99577", "Asia/Kolkata"),
("1262426", "Morinda", "Моринда", "IN", "356", "23", "", "", "", "30.78957", "76.49733", "Asia/Kolkata"),
("1262444", "Murbad", "", "IN", "356", "16", "", "", "", "19.25395", "73.38993", "Asia/Kolkata"),
("1262453", "Muradnagar", "", "IN", "356", "36", "", "", "", "28.7809", "77.49865", "Asia/Kolkata"),
("1262463", "Munnar", "Муннар", "IN", "356", "13", "", "", "", "10.08873", "77.06269", "Asia/Kolkata"),
("1262482", "Munger", "Мангер", "IN", "356", "34", "", "", "", "25.37556", "86.47352", "Asia/Kolkata"),
("1262484", "Mungeli", "", "IN", "356", "37", "", "", "", "22.06709", "81.68822", "Asia/Kolkata"),
("1262485", "Mungaoli", "", "IN", "356", "35", "", "", "", "24.4078", "78.09666", "Asia/Kolkata"),
("1262491", "Mundwa", "", "IN", "356", "24", "", "", "", "27.0631", "73.82304", "Asia/Kolkata"),
("1262497", "Mundra", "", "IN", "356", "09", "", "", "", "22.83918", "69.7219", "Asia/Kolkata"),
("1262510", "Mundgod", "", "IN", "356", "19", "", "", "", "14.97144", "75.03658", "Asia/Kolkata"),
("1262516", "Mundargi", "", "IN", "356", "19", "", "", "", "15.20677", "75.8839", "Asia/Kolkata"),
("1262534", "Multai", "", "IN", "356", "35", "", "", "", "21.77449", "78.25866", "Asia/Kolkata"),
("1262546", "Mulki", "", "IN", "356", "19", "", "", "", "13.09154", "74.78437", "Asia/Kolkata"),
("1262553", "Mulgund", "", "IN", "356", "19", "", "", "", "15.2807", "75.52132", "Asia/Kolkata"),
("1262562", "Mulbagal", "", "IN", "356", "19", "", "", "", "13.16372", "78.39207", "Asia/Kolkata"),
("1262566", "Mulappilangad", "", "IN", "356", "13", "", "", "", "11.8", "75.45", "Asia/Kolkata"),
("1262574", "Mul", "", "IN", "356", "16", "", "", "", "20.0684", "79.67812", "Asia/Kolkata"),
("1262578", "Muktsar", "", "IN", "356", "23", "", "", "", "30.47764", "74.51513", "Asia/Kolkata"),
("1262591", "Mukher", "", "IN", "356", "16", "", "", "", "18.70413", "77.36641", "Asia/Kolkata"),
("1262596", "Mukerian", "", "IN", "356", "23", "", "", "", "31.95097", "75.61488", "Asia/Kolkata"),
("1262624", "Muhammadabad", "", "IN", "356", "36", "", "", "", "27.30854", "79.43368", "Asia/Kolkata"),
("1262625", "Muhammadabad", "", "IN", "356", "36", "", "", "", "26.03404", "83.38114", "Asia/Kolkata"),
("1262626", "Muhammadabad", "", "IN", "356", "36", "", "", "", "25.61873", "83.75499", "Asia/Kolkata"),
("1262634", "Mughal Sarai", "", "IN", "356", "36", "", "", "", "25.28183", "83.12096", "Asia/Kolkata"),
("1262651", "Mudkhed", "", "IN", "356", "16", "", "", "", "19.15657", "77.50304", "Asia/Kolkata"),
("1262663", "Mudhol", "", "IN", "356", "19", "", "", "", "16.33354", "75.28305", "Asia/Kolkata"),
("1262664", "Mudgal", "", "IN", "356", "19", "", "", "", "16.01187", "76.44207", "Asia/Kolkata"),
("1262669", "Muddebihal", "", "IN", "356", "19", "", "", "", "16.33711", "76.13201", "Asia/Kolkata"),
("1262672", "Mudbidri", "", "IN", "356", "19", "", "", "", "13.06653", "74.99525", "Asia/Kolkata"),
("1262678", "Mubarakpur", "", "IN", "356", "36", "", "", "", "26.08866", "83.29088", "Asia/Kolkata"),
("1262710", "Motihari", "", "IN", "356", "34", "", "", "", "26.65738", "84.91922", "Asia/Kolkata"),
("1262734", "Morwa", "", "IN", "356", "09", "", "", "", "22.90469", "73.83912", "Asia/Kolkata"),
("1262740", "Morsi", "", "IN", "356", "16", "", "", "", "21.34071", "78.01332", "Asia/Kolkata"),
("1262771", "Morena", "Морена", "IN", "356", "35", "", "", "", "26.50286", "78.00163", "Asia/Kolkata"),
("1262775", "Morbi", "", "IN", "356", "09", "", "", "", "22.8173", "70.8377", "Asia/Kolkata"),
("1262783", "Morar", "", "IN", "356", "35", "", "", "", "26.2264", "78.22482", "Asia/Kolkata"),
("1262794", "Moram", "", "IN", "356", "16", "", "", "", "17.78744", "76.4706", "Asia/Kolkata"),
("1262801", "Moradabad", "Морадабад", "IN", "356", "36", "", "", "", "28.83893", "78.77684", "Asia/Kolkata"),
("1262824", "Mon", "", "IN", "356", "20", "", "", "", "26.73583", "95.05841", "Asia/Kolkata"),
("1262843", "Mokokchung", "", "IN", "356", "20", "", "", "", "26.3248", "94.51834", "Asia/Kolkata"),
("1262852", "Mokama", "", "IN", "356", "34", "", "", "", "25.39679", "85.91923", "Asia/Kolkata"),
("1262863", "Moirang", "", "IN", "356", "17", "", "", "", "24.4975", "93.77791", "Asia/Kolkata"),
("1262951", "Moga", "Могу", "IN", "356", "23", "", "", "", "30.81571", "75.17419", "Asia/Kolkata"),
("1262958", "Modasa", "", "IN", "356", "09", "", "", "", "23.46254", "73.29857", "Asia/Kolkata"),
("1262988", "Misrikh", "", "IN", "356", "36", "", "", "", "27.43201", "80.53135", "Asia/Kolkata"),
("1262995", "Mirzapur", "Мирзапур", "IN", "356", "36", "", "", "", "25.14582", "82.56975", "Asia/Kolkata"),
("1263012", "Mirialguda", "", "IN", "356", "02", "", "", "", "16.8722", "79.56247", "Asia/Kolkata"),
("1263015", "Mirganj", "", "IN", "356", "36", "", "", "", "28.54012", "79.20817", "Asia/Kolkata"),
("1263021", "Miranpur Katra", "", "IN", "356", "36"