//
//    Main script of DevOOPS v1.0 Bootstrap Theme
//
"use strict";

/*-------------------------------------------
 Dynamically load plugin scripts
 ---------------------------------------------*/
//
//  Dynamically load jQuery Select2 plugin
//  homepage: https://github.com/ivaynberg/select2  v3.4.5  license - GPL2
//


$('.dropdown-toggle').click(function() {
        var dropdownList = $('.dropdown-menu');
        var dropdownOffset = $(this).parent('div').position();
       console.log(dropdownOffset.top);
	
        var dropdownWidth = dropdownList.height();
		console.log(dropdownWidth);
        var docWidth = $('#ajax-content').height();
        console.log(docWidth);
      
        
        var isDropdownVisible = (dropdownOffset.top + dropdownWidth + dropdownWidth + dropdownWidth <= docWidth);
     
        if (!isDropdownVisible) {
          $('.dropdown-toggle').parent('div').addClass('dropup');
        } else {
           $('.dropdown-toggle').parent('div').removeClass('dropup');
        }
    });
	
	
		
			
			
			
			$('#attribute_set').removeClass('dropup');
			$('#status').removeClass('dropup');
			$('.filter').removeClass('dropup');
for(var f=document.forms,i=f.length;i--;)f[i].setAttribute("novalidate",i)
function LoadSelect2Script(callback) {
    if (!$.fn.select2) {
        $.getScript('plugins/select2/select2.min.js', callback);
    }
    else {
        if (callback && typeof (callback) === "function") {
            callback();
        }
    }
}
//
//  Dynamically load DataTables plugin
//  homepage: http://datatables.net v1.9.4 license - GPL or BSD
//
function LoadDataTablesScripts(callback) {
    function LoadDatatables() {
	
		
        $.getScript('plugins/datatables/jquery.dataTables.js', function () {
            $.getScript('plugins/datatables/ZeroClipboard.js', function () {
                $.getScript('plugins/datatables/TableTools.js', function () {
                    $.getScript('plugins/datatables/dataTables.bootstrap.js', function(){
                        $.fn.dataTableExt.oApi.fnDataUpdate = function ( oSettings, nRowObject, iRowIndex ){
                            $(nRowObject).find("TD").each( function(i) {
                                  var iColIndex = oSettings.oApi._fnVisibleToColumnIndex( oSettings, i );
                                  oSettings.oApi._fnSetCellData( oSettings, iRowIndex, iColIndex, $(this).html() );
                            } );
                        };
                        callback();   
                    });
                });
            });
        });
    }
    if (!$.fn.dataTables) {
        LoadDatatables();       
    }
    else {
        if (callback && typeof (callback) === "function") {
            callback();
        }
    }
}
//
//  Dynamically load Fancybox 2 plugin
//  homepage: http://fancyapps.com/fancybox/ v2.1.5 License - MIT
//
function LoadFancyboxScript(callback) {
    if (!$.fn.fancybox) {
        $.getScript('plugins/fancybox/jquery.fancybox.js', callback);
    }
    else {
        if (callback && typeof (callback) === "function") {
            callback();
        }
    }
}
/*-------------------------------------------
 Main scripts used by theme
 ---------------------------------------------*/
//
//  Function for load content from url and put in $('.ajax-content') block
//
function LoadAjaxContent(url) {
    if (url.length == 0) {
        return false;
    }
    $('.preloader').show();
    window.location = url;
    return;
    $.ajax({
        url: url,
        mimeType: 'text/html; charset=utf-8', // ! Need set mimeType only when run from local file
        type: 'GET',
        success: function (data) {
            $('#ajax-content').html(data);
            $('.preloader').hide();
        },
        error: function (jqXHR, textStatus, errorThrown) {
            alert(errorThrown);
        },
        dataType: "html",
        async: false
    });
}
//
//  Function maked all .box selector is draggable, to disable for concrete element add class .no-drop
//
function WinMove() {
    var parentArray = (typeof(channelList) != 'undefined') ? channelList : {};
    $("div.box").draggable({
                revert: true,
                zIndex: 2000,
                cursor: "crosshair",
                handle: '.box-name',
				class: 'highlight',
                opacity: 0.8
            })
            .droppable({
                tolerance: 'pointer',
//                activeClass: "ui-state-hover",
                hoverClass: "highlight",//"ui-state-active",
                drop: function (event, ui) {
                    var draggable = ui.draggable;
                    var droppable = $(this);
                    var dragPos = draggable.position();
                    var dropPos = droppable.position();
                    draggable.swap(droppable, parentArray);
                    setTimeout(function () {
                        var dropmap = droppable.find('[id^=map-]');
                        var dragmap = draggable.find('[id^=map-]');
                        if (dragmap.length > 0 || dropmap.length > 0) {
                            dragmap.resize();
                            dropmap.resize();
                        }
                        else {
                            draggable.resize();
                            droppable.resize();
                        }
						
                    }, 50);
                    setTimeout(function () {
					
                        draggable.find('[id^=map-]').resize();
                        droppable.find('[id^=map-]').resize();
                    }, 250);
                    setTimeout(function () {
                        channelListRender('#channelListContainer');
                    }, 300);
                }
            });
    $('div.box.no-drop').draggable( "disable" ).droppable( "disable" );
}
//
// Swap 2 elements on page. Used by WinMove function
//
jQuery.fn.swap = function (b, parentArray) {
    b = jQuery(b)[0];
    var a = this[0];
    var a_num = $(a).find('span.curr_num').data('number');
    var b_num = $(b).find('span.curr_num').data('number');
    var remove = $(b).children('div').hasClass('empty');
//    var t = a.parentNode.insertBefore(document.createTextNode(''), a);
    b.parentNode.insertBefore(a, b);
//    t.parentNode.insertBefore(b, t);
//    t.parentNode.removeChild(t);
//    if (remove) {
//        setTimeout(function () {
//            $(b).remove();
//        }, 300);
//    }
    if (typeof(parentArray) == 'object' && parentArray.length !=0) {
        a_num = parseInt(a_num, 10) - 1;
        b_num = parseInt(b_num, 10) - 1;
        
        var direction = a_num < b_num ? 1: -1;
        var next_num = a_num + direction;
        
//        if (remove) {
//            parentArray.splice(b_num, 1);
//            b_num += direction;
//        }
        while( Math.abs(b_num - next_num + direction) > 0) {
            if ( typeof(parentArray[next_num]) != 'undefined' && typeof(parentArray[next_num].locked) != 'undefined' &&  !parentArray[next_num].locked) {
                var temp_a_number = parentArray[a_num].number;
                var temp_next_number = parentArray[next_num].number;
                
                var temp_a = parentArray[a_num];
                parentArray[a_num] = parentArray[next_num];
                parentArray[next_num] = temp_a;
                
                parentArray[a_num].number = temp_a_number;
                parentArray[next_num].number = temp_next_number;
                
                a_num = next_num;
            }
            next_num += direction;
        }
    }
    return this;
};
//
//  Function set min-height of window (required for this theme)
//
function SetMinBlockHeight(elem) {
    elem.css('min-height', window.innerHeight - 49)
}
//
//  Beauty tables plugin (navigation in tables with inputs in cell)
//  Created by DevOOPS.
//
(function ($) {
    $.fn.beautyTables = function () {
        var table = this;
        var string_fill = false;
        this.on('keydown', function (event) {
            var target = event.target;
            var tr = $(target).closest("tr");
            var col = $(target).closest("td");
            if (target.tagName.toUpperCase() == 'INPUT') {
                if (event.shiftKey === true) {
                    switch (event.keyCode) {
                        case 37: // left arrow
                            col.prev().children("input[type=text]").focus();
                            break;
                        case 39: // right arrow
                            col.next().children("input[type=text]").focus();
                            break;
                        case 40: // down arrow
                            if (string_fill == false) {
                                tr.next().find('td:eq(' + col.index() + ') input[type=text]').focus();
                            }
                            break;
                        case 38: // up arrow
                            if (string_fill == false) {
                                tr.prev().find('td:eq(' + col.index() + ') input[type=text]').focus();
                            }
                            break;
                    }
                }
                if (event.ctrlKey === true) {
                    switch (event.keyCode) {
                        case 37: // left arrow
                            tr.find('td:eq(1)').find("input[type=text]").focus();
                            break;
                        case 39: // right arrow
                            tr.find('td:last-child').find("input[type=text]").focus();
                            break;
                        case 40: // down arrow
                            if (string_fill == false) {
                                table.find('tr:last-child td:eq(' + col.index() + ') input[type=text]').focus();
                            }
                            break;
                        case 38: // up arrow
                            if (string_fill == false) {
                                table.find('tr:eq(1) td:eq(' + col.index() + ') input[type=text]').focus();
                            }
                            break;
                    }
                }
                if (event.keyCode == 13 || event.keyCode == 9) {
                    event.preventDefault();
                    col.next().find("input[type=text]").focus();
                }
                if (string_fill == false) {
                    if (event.keyCode == 34) {
                        event.preventDefault();
                        table.find('tr:last-child td:last-child').find("input[type=text]").focus();
                    }
                    if (event.keyCode == 33) {
                        event.preventDefault();
                        table.find('tr:eq(1) td:eq(1)').find("input[type=text]").focus();
                    }
                }
            }
        });
        table.find("input[type=text]").each(function () {
            $(this).on('blur', function (event) {
                var target = event.target;
                var col = $(target).parents("td");
                if (table.find("input[name=string-fill]").prop("checked") == true) {
                    col.nextAll().find("input[type=text]").each(function () {
                        $(this).val($(target).val());
                    });
                }
            });
        })
    };
})(jQuery);
//
// Beauty Hover Plugin (backlight row and col when cell in mouseover)
//
//
(function ($) {
    $.fn.beautyHover = function () {
        var table = this;
        table.on('mouseover', 'td', function () {
            var idx = $(this).index();
            var rows = $(this).closest('table').find('tr');
            rows.each(function () {
                $(this).find('td:eq(' + idx + ')').addClass('beauty-hover');
            });
        })
                .on('mouseleave', 'td', function (e) {
                    var idx = $(this).index();
                    var rows = $(this).closest('table').find('tr');
                    rows.each(function () {
                        $(this).find('td:eq(' + idx + ')').removeClass('beauty-hover');
                    });
                });
    };
})(jQuery);

/*-------------------------------------------
 Function for Form Layout page (form layouts.html)
 ---------------------------------------------*/
//
// Example form validator function
//
//
//  Helper for correct size of Messages page
//
function MessagesMenuWidth(){
	var W = window.innerWidth;
	var W_menu = $('#sidebar-left').outerWidth();
	var w_messages = (W-W_menu)*16.666666666666664/100;
	$('#messages-menu').width(w_messages);
}

//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
//
//      MAIN DOCUMENT READY SCRIPT OF DEVOOPS THEME
//
//      In this script main logic of theme
//
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
$(document).ready(function () {
    $( document ).ajaxComplete(function( event,request, settings ) {
        if (typeof(request.responseJSON) !== 'undefined' && typeof(request.responseJSON.error) !== 'undefined' && request.responseJSON.error == 'Need authorization') {
            window.location.reload(true);
            console.log(request.responseJSON.error);
        }
    });
    $( document ).ajaxError(function( event,request, settings ) {
        if (typeof(request.responseJSON) !== 'undefined' && typeof(request.responseJSON.error) !== 'undefined' && request.responseJSON.error == 'Need authorization') {
            window.location.reload(true);
            console.log(request.responseJSON.error);
        }
    });

    if ($("#allowed_locales").length > 0) {
        $("#allowed_locales").on('click', 'a', function(e){
            $.cookies.set('language', $(this).data('locale'), {expiresAt: new Date( 2037, 1, 1 )});
        });
    }

    $('.show-sidebar').on('click', function (e) {
        e.preventDefault();
        $('div#main').toggleClass('sidebar-show');
        setTimeout(MessagesMenuWidth, 250);
    });
//    var ajax_url = 'http://test1.localhost/stalker_portal/server/administrator/';
    var ajax_url = '';
    var ajax_hash = location.hash.replace(/^#/, '');
    if (ajax_hash.search('ajax') == -1) {
//        ajax_url += ajax_hash.length < 1 ? 'ajax/login.html' : ajax_hash;
        ajax_url += ajax_hash.length < 1 ? '' : ajax_hash;
    } else {
        ajax_url = ajax_hash;
    }
    if (ajax_url.length != 0) {
        LoadAjaxContent(ajax_url);
    } else {
        $('.preloader').hide();
    }
    $('.main-menu').on('click', 'a', function (e) {
        if ($(this).next().length == 0) {
            return true;
        } 
        e.stopPropagation();
        e.preventDefault();
        
        var parents = $(this).parents('li');
        var li = $(this).closest('li.dropdown');
        var another_items = $('.main-menu li').not(parents);
        another_items.find('a').removeClass('active');
        another_items.find('a').removeClass('active-parent');
        if ($(this).hasClass('dropdown-toggle') || $(this).closest('li').find('ul').length == 0) {
            $(this).addClass('active-parent');
            var current = $(this).next();
            if (current.is(':visible')) {
                li.find("ul.dropdown-menu").slideUp('fast');
                li.find("ul.dropdown-menu a").removeClass('active')
            } else {
                another_items.find("ul.dropdown-menu").slideUp('fast');
                current.slideDown('fast');
            }
        } else {
            if (li.find('a.dropdown-toggle').hasClass('active-parent')) {
                var pre = $(this).closest('ul.dropdown-menu');
                pre.find("li.dropdown").not($(this).closest('li')).find('ul.dropdown-menu').slideUp('fast');
            }
        }
        if ($(this).hasClass('active') == false) {
            $(this).parents("ul.dropdown-menu").find('a').removeClass('active');
            $(this).addClass('active')
        }
        if ($(this).hasClass('ajax-link')) {
            e.preventDefault();
            if ($(this).hasClass('add-full')) {
                $('#content').addClass('full-content');
            }
            else {
                $('#content').removeClass('full-content');
            }
            var url = $(this).attr('href');
            window.location.hash = url;
            LoadAjaxContent(url);
        }
        if ($(this).attr('href') == '#') {
            e.preventDefault();
        }
    });
    var height = window.innerHeight - 49;
    $('#main').css('min-height', height)
            .on('click', '.expand-link', function (e) {
                var body = $('body');
                e.preventDefault();
                var box = $(this).closest('div.box');
                var button = $(this).find('i');
                button.toggleClass('fa-expand').toggleClass('fa-compress');
                box.toggleClass('expanded');
                body.toggleClass('body-expanded');
                var timeout = 0;
                if (body.hasClass('body-expanded')) {
                    timeout = 100;
                }
                setTimeout(function () {
                    box.toggleClass('expanded-padding');
                }, timeout);
                setTimeout(function () {
                    box.resize();
                    box.find('[id^=map-]').resize();
                }, timeout + 50);
            })
            .on('click', '.collapse-link', function (e) {
                e.preventDefault();
                var box = $(this).closest('div.box');
                var button = $(this).find('i');
                var content = box.find('div.box-content');
                content.slideToggle('fast');
                button.toggleClass('fa-chevron-up').toggleClass('fa-chevron-down');
                setTimeout(function () {
                    box.resize();
                    box.find('[id^=map-]').resize();
                }, 50);
            })
            .on('click', '.close-link', function (e) {
                e.preventDefault();
                var content = $(this).closest('div.box');
                content.remove();
            });
    $('#locked-screen').on('click', function (e) {
        e.preventDefault();
        $('body').addClass('body-screensaver');
        $('#screensaver').addClass("show");
        ScreenSaver();
    });
    $('body').on('click', 'a.close-link', function (e) {
        e.preventDefault();
//        CloseModalBox();
    });
    $(document).on('click', 'a', function (e) {
        if ($(this).hasClass('ajax-link')) {
            e.preventDefault();
            if ($(this).hasClass('add-full')) {
                $('#content').addClass('full-content');
            }
            else {
                $('#content').removeClass('full-content');
            }
            var url = $(this).attr('href');
            window.location.hash = url;
            LoadAjaxContent(url);
        }
    });
    $('#search').on('keydown', function (e) {
        if (e.keyCode == 13) {
            e.preventDefault();
            $('#content').removeClass('full-content');
            ajax_url = 'ajax/page_search.html';
            window.location.hash = ajax_url;
            LoadAjaxContent(ajax_url);
        }
    });
    $('#screen_unlock').on('mouseover', function () {
        var header = 'Enter current username and password';
        var form = $('<div class="form-group"><label class="control-label">Username</label><input type="text" class="form-control" name="username" /></div>' +
                '<div class="form-group"><label class="control-label">Password</label><input type="password" class="form-control" name="password" /></div>');
        var button = $('<div class="text-center"><a href="index.html" class="btn btn-primary">Unlock</a></div>');
        OpenModalBox(header, form, button);
    });
    
    $(document).on("click mousedown mouseup", "#attribute_set .checkbox", function (e) {
        e.stopPropagation();
    });

    $(document).on('click', "#attribute_set li:first-of-type label", function (e) {
        var _input = $(this).find("input[type='checkbox']");
        _input.prop('checked', !_input.is(":checked"));
        $("#attribute_set li:not(first-of-type) input[type='checkbox']").prop('checked', _input.is(":checked"));
        var sendData = {};
        $("#attribute_set input[type='checkbox']").each(function(index){
            $("#datatable-1").dataTable().fnSetColumnVis( index - 1, $(this).prop('checked') );
            sendData[$(this).val()] = $(this).prop('checked');
        });
        setDropdownAttribute(sendData);
        e.stopPropagation();
        return false;
    });

    $(document).on('change', "#attribute_set li:not(:first-child) input[type='checkbox']", function (e) {
        $("#attribute_set input[type='checkbox']").each(function(index){
            $("#datatable-1").dataTable().fnSetColumnVis( index - 1, $(this).prop('checked') );
        });
        var allChbLen = $("#attribute_set li:not(:first-child) input[type='checkbox']").length;
        var chkChbLen = $("#attribute_set li:not(:first-child) input[type='checkbox']:checked").length;
        $("#attribute_set li:first-child input[type='checkbox']").prop('checked', allChbLen == chkChbLen);
        var sendData = {};
        $("#attribute_set input[type='checkbox']").each(function(){
            sendData[$(this).val()] = $(this).prop('checked');
        });
        setDropdownAttribute(sendData);
    });
    
    
    $(document).on("click mousedown mouseup", "div.attribute_set[id!='attribute_set']  .checkbox", function (e) {
        e.stopPropagation();
    });

    $(document).on('click', "div.attribute_set[id!='attribute_set'] li:first-of-type label", function (e) {
        var _input = $(this).find("input[type='checkbox']");
        _input.prop('checked', !_input.is(":checked"));
        var parentSetName = "#" + $(this).closest('div.attribute_set').attr('id');
        if($(this).closest('div.attribute_set').find('.divider').length != 0){
            $(parentSetName + " li:not(first-of-type) input[type='checkbox']").prop('checked', _input.is(":checked"));
        } else if(_input.is(":checked")){
            $(parentSetName + " input[type='checkbox']").prop('checked', false).removeAttr('checked');
            _input.prop('checked', true);
        }
        e.stopPropagation();
        return false;
    });

    $(document).on('change', "div.attribute_set[id!='attribute_set'] li:not(:first-child) input[type='checkbox']", function (e) {
        var parentSetName = "#" + $(this).closest('div.attribute_set').attr('id');
        if($(this).closest('div.attribute_set').find('.divider').length != 0){
            var allChbLen = $(parentSetName + " li:not(:first-child) input[type='checkbox']").length;
            var chkChbLen = $(parentSetName + " li:not(:first-child) input[type='checkbox']:checked").length;
            $(parentSetName + " li:first-child input[type='checkbox']").prop('checked', allChbLen == chkChbLen);
        } else if($(this).is(":checked")){
            $(parentSetName + " input[type='checkbox']").prop('checked', false).removeAttr('checked');
            $(this).prop('checked', true);
        }
    });

    $(document).on('change', "#add_channel input[type='checkbox'], #adm_grp_perm :checkbox", function(e){
        if ($(this).is(':checked')) {
            $(this).val('on');
        } else {
            $(this).val('off');
        }
    });


    $(document).on("click", '#datatable-1 a', function (e) {
        if ($(this).hasClass('ajax-link')) {
            e.preventDefault();
            if ($(this).hasClass('add-full')) {
                $('#content').addClass('full-content');
            }
            else {
                $('#content').removeClass('full-content');
            }
            var url = $(this).attr('href');
            window.location.hash = url;
            LoadAjaxContent(url);
        }
        if ($(this).attr('href') == '#') {
            e.preventDefault();
        }
    });

    $(document).on('click', "#add_channel .box-name .toggle-switch", function (e) {
        e.stopPropagation();
        e.preventDefault();
        return false;
    });

    $(document).on('show', ".box-content[id^='add_channel_']", function (e) {
        e.stopPropagation();
        e.preventDefault();
        $(this).closest('.box').children('.box-header').find('.header_check_info').hide();
        return false;
    });
    $(document).on('hide', ".box-content[id^='add_channel_']", function (e) {
        e.stopPropagation();
        e.preventDefault();
        $(this).closest('.box').children('.box-header').find('.header_check_info').show();
        return false;
    });
    $(document).on('show hide', "#add_channel_storage_save", function (e) {
        e.stopPropagation();
        e.preventDefault();
        $(this).closest('.box').children('.box-header').find("input[type='checkbox']").prop("checked", ($(this).find("input[type='checkbox']:checked").length != 0));
        return false;
    });
    $(document).on('show hide', "#add_channel_EPG", function (e) {
        e.stopPropagation();
        e.preventDefault();
        $(this).closest('.box').children('.box-header').find("input[type='checkbox']").prop("checked", ($(this).find("input[type='text']").val().trim() !== ''));
        return false;
    });
    $(document).on('show hide', "#add_channel_safety", function (e) {
        e.stopPropagation();
        e.preventDefault();
        $(this).closest('.box').children('.box-header').find("input[type='checkbox']").prop("checked", ($(this).find("input[name='age_restriction']:checked").length != 0));
        return false;
    });
    $(document).on('show hide', "#add_channel_type", function (e) {
        e.stopPropagation();
        e.preventDefault();
        $(this).closest('.box').children('.box-header').find("input[type='checkbox']").prop("checked", ($(this).find("input[name='base_channel']:checked").length != 0));
        return false;
    });
    $(document).on('show hide', "#add_channel_usb_store", function (e) {
        e.stopPropagation();
        e.preventDefault();
        $(this).closest('.box').children('.box-header').find("input[type='checkbox']").prop("checked", ($(this).find("input[type='checkbox']:checked").length != 0));
        return false;
    });
    $(document).on('show hide', "#add_channel_temp_http_link, #add_channel_link_monitoring, #add_channel_load_balancing", function (e) {
        e.stopPropagation();
        e.preventDefault();
        $(this).closest('.box').children('.box-header').find("input[type='checkbox']").prop("checked", ($(this).find("input[type='radio']:checked").val() == 'on'));
        return false;
    });

    $(document).on('click', "#modalbox_ad a.close-link, #modalbox_ad a.close-link .fa-times, #modalbox_ad, #modalbox_ad button[type='reset']", function (e) {
        if (e.target != e.currentTarget) {
            return;
        }
        e.stopPropagation();
        e.preventDefault();
        $("#modalbox_ad").find("input").prop("disabled", "disabled");
        $("#modalbox_ad").hide();
        return false;
    });

    $(document).on('click', "#modalbox_ad .channel-form button[type='submit']", function (e) {
        e.stopPropagation();
        e.preventDefault();
        var tmp_id = $("#modalbox_ad").data('tr_id');
        var dataObj = {};
        $('#modalbox_ad').find('input, select').each(function () {
            var name = (typeof ($(this).attr('name')) != 'undefined') ? $(this).attr('name').replace(/\[\d*?\]/ig, '') : false;
            if (!name) {
                return true;
            }
            var type = typeof ($(this).attr('type')) != 'undefined' ? $(this).attr('type') : $(this).get(0).tagName.toLowerCase();
            var value = $(this).val() || '';
            if (typeof (value) == 'array') {
                value = value.join(';');
            }
            if (type == 'checkbox') {
                dataObj[name] = {'value': ($(this).prop('checked') ? 'on' : 'off'), 'type': type};
            } else if (type == 'radio') {
                if ($(this).prop('checked')) {
                    dataObj[name] = {'value': $(this).val(), 'type': type};
                }
            } else if (type == 'select' && $(this).attr('multiple')) {
                dataObj[name] = {'value': value, 'type': type};
            } else {
                dataObj[name] = {'value': value, 'type': type};
            }
        });
        channelUrlDataUpdate("#" + tmp_id, dataObj);
        $("#modalbox_ad").find("input, select").prop("disabled", "disabled");
        $("#modalbox_ad").find("form").each(function () {
            this.reset();
        });
        $("#modalbox_ad").hide();
        return false;
    });

    $(document).on('click', 'div[data-tvfilter] ul a', function (e) {
        e.stopPropagation();
        e.preventDefault();
        var hrefM = window.location.href;
        var filterName = $(this).closest('div[data-tvfilter]').data('tvfilter');
        var filter_str = 'filters[' + filterName + ']=' + $(this).data('filter');
        if (window.location.search == '') {
            window.location.href = hrefM + '?' + filter_str;
        } else {
            var filterRegExp = new RegExp('filters.+?' + filterName + '[^=]*=[^&|^$]*', 'ig');
            if (filterRegExp.test(hrefM)) {
                window.location.href = hrefM.replace(filterRegExp, filter_str);
            } else {
                window.location.href = hrefM + '&' + filter_str;
            }
        }
        return false;
    });
    
    $(document).off('click', "a[disabled], a.disabled");
    $(document).on('click', "a[disabled], a.disabled", function(e){
        e.stopPropagation();
        e.preventDefault();
        $(this).clearQueue();
        $(this).stop();
        return false;
    });
    
    $("#breadcrumb ul").addClass("breadcrumb");
    $('[id*="datepicker"]').attr('readonly', 'readonly');
    
    $(document).on('click', "#modalbox, #modalbox a.close-link, #modalbox a.close-link *", function(e){
        if (e.currentTarget != e.target) {
            return;
        }
        e.stopPropagation();
        e.preventDefault();
        if (typeof($("#modalbox").data('complete')) == 'undefined' || $("#modalbox").data('complete') == 1) {
            closeModalBox();
        } else {
            for(var i=0;i<3;i++) {
                $('#modalbox > div').fadeTo('slow', 0.5).fadeTo('slow', 1.0);
            }
        }
        return false;
    });
    
});

function channelUrlDataGet(container){
    var dataObj = {};
    $(container).find('input').each(function(){
        var name = $(this).attr('name').replace(/\[\d*?\]/ig, '');
        var value = $(this).val();
        var type = $(this).attr('type');
        if (type != 'checkbox') {
            dataObj[name] = {'value': value, 'type': type};
        } else {
            dataObj[name] = {'value': ($(this).prop('checked') ? 'on': 'off'), 'type': type};
        }
    });
    return dataObj;
}

function channelUrlDataUpdate(container, data){
    if ($(container).css('display') == 'none'){
        var clonContainer = $(container).clone(true, true);
        clonContainer.removeAttr('id');
        $(clonContainer).insertAfter(container);
        $(container).css("display", "table-row");
        var countRow = $(container).parent().find($(container).get(0).tagName+":visible").length;
        $(container).find('input').each(function(){
            $(this).attr('name', $(this).attr('name').replace(/\d+?/ig, countRow));
            $(this).attr('id', $(this).attr('id').replace(/\d+?/ig, countRow));
        });
    }
    $(container).find('input').each(function(){
        $(this).prop("disabled", false).removeAttr("disabled");
        var name = $(this).attr('name').replace(/\[\d*?\]/ig, '');
        if (typeof (data[name]) == 'undefined') {
            return true;
        }
        var type = $(this).attr('type');
        if (type == 'checkbox') {
            $(this).prop('checked', (data[name].value == 'on'));
        } else {
            $(this).val(data[name].value);
        }
        var label = $(this).prev("label[data-field='"+name+"']");
        if (label) {
            label.text(data[name].value);
        }
    });
}

function channelListRender(container){
    JSshowModalBox();
    setTimeout(function(){
       if ($("#modalbox").data('complete') != 1) {
            JSErrorModalBox();
       } 
    }, 10000);
    var _container = $(container);
    _container.empty();
    var maxBlockHeight = $(window).height()- _container.offset().top - 50;
    _container.height(maxBlockHeight);
    maxBlockHeight -= $(document).height() - $(window).height();
    _container.height(maxBlockHeight +10);
    var maxBlockWidth = $(window).width()- _container.offset().left - 50;
    _container.width(maxBlockWidth+10);
    var maxItemOnBlock = Math.floor(maxBlockHeight/50);
    var currentCount = 0;
    for (var i= 0; i< channelList.length; ) {
        var currentBlock = $("<div/>", {'class': 'no-padding'}).appendTo(_container);
        var currentItemsBlock = $("<div/>", {'class': 'no-padding'}).appendTo(currentBlock)
        for ( var j = currentCount; j < (currentCount + maxItemOnBlock) && j < channelList.length; j++) {
            if (typeof(channelList[j]) == 'undefined') {
                continue;
            }
            currentItemsBlock.append(getChannelListItem(j+1, channelList[j]));
            i++;
        }
        currentBlock.prepend('<div class=" counter"><span>' + (currentCount + 1) + '-'+ (j) + '</span></div>');
        currentCount = j;
        currentBlock.css('top', 0);
        currentBlock.css('left', (Math.ceil(currentCount/maxItemOnBlock) - 1)*250);
        if (j >= channelList.length) {
            break;
        }
    }
    

    
     WinMove();
     
     JSSuccessModalBox();
     JScloseModalBox();
}

function getChannelListItem(num, item){
    var return_val = '<div class="box '+(item.locked? 'no-drop': '')+'"  style="position:relative; z-index:30;">\n\
                <div class="box-header '+ (item.empty == '1'? 'empty': '') + '"  style="position:relative; z-index:30;">\n\
                    <div class="box-name col-sm-11"  style="position:relative; z-index:30;">\n\
                        <span class="curr_num col-xs-1 col-sm-1 no-padding" data-number="'+num+'">'+item.number+'</span>\n\
                        <div class="channel col-xs-10 col-sm-10 no-padding">\n\
                            <span class="no-padding">\n\
                              <!----  <img class="img-rounded" src="'+item.logo+'" alt="">\n\--->\
                            </span>\n\
                            <a style="position:relative; z-index:300;" href="'+item.link+'" class="no-padding">'+item.name+'</a>';
	    if (item.empty != '1') {
        return_val +='<div class="box-icons col-sm-1 no-padding"><a style="position:relative; z-index:300;" class="lock-link">\n\        <i data-id="' + item.id + '" class="fa fa-'+(!item.locked? 'un': '')+'lock"></i>\n\    </a></div>';
	}						
                 return_val +='    </div>\n\
                    </div>';

    
    return_val +='  <div class="no-move"></div>\n\
                </div>\n\
            </div>';
    return return_val;
}

function ajaxSuccess(data, alertMsg, consoleMsg){
    var alertMsg = typeof(alertMsg) != 'undefined'? alertMsg: true;
    var consoleMsg = typeof(consoleMsg) != 'undefined'? consoleMsg: true;
    if (data.success) {
        if ($.isFunction(window[data.action]) && !data.error) {
            window[data.action](data);
        }
    } else if (data.error) {
        if (alertMsg) {
            alert(data.error);
        }
        if (consoleMsg) {
            console.log(data.error);
        }
    } else {
        if (alertMsg) {
            alert('Some server error');
        }
        if (consoleMsg) {
            console.log('Some server error');
        }
    }
}

function ajaxError(data, alertMsg, consoleMsg){
    var alertMsg = typeof(alertMsg) != 'undefined'? alertMsg: true;
    var consoleMsg = typeof(consoleMsg) != 'undefined'? consoleMsg: true;
    var errAction = '';
    if (typeof (data.responseJSON) == 'object') {
        errAction += data.responseJSON.action + 'Error';
    }
    if ($.isFunction(window[errAction])) {
        window[errAction](data.responseJSON);
    } else {
        if (alertMsg) {
            alert('Some server error');
        }
        if (consoleMsg) {
            console.log('Some server error');
        }
        if ($.isFunction(window['errAction'])) {
            window['errAction']();
        }
    }
}

function ajaxPostSend(url, sendData, alertMsg, consoleMsg, async){
    var alertMsg = typeof(alertMsg) != 'undefined'? alertMsg: true;
    var consoleMsg = typeof(consoleMsg) != 'undefined'? consoleMsg: true;
    var async = typeof(async) != 'undefined' ? async: false;
    $.ajax({
        url: url,
        type: 'POST',
        data: sendData,
        success: function (data) {
            ajaxSuccess(data, alertMsg, consoleMsg);
        },
        error: function (data) {
            ajaxError(data, alertMsg, consoleMsg);
        },
        dataType: "json",
        async: async
    });
}

(function ($) {
    $.each(['show', 'hide'], function (i, ev) {
        var el = $.fn[ev];
        $.fn[ev] = function () {
            this.trigger(ev);
            return el.apply(this, arguments);
        };
    });
})(jQuery);

function setDropdownAttribute(sendData){
    var param = '';
    var filterLink = $("a.btn-success.active[href*='filters']");
    if (filterLink.length > 0) {
        param = 'with-button-filters';
    }
    ajaxPostSend('./?set-dropdown-attribute' + (param != '' ? "=" + param : ''), sendData);
}

jQuery.extend({
    random: function (X) {
        return Math.floor(X * (Math.random() % 1));
    },
    randomBetween: function (MinV, MaxV) {
        return MinV + jQuery.random(MaxV - MinV + 1);
    },
    randString: function (n) {
        if (!n) {
            n = 5;
        }

        var text = '';
        var possible = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';

        for (var i = 0; i < n; i++) {
            text += possible.charAt(Math.floor(Math.random() * possible.length));
        }

        return text;
    }
});

(function($) {
    var re = /([^&=]+)=?([^&]*)/g;
    var decode = function(str) {
        return decodeURIComponent(str.replace(/\+/g, ' '));
    };
    $.parseParams = function(query) {
        var params = {}, e;
        if (query) {
            if (query.substr(0, 1) == '?') {
                query = query.substr(1);
            }

            while (e = re.exec(query)) {
                var k = decode(e[1]);
                var v = decode(e[2]);
                if (params[k] !== undefined) {
                    if (!$.isArray(params[k])) {
                        params[k] = [params[k]];
                    }
                    params[k].push(v);
                } else {
                    params[k] = v;
                }
            }
        }
        return params;
    };
})(jQuery);

var d = new Date();
if (!$.isFunction(d['toLocaleFormat'])) {
    Date.prototype.toLocaleFormat = function (format) {
        var year = this.getFullYear();
        var month = this.getMonth() + 1;
            month = (month.toString().length == 1) ? '0' + month: month;
        var monthNum = this.getMonth();
        var monthName = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
        var day = this.getDate();
            day = (day.toString().length == 1) ? '0' + day: day;
        var hour = this.getHours();
            hour = (hour.toString().length == 1) ? '0' + hour: hour;
        var min = this.getMinutes();
            min = (min.toString().length == 1) ? '0' + min: min;
        var sec = this.getSeconds();
            sec = (sec.toString().length == 1) ? '0' + sec: sec;
        return format.replace("%Y", year).replace("%m", month).replace("%d", day).replace("%H", hour).replace("%M", min).replace("%s", sec).replace("%b", monthName[monthNum]) ;
    };    
}

String.prototype.ucfirts = function() {
    return this.charAt(0).toUpperCase() + this.slice(1);
};

String.prototype.ucwords = function () {
    return this.replace(/^(.)|\s(.)/g, function ($1) {
        return $1.toUpperCase();
    });
};

String.prototype.camelCase = function () {
    return (this.charAt(0).toLowerCase() + this.ucwords().slice(1)).replace(' ', '');
};

function JScloseModalBox(){
    $("#modalbox").data('complete', 1);
    $("#modalbox").hide();
    $('#modalbox').find('.modal-header-name span').empty();
    $('#modalbox').find('.devoops-modal-inner').empty();
    $('#modalbox').find('.devoops-modal-bottom').empty();
}
        
function JSshowModalBox(){
    $("#modalbox").data('complete', 0);
    $('#modalbox').find('.modal-header-name span').text(words['Wait'] + "...");
    $('#modalbox').find('.devoops-modal-inner').html('<span>' + words['Request_is_being_prossessed'] + '...</span>');
    $("#modalbox").show();
}

function JSSuccessModalBox() {
    $("#modalbox").data('complete', 1);
    $('#modalbox').find('.devoops-modal-inner').html('<span>' + words['Done'] + '!</span>');
}

function JSErrorModalBox(){
    $('#modalbox').find('.devoops-modal-inner').html('<span>' + words['Failed'] + '!</span>');
    $("#modalbox").data('complete', 1);
}